/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mds.report.stockup;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.NumberFormatProvider;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportColumnGroup;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.entity.validate.ValidateResultCollection;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.MessageTypes;
import kd.bos.form.ShowType;
import kd.bos.form.control.Toolbar;
import kd.bos.form.control.events.CellClickEvent;
import kd.bos.form.control.events.CellClickListener;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.UploadEvent;
import kd.bos.form.control.events.UploadListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.report.ReportList;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.bos.schedule.api.TaskInfo;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.mmc.mds.common.schedule.TaskTrigger;
import kd.mmc.mds.common.stockup.task.StockUpStatusImportTask;
import kd.mmc.mds.common.stockup.util.StockUpRecorder;

public class StockUpStatusRptFormPlugin
extends AbstractReportFormPlugin
implements UploadListener,
CellClickListener {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        Toolbar toolbar = (Toolbar)this.getView().getControl("toolbarap");
        toolbar.addClickListener((ClickListener)this);
        toolbar.addUploadListener((UploadListener)this);
        ReportList reportList = (ReportList)this.getView().getControl("reportlistap");
        reportList.addCellClickListener((CellClickListener)this);
    }

    public void beforeBindData(EventObject e) {
        if (PermissionServiceHelper.checkPermission((Long)RequestContext.get().getCurrUserId(), (String)"mds", (String)"mds_stockupstatus_rpt", (String)"4730fc9f000003ae")) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"import"});
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{"import"});
        }
        QFilter filter = new QFilter("status", "=", (Object)Character.valueOf('C'));
        filter.and("enable", "=", (Object)"1");
        DynamicObjectCollection collection = QueryServiceHelper.query((String)"mds_stockupscheme", (String)"id", (QFilter[])new QFilter[]{filter}, (String)"createtime desc", (int)1);
        if (collection != null && collection.size() > 0) {
            Object id = ((DynamicObject)collection.get(0)).get("id");
            this.getModel().setValue("setid", (Object)BusinessDataServiceHelper.loadSingleFromCache((Object)id, (String)"mds_stockupscheme"));
        }
    }

    public boolean verifyQuery(ReportQueryParam queryParam) {
        Object setid = this.getModel().getValue("setid");
        if (setid == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5f55\u5165\u5907\u8d27\u65b9\u6848\u3002", (String)"StockUpStatusRptFormPlugin_0", (String)"mmc-mds-report", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    public void cellClick(CellClickEvent e) {
    }

    public void cellDoubleClick(CellClickEvent e) {
        String fieldKey = e.getFieldKey();
        int row = e.getRow();
        List<String> listKey = Arrays.asList("backupbom", "backuphis", "backupcustmor");
        if (listKey.contains(fieldKey) && row != -1) {
            boolean checkPermission = PermissionServiceHelper.checkPermission((Long)RequestContext.get().getCurrUserId(), (String)"mds", (String)"mds_stockupstatus_rpt", (String)"2LE1ZB=1Z98L");
            if (checkPermission) {
                this.stockStatusAdjust(fieldKey, row, (ReportList)e.getSource());
            } else {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u65e0\u201c\u5907\u8d27\u72b6\u6001\u786e\u8ba4\u201d\u7684\u201c\u884c\u7f16\u8f91\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"StockUpStatusRptFormPlugin_4", (String)"mmc-mds-report", (Object[])new Object[0]));
            }
        }
    }

    private void stockStatusAdjust(String fieldKey, int row, ReportList reportList) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("mds_stockstatusadjust");
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "statusadjcallback"));
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        HashMap<String, Object> params = new HashMap<String, Object>(16);
        DynamicObject dynamicObject = reportList.getReportModel().getRowData(row);
        DynamicObject currentStatus = dynamicObject.getDynamicObject(fieldKey);
        if (currentStatus == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u627e\u5230\u5bf9\u5e94\u7684\u5907\u8d27\u72b6\u6001\u89c4\u5219\uff0c\u8bf7\u8c03\u6574\u5907\u8d27\u72b6\u6001\u89c4\u5219\u8bbe\u7f6e\u3002", (String)"StockUpStatusRptFormPlugin_3", (String)"mmc-mds-report", (Object[])new Object[0]));
            return;
        }
        params.put("currentstatus", currentStatus.getPkValue());
        params.put("field", fieldKey);
        String adjustField = reportList.getColumns().stream().filter(f -> Objects.equals(((ReportColumn)f).getFieldKey(), fieldKey)).map(m -> m.getCaption().getLocaleValue()).collect(Collectors.joining(","));
        params.put("adjustfield", adjustField);
        long planId = dynamicObject.getLong("planid");
        params.put("planid", planId);
        long projectId = dynamicObject.getLong("projectid");
        params.put("projectid", projectId);
        showParameter.setCustomParams(params);
        this.getView().showForm(showParameter);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        ChangeData[] changeData = e.getChangeSet();
        Object newValue = changeData[0].getNewValue();
        if (newValue != null && "scheduleinfilter".equals(name)) {
            this.getModel().setValue("scheduleintimefilter_startdate", null);
            this.getModel().setValue("scheduleintimefilter_enddate", null);
        } else if (newValue != null && "scheduleintimefilter_enddate".equals(name)) {
            this.getModel().setValue("scheduleinfilter", null);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        ValidateResultCollection resultCollection;
        List errResults;
        String operatekey = e.getOperateKey();
        if ("batchedit".equals(operatekey) && ((errResults = (resultCollection = e.getOperationResult().getValidateResult()).getValidateErrors()) == null || errResults.size() == 0)) {
            this.doBatchEdit();
        }
    }

    private void doBatchEdit() {
        ReportList reportList = (ReportList)this.getView().getControl("reportlistap");
        int[] rows = reportList.getEntryState().getSelectedRows();
        if (rows.length == 0) {
            String showMsg = ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"StockUpStatusRptFormPlugin_1", (String)"mmc-mds-report", (Object[])new Object[0]);
            this.getView().showTipNotification(showMsg);
            return;
        }
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("mds_stockupmode");
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "stockupmodecallback"));
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(showParameter);
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        Object returndata = e.getReturnData();
        if (returndata instanceof Map && StringUtils.equals((CharSequence)e.getActionId(), (CharSequence)"stockupmodecallback")) {
            int[] rows;
            Map result = (Map)returndata;
            String field = String.valueOf(result.get("field"));
            Object value = result.get("value");
            if (value instanceof DynamicObject) {
                value = ((DynamicObject)value).getPkValue();
            }
            ReportList reportList = (ReportList)this.getView().getControl("reportlistap");
            for (int i : rows = reportList.getEntryState().getSelectedRows()) {
                DynamicObject dynamicObject = reportList.getReportModel().getRowData(i);
                long planid = dynamicObject.getLong("planid");
                long projectid = dynamicObject.getLong("projectid");
                StockUpRecorder.updateRecord((long)planid, (long)projectid, (String)field, value);
            }
            this.getView().invokeOperation("refresh");
        } else if (returndata instanceof Map && StringUtils.equals((CharSequence)e.getActionId(), (CharSequence)"StockUpStatusImportTaskCallBack")) {
            Map dataMap;
            String data;
            TaskInfo taskInfo;
            String taskInfoStr;
            Map result = (Map)returndata;
            if (result.containsKey("taskinfo") && StringUtils.isNotBlank((CharSequence)(taskInfoStr = (String)result.get("taskinfo"))) && (taskInfo = (TaskInfo)SerializationUtils.fromJsonString((String)taskInfoStr, TaskInfo.class)).isTaskEnd() && StringUtils.isNotEmpty((CharSequence)(data = taskInfo.getData())) && (dataMap = (Map)SerializationUtils.fromJsonString((String)data, Map.class)).containsKey("success")) {
                boolean isSuccess = (Boolean)dataMap.get("success");
                if (isSuccess) {
                    this.getView().showSuccessNotification(String.valueOf(dataMap.get("import_msg")));
                    this.getView().invokeOperation("refresh");
                } else if (dataMap.containsKey("failed_url")) {
                    this.getView().showConfirm(String.valueOf(dataMap.get("import_msg")), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("importfailedcallback"));
                    String url = String.valueOf(dataMap.get("failed_url"));
                    this.getPageCache().put("failed_url", url);
                    this.getView().invokeOperation("refresh");
                } else {
                    this.getView().showMessage(String.valueOf(dataMap.get("import_msg")), null, MessageTypes.Default);
                }
            }
        } else if (returndata instanceof Map && StringUtils.equals((CharSequence)e.getActionId(), (CharSequence)"statusadjcallback")) {
            Map result = (Map)returndata;
            String field = (String)result.get("field");
            DynamicObject beforeAdjstus = (DynamicObject)result.get("beforeadjstus");
            DynamicObject afterAdjstus = (DynamicObject)result.get("afteradjstus");
            String adjustReason = (String)result.get("adjustreason");
            long planId = Long.parseLong(String.valueOf(result.get("planid")));
            long projectId = Long.parseLong(String.valueOf(result.get("projectid")));
            StockUpRecorder.updateRecord((long)planId, (long)projectId, (String)field, (Object)afterAdjstus);
            StockUpRecorder.addAdjustRecord((String)field, (DynamicObject)beforeAdjstus, (DynamicObject)afterAdjstus, (String)adjustReason, (long)planId, (long)projectId);
            this.getView().invokeOperation("refresh");
        }
    }

    public void preProcessExportData(List<AbstractReportColumn> exportColumns, DynamicObjectCollection data, NumberFormatProvider numberFormatProvider) {
        ArrayList<ReportColumnGroup> newExportColumn = new ArrayList<ReportColumnGroup>(16);
        Object children = null;
        LinkedList<String> list = new LinkedList<String>();
        list.add("planid");
        list.add("projectid");
        list.add("cabinconfignumber");
        list.add("polarisstatusnumber");
        for (AbstractReportColumn exportColumn : exportColumns) {
            ReportColumn reportColumn = (ReportColumn)exportColumn;
            if (!list.contains(reportColumn.getFieldKey())) continue;
            reportColumn.setHide(false);
        }
        for (AbstractReportColumn column : exportColumns) {
            ReportColumnGroup colg = new ReportColumnGroup();
            String getFieldKey = ((ReportColumn)column).getFieldKey();
            colg.setCaption(new LocaleString(getFieldKey));
            colg.setFieldKey(getFieldKey + "_key");
            colg.getChildren().add(column);
            newExportColumn.add(colg);
        }
        exportColumns.clear();
        exportColumns.addAll(newExportColumn);
    }

    public void afterUpload(UploadEvent evt) {
        String fileUrl = null;
        Object[] urls = evt.getUrls();
        if (urls != null && urls.length > 0) {
            fileUrl = String.valueOf(urls[0]);
        }
        if (StringUtils.isNotEmpty(fileUrl)) {
            HashMap<String, Object> params = new HashMap<String, Object>(16);
            params.put("import_url", fileUrl);
            this.triggerImportTask(params);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        String callBackId = messageBoxClosedEvent.getCallBackId();
        if ("importfailedcallback".equals(callBackId) && MessageBoxResult.Yes == messageBoxClosedEvent.getResult()) {
            String url = this.getPageCache().get("failed_url");
            this.getView().download(url);
        }
    }

    private void triggerImportTask(Map<String, Object> params) {
        TaskTrigger trigger = new TaskTrigger(StockUpStatusImportTask.class, (IFormView)this.getView(), ResManager.loadKDString((String)"\u5f15\u5165", (String)"StockUpStatusRptFormPlugin_2", (String)"mmc-mds-report", (Object[])new Object[0]));
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "StockUpStatusImportTaskCallBack");
        trigger.setCloseCallBack(closeCallBack);
        trigger.run(params);
    }
}

