/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mds.report.stockup;

import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.report.AbstractReportListDataPlugin;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.mmc.mds.common.datafetch.DataFetchUtil;
import kd.mmc.mds.common.stockup.util.StockUpRecorder;
import kd.mmc.mds.common.stockup.util.StockUpStatusHelper;
import kd.mmc.mds.common.stockup.util.StockUpUtil;
import kd.mmc.mds.common.util.DateUtil;

public class StockUpStatusRptPlugin
extends AbstractReportListDataPlugin {
    private static final Log logger = LogFactory.getLog(StockUpStatusRptPlugin.class);

    public DataSet query(ReportQueryParam reportQueryParam, Object o) throws Throwable {
        FilterInfo filter;
        DataSet dataSet;
        block3: {
            dataSet = null;
            filter = reportQueryParam.getFilter();
            DynamicObject setid = filter.getDynamicObject("setid");
            long schemeId = setid.getLong("id");
            DynamicObject scheme = StockUpUtil.getStockUpScheme((long)schemeId);
            if (scheme == null) {
                return dataSet;
            }
            long datafetchsetId = scheme.getLong("datafetchset.id");
            dataSet = DataFetchUtil.fetchDataBySetId((long)datafetchsetId, (String)"sourcebilltype");
            dataSet = this.dataSetFilter(dataSet, filter);
            StockUpRecorder.initUpdateRecord((DataSet)dataSet.copy());
            try {
                dataSet = StockUpStatusHelper.calcStockUpStatus((DataSet)dataSet);
            }
            catch (Exception e) {
                logger.error((Throwable)e);
                String msg = e.getMessage();
                if (msg == null || !msg.contains("Illegal field")) break block3;
                String showMsg = ResManager.loadKDString((String)"\u8fc7\u6ee4\u89c4\u5219\u914d\u7f6e\u6709\u8bef\u6216\u5b9e\u4f53\u5b57\u6bb5\u6620\u5c04\u914d\u7f6e\u5b57\u6bb5\u7f3a\u5931\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u67e5\u770b\u9519\u8bef\u8be6\u60c5", (String)"StockUpStatusRptPlugin_0", (String)"mmc-mds-report", (Object[])new Object[0]);
                throw new KDBizException(showMsg);
            }
        }
        dataSet = this.dataSetFilterForCalculateField(dataSet, filter);
        dataSet = dataSet.orderBy(new String[]{"planid desc", "projectid desc"});
        return dataSet;
    }

    private DataSet dataSetFilter(DataSet dataSet, FilterInfo filter) {
        Date startDate;
        int scheduleInFilter;
        Set<Long> projectStatusFilter;
        Set<Long> schdStatusFilter;
        Set<Long> checktypeFilter;
        Set<Long> mrtypeFilter;
        HashMap<String, Object> params = new HashMap<String, Object>(16);
        List<String> fieldNames = Arrays.asList(dataSet.getRowMeta().getFieldNames());
        Set<Long> customerFilter = this.getFilterFieldIds(filter, "customerfilter");
        if (!customerFilter.isEmpty() && fieldNames.contains("customer")) {
            params.put("customerfilter", customerFilter);
            dataSet = dataSet.where("customer in customerfilter", params);
        }
        if (!(mrtypeFilter = this.getFilterFieldIds(filter, "mrtypefilter")).isEmpty() && fieldNames.contains("mrtype")) {
            params.put("mrtypefilter", mrtypeFilter);
            dataSet = dataSet.where("mrtype in mrtypefilter", params);
        }
        if (!(checktypeFilter = this.getFilterFieldIds(filter, "checktypefilter")).isEmpty() && fieldNames.contains("checktype")) {
            params.put("checktypefilter", checktypeFilter);
            dataSet = dataSet.where("checktype in checktypefilter", params);
        }
        if (!(schdStatusFilter = this.getFilterFieldIds(filter, "schdstatusfilter")).isEmpty() && fieldNames.contains("schdstatus")) {
            params.put("schdstatusfilter", schdStatusFilter);
            dataSet = dataSet.where("schdstatus in schdstatusfilter", params);
        }
        if (!(projectStatusFilter = this.getFilterFieldIds(filter, "projectstatusfilter")).isEmpty() && fieldNames.contains("projectstatus")) {
            params.put("projectstatusfilter", projectStatusFilter);
            dataSet = dataSet.where("projectstatus in projectstatusfilter", params);
        }
        if ((scheduleInFilter = filter.getInt("scheduleinfilter")) != 0 && fieldNames.contains("scheduleintime")) {
            startDate = DateUtil.getZeroTime((Date)new Date());
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(startDate);
            calendar.add(2, scheduleInFilter);
            Date endDate = calendar.getTime();
            params.put("startdate", startDate);
            params.put("enddate", endDate);
            dataSet = dataSet.where("scheduleintime >= startdate and scheduleintime <= enddate", params);
        }
        startDate = filter.getDate("scheduleintimefilter_startdate");
        Date endDate = filter.getDate("scheduleintimefilter_enddate");
        if (startDate != null && endDate != null && fieldNames.contains("scheduleintime")) {
            params.put("startdate", startDate);
            params.put("enddate", endDate);
            dataSet = dataSet.where("scheduleintime >= startdate and scheduleintime <= enddate", params);
        }
        return dataSet;
    }

    private DataSet dataSetFilterForCalculateField(DataSet dataSet, FilterInfo filter) {
        Set<Long> backupCustmorFilter;
        Set<Long> backupHisFilter;
        Set<Long> backupBomFilter;
        Set<Long> cabinConfigFilter;
        HashMap<String, Set<Long>> params = new HashMap<String, Set<Long>>(16);
        List<String> fieldNames = Arrays.asList(dataSet.getRowMeta().getFieldNames());
        Set<Long> polarisStatusFilter = this.getFilterFieldIds(filter, "polarisstatusfilter");
        if (!polarisStatusFilter.isEmpty() && fieldNames.contains("polarisstatus")) {
            params.put("polarisstatusfilter", polarisStatusFilter);
            dataSet = dataSet.where("polarisstatus in polarisstatusfilter", params);
        }
        if (!(cabinConfigFilter = this.getFilterFieldIds(filter, "cabinconfigfilter")).isEmpty() && fieldNames.contains("cabinconfig")) {
            params.put("cabinconfigfilter", cabinConfigFilter);
            dataSet = dataSet.where("cabinconfig in cabinconfigfilter", params);
        }
        if (!(backupBomFilter = this.getFilterFieldIds(filter, "backupbomfilter")).isEmpty() && fieldNames.contains("backupbom")) {
            params.put("backupbomfilter", backupBomFilter);
            dataSet = dataSet.where("backupbom in backupbomfilter", params);
        }
        if (!(backupHisFilter = this.getFilterFieldIds(filter, "backuphisfilter")).isEmpty() && fieldNames.contains("backuphis")) {
            params.put("backuphisfilter", backupHisFilter);
            dataSet = dataSet.where("backuphis in backuphisfilter", params);
        }
        if (!(backupCustmorFilter = this.getFilterFieldIds(filter, "backupcustmorfilter")).isEmpty() && fieldNames.contains("backupcustmor")) {
            params.put("backupcustmorfilter", backupCustmorFilter);
            dataSet = dataSet.where("backupcustmor in backupcustmorfilter", params);
        }
        return dataSet;
    }

    private Set<Long> getFilterFieldIds(FilterInfo filter, String field) {
        DynamicObjectCollection dynamicObjectCollection = filter.getDynamicObjectCollection(field);
        if (dynamicObjectCollection != null) {
            return dynamicObjectCollection.stream().map(m -> m.getLong("id")).collect(Collectors.toSet());
        }
        return new HashSet<Long>(1);
    }
}

