/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mds.mservice;

import java.util.ArrayList;
import java.util.Date;
import kd.bos.coderule.api.CodeRuleInfo;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.mmc.mds.common.util.CalcuColumns;
import kd.mmc.mds.mservice.api.IMdsCalculatingPlanService;

public class MdsCalculatingPlanServiceImpl
implements IMdsCalculatingPlanService {
    private static final Log log = LogFactory.getLog(MdsCalculatingPlanServiceImpl.class);
    private static String MDS_PLANEXEC = "mds_planexec";

    public String runCalculating(Object billid) {
        DynamicObject rplan = BusinessDataServiceHelper.loadSingle((Object)billid, (String)"mds_rplancal");
        if (rplan == null) {
            return "";
        }
        DynamicObject org = rplan.getDynamicObject("org");
        if (org == null) {
            return "";
        }
        DynamicObject doj = BusinessDataServiceHelper.newDynamicObject((String)MDS_PLANEXEC);
        CodeRuleInfo codeRuleInfo = CodeRuleServiceHelper.getCodeRule((String)MDS_PLANEXEC, (DynamicObject)doj, (String)org.getPkValue().toString());
        String number = CodeRuleServiceHelper.getNumber((CodeRuleInfo)codeRuleInfo, (DynamicObject)doj);
        doj.set("number", (Object)number);
        doj.set("createorg", (Object)org);
        doj.set("org", (Object)org);
        doj.set("rplancal", (Object)rplan);
        doj.set("creator", (Object)RequestContext.get().getCurrUserId());
        doj.set("createtime", (Object)new Date());
        doj.set("modifier", (Object)RequestContext.get().getCurrUserId());
        doj.set("modifytime", (Object)new Date());
        doj.set("ctrlstrategy", (Object)"5");
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{doj});
        try {
            CalcuColumns.runImediatlyNoView((DynamicObject)rplan, (int)CalcuColumns.Caltype.XQJH_CAL.ordinal(), (Object)doj.getPkValue());
        }
        catch (Exception e) {
            log.error((Throwable)e);
            return "";
        }
        return number;
    }

    public String getCalculatingStatus(String number) {
        ArrayList<QFilter> qFilters2 = new ArrayList<QFilter>(10);
        qFilters2.add(new QFilter("number", "=", (Object)number));
        DynamicObjectCollection queryList = QueryServiceHelper.query((String)MDS_PLANEXEC, (String)this.getSelections(), (QFilter[])qFilters2.toArray(new QFilter[0]));
        if (queryList.isEmpty()) {
            return "";
        }
        return ((DynamicObject)queryList.get(0)).getString("enable");
    }

    private String getSelections() {
        return "enable,execlogeentry.entrystepname,execlogeentry.entryresult";
    }

    public String loadLog(String number) {
        StringBuilder sb = new StringBuilder();
        ArrayList<QFilter> qFilters2 = new ArrayList<QFilter>(10);
        qFilters2.add(new QFilter("number", "=", (Object)number));
        DynamicObjectCollection queryList = QueryServiceHelper.query((String)MDS_PLANEXEC, (String)this.getSelections(), (QFilter[])qFilters2.toArray(new QFilter[0]));
        if (queryList == null || queryList.size() <= 0) {
            return "";
        }
        for (DynamicObject dob : queryList) {
            sb.append(dob.get("execlogeentry.entrystepname")).append(":").append(dob.get("execlogeentry.entryresult")).append("\u3002\n");
        }
        return sb.toString();
    }
}

