/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mds.mservice;

import java.util.Calendar;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.mmc.mds.common.util.ForecastCalUtil;
import kd.mmc.mds.common.util.MDSUtils;
import kd.mmc.mds.mservice.api.IMdsForecastCalService;

public class MdsForecastCalServiceImpl
implements IMdsForecastCalService {
    private static final Log log = LogFactory.getLog(MdsForecastCalServiceImpl.class);
    private static final String MDS_FORECASTCAL = "mds_forecastcal";
    private static final String MDS_FORECASTCALPLAN = "mds_forecastcalplan";
    private static final String CO_ORG = "org";
    public static final String CO_CALSTATUS = "calstatus";
    private static final String CO_NUMBER = "number";
    private static final int CALCTYPE = 0;

    public String runCalculating(Object billid) {
        DynamicObject fcalplan = BusinessDataServiceHelper.loadSingle((Object)billid, (String)MDS_FORECASTCALPLAN);
        if (fcalplan == null) {
            return "";
        }
        DynamicObject org = fcalplan.getDynamicObject(CO_ORG);
        if (org == null) {
            return "";
        }
        DynamicObject doj = BusinessDataServiceHelper.newDynamicObject((String)MDS_FORECASTCAL);
        String number = CodeRuleServiceHelper.getNumber((String)MDS_FORECASTCAL, (DynamicObject)doj, null);
        doj.set(CO_NUMBER, (Object)number);
        doj.set("createorg", (Object)org);
        doj.set(CO_ORG, (Object)org);
        doj.set("fcalplan", (Object)fcalplan);
        doj.set("predversion", fcalplan.get("predversion"));
        doj.set("creator", (Object)RequestContext.get().getCurrUserId());
        doj.set("createtime", (Object)Calendar.getInstance().getTime());
        doj.set("modifier", (Object)RequestContext.get().getCurrUserId());
        doj.set("modifytime", (Object)Calendar.getInstance().getTime());
        doj.set("ctrlstrategy", (Object)"5");
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{doj});
        try {
            ForecastCalUtil.runImediatly((DynamicObject)fcalplan, null, (Object)doj.getPkValue(), (int)0);
        }
        catch (Exception e) {
            log.error((Throwable)e);
            ErrorCode errorCode = new ErrorCode("runCalculatingError", ResManager.loadKDString((String)"runCalculating()\u8fd0\u884c\u5f02\u5e38\u3002", (String)"MdsForecastCalServiceImpl_0", (String)"mmc-mds-mservice", (Object[])new Object[0]));
            throw new KDBizException((Throwable)e, errorCode, new Object[0]);
        }
        return number;
    }

    public String getCalculatingStatus(String number) {
        if (MDSUtils.isEmpty((CharSequence)number)) {
            return "";
        }
        QFilter qFilter = new QFilter(CO_NUMBER, "=", (Object)number);
        String selectFields = CO_CALSTATUS;
        DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)MDS_FORECASTCAL, (String)selectFields, (QFilter[])new QFilter[]{qFilter});
        if (dynamicObject != null) {
            return dynamicObject.getString(CO_CALSTATUS);
        }
        return "";
    }

    public String loadLog(String number) {
        if (MDSUtils.isEmpty((CharSequence)number)) {
            return "";
        }
        String selectFields = "number, execlogeentry.entrystepseq, execlogeentry.entrystepname, execlogeentry.entryresult";
        QFilter qFilter = new QFilter(CO_NUMBER, "=", (Object)number);
        String orderSeq = "execlogeentry.entrystepseq asc";
        DynamicObjectCollection queryList = QueryServiceHelper.query((String)MDS_FORECASTCAL, (String)selectFields, (QFilter[])new QFilter[]{qFilter}, (String)orderSeq);
        if (queryList != null && !queryList.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            for (DynamicObject dynamicObject : queryList) {
                sb.append(dynamicObject.get("execlogeentry.entrystepname")).append(":").append(dynamicObject.get("execlogeentry.entryresult")).append("\u3002\n");
            }
            return sb.toString();
        }
        return "";
    }
}

