/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mds.mservice.orderpool;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.mmc.mds.common.orderpool.entity.OrgMaterialConfiguredcode;
import kd.mmc.mds.common.orderpool.task.OrderPoolDataOp;
import kd.mmc.mds.common.orderpool.util.ResourceCheckUtil;

public class MdsOrderPoolServiceImpl {
    private static final Log logger = LogFactory.getLog(MdsOrderPoolServiceImpl.class);
    private static final String SPLIT = "&&";

    public JSONObject deleteOrderPool(Map<Long, Set<Long>> orderIdEntryMap) {
        JSONObject result = new JSONObject();
        HashSet<DynamicObject[]> successIds = new HashSet<DynamicObject[]>(orderIdEntryMap.size());
        HashMap<Long, String> errors = new HashMap<Long, String>(orderIdEntryMap.size());
        result.put("successIds", successIds);
        result.put("errors", errors);
        if (orderIdEntryMap == null || orderIdEntryMap.isEmpty()) {
            return result;
        }
        HashSet<Long> orderentryIds = new HashSet<Long>(orderIdEntryMap.size());
        for (Map.Entry<Long, Set<Long>> orderEntry : orderIdEntryMap.entrySet()) {
            Set<Long> set = orderEntry.getValue();
            orderentryIds.addAll(set);
            DynamicObject[] salbillid = orderEntry.getKey();
            successIds.add(salbillid);
        }
        try {
            DynamicObject[] orderpools = BusinessDataServiceHelper.load((String)"mds_orderpooldata", (String)"id,salbillid,scheduledproqty", (QFilter[])new QFilter[]{new QFilter("salbillentryid", "in", orderentryIds)});
            ArrayList<Long> deleteOrderPoolIds = new ArrayList<Long>(orderpools.length);
            ArrayList<DynamicObject> arrayList = new ArrayList<DynamicObject>(orderpools.length);
            for (DynamicObject orderpool : orderpools) {
                Long salbillid = orderpool.getLong("salbillid");
                BigDecimal scheduledproqty = orderpool.getBigDecimal("scheduledproqty");
                if (scheduledproqty != null && scheduledproqty.compareTo(BigDecimal.ZERO) > 0) {
                    orderpool.set("unscheduledproqty", (Object)BigDecimal.ZERO);
                    arrayList.add(orderpool);
                    String error = ResManager.loadKDString((String)"\u6392\u4ea7\u6570\u91cf\u5927\u4e8e0\uff0c\u65e0\u6cd5\u5220\u9664\u3002", (String)"MdsOrderPoolServiceImpl_0", (String)"mmc-mds-mservice", (Object[])new Object[0]);
                    errors.put(salbillid, error);
                    successIds.remove(salbillid);
                    continue;
                }
                deleteOrderPoolIds.add(orderpool.getLong("id"));
            }
            if (!arrayList.isEmpty()) {
                SaveServiceHelper.save((DynamicObject[])arrayList.toArray(new DynamicObject[0]));
            }
            if (deleteOrderPoolIds.size() > 0) {
                MainEntityType type = EntityMetadataCache.getDataEntityType((String)"mds_orderpooldata");
                DeleteServiceHelper.delete((IDataEntityType)type, (Object[])deleteOrderPoolIds.toArray(new Object[0]));
            }
        }
        catch (Exception e) {
            logger.error("\u5220\u9664\u8ba2\u5355\u6c60\u62a5\u9519", (Throwable)e);
            for (Long l : successIds) {
                errors.put(l, e.getMessage());
            }
            successIds.clear();
        }
        result.put("successIds", successIds);
        result.put("errors", errors);
        return result;
    }

    public JSONObject updateOrderPool(String entityNumber, List<Long> orderIds) {
        JSONObject result = new JSONObject();
        HashSet successIds = new HashSet(orderIds.size());
        HashMap errors = new HashMap(orderIds.size());
        result.put("successIds", successIds);
        result.put("errors", errors);
        DynamicObject[] datas = BusinessDataServiceHelper.load((String)"mrp_resource_dataconfig", (String)"id", (QFilter[])new QFilter[]{new QFilter("status", "=", (Object)"C"), new QFilter("billfieldtransfer.srcbill", "=", (Object)entityNumber), new QFilter("billfieldtransfer.destbill", "=", (Object)"mds_orderpooldata")});
        if (datas == null || datas.length == 0) {
            return result;
        }
        Long dataConfId = datas[0].getLong("id");
        OrderPoolDataOp op = new OrderPoolDataOp();
        op.start(dataConfId, orderIds, successIds, errors);
        result.put("successIds", successIds);
        result.put("errors", errors);
        return result;
    }

    public JSONObject deleteOrderPoolEnttry(Map<Long, Set<Long>> orderPoolSchedulePlans) {
        return this.deleteOrderPoolEntry(orderPoolSchedulePlans, "entryscheduleplanid");
    }

    public JSONObject deleteOrderPoolEntry(Map<Long, Set<Long>> orderPoolSchedulePlans, String field) {
        JSONObject result = new JSONObject();
        HashSet<Long> successIds = new HashSet<Long>(orderPoolSchedulePlans.size());
        HashMap<Long, String> errors = new HashMap<Long, String>(orderPoolSchedulePlans.size());
        result.put("successIds", successIds);
        result.put("errors", errors);
        try {
            DynamicObject[] orderpools = BusinessDataServiceHelper.load((String)"mds_orderpooldata", (String)"id,reqqty,scheduledproqty,unscheduledproqty,billentry.entryscheduleplanid,billentry.entryscheduleplanentryid,billentry.entryscheduleqty", (QFilter[])new QFilter[]{new QFilter("id", "in", orderPoolSchedulePlans.keySet())});
            ArrayList<DynamicObject> updateOrderPools = new ArrayList<DynamicObject>(orderpools.length);
            for (DynamicObject orderPool : orderpools) {
                BigDecimal allScheduleqty = BigDecimal.ZERO;
                Long id = orderPool.getLong("id");
                Set<Long> schedulePlanIds = orderPoolSchedulePlans.get(id);
                DynamicObjectCollection billentrys = orderPool.getDynamicObjectCollection("billentry");
                Iterator iterator = billentrys.iterator();
                while (iterator.hasNext()) {
                    DynamicObject billentry = (DynamicObject)iterator.next();
                    Long fieldId = billentry.getLong(field);
                    if (schedulePlanIds.contains(fieldId)) {
                        iterator.remove();
                        continue;
                    }
                    BigDecimal entryscheduleqty = billentry.getBigDecimal("entryscheduleqty");
                    if (entryscheduleqty == null) continue;
                    allScheduleqty = allScheduleqty.add(entryscheduleqty);
                }
                successIds.add(id);
                BigDecimal reqqty = orderPool.getBigDecimal("reqqty");
                orderPool.set("scheduledproqty", (Object)allScheduleqty);
                orderPool.set("unscheduledproqty", (Object)reqqty.subtract(allScheduleqty));
                updateOrderPools.add(orderPool);
            }
            if (!updateOrderPools.isEmpty()) {
                SaveServiceHelper.save((DynamicObject[])updateOrderPools.toArray(new DynamicObject[0]));
            }
        }
        catch (Exception e) {
            logger.error("\u5220\u9664\u8ba2\u5355\u6c60\u5206\u5f55\u62a5\u9519", (Throwable)e);
            for (Long successId : successIds) {
                errors.put(successId, e.getMessage());
            }
            successIds.clear();
        }
        result.put("successIds", successIds);
        result.put("errors", errors);
        return result;
    }

    public JSONObject updateOrderPoolEntry(JSONArray entrys) {
        JSONObject result = new JSONObject();
        HashSet<Long> successIds = new HashSet<Long>(entrys.size());
        HashMap<Long, String> errors = new HashMap<Long, String>(entrys.size());
        result.put("successIds", successIds);
        result.put("errors", errors);
        try {
            HashMap<Long, Map> orderPoolNewEntrys = new HashMap<Long, Map>(16);
            for (int i = 0; i < entrys.size(); ++i) {
                JSONObject data = entrys.getJSONObject(i);
                Long orderPoolId = data.getLong("id");
                successIds.add(orderPoolId);
                Long entryscheduleplanentryid = data.getLong("entryscheduleplanentryid");
                Map datas = orderPoolNewEntrys.computeIfAbsent(orderPoolId, k -> new HashMap());
                datas.put(entryscheduleplanentryid, data);
            }
            MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)"mds_orderpooldata");
            DynamicObject[] orderPools = BusinessDataServiceHelper.load((Object[])orderPoolNewEntrys.keySet().toArray(new Long[0]), (DynamicObjectType)dataEntityType);
            ArrayList<DynamicObject> updateOrderPools = new ArrayList<DynamicObject>(16);
            for (DynamicObject orderPool : orderPools) {
                BigDecimal entryscheduleqty;
                Long id = orderPool.getLong("id");
                Map newEntrys = (Map)orderPoolNewEntrys.get(id);
                BigDecimal allScheduleqty = BigDecimal.ZERO;
                DynamicObjectCollection billentrys = orderPool.getDynamicObjectCollection("billentry");
                for (DynamicObject billentry : billentrys) {
                    Long entryscheduleplanentryid = billentry.getLong("entryscheduleplanentryid");
                    JSONObject jsonObject = (JSONObject)newEntrys.get(entryscheduleplanentryid);
                    entryscheduleqty = billentry.getBigDecimal("entryscheduleqty");
                    if (jsonObject == null) {
                        if (entryscheduleqty == null) continue;
                        allScheduleqty = allScheduleqty.add(entryscheduleqty);
                        continue;
                    }
                    this.updateEntry(billentry, jsonObject);
                    entryscheduleqty = billentry.getBigDecimal("entryscheduleqty");
                    if (entryscheduleqty != null) {
                        allScheduleqty = allScheduleqty.add(entryscheduleqty);
                    }
                    newEntrys.remove(entryscheduleplanentryid);
                }
                for (JSONObject newEntry : newEntrys.values()) {
                    DynamicObject billentry = new DynamicObject(billentrys.getDynamicObjectType());
                    Long entryscheduleplanentryid = newEntry.getLong("entryscheduleplanentryid");
                    this.updateEntry(billentry, newEntry);
                    billentry.set("entryscheduleplanentryid", (Object)entryscheduleplanentryid);
                    entryscheduleqty = billentry.getBigDecimal("entryscheduleqty");
                    if (entryscheduleqty != null) {
                        allScheduleqty = allScheduleqty.add(entryscheduleqty);
                    }
                    billentrys.add((Object)billentry);
                }
                BigDecimal reqqty = orderPool.getBigDecimal("reqqty");
                orderPool.set("scheduledproqty", (Object)allScheduleqty);
                orderPool.set("unscheduledproqty", (Object)reqqty.subtract(allScheduleqty));
                updateOrderPools.add(orderPool);
            }
            if (!updateOrderPools.isEmpty()) {
                SaveServiceHelper.save((DynamicObject[])updateOrderPools.toArray(new DynamicObject[0]));
            }
        }
        catch (Exception e) {
            logger.error("\u66f4\u65b0\u8ba2\u5355\u6c60\u5206\u5f55\u62a5\u9519", (Throwable)e);
            for (Long successId : successIds) {
                errors.put(successId, e.getMessage());
            }
            successIds.clear();
        }
        result.put("successIds", successIds);
        result.put("errors", errors);
        return result;
    }

    public JSONObject updateOrderPoolEntryBySchedulePlan(JSONArray entrys) {
        return this.updateOrderPoolEntryByFeildId(entrys, "entryscheduleplanid");
    }

    public JSONObject updateOrderPoolEntryByFeildId(JSONArray entrys, String feildId) {
        JSONObject result = new JSONObject();
        HashSet<Long> successIds = new HashSet<Long>(entrys.size());
        HashMap<Long, String> errors = new HashMap<Long, String>(entrys.size());
        result.put("successIds", successIds);
        result.put("errors", errors);
        try {
            HashMap<Long, JSONObject> entryscheduleplanNewEntry = new HashMap<Long, JSONObject>(16);
            for (int i = 0; i < entrys.size(); ++i) {
                JSONObject data = entrys.getJSONObject(i);
                Long feildIdLong = data.getLong(feildId);
                successIds.add(feildIdLong);
                entryscheduleplanNewEntry.put(feildIdLong, data);
            }
            DynamicObject[] orderPools = BusinessDataServiceHelper.load((String)"mds_orderpooldata", (String)"id,billentry.isgenmftorder,billentry.entrymanufacturenum,billentry.entryscheduleplanid,billentry.entrymanufactureid,billentry.entrymanufactureentryid,billentry.entrymanufactureseq,billentry.entrymanufactureqty,billentry.entryplanstartworktime,billentry.entryplanendworktime,billentry.entrylinstockqty", (QFilter[])new QFilter[]{new QFilter("billentry." + feildId.trim(), "in", entryscheduleplanNewEntry.keySet())});
            ArrayList<DynamicObject> updateOrderPools = new ArrayList<DynamicObject>(16);
            for (DynamicObject orderPool : orderPools) {
                DynamicObjectCollection billentrys = orderPool.getDynamicObjectCollection("billentry");
                for (DynamicObject billentry : billentrys) {
                    Long entryscheduleplanId = billentry.getLong(feildId);
                    JSONObject newEntry = (JSONObject)entryscheduleplanNewEntry.get(entryscheduleplanId);
                    if (newEntry == null) continue;
                    successIds.add(entryscheduleplanId);
                    this.updateEntry(billentry, newEntry);
                }
                updateOrderPools.add(orderPool);
            }
            if (!updateOrderPools.isEmpty()) {
                SaveServiceHelper.save((DynamicObject[])updateOrderPools.toArray(new DynamicObject[0]));
            }
        }
        catch (Exception e) {
            logger.error("\u66f4\u65b0\u8ba2\u5355\u6c60\u5206\u5f55\u62a5\u9519", (Throwable)e);
            for (Long successId : successIds) {
                errors.put(successId, e.getMessage());
            }
            successIds.clear();
        }
        result.put("successIds", successIds);
        result.put("errors", errors);
        return result;
    }

    public JSONObject clearOrderPoolEntry(Set<Long> schedulePlans) {
        JSONObject result = new JSONObject();
        HashSet<Long> successIds = new HashSet<Long>(schedulePlans.size());
        HashMap<Long, String> errors = new HashMap<Long, String>(schedulePlans.size());
        result.put("successIds", successIds);
        result.put("errors", errors);
        try {
            DynamicObject[] orderPools = BusinessDataServiceHelper.load((String)"mds_orderpooldata", (String)"id,billentry.entryscheduleplanid,billentry.entrymanufactureid,billentry.entrymanufactureentryid,billentry.entrymanufactureseq,billentry.entrymanufactureqty,billentry.entryplanstartworktime,billentry.entryplanendworktime,billentry.entrylinstockqty", (QFilter[])new QFilter[]{new QFilter("billentry.entryscheduleplanid", "in", schedulePlans)});
            ArrayList<DynamicObject> updateOrderPools = new ArrayList<DynamicObject>(16);
            for (DynamicObject orderPool : orderPools) {
                DynamicObjectCollection billentrys = orderPool.getDynamicObjectCollection("billentry");
                for (DynamicObject billentry : billentrys) {
                    Long entryscheduleplanId = billentry.getLong("entryscheduleplanid");
                    if (!schedulePlans.contains(entryscheduleplanId)) continue;
                    billentry.set("entrymanufactureqty", (Object)BigDecimal.ZERO);
                    billentry.set("entryplanstartworktime", null);
                    billentry.set("entryplanendworktime", null);
                    billentry.set("entrylinstockqty", (Object)BigDecimal.ZERO);
                    successIds.add(entryscheduleplanId);
                }
                updateOrderPools.add(orderPool);
            }
            if (!updateOrderPools.isEmpty()) {
                SaveServiceHelper.save((DynamicObject[])updateOrderPools.toArray(new DynamicObject[0]));
            }
        }
        catch (Exception e) {
            logger.error("\u6e05\u9664\u8ba2\u5355\u6c60\u5206\u5f55\u62a5\u9519", (Throwable)e);
            for (Long successId : successIds) {
                errors.put(successId, e.getMessage());
            }
            successIds.clear();
        }
        result.put("successIds", successIds);
        result.put("errors", errors);
        return result;
    }

    private void updateEntry(DynamicObject billentry, JSONObject jsonObject) {
        if (jsonObject.get((Object)"entryscheduleplanno") != null) {
            billentry.set("entryscheduleplanno", jsonObject.get((Object)"entryscheduleplanno"));
        }
        if (jsonObject.get((Object)"entrysheduledate") != null) {
            billentry.set("entrysheduledate", jsonObject.get((Object)"entrysheduledate"));
        }
        if (jsonObject.get((Object)"entryscheduleqty") != null) {
            billentry.set("entryscheduleqty", jsonObject.get((Object)"entryscheduleqty"));
        }
        if (jsonObject.get((Object)"entryondate") != null) {
            billentry.set("entryondate", jsonObject.get((Object)"entryondate"));
        }
        if (jsonObject.get((Object)"entryendworkdate") != null) {
            billentry.set("entryendworkdate", jsonObject.get((Object)"entryendworkdate"));
        }
        if (jsonObject.get((Object)"entrymanufacturenum") != null) {
            billentry.set("isgenmftorder", (Object)true);
            billentry.set("entrymanufacturenum", jsonObject.get((Object)"entrymanufacturenum"));
        }
        if (jsonObject.get((Object)"entrymanufactureid") != null) {
            billentry.set("entrymanufactureid", jsonObject.get((Object)"entrymanufactureid"));
        }
        if (jsonObject.get((Object)"entrymanufactureentryid") != null) {
            billentry.set("entrymanufactureentryid", jsonObject.get((Object)"entrymanufactureentryid"));
        }
        if (jsonObject.get((Object)"entrymanufactureseq") != null) {
            billentry.set("entrymanufactureseq", jsonObject.get((Object)"entrymanufactureseq"));
        }
        if (jsonObject.get((Object)"entrymanufactureqty") != null) {
            billentry.set("entrymanufactureqty", jsonObject.get((Object)"entrymanufactureqty"));
        }
        if (jsonObject.get((Object)"entryplanstartworktime") != null) {
            billentry.set("entryplanstartworktime", jsonObject.get((Object)"entryplanstartworktime"));
        }
        if (jsonObject.get((Object)"entryplanendworktime") != null) {
            billentry.set("entryplanendworktime", jsonObject.get((Object)"entryplanendworktime"));
        }
        if (jsonObject.get((Object)"entrylinstockqty") != null) {
            billentry.set("entrylinstockqty", (Object)billentry.getBigDecimal("entrylinstockqty").add(jsonObject.getBigDecimal("entrylinstockqty")));
        }
        if (jsonObject.get((Object)"entryscheduleplanid") != null) {
            billentry.set("entryscheduleplanid", jsonObject.get((Object)"entryscheduleplanid"));
        }
        if (jsonObject.get((Object)"entrtycreator") != null) {
            billentry.set("entrtycreator", jsonObject.get((Object)"entrtycreator"));
        }
        if (jsonObject.get((Object)"entrycreatedate") != null) {
            billentry.set("entrycreatedate", jsonObject.get((Object)"entrycreatedate"));
        }
    }

    public Map<String, Map<Long, Set<String>>> materialRresourceCheck(Set<Long[]> materialConfiguredcodeorgs) {
        HashMap<String, Map<Long, Set<String>>> reults = new HashMap<String, Map<Long, Set<String>>>(100);
        HashSet<String> materialConfiguredcodeorgSet = new HashSet<String>(100);
        for (Long[] materialConfiguredcodeorg : materialConfiguredcodeorgs) {
            StringBuilder keybulider = new StringBuilder();
            for (Long id : materialConfiguredcodeorg) {
                if (!StringUtils.isBlank((CharSequence)keybulider)) {
                    keybulider.append(SPLIT);
                }
                keybulider.append(id);
            }
            materialConfiguredcodeorgSet.add(keybulider.toString());
        }
        Map resourceChecks = ResourceCheckUtil.resourceCheck(materialConfiguredcodeorgSet);
        for (Map.Entry resourceCheck : resourceChecks.entrySet()) {
            OrgMaterialConfiguredcode omc = (OrgMaterialConfiguredcode)resourceCheck.getKey();
            StringBuilder keybulider = new StringBuilder();
            keybulider.append(omc.getOrgId()).append(SPLIT).append(omc.getMaterialId()).append(SPLIT).append(omc.getConfiguredcode());
            Map value = (Map)resourceCheck.getValue();
            Map computeIfAbsent = reults.computeIfAbsent(keybulider.toString(), k -> new HashMap());
            if (value == null || value.isEmpty()) continue;
            computeIfAbsent.putAll(value);
        }
        return reults;
    }

    public JSONObject returnOrderPool(Map<Long, String> orderPoolReturnMap) {
        JSONObject result = new JSONObject();
        HashSet<Long> successIds = new HashSet<Long>(orderPoolReturnMap.size());
        HashMap<Long, String> errors = new HashMap<Long, String>(orderPoolReturnMap.size());
        result.put("successIds", successIds);
        result.put("errors", errors);
        try {
            DynamicObject[] orderpools = BusinessDataServiceHelper.load((String)"mds_orderpooldata", (String)"id,approveaccess,salbillno,salbillseq,scheduledproqty,reqqty,returndate,returndetail,returnmans,approveaccesstime", (QFilter[])new QFilter[]{new QFilter("id", "in", orderPoolReturnMap.keySet())});
            ArrayList<DynamicObject> updateOrderPools = new ArrayList<DynamicObject>(orderpools.length);
            DynamicObject[] returnrecords = BusinessDataServiceHelper.load((String)"mds_returnrecord", (String)"orderpoolid,salbillno,salbillseq,entryentity.returnmans,entryentity.returndetail,entryentity.returndate", (QFilter[])new QFilter[]{new QFilter("orderpoolid", "in", orderPoolReturnMap.keySet())});
            HashMap<Long, DynamicObject> orderpoolReturnrecords = new HashMap<Long, DynamicObject>(16);
            ArrayList<DynamicObject> returnrecordLists = new ArrayList<DynamicObject>(16);
            for (DynamicObject returnrecord : returnrecords) {
                orderpoolReturnrecords.put(returnrecord.getLong("orderpoolid"), returnrecord);
            }
            for (DynamicObject orderpool : orderpools) {
                String error;
                Long orderPoolId = orderpool.getLong("id");
                BigDecimal reqqty = orderpool.getBigDecimal("reqqty");
                BigDecimal scheduleqty = orderpool.getBigDecimal("scheduledproqty");
                String salbillno = orderpool.getString("salbillno");
                Boolean approveaccess = orderpool.getBoolean("approveaccess");
                if (scheduleqty != null && reqqty.compareTo(scheduleqty) == 0) {
                    error = String.format(ResManager.loadKDString((String)"\u9500\u552e\u8ba2\u5355\u53f7%s\uff0c\u5f85\u6392\u4ea7\u6570\u91cf\u4e3a0\uff0c\u4e0d\u53ef\u9000\u56de\u3002", (String)"MdsOrderPoolServiceImpl_1", (String)"mmc-mds-mservice", (Object[])new Object[0]), salbillno);
                    errors.put(orderPoolId, error);
                    continue;
                }
                if (!approveaccess.booleanValue()) {
                    error = String.format(ResManager.loadKDString((String)"\u9500\u552e\u8ba2\u5355\u53f7%s\u6570\u636e\u4e0d\u662f\u51c6\u5165\u6392\u4ea7\u6570\u636e\uff0c\u4e0d\u5141\u8bb8\u9000\u56de\u3002", (String)"MdsOrderPoolServiceImpl_2", (String)"mmc-mds-mservice", (Object[])new Object[0]), salbillno);
                    errors.put(orderPoolId, error);
                    continue;
                }
                String returnReason = orderPoolReturnMap.getOrDefault(orderPoolId, "");
                if (StringUtils.isBlank((CharSequence)returnReason)) {
                    String error2 = String.format(ResManager.loadKDString((String)"\u9500\u552e\u8ba2\u5355\u53f7%s\uff0c\u8bf7\u586b\u5199\u56de\u9000\u539f\u56e0\u3002", (String)"MdsOrderPoolServiceImpl_3", (String)"mmc-mds-mservice", (Object[])new Object[0]), salbillno);
                    errors.put(orderPoolId, error2);
                    continue;
                }
                successIds.add(orderPoolId);
                orderpool.set("approveaccess", (Object)false);
                orderpool.set("approveaccesstime", null);
                orderpool.set("returnmans", (Object)RequestContext.get().getCurrUserId());
                orderpool.set("returndate", (Object)new Date());
                orderpool.set("returndetail", (Object)returnReason);
                DynamicObject returnrecord = (DynamicObject)orderpoolReturnrecords.get(orderPoolId);
                if (returnrecord == null) {
                    returnrecord = BusinessDataServiceHelper.newDynamicObject((String)"mds_returnrecord");
                    returnrecord.set("orderpoolid", (Object)orderPoolId);
                    returnrecord.set("salbillno", orderpool.get("salbillno"));
                    returnrecord.set("salbillseq", orderpool.get("salbillseq"));
                }
                DynamicObjectCollection entrys = returnrecord.getDynamicObjectCollection("entryentity");
                DynamicObject entry = new DynamicObject(entrys.getDynamicObjectType());
                entry.set("returnmans", (Object)RequestContext.get().getCurrUserId());
                entry.set("returndate", (Object)new Date());
                entry.set("returndetail", (Object)returnReason);
                entrys.add((Object)entry);
                returnrecordLists.add(returnrecord);
                updateOrderPools.add(orderpool);
            }
            if (!updateOrderPools.isEmpty()) {
                SaveServiceHelper.save((DynamicObject[])updateOrderPools.toArray(new DynamicObject[0]));
            }
            if (!returnrecordLists.isEmpty()) {
                SaveServiceHelper.save((DynamicObject[])returnrecordLists.toArray(new DynamicObject[0]));
            }
        }
        catch (Exception e) {
            logger.error("\u9000\u56de\u8ba2\u5355\u6c60\u5206\u5f55\u62a5\u9519", (Throwable)e);
            for (Long successId : successIds) {
                errors.put(successId, e.getMessage());
            }
            successIds.clear();
        }
        result.put("successIds", successIds);
        result.put("errors", errors);
        return result;
    }
}

