/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mds.mservice.orderpool;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import kd.bos.bec.api.IEventServicePlugin;
import kd.bos.bec.model.EntityEvent;
import kd.bos.bec.model.KDBizEvent;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class OrderPoolDeleteEventPlugin
implements IEventServicePlugin {
    public Object handleEvent(KDBizEvent evt) {
        if (evt instanceof EntityEvent) {
            EntityEvent entityEvent = (EntityEvent)evt;
            String operation = entityEvent.getOperation();
            if (!"delete".equals(operation)) {
                return evt.getEventId();
            }
            List bussinessKeys = entityEvent.getBusinesskeys();
            if (bussinessKeys.isEmpty()) {
                return evt.getEventId();
            }
            HashSet<Long> ids = new HashSet<Long>(bussinessKeys.size());
            for (String bussinessKey : bussinessKeys) {
                ids.add(Long.parseLong(bussinessKey));
            }
            ArrayList<Long> orderpoolids = new ArrayList<Long>(bussinessKeys.size());
            DynamicObject[] orderpools = BusinessDataServiceHelper.load((String)"mds_orderpooldata", (String)"id,scheduledproqty,unscheduledproqty", (QFilter[])new QFilter[]{new QFilter("salbillid", "in", ids)});
            ArrayList<DynamicObject> updatePools = new ArrayList<DynamicObject>(orderpools.length);
            for (DynamicObject orderpool : orderpools) {
                BigDecimal scheduledproqty = orderpool.getBigDecimal("scheduledproqty");
                if (scheduledproqty != null && scheduledproqty.compareTo(BigDecimal.ZERO) > 0) {
                    orderpool.set("unscheduledproqty", (Object)BigDecimal.ZERO);
                    updatePools.add(orderpool);
                    continue;
                }
                orderpoolids.add(orderpool.getLong("id"));
            }
            if (!updatePools.isEmpty()) {
                SaveServiceHelper.save((DynamicObject[])updatePools.toArray(new DynamicObject[0]));
            }
            DeleteServiceHelper.delete((String)"mds_orderpooldata", (QFilter[])new QFilter[]{new QFilter("id", "in", orderpoolids)});
        }
        return evt.getEventId();
    }
}

