/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mds.mservice.upgrade;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.servicehelper.QueryServiceHelper;

public class MdsReceiveDataUpgradeService
implements IUpgradeService {
    protected static final Log logger = LogFactory.getLog(MdsReceiveDataUpgradeService.class);
    public static final String UPDATE_SQL = "update t_mds_receivedata set fbaseunitid=? where fmaterialid=? and (fbaseunitid is null or fbaseunitid=0)";

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        DBRoute scmRoute = new DBRoute("scm");
        DataSet receivedataDataSet = DB.queryDataSet((String)"MdsReceiveDataUpgradeService_receivedataDataSet", (DBRoute)scmRoute, (String)"select fmaterialid,fbaseunitid from t_mds_receivedata where fbaseunitid is null or fbaseunitid=0");
        HashSet<Long> materialSet = new HashSet<Long>(16);
        for (Row row : receivedataDataSet) {
            long fmaterialid = row.getLong("fmaterialid");
            materialSet.add(fmaterialid);
        }
        DataSet materialDataSet = QueryServiceHelper.queryDataSet((String)"MdsReceiveDataUpgradeService_materialDataSet", (String)"bd_material", (String)"id,baseunit", (QFilter[])new QFilter[]{new QFilter("id", "in", materialSet)}, null);
        ArrayList<Object[]> updateList = new ArrayList<Object[]>(16);
        for (Row row : materialDataSet) {
            if (updateList.size() >= 10000) {
                this.dbExecuteBatch(UPDATE_SQL, updateList);
                updateList.clear();
            }
            Object[] val = new Object[]{row.getLong("baseunit"), row.getLong("id")};
            updateList.add(val);
        }
        if (updateList.size() > 0) {
            this.dbExecuteBatch(UPDATE_SQL, updateList);
            updateList.clear();
        }
        materialDataSet.close();
        receivedataDataSet.close();
        result.setSuccess(true);
        result.setLog("data update successfully.");
        return result;
    }

    private void dbExecuteBatch(String updateSeqSql, List<Object[]> updateList) {
        DB.executeBatch((DBRoute)DBRoute.of((String)"scm"), (String)updateSeqSql, updateList);
    }
}

