/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mds.opplugin;

import java.util.Date;
import java.util.HashMap;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.lang.Lang;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.api.JobInfo;
import kd.bos.schedule.api.JobType;
import kd.bos.schedule.executor.JobClient;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.mmc.mds.common.util.CalcuColumns;

public class DPSSiteCalcListOp
extends AbstractOperationServicePlugIn {
    private static final String selectProps = "id,number,billstatus,calstatus";
    private static final String classNameTask = "kd.mmc.mds.common.dspsite.DPSSiteHandlerTask";

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        e.getFieldKeys().add("dpssitescheme.id");
        e.getFieldKeys().add("enable");
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        DynamicObject[] objs;
        for (DynamicObject obj : objs = e.getDataEntities()) {
            DynamicObject tmpObj = (DynamicObject)obj.get("dpssitescheme");
            if (tmpObj == null) continue;
            QFilter filter = new QFilter("id", "in", tmpObj.getPkValue());
            QFilter[] filters = new QFilter[]{filter};
            DynamicObject[] objSchemes = BusinessDataServiceHelper.load((String)"mds_siteschemedef", (String)selectProps, (QFilter[])filters);
            String enable = obj.getString("enable");
            if (!"".equals(enable) && !"A".equals(enable)) {
                DynamicObject destobj = obj;
                DynamicObject targetobj = this.ormCreate("mds_dpsplanexec");
                targetobj.set("dpssitescheme", destobj.get("dpssitescheme"));
                targetobj.set("number", (Object)this.getUnRepeatNumber(targetobj));
                targetobj.set("creator", (Object)RequestContext.get().getCurrUserId());
                targetobj.set("createorg", (Object)RequestContext.get().getOrgId());
                targetobj.set("createtime", (Object)new Date());
                targetobj.set("modifier", (Object)RequestContext.get().getCurrUserId());
                targetobj.set("modifytime", (Object)new Date());
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{targetobj});
                obj = targetobj;
            }
            for (DynamicObject _obj : objSchemes) {
                DPSSiteCalcListOp.runImediatly(_obj, obj.getPkValue());
            }
        }
    }

    public String getUnRepeatNumber(DynamicObject targetobj) {
        String entityNum = "mds_dpsplanexec";
        DynamicObject dataInfo = targetobj;
        return CodeRuleServiceHelper.getNumber((String)entityNum, (DynamicObject)dataInfo, null);
    }

    private DynamicObject ormCreate(String entityName) {
        return ORM.create().newDynamicObject(entityName);
    }

    public static void runImediatly(DynamicObject bill, Object schemeid) {
        JobInfo jobInfo = new JobInfo();
        String jobId = bill.getString("number");
        jobInfo.setId(jobId);
        jobInfo.setName(ResManager.loadKDString((String)"\u9700\u6c42\u5206\u914d\u8fd0\u7b97", (String)"DPSSiteCalcListOp_0", (String)"mmc-mds-opplugin", (Object[])new Object[0]));
        jobInfo.setJobType(JobType.REALTIME);
        jobInfo.setRunByOrgId(RequestContext.get().getOrgId());
        jobInfo.setRunByUserId(RequestContext.get().getCurrUserId());
        jobInfo.setRunByLang(Lang.get());
        boolean connc = true;
        jobInfo.setRunConcurrently(connc);
        String className = DPSSiteCalcListOp.getTaskId();
        if (className != null) {
            jobInfo.setTaskDefineId(className);
        }
        jobInfo.setTaskClassname(classNameTask);
        jobInfo.setAppId("mds");
        if (schemeid != null) {
            DynamicObject schemebill = BusinessDataServiceHelper.loadSingle((Object)schemeid, (String)"mds_dpsplanexec");
            schemebill.set("status", (Object)CalcuColumns.Billstatus.PLAN.getCode());
            schemebill.set("enable", (Object)CalcuColumns.CalcStatus.RUNNING.getCode());
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{schemebill});
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("DPSSiteSchemeID", bill.getLong("id"));
        params.put("DPSSiteExecID", schemeid);
        jobInfo.setParams(params);
        boolean isLock = CalcuColumns.createLock((String)"mds_siteschemedef", (String)"update", (String)String.valueOf(bill.getLong("id")));
        if (!isLock) {
            return;
        }
        JobClient.dispatch((JobInfo)jobInfo);
    }

    public static String getTaskId() {
        DynamicObject taskname = BusinessDataServiceHelper.loadSingle((String)"sch_taskdefine", (String)"number", (QFilter[])new QFilter[]{new QFilter("classname", "=", (Object)classNameTask)});
        if (taskname == null) {
            return null;
        }
        return String.valueOf(taskname.getPkValue());
    }
}

