/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mds.opplugin;

import com.alibaba.fastjson.JSON;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.KDBizException;
import kd.bos.form.plugin.impt.BatchImportSheetHandler;
import kd.bos.form.plugin.impt.ImportContext;
import kd.bos.impt.SheetHandler;
import kd.bos.service.KDDateUtils;
import kd.mmc.mds.common.util.DateUtil;
import org.apache.commons.collections4.MapUtils;

class FCPlanDataBatchImportSheetHandler
extends BatchImportSheetHandler {
    private String url;
    private SheetHandler.ParsedRow row2;

    public FCPlanDataBatchImportSheetHandler(ImportContext ctx, MainEntityType mainEntityType, String url) {
        super(ctx, mainEntityType, url);
        this.url = url;
    }

    public void handleRow(SheetHandler.ParsedRow row) {
        if (row.getRowNum() == 2) {
            this.row2 = row;
        } else if (row.getRowNum() == 3) {
            this.declareNameRow(this.row2.getData(), row.getData());
            super.handleRow(this.row2);
            super.handleRow(row);
        } else {
            super.handleRow(row);
        }
    }

    private void declareNameRow(Map<Integer, String> codeRow, Map<Integer, String> nameRow) {
        DistributeSessionlessCache cache;
        HashMap<String, String> errMap = new HashMap<String, String>();
        Map<Integer, Date> dateNodeMap = this.getDateNodeMap(nameRow, codeRow, errMap);
        if (dateNodeMap.isEmpty()) {
            errMap.put("timeParseErr", ResManager.loadKDString((String)"\u65f6\u95f4\u5217\u4e3a\u7a7a", (String)"FCPlanDataBatchImportSheetHandler_0", (String)"mmc-mds-opplugin", (Object[])new Object[0]));
        }
        if (dateNodeMap.size() > 150) {
            errMap.put("timeParseErr", ResManager.loadKDString((String)"\u65f6\u95f4\u5217\u8d85\u957f\uff0c\u8bf7\u63a7\u5236\u5728150\u4e2a\u65f6\u95f4\u5468\u671f\u5185", (String)"FCPlanDataBatchImportSheetHandler_1", (String)"mmc-mds-opplugin", (Object[])new Object[0]));
        }
        Map<String, Date> attrRelDate = this.writeAttrToCodeRow(codeRow, dateNodeMap);
        if (MapUtils.isNotEmpty(errMap)) {
            cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("customRegion");
            cache.put(this.url, (Object)JSON.toJSONString(errMap), 30, TimeUnit.MINUTES);
        }
        if (MapUtils.isNotEmpty(attrRelDate)) {
            cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("customRegion");
            cache.put(this.url + "_attrRelDate", (Object)JSON.toJSONString(attrRelDate), 30, TimeUnit.MINUTES);
        }
    }

    private Map<String, Date> writeAttrToCodeRow(Map<Integer, String> codeRow, Map<Integer, Date> dateNodeMap) {
        HashMap<String, Date> attrRelDate = new HashMap<String, Date>();
        Set<Integer> keySet = dateNodeMap.keySet();
        TreeSet<Integer> treeSet = new TreeSet<Integer>();
        treeSet.addAll(keySet);
        int i = 1;
        for (Integer index : treeSet) {
            String attr = "qty" + i;
            codeRow.put(index, attr);
            attrRelDate.put(attr, dateNodeMap.get(index));
            ++i;
        }
        return attrRelDate;
    }

    /*
     * WARNING - void declaration
     */
    private Map<Integer, Date> getDateNodeMap(Map<Integer, String> nameRow, Map<Integer, String> codeRow, Map<String, String> errMap) {
        HashMap<Integer, Date> dateNodeMap = new HashMap<Integer, Date>();
        Set<Map.Entry<Integer, String>> entrySet = nameRow.entrySet();
        TreeSet<Integer> emptyDateCellSet = new TreeSet<Integer>();
        for (Map.Entry<Integer, String> entry : entrySet) {
            Integer index = entry.getKey();
            String name = entry.getValue();
            String code = codeRow.get(index);
            if (StringUtils.isNotEmpty((CharSequence)name) && StringUtils.isEmpty((CharSequence)code)) {
                String dateNodeStr = name;
                Date dateNode = null;
                try {
                    dateNode = KDDateUtils.parseDate((String)dateNodeStr);
                }
                catch (KDBizException e) {
                    void var15_17;
                    String string = MapUtils.getString(errMap, (Object)"timeParseErr", (String)"");
                    if (kd.bos.util.StringUtils.isNotEmpty((String)string)) {
                        String string2 = string + "\uff0c";
                    }
                    errMap.put("timeParseErr", String.format(ResManager.loadKDString((String)"%1$s\u7b2c%2$s\u5217[%3$s]\u65f6\u95f4\u683c\u5f0f\u6709\u8bef\uff0c\u8bf7\u4fee\u6539\u3002", (String)"FCPlanDataBatchImportSheetHandler_8", (String)"mmc-mds-opplugin", (Object[])new Object[0]), var15_17, index + 1, dateNodeStr));
                }
                if (DateUtil.checkDateOverflow((Date)dateNode)) {
                    Object errMsg = MapUtils.getString(errMap, (Object)"timeParseErr", (String)"");
                    if (kd.bos.util.StringUtils.isNotEmpty((String)errMsg)) {
                        errMsg = (String)errMsg + "\uff0c";
                    }
                    errMap.put("timeParseErr", String.format(ResManager.loadKDString((String)"%1$s\u7b2c%2$s\u5217\u5e74\u4efd\u8d85\u51fa\u8303\u56f4\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\u3002", (String)"FCPlanDataBatchImportSheetHandler_9", (String)"mmc-mds-opplugin", (Object[])new Object[0]), errMsg, index + 1));
                }
                dateNodeMap.put(index, dateNode);
                continue;
            }
            if (!StringUtils.isEmpty((CharSequence)name)) continue;
            emptyDateCellSet.add(index);
        }
        Set set = dateNodeMap.keySet();
        TreeSet<Integer> emptySet = new TreeSet<Integer>();
        TreeSet treeSet = new TreeSet();
        treeSet.addAll(set);
        int maxIndex = 0;
        if (!treeSet.isEmpty()) {
            maxIndex = (Integer)treeSet.last();
        }
        for (Integer index : emptyDateCellSet) {
            if (index >= maxIndex) continue;
            emptySet.add(index + 1);
        }
        if (!emptySet.isEmpty()) {
            String errMsg = MapUtils.getString(errMap, (Object)"timeParseErr", (String)"");
            if (kd.bos.util.StringUtils.isNotEmpty((String)errMsg)) {
                errMsg = errMsg + "\uff0c";
            }
            errMap.put("timeParseErr", String.format(ResManager.loadKDString((String)"\u8bf7\u586b\u5199%1$s\u7b2c%2$s\u5217\u3002", (String)"FCPlanDataBatchImportSheetHandler_10", (String)"mmc-mds-opplugin", (Object[])new Object[0]), errMsg, ((Object)emptySet).toString()));
        }
        HashMap<String, TreeSet> dataRelIndex = new HashMap<String, TreeSet>(128);
        SimpleDateFormat dateformat = new SimpleDateFormat("yyyy-MM-dd");
        Set dateNodeEntry = dateNodeMap.entrySet();
        for (Map.Entry entry : dateNodeEntry) {
            Integer key = (Integer)entry.getKey();
            Date v = (Date)entry.getValue();
            if (v == null) continue;
            String dateStr = dateformat.format(v);
            TreeSet indexSet = null;
            if (dataRelIndex.containsKey(dateStr)) {
                indexSet = (TreeSet)dataRelIndex.get(dateformat.format(v));
                indexSet.add(key + 1);
                continue;
            }
            indexSet = new TreeSet();
            indexSet.add(key + 1);
            dataRelIndex.put(dateformat.format(v), indexSet);
        }
        if (!dataRelIndex.isEmpty()) {
            StringBuilder sBuilder = new StringBuilder();
            sBuilder.append(MapUtils.getString(errMap, (Object)"timeParseErr", (String)""));
            for (Map.Entry entry : dataRelIndex.entrySet()) {
                String date = (String)entry.getKey();
                TreeSet indexSet = (TreeSet)entry.getValue();
                if (indexSet == null || indexSet.size() <= 1) continue;
                if (sBuilder.length() > 0) {
                    sBuilder.append("\uff0c");
                }
                sBuilder.append(String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u5217\u91cd\u590d\u65e5\u671f\u4e3a'%2$s'", (String)"FCPlanDataBatchImportSheetHandler_11", (String)"mmc-mds-opplugin", (Object[])new Object[0]), indexSet.toString(), date));
            }
            if (sBuilder.length() > 0) {
                errMap.put("timeParseErr", sBuilder.toString());
            }
        }
        return dateNodeMap;
    }
}

