/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mds.opplugin;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import kd.bos.algo.olap.util.ByteArrayInputStream;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.QueryEntityType;
import kd.bos.entity.api.ApiResult;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.form.field.ComboItem;
import kd.bos.form.operate.MutexHelper;
import kd.bos.form.plugin.impt.BatchImportPlugin;
import kd.bos.form.plugin.impt.ImportBillData;
import kd.bos.impt.ExcelReader;
import kd.bos.impt.SheetHandler;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import kd.bos.util.ExceptionUtils;
import kd.bos.util.StringUtils;
import kd.bos.util.io.ByteArrayOutputStream;
import kd.mmc.mds.common.plandata.FCPlanDataHelper;
import kd.mmc.mds.common.plandata.PlanDataImportHelper;
import kd.mmc.mds.common.util.DateUtil;
import kd.mmc.mds.common.util.MDSUtils;
import kd.mmc.mds.opplugin.FCPlanDataBatchImportSheetHandler;
import org.apache.commons.collections4.MapUtils;

public class FCPlanDataColumnentryMDSImportPlugin
extends BatchImportPlugin {
    private static Log log = LogFactory.getLog(FCPlanDataColumnentryMDSImportPlugin.class);

    protected int getBatchImportSize() {
        return 1;
    }

    public String getDefaultKeyFields() {
        return "fcvrnnum";
    }

    public List<ComboItem> getOverrideFieldsConfig() {
        List list = super.getOverrideFieldsConfig();
        ArrayList<ComboItem> newlist = new ArrayList<ComboItem>();
        for (ComboItem comboItem : list) {
            if (!"fcvrnnum".equals(comboItem.getValue())) continue;
            newlist.add(comboItem);
        }
        return newlist;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void resolveExcel() {
        FileService service = FileServiceFactory.getAttachmentFileService();
        ExcelReader reader = new ExcelReader();
        Iterator var3 = this.ctx.getAllUrls().iterator();
        HashMap<String, String> errMap = new HashMap<String, String>(16);
        while (var3.hasNext()) {
            Throwable cause;
            String url = (String)var3.next();
            try {
                try (InputStream in = service.getInputStream(url);){
                    final LinkedList sheet = new LinkedList();
                    final LinkedList materialSheet = new LinkedList();
                    new ExcelReader().read(in, new SheetHandler(){

                        public void handleRow(SheetHandler.ParsedRow row) {
                            if (row.getRowNum() > 3) {
                                sheet.add(row.getData().get(0));
                                String material = (String)row.getData().get(1);
                                if (StringUtils.isNotEmpty((String)material)) {
                                    materialSheet.add(material);
                                }
                            }
                        }
                    });
                    PlanDataImportHelper.checkImportOverflow((int)materialSheet.size(), errMap);
                    if (MapUtils.isEmpty(errMap)) {
                        PlanDataImportHelper.checkImportVrdsContinuity(sheet, errMap);
                    }
                    cause = null;
                    if (MapUtils.isNotEmpty(errMap)) {
                        this.putToCache(url, errMap);
                    }
                }
                in = service.getInputStream(url);
                try {
                    MainEntityType mainEntityType = this.buildMainEntityType(null);
                    if (mainEntityType instanceof QueryEntityType) {
                        mainEntityType = ((QueryEntityType)mainEntityType).getMainEntityType();
                    }
                    reader.read(in, (SheetHandler)new FCPlanDataBatchImportSheetHandler(this.ctx, mainEntityType, url));
                }
                catch (Throwable var16) {
                    cause = var16;
                    throw var16;
                }
                finally {
                    if (in == null) continue;
                    if (cause != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable var15) {
                            cause.addSuppressed(var15);
                        }
                        continue;
                    }
                    in.close();
                }
            }
            catch (Throwable var18) {
                log.error(var18);
                if (SystemParamServiceHelper.isShowStackTrace()) {
                    this.ctx.getLogger(url).log(Integer.valueOf(0), var18);
                } else {
                    cause = var18.getCause();
                    String importErrMsg = cause instanceof KDBizException ? var18.getMessage() : ResManager.loadKDString((String)"\u89e3\u6790\u5f02\u5e38\uff0c\u8bf7\u68c0\u67e5\u65e5\u5fd7\u5206\u6790\u3002", (String)"FCPlanDataColumnentryMDSImportPlugin_0", (String)"mmc-mds-opplugin", (Object[])new Object[0]);
                    this.ctx.getLogger(url).log(Integer.valueOf(0), importErrMsg);
                }
                this.ctx.addBillData(url, new ImportBillData(new JSONObject(), 0, 0));
                this.ctx.setResolveComplete(url);
            }
        }
    }

    private void putToCache(String url, Map<String, String> errMap) {
        DistributeSessionlessCache cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("customRegion");
        cache.put(url, (Object)JSON.toJSONString(errMap), 30, TimeUnit.MINUTES);
    }

    protected ApiResult save(List<ImportBillData> rowdatas, ImportLogger logger) {
        ApiResult apiResult;
        String url = logger.getSrcFile();
        DistributeSessionlessCache cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("customRegion");
        String jsonStr = (String)cache.get(url);
        if (StringUtils.isNotEmpty((String)jsonStr)) {
            JSONObject errJson = JSON.parseObject((String)jsonStr);
            String temp2_att_err = errJson.getString("temp2_att_err");
            String timeParseErr = errJson.getString("timeParseErr");
            ArrayList apiList = new ArrayList(16);
            for (int i = 0; i < rowdatas.size(); ++i) {
                ImportBillData importBillData = rowdatas.get(i);
                int startIndex = importBillData.getStartIndex();
                int endIndex = importBillData.getEndIndex();
                HashMap<Integer, JSONArray> convertResult = new HashMap<Integer, JSONArray>();
                for (int curIndex = startIndex; curIndex <= endIndex; ++curIndex) {
                    JSONArray jsonArray = new JSONArray();
                    String errMsg = errJson.getString(curIndex + "");
                    if (curIndex == 4 && StringUtils.isEmpty((String)errMsg)) {
                        errMsg = "";
                        if ("1".equals(temp2_att_err)) {
                            errMsg = ResManager.loadKDString((String)"\u65f6\u95f4\u53c2\u6570\u6709\u8bef", (String)"FCPlanDataColumnentryMDSImportPlugin_1", (String)"mmc-mds-opplugin", (Object[])new Object[0]);
                        }
                        if (StringUtils.isNotEmpty((String)temp2_att_err)) {
                            errMsg = temp2_att_err;
                        }
                        if (StringUtils.isNotEmpty((String)timeParseErr)) {
                            errMsg = timeParseErr;
                        }
                    } else if (StringUtils.isNotEmpty((String)errMsg) && errMsg.endsWith("\uff0c")) {
                        errMsg = errMsg.substring(0, errMsg.length() - 1);
                    }
                    if (!StringUtils.isNotEmpty((String)errMsg)) continue;
                    jsonArray.add((Object)errMsg);
                    convertResult.put(curIndex, jsonArray);
                }
                HashMap<String, Object> apiData = new HashMap<String, Object>(16);
                apiData.put("dindex", i);
                apiData.put("success", false);
                apiData.put("convertResult", convertResult);
                apiList.add(apiData);
            }
            ApiResult apiResult2 = new ApiResult();
            apiResult2.setSuccess(false);
            apiResult2.setData(apiList);
            return apiResult2;
        }
        String attrRelDateStr = (String)cache.get(url + "_attrRelDate");
        JSONObject attrRelDate = JSON.parseObject((String)attrRelDateStr);
        this.formatBillData(rowdatas, attrRelDate);
        StringBuilder sb = new StringBuilder();
        boolean isAddMutex = this.addParentImportMutex(rowdatas, sb);
        if (isAddMutex) {
            apiResult = super.save(rowdatas, logger);
        } else {
            ArrayList apiList = new ArrayList(16);
            HashMap<String, Object> apiData = new HashMap<String, Object>(16);
            HashMap<Integer, JSONArray> convertResult = new HashMap<Integer, JSONArray>(16);
            int curIndex = rowdatas.get(0).getStartIndex();
            JSONArray jsonArray = new JSONArray();
            jsonArray.add((Object)sb.toString());
            convertResult.put(curIndex, jsonArray);
            apiData.put("dindex", 0);
            apiData.put("success", false);
            apiData.put("convertResult", convertResult);
            apiList.add(apiData);
            apiResult = new ApiResult();
            apiResult.setSuccess(false);
            apiResult.setData(apiList);
        }
        this.formatApiResult(apiResult);
        this.releaseParentImportMutex(rowdatas);
        return apiResult;
    }

    private boolean addParentImportMutex(List<ImportBillData> rowdatas, StringBuilder sb) {
        ImportBillData importBillData = rowdatas.get(0);
        JSONObject obj = importBillData.getData();
        String fcvrnnum = obj.getJSONObject("fcvrnnum").getString("number");
        DynamicObject vrds = this.getMdsVrds(fcvrnnum);
        if (vrds != null) {
            DynamicObject[] locks;
            Object pk = vrds.get("id");
            boolean result = MutexHelper.require((String)"mds_vrds", (Object)pk, (String)"importdata", (boolean)true, (StringBuilder)sb);
            if (!result && (locks = FCPlanDataHelper.getDataLocks((Object)(pk + ""), (String)"mds_vrds", (String)"importdata")) != null && locks.length > 0) {
                sb.append((CharSequence)FCPlanDataHelper.getCreateErrMsg((DynamicObject)vrds));
                StringBuilder sb2 = FCPlanDataHelper.getCreateErrMsg((DynamicObject)vrds);
                if (sb2.length() != 0) {
                    sb.setLength(0);
                    sb.append((CharSequence)sb2);
                }
                return false;
            }
            return result;
        }
        return true;
    }

    private void releaseParentImportMutex(List<ImportBillData> rowdatas) {
        ImportBillData importBillData = rowdatas.get(0);
        JSONObject obj = importBillData.getData();
        String fcvrnnum = obj.getJSONObject("fcvrnnum").getString("number");
        DynamicObject vrds = this.getMdsVrds(fcvrnnum);
        if (vrds != null) {
            MutexHelper.release((String)"mds_vrds", (String)"importdata", (String)vrds.getString("id"));
        }
    }

    private void formatApiResult(ApiResult apiResult) {
        Object getDataObj;
        if (apiResult != null && (getDataObj = apiResult.getData()) instanceof List) {
            List apiDataList = (List)getDataObj;
            for (int i = 0; i < apiDataList.size(); ++i) {
                Object apiDataObj = apiDataList.get(i);
                if (!(apiDataObj instanceof Map)) continue;
                Map apiData = (Map)apiDataObj;
                Object convertResultObj = apiData.get("convertResult");
                boolean success = MapUtils.getBoolean((Map)apiData, (Object)"success", (Boolean)true);
                Object data = apiData.get("data");
                if (success || !(data instanceof List)) continue;
                List dataList = (List)data;
                for (int j = 0; j < dataList.size(); ++j) {
                    OperateErrorInfo info;
                    String msg;
                    Object obj = dataList.get(j);
                    if (!(obj instanceof OperateErrorInfo) || (msg = (info = (OperateErrorInfo)obj).getMessage()) == null || !msg.contains(ResManager.loadKDString((String)"\u8ba1\u5212\u7ec4\u7ec7", (String)"FCPlanDataColumnentryMDSImportPlugin_2", (String)"mmc-mds-opplugin", (Object[])new Object[0])) || this.checkRight()) continue;
                    info.setMessage(ResManager.loadKDString((String)"\u8be5\u7528\u6237\u5728\u5f53\u524d\u7ec4\u7ec7\u4e0b\u65e0\u65b0\u589e\u6743\u9650\u3002", (String)"FCPlanDataColumnentryMDSImportPlugin_3", (String)"mmc-mds-opplugin", (Object[])new Object[0]));
                }
            }
        }
    }

    private void formatBillData(List<ImportBillData> rowdatas, JSONObject attrRelDate) {
        HashSet<String> verNumSet = new HashSet<String>(128);
        for (int i = 0; i < rowdatas.size(); ++i) {
            ImportBillData importBillData = rowdatas.get(i);
            JSONObject obj = importBillData.getData();
            String fcvrnnum = obj.getJSONObject("fcvrnnum").getString("number");
            DynamicObject vrds = this.getMdsVrds(fcvrnnum);
            Set dayKeySet = attrRelDate.keySet();
            verNumSet.add(fcvrnnum);
            this.updateStatus(verNumSet);
            verNumSet.clear();
            if (vrds == null) continue;
            String cytypeStr = vrds.getString("cytype");
            String dayofweek = vrds.getString("dayofweek");
            if ("1".equals(cytypeStr) || "3".equals(cytypeStr)) {
                Object key2;
                HashSet<Date> weekDateSet = new HashSet<Date>(128);
                HashMap dateRelMonday = new HashMap(128);
                JSONObject weekAttrRelDate = new JSONObject();
                for (Object key2 : dayKeySet) {
                    Date date = attrRelDate.getDate((String)key2);
                    if ("1".equals(cytypeStr)) {
                        Date monday = DateUtil.getTheWeekStart((Date)date, (int)2);
                        monday = DateUtil.getMondayOffset((Date)monday, (String)dayofweek);
                        dateRelMonday.put(date, monday);
                        weekDateSet.add(monday);
                        continue;
                    }
                    Date monthFirstday = DateUtil.findFirstCurrentMonth((Date)date);
                    monthFirstday = DateUtil.getMonthOffset((Date)monthFirstday, (String)dayofweek);
                    dateRelMonday.put(date, monthFirstday);
                    weekDateSet.add(monthFirstday);
                }
                int z = 1;
                key2 = weekDateSet.iterator();
                while (key2.hasNext()) {
                    Date monday = (Date)key2.next();
                    weekAttrRelDate.put("qty" + z, (Object)monday);
                    ++z;
                }
                boolean hasErr = false;
                JSONArray entryentity = obj.getJSONArray("entryentity");
                JSONArray oldEntryentity = this.deepClone(entryentity);
                for (int j = 0; j < entryentity.size(); ++j) {
                    JSONObject data = entryentity.getJSONObject(j);
                    HashMap<Date, BigDecimal> newValue = new HashMap<Date, BigDecimal>();
                    for (String field : dayKeySet) {
                        String testV = data.getString(field);
                        if (testV != null && !StringUtils.isNumeric((String)testV)) {
                            hasErr = true;
                            continue;
                        }
                        BigDecimal value = data.getBigDecimal(field);
                        Date oldDate = attrRelDate.getDate(field);
                        Date newDate = (Date)dateRelMonday.get(oldDate);
                        BigDecimal oldV = (BigDecimal)newValue.get(newDate);
                        if (value == null) {
                            value = BigDecimal.valueOf(0L);
                        }
                        if (oldV == null) {
                            newValue.put(newDate, value);
                            continue;
                        }
                        newValue.put(newDate, oldV.add(value));
                    }
                    if (hasErr) continue;
                    for (int k = 1; k <= 150; ++k) {
                        String key3 = "qty" + k;
                        if (!weekAttrRelDate.containsKey((Object)key3)) {
                            data.put(key3, (Object)0);
                            continue;
                        }
                        Date d = weekAttrRelDate.getDate(key3);
                        BigDecimal v = (BigDecimal)newValue.get(d);
                        if (v != null) {
                            data.put(key3, (Object)v.toString());
                            continue;
                        }
                        data.put(key3, (Object)0);
                    }
                    this.addUnit(data);
                }
                if (hasErr) {
                    weekAttrRelDate = attrRelDate;
                    obj.put("entryentity", (Object)oldEntryentity);
                }
                JSONArray dateentity = new JSONArray();
                Set weekKeySet = weekAttrRelDate.keySet();
                for (String key4 : weekKeySet) {
                    JSONObject dateObj = new JSONObject();
                    dateObj.put("fieldkey", (Object)key4);
                    dateObj.put("targetdate", (Object)weekAttrRelDate.getDate(key4));
                    dateObj.put("deliverycolumn", (Object)0);
                    dateentity.add((Object)dateObj);
                }
                obj.put("dateentity", (Object)dateentity);
                continue;
            }
            JSONArray dateentity = new JSONArray();
            for (String key : dayKeySet) {
                JSONObject dateObj = new JSONObject();
                dateObj.put("fieldkey", (Object)key);
                dateObj.put("targetdate", (Object)attrRelDate.getDate(key));
                dateObj.put("deliverycolumn", (Object)0);
                dateentity.add((Object)dateObj);
            }
            obj.put("dateentity", (Object)dateentity);
            JSONArray entryentity = obj.getJSONArray("entryentity");
            for (int j = 0; j < entryentity.size(); ++j) {
                JSONObject data = entryentity.getJSONObject(j);
                for (int k = 1; k <= 150; ++k) {
                    String key = "qty" + k;
                    if (dayKeySet.contains(key)) continue;
                    data.put(key, (Object)0);
                }
                this.addUnit(data);
            }
        }
    }

    private void addUnit(JSONObject data) {
        String number;
        DynamicObject materia;
        JSONObject materialObj = data.getJSONObject("material");
        if (materialObj != null && (materia = this.getMaterial(number = materialObj.getString("number"))) != null) {
            Long baseunit = materia.getLong("baseunit.id");
            JSONObject baseunitObj = new JSONObject();
            baseunitObj.put("importprop", (Object)"id");
            baseunitObj.put("id", (Object)baseunit);
            data.put("baseunit", (Object)baseunitObj);
        }
    }

    private DynamicObject getMdsVrds(String fcvrnnumNumber) {
        QFilter verNumFilter = new QFilter("number", "=", (Object)fcvrnnumNumber);
        DynamicObject mdsVrds = QueryServiceHelper.queryOne((String)"mds_vrds", (String)"id,number,cytype,defaultorg.number,group.number,dayofweek", (QFilter[])new QFilter[]{verNumFilter});
        return mdsVrds;
    }

    private DynamicObject getMaterial(String number) {
        QFilter filter = new QFilter("number", "=", (Object)number);
        DynamicObject materia = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_material", (String)"baseunit", (QFilter[])new QFilter[]{filter});
        return materia;
    }

    public void updateStatus(Set<String> verNumSet) {
        DynamicObject[] planObj;
        QFilter filter = new QFilter("fcvrnnum.number", "in", verNumSet);
        String formid = this.ctx.getBillFormId();
        for (DynamicObject obj : planObj = BusinessDataServiceHelper.load((String)formid, (String)"id,billstatus", (QFilter[])new QFilter[]{filter})) {
            String status = obj.getString("billstatus");
            if (!"C".equals(status)) continue;
            obj.set("billstatus", (Object)"A");
        }
        SaveServiceHelper.save((DynamicObject[])planObj);
    }

    private boolean checkRight() {
        String formId = this.ctx.getBillFormId();
        String appid = "mds";
        String permissionItemId = "47156aff000000ac";
        return MDSUtils.checkPermission((String)appid, (String)formId, (String)permissionItemId);
    }

    private <T> JSONArray deepClone(JSONArray obj) {
        Object clonedObj = null;
        ObjectOutputStream oos = null;
        ObjectInputStream ois = null;
        ByteArrayInputStream bais = null;
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            oos = new ObjectOutputStream((OutputStream)baos);
            oos.writeObject(obj);
            bais = new ByteArrayInputStream(baos.toByteArray());
            ois = new ObjectInputStream((InputStream)bais);
            clonedObj = ois.readObject();
        }
        catch (Exception e) {
            throw new KDException((Throwable)e, new ErrorCode("FCPlanDataColumnentryMDSImportPlugin", ExceptionUtils.getExceptionStackTraceMessage((Exception)e)), new Object[0]);
        }
        finally {
            try {
                if (oos != null) {
                    oos.close();
                }
            }
            catch (IOException e) {
                log.error(ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
            }
            try {
                if (ois != null) {
                    ois.close();
                }
            }
            catch (IOException e) {
                log.error(ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
            }
            try {
                if (bais != null) {
                    bais.close();
                }
            }
            catch (IOException e) {
                log.error(ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
            }
        }
        if (clonedObj != null) {
            return (JSONArray)clonedObj;
        }
        return null;
    }
}

