/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mds.opplugin;

import java.util.Calendar;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.mmc.mds.common.plandata.FCPlanDataHelper;
import kd.mmc.mds.common.util.PlanDataToFcDataTranUtil;

public class PlandataAuditOp
extends AbstractOperationServicePlugIn {
    private static final Log log = LogFactory.getLog(PlandataAuditOp.class);

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        DynamicObject[] objs;
        for (DynamicObject dynamicObject : objs = e.getDataEntities()) {
            FCPlanDataHelper.clearOtherData((DynamicObject)dynamicObject);
        }
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        DynamicObject[] objs;
        for (DynamicObject obj : objs = e.getDataEntities()) {
            String version = obj.getString("fcvrnnum.number");
            DynamicObject versionobj = obj.getDynamicObject("fcvrnnum");
            if (!PlanDataToFcDataTranUtil.checkSyncStatusPlanData((String)versionobj.getString("number"))) {
                PlanDataToFcDataTranUtil.tranPlanDataToFcDataStatus((String)version);
                return;
            }
            DynamicObject objlog = this.ormCreate("mds_syncplanlog");
            objlog.set("version", (Object)versionobj);
            objlog.set("direction", (Object)"A");
            objlog.set("status", (Object)"C");
            objlog.set("enable", (Object)1);
            objlog.set("creator", (Object)RequestContext.get().getCurrUserId());
            objlog.set("createtime", (Object)Calendar.getInstance().getTime());
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{objlog});
            PlanDataToFcDataTranUtil.tranPlanDataToFcDataByTask((String)version, (Object)objlog.getPkValue());
        }
    }

    private DynamicObject ormCreate(String entityName) {
        return ORM.create().newDynamicObject(entityName);
    }

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        e.getFieldKeys().add("fcvrnnum.number");
        e.getFieldKeys().add("fcvrnnum.id");
        e.getFieldKeys().add("billstatus");
        e.getFieldKeys().add("enablestatus");
        e.getFieldKeys().add("entryentity");
    }
}

