/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mds.opplugin;

import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.mmc.mds.common.plandata.FCPlanDataHelper;
import kd.mmc.mds.common.plandata.PlanDataFieldsSetter;
import kd.mmc.mds.common.util.PlanDataToFcDataTranUtil;
import kd.mmc.mds.opplugin.validator.PlanDataConfigValidator;
import kd.mmc.mds.opplugin.validator.PlanDataValidator;

public class PlandataListSubmitOp
extends AbstractOperationServicePlugIn {
    private static final Log log = LogFactory.getLog(PlandataListSubmitOp.class);

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        DynamicObject[] objs;
        for (DynamicObject dynamicObject : objs = e.getDataEntities()) {
            FCPlanDataHelper.clearOtherData((DynamicObject)dynamicObject);
        }
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        DynamicObject[] objs;
        for (DynamicObject obj : objs = e.getDataEntities()) {
            String version = obj.getString("fcvrnnum.number");
            PlanDataToFcDataTranUtil.tranPlanDataToFcDataStatus((String)version);
        }
    }

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        String formId = this.billEntityType.getName();
        List allFields = PlanDataFieldsSetter.getAllFields((String)formId);
        allFields = allFields.stream().map(o -> "entryentity." + o).collect(Collectors.toList());
        e.getFieldKeys().addAll(allFields);
        e.getFieldKeys().add("fcvrnnum.number");
        e.getFieldKeys().add("fcvrnnum.id");
        e.getFieldKeys().add("entryentity.edituser");
        e.getFieldKeys().add("entryentity.editcreatedate");
        e.getFieldKeys().add("entryentity.entrymodifier");
        e.getFieldKeys().add("entryentity.editdate");
        e.getFieldKeys().add("entryentity.childid");
        e.getFieldKeys().add("entryentity.childid");
        e.getFieldKeys().addAll(FCPlanDataHelper.getEntryEntityFieldKeys());
        e.getFieldKeys().addAll(FCPlanDataHelper.getDateEntityFieldKeys());
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator((AbstractValidator)new PlanDataValidator());
        e.addValidator((AbstractValidator)new PlanDataConfigValidator());
    }
}

