/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mds.opplugin;

import java.util.ArrayList;
import java.util.Calendar;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.mmc.mds.common.plandata.FCPlanDataHelper;
import kd.mmc.mds.common.util.PlanDataToFcDataTranUtil;
import kd.mmc.mds.opplugin.validator.MultiPlanDataValidator;
import kd.mmc.mds.opplugin.validator.PlanDataConfigValidator;
import kd.mmc.mds.opplugin.validator.PlanDataPlanScopeValidator;

public class PlandataMultiSaveOp
extends AbstractOperationServicePlugIn {
    private static final Log log = LogFactory.getLog(PlandataMultiSaveOp.class);

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        DynamicObject[] objs;
        for (DynamicObject dynamicObject : objs = e.getDataEntities()) {
            FCPlanDataHelper.clearOtherData((DynamicObject)dynamicObject);
            DynamicObject version = dynamicObject.getDynamicObject("fcvrnnum");
            if (version == null) continue;
            dynamicObject.set("billno", version.get("number"));
        }
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        DynamicObject[] objs;
        for (DynamicObject dynamicObject : objs = e.getDataEntities()) {
            DynamicObject version = dynamicObject.getDynamicObject("fcvrnnum");
            Object versionPkValue = version.getPkValue();
            this.resetParentSeq(versionPkValue);
            DynamicObject objlog = this.ormCreate("mds_syncplanlog");
            objlog.set("version", (Object)version);
            objlog.set("direction", (Object)"A");
            objlog.set("status", (Object)"C");
            objlog.set("enable", (Object)1);
            objlog.set("syncresult", (Object)"C");
            objlog.set("creator", (Object)RequestContext.get().getUserId());
            objlog.set("createtime", (Object)Calendar.getInstance().getTime());
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{objlog});
            PlanDataToFcDataTranUtil.tranPlanDataToFcDataByTask((String)version.getString("number"), (Object)objlog.getPkValue());
        }
    }

    private void resetParentSeq(Object versionPkValue) {
        QFilter filter = new QFilter("fcvrnnum", "=", versionPkValue);
        DynamicObject mds_plandata = BusinessDataServiceHelper.loadSingle((String)"mds_plandata", (String)"id", (QFilter[])new QFilter[]{filter});
        if (mds_plandata == null) {
            return;
        }
        DynamicObject mds_plandataObj = BusinessDataServiceHelper.loadSingle((Object)mds_plandata.getPkValue(), (String)"mds_plandata");
        DynamicObjectCollection entryentity = mds_plandataObj.getDynamicObjectCollection("entryentity");
        Integer max = 0;
        if (entryentity != null && entryentity.size() > 0) {
            max = entryentity.stream().map(o -> o.getInt("seq")).max(Integer::compareTo).get();
        }
        if (max == null) {
            max = 0;
        }
        String updateSql = "update t_mds_fcdatatsentry set fseq=? where fentryid=?";
        ArrayList<Object[]> paramList = new ArrayList<Object[]>(16);
        if (entryentity != null && entryentity.size() > 0) {
            for (int i = 0; i < entryentity.size(); ++i) {
                DynamicObject entry = (DynamicObject)entryentity.get(i);
                if (entry.getInt("seq") != 0) continue;
                Object[] objectArray = new Object[2];
                max = max + 1;
                objectArray[0] = max;
                objectArray[1] = entry.getPkValue();
                Object[] param = objectArray;
                paramList.add(param);
            }
            if (paramList != null && paramList.size() > 0) {
                DB.executeBatch((DBRoute)new DBRoute("scm"), (String)updateSql, paramList);
            }
        }
    }

    private DynamicObject ormCreate(String entityName) {
        return ORM.create().newDynamicObject(entityName);
    }

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        e.getFieldKeys().add("fcvrnnum.number");
        e.getFieldKeys().add("fcvrnnum.id");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator((AbstractValidator)new MultiPlanDataValidator());
        e.addValidator((AbstractValidator)new PlanDataConfigValidator());
        e.addValidator((AbstractValidator)new PlanDataPlanScopeValidator());
    }
}

