/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mds.opplugin;

import java.util.Calendar;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.mmc.mds.common.plandata.FCPlanDataHelper;
import kd.mmc.mds.common.util.PlanDataToFcDataTranUtil;
import kd.mmc.mds.opplugin.validator.PlanDataConfigValidator;
import kd.mmc.mds.opplugin.validator.PlanDataPlanScopeValidator;
import kd.mmc.mds.opplugin.validator.PlanDataValidator;

public class PlandataSaveOp
extends AbstractOperationServicePlugIn {
    private static final Log log = LogFactory.getLog(PlandataSaveOp.class);

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        DynamicObject[] objs;
        for (DynamicObject dynamicObject : objs = e.getDataEntities()) {
            FCPlanDataHelper.clearOtherData((DynamicObject)dynamicObject);
            DynamicObject version = dynamicObject.getDynamicObject("fcvrnnum");
            if (version == null) continue;
            dynamicObject.set("billno", version.get("number"));
        }
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        DynamicObject[] objs;
        for (DynamicObject dynamicObject : objs = e.getDataEntities()) {
            DynamicObject version = dynamicObject.getDynamicObject("fcvrnnum");
            DynamicObject objlog = this.ormCreate("mds_syncplanlog");
            objlog.set("version", (Object)version);
            objlog.set("direction", (Object)"A");
            objlog.set("status", (Object)"C");
            objlog.set("enable", (Object)1);
            objlog.set("syncresult", (Object)"C");
            objlog.set("creator", (Object)RequestContext.get().getCurrUserId());
            objlog.set("createtime", (Object)Calendar.getInstance().getTime());
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{objlog});
            PlanDataToFcDataTranUtil.tranPlanDataToFcDataByTask((String)version.getString("number"), (Object)objlog.getPkValue());
        }
    }

    private DynamicObject ormCreate(String entityName) {
        return ORM.create().newDynamicObject(entityName);
    }

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        e.getFieldKeys().add("fcvrnnum.number");
        e.getFieldKeys().add("fcvrnnum.id");
        e.getFieldKeys().addAll(FCPlanDataHelper.getEntryEntityFieldKeys());
        e.getFieldKeys().addAll(FCPlanDataHelper.getDateEntityFieldKeys());
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator((AbstractValidator)new PlanDataValidator());
        e.addValidator((AbstractValidator)new PlanDataConfigValidator());
        e.addValidator((AbstractValidator)new PlanDataPlanScopeValidator());
    }
}

