/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mds.opplugin;

import java.util.Calendar;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.mmc.mds.common.plandata.FCPlanDataHelper;
import kd.mmc.mds.common.plandata.PlanDataFieldsSetter;
import kd.mmc.mds.common.util.PlanDataToFcDataTranUtil;
import kd.mmc.mds.opplugin.validator.PlanDataConfigValidator;
import kd.mmc.mds.opplugin.validator.PlanDataPlanScopeValidator;
import kd.mmc.mds.opplugin.validator.PlanDataValidator;

public class PlandataSubmitOp
extends AbstractOperationServicePlugIn {
    private static final Log log = LogFactory.getLog(PlandataSubmitOp.class);

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        DynamicObject[] objs;
        for (DynamicObject dynamicObject : objs = e.getDataEntities()) {
            FCPlanDataHelper.clearOtherData((DynamicObject)dynamicObject);
        }
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        DynamicObject[] objs;
        for (DynamicObject obj : objs = e.getDataEntities()) {
            String version = obj.getString("fcvrnnum.number");
            DynamicObject versionobj = obj.getDynamicObject("fcvrnnum");
            if (!PlanDataToFcDataTranUtil.checkSyncStatusPlanData((String)versionobj.getString("number"))) {
                PlanDataToFcDataTranUtil.tranPlanDataToFcDataStatus((String)version);
                return;
            }
            DynamicObject objlog = this.ormCreate("mds_syncplanlog");
            objlog.set("version", (Object)versionobj);
            objlog.set("direction", (Object)"A");
            objlog.set("status", (Object)"C");
            objlog.set("enable", (Object)1);
            objlog.set("creator", (Object)RequestContext.get().getUserId());
            objlog.set("createtime", (Object)Calendar.getInstance().getTime());
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{objlog});
            PlanDataToFcDataTranUtil.tranPlanDataToFcDataByTask((String)version, (Object)objlog.getPkValue());
        }
    }

    private DynamicObject ormCreate(String entityName) {
        return ORM.create().newDynamicObject(entityName);
    }

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        String formId = this.billEntityType.getName();
        List allFields = PlanDataFieldsSetter.getAllFields((String)formId);
        allFields = allFields.stream().map(o -> "entryentity." + o).collect(Collectors.toList());
        e.getFieldKeys().addAll(allFields);
        e.getFieldKeys().add("fcvrnnum.number");
        e.getFieldKeys().add("fcvrnnum.id");
        e.getFieldKeys().add("entryentity.edituser");
        e.getFieldKeys().add("entryentity.editcreatedate");
        e.getFieldKeys().add("entryentity.entrymodifier");
        e.getFieldKeys().add("entryentity.editdate");
        e.getFieldKeys().add("entryentity.childid");
        e.getFieldKeys().addAll(FCPlanDataHelper.getEntryEntityFieldKeys());
        e.getFieldKeys().addAll(FCPlanDataHelper.getDateEntityFieldKeys());
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator((AbstractValidator)new PlanDataValidator());
        e.addValidator((AbstractValidator)new PlanDataConfigValidator());
        e.addValidator((AbstractValidator)new PlanDataPlanScopeValidator());
    }
}

