/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mds.opplugin.orderpool;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;
import kd.mmc.mds.common.orderpool.entity.OrgMaterialConfiguredcode;
import kd.mmc.mds.common.orderpool.util.ResourceCheckUtil;

public class OrderPoolRresourceCheckOp
extends AbstractOperationServicePlugIn {
    private static final Log log = LogFactory.getLog(OrderPoolRresourceCheckOp.class);
    private static final String _SPLIT_ = "&&";
    private static final String PROP_ID = "id";

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        e.getFieldKeys().add("material");
        e.getFieldKeys().add("salbillno");
        e.getFieldKeys().add("salbillseq");
        e.getFieldKeys().add("invalidstatus");
        e.getFieldKeys().add("salbillno");
        e.getFieldKeys().add("configuredcode");
        e.getFieldKeys().add("auxpty");
        e.getFieldKeys().add("proorg");
        e.getFieldKeys().add("checkstatus");
        e.getFieldKeys().add("billtype");
        e.getFieldKeys().add("resourcesstatus");
        e.getFieldKeys().add("resourcesexception");
        e.getFieldKeys().add("reqqty");
        e.getFieldKeys().add("deliverydate");
        e.getFieldKeys().add("baseunit");
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        DynamicObject[] datas = e.getDataEntities();
        HashMap<Long, Map<Long, Set<String>>> orderpoolIdError = new HashMap<Long, Map<Long, Set<String>>>(datas.length);
        try (TraceSpan span = Tracer.create((String)"kd.mmc.mds.opplugin.orderpool.OrderPoolRresourceCheckOp.checkDataBom", (String)"checkDataBom");){
            this.checkData(datas, orderpoolIdError);
        }
        ArrayList<DynamicObject> orderpoolreses = new ArrayList<DynamicObject>(datas.length);
        ArrayList<Long> orderpoolIds = new ArrayList<Long>(datas.length);
        for (DynamicObject data : datas) {
            Long id = data.getLong(PROP_ID);
            orderpoolIds.add(id);
            boolean isComplete = true;
            Map map = (Map)orderpoolIdError.get(id);
            if (map == null || map.isEmpty()) {
                this.updateResourcesInfo(data, "B", "A", null);
            } else {
                DynamicObject orderpoolres = BusinessDataServiceHelper.newDynamicObject((String)"mds_orderpoolres");
                orderpoolres.set("salbillno", (Object)data.getString("salbillno"));
                orderpoolres.set("orderpoolid", (Object)id);
                orderpoolres.set("salbillseq", data.get("salbillseq"));
                orderpoolres.set("material", (Object)data.getLong("material.id"));
                orderpoolres.set("configuredcode", (Object)data.getLong("configuredcode.id"));
                orderpoolres.set("reqqty", (Object)data.getBigDecimal("reqqty"));
                orderpoolres.set("baseunit", (Object)data.getLong("baseunit.id"));
                orderpoolres.set("billtype", (Object)data.getLong("billtype.id"));
                orderpoolres.set("deliverydate", (Object)data.getDate("deliverydate"));
                DynamicObjectCollection orderpoolresentrys = orderpoolres.getDynamicObjectCollection("entryentity");
                ArrayList<String> errors = new ArrayList<String>();
                for (Map.Entry entry : map.entrySet()) {
                    Set errorvalues = (Set)entry.getValue();
                    for (String error : errorvalues) {
                        DynamicObject orderpoolresentry = new DynamicObject(orderpoolresentrys.getDynamicObjectType());
                        if (StringUtils.isNotBlank((CharSequence)error)) {
                            isComplete = false;
                        }
                        errors.add(error);
                        orderpoolresentry.set("errorinfo", (Object)error);
                        orderpoolresentrys.add((Object)orderpoolresentry);
                    }
                }
                this.updateResourcesInfo(data, "B", "B", errors);
                orderpoolreses.add(orderpoolres);
            }
            if (!isComplete) continue;
            this.updateResourcesInfo(data, "B", "A", null);
        }
        if (orderpoolIds.size() > 0) {
            DeleteServiceHelper.delete((String)"mds_orderpoolres", (QFilter[])new QFilter[]{new QFilter("orderpoolid", "in", orderpoolIds)});
        }
        if (orderpoolreses.size() > 0) {
            SaveServiceHelper.save((DynamicObject[])orderpoolreses.toArray(new DynamicObject[0]));
        }
        SaveServiceHelper.save((DynamicObject[])datas);
    }

    private void checkData(DynamicObject[] datas, Map<Long, Map<Long, Set<String>>> orderpoolIdError) {
        HashMap<OrgMaterialConfiguredcode, Set> materialConfiguredcodeOrderpoolId = new HashMap<OrgMaterialConfiguredcode, Set>(datas.length);
        HashSet<String> materialConfiguredcodeorgSet = new HashSet<String>(datas.length);
        for (DynamicObject data : datas) {
            Set errors;
            String errorInfo;
            Long orderPoolId = data.getLong(PROP_ID);
            Long materialId = 0L;
            Map materialErrors = orderpoolIdError.computeIfAbsent(orderPoolId, k -> new HashMap());
            DynamicObject material = data.getDynamicObject("material");
            DynamicObject proorg = data.getDynamicObject("proorg");
            if (proorg == null) {
                errorInfo = ResManager.loadKDString((String)"\u6570\u636e\u751f\u4ea7\u7ec4\u7ec7\u4e0d\u5b58\u5728\u3002", (String)"OrderPoolRresourceCheckOp_0", (String)"mmc-mds-opplugin", (Object[])new Object[0]);
                errors = materialErrors.computeIfAbsent(materialId, k -> new HashSet());
                errors.add(errorInfo);
                continue;
            }
            if (material == null) {
                errorInfo = ResManager.loadKDString((String)"\u6570\u636e\u6574\u673a\u6807\u8bc6\u4e0d\u5b58\u5728\u3002", (String)"OrderPoolRresourceCheckOp_1", (String)"mmc-mds-opplugin", (Object[])new Object[0]);
                errors = materialErrors.computeIfAbsent(materialId, k -> new HashSet());
                errors.add(errorInfo);
                continue;
            }
            materialId = material.getLong(PROP_ID);
            Long proorgId = proorg.getLong(PROP_ID);
            Long configuredcodeId = 0L;
            DynamicObject configuredcode = data.getDynamicObject("configuredcode");
            configuredcodeId = configuredcode != null ? configuredcode.getLong(PROP_ID) : 0L;
            OrgMaterialConfiguredcode omc = new OrgMaterialConfiguredcode(proorgId, materialId, configuredcodeId);
            Set orderPoolIds = materialConfiguredcodeOrderpoolId.computeIfAbsent(omc, k -> new HashSet());
            orderPoolIds.add(orderPoolId);
            StringBuilder keybulider = new StringBuilder();
            keybulider.append(materialId).append(_SPLIT_).append(configuredcodeId).append(_SPLIT_).append(proorgId);
            materialConfiguredcodeorgSet.add(keybulider.toString());
        }
        Map resourceChecks = ResourceCheckUtil.resourceCheck(materialConfiguredcodeorgSet);
        for (Map.Entry resourceCheck : resourceChecks.entrySet()) {
            OrgMaterialConfiguredcode omc = (OrgMaterialConfiguredcode)resourceCheck.getKey();
            Map value = (Map)resourceCheck.getValue();
            Set orderpoolIds = materialConfiguredcodeOrderpoolId.getOrDefault(omc, new HashSet());
            if (orderpoolIds.isEmpty() || value == null || value.isEmpty()) continue;
            for (Long orderpoolId : orderpoolIds) {
                Map materialErrors = orderpoolIdError.getOrDefault(orderpoolId, new HashMap(16));
                materialErrors.putAll(value);
            }
        }
    }

    private void updateResourcesInfo(DynamicObject data, String checkstatus, String resourcesStatus, List<String> errors) {
        data.set("checkstatus", (Object)checkstatus);
        data.set("resourcesstatus", (Object)resourcesStatus);
        StringBuilder errorStr = new StringBuilder();
        if (errors != null) {
            for (String error : errors) {
                errorStr.append(error).append("\r\n");
            }
            String error = errorStr.toString();
            if (error.length() > 254) {
                error = error.substring(0, 254);
            }
            data.set("resourcesexception", (Object)error);
        } else {
            data.set("resourcesexception", (Object)" ");
        }
    }
}

