/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mds.opplugin.validator;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.util.StringUtils;
import kd.mmc.mds.common.plandata.FCPlanDataHelper;

public class MdsPlanDataValidator
extends AbstractValidator {
    private static final Map<String, String> vrdsRelPlan = new HashMap<String, String>(4);
    private static final Map<String, String> vertypeMap = new HashMap<String, String>(4);

    public void validate() {
        long userId = RequestContext.get().getCurrUserId();
        String entityKey = this.entityKey;
        for (ExtendedDataEntity rowDataEntity : this.getDataEntities()) {
            DynamicObject dynamicObject = rowDataEntity.getDataEntity();
            if (dynamicObject == null) continue;
            DynamicObject version = dynamicObject.getDynamicObject("fcvrnnum");
            DynamicObjectCollection entryentity = dynamicObject.getDynamicObjectCollection("entryentity");
            Object childPlandataId = FCPlanDataHelper.createChildPlanData((Object)version.getPkValue(), (Object)userId, (DynamicObject)dynamicObject);
            for (DynamicObject entry : entryentity) {
                long edituser2;
                long childid = entry.getLong("childid");
                if (childid != 0L || childPlandataId == null || (edituser2 = entry.getLong("edituser.id")) != userId) continue;
                entry.set("childid", childPlandataId);
            }
            DynamicObject fcvrnnum = dynamicObject.getDynamicObject("fcvrnnum");
            if (fcvrnnum == null) continue;
            String verType = fcvrnnum.getString("vertype");
            String fcvrnnumNumber = fcvrnnum.getString("number");
            String fcvrnnumEnable = fcvrnnum.getString("enable");
            String fcvrnnumStatus = fcvrnnum.getString("status");
            String planType = "0";
            if (entityKey != null && StringUtils.isNotEmpty((String)entityKey)) {
                planType = vrdsRelPlan.get(entityKey);
                if (planType != null && !planType.equals(verType)) {
                    String verTypeName = vertypeMap.get(verType);
                    String planTypeName = vertypeMap.get(planType);
                    this.addErrorMessage(rowDataEntity, String.format(ResManager.loadKDString((String)"\u7248\u672c\u7c7b\u578b\u4e3a'%1$s'\uff0c\u8bf7\u4f7f\u7528\u7248\u672c\u7c7b\u578b\u4e3a'%2$s'\u7684\u9700\u6c42\u7248\u672c\u5b9a\u4e49\u3002", (String)"MdsPlanDataValidator_4", (String)"mmc-mds-opplugin", (Object[])new Object[0]), verTypeName, planTypeName));
                }
                if (!"1".equals(fcvrnnumEnable) || !"C".equals(fcvrnnumStatus)) {
                    this.addErrorMessage(rowDataEntity, String.format(ResManager.loadKDString((String)"\u7248\u672c\u7f16\u7801'%s'\u975e\u5ba1\u6838\u4e14\u53ef\u7528\u3002", (String)"MdsPlanDataValidator_1", (String)"mmc-mds-opplugin", (Object[])new Object[0]), fcvrnnumNumber));
                }
            }
            if (entryentity == null) continue;
            String uniqueMsg = FCPlanDataHelper.checkUnique((Object)fcvrnnum.getPkValue(), (DynamicObjectCollection)entryentity, (boolean)true);
            if (StringUtils.isNotEmpty((String)uniqueMsg)) {
                this.addErrorMessage(rowDataEntity, uniqueMsg);
            }
            for (DynamicObject entry : entryentity) {
                String materialEnable = entry.getString("material.enable");
                String materialStatus = entry.getString("material.status");
                String materialNumber = entry.getString("material.number");
                if (!"C".equals(materialStatus) || !"1".equals(materialEnable)) {
                    this.addErrorMessage(rowDataEntity, String.format(ResManager.loadKDString((String)"\u7269\u6599\u7f16\u7801'%s'\u975e\u5ba1\u6838\u4e14\u53ef\u7528\u3002", (String)"MdsPlanDataValidator_2", (String)"mmc-mds-opplugin", (Object[])new Object[0]), materialNumber));
                }
                for (int i = 1; i <= 150; ++i) {
                    BigDecimal bigDecimal = entry.getBigDecimal("qty" + i);
                    String bigDecimalStr = entry.getString("qty" + i);
                    if (bigDecimal == null || BigDecimal.ZERO.compareTo(bigDecimal) <= 0) continue;
                    this.addErrorMessage(rowDataEntity, String.format(ResManager.loadKDString((String)"'%s'\u683c\u5f0f\u6709\u8bef\u3002", (String)"MdsPlanDataValidator_3", (String)"mmc-mds-opplugin", (Object[])new Object[0]), bigDecimalStr));
                }
            }
        }
    }

    static {
        vrdsRelPlan.put("mds_forecastplandata", "0");
        vrdsRelPlan.put("mds_mdsplandata", "1");
        vrdsRelPlan.put("mds_dpsplandata", "2");
        vertypeMap.put("0", "Forecast");
        vertypeMap.put("1", "MDS");
        vertypeMap.put("2", "DPS");
    }
}

