/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mds.opplugin.validator;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dlock.DLock;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.StringUtils;
import kd.mmc.mds.common.plandata.FCPlanDataHelper;

public class MultiPlanDataValidator
extends AbstractValidator {
    private static final Map<String, String> vrdsRelPlan = new HashMap<String, String>(4);
    private static final Map<String, String> vertypeMap = new HashMap<String, String>(4);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void validate() {
        String entityKey = this.entityKey;
        long userId = RequestContext.get().getCurrUserId();
        DynamicObject user = BusinessDataServiceHelper.loadSingle((Object)userId, (String)"bos_user");
        for (ExtendedDataEntity rowDataEntity : this.getDataEntities()) {
            DynamicObject dynamicObject = rowDataEntity.getDataEntity();
            if (dynamicObject == null) continue;
            DynamicObject fcvrnnum = dynamicObject.getDynamicObject("fcvrnnum");
            DynamicObjectCollection entryentity = dynamicObject.getDynamicObjectCollection("entryentity");
            if (fcvrnnum == null) continue;
            String verType = fcvrnnum.getString("vertype");
            String fcvrnnumNumber = fcvrnnum.getString("number");
            String fcvrnnumEnable = fcvrnnum.getString("enable");
            String fcvrnnumStatus = fcvrnnum.getString("status");
            String planType = "0";
            DLock dLock = DLock.create((String)(fcvrnnum.getPkValue() + "_createParentPlanData"));
            dLock.lock();
            try {
                List falseData;
                this.checkDateOverflow(rowDataEntity);
                if (entityKey != null && StringUtils.isNotEmpty((String)entityKey)) {
                    planType = vrdsRelPlan.get(entityKey);
                    if (planType != null && !planType.equals(verType)) {
                        String verTypeName = vertypeMap.get(verType);
                        String planTypeName = vertypeMap.get(planType);
                        this.addErrorMessage(rowDataEntity, String.format(ResManager.loadKDString((String)"\u7248\u672c\u7c7b\u578b\u4e3a'%1$s'\uff0c\u8bf7\u4f7f\u7528\u7248\u672c\u7c7b\u578b\u4e3a'%2$s'\u7684\u9700\u6c42\u7248\u672c\u5b9a\u4e49\u3002", (String)"MultiPlanDataValidator_5", (String)"mmc-mds-opplugin", (Object[])new Object[0]), verTypeName, planTypeName));
                    }
                    if (!"1".equals(fcvrnnumEnable) || !"C".equals(fcvrnnumStatus)) {
                        this.addErrorMessage(rowDataEntity, String.format(ResManager.loadKDString((String)"\u7248\u672c\u7f16\u7801'%s'\u975e\u5ba1\u6838\u4e14\u53ef\u7528\u3002", (String)"MultiPlanDataValidator_1", (String)"mmc-mds-opplugin", (Object[])new Object[0]), fcvrnnumNumber));
                    }
                }
                if (entryentity != null) {
                    String uniqueMsg = FCPlanDataHelper.checkUnique((Object)fcvrnnum.getPkValue(), (DynamicObjectCollection)entryentity, (boolean)false);
                    if (StringUtils.isNotEmpty((String)uniqueMsg)) {
                        this.addErrorMessage(rowDataEntity, uniqueMsg);
                    }
                    for (DynamicObject entry : entryentity) {
                        String materialEnable = entry.getString("material.enable");
                        String materialStatus = entry.getString("material.status");
                        String materialNumber = entry.getString("material.number");
                        if (!"C".equals(materialStatus) || !"1".equals(materialEnable)) {
                            this.addErrorMessage(rowDataEntity, String.format(ResManager.loadKDString((String)"\u7269\u6599\u7f16\u7801'%s'\u975e\u5ba1\u6838\u4e14\u53ef\u7528\u3002", (String)"MultiPlanDataValidator_2", (String)"mmc-mds-opplugin", (Object[])new Object[0]), materialNumber));
                        }
                        for (int i = 1; i <= 150; ++i) {
                            BigDecimal bigDecimal = entry.getBigDecimal("qty" + i);
                            String bigDecimalStr = entry.getString("qty" + i);
                            if (bigDecimal == null || BigDecimal.ZERO.compareTo(bigDecimal) <= 0) continue;
                            this.addErrorMessage(rowDataEntity, String.format(ResManager.loadKDString((String)"'%s'\u683c\u5f0f\u6709\u8bef\u3002", (String)"MultiPlanDataValidator_3", (String)"mmc-mds-opplugin", (Object[])new Object[0]), bigDecimalStr));
                        }
                    }
                }
                if ((falseData = this.getFalseDataEntities()).contains(rowDataEntity)) continue;
                StringBuilder msg = new StringBuilder();
                Object plandataId = FCPlanDataHelper.createPlanData((DynamicObject)dynamicObject, (StringBuilder)msg);
                if (plandataId == null) {
                    this.addErrorMessage(rowDataEntity, msg.toString());
                    continue;
                }
                DynamicObjectCollection dateentity = dynamicObject.getDynamicObjectCollection("dateentity");
                dateentity.clear();
                dynamicObject.set("dateentity", (Object)dateentity);
                DynamicObject mds_plandata = BusinessDataServiceHelper.loadSingleFromCache((Object)plandataId, (String)"mds_plandata");
                if (mds_plandata != null) {
                    dynamicObject.set("org", mds_plandata.get("org"));
                }
                for (DynamicObject entry : entryentity) {
                    entry.set("parentid", plandataId);
                }
            }
            finally {
                dLock.unlock();
            }
        }
    }

    private void checkDateOverflow(ExtendedDataEntity rowDataEntity) {
        String dateStr;
        Date date;
        DynamicObject dynamicObject = rowDataEntity.getDataEntity();
        HashSet<String> allDataStr = new HashSet<String>(256);
        if (dynamicObject == null) {
            return;
        }
        DynamicObject version = dynamicObject.getDynamicObject("fcvrnnum");
        if (version == null) {
            return;
        }
        QFilter filter = new QFilter("fcvrnnum", "=", version.getPkValue());
        DynamicObject mds_plandata = BusinessDataServiceHelper.loadSingle((String)"mds_plandata", (String)"id", (QFilter[])new QFilter[]{filter});
        if (mds_plandata == null) {
            return;
        }
        DynamicObject mds_plandataObj = BusinessDataServiceHelper.loadSingle((Object)mds_plandata.getPkValue(), (String)"mds_plandata");
        DynamicObjectCollection childDateentity = dynamicObject.getDynamicObjectCollection("dateentity");
        DynamicObjectCollection parentDateentity = mds_plandataObj.getDynamicObjectCollection("dateentity");
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        for (DynamicObject entity : parentDateentity) {
            date = entity.getDate("targetdate");
            dateStr = sdf.format(date);
            allDataStr.add(dateStr);
        }
        for (DynamicObject entity : childDateentity) {
            date = entity.getDate("targetdate");
            dateStr = sdf.format(date);
            allDataStr.add(dateStr);
        }
        if (allDataStr.size() > 150) {
            String verNum = version.getString("number");
            this.addErrorMessage(rowDataEntity, String.format(ResManager.loadKDString((String)"\u7248\u672c\u7f16\u7801'%s'\u65f6\u95f4\u5217\u8d85\u957f\uff0c\u8bf7\u51cf\u5c11%d\u4e2a\u5468\u671f\u3002", (String)"MultiPlanDataValidator_4", (String)"mmc-mds-opplugin", (Object[])new Object[0]), verNum, allDataStr.size() - 150));
        }
    }

    static {
        vrdsRelPlan.put("mds_forecastplandata", "0");
        vrdsRelPlan.put("mds_mdsplandata", "1");
        vrdsRelPlan.put("mds_dpsplandata", "2");
        vertypeMap.put("0", "Forecast");
        vertypeMap.put("1", "MDS");
        vertypeMap.put("2", "DPS");
    }
}

