/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mds.opplugin.validator;

import java.util.LinkedList;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.mmc.mds.common.plandata.FCPlanDataHelper;

public class PlanDataPlanScopeValidator
extends AbstractValidator {
    public void validate() {
        for (ExtendedDataEntity rowDataEntity : this.getDataEntities()) {
            DynamicObjectCollection entryentity;
            DynamicObject dynamicObject = rowDataEntity.getDataEntity();
            if (dynamicObject == null || (entryentity = dynamicObject.getDynamicObjectCollection("entryentity")) == null) continue;
            for (DynamicObject entry : entryentity) {
                List planScopeIds;
                long materialId = entry.getLong("material.id");
                long prodorgId = entry.getLong("prodorg.id");
                long planscopeId = entry.getLong("planscope.id");
                if (planscopeId <= 0L || materialId <= 0L || prodorgId <= 0L || (planScopeIds = FCPlanDataHelper.getPlanScopeIds((long)prodorgId, (long)materialId)).contains(planscopeId)) continue;
                String materialNumber = entry.getString("material.number");
                String prodorgName = entry.getString("prodorg.name");
                String planscopeName = entry.getString("planscope.name");
                this.addErrorMessage(rowDataEntity, String.format(ResManager.loadKDString((String)"\u7269\u6599\u7f16\u7801'%1$s',\u4f9b\u5e94\u7ec4\u7ec7'%2$s'\u4e0d\u5b58\u5728\u8ba1\u5212\u8303\u56f4'%3$s'\u3002", (String)"PlanDataPlanScopeValidator_0", (String)"mmc-mds-opplugin", (Object[])new Object[0]), materialNumber, prodorgName, planscopeName));
            }
        }
        ExtendedDataEntity[] entitys = this.getDataEntities();
        this.checkPlanScope(entitys);
    }

    private void checkPlanScope(ExtendedDataEntity[] entitys) {
        for (ExtendedDataEntity entity : entitys) {
            DynamicObject dataEntity = entity.getDataEntity();
            DynamicObjectCollection entryentity = dataEntity.getDynamicObjectCollection("entryentity");
            for (DynamicObject dynamicObject : entryentity) {
                long planscopeLong = dynamicObject.getLong("planscope.id");
                long materialLong = dynamicObject.getLong("material.id");
                long prodorgLong = dynamicObject.getLong("prodorg.id");
                LinkedList<Long> result = new LinkedList<Long>();
                QFilter filter = new QFilter("material", "=", (Object)materialLong);
                filter.and("createorg", "=", (Object)prodorgLong);
                filter.and("enable", "=", (Object)"1");
                filter.and("status", "=", (Object)"C");
                filter.and("entrymatplanscop.start_useing", "=", (Object)"1");
                try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"FCPlanDataHelper:getPlanScopeIds", (String)"msplan_matplanscop", (String)"entrymatplanscop.planscope", (QFilter[])new QFilter[]{filter}, null);){
                    if (dataSet != null) {
                        for (Row row : dataSet) {
                            result.add(row.getLong("entrymatplanscop.planscope"));
                        }
                    }
                }
                QFilter filter2 = new QFilter("createorg", "=", (Object)prodorgLong);
                filter2.and("enable", "=", (Object)"1");
                filter2.and("status", "=", (Object)"C");
                filter2.and("type", "=", (Object)"A");
                DynamicObject planscope = QueryServiceHelper.queryOne((String)"msplan_planscope", (String)"id", (QFilter[])new QFilter[]{filter2});
                Long defaultPlanScopeId = 0L;
                if (planscope != null) {
                    defaultPlanScopeId = planscope.getLong("id");
                }
                if (defaultPlanScopeId != null) {
                    result.add(defaultPlanScopeId);
                }
                if (planscopeLong <= 0L || result.contains(planscopeLong)) continue;
                String e = ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u201c\u4f9b\u5e94\u7ec4\u7ec7\u201d\u4e0b\u5df2\u542f\u7528\u7684\u201c\u8ba1\u5212\u8303\u56f4\u201d\u3002", (String)"PlanDataPlanScopeValidator_1", (String)"mmc-mds-opplugin", (Object[])new Object[0]);
                this.addErrorMessage(entity, e);
            }
        }
    }
}

