/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mds.opplugin.validator;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;

public class PlandataSetEnableValidator
extends AbstractValidator {
    public void validate() {
        ArrayList<String> numberList = new ArrayList<String>(16);
        for (ExtendedDataEntity rowDataEntity : this.getDataEntities()) {
            DynamicObject dynamicObject = rowDataEntity.getDataEntity();
            if (dynamicObject == null) continue;
            numberList.add(dynamicObject.getString("number"));
        }
        QFilter filter = new QFilter("number", "in", numberList);
        filter.and("enable", "=", (Object)"1");
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)"PlandataSetEnableValidator", (String)"mds_plandatafieldset", (String)"number,enable", (QFilter[])new QFilter[]{filter}, null);
        ArrayList<String> hasEnableNumberList = new ArrayList<String>(16);
        for (Row row : dataSet) {
            hasEnableNumberList.add(row.getString("number"));
        }
        Map<String, List<String>> group = numberList.stream().collect(Collectors.groupingBy(String::toString));
        for (ExtendedDataEntity rowDataEntity : this.getDataEntities()) {
            DynamicObject dynamicObject = rowDataEntity.getDataEntity();
            if (dynamicObject == null) continue;
            String number = dynamicObject.getString("number");
            List<String> numberGroup = group.get(number);
            if (numberGroup != null && numberGroup.size() > 1) {
                this.addErrorMessage(rowDataEntity, ResManager.loadKDString((String)"\u8be5\u7f16\u7801\u5728\u64cd\u4f5c\u4e2d\u91cd\u590d\u3002", (String)"PlandataSetEnableValidator_0", (String)"mmc-mds-opplugin", (Object[])new Object[0]));
            }
            if (!hasEnableNumberList.contains(number)) continue;
            this.addErrorMessage(rowDataEntity, ResManager.loadKDString((String)"\u8be5\u7f16\u7801\u5b58\u5728\u5df2\u542f\u7528\u7684\u6570\u636e\u3002", (String)"PlandataSetEnableValidator_1", (String)"mmc-mds-opplugin", (Object[])new Object[0]));
        }
    }
}

