/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mds.opplugin.validator;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.mmc.mds.common.productfamily.ProductFamilyCommons;

public class ProductFamilyValidator
extends AbstractValidator {
    public void validate() {
        for (ExtendedDataEntity rowDataEntity : this.getDataEntities()) {
            String number;
            DynamicObject dynamicObject = rowDataEntity.getDataEntity();
            if (dynamicObject == null) continue;
            DynamicObject materielitem = dynamicObject.getDynamicObject("materielitem");
            DynamicObject materielpbom = dynamicObject.getDynamicObject("materielpbom");
            String bomtype = dynamicObject.getString("bomtype");
            String pbomnameedit = dynamicObject.getString("pbomnameedit");
            Object pkValue = dynamicObject.getPkValue();
            DynamicObject materialPlan = ProductFamilyValidator.getMaterialPlan(materielitem);
            if (StringUtils.isNotEmpty((String)bomtype)) {
                String materialStatus;
                String materialEnable;
                String number2;
                Object materielitemId;
                Object materielpbomId;
                if (materielpbom != null && materielitem != null && "MBOM".equals(bomtype)) {
                    materielpbomId = materielpbom.getPkValue();
                    materielitemId = materielitem.getPkValue();
                    if (materielpbomId != null && materielpbomId.equals(materielitemId)) {
                        this.addErrorMessage(rowDataEntity, ResManager.loadKDString((String)"BOM\u7c7b\u578b\u4e3a\u5236\u9020BOM\u65f6\uff0c\u7269\u6599\u7f16\u7801\u4e0e\u8ba1\u5212BOM\u7269\u6599\u7f16\u7801\u4e0d\u53ef\u76f8\u540c\u3002", (String)"ProductFamilyValidator_0", (String)"mmc-mds-opplugin", (Object[])new Object[0]));
                    }
                }
                if (materielpbom == null) {
                    this.addErrorMessage(rowDataEntity, ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u8ba1\u5212BOM\u3002", (String)"ProductFamilyValidator_1", (String)"mmc-mds-opplugin", (Object[])new Object[0]));
                }
                if (materielpbom != null && materielitem != null && "PBOM".equals(bomtype)) {
                    materielpbomId = materielpbom.getPkValue();
                    materielitemId = materielitem.getPkValue();
                    if (materielpbomId != null && !materielpbomId.equals(materielitemId)) {
                        this.addErrorMessage(rowDataEntity, ResManager.loadKDString((String)"BOM\u7c7b\u578b\u4e3a\u8ba1\u5212BOM\u65f6\uff0c\u7269\u6599\u7f16\u7801\u4e0e\u8ba1\u5212BOM\u7269\u6599\u7f16\u7801\u5fc5\u987b\u76f8\u540c\u3002", (String)"ProductFamilyValidator_2", (String)"mmc-mds-opplugin", (Object[])new Object[0]));
                    }
                }
                if (!ProductFamilyCommons.checkPbomnameEditOnly((DynamicObject)dynamicObject, (String)pbomnameedit)) {
                    this.addErrorMessage(rowDataEntity, String.format(ResManager.loadKDString((String)"\u8ba1\u5212BOM\u540d\u79f0'%s'\u4e0d\u552f\u4e00\u3002", (String)"ProductFamilyValidator_3", (String)"mmc-mds-opplugin", (Object[])new Object[0]), pbomnameedit));
                }
                if (materielpbom != null) {
                    materielpbomId = materielpbom.getPkValue();
                    number2 = materielpbom.getString("number");
                    if (!this.checkPbom(materielpbomId, pkValue)) {
                        this.addErrorMessage(rowDataEntity, String.format(ResManager.loadKDString((String)"\u7269\u6599\u7f16\u7801'%s'\u7c7b\u578b\u4e3a\u5236\u9020BOM\uff0c\u4e0d\u80fd\u4f5c\u4e3a\u8ba1\u5212BOM\u3002", (String)"ProductFamilyValidator_4", (String)"mmc-mds-opplugin", (Object[])new Object[0]), number2));
                    }
                    materialEnable = materielpbom.getString("enable");
                    materialStatus = materielpbom.getString("status");
                    if (!"C".equals(materialStatus) || !"1".equals(materialEnable)) {
                        this.addErrorMessage(rowDataEntity, String.format(ResManager.loadKDString((String)"\u7269\u6599\u7f16\u7801'%s'\u975e\u5ba1\u6838\u4e14\u53ef\u7528\u3002", (String)"ProductFamilyValidator_5", (String)"mmc-mds-opplugin", (Object[])new Object[0]), number2));
                    }
                    if ("MBOM".equals(bomtype) && !this.checkContainsPbom(materielpbomId)) {
                        this.addErrorMessage(rowDataEntity, String.format(ResManager.loadKDString((String)"\u7269\u6599\u7f16\u7801'%s'\u672a\u7ef4\u62a4\u8ba1\u5212BOM\u7f16\u7801\uff0c\u8bf7\u5148\u7ef4\u62a4\u3002", (String)"ProductFamilyValidator_6", (String)"mmc-mds-opplugin", (Object[])new Object[0]), number2));
                    }
                }
                if (materielitem != null) {
                    Object materielitemId2 = materielitem.getPkValue();
                    number2 = materielitem.getString("number");
                    if (!this.checkMbom(materielitemId2, pkValue) && "MBOM".equals(bomtype)) {
                        this.addErrorMessage(rowDataEntity, String.format(ResManager.loadKDString((String)"\u7269\u6599\u7f16\u7801'%s'\u7c7b\u578b\u4e3a\u8ba1\u5212BOM\uff0c\u4e0d\u80fd\u4f5c\u4e3a\u5236\u9020BOM\u3002", (String)"ProductFamilyValidator_7", (String)"mmc-mds-opplugin", (Object[])new Object[0]), number2));
                    }
                    materialEnable = materielitem.getString("enable");
                    materialStatus = materielitem.getString("status");
                    if (!"C".equals(materialStatus) || !"1".equals(materialEnable)) {
                        this.addErrorMessage(rowDataEntity, String.format(ResManager.loadKDString((String)"\u7269\u6599\u7f16\u7801'%s'\u975e\u5ba1\u6838\u4e14\u53ef\u7528\u3002", (String)"ProductFamilyValidator_5", (String)"mmc-mds-opplugin", (Object[])new Object[0]), number2));
                    }
                }
                if (materielitem == null) continue;
                number = materielitem.getString("number");
                if (materialPlan != null) continue;
                this.addErrorMessage(rowDataEntity, String.format(ResManager.loadKDString((String)"\u7269\u6599\u7f16\u7801'%s'\u65e0\u7269\u6599\u8ba1\u5212\u4fe1\u606f\uff0c\u8bf7\u5148\u7ef4\u62a4\u3002", (String)"ProductFamilyValidator_8", (String)"mmc-mds-opplugin", (Object[])new Object[0]), number));
                continue;
            }
            dynamicObject.set("materielpbom", null);
            dynamicObject.set("pbomnameedit", null);
            if (materielitem == null) continue;
            number = materielitem.getString("number");
            String materialEnable = materielitem.getString("enable");
            String materialStatus = materielitem.getString("status");
            Object materielitemId = materielitem.getPkValue();
            if (!"C".equals(materialStatus) || !"1".equals(materialEnable)) {
                this.addErrorMessage(rowDataEntity, String.format(ResManager.loadKDString((String)"\u7269\u6599\u7f16\u7801'%s'\u975e\u5ba1\u6838\u4e14\u53ef\u7528\u3002", (String)"ProductFamilyValidator_5", (String)"mmc-mds-opplugin", (Object[])new Object[0]), number));
            }
            if (this.checkMbom(materielitemId, pkValue)) continue;
            this.addErrorMessage(rowDataEntity, String.format(ResManager.loadKDString((String)"\u7269\u6599\u7f16\u7801'%s'\u8be5\u8ba1\u5212BOM\u5df2\u88ab\u5f15\u7528\uff0c\u4e0d\u80fd\u4fee\u6539\u3002", (String)"ProductFamilyValidator_9", (String)"mmc-mds-opplugin", (Object[])new Object[0]), number));
        }
    }

    private boolean checkContainsPbom(Object id) {
        QFilter filter = new QFilter("materielitem", "=", id).and("bomtype", "=", (Object)"PBOM");
        DynamicObjectCollection materialplan = QueryServiceHelper.query((String)"mds_productfamily", (String)"id", (QFilter[])new QFilter[]{filter});
        return materialplan != null && !materialplan.isEmpty();
    }

    private boolean checkPbom(Object id, Object pkValue) {
        QFilter filter = new QFilter("materielitem", "=", id).and("bomtype", "=", (Object)"MBOM").and("id", "!=", pkValue);
        DynamicObjectCollection materialplan = QueryServiceHelper.query((String)"mds_productfamily", (String)"id", (QFilter[])new QFilter[]{filter});
        return materialplan == null || materialplan.isEmpty();
    }

    private boolean checkMbom(Object id, Object pkValue) {
        QFilter filter = new QFilter("materielpbom", "=", id).and("id", "!=", pkValue);
        DynamicObjectCollection materialplan = QueryServiceHelper.query((String)"mds_productfamily", (String)"id", (QFilter[])new QFilter[]{filter});
        return materialplan == null || materialplan.isEmpty();
    }

    public static DynamicObject getMaterialPlan(Object materielitem) {
        DynamicObject result = null;
        if (materielitem instanceof DynamicObject) {
            DynamicObject materialplan;
            Object pkValue = ((DynamicObject)materielitem).getPkValue();
            if (pkValue == null) {
                pkValue = ((DynamicObject)materielitem).getLong("id");
            }
            QFilter filter = new QFilter("masterid", "=", pkValue);
            result = materialplan = BusinessDataServiceHelper.loadSingle((String)"mpdm_materialplan", (String)"id", (QFilter[])new QFilter[]{filter});
        }
        return result;
    }
}

