/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mds.opplugin.validator;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;

public class PurQuotaAllocateListValidator
extends AbstractValidator {
    private static final String CO_CREATEORG = "createorg";
    private static final String BILL_ENTRY = "entryentity";
    private static final String CO_QUOTAMOD = "quotamod";
    private static final String CO_MATERIAL = "material";
    private static final String CO_STATUS = "status";
    private static final String CO_ENABLE = "enable";
    private static final String CO_EFFECTDATE = "effectdate";
    private static final String CO_LOSEDATE = "losedate";
    private static final String CO_ALLOCATEORG = "allocateorg";
    private static final String CO_KEY_QUOTADATA = "mds_quotadata";
    private static final String CO_SAVE = "save";
    private static final String CO_SUBMIT = "submit";
    private SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void validate() {
        ExtendedDataEntity[] entendsentitys;
        String operatekey = this.getOperateKey();
        if (CO_ENABLE.equals(operatekey) || CO_SUBMIT.equals(operatekey)) {
            entendsentitys = this.getDataEntities();
            ArrayList<DynamicObject> valList = new ArrayList<DynamicObject>(entendsentitys.length);
            ExtendedDataEntity[] extendedDataEntityArray = entendsentitys;
            int n = extendedDataEntityArray.length;
            for (int i = 0; i < n; ++i) {
                Date loseDate;
                Date effectDate;
                DynamicObject material;
                ExtendedDataEntity obj = extendedDataEntityArray[i];
                if (!this.allEntiesCorrect(obj)) {
                    this.addErrorMessage(obj, ResManager.loadKDString((String)"\u8be5\u7269\u6599\u5b9a\u989d\u7684\u5206\u914d\u6bd4\u4f8b\u4e4b\u548c\u4e0d\u4e3a100\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"PurQuotaAllocateListValidator_0", (String)"mmc-mds-opplugin", (Object[])new Object[0]));
                }
                DynamicObject dobj = obj.getDataEntity();
                if (CO_ENABLE.equals(operatekey) && "1".equals(dobj.getString(CO_ENABLE)) || CO_SUBMIT.equals(operatekey) && !"A".equals(dobj.getString(CO_STATUS))) continue;
                DynamicObject useorg = dobj.getDynamicObject(CO_CREATEORG);
                if (!this.uniqueOrgMaterial(useorg, material = dobj.getDynamicObject(CO_MATERIAL), effectDate = dobj.getDate(CO_EFFECTDATE), loseDate = dobj.getDate(CO_LOSEDATE))) {
                    SimpleDateFormat simpleDateFormat = this.sdf;
                    synchronized (simpleDateFormat) {
                        String effectDate2 = this.sdf.format(effectDate);
                        String loseDate2 = this.sdf.format(loseDate);
                        this.addErrorMessage(obj, String.format(ResManager.loadKDString((String)"\u7269\u6599\u201c%1$s\u201d\u5728\u751f\u6548\u65e5\u671f%2$s\u548c\u5931\u6548\u65e5\u671f%3$s\u4e4b\u95f4\uff0c\u5df2\u7ecf\u5b9a\u4e49\u4e86\u914d\u989d\u3002", (String)"PurQuotaAllocateListValidator_5", (String)"mmc-mds-opplugin", (Object[])new Object[0]), material.getString("name"), effectDate2, loseDate2));
                        continue;
                    }
                }
                this.valRepeat(valList, obj);
            }
        }
        if (CO_SUBMIT.equals(operatekey) || CO_SAVE.equals(operatekey)) {
            for (ExtendedDataEntity obj : entendsentitys = this.getDataEntities()) {
                DynamicObject dynamicObject = obj.getDataEntity();
                if (dynamicObject == null) {
                    this.addErrorMessage(obj, ResManager.loadKDString((String)"\u8be5\u914d\u989d\u6570\u636e\u5df2\u5220\u9664\u3002", (String)"PurQuotaAllocateListValidator_2", (String)"mmc-mds-opplugin", (Object[])new Object[0]));
                    return;
                }
                DynamicObject material = dynamicObject.getDynamicObject(CO_MATERIAL);
                if (material == null) {
                    this.addErrorMessage(obj, ResManager.loadKDString((String)"\u8be5\u914d\u989d\u6570\u636e\u7269\u6599\u672a\u627e\u5230\u3002", (String)"PurQuotaAllocateListValidator_3", (String)"mmc-mds-opplugin", (Object[])new Object[0]));
                    return;
                }
                DynamicObjectCollection entryEntity = dynamicObject.getDynamicObjectCollection(BILL_ENTRY);
                HashMap<Object, Object> orgMap = new HashMap<Object, Object>();
                for (DynamicObject o : entryEntity) {
                    DynamicObject org = o.getDynamicObject(CO_ALLOCATEORG);
                    if (org == null) continue;
                    if (orgMap.containsKey(org.getPkValue())) {
                        this.addErrorMessage(obj, String.format(ResManager.loadKDString((String)"\u7269\u6599\u201c%1$s\u201d\u5728\u5206\u5f55\u4e2d\u4f9b\u5e94\u7ec4\u7ec7\u201c%2$s\u201d\u8bbe\u7f6e\u91cd\u590d\u3002", (String)"PurQuotaAllocateListValidator_6", (String)"mmc-mds-opplugin", (Object[])new Object[0]), material.getString("name"), org.getString("name")));
                        return;
                    }
                    orgMap.put(org.getPkValue(), org.getPkValue());
                }
            }
        }
    }

    private boolean uniqueOrgMaterial(DynamicObject useorg, DynamicObject material, Date effectDate, Date loseDate) {
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        filters.add(new QFilter(CO_MATERIAL, "=", material == null ? Integer.valueOf(0) : material.getPkValue()));
        filters.add(new QFilter(CO_STATUS, "=", (Object)"C").or(new QFilter(CO_STATUS, "=", (Object)"B")));
        filters.add(new QFilter(CO_ENABLE, "=", (Object)"1"));
        DynamicObjectCollection query = QueryServiceHelper.query((String)CO_KEY_QUOTADATA, (String)"effectDate,loseDate", (QFilter[])filters.toArray(new QFilter[0]));
        if (query == null || query.isEmpty()) {
            return true;
        }
        for (DynamicObject obj : query) {
            Date effectDate2 = obj.getDate(CO_EFFECTDATE);
            Date loseDate2 = obj.getDate(CO_LOSEDATE);
            if (effectDate.compareTo(loseDate2) > 0 || loseDate.compareTo(effectDate2) < 0) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void valRepeat(List<DynamicObject> valList, ExtendedDataEntity edata) {
        DynamicObject dobj = edata.getDataEntity();
        DynamicObject material = dobj.getDynamicObject(CO_MATERIAL);
        Date effectDate = dobj.getDate(CO_EFFECTDATE);
        Date loseDate = dobj.getDate(CO_LOSEDATE);
        for (DynamicObject obj : valList) {
            DynamicObject valMaterial = obj.getDynamicObject(CO_MATERIAL);
            if (!valMaterial.getPkValue().equals(material.getPkValue())) continue;
            Date valEffectDate = obj.getDate("effectDate");
            Date valLoseDate = obj.getDate("loseDate");
            if (effectDate.compareTo(valLoseDate) > 0 || loseDate.compareTo(valEffectDate) < 0) continue;
            SimpleDateFormat simpleDateFormat = this.sdf;
            synchronized (simpleDateFormat) {
                String edate = this.sdf.format(valEffectDate);
                String ldate = this.sdf.format(valLoseDate);
                this.addErrorMessage(edata, String.format(ResManager.loadKDString((String)"\u7269\u6599\u201c%1$s\u201d\u5728\u751f\u6548\u65e5\u671f%2$s\u548c\u5931\u6548\u65e5\u671f%3$s\u4e4b\u95f4\uff0c\u5df2\u7ecf\u5b9a\u4e49\u4e86\u914d\u989d\u3002", (String)"PurQuotaAllocateListValidator_5", (String)"mmc-mds-opplugin", (Object[])new Object[0]), material.getString("name"), edate, ldate));
            }
            return;
        }
        valList.add(dobj);
    }

    private boolean allEntiesCorrect(ExtendedDataEntity entity) {
        DynamicObject dynamicObject = entity.getDataEntity();
        if (dynamicObject == null) {
            return true;
        }
        DynamicObjectCollection dynamicObjects = dynamicObject.getDynamicObjectCollection(BILL_ENTRY);
        BigDecimal sum = new BigDecimal("0.00");
        BigDecimal zero = new BigDecimal("0.00");
        for (DynamicObject child : dynamicObjects) {
            BigDecimal d = child.getBigDecimal(CO_QUOTAMOD) == null ? zero : child.getBigDecimal(CO_QUOTAMOD);
            sum = sum.add(d);
        }
        if (sum.subtract(new BigDecimal("100.00")).compareTo(zero) > 0) {
            return false;
        }
        BigInteger sum1 = sum.toBigInteger();
        return sum1.intValue() == 100 ? Boolean.TRUE : Boolean.FALSE;
    }
}

