/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mds.opplugin.validator;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Objects;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.login.actions.SerializationUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;

public class SafetyStockSubmitEnableValidator
extends AbstractValidator {
    private String errortypeFix = ResManager.loadKDString((String)"\u7269\u6599\u5df2\u5b58\u5728\u5b89\u5168\u5e93\u5b58\u8bbe\u7f6e\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"SafetyStockSubmitEnableValidator_0", (String)"mmc-mds-opplugin", (Object[])new Object[0]);
    private String errortypeDynamic = ResManager.loadKDString((String)"\u7269\u6599\u8bbe\u7f6e\u7684\u5b89\u5168\u5e93\u5b58\u6709\u6548\u65f6\u95f4\u6bb5\u91cd\u53e0\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"SafetyStockSubmitEnableValidator_1", (String)"mmc-mds-opplugin", (Object[])new Object[0]);
    private String selectField = "id,saftytype,material.id,effecttime,loseeffecttime,status,enable,ctrlstrategy,createorg.id,auxpty.value,planscope.id";

    public void validate() {
        ExtendedDataEntity[] entitys = this.getDataEntities();
        this.checkPlanScope(entitys);
        String operatekey = this.getOperateKey();
        HashSet<Long> materialIds = new HashSet<Long>(16);
        for (ExtendedDataEntity entity : entitys) {
            materialIds.add(entity.getDataEntity().getLong("material.id"));
        }
        QFilter filter = new QFilter("material.id", "in", materialIds);
        filter.and("status", "in", (Object)new Object[]{"B", "C"});
        filter.and("enable", "=", (Object)"1");
        QFilter[] filters = new QFilter[]{filter};
        DynamicObjectCollection dbobjs = QueryServiceHelper.query((String)"mds_safetystock", (String)this.selectField, (QFilter[])filters);
        this.analyseSafetyStockEffect(operatekey, entitys, dbobjs);
    }

    private void checkPlanScope(ExtendedDataEntity[] entitys) {
        for (ExtendedDataEntity entity : entitys) {
            DynamicObject dataEntity = entity.getDataEntity();
            long planscopeLong = dataEntity.getLong("planscope.id");
            DynamicObject material = dataEntity.getDynamicObject("material");
            long materialLong = material.getLong("id");
            DynamicObject createorg = dataEntity.getDynamicObject("createorg");
            long createorgLong = createorg.getLong("id");
            LinkedList<Long> result = new LinkedList<Long>();
            QFilter filter = new QFilter("material", "=", (Object)materialLong);
            filter.and("createorg", "=", (Object)createorgLong);
            filter.and("enable", "=", (Object)"1");
            filter.and("status", "=", (Object)"C");
            filter.and("entrymatplanscop.start_useing", "=", (Object)"1");
            try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"FCPlanDataHelper:getPlanScopeIds", (String)"msplan_matplanscop", (String)"entrymatplanscop.planscope", (QFilter[])new QFilter[]{filter}, null);){
                if (dataSet != null) {
                    for (Row row : dataSet) {
                        result.add(row.getLong("entrymatplanscop.planscope"));
                    }
                }
            }
            QFilter filter2 = new QFilter("createorg", "=", (Object)createorgLong);
            filter2.and("enable", "=", (Object)"1");
            filter2.and("status", "=", (Object)"C");
            filter2.and("type", "=", (Object)"A");
            DynamicObject planscope = QueryServiceHelper.queryOne((String)"msplan_planscope", (String)"id", (QFilter[])new QFilter[]{filter2});
            Long defaultPlanScopeId = 0L;
            if (planscope != null) {
                defaultPlanScopeId = planscope.getLong("id");
            }
            if (defaultPlanScopeId != null) {
                result.add(defaultPlanScopeId);
            }
            if (planscopeLong <= 0L || result.contains(planscopeLong)) continue;
            String e = ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u201c\u521b\u5efa\u7ec4\u7ec7\u201d\u4e0b\u5df2\u542f\u7528\u7684\u201c\u8ba1\u5212\u8303\u56f4\u201d\u3002", (String)"MatPlanScopRelaValidator_0", (String)"mmc-mds-opplugin", (Object[])new Object[0]);
            this.addErrorMessage(entity, e);
        }
    }

    private void analyseSafetyStockEffect(String operatekey, ExtendedDataEntity[] entitys, DynamicObjectCollection dbobjs) {
        ArrayList<DynamicObject> allObj = new ArrayList<DynamicObject>();
        for (DynamicObject obj : dbobjs) {
            allObj.add(obj);
        }
        for (ExtendedDataEntity entity : entitys) {
            boolean isEffect = true;
            DynamicObject obj = entity.getDataEntity();
            Long materialid = entity.getDataEntity().getLong("material.id");
            String saftytype = entity.getDataEntity().getString("saftytype");
            Date effecttime = entity.getDataEntity().getDate("effecttime");
            Date loseeffecttime = entity.getDataEntity().getDate("loseeffecttime");
            String ctrlstrategy = entity.getDataEntity().getString("ctrlstrategy");
            long createorg = entity.getDataEntity().getLong("createorg.id");
            long planscope = entity.getDataEntity().getLong("planscope.id");
            DynamicObject auxprop = entity.getDataEntity().getDynamicObject("auxpty");
            Object auxpropValueMap = null;
            String newAuxpropJson = null;
            if (auxprop != null) {
                newAuxpropJson = auxprop.getString("value");
            }
            Long id = obj.getLong("id");
            if ("A".equals(saftytype)) {
                for (DynamicObject dbobj : allObj) {
                    String dbCtrlstrategy = dbobj.getString("ctrlstrategy");
                    long dbCreateorg = dbobj.getLong("createorg.id");
                    String dbAuxpropJson = dbobj.getString("auxpty.value");
                    long dbPlanscope = dbobj.getLong("planscope.id");
                    if ("7".equals(ctrlstrategy) && "7".equals(dbCtrlstrategy) && dbCreateorg != createorg || !materialid.equals(dbobj.getLong("material.id")) || id.equals(dbobj.getLong("id")) || !this.isAuxpropEqual(newAuxpropJson, dbAuxpropJson) || planscope != dbPlanscope) continue;
                    isEffect = false;
                    this.addErrorMessage(entity, this.errortypeFix);
                    break;
                }
            } else {
                for (DynamicObject dbobj : allObj) {
                    Long dbmaterialid = dbobj.getLong("material.id");
                    Long dbpk = dbobj.getLong("id");
                    String dbCtrlstrategy = dbobj.getString("ctrlstrategy");
                    long dbCreateorg = dbobj.getLong("createorg.id");
                    String dbAuxpropJson = dbobj.getString("auxpty.value");
                    long dbPlanscope = dbobj.getLong("planscope.id");
                    if ("7".equals(ctrlstrategy) && "7".equals(dbCtrlstrategy) && dbCreateorg != createorg || !materialid.equals(dbmaterialid) || id.compareTo(dbpk) == 0 || !this.isAuxpropEqual(newAuxpropJson, dbAuxpropJson) || planscope != dbPlanscope) continue;
                    if ("A".equals(dbobj.getString("saftytype"))) {
                        isEffect = false;
                        this.addErrorMessage(entity, entity.getDataEntity().getString("material.number") + this.errortypeFix);
                    } else {
                        if (effecttime.compareTo(dbobj.getDate("loseeffecttime")) > 0 || loseeffecttime.compareTo(dbobj.getDate("effecttime")) < 0) continue;
                        isEffect = false;
                        this.addErrorMessage(entity, this.errortypeDynamic);
                    }
                    break;
                }
            }
            if (!isEffect || !"enable".equals(operatekey) && !"submit".equals(operatekey)) continue;
            allObj.add(obj);
        }
    }

    private boolean isAuxpropEqual(String newAuxpropJson, String dbAuxpropJson) {
        if (!Objects.equals(newAuxpropJson, dbAuxpropJson)) {
            return false;
        }
        LinkedHashMap dbAuxpropValueMap = null;
        if (StringUtils.isNotEmpty((String)dbAuxpropJson)) {
            dbAuxpropValueMap = (LinkedHashMap)SerializationUtils.fromJsonString((String)dbAuxpropJson, LinkedHashMap.class);
        }
        LinkedHashMap newAuxpropValueMap = null;
        if (StringUtils.isNotEmpty((String)newAuxpropJson)) {
            newAuxpropValueMap = (LinkedHashMap)SerializationUtils.fromJsonString((String)newAuxpropJson, LinkedHashMap.class);
        }
        return Objects.equals(newAuxpropValueMap, dbAuxpropValueMap);
    }
}

