/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mds.opplugin.validator;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;

public class StockRangeDefEditValidator
extends AbstractValidator {
    private static final String ENTRYENTITY = "entryentity";
    private static final String ISUSE = "isuse";
    private static final String CUSTOMER = "customer";
    private static final String MRTYPE = "mrtype";
    private static final String CHECKTYPE = "checktype";
    private static final String CABINCONFIG = "cabinconfig";
    private static final String SCHDSTATUS = "schdstatus";

    public void validate() {
        String operate = this.getOperateKey();
        if ("save".equals(operate) || "submit".equals(operate)) {
            ExtendedDataEntity[] objs;
            for (ExtendedDataEntity obj : objs = this.getDataEntities()) {
                ArrayList emptyRowList = new ArrayList(16);
                DynamicObject dynamicObject = obj.getDataEntity();
                String number = dynamicObject.getString("number");
                DynamicObjectCollection entryentity = dynamicObject.getDynamicObjectCollection(ENTRYENTITY);
                Map<String, List<String[]>> map = entryentity.stream().map(m -> {
                    StringBuilder sb = new StringBuilder();
                    Long seq = m.getLong("seq");
                    boolean isuse = m.getBoolean(ISUSE);
                    sb.append(isuse);
                    String customers = this.getFieldBaseDataIds((DynamicObject)m, CUSTOMER);
                    sb.append(customers);
                    DynamicObject mrtype = m.getDynamicObject(MRTYPE);
                    if (mrtype != null) {
                        sb.append(mrtype.getPkValue()).append(",");
                    }
                    String checktypes = this.getFieldBaseDataIds((DynamicObject)m, CHECKTYPE);
                    sb.append(checktypes);
                    String cabinconfigs = this.getFieldBaseDataIds((DynamicObject)m, CABINCONFIG);
                    sb.append(cabinconfigs);
                    String schdstatuss = this.getFieldBaseDataIds((DynamicObject)m, SCHDSTATUS);
                    sb.append(schdstatuss);
                    if (StringUtils.isEmpty((CharSequence)customers) && mrtype == null && StringUtils.isEmpty((CharSequence)checktypes) && StringUtils.isEmpty((CharSequence)cabinconfigs) && StringUtils.isEmpty((CharSequence)schdstatuss)) {
                        emptyRowList.add(seq);
                        return null;
                    }
                    return new String[]{sb.toString(), String.valueOf(seq)};
                }).filter(Objects::nonNull).collect(Collectors.groupingBy(m -> m[0]));
                for (List<String[]> value : map.values()) {
                    if (value.size() <= 1) continue;
                    List list = value.stream().map(m -> m[1]).collect(Collectors.toList());
                    this.addErrorMessage(obj, String.format(String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\uff0c\u5907\u8d27\u8303\u56f4\u660e\u7ec6\u91cd\u590d\uff0c\u8bf7\u91cd\u65b0\u7ef4\u62a4\u3002", (String)"StockRangeDefEditValidator_0", (String)"mmc-mds-opplugin", (Object[])new Object[0]), list), number));
                }
                if (emptyRowList.isEmpty()) continue;
                this.addErrorMessage(obj, String.format(String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u5907\u8d27\u8303\u56f4\u660e\u7ec6\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\u3002", (String)"StockRangeDefEditValidator_1", (String)"mmc-mds-opplugin", (Object[])new Object[0]), emptyRowList), number));
            }
        }
    }

    private String getFieldBaseDataIds(DynamicObject dynamicObject, String field) {
        DynamicObjectCollection customers = dynamicObject.getDynamicObjectCollection(field);
        return customers.stream().map(m -> m.getLong("fbasedataid.id")).sorted().map(String::valueOf).collect(Collectors.joining(","));
    }
}

