/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mds.opplugin.validator;

import java.util.Arrays;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;

public class TransformValidator
extends AbstractValidator {
    public void validate() {
        String operate = this.getOperateKey();
        if ("enable".equals(operate) || "submit".equals(operate)) {
            ExtendedDataEntity[] objs = this.getDataEntities();
            Set beforeId = Arrays.stream(objs).map(ExtendedDataEntity::getDataEntity).map(m -> m.getDynamicObject("materielbefore").getPkValue()).collect(Collectors.toSet());
            for (ExtendedDataEntity obj : objs) {
                DynamicObject objDataEntity = obj.getDataEntity();
                DynamicObject materielBefore = objDataEntity.getDynamicObject("materielbefore");
                DynamicObject materielAfter = objDataEntity.getDynamicObject("materielafter");
                QFilter commonFilter = new QFilter("status", "in", Arrays.asList("B", "C"));
                commonFilter.and("enable", "=", (Object)"1");
                QFilter qFilter = new QFilter("materielafter", "=", materielBefore.getPkValue());
                qFilter.or("materielbefore", "=", materielAfter.getPkValue());
                DynamicObject transform = QueryServiceHelper.queryOne((String)"mds_transform", (String)"id,materielbefore.id,materielbefore.number,materielbefore.name,materielafter.id,materielafter.number,materielafter.name", (QFilter[])new QFilter[]{commonFilter, qFilter});
                if (transform != null) {
                    String name = "";
                    if (Objects.equals(transform.getLong("materielbefore.id"), materielAfter.getPkValue())) {
                        name = transform.getString("materielbefore.name");
                    } else if (Objects.equals(transform.getLong("materielafter.id"), materielBefore.getPkValue())) {
                        name = transform.getString("materielafter.name");
                    }
                    this.addErrorMessage(obj, String.format(ResManager.loadKDString((String)"\u7269\u6599%s\u5b58\u5728\u8fde\u7eed\u8f6c\u6362\uff0c\u82e5\u8981\u7ee7\u7eed\u7ef4\u62a4\uff0c\u8bf7\u5148\u4fee\u6539\u6216\u7981\u7528\u539f\u6570\u636e\u3002", (String)"TransformValidator_0", (String)"mmc-mds-opplugin", (Object[])new Object[0]), name));
                    continue;
                }
                if (!beforeId.contains(materielAfter.getPkValue()) || objs.length <= 1) continue;
                this.addErrorMessage(obj, String.format(ResManager.loadKDString((String)"\u7269\u6599%s\u5b58\u5728\u8fde\u7eed\u8f6c\u6362\uff0c\u82e5\u8981\u7ee7\u7eed\u7ef4\u62a4\uff0c\u8bf7\u5148\u4fee\u6539\u6216\u7981\u7528\u539f\u6570\u636e\u3002", (String)"TransformValidator_0", (String)"mmc-mds-opplugin", (Object[])new Object[0]), materielAfter.getString("name")));
            }
        }
    }
}

