/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mps.common.util;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.MainEntityType;
import kd.bos.inte.api.EnabledLang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataService;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.inte.InteServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.util.DynamicObjectSerializeUtil;
import kd.mmc.mps.common.enums.InitContextEnum;
import kd.mmc.mps.consts.InitDataConst;
import org.dom4j.Document;
import org.dom4j.io.SAXReader;

public class MPSInitHelper {
    private static final Log log = LogFactory.getLog(MPSInitHelper.class);
    private static final String MPS_INITDATA = "mps_initdata";
    private static final String algoKey = "MPSInitHelper";
    private static final Map<String, String> cellsdatas = new HashMap<String, String>(2);
    private static final Map<String, String> xmls = new HashMap<String, String>(2);
    private static final Set<String> initializedEntity = new HashSet<String>(2);

    public static void initConfigData(long orgId) {
        QFilter qFilter = new QFilter("org", "=", (Object)orgId);
        ArrayList<DynamicObject> list = new ArrayList<DynamicObject>(5);
        ArrayList<InitContextEnum> values = new ArrayList<InitContextEnum>(Arrays.asList(InitContextEnum.values()));
        DynamicObject[] datas = BusinessDataServiceHelper.load((String)MPS_INITDATA, (String)"inittype", (QFilter[])new QFilter[]{qFilter});
        for (DynamicObject data : datas) {
            InitContextEnum num = InitContextEnum.fromName(data.getLocaleString("inittype"));
            if (num == null) continue;
            values.remove((Object)num);
        }
        for (InitContextEnum num : values) {
            DynamicObject data = BusinessDataServiceHelper.newDynamicObject((String)MPS_INITDATA);
            data.set("org", (Object)orgId);
            data.set("createtime", (Object)new Date());
            data.set("creator", (Object)RequestContext.get().getCurrUserId());
            data.set("initstatus", (Object)"0");
            data.set("inittype", (Object)num.getName());
            data.set("inittext", (Object)num.getValue());
            list.add(data);
        }
        SaveServiceHelper.save((DynamicObject[])list.toArray(new DynamicObject[0]));
    }

    public static synchronized void initMpsData(long useOrgId, List<Long> ids, long calcId, String appId) {
        if (ids.isEmpty()) {
            return;
        }
        if (StringUtils.isBlank((CharSequence)appId)) {
            appId = "mps";
        }
        QFilter qFilter = new QFilter("id", "in", ids);
        ArrayList<InitContextEnum> initEnums = new ArrayList<InitContextEnum>(ids.size());
        DynamicObject[] datas = BusinessDataServiceHelper.load((String)MPS_INITDATA, (String)"id,inittype", (QFilter[])new QFilter[]{qFilter});
        for (DynamicObject data : datas) {
            InitContextEnum initEnum = InitContextEnum.fromName(data.getLocaleString("inittype"));
            if (initEnum == null) continue;
            initEnums.add(initEnum);
        }
        log.info("begin");
        initializedEntity.clear();
        for (InitContextEnum initEnum : initEnums) {
            switch (initEnum) {
                case ResModule: {
                    log.info("ResModule");
                    MPSInitHelper.initData(useOrgId, "mrp_resourceregister_cf", true, appId);
                    MPSInitHelper.clearCache("mrp_resourceregister_cf", useOrgId);
                    MPSInitHelper.clearCache("mrp_billfieldtransfer", useOrgId);
                    break;
                }
                case AlgoModule: {
                    log.info("AlgoModule");
                    MPSInitHelper.initLargeFile();
                    HashSet<String> removes = new HashSet<String>(16);
                    MPSInitHelper.initData(useOrgId, "mrp_businessplan", true, appId);
                    log.info("mrp_businessplan");
                    MPSInitHelper.initData(useOrgId, "mrp_calplanconfig", true, removes, appId);
                    log.info("mrp_calplanconfig");
                    MPSInitHelper.clearCache("mrp_calplanconfig", useOrgId);
                    MPSInitHelper.clearCache("mrp_businessplan", useOrgId);
                    MPSInitHelper.clearCache("mrp_algoregister", useOrgId);
                    break;
                }
            }
        }
        long userId = RequestContext.get().getCurrUserId();
        Timestamp timestamp = new Timestamp(new Date().getTime());
        String updateSql = "update t_mps_initdata set finitstatus = '1',fmodifierid = ?, fmodifytime = ? where fid = ?";
        ArrayList<Object[]> params = new ArrayList<Object[]>(ids.size());
        for (Long id : ids) {
            Object[] p = new Object[3];
            p[2] = id;
            p[0] = userId;
            p[1] = timestamp;
            params.add(p);
        }
        DB.executeBatch((DBRoute)new DBRoute("scm"), (String)updateSql, params);
    }

    private static void initLargeFile() {
        cellsdatas.clear();
        cellsdatas.put("CalcNo", MPSInitHelper.getInitDataCache(InitDataConst.isEn_US() ? "bizCellStr_en" : "bizCellStr", "/init-mpsdata"));
        cellsdatas.put("CalcVehicleStartTime", MPSInitHelper.getInitDataCache(InitDataConst.isEn_US() ? "bizCellStr_en" : "bizCellStr", "/init-mpsdata1"));
        cellsdatas.put("ReportLog_S", MPSInitHelper.getInitDataCache(InitDataConst.isEn_US() ? "bizCellStr_en" : "bizCellStr", "/init-mpsdata2"));
        cellsdatas.put("SchedulePlan_getdata", MPSInitHelper.getInitDataCache(InitDataConst.isEn_US() ? "bizCellStr_en" : "bizCellStr", "/init-mpsdata3"));
        cellsdatas.put("Schedu_plan", MPSInitHelper.getInitDataCache(InitDataConst.isEn_US() ? "bizCellStr_en" : "bizCellStr", "/init-mpsdata4"));
        xmls.clear();
        xmls.put("CalcNo", MPSInitHelper.XmlToString("mpsbizXml"));
        xmls.put("CalcVehicleStartTime", MPSInitHelper.XmlToString("mpsbizXml1"));
        xmls.put("ReportLog_S", MPSInitHelper.XmlToString("mpsbizXml2"));
        xmls.put("SchedulePlan_getdata", MPSInitHelper.XmlToString("mpsbizXml3"));
        xmls.put("Schedu_plan", MPSInitHelper.XmlToString("mpsbizXml4"));
    }

    private static Set<String> getNotInitCalcPlanNumbers(long orgId) {
        HashSet<String> removeNumbers = new HashSet<String>(4);
        QFilter globalFilter = new QFilter("number", "=", (Object)"Schedule_Caculate_S");
        QFilter qFilter = new QFilter("createorg", "=", (Object)orgId);
        qFilter.and(new QFilter("status", "=", (Object)"C"));
        qFilter.and(new QFilter("enable", "=", (Object)"1"));
        if (QueryServiceHelper.exists((String)"mrp_calplanconfig", (QFilter[])new QFilter[]{qFilter, globalFilter})) {
            removeNumbers.add("Schedule_Caculate_S");
        }
        return removeNumbers;
    }

    public static void initData(long orgId, String entity, boolean isReload, String appId) {
        MPSInitHelper.initData(orgId, entity, isReload, new HashSet<String>(16), appId);
    }

    private static void initData(long orgId, String entity, boolean isReload, Set<String> removeNumbers, String appId) {
        if (StringUtils.isBlank((CharSequence)entity)) {
            return;
        }
        String defaultctrlstrategy = MPSInitHelper.getDefaultCtrlStrategy(entity);
        Map<String, Map<String, List<Object>>> initSql = InitDataConst.getSql(entity, orgId, defaultctrlstrategy, cellsdatas, xmls, appId);
        log.info("initSql");
        if (initSql.size() != 0) {
            log.info("initSql.size");
            for (String remKey : initSql.keySet()) {
                if ("7".equals(defaultctrlstrategy) && QueryServiceHelper.exists((String)entity, (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)remKey).and("ctrlstrategy", "=", (Object)"5").and("createorg", "=", (Object)orgId)})) {
                    removeNumbers.add(remKey);
                }
                if (!"5".equals(defaultctrlstrategy)) continue;
                if (QueryServiceHelper.exists((String)entity, (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)remKey).and("ctrlstrategy", "=", (Object)"7").and("createorg", "=", (Object)orgId)})) {
                    removeNumbers.add(remKey);
                }
                if (!QueryServiceHelper.exists((String)entity, (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)remKey).and("ctrlstrategy", "=", (Object)"5").and("createorg", "!=", (Object)orgId)})) continue;
                removeNumbers.add(remKey);
            }
        }
        for (String num : removeNumbers) {
            initSql.remove(num);
        }
        if (initSql.isEmpty()) {
            return;
        }
        DynamicObject org = BusinessDataServiceHelper.loadSingleFromCache((Object)orgId, (String)"bos_org");
        Long userId = RequestContext.get().getCurrUserId();
        DynamicObject user = BusinessDataServiceHelper.loadSingleFromCache((Object)userId, (String)"bos_user");
        HashMap<String, Map<String, List<Object>>> exeSqls = new HashMap<String, Map<String, List<Object>>>(initSql.size());
        boolean isPrivate = StringUtils.equals((CharSequence)defaultctrlstrategy, (CharSequence)"7");
        Map<String, Long> oldPrivateDataId = null;
        if (isReload) {
            if (isPrivate) {
                oldPrivateDataId = MPSInitHelper.getPrivateOldData(entity, initSql.keySet(), orgId);
            }
            exeSqls.putAll(initSql);
        } else {
            for (Map.Entry<String, Map<String, List<Object>>> entry : initSql.entrySet()) {
                QFilter qFilter = new QFilter("number", "=", (Object)entry.getKey());
                if (isPrivate) {
                    qFilter.and(new QFilter("createorg", "=", (Object)orgId));
                }
                if (QueryServiceHelper.exists((String)entity, (QFilter[])new QFilter[]{qFilter})) continue;
                exeSqls.put(entry.getKey(), entry.getValue());
            }
        }
        log.info("entity");
        Map<String, Long> idMap = InitDataConst.getDataIds(entity);
        LinkedHashMap<String, List<Object>> allSqls = new LinkedHashMap<String, List<Object>>();
        for (Map.Entry entry : exeSqls.entrySet()) {
            log.info("exeSqls");
            Long id = idMap.getOrDefault(entry.getKey(), 0L);
            Long oldId = oldPrivateDataId != null ? oldPrivateDataId.get(entry.getKey()) : null;
            MPSInitHelper.insertData(isPrivate, isReload, entity, id, (String)entry.getKey(), (Map)entry.getValue(), org, user, oldId, false, allSqls, appId);
        }
        MPSInitHelper.executeSql(new DBRoute(MPSInitHelper.getDbKey(entity)), allSqls, entity);
    }

    private static void clearCache(String entity, Long useorgId) {
        BaseDataService baseDataService = new BaseDataService();
        baseDataService.clearBaseDataFilterCache(entity, useorgId);
        ArrayList<Long> orgIDList = new ArrayList<Long>(1);
        orgIDList.add(useorgId);
        BaseDataServiceHelper.refreshBaseDataUseRange((String)entity, orgIDList);
    }

    private static Map<String, Long> getPrivateOldData(String entity, Set<String> nums, Long orgId) {
        HashMap<String, Long> oldPrivateDataId = new HashMap<String, Long>(nums.size());
        QFilter qFilter = new QFilter("number", "in", nums);
        qFilter.and(new QFilter("createorg", "=", (Object)orgId));
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)algoKey, (String)entity, (String)"number,id", (QFilter[])new QFilter[]{qFilter}, null);){
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                oldPrivateDataId.put(row.getString("number"), row.getLong("id"));
            }
        }
        return oldPrivateDataId;
    }

    private static Long insertData(boolean isPrivate, boolean isReload, String entity, Long id, String num, Map<String, List<Object>> sql, DynamicObject org, DynamicObject user, Long oldId, boolean execute, Map<String, List<Object>> allSql, String appId) {
        Long result = id;
        if (isPrivate && QueryServiceHelper.exists((String)entity, (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)id)})) {
            result = MPSInitHelper.insertPrivateData(entity, id, num, org, user, oldId, isReload, appId);
        } else if (MPSInitHelper.insertSharedData(entity, id, org, user, isReload, appId)) {
            if (execute) {
                MPSInitHelper.executeSql(new DBRoute(MPSInitHelper.getDbKey(entity)), sql, entity, execute);
            } else {
                for (Map.Entry<String, List<Object>> entry : sql.entrySet()) {
                    List list = allSql.computeIfAbsent(entry.getKey(), k -> new ArrayList(16));
                    list.addAll((Collection)entry.getValue());
                }
            }
        }
        return result;
    }

    private static boolean insertSharedData(String entity, Long id, DynamicObject org, DynamicObject user, boolean isReload, String appId) {
        if (!isReload && QueryServiceHelper.exists((String)entity, (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)id)})) {
            return false;
        }
        switch (entity) {
            case "mrp_calplanconfig": {
                MPSInitHelper.loopInsertValue("mrp_businessplan", "7", org, user, isReload, appId);
                break;
            }
            case "mrp_businessplan": {
                MPSInitHelper.loopInsertValue("mrp_algoregister", "5", org, user, isReload, appId);
                break;
            }
            case "mrp_resourceregister_cf": {
                MPSInitHelper.loopInsertValue("mrp_billfieldtransfer", "5", org, user, isReload, appId);
                break;
            }
            case "mpdm_manustrategy_group": {
                MPSInitHelper.loopInsertValue("mpdm_manustrategy", "5", org, user, isReload, appId);
                break;
            }
        }
        return true;
    }

    private static void executeSql(DBRoute dbRoute, Map<String, List<Object>> sql, String entity) {
        MPSInitHelper.executeSql(dbRoute, sql, entity, false);
    }

    private static void executeSql(DBRoute dbRoute, Map<String, List<Object>> sql, String entity, boolean execute) {
        if (initializedEntity.add(entity) || execute) {
            for (Map.Entry<String, List<Object>> entry : sql.entrySet()) {
                ArrayList<Object[]> list;
                List<Object> value = entry.getValue();
                if (value.size() <= 0) continue;
                if (value.get(0) instanceof Object[]) {
                    list = new ArrayList<Object[]>(16);
                    for (Object object : value) {
                        list.add((Object[])object);
                    }
                    DB.executeBatch((DBRoute)dbRoute, (String)entry.getKey(), list);
                    continue;
                }
                if (!(value.get(0) instanceof List)) continue;
                list = new ArrayList(16);
                for (Object object : value) {
                    for (Object[] objects : (List)object) {
                        list.add(objects);
                    }
                }
                DB.executeBatch((DBRoute)dbRoute, (String)entry.getKey(), list);
            }
        }
    }

    private static void loopInsertValue(String entity, String ctrl, DynamicObject org, DynamicObject user, boolean isReload, String appId) {
        Long orgId = org == null ? 0L : org.getLong("id");
        Map<String, Map<String, List<Object>>> bizSqls = InitDataConst.getSql(entity, orgId, ctrl, cellsdatas, xmls, appId);
        Map<String, Long> bizIds = InitDataConst.getDataIds(entity);
        boolean isPrivate = StringUtils.equals((CharSequence)"7", (CharSequence)ctrl);
        Map<String, Long> oldPrivateDataId = null;
        if (isPrivate) {
            oldPrivateDataId = MPSInitHelper.getPrivateOldData(entity, bizSqls.keySet(), orgId);
        } else {
            if (bizIds.size() != 0) {
                for (String remKey : bizIds.keySet()) {
                    if (!QueryServiceHelper.exists((String)entity, (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)remKey).and("ctrlstrategy", "=", (Object)"5").and("createorg", "!=", (Object)orgId)})) continue;
                    bizSqls.remove(remKey);
                }
            }
            oldPrivateDataId = new HashMap<String, Long>(0);
        }
        LinkedHashMap<String, List<Object>> allSqls = new LinkedHashMap<String, List<Object>>();
        for (Map.Entry<String, Map<String, List<Object>>> entry : bizSqls.entrySet()) {
            MPSInitHelper.insertData(isPrivate, isReload, entity, bizIds.get(entry.getKey()), entry.getKey(), entry.getValue(), org, user, oldPrivateDataId.get(entry.getKey()), false, allSqls, appId);
        }
        MPSInitHelper.executeSql(new DBRoute(MPSInitHelper.getDbKey(entity)), allSqls, entity);
    }

    private static Long insertPrivateData(String entity, Long id, String num, DynamicObject org, DynamicObject user, Long oldId, boolean isReload, String appId) {
        List enabledLangs;
        LocaleString localeString;
        Long newId = 0L;
        if (id == null || id <= 0L) {
            return newId;
        }
        Long orgId = org == null ? 0L : org.getLong("id");
        Long userId = user == null ? 0L : user.getLong("id");
        String base64 = "";
        switch (entity) {
            case "mrp_calplanconfig": {
                base64 = MPSInitHelper.getInitDataCache("calcPlanBase64Cache", MPSInitHelper.getDataFileName4EntityNumber(num));
                break;
            }
            case "mrp_businessplan": {
                base64 = MPSInitHelper.getInitDataCache(InitDataConst.isEn_US() ? "bizBase64Cache_en" : "bizBase64Cache", MPSInitHelper.getDataFileName4EntityNumber(num));
                break;
            }
            default: {
                return newId;
            }
        }
        ORM orm = ORM.create();
        MainEntityType dt = MetadataServiceHelper.getDataEntityType((String)entity);
        Object[] deserialize = DynamicObjectSerializeUtil.deserialize((String)base64, (DynamicObjectType)dt);
        DynamicObject newData = (DynamicObject)OrmUtils.clone((Object)deserialize[0], (IDataEntityType)dt, (boolean)true, (boolean)true);
        boolean isSave = false;
        if (oldId != null && oldId > 0L) {
            newId = oldId;
        } else {
            newId = orm.genLongId((IDataEntityType)dt);
            isSave = true;
        }
        if (StringUtils.equalsIgnoreCase((CharSequence)entity, (CharSequence)"mrp_calplanconfig")) {
            localeString = ResManager.getLocaleString((String)"\u6392\u4ea7\u8fd0\u7b97\u8ba1\u7b97\u65b9\u6848", (String)"InitDataConst_1", (String)"mmc-mps-common");
            enabledLangs = InteServiceHelper.getEnabledLang();
            for (EnabledLang enabledLang : enabledLangs) {
                if (!"en_US".equals(enabledLang.getNumber()) || localeString == null) continue;
                String item = (String)localeString.getItem(enabledLang.getNumber());
                OrmLocaleValue localeValue = (OrmLocaleValue)newData.get("name");
                localeValue.put(enabledLang.getNumber(), item);
            }
            Map<String, Long> bizIds = InitDataConst.getDataIds("mrp_businessplan");
            Map<String, Map<String, List<Object>>> bizSqls = InitDataConst.getSql("mrp_businessplan", orgId, "7", cellsdatas, xmls, appId);
            List<String> bizNumList = MPSInitHelper.getBizNum4CalcNum(num);
            if (bizNumList.size() != 0) {
                int i = 0;
                for (String bizNum : bizNumList) {
                    HashSet<String> bizNums = new HashSet<String>(1);
                    bizNums.add(bizNum);
                    Map<String, Long> oldPrivateDataId = MPSInitHelper.getPrivateOldData("mrp_businessplan", bizNums, orgId);
                    Long bizId = MPSInitHelper.insertData(true, isReload, "mrp_businessplan", bizIds.get(bizNum), bizNum, bizSqls.get(bizNum), org, user, oldPrivateDataId.get(bizNum), true, Collections.emptyMap(), appId);
                    newData.set("fieldtype", (Object)appId);
                    DynamicObjectCollection entryentity = newData.getDynamicObjectCollection("entryentity");
                    if (entryentity.size() < bizNumList.size()) {
                        int resize = bizNumList.size() - entryentity.size();
                        for (int j = 0; j < resize; ++j) {
                            DynamicObject dynamicObject = entryentity.addNew();
                        }
                    } else if (entryentity.size() == bizNumList.size()) {
                        // empty if block
                    }
                    ++i;
                }
            }
        } else if (StringUtils.equalsIgnoreCase((CharSequence)entity, (CharSequence)"mrp_businessplan")) {
            localeString = null;
            if ("CalcNo".equals(newData.getString("number"))) {
                localeString = ResManager.getLocaleString((String)"\u4e0a\u7ebf\u987a\u5e8f\u7801\u8ba1\u7b97", (String)"InitDataConst_2", (String)"mmc-mps-common");
            } else if ("CalcVehicleStartTime".equals(newData.getString("number"))) {
                localeString = ResManager.getLocaleString((String)"\u4e0a\u7ebf\u65f6\u95f4\u8ba1\u7b97", (String)"InitDataConst_3", (String)"mmc-mps-common");
            } else if ("SchedulePlan_getdata".equals(newData.getString("number"))) {
                localeString = ResManager.getLocaleString((String)"\u83b7\u53d6\u4e1a\u52a1\u6570\u636e", (String)"InitDataConst_5", (String)"mmc-mps-common");
            } else if ("Schedu_plan".equals(newData.getString("number"))) {
                localeString = ResManager.getLocaleString((String)"\u6392\u4ea7\u8ba1\u5212", (String)"InitDataConst_6", (String)"mmc-mps-common");
            } else if ("ReportLog_S".equals(newData.getString("number"))) {
                localeString = ResManager.getLocaleString((String)"\u62a5\u8868\u4fe1\u606f\u8bb0\u5f55", (String)"InitDataConst_7", (String)"mmc-mps-common");
            }
            enabledLangs = InteServiceHelper.getEnabledLang();
            for (EnabledLang enabledLang : enabledLangs) {
                if (!"en_US".equals(enabledLang.getNumber()) || localeString == null) continue;
                String item = (String)localeString.getItem(enabledLang.getNumber());
                OrmLocaleValue localeValue = (OrmLocaleValue)newData.get("name");
                localeValue.put(enabledLang.getNumber(), item);
            }
            newData.set("fieldtype", (Object)appId);
            MPSInitHelper.loopInsertValue("mrp_algoregister", "5", org, user, isReload, appId);
        }
        Date nowTime = new Date();
        newData.set("issys", (Object)true);
        newData.set("masterid", (Object)newId);
        newData.set("id", (Object)newId);
        newData.set("createorg_id", (Object)orgId);
        newData.set("org_id", (Object)orgId);
        newData.set("org", (Object)org);
        newData.set("createorg", (Object)org);
        newData.set("ctrlstrategy", (Object)"7");
        newData.set("creator_id", (Object)userId);
        newData.set("modifier_id", (Object)userId);
        newData.set("creator", (Object)user);
        newData.set("modifier", (Object)user);
        newData.set("createtime", (Object)nowTime);
        newData.set("modifytime", (Object)nowTime);
        newData.set("issys", (Object)true);
        if (isReload || isSave) {
            DeleteServiceHelper.delete((String)entity, (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)newId)});
            Object[] objs = SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{newData});
            if (objs.length > 0 && objs[0] instanceof DynamicObject) {
                newId = ((DynamicObject)objs[0]).getLong("id");
            }
        }
        return newId;
    }

    private static List<String> getBizNum4CalcNum(String calcNum) {
        ArrayList<String> calcNumList = new ArrayList<String>(16);
        if (StringUtils.equalsIgnoreCase((CharSequence)calcNum, (CharSequence)"Schedule_Caculate_S")) {
            calcNumList.add("CalcNo");
            calcNumList.add("CalcVehicleStartTime");
            calcNumList.add("ReportLog_S");
            calcNumList.add("SchedulePlan_getdata");
            calcNumList.add("Schedu_plan");
        }
        return calcNumList;
    }

    private static String getDataFileName4EntityNumber(String num) {
        if (StringUtils.equalsIgnoreCase((CharSequence)num, (CharSequence)"CalcNo")) {
            return "/init-mpsdata";
        }
        if (StringUtils.equalsIgnoreCase((CharSequence)num, (CharSequence)"CalcVehicleStartTime")) {
            return "/init-mpsdata1";
        }
        if (StringUtils.equalsIgnoreCase((CharSequence)num, (CharSequence)"ReportLog_S")) {
            return "/init-mpsdata2";
        }
        if (StringUtils.equalsIgnoreCase((CharSequence)num, (CharSequence)"SchedulePlan_getdata")) {
            return "/init-mpsdata3";
        }
        if (StringUtils.equalsIgnoreCase((CharSequence)num, (CharSequence)"Schedu_plan")) {
            return "/init-mpsdata4";
        }
        return "/init-mpsdata";
    }

    private static String getDefaultCtrlStrategy(String entity) {
        String defaultctrlstrategy;
        switch (entity) {
            case "mrp_businessplan": 
            case "mrp_calplanconfig": {
                defaultctrlstrategy = "7";
                break;
            }
            default: {
                defaultctrlstrategy = "5";
            }
        }
        return defaultctrlstrategy;
    }

    private static String getDbKey(String entity) {
        return ORM.create().getDataEntityType(entity).getDBRouteKey();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getInitDataCache(String key, String filePatch) {
        InputStream in = MPSInitHelper.class.getResourceAsStream(filePatch);
        ArrayList<String> strs = new ArrayList<String>(6);
        BufferedReader reader = null;
        try {
            String line;
            reader = new BufferedReader(new InputStreamReader(in, "UTF-8"));
            while ((line = reader.readLine()) != null) {
                strs.add(line);
            }
        }
        catch (Exception e) {
            log.error((Throwable)e);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (Exception e) {
                    log.error((Throwable)e);
                }
            }
        }
        for (int i = 0; i < strs.size() - 1; ++i) {
            if (!StringUtils.equals((CharSequence)key, (CharSequence)((CharSequence)strs.get(i)))) continue;
            return (String)strs.get(i + 1);
        }
        return null;
    }

    private static String XmlToString(String fileName) {
        SAXReader saxReader = new SAXReader();
        String xmlString = "";
        try (InputStream input = MPSInitHelper.class.getResourceAsStream(InitDataConst.isEn_US() ? "/" + fileName + "_en.xml" : "/" + fileName + ".xml");){
            Document document = saxReader.read(input);
            xmlString = document.asXML();
        }
        catch (Exception e) {
            log.error((Throwable)e);
            xmlString = "";
        }
        return xmlString;
    }
}

