/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mps.common.util;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.GroupbyDataSet;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.cache.CacheConfigKeys;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.redis.JedisClient;
import kd.bos.redis.RedisFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.bos.servicehelper.devportal.BizAppServiceHelp;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.mmc.mps.common.model.CapacityRateModel;
import kd.mmc.mps.common.model.ReduOrderModel;
import kd.mmc.mps.consts.schedule.SchedulePlanErrors;

public class MPSScheduleUtils {
    private static final Log logger = LogFactory.getLog(MPSScheduleUtils.class);
    private static final String MPS_PROPLANSCHDEF = "mps_proplanschdef";

    public static BigDecimal getBigDecimalValue(Object value) {
        if (value == null) {
            return BigDecimal.ZERO;
        }
        if (value instanceof BigDecimal) {
            return (BigDecimal)value;
        }
        if (value instanceof Integer) {
            return new BigDecimal((Integer)value);
        }
        if (value instanceof Long) {
            return new BigDecimal((Long)value);
        }
        if (value instanceof Double) {
            return new BigDecimal(value.toString());
        }
        if (value instanceof Float) {
            return new BigDecimal(value.toString());
        }
        if (value instanceof Byte) {
            return new BigDecimal(((Byte)value).byteValue());
        }
        if (value instanceof Short) {
            return new BigDecimal(((Short)value).shortValue());
        }
        return BigDecimal.ZERO;
    }

    public static DynamicObject createNewLog(DynamicObject planprogram, Long orgId, String formName, String menuName) {
        DynamicObject caculateLog = ORM.create().newDynamicObject("mrp_caculate_log");
        Long id = ORM.create().genLongId("mrp_caculate_log");
        caculateLog.set("id", (Object)id);
        String number = CodeRuleServiceHelper.getNumber((String)"mrp_caculate_log", (DynamicObject)caculateLog, (String)orgId.toString());
        caculateLog.set("number", (Object)number);
        caculateLog.set("createorg", (Object)orgId);
        caculateLog.set("useorg", (Object)orgId);
        caculateLog.set("plantype", (Object)"MPS");
        caculateLog.set("plangram", (Object)planprogram.getLong("id"));
        caculateLog.set("programname", (Object)planprogram.getString("name"));
        caculateLog.set("programnumber", (Object)planprogram.getString("number"));
        caculateLog.set("plangramentity", (Object)MPS_PROPLANSCHDEF);
        caculateLog.set("plandate", (Object)new Date());
        caculateLog.set("creator", (Object)RequestContext.get().getUserId());
        caculateLog.set("operatmode", (Object)formName);
        caculateLog.set("operatmodekey", (Object)menuName);
        caculateLog.set("calculatestatus", (Object)"D");
        caculateLog.set("startdate", (Object)new Date());
        caculateLog.set("ctrlstrategy", (Object)"7");
        caculateLog.set("isllc", (Object)Boolean.FALSE);
        caculateLog.set("isbomcheck", (Object)Boolean.FALSE);
        caculateLog.set("isallowdateinpast", (Object)Boolean.FALSE);
        caculateLog.set("iscommon", (Object)Boolean.FALSE);
        caculateLog.set("iscustomize", (Object)Boolean.FALSE);
        caculateLog.set("isselection", (Object)Boolean.FALSE);
        caculateLog.set("isnotsetup", (Object)Boolean.FALSE);
        caculateLog.set("runtype", (Object)"MPS");
        if (number != null) {
            caculateLog.set("number", (Object)id);
        }
        ORM.create().save(caculateLog);
        BaseDataServiceHelper.clearCache((DynamicObject)caculateLog);
        return caculateLog;
    }

    public static Long getLongValue(Object value) {
        if (value == null) {
            return 0L;
        }
        if (value instanceof Integer) {
            Integer result = (Integer)value;
            return result.longValue();
        }
        if (value instanceof String) {
            return Long.parseLong((String)value);
        }
        if (value instanceof BigDecimal) {
            BigDecimal result = (BigDecimal)value;
            return result.longValue();
        }
        return (Long)value;
    }

    public static Date getDateValue(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Date) {
            return (Date)value;
        }
        if (value instanceof Long) {
            return new Date((Long)value);
        }
        return null;
    }

    public static int getIntValue(Object value) {
        if (value == null) {
            return 0;
        }
        if (value instanceof String) {
            if (StringUtils.isBlank((CharSequence)((String)value))) {
                return 0;
            }
            return Integer.parseInt((String)value);
        }
        if (value instanceof BigDecimal) {
            BigDecimal result = (BigDecimal)value;
            return result.intValue();
        }
        if (value instanceof Long) {
            Long result = (Long)value;
            return result.intValue();
        }
        if (value instanceof Byte) {
            Byte result = (Byte)value;
            return result.intValue();
        }
        if (value instanceof Short) {
            Short result = (Short)value;
            return result.intValue();
        }
        if (value instanceof Float) {
            Float result = (Float)value;
            return result.intValue();
        }
        if (value instanceof Double) {
            Double result = (Double)value;
            return result.intValue();
        }
        return (Integer)value;
    }

    public static void writeSchedule(DynamicObject[] successPlan, String sign) {
        HashMap<Long, BigDecimal> scheduIdToNum = new HashMap<Long, BigDecimal>(successPlan.length);
        for (DynamicObject dynamicObject : successPlan) {
            Long scheduId = dynamicObject.getLong("productionid");
            BigDecimal putinqty = dynamicObject.getBigDecimal("scheduleqty");
            if (scheduId == null || scheduId == 0L || putinqty.compareTo(BigDecimal.ZERO) < 0) continue;
            if (scheduIdToNum.containsKey(scheduId)) {
                putinqty = putinqty.add((BigDecimal)scheduIdToNum.get(scheduId));
            }
            scheduIdToNum.put(scheduId, putinqty);
        }
        if (scheduIdToNum.size() != 0) {
            DynamicObject[] load;
            for (DynamicObject dynamicObject : load = BusinessDataServiceHelper.load((String)"mps_scheduledata", (String)"id,plsqty,orderqty,arrangedqty,schedustatus", (QFilter[])new QFilter[]{new QFilter("id", "in", scheduIdToNum.keySet())})) {
                Long id = dynamicObject.getLong("id");
                BigDecimal plsqty = dynamicObject.getBigDecimal("plsqty");
                BigDecimal orderqty = dynamicObject.getBigDecimal("orderqty");
                BigDecimal putinNum = (BigDecimal)scheduIdToNum.get(id);
                if (plsqty == null) {
                    plsqty = BigDecimal.ZERO;
                }
                if (orderqty == null) {
                    orderqty = BigDecimal.ZERO;
                }
                plsqty = "submit".equals(sign) ? plsqty.add(putinNum) : plsqty.subtract(putinNum);
                BigDecimal arrangedqty = orderqty.subtract(plsqty);
                dynamicObject.set("plsqty", (Object)plsqty);
                dynamicObject.set("arrangedqty", (Object)arrangedqty);
                if (plsqty.compareTo(orderqty) >= 0) {
                    dynamicObject.set("schedustatus", (Object)Character.valueOf('B'));
                    continue;
                }
                dynamicObject.set("schedustatus", (Object)Character.valueOf('A'));
            }
            SaveServiceHelper.save((DynamicObject[])load);
        }
    }

    public static Date getLastDayOfMonth(Date date) {
        Calendar instance = Calendar.getInstance();
        date = MPSScheduleUtils.getFirstDayOfMonth(date);
        instance.setTime(date);
        instance.add(2, 1);
        instance.add(5, -1);
        return instance.getTime();
    }

    public static Date getFirstDayOfMonth(Date date) {
        Calendar instance = Calendar.getInstance();
        instance.setTime(date);
        instance.set(5, 1);
        instance.set(11, 0);
        instance.set(12, 0);
        instance.set(13, 0);
        instance.set(14, 0);
        return instance.getTime();
    }

    public static DynamicObject[] getSuccessPlan(List<Object> successPkIds) {
        MainEntityType planorderType = EntityMetadataCache.getDataEntityType((String)"mps_scheduleplan");
        DynamicObject[] successDny = BusinessDataServiceHelper.load((Object[])successPkIds.toArray(), (DynamicObjectType)planorderType);
        return successDny;
    }

    public static Map<String, Integer> getMaxLevelSequence(DynamicObject[] successPlan, List<Long> idList, List<Date> sheduledates, Long workCentreId) {
        ArrayList<Long> workcenterIds = new ArrayList<Long>(8);
        ArrayList<Long> orgIds = new ArrayList<Long>(8);
        ArrayList<Date> sheduledates_query = new ArrayList<Date>(8);
        if (sheduledates != null && sheduledates.size() != 0) {
            sheduledates_query.addAll(sheduledates);
        }
        for (DynamicObject dynamicObject : successPlan) {
            if (workCentreId != null) {
                workcenterIds.add(workCentreId);
            } else {
                Long workcentreId = dynamicObject.getDynamicObject("workcentre").getLong("id");
                workcenterIds.add(workcentreId);
            }
            Long orgId = dynamicObject.getDynamicObject("org").getLong("id");
            Date sheduledate = dynamicObject.getDate("sheduledate");
            orgIds.add(orgId);
            if (sheduledates != null && sheduledates.size() != 0) continue;
            sheduledates_query.add(sheduledate);
        }
        QFilter qFilter_status = new QFilter("billstatus", "=", (Object)"C");
        QFilter qFilter_sequence = new QFilter("entryentity.sequence", "!=", (Object)0);
        QFilter qFilter_workcentreId = new QFilter("workcentre", "in", workcenterIds);
        QFilter qFilter_orgIds = new QFilter("org", "in", orgIds);
        QFilter qFilter_sheduledates = new QFilter("sheduledate", "in", sheduledates_query);
        QFilter qFilter_id = new QFilter("id", "not in", idList);
        DynamicObjectCollection query = QueryServiceHelper.query((String)"mps_scheduleplan", (String)"id,workcentre,org,sheduledate,entryentity.sequence", (QFilter[])new QFilter[]{qFilter_status, qFilter_sequence, qFilter_workcentreId, qFilter_orgIds, qFilter_sheduledates, qFilter_id}, (String)"entryentity.sequence desc");
        HashMap<String, Integer> maxLevel = new HashMap<String, Integer>(8);
        StringBuilder stringBuilder = new StringBuilder();
        for (DynamicObject dynamicObject : query) {
            stringBuilder.setLength(0);
            Long workcentreId = dynamicObject.getLong("workcentre");
            Long orgId = dynamicObject.getLong("org");
            Long sheduledate = dynamicObject.getDate("sheduledate").getTime();
            int sequence = dynamicObject.getInt("entryentity.sequence");
            String key = stringBuilder.append(workcentreId).append(".").append(orgId).append(".").append(sheduledate).toString();
            if (maxLevel.containsKey(key)) {
                Integer level = (Integer)maxLevel.get(key);
                if (level >= sequence) continue;
                maxLevel.put(key, sequence);
                continue;
            }
            maxLevel.put(key, sequence);
        }
        return maxLevel;
    }

    public static void setMaxSeqNoByExitEntry(Map<String, Integer> maxLevelSequence, DynamicObject[] successPlan, boolean isClear, Date changeDate, Long workCentreId) {
        StringBuilder stringBuilder = new StringBuilder();
        for (DynamicObject dynamicObject : successPlan) {
            BigDecimal scheduleqty = dynamicObject.getBigDecimal("scheduleqty");
            stringBuilder.setLength(0);
            Long workcentreId = 0L;
            workcentreId = workCentreId != null ? workCentreId : Long.valueOf(dynamicObject.getDynamicObject("workcentre").getLong("id"));
            Long orgId = dynamicObject.getDynamicObject("org").getLong("id");
            Long sheduledate = changeDate == null ? Long.valueOf(dynamicObject.getDate("sheduledate").getTime()) : Long.valueOf(changeDate.getTime());
            String key = stringBuilder.append(workcentreId).append('.').append(orgId).append('.').append(sheduledate).toString();
            DynamicObjectCollection entryentitys = dynamicObject.getDynamicObjectCollection("entryentity");
            if (isClear) {
                entryentitys.clear();
            }
            if (entryentitys != null && entryentitys.size() != 0) {
                for (DynamicObject entryentity : entryentitys) {
                    Integer maxLevel = maxLevelSequence.get(key);
                    BigDecimal resBigInteger = BigDecimal.ZERO;
                    entryentity.set("ontime", null);
                    entryentity.set("instocktime", null);
                    if (maxLevel != null) {
                        BigDecimal[] resBigIntegers = BigDecimal.valueOf(maxLevel.intValue()).divideAndRemainder(new BigDecimal("100"));
                        resBigInteger = resBigIntegers[0];
                    }
                    int seq = resBigInteger.add(BigDecimal.ONE).intValue() * 100;
                    entryentity.set("sequence", (Object)seq);
                    maxLevelSequence.put(key, seq);
                }
                continue;
            }
            for (int i = 0; i < scheduleqty.intValue(); ++i) {
                Integer maxLevel = maxLevelSequence.get(key);
                stringBuilder.setLength(0);
                String entryNo = dynamicObject.getString("billno");
                StringBuilder serialno = stringBuilder.append(entryNo).append("00").append(i + 1);
                if (maxLevel != null) {
                    BigDecimal[] resBigIntegers = BigDecimal.valueOf(maxLevel.intValue()).divideAndRemainder(new BigDecimal("100"));
                    BigDecimal resBigInteger = resBigIntegers[0];
                    int seq = resBigInteger.add(BigDecimal.ONE).intValue() * 100;
                    DynamicObject entryentity = entryentitys.addNew();
                    entryentity.set("sequence", (Object)seq);
                    entryentity.set("serialno", (Object)serialno.toString());
                    entryentity.set("seq", (Object)(i + 1));
                    maxLevelSequence.put(key, seq);
                    continue;
                }
                DynamicObject entryentity = entryentitys.addNew();
                entryentity.set("sequence", (Object)100);
                entryentity.set("serialno", (Object)serialno.toString());
                entryentity.set("seq", (Object)(i + 1));
                maxLevelSequence.put(key, 100);
            }
        }
    }

    private static long getLongValueByField(Map<String, Object> scheduleOrderMap, String field) {
        Object o = scheduleOrderMap.get(field);
        if (o != null) {
            return Long.parseLong(o.toString());
        }
        return 0L;
    }

    public static void doViewDetailConfig(ListSelectedRowCollection selectedData, IFormView view, String sign) {
        HashSet<Long> idSet = new HashSet<Long>(8);
        HashSet<Long> configurecodeIDSet = new HashSet<Long>(8);
        for (ListSelectedRow row : selectedData) {
            QFilter filters;
            DynamicObject[] scheduleSorts;
            Long ScheduleSortID = (Long)row.getPrimaryKeyValue();
            if (idSet.add(ScheduleSortID)) {
                idSet.add(ScheduleSortID);
            }
            String filed = "configuredcode.id";
            String selectFiled = "id,configuredcode,configuredcode.id";
            if ("mps_scheduledata".equals(sign)) {
                selectFiled = "id,configurecode,configurecode.id";
                filed = "configurecode.id";
            }
            if ((scheduleSorts = BusinessDataServiceHelper.load((String)sign, (String)selectFiled, (QFilter[])new QFilter[]{filters = new QFilter("id", "in", idSet)})) == null || scheduleSorts.length <= 0) continue;
            for (DynamicObject ScheduleSort : scheduleSorts) {
                Long configurecodeID;
                Long l = ScheduleSort.get(filed) == null ? null : (configurecodeID = ScheduleSort.get(filed) instanceof Long ? (Long)ScheduleSort.get(filed) : null);
                if (configurecodeID == null || !configurecodeIDSet.add(configurecodeID)) continue;
                configurecodeIDSet.add(configurecodeID);
            }
        }
        if (configurecodeIDSet == null || configurecodeIDSet.size() <= 0) {
            view.showTipNotification(ResManager.loadKDString((String)"\u9009\u62e9\u7684\u6570\u636e\u914d\u7f6e\u53f7\u5b57\u6bb5\u503c\u4e3a\u7a7a\uff0c\u6ca1\u6709\u8be6\u7ec6\u914d\u7f6e\u4fe1\u606f\u3002", (String)"MpsScheduleSortDetailListPlugin_1", (String)"mmc-mps-formplugin", (Object[])new Object[0]));
            return;
        }
        MPSScheduleUtils.showViewDetailConfigForm(configurecodeIDSet, view);
    }

    public static void showViewDetailConfigForm(Set<Long> configurecodeIDSet, IFormView view) {
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId("mps_schsortviewconfig");
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setCustomParam("configurecodeIDSet", configurecodeIDSet);
        view.showForm(formShowParameter);
    }

    public static Map<Long, Long> getOrderToGroupMap(List<Map<String, Object>> scheduleOrderList, Map<Long, Long> orderToMatType, Boolean isError, List<Long> MoreGroupOrderId) {
        DynamicObject productConfigure;
        Object productConfigures;
        QFilter qFilter;
        HashMap<Long, Long> orderIdToMatIdMap = new HashMap<Long, Long>(scheduleOrderList.size());
        HashMap orderIdToMatIdAndConfigIdMap = new HashMap(scheduleOrderList.size());
        HashMap<Long, List> matIdToConfigIdMap = new HashMap<Long, List>(scheduleOrderList.size());
        for (Map<String, Object> scheduleOrderMap : scheduleOrderList) {
            HashMap<Long, Long> matIdToConfigId = new HashMap<Long, Long>(scheduleOrderList.size());
            orderIdToMatIdMap.put(MPSScheduleUtils.getLongValueByField(scheduleOrderMap, "sourcebillid"), MPSScheduleUtils.getLongValueByField(scheduleOrderMap, "materiel_code"));
            List configList = matIdToConfigIdMap.computeIfAbsent(MPSScheduleUtils.getLongValueByField(scheduleOrderMap, "materiel_code"), k -> new ArrayList(10));
            Long configure = MPSScheduleUtils.getLongValueByField(scheduleOrderMap, "configure");
            if (configure == null || configure == 0L) continue;
            configList.add(MPSScheduleUtils.getLongValueByField(scheduleOrderMap, "configure"));
            matIdToConfigId.put(MPSScheduleUtils.getLongValueByField(scheduleOrderMap, "materiel_code"), MPSScheduleUtils.getLongValueByField(scheduleOrderMap, "configure"));
            orderIdToMatIdAndConfigIdMap.put(MPSScheduleUtils.getLongValueByField(scheduleOrderMap, "sourcebillid"), matIdToConfigId);
        }
        HashMap<Long, List> matIdToMatTypeMap = new HashMap<Long, List>(16);
        QFilter matQFilter = new QFilter("material", "in", orderIdToMatIdMap.values());
        DynamicObjectCollection materialColl = QueryServiceHelper.query((String)"bd_materialgroupdetail", (String)"material, group", (QFilter[])matQFilter.toArray());
        for (DynamicObject matDyn : materialColl) {
            List matTypeList = matIdToMatTypeMap.computeIfAbsent(matDyn.getLong("material"), k -> new ArrayList(10));
            matTypeList.add(matDyn.getLong("group"));
        }
        HashSet<Long> configSet = new HashSet<Long>(8);
        HashMap<Long, Long> orderIdToGroupIdMap = new HashMap<Long, Long>(16);
        Collection values = matIdToConfigIdMap.values();
        for (List list : values) {
            for (Long configId : list) {
                configSet.add(configId);
            }
        }
        DynamicObject productconfigure = ORM.create().newDynamicObject("pdm_productconfigure");
        HashMap<Object, Map<Long, ArrayList<Object>>> configToFeatureMap = new HashMap<Object, Map<Long, ArrayList<Object>>>(16);
        IDataEntityProperty iDataEntityProperty_masterconfigcode = (IDataEntityProperty)productconfigure.getDataEntityType().getProperties().get((Object)"masterconfigcode");
        if (iDataEntityProperty_masterconfigcode != null) {
            qFilter = new QFilter("masterconfigcode", "in", configSet);
            productConfigures = QueryServiceHelper.query((String)"pdm_productconfigure", (String)"prodorgid, materielno, masterconfigcode, entryentity.featurevalueid,entryentity.featurenumberid,entryentity.featureid", (QFilter[])new QFilter[]{qFilter});
            if (productConfigures != null && productConfigures.size() > 0) {
                Iterator iterator = productConfigures.iterator();
                while (iterator.hasNext()) {
                    productConfigure = (DynamicObject)iterator.next();
                    Long configureId = productConfigure.getLong("masterconfigcode");
                    String value = productConfigure.getString("entryentity.featurevalueid");
                    String featureId_string = productConfigure.getString("entryentity.featurenumberid");
                    Long featureId = 0L;
                    if (featureId_string == null || featureId_string.isEmpty()) {
                        Long entryentity_featureid = productConfigure.getLong("entryentity.featureid");
                        if (entryentity_featureid == null || entryentity_featureid.equals(0L)) continue;
                        featureId = entryentity_featureid;
                    } else {
                        featureId = Long.parseLong(featureId_string);
                    }
                    Map featureToValue = new HashMap(16);
                    if (configToFeatureMap.containsKey(configureId)) {
                        featureToValue = (Map)configToFeatureMap.get(configureId);
                    }
                    List<String> valueList = new ArrayList<String>(16);
                    if (featureToValue.containsKey(featureId)) {
                        valueList = (List)featureToValue.get(featureId);
                    }
                    valueList.add(value);
                    featureToValue.put(featureId, valueList);
                    configToFeatureMap.put(configureId, featureToValue);
                }
            }
        } else {
            qFilter = new QFilter("treeentryentity.configcode", "in", configSet);
            productConfigures = QueryServiceHelper.query((String)"pdm_productconfigure", (String)"prodorgid, materielno, entryentity.featurevalueid,entryentity.featurenumberid,treeentryentity.configcode", (QFilter[])new QFilter[]{qFilter.and("treeentryentity.pid", "=", (Object)0L)});
            if (productConfigures != null && productConfigures.size() > 0) {
                Iterator iterator = productConfigures.iterator();
                while (iterator.hasNext()) {
                    productConfigure = (DynamicObject)iterator.next();
                    long configureId = productConfigure.getLong("treeentryentity.configcode");
                    String value = productConfigure.getString("entryentity.featurevalueid");
                    String featureId_string = productConfigure.getString("entryentity.featurenumberid");
                    Long featureId = Long.parseLong(featureId_string);
                    HashMap featureToValue = new HashMap(16);
                    List<String> valueList = new ArrayList<String>(16);
                    if (featureToValue.containsKey(featureId)) {
                        valueList = (List)featureToValue.get(featureId);
                    }
                    valueList.add(value);
                    featureToValue.put(featureId, valueList);
                    configToFeatureMap.put(configureId, featureToValue);
                }
            }
        }
        HashSet<Long> set_createorg = new HashSet<Long>(scheduleOrderList.size());
        for (Map map : scheduleOrderList) {
            long longValue = MPSScheduleUtils.getLongValueByField(map, "production_org");
            set_createorg.add(longValue);
        }
        if (set_createorg.size() == 0) {
            if (isError.booleanValue()) {
                throw new KDBizException(SchedulePlanErrors.orderNoGroupError(), new Object[0]);
            }
            return orderIdToGroupIdMap;
        }
        QFilter groupQFilter = new QFilter("createorg", "in", set_createorg).and("status", "=", (Object)"C").and("enable", "=", (Object)"1");
        DynamicObjectCollection dynamicObjectCollection = QueryServiceHelper.query((String)"mps_intensive", (String)"id, number, createorg, series, material, entryentity.featureid featureId,series.isleaf,series.longnumber,type", (QFilter[])new QFilter[]{groupQFilter});
        HashMap<Long, Set<Long>> idAndchild = new HashMap<Long, Set<Long>>(8);
        for (DynamicObject dynamicObject : dynamicObjectCollection) {
            HashSet<Long> set = new HashSet<Long>(8);
            String longnumber = dynamicObject.getString("series.longnumber");
            Long id = dynamicObject.getLong("series");
            MPSScheduleUtils.querySeries(longnumber, set);
            idAndchild.put(id, set);
        }
        List<Long> idSort = MPSScheduleUtils.sortIdChildByChildNum(idAndchild);
        HashMap<Long, ArrayList<Long>> matToGroupMap = new HashMap<Long, ArrayList<Long>>(16);
        Map mps_intensive = BusinessDataServiceHelper.loadFromCache((String)"mps_intensive", (QFilter[])new QFilter[]{groupQFilter});
        HashMap<Long, Map<Long, Map<Long, List<String>>>> matTypeToGroupAndFeatureMap = new HashMap<Long, Map<Long, Map<Long, List<String>>>>(16);
        HashMap<Long, Map<Long, Map<Long, List<String>>>> matToGroupAndFeatureMap = new HashMap<Long, Map<Long, Map<Long, List<String>>>>(16);
        HashMap<Long, List> matTypeToGroupMap = new HashMap<Long, List>(16);
        HashSet<Long> group_exsit_nofe = new HashSet<Long>(8);
        if (mps_intensive != null && mps_intensive.size() > 0) {
            for (Map.Entry entry : mps_intensive.entrySet()) {
                ArrayList<Long> groupList;
                Long l = (Long)entry.getKey();
                DynamicObject dynamicObject = (DynamicObject)entry.getValue();
                String string = dynamicObject.getString("type");
                DynamicObjectCollection entryentity = dynamicObject.getDynamicObjectCollection("entryentity");
                if ("1".equals(string)) {
                    DynamicObject series1 = dynamicObject.getDynamicObject("series");
                    Long series = 0L;
                    if (series1 != null) {
                        series = series1.getLong("id");
                    }
                    if (entryentity != null && entryentity.size() != 0) {
                        MPSScheduleUtils.getMapValue(matTypeToGroupAndFeatureMap, entryentity, series, l);
                        continue;
                    }
                    group_exsit_nofe.add(l);
                    groupList = (List)matTypeToGroupMap.get(series);
                    if (groupList == null) {
                        groupList = new ArrayList(16);
                        matTypeToGroupMap.put(series, groupList);
                    }
                    groupList.add(l);
                    continue;
                }
                DynamicObject material1 = dynamicObject.getDynamicObject("material");
                Long material = 0L;
                if (material1 != null) {
                    material = material1.getLong("id");
                }
                if (entryentity != null && entryentity.size() != 0) {
                    MPSScheduleUtils.getMapValue(matToGroupAndFeatureMap, entryentity, material, l);
                    continue;
                }
                groupList = (ArrayList<Long>)matToGroupMap.get(material);
                if (groupList == null) {
                    groupList = new ArrayList<Long>(16);
                    matToGroupMap.put(material, groupList);
                }
                groupList.add(l);
            }
        }
        HashMap matTypeToGroupAndFeatureMap_clone = new HashMap(matTypeToGroupAndFeatureMap);
        for (Long l : idSort) {
            Map groupAndFeatureMap = (Map)matTypeToGroupAndFeatureMap_clone.get(l);
            if (groupAndFeatureMap == null) continue;
            Set set = (Set)idAndchild.get(l);
            for (Object childrenId : set) {
                if (matTypeToGroupAndFeatureMap.containsKey(childrenId)) continue;
                matTypeToGroupAndFeatureMap.put((Long)childrenId, groupAndFeatureMap);
            }
        }
        HashMap<Long, List> hashMap = new HashMap<Long, List>(matTypeToGroupMap.size());
        hashMap.putAll(matTypeToGroupMap);
        for (Long matTyp : idSort) {
            List list = (List)hashMap.get(matTyp);
            if (list == null) continue;
            Set childrens = (Set)idAndchild.get(matTyp);
            for (Long childrenId : childrens) {
                if (!matTypeToGroupMap.containsKey(childrenId)) {
                    matTypeToGroupMap.put(childrenId, list);
                    continue;
                }
                List list2 = (List)matTypeToGroupMap.get(childrenId);
                for (Long id : list) {
                    if (list2.contains(id) || group_exsit_nofe.contains(id)) continue;
                    list2.add(id);
                }
            }
        }
        ArrayList<Long> arrayList = new ArrayList<Long>(10);
        for (Map.Entry entry : orderIdToMatIdMap.entrySet()) {
            List matTypeList;
            List group_list;
            Object configId;
            Map matIdToConfigIdMaps;
            Boolean isNext = true;
            Long orderId = (Long)entry.getKey();
            Long matId = (Long)entry.getValue();
            Map groupAndFeatureMap = (Map)matToGroupAndFeatureMap.get(matId);
            if (groupAndFeatureMap != null && (matIdToConfigIdMaps = (Map)orderIdToMatIdAndConfigIdMap.get(orderId)) != null) {
                configId = (Long)matIdToConfigIdMaps.get(matId);
                Map configFeatures = (Map)configToFeatureMap.get(configId);
                for (Map.Entry groupAndFeatureMapEntry : groupAndFeatureMap.entrySet()) {
                    Long group = (Long)groupAndFeatureMapEntry.getKey();
                    Map featureList = (Map)groupAndFeatureMapEntry.getValue();
                    Boolean isMate = true;
                    block16: for (Map.Entry mapEntry : featureList.entrySet()) {
                        Long featureId = (Long)mapEntry.getKey();
                        List valueList = (List)mapEntry.getValue();
                        if (configFeatures != null && configFeatures.containsKey(featureId)) {
                            List configFeatures_value = (List)configFeatures.get(featureId);
                            for (String string : valueList) {
                                if (configFeatures_value.contains(string)) continue;
                                isMate = false;
                                continue block16;
                            }
                            continue;
                        }
                        isMate = false;
                        break;
                    }
                    if (!isMate.booleanValue()) continue;
                    if (orderIdToGroupIdMap.get(orderId) != null && ((Long)orderIdToGroupIdMap.get(orderId)).longValue() != group.longValue()) {
                        arrayList.add(orderId);
                        orderIdToGroupIdMap.remove(orderId);
                    } else {
                        orderIdToGroupIdMap.put(orderId, group);
                    }
                    isNext = false;
                }
            }
            if (isNext.booleanValue() && (group_list = (List)matToGroupMap.get(matId)) != null) {
                for (Long groupId : group_list) {
                    if (orderIdToGroupIdMap.get(orderId) != null && ((Long)orderIdToGroupIdMap.get(orderId)).longValue() != groupId.longValue()) {
                        arrayList.add(orderId);
                        orderIdToGroupIdMap.remove(orderId);
                    } else {
                        orderIdToGroupIdMap.put(orderId, groupId);
                    }
                    isNext = false;
                }
            }
            if (isNext.booleanValue() && (matIdToConfigIdMaps = (Map)orderIdToMatIdAndConfigIdMap.get(orderId)) != null) {
                configId = (Long)matIdToConfigIdMaps.get(matId);
                List matTypeList2 = (List)matIdToMatTypeMap.get(matId);
                Map configFeatures = (Map)configToFeatureMap.get(configId);
                for (Map.Entry matTypeToGroupAndFeatureMapEntry : matTypeToGroupAndFeatureMap.entrySet()) {
                    Long matTypeId = (Long)matTypeToGroupAndFeatureMapEntry.getKey();
                    Map groupAndFeatureMap_type = (Map)matTypeToGroupAndFeatureMapEntry.getValue();
                    if (matTypeList2 == null || !matTypeList2.contains(matTypeId)) continue;
                    for (Map.Entry groupAndFeatureMapEntry : groupAndFeatureMap_type.entrySet()) {
                        Long group = (Long)groupAndFeatureMapEntry.getKey();
                        Map featureList = (Map)groupAndFeatureMapEntry.getValue();
                        Boolean isMate = true;
                        block21: for (Map.Entry entry2 : featureList.entrySet()) {
                            Long featureId = (Long)entry2.getKey();
                            List valueList = (List)entry2.getValue();
                            if (configFeatures != null && configFeatures.containsKey(featureId)) {
                                List configFeatures_value = (List)configFeatures.get(featureId);
                                for (String value : valueList) {
                                    if (configFeatures_value.contains(value)) continue;
                                    isMate = false;
                                    continue block21;
                                }
                                continue;
                            }
                            isMate = false;
                            break;
                        }
                        if (!isMate.booleanValue()) continue;
                        if (orderIdToGroupIdMap.get(orderId) != null && ((Long)orderIdToGroupIdMap.get(orderId)).longValue() != group.longValue()) {
                            arrayList.add(orderId);
                            orderIdToGroupIdMap.remove(orderId);
                            orderToMatType.remove(orderId);
                        } else {
                            orderIdToGroupIdMap.put(orderId, group);
                            orderToMatType.put(orderId, matTypeId);
                        }
                        isNext = false;
                    }
                }
            }
            if (!isNext.booleanValue() || (matTypeList = (List)matIdToMatTypeMap.get(matId)) == null) continue;
            for (Long matTypeId : matTypeList) {
                if (!matTypeToGroupMap.containsKey(matTypeId)) continue;
                List group_list2 = (List)matTypeToGroupMap.get(matTypeId);
                for (Long groupId : group_list2) {
                    if (orderIdToGroupIdMap.get(orderId) != null && ((Long)orderIdToGroupIdMap.get(orderId)).longValue() != groupId.longValue()) {
                        arrayList.add(orderId);
                        orderIdToGroupIdMap.remove(orderId);
                        orderToMatType.remove(orderId);
                        continue;
                    }
                    orderIdToGroupIdMap.put(orderId, groupId);
                    orderToMatType.put(orderId, matTypeId);
                }
            }
        }
        if (!kd.bos.util.CollectionUtils.isEmpty(arrayList)) {
            for (Map map : scheduleOrderList) {
                Object sourceentryid = map.get("sourceentryid");
                if (sourceentryid != null && Long.parseLong(sourceentryid.toString()) != 0L) {
                    if (!arrayList.contains(sourceentryid)) continue;
                    MoreGroupOrderId.add((Long)sourceentryid);
                    continue;
                }
                if (!arrayList.contains(map.get("sourcebillid"))) continue;
                MoreGroupOrderId.add((Long)map.get("sourcebillid"));
            }
        }
        return orderIdToGroupIdMap;
    }

    private static void getMapValue(Map<Long, Map<Long, Map<Long, List<String>>>> mapValue, DynamicObjectCollection entryentity, Long sign, Long groupId) {
        Map<Long, List<String>> featureToValue;
        Map<Long, Map<Long, List<String>>> groupAndFeatureMap = mapValue.get(sign);
        if (groupAndFeatureMap == null) {
            groupAndFeatureMap = new HashMap<Long, Map<Long, List<String>>>(16);
            mapValue.put(sign, groupAndFeatureMap);
            featureToValue = new HashMap<Long, List<String>>(16);
            groupAndFeatureMap.put(groupId, featureToValue);
        }
        if ((featureToValue = groupAndFeatureMap.get(groupId)) == null) {
            featureToValue = new HashMap<Long, List<String>>(16);
            groupAndFeatureMap.put(groupId, featureToValue);
        }
        for (DynamicObject dynamicObject1 : entryentity) {
            String value = dynamicObject1.getString("entryvalueid");
            Long featureId = dynamicObject1.getLong("featureid.id");
            List<String> valueList = new ArrayList<String>(16);
            if (featureToValue.containsKey(featureId)) {
                valueList = featureToValue.get(featureId);
            }
            valueList.add(value);
            featureToValue.put(featureId, valueList);
        }
    }

    public static List<Long> sortIdChildByChildNum(Map<Long, Set<Long>> idAndchild) {
        Set<Long> matTypes = idAndchild.keySet();
        Long[] numbers = matTypes.toArray(new Long[matTypes.size()]);
        int size = numbers.length;
        for (int i = 0; i < size - 1; ++i) {
            for (int j = i + 1; j < size; ++j) {
                if (idAndchild.get(numbers[i]).size() <= idAndchild.get(numbers[j]).size()) continue;
                Long temp = numbers[i];
                numbers[i] = numbers[j];
                numbers[j] = temp;
            }
        }
        List<Long> list = Arrays.asList(numbers);
        return list;
    }

    public static Map<Long, List<Long>> orderGrouping(List<Map<String, Object>> scheduleOrderList, Map<Long, Long> orderIdToGroupIdMap, Map<Long, Long> groupDefineToGroupMap, Map<Long, BigDecimal> orderAndNum, Map<Long, Map<String, Object>> orderAndOrderMessage) {
        HashMap<Long, List<Long>> groupAndOrder = new HashMap<Long, List<Long>>(8);
        for (Map<String, Object> mapEntry : scheduleOrderList) {
            ArrayList<Long> orderSets;
            Long orderId = (Long)mapEntry.get("sourcebillid");
            BigDecimal order_num = (BigDecimal)mapEntry.get("order_num");
            Long groupDefindId = orderIdToGroupIdMap.get(orderId);
            Long groupId = groupDefineToGroupMap.get(groupDefindId);
            orderAndNum.put(orderId, order_num);
            orderAndOrderMessage.put(orderId, mapEntry);
            if (groupAndOrder.containsKey(groupId)) {
                orderSets = (ArrayList<Long>)groupAndOrder.get(groupId);
                orderSets.add(orderId);
                continue;
            }
            orderSets = new ArrayList<Long>(8);
            orderSets.add(orderId);
            groupAndOrder.put(groupId, orderSets);
        }
        return groupAndOrder;
    }

    public static DynamicObjectCollection queryIntensiveColl(Map<Long, Long> orderIdToGroupIdMap) {
        DynamicObjectCollection intensiveColl = QueryServiceHelper.query((String)"mps_intensive", (String)"id, group, number", (QFilter[])new QFilter[]{new QFilter("id", "in", orderIdToGroupIdMap.values())});
        return intensiveColl;
    }

    public static void getGroupAndGroupDefineRelation(DynamicObjectCollection intensiveColl, Map<String, Object> capacityMessage) {
        HashMap<Long, List<Long>> groupToGroupDefineMap = new HashMap<Long, List<Long>>(8);
        HashMap<Long, Long> groupDefineToGroupMap = new HashMap<Long, Long>(8);
        for (DynamicObject dynamicObject : intensiveColl) {
            List<Long> groupDefindList;
            long groupDefindId = dynamicObject.getLong("id");
            long groupId = dynamicObject.getLong("group");
            groupDefineToGroupMap.put(groupDefindId, groupId);
            if (groupToGroupDefineMap.containsKey(groupId)) {
                groupDefindList = (List)groupToGroupDefineMap.get(groupId);
                if (groupDefindList.contains(groupDefindId)) continue;
                groupDefindList.add(groupDefindId);
                continue;
            }
            groupDefindList = new ArrayList(8);
            groupDefindList.add(groupDefindId);
            groupToGroupDefineMap.put(groupId, groupDefindList);
        }
        capacityMessage.put("groupToGroupDefineMap", groupToGroupDefineMap);
        capacityMessage.put("groupDefineToGroupMap", groupDefineToGroupMap);
    }

    public static List<CapacityRateModel> getCapacityRate(Map<Long, List<CapacityRateModel>> capacityRateMap, Long workCenterId, Long groupId) {
        List<CapacityRateModel> capacityRateModels = capacityRateMap.get(workCenterId);
        ArrayList<CapacityRateModel> collect = new ArrayList<CapacityRateModel>(8);
        if (!CollectionUtils.isEmpty(capacityRateModels)) {
            for (CapacityRateModel capacityRateModel : capacityRateModels) {
                if (capacityRateModel.getTargetGroupId() == null || capacityRateModel.getTargetGroupId().longValue() != groupId.longValue()) continue;
                collect.add(capacityRateModel);
            }
            return collect;
        }
        return new ArrayList<CapacityRateModel>(10);
    }

    public static List<ReduOrderModel> getReduOrderModel(List<ReduOrderModel> reduOrderModelList, Long workCenterId, Long groupId, Date date) {
        if (reduOrderModelList == null) {
            return new ArrayList<ReduOrderModel>();
        }
        List<ReduOrderModel> collect = reduOrderModelList.stream().filter(x -> x.getWorkCenterId().longValue() == workCenterId.longValue() && x.getGroupId().longValue() == groupId.longValue() && x.getDate().getTime() == date.getTime()).collect(Collectors.toList());
        return collect;
    }

    public static List<ReduOrderModel> getReduOrderModelByWorkAndDate(List<ReduOrderModel> reduOrderModelList, Long workCenterId, Date date) {
        if (reduOrderModelList == null) {
            return new ArrayList<ReduOrderModel>();
        }
        List<ReduOrderModel> collect = reduOrderModelList.stream().filter(x -> x.getWorkCenterId().longValue() == workCenterId.longValue() && x.getDate().getTime() == date.getTime()).collect(Collectors.toList());
        return collect;
    }

    public static List<ReduOrderModel> getReduOrderModelByWork(List<ReduOrderModel> reduOrderModelList, Long workCenterId) {
        if (reduOrderModelList == null) {
            return new ArrayList<ReduOrderModel>();
        }
        List<ReduOrderModel> collect = reduOrderModelList.stream().filter(x -> x.getWorkCenterId().longValue() == workCenterId.longValue()).collect(Collectors.toList());
        return collect;
    }

    public static Map<Long, Long> getWorkCenterToPlanerMap(List<Long> workCenterIdList) {
        HashMap<Long, Long> workCenterToPlanerMap = new HashMap<Long, Long>(8);
        return workCenterToPlanerMap;
    }

    public static List<CapacityRateModel> getGroupToCapacityRate(Map<Long, List<CapacityRateModel>> capacityRateMap, Long workCenterId, Long groupId) {
        List<CapacityRateModel> capacityRateModels = capacityRateMap.get(workCenterId);
        ArrayList<CapacityRateModel> collect = new ArrayList<CapacityRateModel>(8);
        if (!CollectionUtils.isEmpty(capacityRateModels)) {
            for (CapacityRateModel capacityRateModel : capacityRateModels) {
                if (capacityRateModel.getSourceGroupId() == null || capacityRateModel.getSourceGroupId().longValue() != groupId.longValue()) continue;
                collect.add(capacityRateModel);
            }
            return collect;
        }
        return new ArrayList<CapacityRateModel>(10);
    }

    public static void querySeries(String longnumber, Set<Long> maTypeToChild) {
        String sql = "select fid from T_BD_MaterialGroup where flongnumber like  '" + longnumber + "!%'";
        try (DataSet querySeries = DB.queryDataSet((String)"querySeries", (DBRoute)DBRoute.basedata, (String)sql);){
            while (querySeries.hasNext()) {
                Row row = querySeries.next();
                maTypeToChild.add(row.getLong("fid"));
            }
        }
    }

    public static QFilter[] getQFilter(Long workCenterId, Long from, Long to) {
        QFilter[] filters = new QFilter[]{new QFilter("workcentre", "=", (Object)workCenterId), new QFilter("billstatus", "=", (Object)"C"), new QFilter("cancel", "=", (Object)Character.valueOf('0')), new QFilter("sheduledate", ">=", (Object)new Timestamp(from)), new QFilter("sheduledate", "<=", (Object)new Timestamp(to))};
        return filters;
    }

    public static JedisClient getJedis() {
        MPSScheduleUtils.getUrl();
        return RedisFactory.getJedisClient((String)MPSScheduleUtils.getUrl());
    }

    private static String getUrl() {
        String configKey = CacheConfigKeys.getSessionlessConfigKey((String)"mps");
        String url = System.getProperty(configKey);
        if (url == null) {
            configKey = CacheConfigKeys.getSessionlessConfigKey((String)null);
            url = System.getProperty(configKey);
        }
        return url;
    }

    public static Long resetCalendar(Calendar cal, Long date, Long to) {
        cal.setTimeInMillis(date);
        cal.add(14, to.intValue());
        return cal.getTimeInMillis();
    }

    public static Map<Long, List<Object[]>> parseTimeSlots(DataSet ds, BigDecimal timespanByHour, DynamicObjectCollection spans) {
        GroupbyDataSet sumDs = ds.groupBy(new String[]{"sheduledate"});
        ds = sumDs.sum("scheduleqty").finish();
        HashMap<Long, List<Object[]>> ret = new HashMap<Long, List<Object[]>>(8);
        BigDecimal timespanBySec = timespanByHour.multiply(new BigDecimal(60)).multiply(new BigDecimal(60)).setScale(2, RoundingMode.HALF_UP);
        Calendar cal = Calendar.getInstance();
        while (ds.hasNext()) {
            Row row = ds.next();
            Long date = row.getTimestamp("sheduledate").getTime();
            ArrayList<Object[]> slots = new ArrayList<Object[]>(8);
            ret.put(date, slots);
            int qty = row.getBigDecimal("scheduleqty").intValue();
            BigDecimal scheduleqty = row.getBigDecimal("scheduleqty");
            if (scheduleqty.compareTo(BigDecimal.ZERO) == 0) continue;
            int seconds = timespanBySec.divide(row.getBigDecimal("scheduleqty"), 0, RoundingMode.HALF_DOWN).intValue();
            int idx = 0;
            DynamicObject span = (DynamicObject)spans.get(idx++);
            Long to = MPSScheduleUtils.resetCalendar(cal, date, span.getLong("workendtime") * 1000L);
            Long from = MPSScheduleUtils.resetCalendar(cal, date, span.getLong("workstarttime") * 1000L);
            Boolean isaddDay = false;
            while (--qty >= 0) {
                slots.add(new Object[]{from, span.getLong("id")});
                Long fromBefore = from;
                cal.add(13, seconds);
                from = cal.getTimeInMillis();
                if (from >= to && idx < spans.size()) {
                    span = (DynamicObject)spans.get(idx++);
                    BigDecimal difftime = new BigDecimal(from).subtract(new BigDecimal(to));
                    BigDecimal multiply = new BigDecimal(seconds).multiply(new BigDecimal(1000));
                    to = MPSScheduleUtils.resetCalendar(cal, date, span.getLong("workendtime") * 1000L);
                    from = MPSScheduleUtils.resetCalendar(cal, date, span.getLong("workstarttime") * 1000L);
                    if (difftime.compareTo(multiply) < 0) {
                        from = new BigDecimal(from).add(difftime).longValue();
                    }
                    if (to <= from) {
                        to = to + 86400000L;
                    }
                }
                if (from >= fromBefore && !isaddDay.booleanValue()) continue;
                isaddDay = true;
                from = from + 86400000L;
                to = to + 86400000L;
            }
        }
        return ret;
    }

    public static QFilter parseDetailFilters(DataSet ds) {
        HashSet<Long> scheduleplanId = new HashSet<Long>(8);
        while (ds.hasNext()) {
            Row row = ds.next();
            scheduleplanId.add(row.getLong("id"));
        }
        return new QFilter("id", "in", scheduleplanId);
    }

    public static QFilter parseDetailScheduIdFilters(DataSet ds) {
        ArrayList<Long> scheduList = new ArrayList<Long>(8);
        while (ds.hasNext()) {
            Row row = ds.next();
            Long id = row.getLong("id");
            scheduList.add(id);
        }
        QFilter groupFilter = new QFilter("scheduleplan", "in", scheduList);
        return groupFilter;
    }

    public static Map<Long, String> getConfigure(List<Map<String, Object>> scheduleOrderList) {
        try {
            if (scheduleOrderList == null) {
                return new HashMap<Long, String>(8);
            }
            ArrayList<Long> configureList = new ArrayList<Long>(scheduleOrderList.size());
            for (Map<String, Object> map : scheduleOrderList) {
                Object configure = map.get("configure");
                if (configure == null || configure instanceof Integer) continue;
                configureList.add((Long)configure);
            }
            Map res = (Map)DispatchServiceHelper.invokeBizService((String)"mmc", (String)"pdm", (String)"proConfigListQueryService", (String)"getJsonProdConfigFeatureList", (Object[])new Object[]{false, configureList});
            HashMap<Long, String> configureToFeature = new HashMap<Long, String>(configureList.size());
            if (res != null) {
                if (res.get("data") == null || res.get("data").toString().isEmpty()) {
                    return configureToFeature;
                }
                JSONArray resJson = (JSONArray)res.get("data");
                if (resJson != null && resJson.size() > 0) {
                    for (int i = 0; i < resJson.size(); ++i) {
                        JSONObject configObjs = (JSONObject)resJson.get(i);
                        for (Long configstr : configureList) {
                            JSONObject configObj = (JSONObject)configObjs.get((Object)configstr);
                            if (configObj == null) continue;
                            JSONArray configIDJson = configObj.getJSONArray("featurelist");
                            StringBuilder featurevalueSb = new StringBuilder();
                            for (int j = 0; j < configIDJson.size(); ++j) {
                                JSONObject configCode = (JSONObject)configIDJson.get(j);
                                Object featurevalueinfo = configCode.get((Object)"featurevalueinfo");
                                if (featurevalueinfo != null) {
                                    List featurevalueinfoList = (List)featurevalueinfo;
                                    for (Map map : featurevalueinfoList) {
                                        String featurevalueStr = (String)map.get("featurevaluename");
                                        if (featurevalueStr == null || !kd.bos.util.StringUtils.isNotEmpty((String)featurevalueStr)) continue;
                                        featurevalueSb.append(featurevalueStr).append("\\");
                                    }
                                }
                                if (featurevalueSb.length() <= 1) continue;
                                String substring = featurevalueSb.substring(0, featurevalueSb.length() - 1);
                                configureToFeature.put(configstr, substring);
                            }
                        }
                    }
                }
            }
            return configureToFeature;
        }
        catch (Exception ex) {
            throw new KDBizException(ex.getMessage());
        }
    }

    public static Long getTotalWorkcenter(Map<Long, Map<Long, Set<Long>>> orgToWorkcenter, Long center, Long orgId) {
        Long totalCenter = null;
        Map<Long, Set<Long>> totalWorkcenterToWorkcenter = orgToWorkcenter.get(orgId);
        if (totalWorkcenterToWorkcenter != null) {
            for (Map.Entry<Long, Set<Long>> mapEntry : totalWorkcenterToWorkcenter.entrySet()) {
                Long totalWorkCenter = mapEntry.getKey();
                Set<Long> workCenters = mapEntry.getValue();
                if (!workCenters.contains(center)) continue;
                totalCenter = totalWorkCenter;
                break;
            }
        }
        return totalCenter;
    }

    public static String pollingStatus(long calculateLogId) {
        Date beginTime = TimeServiceHelper.now();
        Date endTime = TimeServiceHelper.now();
        try {
            while (true) {
                DynamicObject calculateLog;
                String status;
                if ("B".equals(status = (calculateLog = QueryServiceHelper.queryOne((String)"mrp_caculate_log", (String)"id, calculatestatus", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)calculateLogId)})).getString("calculatestatus"))) {
                    return status;
                }
                if ("A".equals(status)) {
                    return status;
                }
                if (BigDecimal.valueOf(endTime.getTime()).subtract(BigDecimal.valueOf(beginTime.getTime())).compareTo(new BigDecimal(120000)) >= 0) {
                    return status;
                }
                Thread.sleep(1000L);
                endTime = TimeServiceHelper.now();
            }
        }
        catch (Exception e) {
            throw new KDBizException(e.getMessage());
        }
    }

    public static List<Map<String, Object>> getScheduleOrder(DataSet dataSet, List<Long> sourcebillidList, List<Long> sourceentryidList) {
        if (dataSet == null || dataSet.isEmpty()) {
            return new ArrayList<Map<String, Object>>();
        }
        ArrayList<Map<String, Object>> scheduleOrderList = new ArrayList<Map<String, Object>>(8);
        DataSet copy = dataSet.copy();
        RowMeta rowMeta = copy.getRowMeta();
        String[] fieldNames = rowMeta.getFieldNames();
        while (copy.hasNext()) {
            Object sourcebillid;
            Row next = copy.next();
            HashMap<String, Object> scheduleOrderMap = new HashMap<String, Object>(8);
            for (int i = 0; i < fieldNames.length; ++i) {
                scheduleOrderMap.put(fieldNames[i], next.get(fieldNames[i]));
            }
            Object sourceentryid = scheduleOrderMap.get("sourceentryid");
            if (sourceentryid != null && Long.parseLong(sourceentryid.toString()) != 0L) {
                scheduleOrderMap.put("sourcebillid_old", scheduleOrderMap.get("sourcebillid"));
                scheduleOrderMap.put("sourcebillid", sourceentryid);
                sourceentryidList.add((Long)sourceentryid);
            }
            if ((sourcebillid = scheduleOrderMap.get("sourcebillid_old")) != null && Long.parseLong(sourcebillid.toString()) != 0L) {
                sourcebillidList.add((Long)sourcebillid);
            }
            scheduleOrderList.add(scheduleOrderMap);
        }
        return scheduleOrderList;
    }

    public static List<Map<String, Object>> getScheduleOrder(DataSet dataSet) {
        if (dataSet == null || dataSet.isEmpty()) {
            return new ArrayList<Map<String, Object>>();
        }
        ArrayList<Map<String, Object>> scheduleOrderList = new ArrayList<Map<String, Object>>(8);
        DataSet copy = dataSet.copy();
        RowMeta rowMeta = copy.getRowMeta();
        String[] fieldNames = rowMeta.getFieldNames();
        while (copy.hasNext()) {
            Row next = copy.next();
            HashMap<String, Object> scheduleOrderMap = new HashMap<String, Object>(8);
            for (int i = 0; i < fieldNames.length; ++i) {
                if ("workcenter".equals(fieldNames[i])) continue;
                scheduleOrderMap.put(fieldNames[i], next.get(fieldNames[i]));
            }
            Object sourceentryid = scheduleOrderMap.get("sourceentryid");
            if (sourceentryid != null && Long.parseLong(sourceentryid.toString()) != 0L) {
                scheduleOrderMap.put("sourcebillid_old", scheduleOrderMap.get("sourcebillid"));
                scheduleOrderMap.put("sourcebillid", sourceentryid);
            }
            scheduleOrderList.add(scheduleOrderMap);
        }
        logger.info("size", (Object)scheduleOrderList.size());
        return scheduleOrderList;
    }

    public static Map<Long, Map<Long, Set<Long>>> getOrgWorkcenter() {
        DynamicObject[] query;
        HashMap<Long, Map<Long, Set<Long>>> orgToWorkCenter = new HashMap<Long, Map<Long, Set<Long>>>(8);
        for (DynamicObject dynamicObject : query = BusinessDataServiceHelper.load((String)"mps_totalworkcenter", (String)"totalworkcenter,createorg,entryentity.workcenter", (QFilter[])new QFilter[]{new QFilter("status", "=", (Object)"C").and("enable", "=", (Object)"1")})) {
            long workcenterId;
            Set<Long> workcenterIdSet;
            DynamicObjectCollection dynamicObjectCollection;
            HashMap<Long, Set<Long>> totalWorkToworkcenter;
            Long orgId = dynamicObject.getDynamicObject("createorg").getLong("id");
            Long totalworkcenterId = dynamicObject.getDynamicObject("totalworkcenter").getLong("id");
            if (orgToWorkCenter.containsKey(orgId)) {
                totalWorkToworkcenter = (HashMap<Long, Set<Long>>)orgToWorkCenter.get(orgId);
                dynamicObjectCollection = dynamicObject.getDynamicObjectCollection("entryentity");
                if (totalWorkToworkcenter.containsKey(totalworkcenterId)) {
                    workcenterIdSet = (Set)totalWorkToworkcenter.get(totalworkcenterId);
                    for (DynamicObject workcenterDny : dynamicObjectCollection) {
                        if (workcenterDny.getDynamicObject("workcenter") == null) continue;
                        workcenterId = workcenterDny.getDynamicObject("workcenter").getLong("id");
                        workcenterIdSet.add(workcenterId);
                    }
                    continue;
                }
                workcenterIdSet = new HashSet(8);
                for (DynamicObject workcenterDny : dynamicObjectCollection) {
                    if (workcenterDny.getDynamicObject("workcenter") == null) continue;
                    workcenterId = workcenterDny.getDynamicObject("workcenter").getLong("id");
                    workcenterIdSet.add(workcenterId);
                }
                totalWorkToworkcenter.put(totalworkcenterId, workcenterIdSet);
                continue;
            }
            totalWorkToworkcenter = new HashMap<Long, Set<Long>>(8);
            dynamicObjectCollection = dynamicObject.getDynamicObjectCollection("entryentity");
            workcenterIdSet = new HashSet(8);
            for (DynamicObject workcenterDny : dynamicObjectCollection) {
                if (workcenterDny.getDynamicObject("workcenter") == null) continue;
                workcenterId = workcenterDny.getDynamicObject("workcenter").getLong("id");
                workcenterIdSet.add(workcenterId);
            }
            totalWorkToworkcenter.put(totalworkcenterId, workcenterIdSet);
            orgToWorkCenter.put(orgId, totalWorkToworkcenter);
        }
        return orgToWorkCenter;
    }

    public static void writeOrderPool(DynamicObject[] successPlan, String operateKey, Map<Long, List<Long>> entryentityList) {
        if ("submit".equals(operateKey)) {
            JSONArray entrys = new JSONArray();
            for (DynamicObject dynamicObject : successPlan) {
                Long l = dynamicObject.getLong("orderpoolid");
                BigDecimal putinqty = dynamicObject.getBigDecimal("scheduleqty");
                if (l == null || l == 0L || putinqty.compareTo(BigDecimal.ZERO) < 0) continue;
                String billno = dynamicObject.getString("billno");
                Long id = dynamicObject.getLong("id");
                Long creator = 0L;
                if (dynamicObject.getDynamicObject("creator") != null) {
                    creator = dynamicObject.getDynamicObject("creator").getLong("id");
                }
                Date createtime = dynamicObject.getDate("createtime");
                Date sheduledate = dynamicObject.getDate("sheduledate");
                String downbilltype = dynamicObject.getString("downbilltype");
                Long downstreamid = dynamicObject.getLong("downstreamid");
                Long downstreamentryid = dynamicObject.getLong("downstreamentryid");
                String downstreamno = dynamicObject.getString("downstreamno");
                int downstreamseq = dynamicObject.getInt("downstreamseq");
                DynamicObjectCollection entryentitys = dynamicObject.getDynamicObjectCollection("entryentity");
                for (DynamicObject entry : entryentitys) {
                    JSONObject param = new JSONObject();
                    param.put("id", (Object)l);
                    param.put("entryscheduleplanno", (Object)billno);
                    param.put("entrtycreator", (Object)creator);
                    param.put("entrycreatedate", (Object)createtime);
                    param.put("entryscheduleplanid", (Object)id);
                    param.put("entrysheduledate", (Object)sheduledate);
                    param.put("entryscheduleqty", (Object)BigDecimal.ONE);
                    param.put("entryscheduleplanentryid", entry.get("id"));
                    param.put("entryondate", entry.get("ontime"));
                    param.put("entryendworkdate", entry.get("instocktime"));
                    if ("pom_mftorder_BT_S".equals(downbilltype)) {
                        param.put("entrymanufacturenum", (Object)downstreamno);
                        param.put("entrymanufactureid", (Object)downstreamid);
                        param.put("entrymanufactureentryid", (Object)downstreamentryid);
                        param.put("entrymanufactureseq", (Object)downstreamseq);
                        param.put("entryplanstartworktime", null);
                        param.put("entryplanendworktime", null);
                        param.put("entryplaninstocktime", null);
                        param.put("entryrealinstocktime", null);
                    }
                    entrys.add((Object)param);
                }
            }
            try {
                JSONObject results;
                Object errors;
                if (entrys.size() != 0 && (errors = (results = (JSONObject)DispatchServiceHelper.invokeBizService((String)"mmc", (String)"mds", (String)"IMdsOrderPoolService", (String)"updateOrderPoolEntry", (Object[])new Object[]{entrys})).get((Object)"errors")) != null && !((Map)errors).isEmpty()) {
                    StringBuilder sb = new StringBuilder(ResManager.loadKDString((String)"\u53cd\u5199\u8ba2\u5355\u6c60\u5931\u8d25\uff1a", (String)"CapacityScheduReportPlugin_5", (String)"mmc-mps-formplugin", (Object[])new Object[0]));
                    for (Map.Entry entry : ((Map)errors).entrySet()) {
                        Long key = (Long)entry.getKey();
                        String value = (String)entry.getValue();
                        sb.append(key).append(key).append(value).append("\n");
                    }
                    throw new KDBizException(sb.toString());
                }
            }
            catch (Exception e) {
                String message = ResManager.loadKDString((String)"IMdsOrderPoolService\u5bf9\u5e94\u7684\u670d\u52a1\u5b9e\u73b0\u672a\u627e\u5230", (String)"CapacityScheduReportPlugin_7", (String)"mmc-mps-formplugin", (Object[])new Object[0]);
                if (!message.equals(e.getMessage())) {
                    throw new KDBizException(e.getMessage());
                }
                logger.error(message);
            }
        } else if ("unaudit".equals(operateKey)) {
            HashMap map = new HashMap(8);
            for (DynamicObject dynamicObject : successPlan) {
                HashSet<Long> longs;
                Long l = dynamicObject.getLong("orderpoolid");
                Long id = dynamicObject.getLong("id");
                if (entryentityList == null) {
                    if (l == null || l == 0L) continue;
                    if (map.containsKey(l)) {
                        Set longs2 = (Set)map.get(l);
                        longs2.add(id);
                        continue;
                    }
                    HashSet<Long> longs2 = new HashSet<Long>(8);
                    longs2.add(id);
                    map.put(l, longs2);
                    continue;
                }
                List<Long> list = entryentityList.get(id);
                if (list == null || l == null || l == 0L) continue;
                if (map.containsKey(l)) {
                    longs = (HashSet<Long>)map.get(l);
                    longs.addAll(list);
                    continue;
                }
                longs = new HashSet<Long>(8);
                longs.addAll(list);
                map.put(l, longs);
            }
            try {
                JSONObject results;
                Object errors;
                if (map.size() != 0 && (errors = (results = entryentityList == null ? (JSONObject)DispatchServiceHelper.invokeBizService((String)"mmc", (String)"mds", (String)"IMdsOrderPoolService", (String)"deleteOrderPoolEntry", (Object[])new Object[]{map, "entryscheduleplanid"}) : (JSONObject)DispatchServiceHelper.invokeBizService((String)"mmc", (String)"mds", (String)"IMdsOrderPoolService", (String)"deleteOrderPoolEntry", (Object[])new Object[]{map, "entryscheduleplanentryid"})).get((Object)"errors")) != null && !((Map)errors).isEmpty()) {
                    StringBuilder sb = new StringBuilder(ResManager.loadKDString((String)"\u53cd\u5199\u8ba2\u5355\u6c60\u5931\u8d25\uff1a", (String)"CapacityScheduReportPlugin_5", (String)"mmc-mps-formplugin", (Object[])new Object[0]));
                    for (Map.Entry entry : ((Map)errors).entrySet()) {
                        Long key = (Long)entry.getKey();
                        String value = (String)entry.getValue();
                        sb.append(key).append(key).append(value).append("\n");
                    }
                    throw new KDBizException(sb.toString());
                }
            }
            catch (Exception e) {
                String message = ResManager.loadKDString((String)"IMdsOrderPoolService\u5bf9\u5e94\u7684\u670d\u52a1\u5b9e\u73b0\u672a\u627e\u5230", (String)"CapacityScheduReportPlugin_7", (String)"mmc-mps-formplugin", (Object[])new Object[0]);
                if (!message.equals(e.getMessage())) {
                    throw new KDBizException(e.getMessage());
                }
                logger.error(message);
            }
        }
    }

    public static Map<Long, String> writeOrderPool_return(Map<Long, String> map) {
        try {
            JSONObject results = (JSONObject)DispatchServiceHelper.invokeBizService((String)"mmc", (String)"mds", (String)"IMdsOrderPoolService", (String)"returnOrderPool", (Object[])new Object[]{map});
            Object errors = results.get((Object)"errors");
            if (errors != null && !((Map)errors).isEmpty()) {
                return (Map)errors;
            }
        }
        catch (Exception e) {
            String message = ResManager.loadKDString((String)"IMdsOrderPoolService\u5bf9\u5e94\u7684\u670d\u52a1\u5b9e\u73b0\u672a\u627e\u5230", (String)"CapacityScheduReportPlugin_7", (String)"mmc-mps-formplugin", (Object[])new Object[0]);
            if (!message.equals(e.getMessage())) {
                throw new KDBizException(e.getMessage());
            }
            logger.error(message);
        }
        return new HashMap<Long, String>(8);
    }

    public static Set<Long> getProductOrg(List<Long> orgId) {
        HashSet<Long> idSet = new HashSet<Long>(orgId.size());
        QFilter orgIdfilter = new QFilter("org", "in", orgId);
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"PlanViewOrgHelper", (String)"bos_org_structure", (String)"org", (QFilter[])new QFilter[]{orgIdfilter}, null);){
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                long id = row.getLong("org");
                idSet.add(id);
            }
        }
        return idSet;
    }

    public static DynamicObject getPlanProgram(Long orgId) {
        QFilter isdefaultscheFilter;
        if (orgId == null || orgId.equals(0L)) {
            return null;
        }
        QFilter statusFilter = new QFilter("status", "=", (Object)Character.valueOf('C'));
        QFilter enableFilter = new QFilter("enable", "=", (Object)Character.valueOf('1'));
        QFilter baseDataFilter = BaseDataServiceHelper.getBaseDataFilter((String)MPS_PROPLANSCHDEF, (Long)orgId);
        DynamicObjectCollection query = QueryServiceHelper.query((String)MPS_PROPLANSCHDEF, (String)"id, number, name,capacalcway", (QFilter[])new QFilter[]{baseDataFilter, isdefaultscheFilter = new QFilter("isdefaultsche", "=", (Object)Character.valueOf('1'))});
        if (query == null || query.size() == 0) {
            DynamicObjectCollection query_other = QueryServiceHelper.query((String)MPS_PROPLANSCHDEF, (String)"id, number, name,capacalcway", (QFilter[])new QFilter[]{new QFilter("ctrlstrategy", "=", (Object)"5").and("isdefaultsche", "=", (Object)Character.valueOf('1')), statusFilter, enableFilter});
            if (query_other == null || query_other.size() == 0 || query_other.size() > 1) {
                return null;
            }
            return (DynamicObject)query_other.get(0);
        }
        return (DynamicObject)query.get(0);
    }

    public static Map<Long, String> getWorkDay(DynamicObject dynamicObject, Long workcalendar) {
        DynamicObject query;
        Long createorg;
        Long calendarId = dynamicObject.getLong("calendar");
        if (workcalendar != null && workcalendar != 0L) {
            calendarId = workcalendar;
        }
        HashMap<Long, String> workCalendar = new HashMap<Long, String>(8);
        if ((calendarId == null || calendarId == 0L) && (createorg = Long.valueOf(dynamicObject.getLong("createorg"))) != null && (query = QueryServiceHelper.queryOne((String)"mpdm_calendar", (String)"id", (QFilter[])new QFilter[]{new QFilter("createorg", "=", (Object)createorg).and("isfault", "=", (Object)"1")})) != null) {
            calendarId = query.getLong("id");
        }
        if (calendarId != 0L) {
            QFilter qFilter = new QFilter("id", "=", (Object)calendarId);
            try (DataSet dataSet = ORM.create().queryDataSet("mpsQueryCalendar", "mpdm_calendar", "dateentry.workdate,dateentry.datetype", qFilter.toArray(), "dateentry.workdate asc");){
                if (dataSet.hasNext()) {
                    for (Row row : dataSet) {
                        if (row.getDate("dateentry.workdate") == null) continue;
                        workCalendar.put(row.getDate("dateentry.workdate").getTime(), row.getString("dateentry.datetype"));
                    }
                }
            }
        }
        return workCalendar;
    }

    public static Map<Long, Map<Long, String>> getWorkDayByRange(Date filterbeginDate, Date filterEndDate, Map<Long, Object[]> planWorkCenter) {
        HashMap<Long, Map<Long, String>> workcenterToworkCalendar = new HashMap<Long, Map<Long, String>>(16);
        HashMap<Long, Long> workcenterIdToCaner = new HashMap<Long, Long>(16);
        for (Map.Entry<Long, Object[]> mapEntry : planWorkCenter.entrySet()) {
            Long workcenterId = mapEntry.getKey();
            Object[] objectArray = mapEntry.getValue();
            if (objectArray[1] == null) continue;
            workcenterIdToCaner.put(workcenterId, (Long)objectArray[1]);
        }
        QFilter qFilter = new QFilter("id", "in", workcenterIdToCaner.values()).and("dateentry.workdate", ">=", (Object)filterbeginDate).and("dateentry.workdate", "<=", (Object)filterEndDate);
        DataSet dataSet = ORM.create().queryDataSet("mpsQueryCalendar", "mpdm_calendar", "id,dateentry.workdate,dateentry.datetype,expiringyearfrom,expiringmonthfrom,expiringyearto,expiringmonthto", qFilter.toArray(), "dateentry.workdate asc");
        Object object = null;
        try {
            if (dataSet.hasNext()) {
                for (Row row : dataSet) {
                    HashMap<Long, String> workCalendar;
                    if (row.getDate("dateentry.workdate") == null) continue;
                    Long id = row.getLong("id");
                    if (workcenterToworkCalendar.containsKey(id)) {
                        workCalendar = (HashMap<Long, String>)workcenterToworkCalendar.get(id);
                        workCalendar.put(row.getDate("dateentry.workdate").getTime(), row.getString("dateentry.datetype"));
                        continue;
                    }
                    MPSScheduleUtils.checkRange(row, filterbeginDate, filterEndDate);
                    workCalendar = new HashMap<Long, String>(16);
                    workCalendar.put(row.getDate("dateentry.workdate").getTime(), row.getString("dateentry.datetype"));
                    workcenterToworkCalendar.put(id, workCalendar);
                }
            }
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            if (dataSet != null) {
                if (object != null) {
                    try {
                        dataSet.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                } else {
                    dataSet.close();
                }
            }
        }
        HashMap workcenterToworkCalendar_clone = new HashMap(workcenterToworkCalendar);
        workcenterToworkCalendar.clear();
        for (Map.Entry entry : workcenterIdToCaner.entrySet()) {
            Long workcenterId = (Long)entry.getKey();
            Long workCalendar = (Long)entry.getValue();
            Map longStringMap = (Map)workcenterToworkCalendar_clone.get(workCalendar);
            workcenterToworkCalendar.put(workcenterId, longStringMap);
        }
        return workcenterToworkCalendar;
    }

    public static void checkRange(Row row, Date filterbeginDate, Date filterEndDate) {
        Calendar calendar = Calendar.getInstance();
        String expiringyearfrom = row.getString("expiringyearfrom");
        String expiringmonthfrom = row.getString("expiringmonthfrom");
        String expiringyearto = row.getString("expiringyearto");
        String expiringmonthto = row.getString("expiringmonthto");
        if (expiringmonthto == null || expiringyearto == null || expiringyearfrom == null || expiringmonthfrom == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u751f\u4ea7\u65e5\u5386\u6709\u6548\u671f\u8bbe\u7f6e\u6709\u8bef\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"SchedulePlanErrors_18", (String)"mmc-mps-common", (Object[])new Object[0]));
        }
        calendar.set(1, Integer.parseInt(expiringyearfrom));
        calendar.set(2, Integer.parseInt(expiringmonthfrom) - 1);
        calendar.set(5, 1);
        calendar.set(13, 0);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(14, 0);
        if (filterbeginDate.getTime() < calendar.getTime().getTime()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u751f\u4ea7\u65e5\u5386\u5b58\u5728\u4e0d\u5305\u542b\u7684\u8fc7\u6ee4\u65e5\u671f\u3002", (String)"SchedulePlanErrors_19", (String)"mmc-mps-common", (Object[])new Object[0]));
        }
        calendar = Calendar.getInstance();
        calendar.set(1, Integer.parseInt(expiringyearto));
        calendar.set(2, Integer.parseInt(expiringmonthto) - 1);
        calendar.set(5, calendar.getActualMaximum(5));
        calendar.set(13, 0);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(14, 0);
        if (filterEndDate.getTime() > calendar.getTime().getTime()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u751f\u4ea7\u65e5\u5386\u5b58\u5728\u4e0d\u5305\u542b\u7684\u8fc7\u6ee4\u65e5\u671f\u3002", (String)"SchedulePlanErrors_19", (String)"mmc-mps-common", (Object[])new Object[0]));
        }
    }

    public static List<Long> getHasPermOrg(String entity, String appId) {
        Long uid = RequestContext.get().getCurrUserId();
        HasPermOrgResult result = PermissionServiceHelper.getAllPermOrgs((Long)uid, (String)BizAppServiceHelp.getAppIdByAppNumber((String)appId), (String)entity, (String)"47150e89000000ac");
        ArrayList<QFilter> qfilters = new ArrayList<QFilter>(2);
        QFilter permFilter = null;
        if (!result.hasAllOrgPerm()) {
            qfilters = new ArrayList(3);
            permFilter = new QFilter("id", "in", (Object)result.getHasPermOrgs());
            qfilters.add(permFilter);
        }
        QFilter enableFilter = new QFilter("enable", "=", (Object)Boolean.TRUE);
        qfilters.add(enableFilter);
        HashMap orgMap = BusinessDataServiceHelper.loadFromCache((String)"bos_org", (QFilter[])qfilters.toArray(new QFilter[0]));
        if (orgMap == null) {
            orgMap = new HashMap(0);
        }
        ArrayList<Long> orgPks = new ArrayList<Long>(orgMap.size());
        for (DynamicObject org : orgMap.values()) {
            Object orgPk = org.getPkValue();
            orgPks.add((Long)orgPk);
        }
        return orgPks;
    }

    public static Date getNewDate(Date pls_date) {
        if (pls_date != null) {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime(pls_date);
            calendar.set(11, 0);
            calendar.set(12, 0);
            calendar.set(13, 0);
            return calendar.getTime();
        }
        return null;
    }

    public static String moreNumTips(DynamicObject[] successPlan) {
        BigDecimal num;
        BigDecimal scheduleqty;
        Long productionid;
        StringBuilder stringBuilder = new StringBuilder();
        ArrayList<Long> productionids = new ArrayList<Long>(16);
        HashMap<Long, String> productionidToMesage = new HashMap<Long, String>(16);
        for (DynamicObject dynamicObject : successPlan) {
            Long productionid2 = dynamicObject.getLong("productionid");
            String sourcebillno = dynamicObject.getString("sourcebillno");
            String string = dynamicObject.getString("billno");
            if (productionid2 == null || productionid2 == 0L) continue;
            productionids.add(productionid2);
            String s = sourcebillno + "," + string;
            productionidToMesage.put(productionid2, s);
        }
        HashMap<Long, BigDecimal> scheduleplanDataMap = new HashMap<Long, BigDecimal>(16);
        HashMap<Long, BigDecimal> scheduledataDataMap = new HashMap<Long, BigDecimal>(16);
        QFilter qFilter = new QFilter("billstatus", "=", (Object)"C").or("billstatus", "=", (Object)"D");
        DynamicObject[] scheduleplanload = BusinessDataServiceHelper.load((String)"mps_scheduleplan", (String)"scheduleqty,productionid", (QFilter[])new QFilter[]{new QFilter("productionid", "in", productionids).and(qFilter)});
        DynamicObject[] scheduledata = BusinessDataServiceHelper.load((String)"mps_scheduledata", (String)"orderqty,id", (QFilter[])new QFilter[]{new QFilter("id", "in", productionids)});
        for (DynamicObject dynamicObject : scheduleplanload) {
            productionid = dynamicObject.getLong("productionid");
            scheduleqty = dynamicObject.getBigDecimal("scheduleqty");
            if (productionid == null || productionid == 0L) continue;
            if (scheduleplanDataMap.containsKey(productionid)) {
                num = (BigDecimal)scheduleplanDataMap.get(productionid);
                num = num.add(scheduleqty);
                scheduleplanDataMap.put(productionid, num);
                continue;
            }
            scheduleplanDataMap.put(productionid, scheduleqty);
        }
        for (DynamicObject dynamicObject : scheduledata) {
            productionid = dynamicObject.getLong("id");
            scheduleqty = dynamicObject.getBigDecimal("orderqty");
            if (productionid == null || productionid == 0L) continue;
            if (scheduledataDataMap.containsKey(productionid)) {
                num = (BigDecimal)scheduledataDataMap.get(productionid);
                num = num.add(scheduleqty);
                scheduledataDataMap.put(productionid, num);
                continue;
            }
            scheduledataDataMap.put(productionid, scheduleqty);
        }
        for (Map.Entry entry : scheduleplanDataMap.entrySet()) {
            String s;
            Long proId = (Long)entry.getKey();
            BigDecimal num2 = (BigDecimal)entry.getValue();
            BigDecimal bigDecimal = (BigDecimal)scheduledataDataMap.get(proId);
            if (num2 == null) {
                num2 = BigDecimal.ZERO;
            }
            if (bigDecimal == null) {
                bigDecimal = BigDecimal.ZERO;
            }
            if (num2.compareTo(bigDecimal) <= 0 || (s = (String)productionidToMesage.get(proId)) == null || !s.contains(",")) continue;
            String[] split = s.split(",");
            stringBuilder.append(ResManager.loadKDString((String)"\u6765\u6e90\u5355\u636e\u7f16\u7801\uff1a", (String)"CapacityScheduReportQuery_8", (String)"mmc-mps-report", (Object[])new Object[0])).append(split[0]).append(" ").append(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u7801\uff1a", (String)"CapacityScheduReportQuery_9", (String)"mmc-mps-report", (Object[])new Object[0])).append(split[1]).append(" ").append(ResManager.loadKDString((String)"\u5df2\u8d85\u6392\uff0c\u8bf7\u6ce8\u610f\u68c0\u67e5\u6570\u636e\u3002", (String)"SchedulePlanErrors_21", (String)"mmc-mps-common", (Object[])new Object[0])).append("\n");
        }
        return stringBuilder.toString();
    }
}

