/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mps.common.util;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.LinkSetElement;
import kd.bos.entity.LinkSetItemElement;
import kd.bos.entity.botp.runtime.TableDefine;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.botp.ConvertMetaServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class MpsBotpRowLinkUtils {
    private static Log log = LogFactory.getLog(MpsBotpRowLinkUtils.class);
    private static final DBRoute scmDBRoute = new DBRoute("scm");
    private static final DBRoute sysDBRoute = new DBRoute("sys");

    public static void fixRowLink(String targetEntityNumber, String targetEntryKey, String srcEntityNumber, String srcEntryFld, String srcRowSeqFld, Object targetBillId, String srcBillNo) {
        if (StringUtils.isNotBlank((CharSequence)targetEntityNumber) && StringUtils.isNotBlank((CharSequence)targetEntryKey) && StringUtils.isNotBlank((CharSequence)srcEntityNumber) && StringUtils.isNotBlank((CharSequence)srcEntryFld) && StringUtils.isNotBlank((CharSequence)srcRowSeqFld) && StringUtils.isNotBlank((CharSequence)srcBillNo) && null != targetBillId) {
            DynamicObject targetBillObj = BusinessDataServiceHelper.loadSingle((Object)targetBillId, (String)targetEntityNumber);
            TableDefine targetTableDefine = EntityMetadataCache.loadTableDefine((String)targetEntityNumber, (String)targetEntryKey);
            TableDefine srcTableDefine = EntityMetadataCache.loadTableDefine((String)srcEntityNumber, (String)srcEntryFld);
            DynamicObject[] sourceBillObjs = MpsBotpRowLinkUtils.loadSourceBill(srcTableDefine, srcBillNo);
            log.info("\u8fdb\u5165\u5230\u521b\u5efat_pom_mftorder_tc\u8868\u6570\u636e,srcBillNo:" + srcBillNo);
            MpsBotpRowLinkUtils.createLinkEntity(targetTableDefine, targetBillObj, srcTableDefine, sourceBillObjs, srcRowSeqFld);
            log.info("\u8fdb\u5165\u5230\u6700\u540e\u7684SaveServiceHelper.saveOperate()\u4fdd\u5b58\u8bbf\u6c42,targetEntityNumber:" + targetEntityNumber);
            SaveServiceHelper.saveOperate((String)targetEntityNumber, (DynamicObject[])new DynamicObject[]{targetBillObj}, (OperateOption)OperateOption.create());
        }
    }

    public static void fixRowLinkDB(String targetEntityNumber, String targetEntryKey, String srcEntityNumber, String srcEntryFld, String srcRowSeqFld, Long targetBillId, String srcBillNO) {
        if (StringUtils.isNotBlank((CharSequence)targetEntityNumber) && StringUtils.isNotBlank((CharSequence)targetEntryKey) && StringUtils.isNotBlank((CharSequence)srcEntityNumber) && StringUtils.isNotBlank((CharSequence)srcEntryFld) && StringUtils.isNotBlank((CharSequence)srcRowSeqFld) && StringUtils.isNotBlank((CharSequence)srcBillNO) && null != targetBillId) {
            DynamicObject targetBillObj = BusinessDataServiceHelper.loadSingle((Object)targetBillId, (String)targetEntityNumber);
            TableDefine targetTableDefine = EntityMetadataCache.loadTableDefine((String)targetEntityNumber, (String)targetEntryKey);
            TableDefine srcTableDefine = EntityMetadataCache.loadTableDefine((String)srcEntityNumber, (String)srcEntryFld);
            String targetTcTable = MpsBotpRowLinkUtils.getTcTable(targetEntityNumber);
            String targetLinkTable = MpsBotpRowLinkUtils.getLinkTable(targetTableDefine, targetEntityNumber);
            Long targetEntryTableID = targetTableDefine.getTableId();
            Long srcEntryTableID = srcTableDefine.getTableId();
            Long targetTableID = EntityMetadataCache.loadMainTableDefine((String)targetEntityNumber).getTableId();
            Long srcTableID = EntityMetadataCache.loadMainTableDefine((String)srcEntityNumber).getTableId();
            ORM orm = ORM.create();
            DynamicObject[] sourceBillObjs = MpsBotpRowLinkUtils.loadSourceBill(srcTableDefine, srcBillNO);
            String lkEntryKey = targetTableDefine.getEntityKey() + "_lk";
            DynamicObjectCollection targetRows = targetBillObj.getDynamicObjectCollection(targetTableDefine.getEntityKey());
            HashSet<String> executeSet = new HashSet<String>(16);
            String keyString = null;
            ArrayList<Object[]> paramList1 = new ArrayList<Object[]>(16);
            ArrayList<Object[]> paramList2 = new ArrayList<Object[]>(16);
            ArrayList<Object[]> paramList3 = new ArrayList<Object[]>(16);
            for (DynamicObject targetRow : targetRows) {
                Long srcBillId;
                DynamicObjectCollection linkRows = targetRow.getDynamicObjectCollection(lkEntryKey);
                if (!linkRows.isEmpty()) continue;
                Long srcBillEntryId = srcBillId = Long.valueOf(sourceBillObjs[0].getLong("id"));
                Long tBillEntryID = targetBillId;
                keyString = MpsBotpRowLinkUtils.getKeySting("1", srcBillId, targetBillId, "", "");
                if (executeSet.add(keyString)) {
                    MpsBotpRowLinkUtils.addBilltrackerData(srcTableID, srcBillId, targetTableID, targetBillId, orm, paramList1);
                }
                if (executeSet.add(keyString = MpsBotpRowLinkUtils.getKeySting("2", srcBillId, targetBillId, srcBillEntryId, tBillEntryID)) && !MpsBotpRowLinkUtils.isNullString(targetLinkTable)) {
                    MpsBotpRowLinkUtils.addLinkTableData(targetLinkTable, srcEntryTableID, srcBillId, srcBillEntryId, tBillEntryID, 1, paramList2);
                }
                if (!executeSet.add(keyString = MpsBotpRowLinkUtils.getKeySting("3", srcBillId, targetBillId, srcBillEntryId, tBillEntryID)) || MpsBotpRowLinkUtils.isNullString(targetTcTable)) continue;
                MpsBotpRowLinkUtils.addTcTableData(targetTcTable, srcEntryTableID, srcBillId, srcBillEntryId, targetEntryTableID, targetBillId, tBillEntryID, paramList3);
            }
            if (!paramList1.isEmpty()) {
                MpsBotpRowLinkUtils.insertBilltrackerData(paramList1);
            }
            if (!paramList2.isEmpty()) {
                MpsBotpRowLinkUtils.insertLinkTableData(targetLinkTable, paramList2);
            }
            if (!paramList3.isEmpty()) {
                MpsBotpRowLinkUtils.insertTcTableData(targetTcTable, paramList3);
            }
        }
    }

    private static void addLinkTableData(String lkTableName, Long stableid, Long sbillid, Long sbillEntryid, Long tbillEntryid, int seq, List<Object[]> paramList) {
        if (!MpsBotpRowLinkUtils.isExistsLinkTableData(lkTableName, sbillEntryid, tbillEntryid)) {
            Long linkID = DBServiceHelper.genGlobalLongId();
            Object[] objects = new Object[]{tbillEntryid, linkID, seq, stableid, sbillid, sbillEntryid};
            paramList.add(objects);
        }
    }

    private static boolean isExistsLinkTableData(String lkTableName, Long sbillEntryid, Long tbillEntryid) {
        StringBuilder bf = new StringBuilder(150);
        bf.append(" select fpkid from ").append(lkTableName).append(" where fentryid = ? and  fsid = ? ");
        try (DataSet ds = DB.queryDataSet((String)"mmc-BotpRowLinkUtils-isExistsLinkTableData", (DBRoute)scmDBRoute, (String)bf.toString(), (Object[])new Long[]{tbillEntryid, sbillEntryid});){
            boolean bl = ds.hasNext();
            return bl;
        }
    }

    private static void insertLinkTableData(String lkTableName, List<Object[]> paramList) {
        StringBuilder bf = new StringBuilder(100);
        bf.append(" insert into ").append(lkTableName).append("(fentryid,fpkid,fseq,fstableid,fsbillid,fsid) ");
        bf.append(" values(?,?,?,?,?,?) ");
        DB.executeBatch((DBRoute)scmDBRoute, (String)bf.toString(), paramList);
    }

    private static void addTcTableData(String tcTableName, Long stableid, Long sbillid, Long sbillEntryid, Long ttableid, Long tbillid, Long tbillEntryid, List<Object[]> paramList) {
        if (!MpsBotpRowLinkUtils.isExistsTcTableData(tcTableName, sbillEntryid, tbillEntryid)) {
            Long tcID = DBServiceHelper.genGlobalLongId();
            Object[] objects = new Object[]{tcID, tbillid, ttableid, tbillEntryid, sbillid, stableid, sbillEntryid};
            paramList.add(objects);
        }
    }

    private static boolean isExistsTcTableData(String tcTableName, Long sbillEntryid, Long tbillEntryid) {
        StringBuilder bf = new StringBuilder(100);
        bf.append(" select fid from ").append(tcTableName).append(" where ftid = ? and  fsid = ? ");
        try (DataSet ds = DB.queryDataSet((String)"mmc-BotpRowLinkUtils-isExistsLinkTableData", (DBRoute)scmDBRoute, (String)bf.toString(), (Object[])new Long[]{tbillEntryid, sbillEntryid});){
            boolean bl = ds.hasNext();
            return bl;
        }
    }

    private static void insertTcTableData(String tcTableName, List<Object[]> paramList) {
        StringBuilder bf = new StringBuilder(100);
        bf.append(" insert into ").append(tcTableName).append("(fid,ftbillid,fttableid,ftid,fsbillid,fstableid,fsid) ");
        bf.append(" values(?,?,?,?,?,?,?) ");
        DB.executeBatch((DBRoute)scmDBRoute, (String)bf.toString(), paramList);
    }

    private static String getLinkTable(TableDefine tableDefine, String entityNumber) {
        LinkSetElement targgetLinkSet = ConvertMetaServiceHelper.loadLinkSet((String)entityNumber);
        String lkEntryKey = tableDefine.getEntityKey() + "_lk";
        List lkitems = targgetLinkSet.getItems();
        for (int i = 0; i < lkitems.size(); ++i) {
            if (!((LinkSetItemElement)lkitems.get(i)).getLinkEntityKey().equals(lkEntryKey)) continue;
            return ((LinkSetItemElement)lkitems.get(i)).getTableName();
        }
        return "";
    }

    private static String getTcTable(String entityNumber) {
        LinkSetElement targgetLinkSet = ConvertMetaServiceHelper.loadLinkSet((String)entityNumber);
        return targgetLinkSet.getTrackerTable();
    }

    private static String getKeySting(String atype, Object obj1, Object obj2, Object obj3, Object obj4) {
        StringBuilder bf = new StringBuilder(100);
        bf.append(atype);
        bf.append('_');
        bf.append(obj1);
        bf.append('_');
        bf.append(obj2);
        bf.append('_');
        bf.append(obj3);
        bf.append('_');
        bf.append(obj4);
        return bf.toString();
    }

    private static void addBilltrackerData(Long stableid, Long sbillid, Long ttableid, Long tbillid, ORM orm, List<Object[]> paramList) {
        if (!MpsBotpRowLinkUtils.isExistsBilltrackerData(stableid, sbillid, ttableid, tbillid)) {
            Long trackID = orm.genLongId("botp_billtracker");
            Object[] objects = new Object[]{trackID, stableid, sbillid, ttableid, tbillid, new Date()};
            paramList.add(objects);
        }
    }

    private static boolean isExistsBilltrackerData(Long stableid, Long sbillid, Long ttableid, Long tbillid) {
        StringBuilder bf = new StringBuilder(200);
        bf.append(" select fid from t_botp_billtracker where fsbillid = ? and  ftbillid = ? and fstableid = ? and fttableid = ?  ");
        try (DataSet ds = DB.queryDataSet((String)"mmc-BotpRowLinkUtils-isExistsBilltrackerData", (DBRoute)sysDBRoute, (String)bf.toString(), (Object[])new Long[]{sbillid, tbillid, stableid, ttableid});){
            boolean bl = ds.hasNext();
            return bl;
        }
    }

    private static void insertBilltrackerData(List<Object[]> paramList) {
        try (TXHandle txHandle = TX.requiresNew();){
            StringBuilder bf = new StringBuilder(200);
            bf.append(" insert into t_botp_billtracker(fid,fstableid,fsbillid,fttableid,ftbillid,fcreatetime) ");
            bf.append(" values(?,?,?,?,?,?) ");
            DB.executeBatch((DBRoute)sysDBRoute, (String)bf.toString(), paramList);
        }
    }

    private static boolean isNullString(String obj) {
        return obj == null || "".equals(obj);
    }

    private static DynamicObject[] loadSourceBill(TableDefine srcTableDefine, String srcBillNo) {
        BillEntityType sourceMainType = (BillEntityType)EntityMetadataCache.getDataEntityType((String)srcTableDefine.getEntityNumber());
        HashSet<String> selectFields = new HashSet<String>();
        selectFields.add("id");
        selectFields.add(sourceMainType.getBillNo());
        selectFields.add(srcTableDefine.getEntityKey() + ".id");
        selectFields.add(srcTableDefine.getEntityKey() + ".seq");
        QFilter filter = new QFilter(sourceMainType.getBillNo(), "=", (Object)srcBillNo);
        DynamicObject[] sourceBillObjs = BusinessDataServiceHelper.load((String)srcTableDefine.getEntityNumber(), (String)StringUtils.join((Object[])selectFields.toArray(), (String)","), (QFilter[])new QFilter[]{filter});
        return sourceBillObjs;
    }

    private static void createLinkEntity(TableDefine targetTableDefine, DynamicObject targetBillObj, TableDefine srcTableDefine, DynamicObject[] sourceBillObjs, String srcRowSeqFld) {
        HashMap<Long, Object> srcRowIds = new HashMap<Long, Object>(sourceBillObjs.length);
        for (DynamicObject srcObj : sourceBillObjs) {
            srcRowIds.put((Long)srcObj.get("id"), srcObj.get("id"));
        }
        Long srcTableId = srcTableDefine.getTableId();
        String lkEntryKey = targetTableDefine.getEntityKey() + "_lk";
        DynamicObjectCollection targetRows = targetBillObj.getDynamicObjectCollection(targetTableDefine.getEntityKey());
        for (DynamicObject targetRow : targetRows) {
            DynamicObjectCollection linkRows = targetRow.getDynamicObjectCollection(lkEntryKey);
            if (!linkRows.isEmpty()) continue;
            DynamicObject linkRow = new DynamicObject(linkRows.getDynamicObjectType());
            linkRows.add((Object)linkRow);
            Long srcRowFld = targetRow.getLong(srcRowSeqFld);
            log.info("\u5f55\u5165\u6570\u636e\u5230t_pom_mftorder_tc\u8868\u6570\u636e,srcRowFld:" + srcRowFld);
            if (!srcRowIds.containsKey(srcRowFld)) continue;
            linkRow.set(lkEntryKey + "_sbillid", (Object)srcRowFld);
            linkRow.set(lkEntryKey + "_sid", (Object)srcRowFld);
            linkRow.set(lkEntryKey + "_stableid", (Object)srcTableId);
        }
    }
}

