/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mps.common.util;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Field;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.mmc.mps.common.util.MPSScheduleUtils;
import kd.mpscmm.msplan.mservice.service.datafetch.model.FetchDataQueryModule;
import kd.mpscmm.msplan.mservice.service.datafetch.util.DataSourceFetchDataUtil;
import org.apache.commons.lang3.time.DateUtils;

public class ReportQueryUtils {
    private static final Log log = LogFactory.getLog(ReportQueryUtils.class);

    public static Map<Long, Map<Long, Map<Long, BigDecimal>>> getResoureQty(List<Map<String, Object>> resoureDataMessage, Map<Long, Object[]> planWorkCenter, Date filterbeginDate, Date filterEndDate, Map<Long, BigDecimal> workshiftTime, Map<Long, Map<Long, String>> workcenterToworkDayByRange, Map<Long, Map<Long, BigDecimal>> workCenterToresourceToQty) {
        HashMap<Long, Map<Long, Map<Long, BigDecimal>>> workCenterToDateResoureQty = new HashMap<Long, Map<Long, Map<Long, BigDecimal>>>(16);
        for (Map.Entry<Long, Object[]> mapEntry : planWorkCenter.entrySet()) {
            Long workcenterId = mapEntry.getKey();
            for (Map<String, Object> map : resoureDataMessage) {
                Date startdate = filterbeginDate;
                Date enddate = filterEndDate;
                Object workcenter = map.get("workcenter");
                Object resource = map.get("resource");
                if (resource == null) {
                    resource = 0L;
                }
                if (!workcenterId.equals(workcenter)) continue;
                Object resouceqty = map.get("resouceqty");
                Map<Long, String> workDayByRange = workcenterToworkDayByRange.get(workcenter);
                if (workDayByRange == null) continue;
                while (!enddate.before(startdate)) {
                    Long starttime = startdate.getTime();
                    String s = workDayByRange.get(starttime);
                    if (!"4".equals(s)) {
                        Map<Long, BigDecimal> res;
                        Map<Long, BigDecimal> resourceToQty;
                        BigDecimal resouceqty_all;
                        BigDecimal time;
                        Object[] objects;
                        HashMap dateResoureQty = (HashMap)workCenterToDateResoureQty.get(workcenterId);
                        if (dateResoureQty != null) {
                            objects = planWorkCenter.get(workcenterId);
                            time = workshiftTime.get(objects[0]);
                            resouceqty_all = time.multiply(BigDecimal.valueOf(3600L));
                            if (resouceqty instanceof Integer && (Integer)resouceqty != 0) {
                                resourceToQty = workCenterToresourceToQty.get(workcenterId);
                                if (resourceToQty == null) {
                                    resourceToQty = new HashMap<Long, BigDecimal>(16);
                                    resourceToQty.put((Long)resource, new BigDecimal(resouceqty.toString()));
                                    workCenterToresourceToQty.put(workcenterId, resourceToQty);
                                } else if (!resourceToQty.containsKey(resource)) {
                                    resourceToQty.put((Long)resource, new BigDecimal(resouceqty.toString()));
                                }
                                resouceqty_all = new BigDecimal(resouceqty.toString()).multiply(resouceqty_all);
                            }
                            res = new HashMap<Long, BigDecimal>(16);
                            if (dateResoureQty.containsKey(starttime)) {
                                res = (Map)dateResoureQty.get(starttime);
                            }
                            res.put((Long)resource, resouceqty_all);
                            dateResoureQty.put(starttime, res);
                        } else {
                            dateResoureQty = new HashMap(16);
                            workCenterToDateResoureQty.put(workcenterId, dateResoureQty);
                            objects = planWorkCenter.get(workcenterId);
                            time = workshiftTime.get(objects[0]);
                            resouceqty_all = time.multiply(BigDecimal.valueOf(3600L));
                            if (resouceqty instanceof Integer && (Integer)resouceqty != 0) {
                                resouceqty_all = new BigDecimal(resouceqty.toString()).multiply(resouceqty_all);
                                resourceToQty = workCenterToresourceToQty.get(workcenterId);
                                if (resourceToQty == null) {
                                    resourceToQty = new HashMap<Long, BigDecimal>(16);
                                    workCenterToresourceToQty.put(workcenterId, resourceToQty);
                                    if (!resourceToQty.containsKey(resource)) {
                                        resourceToQty.put((Long)resource, new BigDecimal(resouceqty.toString()));
                                    }
                                }
                            }
                            res = new HashMap(16);
                            res.put((Long)resource, resouceqty_all);
                            dateResoureQty.put(starttime, res);
                        }
                    }
                    startdate = DateUtils.addDays((Date)startdate, (int)1);
                }
            }
        }
        return workCenterToDateResoureQty;
    }

    public static Map<Long, Object[]> getPlanWorkCenter(DynamicObject queryplan, Map<Long, BigDecimal> workshiftTime, StringBuilder tipMessage) {
        HashMap<Long, Object[]> workCenterToMessage = new HashMap<Long, Object[]>(16);
        DynamicObject workcenter = BusinessDataServiceHelper.loadSingle((String)"mps_proplanschdef", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)queryplan.getLong("id"))});
        DynamicObjectCollection workentrys = workcenter.getDynamicObjectCollection("workentry");
        ArrayList<Long> workshiftList = new ArrayList<Long>(16);
        ArrayList<Long> workcalendarList = new ArrayList<Long>(16);
        HashMap<Long, String> workcenterMap = new HashMap<Long, String>(16);
        for (Object workentry : workentrys) {
            BigDecimal classsystemtime;
            Long workshiftId;
            DynamicObject workshift_work;
            Long workcenterId = workentry.getDynamicObject("workcenter").getLong("id");
            String workcenternumber = workentry.getDynamicObject("workcenter").getString("number");
            workcenterMap.put(workcenterId, workcenternumber);
            Object[] objects = new Object[3];
            BigDecimal effect = BigDecimal.ONE;
            if (workentry.get("effect") != null && workentry.getBigDecimal("effect").compareTo(BigDecimal.ZERO) > 0) {
                effect = workentry.getBigDecimal("effect");
            }
            objects[2] = effect;
            if (workentry.get("workshift_work") != null) {
                workshift_work = workentry.getDynamicObject("workshift_work");
                workshiftId = workshift_work.getLong("id");
                classsystemtime = workshift_work.getBigDecimal("classsystemtime");
                classsystemtime = classsystemtime.multiply(effect);
                objects[0] = workshiftId;
                workshiftTime.put(workshiftId, classsystemtime);
            } else {
                workshift_work = workcenter.getDynamicObject("workshift");
                if (workshift_work != null) {
                    workshiftId = workshift_work.getLong("id");
                    classsystemtime = workshift_work.getBigDecimal("classsystemtime");
                    classsystemtime = classsystemtime.multiply(effect);
                    objects[0] = workshiftId;
                    workshiftTime.put(workshiftId, classsystemtime);
                }
            }
            workshiftList.add((Long)objects[0]);
            if (workentry.get("workcalendar") != null) {
                objects[1] = workentry.getDynamicObject("workcalendar").getLong("id");
            } else {
                DynamicObject calendar = workcenter.getDynamicObject("calendar");
                if (calendar == null) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u751f\u4ea7\u65e5\u5386\u4e3a\u7a7a\u3002", (String)"SchedulePlanErrors_20", (String)"mmc-mps-common", (Object[])new Object[0]));
                }
                objects[1] = calendar.getLong("id");
            }
            workcalendarList.add((Long)objects[1]);
            workCenterToMessage.put(workcenterId, objects);
        }
        DynamicObjectCollection query_workshift = QueryServiceHelper.query((String)"mpdm_classsystem", (String)"id", (QFilter[])new QFilter[]{new QFilter("id", "in", workshiftList).and("enable", "=", (Object)"1").and("status", "=", (Object)"C")});
        workshiftList.clear();
        for (DynamicObject dynamicObject : query_workshift) {
            workshiftList.add(dynamicObject.getLong("id"));
        }
        DynamicObjectCollection query_calendar = QueryServiceHelper.query((String)"mpdm_calendar", (String)"id", (QFilter[])new QFilter[]{new QFilter("id", "in", workcalendarList).and("enable", "=", (Object)"1").and("status", "=", (Object)"C")});
        workcalendarList.clear();
        for (DynamicObject dynamicObject : query_calendar) {
            workcalendarList.add(dynamicObject.getLong("id"));
        }
        for (Map.Entry mapEntry : workCenterToMessage.entrySet()) {
            Long workcenterId = (Long)mapEntry.getKey();
            Object[] value = (Object[])mapEntry.getValue();
            if (!workshiftList.contains(value[0])) {
                tipMessage.append(ResManager.loadKDString((String)"\u73ed\u5236\u5b58\u5728\u4e0d\u53ef\u7528\u6216\u8005\u6682\u5b58\u7684\u6570\u636e", (String)"CapacityScheduReportQuery_19", (String)"mmc-mps-report", (Object[])new Object[0])).append("\n");
                value[0] = null;
            }
            if (workcalendarList.contains(value[1])) continue;
            tipMessage.append(ResManager.loadKDString((String)"\u5de5\u4f5c\u4e2d\u5fc3:", (String)"CapacityScheduReportQuery_21", (String)"mmc-mps-report", (Object[])new Object[0])).append((String)workcenterMap.get(workcenterId)).append("  ").append(ResManager.loadKDString((String)"\u751f\u4ea7\u65e5\u5386\u5b58\u5728\u4e0d\u53ef\u7528\u6216\u8005\u6682\u5b58\u7684\u6570\u636e", (String)"CapacityScheduReportQuery_20", (String)"mmc-mps-report", (Object[])new Object[0])).append("\n");
            value[1] = null;
        }
        return workCenterToMessage;
    }

    public static List<Map<String, Object>> getRoute(List<Map<String, Object>> dataMessage, DynamicObject org, Map<Long, List<Map<String, Object>>> routeId, StringBuilder tipMessage, Map<Long, Object[]> routeIdToDateRange) {
        ArrayList<Map<String, Object>> dataMessage_all = new ArrayList<Map<String, Object>>(16);
        if (dataMessage.size() == 0) {
            return dataMessage_all;
        }
        HashSet<Long> materialList = new HashSet<Long>(16);
        ArrayList<Long> productionversionList = new ArrayList<Long>(16);
        ArrayList<Map<String, Object>> dataMessage_material = new ArrayList<Map<String, Object>>(16);
        ArrayList<Map<String, Object>> dataMessage_productionversion = new ArrayList<Map<String, Object>>(16);
        ArrayList<Map<String, Object>> dataMessage_mservice = new ArrayList<Map<String, Object>>(16);
        ArrayList<Map<String, Object>> dataMessage_exception = new ArrayList<Map<String, Object>>(16);
        Long getOrderRouteBeginTime = TimeServiceHelper.now().getTime();
        log.info("getOrderRouteBeginTime" + getOrderRouteBeginTime);
        ReportQueryUtils.getOrderRoute(productionversionList, dataMessage, dataMessage_mservice, dataMessage_all, dataMessage_productionversion, routeId, routeIdToDateRange, tipMessage);
        Long getOrderRouteEndTime = TimeServiceHelper.now().getTime();
        log.info("getOrderRouteEndTime" + (getOrderRouteEndTime - getOrderRouteBeginTime));
        ReportQueryUtils.getOrderProductionversionRoute(productionversionList, dataMessage_mservice, dataMessage_all, dataMessage_productionversion, routeId, routeIdToDateRange, tipMessage);
        Long getOrderProductionversionRouteBegin = TimeServiceHelper.now().getTime();
        log.info("getOrderProductionversionRouteBegin" + (getOrderProductionversionRouteBegin - getOrderRouteBeginTime));
        ReportQueryUtils.getMserviceRoute(dataMessage_all, dataMessage_mservice, dataMessage_material, routeId, org.getLong("id"));
        Long getMserviceRouteEnd = TimeServiceHelper.now().getTime();
        log.info("getMserviceRouteEnd" + (getMserviceRouteEnd - getOrderProductionversionRouteBegin));
        ReportQueryUtils.getRouteByMaterial(dataMessage_material, dataMessage_all, materialList, org, dataMessage_exception, routeId, tipMessage, routeIdToDateRange);
        log.info("getRouteByMaterialEnd" + (TimeServiceHelper.now().getTime() - getMserviceRouteEnd));
        return dataMessage_all;
    }

    public static Map<Long, List<Long>> getMeasureunitconv(Map<String, BigDecimal> convToCoeff, Map<String, Long> baseTimeMap) {
        HashMap<Long, List<Long>> convMap = new HashMap<Long, List<Long>>(16);
        Map measureunitconv = BusinessDataServiceHelper.loadFromCache((String)"bd_measureunitconv", (QFilter[])new QFilter[]{new QFilter("id", "!=", (Object)0L)});
        for (DynamicObject dynamicObject : measureunitconv.values()) {
            ArrayList<Long> desmuidList;
            DynamicObject srcmuidDyn = dynamicObject.getDynamicObject("srcmuid");
            DynamicObject desmuidDyn = dynamicObject.getDynamicObject("desmuid");
            Long srcmuid = srcmuidDyn.getLong("id");
            Long desmuid = desmuidDyn.getLong("id");
            String srcmuNumber = srcmuidDyn.getString("number");
            String desmuNumber = desmuidDyn.getString("number");
            if (("hour".equals(srcmuNumber) || "minute".equals(srcmuNumber) || "second".equals(srcmuNumber)) && !baseTimeMap.containsKey(srcmuNumber)) {
                baseTimeMap.put(srcmuNumber, srcmuid);
            }
            if (("hour".equals(desmuNumber) || "minute".equals(desmuNumber) || "second".equals(desmuNumber)) && !baseTimeMap.containsKey(desmuNumber)) {
                baseTimeMap.put(desmuNumber, desmuid);
            }
            BigDecimal numerator = dynamicObject.getBigDecimal("numerator");
            String convKey = srcmuid + "," + desmuid;
            convToCoeff.put(convKey, numerator);
            if (convMap.containsKey(srcmuid)) {
                desmuidList = (ArrayList<Long>)convMap.get(srcmuid);
                desmuidList.add(desmuid);
                continue;
            }
            desmuidList = new ArrayList<Long>(16);
            desmuidList.add(desmuid);
            convMap.put(srcmuid, desmuidList);
        }
        return convMap;
    }

    public static void saveCapacityloadDataToBack(List<Map<String, Object>> dataMessageByReport, DynamicObject queryplan, Map<Long, Object[]> planWorkCenter) {
        ORM orm = ORM.create();
        ArrayList<DynamicObject> dnyList = new ArrayList<DynamicObject>(16);
        int delete = DeleteServiceHelper.delete((String)"mps_capacityload", (QFilter[])new QFilter[]{new QFilter("scheduleplan.number", "=", (Object)queryplan.getString("number"))});
        for (Map<String, Object> map : dataMessageByReport) {
            Object workcentre = map.get("workcentre");
            if (workcentre != null && (Long)workcentre != 0L && !planWorkCenter.containsKey(workcentre)) continue;
            DynamicObject capacityload = ReportQueryUtils.getDyn(orm, "mps_capacityload");
            capacityload.set("billtype", (Object)"A");
            capacityload.set("org", map.get("org"));
            capacityload.set("sourcetype", map.get("sourcebilltype"));
            capacityload.set("sourcebillid", map.get("sourcebillid_old"));
            capacityload.set("sourcebillentryno", map.get("entryseq"));
            capacityload.set("materiel_code", map.get("materiel"));
            capacityload.set("configure", map.get("configurecode"));
            capacityload.set("tracknumber", map.get("tracknumber"));
            capacityload.set("auxiliary", map.get("auxiliary"));
            capacityload.set("workcenter", map.get("workcentre"));
            capacityload.set("requirenum", map.get("orderqty"));
            capacityload.set("requiredate", map.get("demanddate"));
            capacityload.set("billno", map.get("sourcebillno"));
            capacityload.set("group", map.get("group"));
            capacityload.set("sourcebillentryid", map.get("sourceentryid"));
            capacityload.set("creater", (Object)RequestContext.getOrCreate().getCurrUserId());
            capacityload.set("createdate", (Object)TimeServiceHelper.now());
            capacityload.set("scheduleplan", (Object)queryplan.getLong("id"));
            dnyList.add(capacityload);
        }
        for (Map<String, Object> map : dataMessageByReport) {
            DynamicObject capacityload = ReportQueryUtils.getDyn(orm, "mps_capacityload");
            Object workcentre = map.get("workcentre");
            if (workcentre != null && (Long)workcentre != 0L && !planWorkCenter.containsKey(workcentre)) continue;
            capacityload.set("workcenter", map.get("workcenter"));
            capacityload.set("billtype", (Object)"B");
            capacityload.set("org", map.get("production_org"));
            capacityload.set("sourcebillid", map.get("sourcebillid"));
            capacityload.set("sourcebillentryid", map.get("sourceentryid"));
            capacityload.set("sourcebillentryno", map.get("sourcebillentryno"));
            capacityload.set("materiel_code", map.get("materiel_code"));
            capacityload.set("configure", map.get("configure"));
            capacityload.set("tracknumber", map.get("tracknumber"));
            capacityload.set("auxiliary", map.get("auxiliary"));
            capacityload.set("workcenter", map.get("workcenter"));
            capacityload.set("requirenum", map.get("plsqty"));
            capacityload.set("requiredate", map.get("pls_date"));
            capacityload.set("billno", map.get("billno"));
            capacityload.set("group", map.get("group"));
            capacityload.set("creater", (Object)RequestContext.getOrCreate().getCurrUserId());
            capacityload.set("createdate", (Object)TimeServiceHelper.now());
            capacityload.set("scheduleplan", (Object)queryplan.getLong("id"));
            dnyList.add(capacityload);
        }
        if (dnyList.size() != 0) {
            SaveServiceHelper.save((DynamicObject[])dnyList.toArray(new DynamicObject[0]));
        }
    }

    private static DynamicObject getDyn(ORM orm, String sign) {
        DynamicObject capacityload = orm.newDynamicObject(sign);
        return capacityload;
    }

    public static void saveCapaDataToBack(Map<Long, Map<Date, BigDecimal>> capacityMessage, DynamicObject org, Map<Long, Long> groupToWorkcenter, DynamicObject queryplan, Map<Long, Map<Integer, Map<Integer, Map<String, Object>>>> signToData, Date filterbeginDate, Date filterEndDate, Map<Long, Map<Long, Map<Date, BigDecimal>>> workcenterGroupcapacityMessage) {
        ORM orm = ORM.create();
        ArrayList<DynamicObject> dnyList = new ArrayList<DynamicObject>(16);
        if (capacityMessage != null && capacityMessage.size() != 0 || workcenterGroupcapacityMessage != null && workcenterGroupcapacityMessage.size() != 0) {
            Long workcenterId;
            int delete = DeleteServiceHelper.delete((String)"mps_availablecapacity", (QFilter[])new QFilter[]{new QFilter("scheduleplan.number", "=", (Object)queryplan.getString("number"))});
            for (Map.Entry<Long, Map<Integer, Map<Integer, Map<String, Object>>>> entry : signToData.entrySet()) {
                workcenterId = entry.getKey();
                Map<Date, BigDecimal> dateTocapacity = capacityMessage.get(workcenterId);
                Map<Long, Map<Date, BigDecimal>> groupdateTocapacity = workcenterGroupcapacityMessage.get(workcenterId);
                if (dateTocapacity == null && groupdateTocapacity == null || dateTocapacity == null) continue;
                for (Map.Entry<Date, BigDecimal> capaEntry : dateTocapacity.entrySet()) {
                    Date capacityDate = capaEntry.getKey();
                    if (capacityDate.before(filterbeginDate) || capacityDate.after(filterEndDate)) continue;
                    DynamicObject availableCapacity = ReportQueryUtils.getDyn(orm, "mps_availablecapacity");
                    availableCapacity.set("workcenter", (Object)workcenterId);
                    availableCapacity.set("org", (Object)org);
                    availableCapacity.set("date", (Object)capaEntry.getKey());
                    availableCapacity.set("daycapa", (Object)capaEntry.getValue());
                    availableCapacity.set("creater", (Object)RequestContext.getOrCreate().getCurrUserId());
                    availableCapacity.set("createdate", (Object)TimeServiceHelper.now());
                    availableCapacity.set("scheduleplan", (Object)queryplan.getLong("id"));
                    dnyList.add(availableCapacity);
                }
            }
            for (Map.Entry<Long, Map<Number, Map<Comparable<Integer>, Object>>> entry : workcenterGroupcapacityMessage.entrySet()) {
                workcenterId = entry.getKey();
                Map<Number, Map<Comparable<Integer>, Object>> groupdateTocapacity = entry.getValue();
                if (groupdateTocapacity == null) continue;
                for (Map.Entry<Number, Map<Comparable<Integer>, Object>> groupcapaEntry : groupdateTocapacity.entrySet()) {
                    Long group = (Long)groupcapaEntry.getKey();
                    Map<Comparable<Integer>, Object> dateTocapacity_group = groupcapaEntry.getValue();
                    for (Map.Entry<Comparable<Integer>, Object> capaEntry : dateTocapacity_group.entrySet()) {
                        Date capacityDate = (Date)capaEntry.getKey();
                        if (capacityDate.before(filterbeginDate) || capacityDate.after(filterEndDate)) continue;
                        DynamicObject availableCapacity = ReportQueryUtils.getDyn(orm, "mps_availablecapacity");
                        availableCapacity.set("workcenter", (Object)workcenterId);
                        availableCapacity.set("org", (Object)org);
                        availableCapacity.set("group", (Object)group);
                        availableCapacity.set("date", capaEntry.getKey());
                        availableCapacity.set("daycapa", capaEntry.getValue());
                        availableCapacity.set("creater", (Object)RequestContext.getOrCreate().getCurrUserId());
                        availableCapacity.set("createdate", (Object)TimeServiceHelper.now());
                        availableCapacity.set("scheduleplan", (Object)queryplan.getLong("id"));
                        dnyList.add(availableCapacity);
                    }
                }
            }
        }
        if (dnyList.size() != 0) {
            SaveServiceHelper.save((DynamicObject[])dnyList.toArray(new DynamicObject[0]));
        }
    }

    public static void putCapaDataToSignData(Map<Long, Map<Integer, Map<Integer, Map<String, Object>>>> signToData_new, Map<Long, Map<Integer, Map<Integer, Map<String, Object>>>> signToData) {
        for (Map.Entry<Long, Map<Integer, Map<Integer, Map<String, Object>>>> mapEntry : signToData_new.entrySet()) {
            Long workcenterId = mapEntry.getKey();
            Map<Integer, Map<Integer, Map<String, Object>>> yearToValueMessage_new = mapEntry.getValue();
            if (!signToData.containsKey(workcenterId)) continue;
            Map<Integer, Map<Integer, Map<String, Object>>> yearToValueMessage = signToData.get(workcenterId);
            for (Map.Entry<Integer, Map<Integer, Map<String, Object>>> entry_year : yearToValueMessage_new.entrySet()) {
                Integer year = entry_year.getKey();
                Map<Integer, Map<String, Object>> valueMessage_new = entry_year.getValue();
                if (!yearToValueMessage.containsKey(year)) continue;
                Map<Integer, Map<String, Object>> valueMessage = yearToValueMessage.get(year);
                valueMessage.putAll(valueMessage_new);
            }
        }
    }

    public static Map<Long, Map<Integer, Map<Long, Map<Integer, Map<String, Object>>>>> putaAllResourceDateToSignData(Map<Long, Map<Long, Map<Long, BigDecimal>>> resoureQty, Map<Long, Map<Integer, Map<Long, Map<Integer, Map<String, Object>>>>> signToData, String cycle, Map<Integer, Map<Integer, String>> dayToDate, Date filterbeginDate, Date filterEndDate, Map<Long, Map<Long, String>> workcenterToworkDayByRange, Map<Long, Object[]> planWorkCenter, Map<Long, BigDecimal> workshiftTime, Map<Integer, Map<Integer, String>> yearToWeekTorange) {
        HashMap<Long, Map<Integer, Map<Long, Map<Integer, Map<String, Object>>>>> capaData = new HashMap<Long, Map<Integer, Map<Long, Map<Integer, Map<String, Object>>>>>(16);
        for (Map.Entry<Long, Map<Integer, Map<Long, Map<Integer, Map<String, Object>>>>> mapEntry : signToData.entrySet()) {
            Map<Integer, Map<Long, Map<Integer, Map<String, Object>>>> mapEntryValue_mapmap = mapEntry.getValue();
            Long workcenterId = mapEntry.getKey();
            Object[] objects = planWorkCenter.get(workcenterId);
            BigDecimal time = workshiftTime.get(objects[0]);
            Map<Long, Map<Long, BigDecimal>> dateResourceCapacity = resoureQty.get(workcenterId);
            BigDecimal resouceqty_all = time.multiply(BigDecimal.valueOf(3600L));
            if (!workcenterToworkDayByRange.containsKey(workcenterId)) continue;
            Map<Long, String> workDayByRange = workcenterToworkDayByRange.get(workcenterId);
            for (Map.Entry<Integer, Map<Long, Map<Integer, Map<String, Object>>>> mapEntryValue_map : mapEntryValue_mapmap.entrySet()) {
                Map<Long, Map<Integer, Map<String, Object>>> mapEntryValue = mapEntryValue_map.getValue();
                Integer year = mapEntryValue_map.getKey();
                for (Map.Entry<Long, Map<Integer, Map<String, Object>>> mapEntry_messages : mapEntryValue.entrySet()) {
                    Long resoureId = mapEntry_messages.getKey();
                    HashMap<Integer, Map<String, Object>> mapEntry_message_new = new HashMap<Integer, Map<String, Object>>(16);
                    Map<Integer, Map<String, Object>> mapEntry_message = mapEntry_messages.getValue();
                    Date startdate = filterbeginDate;
                    Date enddate = filterEndDate;
                    while (!enddate.before(startdate) && workDayByRange != null) {
                        String s = workDayByRange.get(startdate.getTime());
                        if (!"4".equals(s)) {
                            int dateKey = ReportQueryUtils.getDateKey(startdate, cycle, dayToDate, yearToWeekTorange);
                            Map<String, Object> map = mapEntry_message.get(dateKey);
                            Map<Long, BigDecimal> resourceCapacity = dateResourceCapacity.get(startdate.getTime());
                            if (resoureId == 0L && dateResourceCapacity != null) {
                                if (resourceCapacity == null) {
                                    resourceCapacity = new HashMap<Long, BigDecimal>(16);
                                    dateResourceCapacity.put(startdate.getTime(), resourceCapacity);
                                    resourceCapacity.put(0L, resouceqty_all);
                                } else if (!resourceCapacity.containsKey(0L)) {
                                    resourceCapacity.put(0L, resouceqty_all);
                                }
                            }
                            if (resoureId == 0L) {
                                if (map == null) {
                                    Map map_new = (Map)mapEntry_message_new.get(dateKey);
                                    if (map_new == null) {
                                        if (year.equals(startdate.getYear() + 1900)) {
                                            map = new HashMap<String, Object>(16);
                                            mapEntry_message_new.put(dateKey, map);
                                            map.put("actresource", 0L);
                                            map.put("cycle_r", cycle);
                                            map.put("year", startdate.getYear() + 1900);
                                            map.put("ratecapacity", resouceqty_all);
                                            map.put("workcenter_r", workcenterId);
                                        }
                                    } else {
                                        BigDecimal allCapacity = resouceqty_all;
                                        Object ratecapacity = map_new.get("ratecapacity");
                                        if (ratecapacity != null) {
                                            allCapacity = resouceqty_all.add((BigDecimal)ratecapacity);
                                        }
                                        map_new.put("ratecapacity", allCapacity);
                                    }
                                }
                            } else if (map == null) {
                                map = new HashMap<String, Object>(16);
                                if (resourceCapacity != null && resourceCapacity.containsKey(resoureId) && year.equals(startdate.getYear() + 1900)) {
                                    map.put("actresource", resoureId);
                                    map.put("cycle_r", cycle);
                                    map.put("year", startdate.getYear() + 1900);
                                    map.put("ratecapacity", resourceCapacity.get(resoureId));
                                    map.put("workcenter_r", workcenterId);
                                    mapEntry_message.put(dateKey, map);
                                }
                            }
                        }
                        startdate = DateUtils.addDays((Date)startdate, (int)1);
                    }
                    mapEntry_message.putAll(mapEntry_message_new);
                }
            }
        }
        return capaData;
    }

    public static Map<Long, Map<Integer, Map<Integer, Map<String, Object>>>> putaAllQueryDateToSignData(Map<Long, Map<Date, BigDecimal>> capacityMessage, Map<Long, Map<Integer, Map<Integer, Map<String, Object>>>> signToData, Map<Integer, Map<Integer, String>> dayToDate, String cycle, Date filterbeginDate, Date filterEndDate, Map<Integer, Map<Integer, String>> yearToWeekTorange) {
        HashMap<Long, Map<Integer, Map<Integer, Map<String, Object>>>> capaData = new HashMap<Long, Map<Integer, Map<Integer, Map<String, Object>>>>(16);
        for (Map.Entry<Long, Map<Integer, Map<Integer, Map<String, Object>>>> mapEntry : signToData.entrySet()) {
            Long workcenterId = mapEntry.getKey();
            Map<Date, BigDecimal> dateTocapacity = capacityMessage.get(workcenterId);
            if (dateTocapacity == null) continue;
            for (Map.Entry<Date, BigDecimal> mapEntry_dateTocapacity : dateTocapacity.entrySet()) {
                Map<String, String> message;
                HashMap<Integer, Map<Integer, Map<String, String>>> yearValueMap;
                Date capacityDate = mapEntry_dateTocapacity.getKey();
                if (capacityDate.before(filterbeginDate) || capacityDate.after(filterEndDate)) continue;
                int year = capacityDate.getYear() + 1900;
                int value = "mon".equals(cycle) ? capacityDate.getMonth() + 1 : ("wek".equals(cycle) ? ReportQueryUtils.calculateWeek(capacityDate, yearToWeekTorange) : ("qua".equals(cycle) ? capacityDate.getMonth() / 3 + 1 : ReportQueryUtils.calculateDay(capacityDate, dayToDate)));
                Map<Integer, Map<Integer, Map<String, Object>>> mapEntryValue = mapEntry.getValue();
                Map<Integer, Map<String, Object>> valueToMessage = mapEntryValue.get(year);
                if (valueToMessage == null || valueToMessage.containsKey(value)) continue;
                if (capaData.containsKey(workcenterId)) {
                    Map<Integer, Map<String, String>> valueMessage;
                    yearValueMap = (HashMap<Integer, Map<Integer, Map<String, String>>>)capaData.get(workcenterId);
                    if (yearValueMap.containsKey(year)) {
                        valueMessage = (Map)yearValueMap.get(year);
                        if (valueMessage.containsKey(value)) {
                            message = (Map)valueMessage.get(value);
                            BigDecimal allCapa = BigDecimal.ZERO;
                            if (message.get("ratecapacity") != null) {
                                allCapa = (BigDecimal)message.get("ratecapacity");
                            }
                            message.put("cycle_r", cycle);
                            message.put("year", (String)((Object)Integer.valueOf(year)));
                            message.put("ratecapacity", (String)((Object)allCapa.add(mapEntry_dateTocapacity.getValue())));
                            message.put("workcenter_r", (String)((Object)workcenterId));
                            continue;
                        }
                        message = new HashMap(16);
                        message.put("cycle_r", cycle);
                        message.put("year", (String)((Object)Integer.valueOf(year)));
                        message.put("ratecapacity", (String)((Object)mapEntry_dateTocapacity.getValue()));
                        message.put("workcenter_r", (String)((Object)workcenterId));
                        valueMessage.put(value, message);
                        continue;
                    }
                    valueMessage = new HashMap(16);
                    yearValueMap.put(year, valueMessage);
                    message = new HashMap(16);
                    message.put("cycle_r", cycle);
                    message.put("year", (String)((Object)Integer.valueOf(year)));
                    message.put("ratecapacity", (String)((Object)mapEntry_dateTocapacity.getValue()));
                    message.put("workcenter_r", (String)((Object)workcenterId));
                    valueMessage.put(value, message);
                    continue;
                }
                yearValueMap = new HashMap<Integer, Map<Integer, Map<String, String>>>(16);
                capaData.put(workcenterId, yearValueMap);
                HashMap<Integer, Map<String, String>> valueToMessage_new = new HashMap<Integer, Map<String, String>>(16);
                yearValueMap.put(year, valueToMessage_new);
                message = new HashMap(16);
                valueToMessage_new.put(value, message);
                message.put("cycle_r", cycle);
                message.put("year", (String)((Object)Integer.valueOf(year)));
                message.put("ratecapacity", (String)((Object)mapEntry_dateTocapacity.getValue()));
                message.put("workcenter_r", (String)((Object)workcenterId));
            }
        }
        return capaData;
    }

    public static DataSet getResoureData(DynamicObject queryplan) {
        Set<Long> orderModelId = ReportQueryUtils.getOrderModelId(queryplan, "resoure");
        DataSet orderDataset = ReportQueryUtils.getOrderDataset(orderModelId);
        if (orderDataset != null) {
            return orderDataset;
        }
        return null;
    }

    public static void putExitResourceToMap(Map<Long, Map<Integer, Map<Long, Map<Integer, Map<String, Object>>>>> signToData, Map<Long, Map<Long, Map<Long, BigDecimal>>> resoureQty, Map<Integer, Map<Integer, String>> dayToDate, Map<Long, BigDecimal> workshiftTime, Map<Long, Object[]> planWorkCenter, Map<Long, Map<Long, String>> workcenterToworkDayByRange, String cycle, Date filterbeginDate, Date filterEndDate, Map<Long, Map<Long, BigDecimal>> workcenterToresourceToQty, Map<Integer, Map<Integer, String>> yearToWeekTorange) {
        log.info("signToData" + signToData.toString());
        for (Map.Entry<Long, Map<Integer, Map<Long, Map<Integer, Map<String, Object>>>>> mapEntry : signToData.entrySet()) {
            Map<Integer, Map<Long, Map<Integer, Map<String, Object>>>> mapEntryValue_mapmap = mapEntry.getValue();
            Long workcenterId = mapEntry.getKey();
            Object[] objects = planWorkCenter.get(workcenterId);
            BigDecimal time = workshiftTime.get(objects[0]);
            Map<Long, Map<Long, BigDecimal>> dateResourceCapacity = resoureQty.get(workcenterId);
            BigDecimal resouceqty_all = time.multiply(BigDecimal.valueOf(3600L));
            Map<Long, String> workDayByRange = workcenterToworkDayByRange.get(workcenterId);
            if (workDayByRange == null) continue;
            for (Map.Entry<Integer, Map<Long, Map<Integer, Map<String, Object>>>> mapEntryValue_map : mapEntryValue_mapmap.entrySet()) {
                Map<Long, Map<Integer, Map<String, Object>>> mapEntryValue = mapEntryValue_map.getValue();
                int year = mapEntryValue_map.getKey();
                for (Map.Entry<Long, Map<Integer, Map<String, Object>>> mapEntry_messages : mapEntryValue.entrySet()) {
                    Long resoureId = mapEntry_messages.getKey();
                    Map<Integer, Map<String, Object>> mapEntry_message = mapEntry_messages.getValue();
                    Date startdate = filterbeginDate;
                    Date enddate = filterEndDate;
                    while (!enddate.before(startdate)) {
                        Long starttime = startdate.getTime();
                        String s = workDayByRange.get(starttime);
                        int staryear = startdate.getYear() + 1900;
                        if (!"4".equals(s)) {
                            int dateKey = ReportQueryUtils.getDateKey(startdate, cycle, dayToDate, yearToWeekTorange);
                            if (staryear == year) {
                                Map<String, Object> map = mapEntry_message.get(dateKey);
                                if (map != null) {
                                    BigDecimal allCapacity = BigDecimal.ZERO;
                                    if (dateResourceCapacity != null) {
                                        Map<Long, BigDecimal> resourceCapacity = dateResourceCapacity.get(starttime);
                                        if (resourceCapacity != null) {
                                            BigDecimal bigDecimal = resourceCapacity.get(resoureId);
                                            allCapacity = bigDecimal != null ? bigDecimal : (resoureId.equals(0L) ? resouceqty_all : BigDecimal.ZERO);
                                        }
                                    } else {
                                        allCapacity = resoureId.equals(0L) ? resouceqty_all : BigDecimal.ZERO;
                                    }
                                    Object ratecapacity = map.get("ratecapacity");
                                    if (ratecapacity != null) {
                                        allCapacity = allCapacity.add((BigDecimal)ratecapacity);
                                    }
                                    map.put("ratecapacity", allCapacity);
                                } else {
                                    map = new HashMap<String, Object>(16);
                                    map.put("actresource", resoureId);
                                    map.put("cycle_r", cycle);
                                    map.put("year", startdate.getYear() + 1900);
                                    BigDecimal resouceqtys = resouceqty_all;
                                    Map<Long, BigDecimal> resourceToQty = workcenterToresourceToQty.get(workcenterId);
                                    if (resoureId != 0L && resourceToQty != null && resourceToQty.containsKey(resoureId)) {
                                        resouceqtys = resouceqty_all.multiply(resourceToQty.get(resoureId));
                                    }
                                    if (resourceToQty == null || !resourceToQty.containsKey(resoureId)) {
                                        resouceqtys = BigDecimal.ZERO;
                                    }
                                    map.put("ratecapacity", resouceqtys);
                                    map.put("workcenter_r", workcenterId);
                                    if (resouceqtys.compareTo(BigDecimal.ZERO) != 0) {
                                        mapEntry_message.put(dateKey, map);
                                    }
                                }
                            }
                        }
                        startdate = DateUtils.addDays((Date)startdate, (int)1);
                    }
                }
            }
        }
    }

    public static void putResourceToMap(Map<Long, Map<Integer, Map<Long, Map<Integer, Map<String, Object>>>>> signToData, Map<Long, Map<Long, Map<Long, BigDecimal>>> resoureQty, Map<Integer, Map<Integer, String>> dayToDate, Map<Long, BigDecimal> workshiftTime, Map<Long, Object[]> planWorkCenter, Map<Long, Map<Long, String>> workcenterToworkDayByRange, String cycle, Date filterbeginDate, Date filterEndDate, Map<Integer, Map<Integer, String>> yearToWeekTorange) {
        log.info("resoureQty" + resoureQty.toString());
        for (Map.Entry<Long, Object[]> mapEntry : planWorkCenter.entrySet()) {
            Long workcenterId = mapEntry.getKey();
            Object[] objects = mapEntry.getValue();
            if (resoureQty.containsKey(workcenterId)) {
                Map<String, Object> message;
                Map<Integer, Map<String, Object>> dateToMessage;
                Long resourceId;
                BigDecimal capacity;
                Map<Long, BigDecimal> resourceCapacity;
                Map<Long, Map<Integer, Map<String, Object>>> resourceDateMessage;
                Date date;
                Long starttime;
                Map<Long, Map<Long, BigDecimal>> dateResourceQty = resoureQty.get(workcenterId);
                Map<Integer, Map<Long, Map<Integer, Map<String, Object>>>> yearResourceDateMessage = signToData.get(workcenterId);
                if (yearResourceDateMessage == null) {
                    yearResourceDateMessage = new HashMap<Integer, Map<Long, Map<Integer, Map<String, Object>>>>(16);
                    signToData.put(workcenterId, yearResourceDateMessage);
                    for (Map.Entry<Long, Map<Long, BigDecimal>> mapEntry_dateTocapacity : dateResourceQty.entrySet()) {
                        starttime = mapEntry_dateTocapacity.getKey();
                        date = new Date(starttime);
                        int dateKey = ReportQueryUtils.getDateKey(date, cycle, dayToDate, yearToWeekTorange);
                        int year = date.getYear() + 1900;
                        resourceDateMessage = yearResourceDateMessage.get(year);
                        if (resourceDateMessage == null) {
                            resourceDateMessage = new HashMap<Long, Map<Integer, Map<String, Object>>>(16);
                            yearResourceDateMessage.put(year, resourceDateMessage);
                            resourceCapacity = mapEntry_dateTocapacity.getValue();
                            for (Map.Entry<Long, BigDecimal> mapEntry_resourceCapacity : resourceCapacity.entrySet()) {
                                capacity = mapEntry_resourceCapacity.getValue();
                                resourceId = mapEntry_resourceCapacity.getKey();
                                dateToMessage = resourceDateMessage.get(resourceId);
                                if (dateToMessage != null) continue;
                                dateToMessage = new HashMap<Integer, Map<String, Object>>(16);
                                resourceDateMessage.put(resourceId, dateToMessage);
                                message = dateToMessage.get(dateKey);
                                if (message != null) continue;
                                message = new HashMap<String, Object>(16);
                                dateToMessage.put(dateKey, message);
                                message.put("actresource", resourceId);
                                message.put("cycle_r", cycle);
                                message.put("year", year);
                                message.put("ratecapacity", capacity);
                                message.put("workcenter_r", workcenterId);
                            }
                            continue;
                        }
                        resourceCapacity = mapEntry_dateTocapacity.getValue();
                        for (Map.Entry<Long, BigDecimal> mapEntry_resourceCapacity : resourceCapacity.entrySet()) {
                            capacity = mapEntry_resourceCapacity.getValue();
                            resourceId = mapEntry_resourceCapacity.getKey();
                            dateToMessage = resourceDateMessage.get(resourceId);
                            if (dateToMessage == null) {
                                dateToMessage = new HashMap<Integer, Map<String, Object>>(16);
                                resourceDateMessage.put(resourceId, dateToMessage);
                                message = dateToMessage.get(dateKey);
                                if (message != null) continue;
                                message = new HashMap<String, Object>(16);
                                dateToMessage.put(dateKey, message);
                                message.put("actresource", resourceId);
                                message.put("cycle_r", cycle);
                                message.put("year", year);
                                message.put("ratecapacity", capacity);
                                message.put("workcenter_r", workcenterId);
                                continue;
                            }
                            message = dateToMessage.get(dateKey);
                            if (message == null) {
                                message = new HashMap<String, Object>(16);
                                dateToMessage.put(dateKey, message);
                                message.put("actresource", resourceId);
                                message.put("cycle_r", cycle);
                                message.put("year", year);
                                message.put("ratecapacity", capacity);
                                message.put("workcenter_r", workcenterId);
                                continue;
                            }
                            BigDecimal allCapacity = resourceCapacity.get(resourceId);
                            Object ratecapacity = message.get("ratecapacity");
                            if (ratecapacity != null) {
                                allCapacity = allCapacity.add(new BigDecimal(ratecapacity.toString()));
                            }
                            message.put("actresource", resourceId);
                            message.put("cycle_r", cycle);
                            message.put("year", year);
                            message.put("ratecapacity", allCapacity);
                            message.put("workcenter_r", workcenterId);
                        }
                    }
                    continue;
                }
                for (Map.Entry<Long, Map<Long, BigDecimal>> mapEntry_dateTocapacity : dateResourceQty.entrySet()) {
                    starttime = mapEntry_dateTocapacity.getKey();
                    date = new Date(starttime);
                    int dateKey = ReportQueryUtils.getDateKey(date, cycle, dayToDate, yearToWeekTorange);
                    int year = date.getYear() + 1900;
                    resourceDateMessage = yearResourceDateMessage.get(year);
                    if (resourceDateMessage == null) continue;
                    resourceCapacity = mapEntry_dateTocapacity.getValue();
                    for (Map.Entry<Long, BigDecimal> mapEntry_resourceCapacity : resourceCapacity.entrySet()) {
                        capacity = mapEntry_resourceCapacity.getValue();
                        resourceId = mapEntry_resourceCapacity.getKey();
                        dateToMessage = resourceDateMessage.get(resourceId);
                        if (dateToMessage == null) {
                            dateToMessage = new HashMap<Integer, Map<String, Object>>(16);
                            resourceDateMessage.put(resourceId, dateToMessage);
                            message = dateToMessage.get(dateKey);
                            if (message != null) continue;
                            message = new HashMap<String, Object>(16);
                            dateToMessage.put(dateKey, message);
                            message.put("actresource", resourceId);
                            message.put("cycle_r", cycle);
                            message.put("year", year);
                            message.put("ratecapacity", capacity);
                            message.put("workcenter_r", workcenterId);
                            continue;
                        }
                        message = dateToMessage.get(dateKey);
                        if (message != null) continue;
                        message = new HashMap<String, Object>(16);
                        dateToMessage.put(dateKey, message);
                        message.put("actresource", resourceId);
                        message.put("cycle_r", cycle);
                        message.put("year", year);
                        message.put("ratecapacity", capacity);
                        message.put("workcenter_r", workcenterId);
                    }
                }
                continue;
            }
            Map<Long, String> workDayByRange = workcenterToworkDayByRange.get(workcenterId);
            Date startdate = filterbeginDate;
            Date enddate = filterEndDate;
            if (workDayByRange == null) continue;
            while (!enddate.before(startdate)) {
                Long starttime = startdate.getTime();
                String s = workDayByRange.get(starttime);
                if (!"4".equals(s)) {
                    HashMap dateResourceQty = new HashMap(16);
                    resoureQty.put(workcenterId, dateResourceQty);
                    BigDecimal time = workshiftTime.get(objects[0]);
                    BigDecimal resouceqty_all = time.multiply(BigDecimal.valueOf(3600L));
                    HashMap<Long, BigDecimal> res = new HashMap<Long, BigDecimal>(16);
                    res.put(0L, resouceqty_all);
                    dateResourceQty.put(starttime, res);
                }
                startdate = DateUtils.addDays((Date)startdate, (int)1);
            }
        }
    }

    public static int getDateKey(Date date, String cycle, Map<Integer, Map<Integer, String>> dayToDate, Map<Integer, Map<Integer, String>> yearToWeekTorange) {
        int dateKey = "mon".equals(cycle) ? date.getMonth() + 1 : ("wek".equals(cycle) ? ReportQueryUtils.calculateWeek(date, yearToWeekTorange) : ("qua".equals(cycle) ? date.getMonth() / 3 + 1 : ReportQueryUtils.calculateDay(date, dayToDate)));
        return dateKey;
    }

    public static void subtractionDownTimePlan_new(Map<String, Map<Long, Map<String, Map<String, Object>>>> downTimePlan, Map<Long, Map<Integer, Map<Long, Map<Integer, Map<String, Object>>>>> signToData, DynamicObject org, String cycle, Map<Integer, Map<Integer, String>> dayToDate, Map<Integer, Map<Integer, String>> yearToWeekTorange) {
        if (downTimePlan == null || downTimePlan.size() == 0) {
            return;
        }
        for (Map.Entry<Long, Map<Integer, Map<Long, Map<Integer, Map<String, Object>>>>> mapEntry : signToData.entrySet()) {
            Map<Integer, Map<Long, Map<Integer, Map<String, Object>>>> mapEntryValue_mapmap = mapEntry.getValue();
            Long workcenterId = mapEntry.getKey();
            for (Map.Entry<Integer, Map<Long, Map<Integer, Map<String, Object>>>> mapEntryValue_map : mapEntryValue_mapmap.entrySet()) {
                Map<Long, Map<Integer, Map<String, Object>>> mapEntryValue = mapEntryValue_map.getValue();
                for (Map.Entry<Long, Map<Integer, Map<String, Object>>> mapEntry_messages : mapEntryValue.entrySet()) {
                    Long resoureId = mapEntry_messages.getKey();
                    Map<Integer, Map<String, Object>> mapEntry_message = mapEntry_messages.getValue();
                    String downKey = workcenterId + "," + resoureId + "," + org.getLong("id");
                    Map<Long, Map<String, Map<String, Object>>> resourceMessage = downTimePlan.get(downKey);
                    if (resourceMessage == null) continue;
                    for (Map.Entry<Long, Map<String, Map<String, Object>>> mapentry : resourceMessage.entrySet()) {
                        Long time = mapentry.getKey();
                        Map<String, Map<String, Object>> detailMessage = mapentry.getValue();
                        int dateKey = ReportQueryUtils.getDateKey(new Date(time), cycle, dayToDate, yearToWeekTorange);
                        Map<String, Object> map = mapEntry_message.get(dateKey);
                        if (map == null) continue;
                        Object ratecapacity = map.get("ratecapacity");
                        BigDecimal allCapatity = BigDecimal.ZERO;
                        if (ratecapacity != null) {
                            allCapatity = new BigDecimal(ratecapacity.toString());
                        }
                        for (Map.Entry<String, Map<String, Object>> mapEntry_detail : detailMessage.entrySet()) {
                            BigDecimal multiply;
                            Map<String, Object> dowmtimeMessage = mapEntry_detail.getValue();
                            Object qty = dowmtimeMessage.get("qty");
                            Object times = dowmtimeMessage.get("time");
                            BigDecimal downQty = BigDecimal.ZERO;
                            BigDecimal downTime = BigDecimal.ZERO;
                            if (qty != null) {
                                downQty = new BigDecimal(qty.toString());
                            }
                            if (times != null) {
                                downTime = new BigDecimal(times.toString());
                            }
                            if ((allCapatity = allCapatity.subtract(multiply = downQty.multiply(downTime))).compareTo(BigDecimal.ZERO) >= 0) continue;
                            allCapatity = BigDecimal.ZERO;
                        }
                        map.put("ratecapacity", allCapatity);
                    }
                }
            }
        }
    }

    public static void putCapatityToMap(Map<Long, Map<Integer, Map<Integer, Map<String, Object>>>> signToData, Map<Long, Map<Date, BigDecimal>> capacityMessage, Map<Integer, Map<Integer, String>> dayToDate, String cycle, Map<Integer, Map<Integer, String>> yearToWeekTorange) {
        for (Map.Entry<Long, Map<Date, BigDecimal>> mapEntry : capacityMessage.entrySet()) {
            Long workcenterId = mapEntry.getKey();
            Map<Date, BigDecimal> dateTocapacity = mapEntry.getValue();
            Map<Integer, Map<Integer, Map<String, Object>>> yearToDateMessage = signToData.get(workcenterId);
            for (Map.Entry<Date, BigDecimal> mapEntry_dateTocapacity : dateTocapacity.entrySet()) {
                Map<String, Object> map;
                Map<Integer, Map<String, Object>> dateMessage;
                Date date = mapEntry_dateTocapacity.getKey();
                BigDecimal capacity = mapEntry_dateTocapacity.getValue();
                int year = date.getYear() + 1900;
                int dateKey = ReportQueryUtils.getDateKey(date, cycle, dayToDate, yearToWeekTorange);
                if (yearToDateMessage == null) {
                    yearToDateMessage = new HashMap<Integer, Map<Integer, Map<String, Object>>>(16);
                    signToData.put(workcenterId, yearToDateMessage);
                    dateMessage = yearToDateMessage.get(year);
                    if (dateMessage != null) continue;
                    dateMessage = new HashMap<Integer, Map<String, Object>>(16);
                    yearToDateMessage.put(year, dateMessage);
                    map = dateMessage.get(dateKey);
                    if (map != null) continue;
                    map = new HashMap<String, Object>(16);
                    map.put("year", year);
                    map.put("cycle_r", cycle);
                    map.put("ratecapacity", capacity);
                    map.put("workcenter_r", workcenterId);
                    continue;
                }
                dateMessage = yearToDateMessage.get(year);
                if (dateMessage == null) {
                    dateMessage = new HashMap<Integer, Map<String, Object>>(16);
                    yearToDateMessage.put(year, dateMessage);
                    map = dateMessage.get(dateKey);
                    if (map != null) continue;
                    map = new HashMap<String, Object>(16);
                    map.put("year", year);
                    map.put("cycle_r", cycle);
                    map.put("ratecapacity", capacity);
                    map.put("workcenter_r", workcenterId);
                    continue;
                }
                map = dateMessage.get(dateKey);
                if (map == null) {
                    map = new HashMap<String, Object>(16);
                    map.put("year", year);
                    map.put("cycle_r", cycle);
                    map.put("ratecapacity", capacity);
                    map.put("workcenter_r", workcenterId);
                    continue;
                }
                Object ratecapacity = map.get("ratecapacity");
                BigDecimal allCapacity = BigDecimal.ZERO;
                if (ratecapacity != null) {
                    allCapacity = new BigDecimal(ratecapacity.toString());
                }
                allCapacity = allCapacity.add(capacity);
                map.put("ratecapacity", allCapacity);
            }
        }
    }

    public static Map<Long, Map<Date, BigDecimal>> getCapacityMessage(DynamicObject queryplan, Map<Long, Map<Long, Map<Date, BigDecimal>>> workcenterGroupcapacityMessage, Date filterbeginDate, Date filterEndDate) {
        DynamicObjectCollection query = QueryServiceHelper.query((String)"mps_proplanschdef", (String)"workentry.workcenter,workentry.productionrules,calendar,createorg,workentry.workcalendar", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)queryplan.getLong("id"))});
        HashMap<Long, Long> workcenterToProductionRules = new HashMap<Long, Long>(8);
        HashMap<Long, Map<Date, BigDecimal>> workcenterMaxcapacityToDate = new HashMap<Long, Map<Date, BigDecimal>>(8);
        HashMap<Long, Map<Long, String>> workcenterToworkDay = new HashMap<Long, Map<Long, String>>(8);
        if (query != null && query.size() != 0) {
            for (DynamicObject dynamicObject : query) {
                Long workcalendar = dynamicObject.getLong("workentry.workcalendar");
                Long workcenterId = dynamicObject.getLong("workentry.workcenter");
                if (!workcenterToworkDay.containsKey(workcenterId)) {
                    Map<Long, String> workDay = MPSScheduleUtils.getWorkDay(dynamicObject, workcalendar);
                    workcenterToworkDay.put(workcenterId, workDay);
                }
                Long productionrulesId = dynamicObject.getLong("workentry.productionrules");
                workcenterToProductionRules.put(workcenterId, productionrulesId);
            }
        }
        HashMap<Long, Long> productionRulesToCapacity = new HashMap<Long, Long>(8);
        DynamicObjectCollection productionrules = QueryServiceHelper.query((String)"mps_productionrules", (String)"id,capacitydefinition", (QFilter[])new QFilter[]{new QFilter("id", "in", workcenterToProductionRules.values())});
        for (DynamicObject dynamicObject : productionrules) {
            Long id = dynamicObject.getLong("id");
            Long capacitydefinition = dynamicObject.getLong("capacitydefinition");
            productionRulesToCapacity.put(id, capacitydefinition);
        }
        DynamicObjectCollection capacitydef = QueryServiceHelper.query((String)"mps_capacitydef", (String)"capacitytype,workcenter,entryentity.maxcapacity,entryentity.startdate,entryentity.enddate,entryentity.group", (QFilter[])new QFilter[]{new QFilter("id", "in", productionRulesToCapacity.values())});
        for (DynamicObject dynamicObject : capacitydef) {
            String s;
            Map<Date, BigDecimal> maxcapacityToDate;
            Date enddate;
            Date startdate;
            Map workDay;
            Long workcenter;
            String type = dynamicObject.getString("capacitytype");
            if ("A".equals(type)) {
                String s2;
                workcenter = dynamicObject.getLong("workcenter");
                workDay = (Map)workcenterToworkDay.get(workcenter);
                HashMap<Date, BigDecimal> maxcapacityToDate2 = (HashMap<Date, BigDecimal>)workcenterMaxcapacityToDate.get(workcenter);
                BigDecimal maxcapacity = dynamicObject.getBigDecimal("entryentity.maxcapacity");
                startdate = dynamicObject.getDate("entryentity.startdate");
                enddate = dynamicObject.getDate("entryentity.enddate");
                if (maxcapacityToDate2 == null) {
                    maxcapacityToDate2 = new HashMap<Date, BigDecimal>(8);
                    while (!enddate.before(startdate)) {
                        if (!(filterbeginDate.after(startdate) || filterEndDate.before(startdate) || "4".equals(s2 = (String)workDay.get(startdate.getTime())))) {
                            maxcapacityToDate2.put(startdate, maxcapacity);
                        }
                        startdate = DateUtils.addDays((Date)startdate, (int)1);
                    }
                    workcenterMaxcapacityToDate.put(workcenter, maxcapacityToDate2);
                    continue;
                }
                while (!enddate.before(startdate)) {
                    s2 = (String)workDay.get(startdate.getTime());
                    if (!(filterbeginDate.after(startdate) || filterEndDate.before(startdate) || s2 == null || "4".equals(s2))) {
                        maxcapacityToDate2.put(startdate, maxcapacity);
                    }
                    startdate = DateUtils.addDays((Date)startdate, (int)1);
                }
                continue;
            }
            workcenter = dynamicObject.getLong("workcenter");
            workDay = (Map)workcenterToworkDay.get(workcenter);
            Map<Long, Map<Date, BigDecimal>> groupmaxcapacityToDate = workcenterGroupcapacityMessage.get(workcenter);
            Long group = dynamicObject.getLong("entryentity.group");
            startdate = dynamicObject.getDate("entryentity.startdate");
            enddate = dynamicObject.getDate("entryentity.enddate");
            BigDecimal maxcapacity = dynamicObject.getBigDecimal("entryentity.maxcapacity");
            if (groupmaxcapacityToDate == null) {
                groupmaxcapacityToDate = new HashMap<Long, Map<Date, BigDecimal>>(16);
                maxcapacityToDate = new HashMap<Date, BigDecimal>(8);
                while (!enddate.before(startdate)) {
                    s = (String)workDay.get(startdate.getTime());
                    if (!(filterbeginDate.after(startdate) || filterEndDate.before(startdate) || "4".equals(s))) {
                        maxcapacityToDate.put(startdate, maxcapacity);
                    }
                    startdate = DateUtils.addDays((Date)startdate, (int)1);
                }
                groupmaxcapacityToDate.put(group, maxcapacityToDate);
                workcenterGroupcapacityMessage.put(workcenter, groupmaxcapacityToDate);
                continue;
            }
            maxcapacityToDate = groupmaxcapacityToDate.get(group);
            if (maxcapacityToDate == null) {
                maxcapacityToDate = new HashMap<Date, BigDecimal>(8);
                while (!enddate.before(startdate)) {
                    s = (String)workDay.get(startdate.getTime());
                    if (!(filterbeginDate.after(startdate) || filterEndDate.before(startdate) || "4".equals(s))) {
                        maxcapacityToDate.put(startdate, maxcapacity);
                    }
                    startdate = DateUtils.addDays((Date)startdate, (int)1);
                }
                groupmaxcapacityToDate.put(group, maxcapacityToDate);
                continue;
            }
            while (!enddate.before(startdate)) {
                s = (String)workDay.get(startdate.getTime());
                if (!(filterbeginDate.after(startdate) || filterEndDate.before(startdate) || "4".equals(s))) {
                    maxcapacityToDate.put(startdate, maxcapacity);
                }
                startdate = DateUtils.addDays((Date)startdate, (int)1);
            }
        }
        return workcenterMaxcapacityToDate;
    }

    public static void assigedNumMatch(Map<String, BigDecimal> fieldToNum, Map<String, Object> orderMap, Set<String> allField) {
        BigDecimal num;
        StringBuilder stringBuilder = new StringBuilder();
        Object order_num = orderMap.get("order_num");
        BigDecimal ordernum = BigDecimal.ZERO;
        if (order_num != null) {
            ordernum = new BigDecimal(order_num.toString());
        }
        for (String field : allField) {
            Object o;
            if ("sourcebillid".equals(field)) {
                field = "sourcebillid_old";
            }
            if ((o = orderMap.get(field)) == null) {
                o = 0;
            }
            stringBuilder.append(o).append(",");
        }
        String key = "";
        if (stringBuilder.length() > 1) {
            key = stringBuilder.substring(0, stringBuilder.length() - 1);
        }
        if ((num = fieldToNum.get(key)) != null) {
            if (ordernum.compareTo(num) > 0) {
                orderMap.put("assigedNum", num);
                fieldToNum.put(key, BigDecimal.ZERO);
            } else {
                orderMap.put("assigedNum", ordernum);
                num = num.subtract(ordernum);
                fieldToNum.put(key, num);
            }
        }
    }

    public static void putPlanloadNumToMap(List<Map<String, Object>> dataMessageByReport, Map<Long, Map<Integer, Map<Integer, Map<String, Object>>>> signToData, String cycle, Map<Integer, Map<Integer, Map<String, Object>>> signToData_noworkcenter, Map<Integer, Map<Integer, String>> dayToDate, List<Long> workcenterList, Map<String, Long> scheduDataWorkcenter, Map<Long, Object[]> planWorkCenter, Map<Integer, Map<Integer, String>> yearToWeekTorange) {
        for (Map<String, Object> map : dataMessageByReport) {
            Date sheduledate = (Date)map.get("demanddate");
            Long workcentre = (Long)map.get("workcentre");
            Long sourceentryid = (Long)map.get("sourceentryid");
            Integer entryseq = (Integer)map.get("entryseq");
            String key = sourceentryid + "," + entryseq;
            Long aLong = scheduDataWorkcenter.get(key);
            if (aLong != null && aLong != 0L) {
                workcentre = aLong;
            }
            if (workcenterList.size() != 0 && !workcenterList.contains(workcentre) || workcentre != null && workcentre != 0L && !planWorkCenter.containsKey(workcentre)) continue;
            int year = sheduledate.getYear() + 1900;
            int value = "mon".equals(cycle) ? sheduledate.getMonth() + 1 : ("wek".equals(cycle) ? ReportQueryUtils.calculateWeek(sheduledate, yearToWeekTorange) : ("qua".equals(cycle) ? sheduledate.getMonth() / 3 + 1 : ReportQueryUtils.calculateDay(sheduledate, dayToDate)));
            Map<String, Object> map_num = null;
            Map<Integer, Map<String, Object>> integerMap = null;
            Map<Integer, Map<Integer, Map<String, Object>>> integerMapMap = null;
            if (workcentre == null || workcentre == 0L) {
                integerMap = signToData_noworkcenter.get(year);
                if (integerMap == null) {
                    integerMap = new HashMap<Integer, Map<String, Object>>(16);
                    signToData_noworkcenter.put(year, integerMap);
                } else {
                    map_num = integerMap.get(value);
                }
            } else {
                integerMapMap = signToData.get(workcentre);
                if (integerMapMap == null) {
                    integerMapMap = new HashMap<Integer, Map<Integer, Map<String, Object>>>(8);
                    signToData.put(workcentre, integerMapMap);
                    integerMap = new HashMap<Integer, Map<String, Object>>(16);
                    integerMapMap.put(year, integerMap);
                } else if (integerMapMap.containsKey(year)) {
                    integerMap = integerMapMap.get(year);
                    if (integerMap == null) {
                        integerMap = new HashMap<Integer, Map<String, Object>>(8);
                        integerMapMap.put(year, integerMap);
                        integerMap = new HashMap<Integer, Map<String, Object>>(16);
                        integerMapMap.put(value, integerMap);
                    } else {
                        map_num = integerMap.get(value);
                    }
                } else {
                    integerMap = new HashMap<Integer, Map<String, Object>>(16);
                    integerMapMap.put(year, integerMap);
                }
            }
            if (map_num != null) {
                Object planlaod = map_num.get("planlaod");
                BigDecimal load = BigDecimal.ZERO;
                if (planlaod != null) {
                    load = new BigDecimal(planlaod.toString());
                }
                Object orderqty = map.get("orderqty");
                BigDecimal plsqty = BigDecimal.ZERO;
                if (orderqty != null) {
                    plsqty = new BigDecimal(orderqty.toString());
                }
                if (map.containsKey("assigedNum")) {
                    BigDecimal assigedNum = (BigDecimal)map.get("assigedNum");
                    plsqty = plsqty.subtract(assigedNum);
                }
                load = load.add(plsqty);
                map_num.put("planlaod", load);
                if (!map_num.containsKey("download")) continue;
                BigDecimal download = new BigDecimal(map_num.get("download").toString());
                BigDecimal allload = load.add(download);
                map_num.put("allload", allload);
                continue;
            }
            HashMap<String, Object> keyToData = new HashMap<String, Object>(8);
            Object orderqty_o = map.get("orderqty");
            BigDecimal plsqty = BigDecimal.ZERO;
            if (orderqty_o != null) {
                plsqty = new BigDecimal(orderqty_o.toString());
            }
            if (map.containsKey("assigedNum")) {
                BigDecimal assigedNum = (BigDecimal)map.get("assigedNum");
                plsqty = plsqty.subtract(assigedNum);
            }
            keyToData.put("year", year);
            keyToData.put("cycle_r", cycle);
            keyToData.put("workcenter_r", workcentre);
            keyToData.put("planlaod", plsqty);
            keyToData.put("download", BigDecimal.ZERO);
            BigDecimal allload = plsqty;
            keyToData.put("allload", allload);
            integerMap.put(value, keyToData);
        }
    }

    public static void putDownloadNumToMap(List<Map<String, Object>> dataMessageByReport, Map<Long, Map<Integer, Map<Integer, Map<String, Object>>>> signToData, String cycle, Map<Integer, Map<Integer, Map<String, Object>>> signToData_noworkcenter, Map<Integer, Map<Integer, String>> dayToDate, Map<Long, Object[]> planWorkCenter, Map<Integer, Map<Integer, String>> yearToWeekTorange) {
        for (Map<String, Object> message : dataMessageByReport) {
            BigDecimal plsqty;
            Object sheduledate_o = message.get("pls_date");
            Object workcentre = message.get("workcenter");
            if (workcentre != null && (Long)workcentre != 0L && !planWorkCenter.containsKey(workcentre)) continue;
            Date sheduledate = null;
            if (sheduledate_o == null) continue;
            sheduledate = (Date)sheduledate_o;
            int year = sheduledate.getYear() + 1900;
            int value = "mon".equals(cycle) ? sheduledate.getMonth() + 1 : ("wek".equals(cycle) ? ReportQueryUtils.calculateWeek(sheduledate, yearToWeekTorange) : ("qua".equals(cycle) ? sheduledate.getMonth() / 3 + 1 : ReportQueryUtils.calculateDay(sheduledate, dayToDate)));
            Map<Integer, Map<String, Object>> integerMap = null;
            Map<String, Object> map = null;
            Map<Integer, Map<Integer, Map<String, Object>>> integerMapMap = null;
            if (workcentre == null || (Long)workcentre == 0L) {
                integerMap = signToData_noworkcenter.get(year);
                if (integerMap == null) {
                    integerMap = new HashMap<Integer, Map<String, Object>>(16);
                    signToData_noworkcenter.put(year, integerMap);
                } else {
                    map = integerMap.get(value);
                }
            } else {
                integerMapMap = signToData.get(workcentre);
                if (integerMapMap == null) {
                    integerMapMap = new HashMap<Integer, Map<Integer, Map<String, Object>>>(8);
                    signToData.put((Long)workcentre, integerMapMap);
                    integerMap = new HashMap<Integer, Map<String, Object>>(16);
                    integerMapMap.put(year, integerMap);
                } else if (integerMapMap.containsKey(year)) {
                    integerMap = integerMapMap.get(year);
                    if (integerMap == null) {
                        integerMap = new HashMap<Integer, Map<String, Object>>(8);
                        integerMapMap.put(year, integerMap);
                        integerMap = new HashMap<Integer, Map<String, Object>>(16);
                        integerMapMap.put(value, integerMap);
                    } else {
                        map = integerMap.get(value);
                    }
                } else {
                    integerMap = new HashMap<Integer, Map<String, Object>>(16);
                    integerMapMap.put(year, integerMap);
                }
            }
            if (map != null) {
                Object download = map.get("download");
                if (download != null) {
                    plsqty = (BigDecimal)message.get("plsqty");
                    BigDecimal load = new BigDecimal(download.toString());
                    load = load.add(plsqty);
                    map.put("download", load);
                    map.put("allload", load);
                    continue;
                }
                map.put("download", BigDecimal.ZERO);
                map.put("allload", BigDecimal.ZERO);
                continue;
            }
            HashMap<String, Object> keyToData = new HashMap<String, Object>(8);
            plsqty = (BigDecimal)message.get("plsqty");
            keyToData.put("year", year);
            keyToData.put("cycle_r", cycle);
            keyToData.put("workcenter_r", workcentre);
            keyToData.put("sheduledate", sheduledate);
            keyToData.put("planlaod", BigDecimal.ZERO);
            keyToData.put("allload", plsqty);
            keyToData.put("download", plsqty);
            integerMap.put(value, keyToData);
        }
    }

    public static String getWeekStarAndEedDate(Integer week, Integer year) {
        Calendar calendar = Calendar.getInstance();
        calendar.clear();
        calendar.setFirstDayOfWeek(2);
        calendar.set(1, year);
        calendar.add(3, week - 1);
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
        String dateStr = simpleDateFormat.format(calendar.getTime());
        calendar.add(5, 6);
        String dateStr_end = simpleDateFormat.format(calendar.getTime());
        return dateStr + "~" + dateStr_end;
    }

    public static int calculateWeek(Date date, Map<Integer, Map<Integer, String>> yearToWeekTorange) {
        Calendar calendar = Calendar.getInstance();
        calendar.setFirstDayOfWeek(2);
        calendar.setTime(date);
        int week = calendar.get(3);
        int weekDay = calendar.get(7);
        calendar.add(6, 2 - weekDay);
        Date beginDayOfWeek = calendar.getTime();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
        String dateStr = simpleDateFormat.format(beginDayOfWeek);
        calendar.add(6, 6);
        Date endDayOfWeek = calendar.getTime();
        String dateend = simpleDateFormat.format(endDayOfWeek);
        if (week == 1 && date.getMonth() == 11) {
            calendar.set(6, calendar.get(6) - 7);
            week = calendar.get(3) + 1;
        }
        int year = calendar.getTime().getYear() + 1900;
        String range = dateStr + "~" + dateend;
        if (yearToWeekTorange.containsKey(year)) {
            Map<Integer, String> weekTorange = yearToWeekTorange.get(year);
            if (!weekTorange.containsKey(week)) {
                weekTorange.put(week, range);
            }
        } else {
            HashMap<Integer, String> weekTorange = new HashMap<Integer, String>(16);
            weekTorange.put(week, range);
            yearToWeekTorange.put(year, weekTorange);
        }
        return week;
    }

    public static int calculateDay(Date date, Map<Integer, Map<Integer, String>> yearDayToDate) {
        Calendar calendar = Calendar.getInstance();
        calendar.setFirstDayOfWeek(2);
        calendar.setTime(date);
        int year = date.getYear() + 1900;
        int d = calendar.get(5);
        int m = calendar.get(2) + 1;
        int day = calendar.get(6);
        Map<Integer, String> dayToDate = yearDayToDate.get(year);
        if (dayToDate == null) {
            dayToDate = new HashMap<Integer, String>(16);
            yearDayToDate.put(year, dayToDate);
        }
        dayToDate.put(day, m + "/" + d);
        return day;
    }

    public static Map<String, Long> getScheduDataWorkcenter(List<Map<String, Object>> dataMessageByReport) {
        HashSet<Long> sourceentryidList = new HashSet<Long>(16);
        HashSet<Integer> rowList = new HashSet<Integer>(16);
        for (Map<String, Object> map : dataMessageByReport) {
            Long sourceentryid = (Long)map.get("sourceentryid");
            Integer entryseq = (Integer)map.get("entryseq");
            if (sourceentryid != null && sourceentryid != 0L) {
                sourceentryidList.add(sourceentryid);
            }
            if (entryseq == null) continue;
            rowList.add(entryseq);
        }
        QFilter qFilter_id = new QFilter("sourceentryid", "in", sourceentryidList);
        QFilter qFilter_row = new QFilter("entryseq", "in", rowList);
        DataSet scheduleplanDataset = QueryServiceHelper.queryDataSet((String)"reportQuery", (String)"mps_scheduledata", (String)"id,sourceentryid,entryseq,workcentre", (QFilter[])new QFilter[]{qFilter_id, qFilter_row}, null);
        HashMap<String, Long> idSeqToWorkcenter = new HashMap<String, Long>(16);
        while (scheduleplanDataset.hasNext()) {
            Row next = scheduleplanDataset.next();
            Long sourceentryid = next.getLong("sourceentryid");
            Integer entryseq = next.getInteger("entryseq");
            Long workcentre = next.getLong("workcentre");
            String key = sourceentryid + "," + entryseq;
            idSeqToWorkcenter.put(key, workcentre);
        }
        return idSeqToWorkcenter;
    }

    public static DataSet getPlanData(DynamicObject org, DynamicObject queryplan, Date filterbeginDate, Date filterEndDate, List<Long> datasourcesList) {
        Set<Long> orderModelId = ReportQueryUtils.getOrderModelId(queryplan, "order");
        HashSet<Long> orderModel_exit = new HashSet<Long>(8);
        if (datasourcesList.size() != 0) {
            for (Long id : orderModelId) {
                if (!datasourcesList.contains(id)) continue;
                orderModel_exit.add(id);
            }
        } else {
            orderModel_exit.addAll(orderModelId);
        }
        DataSet orderDataset = ReportQueryUtils.getOrderDataset(orderModel_exit);
        if (orderDataset != null) {
            HashMap<String, Timestamp> sqlParams = new HashMap<String, Timestamp>();
            sqlParams.put("_requiredate", new Timestamp(filterEndDate.getTime()));
            sqlParams.put("_requiredate_end", new Timestamp(filterbeginDate.getTime()));
            String[] fields = orderDataset.getRowMeta().getFieldNames();
            ArrayList<String> initFiled = new ArrayList<String>(Arrays.asList(fields));
            if (initFiled.contains("requiredate")) {
                DataSet dataSet_finsh = orderDataset.filter("production_org = " + org.getLong("id")).filter("requiredate <= _requiredate", sqlParams).filter("requiredate >= _requiredate_end", sqlParams);
                return dataSet_finsh;
            }
            return null;
        }
        return null;
    }

    public static DataSet filterWorkCenter(List<Long> workcenterList, DataSet dataSet_sort, List<Long> actresourceList) {
        DataSet dataSet_finsh;
        DataSet dataSet_workcenter;
        HashMap<String, List<Long>> sqlParams = new HashMap<String, List<Long>>();
        if (workcenterList.size() != 0) {
            sqlParams.put("_workcenter", workcenterList);
            dataSet_workcenter = dataSet_sort.filter("workcenter_r in _workcenter", sqlParams);
        } else {
            dataSet_workcenter = dataSet_sort;
        }
        if (actresourceList.size() != 0) {
            sqlParams.put("_actresource", actresourceList);
            dataSet_finsh = dataSet_workcenter.filter("actresource in _actresource", sqlParams);
        } else {
            dataSet_finsh = dataSet_workcenter;
        }
        return dataSet_finsh;
    }

    public static DataSet getAssignedData_nofilterTime(DynamicObject org, DynamicObject queryplan, List<Long> datasourcesList) {
        Set<Long> orderModelId = ReportQueryUtils.getOrderModelId(queryplan, "assigned");
        HashSet<Long> orderModel_exit = new HashSet<Long>(8);
        if (datasourcesList.size() != 0) {
            for (Long id : orderModelId) {
                if (!datasourcesList.contains(id)) continue;
                orderModel_exit.add(id);
            }
        } else {
            orderModel_exit.addAll(orderModelId);
        }
        DataSet orderDataset = ReportQueryUtils.getOrderDataset(orderModel_exit);
        if (orderDataset != null) {
            DataSet dataSet_finsh = orderDataset.filter("production_org = " + org.getLong("id"));
            return dataSet_finsh;
        }
        return null;
    }

    public static DataSet getAssignedData(DataSet orderDataset, Date filterbeginDate, Date filterEndDate) {
        if (orderDataset != null) {
            HashMap<String, Timestamp> sqlParams = new HashMap<String, Timestamp>();
            sqlParams.put("_requiredate", new Timestamp(filterEndDate.getTime()));
            sqlParams.put("_requiredate_end", new Timestamp(filterbeginDate.getTime()));
            String[] fields = orderDataset.getRowMeta().getFieldNames();
            ArrayList<String> initFiled = new ArrayList<String>(Arrays.asList(fields));
            if (!initFiled.contains("pls_date")) {
                return null;
            }
            DataSet dataSet = orderDataset.copy().updateField("pls_date", "case when pls_date == null then null else TO_DATE(TO_CHAR(pls_date,'yyyy-MM-dd'),'yyyy-MM-dd') end");
            DataSet dataSet_finsh = dataSet.filter("pls_date <= _requiredate", sqlParams).filter("pls_date >= _requiredate_end", sqlParams);
            return dataSet_finsh;
        }
        return null;
    }

    public static DataSet getOrderDataset(Set<Long> modelIds) {
        DataSet dataSet = null;
        for (Long modelId : modelIds) {
            DataSet ds;
            FetchDataQueryModule queryMD = DataSourceFetchDataUtil.getQueryModuleByModel((Long)modelId, null);
            DataSet dsItem = DataSourceFetchDataUtil.getDataSetByModel((FetchDataQueryModule)queryMD, (DataSet)(ds = QueryServiceHelper.queryDataSet((String)DataSourceFetchDataUtil.class.getName(), (String)queryMD.getMt(), (String)queryMD.getOql(), (QFilter[])queryMD.getqFilters(), null)));
            if (dsItem == null || dsItem.isEmpty()) {
                return null;
            }
            if (dataSet == null) {
                dataSet = dsItem;
                continue;
            }
            RowMeta leftRowMeta = dataSet.getRowMeta();
            RowMeta rightRowMeta = dsItem.getRowMeta();
            Field[] leftFields = leftRowMeta.getFields();
            Field[] rightFields = rightRowMeta.getFields();
            HashSet<String> allFieldName = new HashSet<String>(16);
            HashSet<String> leftName = new HashSet<String>(16);
            HashSet<String> rightName = new HashSet<String>(16);
            for (Field leftField : leftFields) {
                allFieldName.add(leftField.getName());
                leftName.add(leftField.getName());
            }
            for (Field rightField : rightFields) {
                allFieldName.add(rightField.getName());
                rightName.add(rightField.getName());
            }
            for (String fieldName : allFieldName) {
                if (!leftName.contains(fieldName)) {
                    dataSet = dataSet.addNullField(fieldName);
                }
                if (rightName.contains(fieldName)) continue;
                dsItem = dsItem.addNullField(fieldName);
            }
            dataSet = dataSet.select(allFieldName.toArray(new String[0]));
            dsItem = dsItem.select(allFieldName.toArray(new String[0]));
            dataSet = dataSet.union(dsItem);
        }
        return dataSet;
    }

    public static Set<Long> getOrderModelId(DynamicObject plan, String sign) {
        DynamicObjectCollection orderEntryColl = "assigned".equals(sign) ? plan.getDynamicObjectCollection("data_entryentity") : ("route".equals(sign) ? plan.getDynamicObjectCollection("route_entryentity") : ("resoure".equals(sign) ? plan.getDynamicObjectCollection("resources_entryentity") : plan.getDynamicObjectCollection("order_entryentity")));
        HashSet<Long> idSet = new HashSet<Long>(orderEntryColl.size());
        if (orderEntryColl != null && !orderEntryColl.isEmpty()) {
            for (DynamicObject order : orderEntryColl) {
                boolean isCalculate = false;
                if ("assigned".equals(sign)) {
                    if (order.get("dataisincalculate") != null) {
                        isCalculate = order.getBoolean("dataisincalculate");
                    }
                    if (!isCalculate || order.get("dataresourceconfig") == null) continue;
                    idSet.add(order.getLong("dataresourceconfig_id"));
                    continue;
                }
                if ("route".equals(sign)) {
                    if (order.get("routeisincalculate") != null) {
                        isCalculate = order.getBoolean("routeisincalculate");
                    }
                    if (!isCalculate || order.get("routeresourceconfig") == null) continue;
                    idSet.add(order.getLong("routeresourceconfig_id"));
                    continue;
                }
                if ("resoure".equals(sign)) {
                    if (order.get("resourcesisincalculate") != null) {
                        isCalculate = order.getBoolean("resourcesisincalculate");
                    }
                    if (!isCalculate || order.get("resourcesresourceconfig") == null) continue;
                    idSet.add(order.getLong("resourcesresourceconfig_id"));
                    continue;
                }
                if (order.get("isincalculate") != null) {
                    isCalculate = order.getBoolean("isincalculate");
                }
                if (!isCalculate || order.get("resourceconfig") == null) continue;
                idSet.add(order.getLong("resourceconfig_id"));
            }
            if (idSet.size() == 0) {
                return idSet;
            }
        }
        return idSet;
    }

    public static DataSet getRouteData(DynamicObject queryplan, List<Long> actresourceList) {
        Set<Long> orderModelId = ReportQueryUtils.getOrderModelId(queryplan, "route");
        DataSet orderDataset = ReportQueryUtils.getOrderDataset(orderModelId);
        if (orderDataset != null) {
            HashMap<String, List<Long>> sqlParams = new HashMap<String, List<Long>>();
            sqlParams.put("_actresource", actresourceList);
            String[] fields = orderDataset.getRowMeta().getFieldNames();
            ArrayList<String> initFiled = new ArrayList<String>(Arrays.asList(fields));
            if (initFiled.contains("actresource") && actresourceList.size() != 0) {
                DataSet dataSet_finsh = orderDataset.filter("actresource in _actresource ", sqlParams);
                return dataSet_finsh;
            }
            return orderDataset;
        }
        return null;
    }

    public static List<Map<String, Object>> getRouteOrder(DataSet routeData, Map<Long, List<Map<String, Object>>> routeIds, String sign, Map<Long, Object[]> routeIdToDateRange) {
        if (routeData == null || routeData.isEmpty()) {
            return new ArrayList<Map<String, Object>>();
        }
        ArrayList<Map<String, Object>> scheduleOrderList = new ArrayList<Map<String, Object>>(8);
        DataSet copy = routeData.copy();
        RowMeta rowMeta = copy.getRowMeta();
        String[] fieldNames = rowMeta.getFieldNames();
        ArrayList<String> initFiled = new ArrayList<String>(Arrays.asList(fieldNames));
        if (!initFiled.contains("processroute") && "route".equals(sign)) {
            return null;
        }
        boolean isExsitValiditytime = false;
        if (initFiled.contains("validitybegindate") && initFiled.contains("validityenddate")) {
            isExsitValiditytime = true;
        }
        while (copy.hasNext()) {
            Row next = copy.next();
            HashMap<String, Object> scheduleOrderMap = new HashMap<String, Object>(8);
            Object[] objects = new Object[2];
            for (int i = 0; i < fieldNames.length; ++i) {
                List<Map<String, Object>> routeList;
                scheduleOrderMap.put(fieldNames[i], next.get(fieldNames[i]));
                if (isExsitValiditytime) {
                    if ("validitybegindate".equals(fieldNames[i])) {
                        objects[0] = next.get(fieldNames[i]);
                    }
                    if ("validityenddate".equals(fieldNames[i])) {
                        objects[1] = next.get(fieldNames[i]);
                    }
                }
                if (!"processroute".equals(fieldNames[i])) continue;
                Long routeId = next.getLong(fieldNames[i]);
                if (routeIds.containsKey(routeId)) {
                    routeList = routeIds.get(routeId);
                    routeList.add(scheduleOrderMap);
                    continue;
                }
                routeIdToDateRange.put(routeId, objects);
                routeList = new ArrayList<Map<String, Object>>(16);
                routeList.add(scheduleOrderMap);
                routeIds.put(next.getLong(fieldNames[i]), routeList);
            }
            scheduleOrderList.add(scheduleOrderMap);
        }
        log.info("routesize", (Object)scheduleOrderList.size());
        return scheduleOrderList;
    }

    public static void getMserviceRoute(List<Map<String, Object>> dataMessage_all, List<Map<String, Object>> dataMessage_mservice, List<Map<String, Object>> dataMessage_material, Map<Long, List<Map<String, Object>>> routeId, Long orgid) {
        ArrayList params = new ArrayList(dataMessage_mservice.size());
        for (Map<String, Object> dataMessage : dataMessage_mservice) {
            HashMap<String, Object> map = new HashMap<String, Object>(16);
            map.put("bizorg", orgid);
            Object material_code = dataMessage.get("materiel_code");
            if (material_code != null) {
                map.put("material", material_code);
            }
            if (dataMessage.containsKey("requiredate")) {
                map.put("bomdate", dataMessage.get("requiredate"));
                if (dataMessage.get("order_num") != null) {
                    map.put("qty", new BigDecimal(dataMessage.get("order_num").toString()));
                }
            }
            if (dataMessage.containsKey("pls_date")) {
                map.put("bomdate", dataMessage.get("pls_date"));
                if (dataMessage.get("plsqty") != null) {
                    map.put("qty", new BigDecimal(dataMessage.get("plsqty").toString()));
                }
            }
            if (dataMessage.get("configure") != null) {
                map.put("configure", dataMessage.get("configure"));
            }
            if (dataMessage.get("auxiliary") != null) {
                map.put("auxproperty", dataMessage.get("auxiliary"));
            }
            params.add(map);
        }
        log.info("mservice" + ((Object)params).toString());
        Map resMap = (Map)DispatchServiceHelper.invokeBizService((String)"bd", (String)"mpdm", (String)"IAutoSetManuVersionService", (String)"getBatchManuVersion", (Object[])new Object[]{params});
        if (resMap == null || resMap.size() == 0) {
            dataMessage_material.addAll(dataMessage_mservice);
            return;
        }
        Map marterielToRoute = (Map)resMap.get(orgid);
        if (marterielToRoute == null || marterielToRoute.isEmpty()) {
            dataMessage_material.addAll(dataMessage_mservice);
            return;
        }
        StringBuilder sb = new StringBuilder("productionDnyMessage:");
        ReportQueryUtils.getMserviceRouteByReturn(sb, dataMessage_mservice, marterielToRoute, routeId, dataMessage_all, dataMessage_material);
        log.info(sb.toString());
    }

    public static void getMserviceRouteByReturn(StringBuilder sb, List<Map<String, Object>> dataMessage_mservice, Map<Object, Set<DynamicObject>> marterielToRoute, Map<Long, List<Map<String, Object>>> routeId, List<Map<String, Object>> dataMessage_all, List<Map<String, Object>> dataMessage_material) {
        for (Map<String, Object> dataMessage : dataMessage_mservice) {
            Object material_code = dataMessage.get("materiel_code");
            if (material_code == null) continue;
            Set<DynamicObject> productionversion = marterielToRoute.get(material_code);
            if (productionversion != null) {
                DynamicObject productionDny = (DynamicObject)productionversion.toArray()[0];
                Long processrouteId = productionDny.getLong("processroute");
                sb.append(material_code).append(":").append(processrouteId).append(productionDny.getLong("id")).append(":");
                if (routeId.containsKey(processrouteId)) {
                    List<Map<String, Object>> routeList = routeId.get(processrouteId);
                    dataMessage.put("processroute", routeList);
                    dataMessage_all.add(dataMessage);
                    continue;
                }
                dataMessage_material.add(dataMessage);
                continue;
            }
            dataMessage_material.add(dataMessage);
        }
    }

    public static void getOrderProductionversionRoute(List<Long> productionversionList, List<Map<String, Object>> dataMessage_mservice, List<Map<String, Object>> dataMessage_all, List<Map<String, Object>> dataMessage_productionversion, Map<Long, List<Map<String, Object>>> routeIds, Map<Long, Object[]> routeIdToDateRange, StringBuilder tipMessage) {
        QFilter qFilter = new QFilter("id", "in", productionversionList).and("enable", "=", (Object)"1").and("status", "=", (Object)"C");
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)"capacityScheduReportQuerypro", (String)"pdm_manuversion", (String)"id,processroute", (QFilter[])new QFilter[]{qFilter}, (String)"");
        if (dataSet == null || dataSet.isEmpty()) {
            dataMessage_mservice.addAll(dataMessage_productionversion);
        } else {
            HashMap<Long, Long> proToRoute = new HashMap<Long, Long>(16);
            while (dataSet.hasNext()) {
                Row next = dataSet.next();
                Long proId = next.getLong("id");
                Long routeId = next.getLong("processroute");
                proToRoute.put(proId, routeId);
            }
            for (Map<String, Object> map : dataMessage_productionversion) {
                Object productionversion = map.get("productionversion");
                if (proToRoute.containsKey(productionversion)) {
                    Long processroute = (Long)proToRoute.get(productionversion);
                    if (!routeIds.containsKey(processroute)) continue;
                    Object exsitProcessroute = ReportQueryUtils.isExsitRangeDate(map, routeIdToDateRange, processroute);
                    if (exsitProcessroute == null) {
                        tipMessage.append(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u7801\uff1a", (String)"CapacityScheduReportQuery_9", (String)"mmc-mps-report", (Object[])new Object[0])).append(map.get("billno") == null ? " " : map.get("billno")).append(" ").append(ResManager.loadKDString((String)"\u6765\u6e90\u5355\u636e\u7f16\u7801\uff1a", (String)"CapacityScheduReportQuery_8", (String)"mmc-mps-report", (Object[])new Object[0])).append(map.get("plan_order_billno")).append("  ").append(ResManager.loadKDString((String)"\u6765\u6e90\u5355\u636e\u884c\u53f7\uff1a", (String)"CapacityScheduReportQuery_17", (String)"mmc-mps-report", (Object[])new Object[0])).append(1).append(" ").append(ResManager.loadKDString((String)"\u9700\u6c42\u65f6\u95f4\u4e0d\u5728\u5de5\u827a\u8def\u7ebf\u6a21\u578b\u7684\u6709\u6548\u671f\u5185", (String)"CapacityScheduReportQuery_18", (String)"mmc-mps-report", (Object[])new Object[0])).append("\n");
                        continue;
                    }
                    List<Map<String, Object>> routeList = routeIds.get(proToRoute.get(productionversion));
                    map.put("processroute", routeList);
                    dataMessage_all.add(map);
                    continue;
                }
                dataMessage_mservice.add(map);
            }
        }
    }

    public static void getRouteByMaterial(List<Map<String, Object>> dataMessage_material, List<Map<String, Object>> dataMessage_all, Set<Long> materialList, DynamicObject org, List<Map<String, Object>> dataMessage_exception, Map<Long, List<Map<String, Object>>> routeId, StringBuilder tipMessage, Map<Long, Object[]> routeIdToDateRange) {
        for (Map<String, Object> map : dataMessage_material) {
            Object material_code = map.get("materiel_code");
            if (material_code == null) continue;
            materialList.add((Long)material_code);
        }
        Map<Long, DynamicObject> matToMft = ReportQueryUtils.getMftByMat(materialList);
        Map<Long, DynamicObject> matToRoute = ReportQueryUtils.getRouteFromCache(matToMft, org);
        for (Map<String, Object> map : dataMessage_material) {
            Object material_code = map.get("materiel_code");
            if (material_code == null) continue;
            DynamicObject dynamicObject = matToRoute.get(material_code);
            if (dynamicObject == null) {
                tipMessage.append(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u7801\uff1a", (String)"CapacityScheduReportQuery_9", (String)"mmc-mps-report", (Object[])new Object[0])).append(map.get("billno") == null ? " " : map.get("billno")).append(ResManager.loadKDString((String)"\u6765\u6e90\u5355\u636e\u7f16\u7801\uff1a", (String)"CapacityScheduReportQuery_8", (String)"mmc-mps-report", (Object[])new Object[0])).append(map.get("plan_order_billno")).append("  ").append(ResManager.loadKDString((String)"\u6765\u6e90\u5355\u636e\u884c\u53f7\uff1a", (String)"CapacityScheduReportQuery_17", (String)"mmc-mps-report", (Object[])new Object[0])).append(map.get("sourcebillentryno")).append("  ").append(ResManager.loadKDString((String)"\u4e0d\u5b58\u5728\u5de5\u827a\u8def\u7ebf", (String)"CapacityScheduReportQuery_5", (String)"mmc-mps-report", (Object[])new Object[0])).append("\n");
                continue;
            }
            Long processroute = dynamicObject.getLong("id");
            if (routeId.containsKey(processroute)) {
                Object exsitProcessroute = ReportQueryUtils.isExsitRangeDate(map, routeIdToDateRange, processroute);
                if (exsitProcessroute == null) {
                    tipMessage.append(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u7801\uff1a", (String)"CapacityScheduReportQuery_9", (String)"mmc-mps-report", (Object[])new Object[0])).append(map.get("billno") == null ? " " : map.get("billno")).append(" ").append(ResManager.loadKDString((String)"\u6765\u6e90\u5355\u636e\u7f16\u7801\uff1a", (String)"CapacityScheduReportQuery_8", (String)"mmc-mps-report", (Object[])new Object[0])).append(map.get("plan_order_billno")).append("  ").append(ResManager.loadKDString((String)"\u6765\u6e90\u5355\u636e\u884c\u53f7\uff1a", (String)"CapacityScheduReportQuery_17", (String)"mmc-mps-report", (Object[])new Object[0])).append(map.get("sourcebillentryno")).append(" ").append(ResManager.loadKDString((String)"\u9700\u6c42\u65f6\u95f4\u4e0d\u5728\u5de5\u827a\u8def\u7ebf\u6a21\u578b\u7684\u6709\u6548\u671f\u5185", (String)"CapacityScheduReportQuery_18", (String)"mmc-mps-report", (Object[])new Object[0])).append("\n");
                    continue;
                }
                map.put("processroute", routeId.get(dynamicObject.getLong("id")));
                dataMessage_all.add(map);
                continue;
            }
            tipMessage.append(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u7801\uff1a", (String)"CapacityScheduReportQuery_9", (String)"mmc-mps-report", (Object[])new Object[0])).append(map.get("billno") == null ? " " : map.get("billno")).append(" ").append(ResManager.loadKDString((String)"\u6765\u6e90\u5355\u636e\u7f16\u7801\uff1a", (String)"CapacityScheduReportQuery_8", (String)"mmc-mps-report", (Object[])new Object[0])).append(map.get("plan_order_billno")).append("  ").append(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u7801\uff1a", (String)"CapacityScheduReportQuery_9", (String)"mmc-mps-report", (Object[])new Object[0])).append(ResManager.loadKDString((String)"\u6765\u6e90\u5355\u636e\u884c\u53f7\uff1a", (String)"CapacityScheduReportQuery_17", (String)"mmc-mps-report", (Object[])new Object[0])).append(map.get("sourcebillentryno")).append(" ").append(ResManager.loadKDString((String)"\u5de5\u827a\u8def\u7ebf\u6a21\u578b\u4e0d\u5b58\u5728\u8be5\u5de5\u827a\u8def\u7ebf", (String)"CapacityScheduReportQuery_15", (String)"mmc-mps-report", (Object[])new Object[0])).append("\n");
        }
    }

    public static Map<Long, DynamicObject> getMftByMat(Set<Long> materialList) {
        HashMap<Long, DynamicObject> matToMft = new HashMap<Long, DynamicObject>(16);
        Map materialmftinfo = BusinessDataServiceHelper.loadFromCache((String)"bd_materialmftinfo", (QFilter[])new QFilter[]{new QFilter("masterid.id", "in", materialList)});
        for (DynamicObject dynamicObject : materialmftinfo.values()) {
            Long matId = dynamicObject.getLong("masterid.id");
            matToMft.put(matId, dynamicObject);
        }
        return matToMft;
    }

    public static Map<Long, DynamicObject> getRouteFromCache(Map<Long, DynamicObject> mftmaterials, DynamicObject org) {
        DynamicObject processroute;
        HashMap<Long, DynamicObject> routeMap = new HashMap<Long, DynamicObject>(16);
        if (mftmaterials == null || mftmaterials.size() == 0 || org == null) {
            return routeMap;
        }
        HashMap<Long, DynamicObject> mftmaterials_clone = new HashMap<Long, DynamicObject>(mftmaterials);
        Long startdate = System.currentTimeMillis();
        QFilter statusFilter = new QFilter("ismainprocess", "=", (Object)"1");
        statusFilter.and(new QFilter("status", "=", (Object)"C"));
        statusFilter.and(new QFilter("enable", "=", (Object)"1"));
        QFilter orgqFilter = BaseDataServiceHelper.getBaseDataFilter((String)ReportQueryUtils.getKeyEntityID(), (Long)org.getLong("id"));
        QFilter typeA = new QFilter("processtype", "=", (Object)"A");
        QFilter typeB = new QFilter("processtype", "=", (Object)"B");
        QFilter typeC = new QFilter("processtype", "=", (Object)"C");
        QFilter materialFilter = new QFilter("material.id", "in", mftmaterials.keySet());
        Map processrouteMap = BusinessDataServiceHelper.loadFromCache((String)ReportQueryUtils.getKeyEntityID(), (QFilter[])new QFilter[]{orgqFilter, typeA, materialFilter, statusFilter});
        for (Map.Entry mapEntry_processroute : processrouteMap.entrySet()) {
            DynamicObject value = (DynamicObject)mapEntry_processroute.getValue();
            routeMap.put(value.getLong("material.id"), value);
            mftmaterials_clone.remove(value.getLong("material.id"));
        }
        if (mftmaterials_clone.size() == 0) {
            return routeMap;
        }
        HashMap matToGroupIdList = new HashMap(16);
        ArrayList<Long> grouplist = new ArrayList<Long>();
        for (Map.Entry entry : mftmaterials_clone.entrySet()) {
            DynamicObject value = (DynamicObject)entry.getValue();
            Iterator matId = (Long)entry.getKey();
            DynamicObjectCollection dynamicObjectCollection = value.getDynamicObjectCollection("mftcontrolentry");
            for (DynamicObject group : dynamicObjectCollection) {
                ArrayList<Long> groupIdList;
                grouplist.add((Long)group.getDynamicObject("materialcontrol").getPkValue());
                if (matToGroupIdList.containsKey(matId)) {
                    groupIdList = (ArrayList<Long>)matToGroupIdList.get(matId);
                    groupIdList.add((Long)group.getDynamicObject("materialcontrol").getPkValue());
                    continue;
                }
                groupIdList = new ArrayList<Long>(16);
                groupIdList.add((Long)group.getDynamicObject("materialcontrol").getPkValue());
                matToGroupIdList.put(matId, groupIdList);
            }
        }
        HashMap<Long, Long> groupToRoute = new HashMap<Long, Long>(16);
        HashMap<Long, Date> hashMap = new HashMap<Long, Date>(16);
        if (!grouplist.isEmpty()) {
            Map routeByGroup = BusinessDataServiceHelper.loadFromCache((String)ReportQueryUtils.getKeyEntityID(), (QFilter[])new QFilter[]{orgqFilter, typeB, statusFilter, new QFilter("materialgroup", "in", grouplist)});
            for (Map.Entry entry : routeByGroup.entrySet()) {
                DynamicObject value = (DynamicObject)entry.getValue();
                Long groupId = value.getDynamicObject("materialgroup").getLong("id");
                groupToRoute.put(groupId, value.getLong("id"));
                hashMap.put(value.getLong("id"), value.getDate("audittime"));
            }
            for (Map.Entry entry : matToGroupIdList.entrySet()) {
                List groupList = (List)entry.getValue();
                Long matId = (Long)entry.getKey();
                Date initData = null;
                Long route = null;
                for (Long groupId : groupList) {
                    Long routeId = (Long)groupToRoute.get(groupId);
                    Date date = (Date)hashMap.get(routeId);
                    if (initData != null && date != null) {
                        if (!initData.before(date)) continue;
                        route = routeId;
                        initData = date;
                        continue;
                    }
                    initData = date;
                    route = routeId;
                }
                if (route == null) continue;
                mftmaterials_clone.remove(matId);
                routeMap.put(matId, (DynamicObject)routeByGroup.get(route));
            }
        }
        if (mftmaterials_clone.size() == 0) {
            return routeMap;
        }
        DynamicObject[] load = BusinessDataServiceHelper.load((String)ReportQueryUtils.getKeyEntityID(), (String)"id", (QFilter[])new QFilter[]{orgqFilter, typeC, statusFilter}, (String)"audittime desc", (int)1);
        if (load != null && load.length != 0 && (processroute = BusinessDataServiceHelper.loadSingle((String)ReportQueryUtils.getKeyEntityID(), (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)load[0].getLong("id"))})) != null) {
            log.info("processroute" + processroute.getString("number") + ":" + mftmaterials_clone.size());
            for (Long matId : mftmaterials_clone.keySet()) {
                routeMap.put(matId, processroute);
            }
        }
        return routeMap;
    }

    public static void getOrderRoute(List<Long> productionversionList, List<Map<String, Object>> dataMessage, List<Map<String, Object>> dataMessage_mservice, List<Map<String, Object>> dataMessage_all, List<Map<String, Object>> dataMessage_productionversion, Map<Long, List<Map<String, Object>>> routeId, Map<Long, Object[]> routeIdToDateRange, StringBuilder tipMessage) {
        for (Map<String, Object> map : dataMessage) {
            Object processroute = map.get("processroute");
            if (processroute == null) {
                Object productionversion = map.get("productionversion");
                if (productionversion == null) {
                    Object material_code = map.get("materiel_code");
                    if (material_code == null) continue;
                    dataMessage_mservice.add(map);
                    continue;
                }
                productionversionList.add((Long)productionversion);
                dataMessage_productionversion.add(map);
                continue;
            }
            Object exsitProcessroute = ReportQueryUtils.isExsitRangeDate(map, routeIdToDateRange, processroute);
            if (routeId.containsKey(processroute)) {
                if (exsitProcessroute == null) {
                    tipMessage.append(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u7801\uff1a", (String)"CapacityScheduReportQuery_9", (String)"mmc-mps-report", (Object[])new Object[0])).append(map.get("billno") == null ? "" : map.get("billno")).append(" ").append(ResManager.loadKDString((String)"\u6765\u6e90\u5355\u636e\u7f16\u7801\uff1a", (String)"CapacityScheduReportQuery_8", (String)"mmc-mps-report", (Object[])new Object[0])).append(map.get("plan_order_billno")).append("  ").append(ResManager.loadKDString((String)"\u6765\u6e90\u5355\u636e\u884c\u53f7\uff1a", (String)"CapacityScheduReportQuery_17", (String)"mmc-mps-report", (Object[])new Object[0])).append(map.get("sourcebillentryno")).append(" ").append(ResManager.loadKDString((String)"\u9700\u6c42\u65f6\u95f4\u4e0d\u5728\u5de5\u827a\u8def\u7ebf\u6a21\u578b\u7684\u6709\u6548\u671f\u5185", (String)"CapacityScheduReportQuery_18", (String)"mmc-mps-report", (Object[])new Object[0])).append("\n");
                    continue;
                }
                List<Map<String, Object>> routeList = routeId.get(processroute);
                map.put("processroute", routeList);
                dataMessage_all.add(map);
                continue;
            }
            tipMessage.append(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u7801\uff1a", (String)"CapacityScheduReportQuery_9", (String)"mmc-mps-report", (Object[])new Object[0])).append(map.get("billno") == null ? "" : map.get("billno")).append(" ").append(ResManager.loadKDString((String)"\u6765\u6e90\u5355\u636e\u7f16\u7801\uff1a", (String)"CapacityScheduReportQuery_8", (String)"mmc-mps-report", (Object[])new Object[0])).append(map.get("plan_order_billno")).append("  ").append(ResManager.loadKDString((String)"\u6765\u6e90\u5355\u636e\u884c\u53f7\uff1a", (String)"CapacityScheduReportQuery_17", (String)"mmc-mps-report", (Object[])new Object[0])).append(map.get("sourcebillentryno")).append(" ").append(ResManager.loadKDString((String)"\u5de5\u827a\u8def\u7ebf\u6a21\u578b\u4e0d\u5b58\u5728\u8be5\u5de5\u827a\u8def\u7ebf", (String)"CapacityScheduReportQuery_15", (String)"mmc-mps-report", (Object[])new Object[0])).append("\n");
        }
    }

    private static Object isExsitRangeDate(Map<String, Object> dataMessage, Map<Long, Object[]> routeIdToDateRange, Object processroute) {
        Object[] objects;
        if (dataMessage.containsKey("requiredate")) {
            Date requiredate = (Date)dataMessage.get("requiredate");
            objects = routeIdToDateRange.get(processroute);
            if (objects != null) {
                if (objects[0] != null) {
                    if (!((Date)objects[0]).after(requiredate) && !((Date)objects[1]).before(requiredate)) {
                        return processroute;
                    }
                    return null;
                }
                return processroute;
            }
        }
        if (dataMessage.containsKey("pls_date")) {
            Date pls_date = (Date)dataMessage.get("pls_date");
            objects = routeIdToDateRange.get(processroute);
            if (objects != null) {
                if (objects[1] != null) {
                    if (!((Date)objects[0]).after(pls_date) && !((Date)objects[1]).before(pls_date)) {
                        return processroute;
                    }
                    return null;
                }
                return processroute;
            }
        }
        return null;
    }

    public static List<Map<String, Object>> resourceDataFill(List<Map<String, Object>> planDataMessage_route, Map<Long, Object[]> planWorkCenter, Map<Long, String> measureunits, String sign, List<Map<String, Object>> planDataMessage_save) {
        ArrayList<Map<String, Object>> planDataMessage = new ArrayList<Map<String, Object>>(16);
        ArrayList<Map<String, Object>> planDataMessage_route_clone = new ArrayList<Map<String, Object>>(planDataMessage_route);
        HashMap<String, BigDecimal> convToCoeff = new HashMap<String, BigDecimal>(16);
        HashMap<String, Long> baseTimeMap = new HashMap<String, Long>(16);
        Map<Long, List<Long>> measureunitconv = ReportQueryUtils.getMeasureunitconv(convToCoeff, baseTimeMap);
        for (Map map : planDataMessage_route_clone) {
            Object processroute = map.get("processroute");
            if (processroute == null) continue;
            List processrouteList = (List)processroute;
            HashMap<Long, Map<Long, BigDecimal>> actentryMap = new HashMap<Long, Map<Long, BigDecimal>>(16);
            if (processrouteList != null && processrouteList.size() != 0) {
                HashMap<String, Object> map_clone;
                for (Map map2 : processrouteList) {
                    Object workcenter = map2.get("workcenter");
                    if (!planWorkCenter.containsKey(workcenter)) continue;
                    map.put("workcenter", workcenter);
                    map.put("operationno", map2.get("operationno"));
                    map.put("productionworkshop", map2.get("productionworkshop"));
                    Object baseqty_obj = map2.get("qty");
                    BigDecimal baseqty = BigDecimal.ZERO;
                    if (baseqty_obj instanceof BigDecimal) {
                        baseqty = (BigDecimal)baseqty_obj;
                    }
                    map.put("activity", map2.get("activity"));
                    Object actresource = map2.get("actresource");
                    if (actresource != null) {
                        map.put("actresource", actresource);
                        map_clone = new HashMap(map);
                        ReportQueryUtils.calcTime(map2, map_clone, convToCoeff, measureunitconv, baseTimeMap, measureunits, baseqty, sign, actentryMap, workcenter);
                        planDataMessage_save.add(map_clone);
                        continue;
                    }
                    map.put("actresource", 0L);
                    map_clone = new HashMap(map);
                    ReportQueryUtils.calcTime(map2, map_clone, convToCoeff, measureunitconv, baseTimeMap, measureunits, baseqty, sign, actentryMap, workcenter);
                    planDataMessage_save.add(map_clone);
                }
                for (Map.Entry entry : actentryMap.entrySet()) {
                    Long workcenterId = (Long)entry.getKey();
                    Map actMap = (Map)entry.getValue();
                    for (Map.Entry mapEntry_act : actMap.entrySet()) {
                        map.put("workcenter", workcenterId);
                        map.put("actresource", mapEntry_act.getKey());
                        map.put("lastqty", mapEntry_act.getValue());
                        map_clone = new HashMap<String, Object>(map);
                        planDataMessage.add(map_clone);
                    }
                }
                continue;
            }
            map.put("actresource", 0L);
            planDataMessage_save.add(map);
            planDataMessage.add(map);
        }
        return planDataMessage;
    }

    public static List<Map<String, Object>> resourceDataFill_Detail(List<Map<String, Object>> planDataMessage_route, Map<Long, Object[]> planWorkCenter, Map<Long, String> measureunits, String sign) {
        HashMap<String, BigDecimal> convToCoeff = new HashMap<String, BigDecimal>(16);
        HashMap<String, Long> baseTimeMap = new HashMap<String, Long>(16);
        Map<Long, List<Long>> measureunitconv = ReportQueryUtils.getMeasureunitconv(convToCoeff, baseTimeMap);
        ArrayList<Map<String, Object>> planDataMessage_clone = new ArrayList<Map<String, Object>>();
        for (Map<String, Object> map : planDataMessage_route) {
            HashMap dataMessage = new HashMap(16);
            Object processroute = map.get("processroute");
            if (processroute != null) {
                List processrouteList = (List)processroute;
                if (processrouteList != null && processrouteList.size() != 0) {
                    for (Map processentry : processrouteList) {
                        BigDecimal capacity;
                        HashMap<String, Object> map_clone;
                        Object workcenter = processentry.get("workcenter");
                        if (!planWorkCenter.containsKey(workcenter)) continue;
                        Object baseqty_obj = processentry.get("qty");
                        map.put("workcenter", workcenter);
                        BigDecimal baseqty = BigDecimal.ZERO;
                        if (baseqty_obj instanceof BigDecimal) {
                            baseqty = (BigDecimal)baseqty_obj;
                        }
                        map.put("activity", processentry.get("activity"));
                        Object actresource = processentry.get("actresource");
                        HashMap<Long, HashMap<String, Object>> acToMessage = (HashMap<Long, HashMap<String, Object>>)dataMessage.get(workcenter);
                        Long actresource_l = 0L;
                        if (actresource != null) {
                            actresource_l = Long.parseLong(actresource.toString());
                        }
                        if (acToMessage == null) {
                            acToMessage = new HashMap<Long, HashMap<String, Object>>(16);
                            dataMessage.put((Long)workcenter, acToMessage);
                            map_clone = new HashMap<String, Object>(map);
                            map_clone.put("actresource", actresource_l);
                            capacity = ReportQueryUtils.getCapacity(sign, map_clone, processentry, measureunitconv, baseTimeMap, convToCoeff, measureunits, baseqty);
                            map_clone.put("lastqty", capacity);
                            acToMessage.put(actresource_l, map_clone);
                            continue;
                        }
                        map_clone = (HashMap<String, Object>)acToMessage.get(actresource_l);
                        if (map_clone != null) {
                            capacity = ReportQueryUtils.getCapacity(sign, map, processentry, measureunitconv, baseTimeMap, convToCoeff, measureunits, baseqty);
                            Object lastqty = map_clone.get("lastqty");
                            if (lastqty != null) {
                                capacity = capacity.add(new BigDecimal(lastqty.toString()));
                            }
                            map_clone.put("lastqty", capacity);
                            continue;
                        }
                        map_clone = new HashMap<String, Object>(map);
                        map_clone.put("actresource", actresource_l);
                        capacity = ReportQueryUtils.getCapacity(sign, map_clone, processentry, measureunitconv, baseTimeMap, convToCoeff, measureunits, baseqty);
                        map_clone.put("lastqty", capacity);
                        acToMessage.put(actresource_l, map_clone);
                    }
                } else {
                    map.put("actresource", 0L);
                }
            }
            for (Map.Entry mapEntry : dataMessage.entrySet()) {
                Map acToMessage = (Map)mapEntry.getValue();
                planDataMessage_clone.addAll(acToMessage.values());
            }
        }
        return planDataMessage_clone;
    }

    private static BigDecimal getCapacity(String sign, Map<String, Object> map, Map<String, Object> processentry, Map<Long, List<Long>> measureunitconv, Map<String, Long> baseTimeMap, Map<String, BigDecimal> convToCoeff, Map<Long, String> measureunits, BigDecimal baseqty) {
        Object orderNnum = null;
        orderNnum = "plan".equals(sign) ? map.get("order_num") : map.get("plsqty");
        Object unitId = processentry.get("unit");
        Long convId = ReportQueryUtils.checkUnitRule(unitId, measureunitconv, baseTimeMap, measureunits);
        if (unitId != null && unitId.equals(8L)) {
            convId = (Long)unitId;
        }
        BigDecimal coeff = ReportQueryUtils.getCoeff(convId, measureunits, baseTimeMap, unitId, convToCoeff);
        if (orderNnum != null) {
            BigDecimal multiply = baseqty.multiply(coeff).multiply(new BigDecimal(orderNnum.toString()));
            return multiply;
        }
        return BigDecimal.ZERO;
    }

    public static Map<Long, Date> getRouteCreatTime(Set<Long> routeIds) {
        HashMap<Long, Date> routeidToCreatTime = new HashMap<Long, Date>(16);
        DynamicObjectCollection query = QueryServiceHelper.query((String)"pdm_route", (String)"id,audittime", (QFilter[])new QFilter[]{new QFilter("id", "in", routeIds)});
        for (DynamicObject dynamicObject : query) {
            routeidToCreatTime.put(dynamicObject.getLong("id"), dynamicObject.getDate("audittime"));
        }
        return routeidToCreatTime;
    }

    public static Map<String, List<Map<String, Object>>> getMatcthItemRoute(Map<String, String> matchItem, List<Map<String, Object>> routeDataMessage, Map<Long, Date> routeIdToCreatTime) {
        HashMap<String, List<Map<String, Object>>> matchItemToRouteId = new HashMap<String, List<Map<String, Object>>>(16);
        HashMap<String, Date> exsitRouteIdToCreatTime = new HashMap<String, Date>(16);
        for (Map<String, Object> map : routeDataMessage) {
            List<Map<String, Object>> maps;
            StringBuilder sb = new StringBuilder();
            Object processroute = map.get("processroute");
            for (String field : matchItem.keySet()) {
                sb.append(map.get(field)).append(",");
            }
            if (matchItemToRouteId.containsKey(sb.toString())) {
                maps = (List)matchItemToRouteId.get(sb.toString());
                Date date = (Date)exsitRouteIdToCreatTime.get(sb.toString());
                if (!date.before(routeIdToCreatTime.get(processroute))) continue;
                maps.clear();
                maps.add(map);
                exsitRouteIdToCreatTime.put(sb.toString(), routeIdToCreatTime.get(processroute));
                continue;
            }
            maps = new ArrayList(16);
            maps.add(map);
            matchItemToRouteId.put(sb.toString(), maps);
            exsitRouteIdToCreatTime.put(sb.toString(), routeIdToCreatTime.get(processroute));
        }
        return matchItemToRouteId;
    }

    public static Map<Long, String> getMeasureunits() {
        HashMap<Long, String> unitIdToNumber = new HashMap<Long, String>(16);
        DynamicObjectCollection query = QueryServiceHelper.query((String)"bd_measureunits", (String)"id,number", (QFilter[])new QFilter[]{new QFilter("id", "!=", (Object)0L)});
        for (DynamicObject dynamicObject : query) {
            unitIdToNumber.put(dynamicObject.getLong("id"), dynamicObject.getString("number"));
        }
        return unitIdToNumber;
    }

    public static Map<String, Long> getMeasureunitNumber() {
        HashMap<String, Long> unitIdToNumber = new HashMap<String, Long>(16);
        DynamicObjectCollection query = QueryServiceHelper.query((String)"bd_measureunits", (String)"id,number", (QFilter[])new QFilter[]{new QFilter("id", "!=", (Object)0L)});
        for (DynamicObject dynamicObject : query) {
            unitIdToNumber.put(dynamicObject.getString("number"), dynamicObject.getLong("id"));
        }
        return unitIdToNumber;
    }

    public static void calcTime(Map<String, Object> processentry, Map<String, Object> map, Map<String, BigDecimal> convToCoeff, Map<Long, List<Long>> measureunitconv, Map<String, Long> baseTimeMap, Map<Long, String> measureunits, BigDecimal baseqty, String sign, Map<Long, Map<Long, BigDecimal>> workToactentryMap, Object workcenterId) {
        Object activtyprocessstage = processentry.get("activtyprocessstage");
        Object orderNnum = null;
        if ("plan".equals(sign)) {
            orderNnum = map.get("order_num");
            map.put("exsitbilltype", "A");
        } else {
            orderNnum = map.get("plsqty");
            map.put("exsitbilltype", "B");
        }
        map.put("activtyprocessstage", activtyprocessstage);
        Object unitId = processentry.get("unit");
        map.put("unitId", unitId);
        map.put("baseqty", baseqty);
        map.put("processroute", processentry.get("processroute"));
        map.put("resourcedetailname", processentry.get("resourcedetailname"));
        map.put("resourcedetailnumber", processentry.get("resourcedetailnumber"));
        Long convId = ReportQueryUtils.checkUnitRule(unitId, measureunitconv, baseTimeMap, measureunits);
        if (unitId != null && unitId.equals(8L)) {
            convId = (Long)unitId;
        }
        BigDecimal coeff = ReportQueryUtils.getCoeff(convId, measureunits, baseTimeMap, unitId, convToCoeff);
        if (orderNnum != null) {
            BigDecimal multiply = baseqty.multiply(coeff).multiply(new BigDecimal(orderNnum.toString()));
            map.put("coeff", coeff);
            Long actresourceId = (Long)map.get("actresource");
            if (workToactentryMap.containsKey(workcenterId)) {
                Map<Long, BigDecimal> actentryMap = workToactentryMap.get(workcenterId);
                BigDecimal allMultiply = BigDecimal.ZERO;
                if (actentryMap.containsKey(actresourceId)) {
                    BigDecimal lastqty = actentryMap.get(actresourceId);
                    if (lastqty != null) {
                        allMultiply = multiply.add(new BigDecimal(((Object)lastqty).toString()));
                    }
                } else {
                    allMultiply = multiply;
                }
                actentryMap.put(actresourceId, allMultiply);
            } else {
                HashMap<Long, BigDecimal> actentryMap = new HashMap<Long, BigDecimal>(16);
                workToactentryMap.put((Long)workcenterId, actentryMap);
                actentryMap.put(actresourceId, multiply);
            }
            map.put("lastqty", multiply);
        }
    }

    public static DataSet timeCov(DataSet dataSet_filter, String timeunit) {
        HashMap<String, BigDecimal> convToCoeff = new HashMap<String, BigDecimal>(16);
        HashMap<String, Long> baseTimeMap = new HashMap<String, Long>(16);
        ReportQueryUtils.getMeasureunitconv(convToCoeff, baseTimeMap);
        Map<String, Long> measureunitNumber = ReportQueryUtils.getMeasureunitNumber();
        Map<Long, String> measureunits = ReportQueryUtils.getMeasureunits();
        Long second = (Long)baseTimeMap.get("second");
        Long timeUnitId = measureunitNumber.get(timeunit);
        Boolean isMu = true;
        BigDecimal coeff = ReportQueryUtils.getCoeffByBaseUnit(timeUnitId, measureunits, baseTimeMap, second, convToCoeff);
        if (coeff == null) {
            String unitconvKey = second + "," + timeUnitId;
            coeff = (BigDecimal)convToCoeff.get(unitconvKey);
            isMu = false;
        }
        if (coeff != null) {
            DataSet dataSet = dataSet_filter.updateFields(new String[]{"download", "planlaod", "ratecapacity"}, new String[]{"case when download = null then 0 else download end", "case when planlaod = null then 0 else planlaod end", "case when ratecapacity = null then 0 else ratecapacity end"});
            DataSet dataSet2 = dataSet.addField(coeff.toString(), "coeff");
            DataSet dataSet1 = null;
            dataSet1 = isMu != false ? dataSet2.updateFields(new String[]{"download", "planlaod", "ratecapacity"}, new String[]{"case when download = 0 then 0 else Round(download/coeff,2) end", "case when planlaod = 0 then 0 else  Round(planlaod/coeff,2) end", "case when ratecapacity = 0 then 0 else  Round(ratecapacity/coeff,2) end"}) : dataSet2.updateFields(new String[]{"download", "planlaod", "ratecapacity"}, new String[]{"case when download = 0 then 0 else Round(download*coeff,2) end", "case when planlaod = 0 then 0 else  Round(planlaod*coeff,2) end", "case when ratecapacity = 0 then 0 else  Round(ratecapacity*coeff,2) end"});
            DataSet dataSet3 = dataSet1.updateField("allload", "download+planlaod");
            return dataSet3;
        }
        throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5355\u4f4d:%1$s\u4e0d\u5b58\u5728\u76ee\u6807\u5355\u4f4d\u4e3a\u79d2\u7684\u901a\u7528\u5355\u4f4d\u6362\u7b97\u5173\u7cfb\u3002", (String)"CapacityScheduReportQuery_22", (String)"mmc-mps-report", (Object[])new Object[0]), timeunit));
    }

    public static BigDecimal getCoeff(Long convId, Map<Long, String> measureunits, Map<String, Long> baseTimeMap, Object unitId, Map<String, BigDecimal> convToCoeff) {
        BigDecimal allCoeff = BigDecimal.ZERO;
        if (measureunits.containsKey(convId)) {
            String unitNumber = measureunits.get(convId);
            Long hour = baseTimeMap.get("hour");
            Long minute = baseTimeMap.get("minute");
            Long second = baseTimeMap.get("second");
            if ("hour".equals(unitNumber)) {
                String unitconvKey = unitId + "," + convId;
                BigDecimal coeff = convToCoeff.get(unitconvKey);
                unitconvKey = hour + "," + minute;
                BigDecimal coeff_hour = convToCoeff.get(unitconvKey);
                unitconvKey = minute + "," + second;
                BigDecimal coeff_minute = convToCoeff.get(unitconvKey);
                allCoeff = coeff == null || coeff_hour == null || coeff_minute == null ? BigDecimal.ONE : coeff.multiply(coeff_hour).multiply(coeff_minute);
            } else if ("minute".equals(unitNumber)) {
                String unitconvKey = unitId + "," + convId;
                BigDecimal coeff = convToCoeff.get(unitconvKey);
                if (coeff == null) {
                    coeff = BigDecimal.ONE;
                }
                unitconvKey = minute + "," + second;
                BigDecimal coeff_minute = convToCoeff.get(unitconvKey);
                allCoeff = coeff.multiply(coeff_minute);
            } else if ("second".equals(unitNumber)) {
                if (convId.equals(unitId)) {
                    allCoeff = BigDecimal.ONE;
                } else {
                    String unitconvKey = unitId + "," + convId;
                    BigDecimal coeff = convToCoeff.get(unitconvKey);
                    if (coeff != null) {
                        allCoeff = coeff;
                    }
                }
            }
        }
        return allCoeff;
    }

    public static Long checkUnitRule(Object unitId, Map<Long, List<Long>> measureunitconv, Map<String, Long> baseTimeMap, Map<Long, String> measureunits) {
        List<Long> childerUnit = measureunitconv.get(unitId);
        if (childerUnit != null) {
            if (unitId.equals(8L)) {
                return 8L;
            }
            ArrayList<Long> childerUnit_clone = new ArrayList<Long>(childerUnit);
            childerUnit_clone.retainAll(baseTimeMap.values());
            String unitNumber = measureunits.get(unitId);
            if (childerUnit_clone.size() > 1) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5355\u4f4d%1$s\u5b58\u5728\u591a\u6761\u76ee\u6807\u5355\u4f4d\u4e3a\u65f6\u3001\u5206\u3001\u79d2\u7684\u901a\u7528\u5355\u4f4d\u6362\u7b97\u5173\u7cfb\u3002", (String)"CapacityScheduReportQuery_6", (String)"mmc-mps-report", (Object[])new Object[0]), unitNumber));
            }
            if (childerUnit_clone.size() == 0) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5355\u4f4d:%1$s\u4e0d\u5b58\u5728\u76ee\u6807\u5355\u4f4d\u4e3a\u65f6\uff0c\u5206\uff0c\u79d2\u7684\u901a\u7528\u5355\u4f4d\u6362\u7b97\u5173\u7cfb\u3002", (String)"CapacityScheduReportQuery_7", (String)"mmc-mps-report", (Object[])new Object[0]), unitNumber));
            }
            return (Long)childerUnit_clone.get(0);
        }
        return 0L;
    }

    public static String getKeyEntityID() {
        return "pdm_route";
    }

    public static void getRouteByMatchItem(List<Map<String, Object>> planDataMessage, Map<String, List<Map<String, Object>>> matcthItemRoute, Map<Long, List<Map<String, Object>>> routeMps, Map<String, String> matchItem, StringBuilder tipMessage) {
        for (Map<String, Object> map : planDataMessage) {
            StringBuilder sb = new StringBuilder();
            for (String field : matchItem.values()) {
                sb.append(map.get(field)).append(",");
            }
            List<Map<String, Object>> routeList = matcthItemRoute.get(sb.toString());
            map.remove("processroute");
            if (routeList == null) {
                tipMessage.append(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u7801\uff1a", (String)"CapacityScheduReportQuery_9", (String)"mmc-mps-report", (Object[])new Object[0])).append(map.get("billno") == null ? " " : map.get("billno")).append(" ").append(ResManager.loadKDString((String)"\u6765\u6e90\u5355\u636e\u7f16\u7801\uff1a", (String)"CapacityScheduReportQuery_8", (String)"mmc-mps-report", (Object[])new Object[0])).append(map.get("plan_order_billno")).append("  ").append(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u7801\uff1a", (String)"CapacityScheduReportQuery_9", (String)"mmc-mps-report", (Object[])new Object[0])).append(map.get("billno")).append(ResManager.loadKDString((String)"\u4e0d\u5b58\u5728\u5de5\u827a\u8def\u7ebf", (String)"CapacityScheduReportQuery_5", (String)"mmc-mps-report", (Object[])new Object[0])).append("\n");
                continue;
            }
            map.put("processroute", routeList);
        }
    }

    public static void putResourceCapaDataToSignData(Map<Long, Map<Integer, Map<Long, Map<Integer, Map<String, Object>>>>> signToData_new, Map<Long, Map<Integer, Map<Long, Map<Integer, Map<String, Object>>>>> signToData) {
        for (Map.Entry<Long, Map<Integer, Map<Long, Map<Integer, Map<String, Object>>>>> mapEntry : signToData_new.entrySet()) {
            Long workcenterId = mapEntry.getKey();
            Map<Integer, Map<Long, Map<Integer, Map<String, Object>>>> yearToValueMessage_new = mapEntry.getValue();
            if (!signToData.containsKey(workcenterId)) continue;
            Map<Integer, Map<Long, Map<Integer, Map<String, Object>>>> yearToValueMessage = signToData.get(workcenterId);
            for (Map.Entry<Integer, Map<Long, Map<Integer, Map<String, Object>>>> entry_year : yearToValueMessage_new.entrySet()) {
                Integer year = entry_year.getKey();
                Map<Long, Map<Integer, Map<String, Object>>> resourcevalueMessage_new = entry_year.getValue();
                if (yearToValueMessage.containsKey(year)) {
                    Map<Long, Map<Integer, Map<String, Object>>> valueMessage = yearToValueMessage.get(year);
                    for (Map.Entry<Long, Map<Integer, Map<String, Object>>> valueMessage_new : resourcevalueMessage_new.entrySet()) {
                        Map<Integer, Map<String, Object>> value = valueMessage_new.getValue();
                        Long resourceId = valueMessage_new.getKey();
                        if (!valueMessage.containsKey(resourceId)) continue;
                        Map<Integer, Map<String, Object>> integerMapMap = valueMessage.get(resourceId);
                        integerMapMap.putAll(value);
                    }
                    continue;
                }
                yearToValueMessage.put(year, resourcevalueMessage_new);
            }
        }
    }

    public static void putPlanloadQtyToMap(List<Map<String, Object>> planDataMessage_qty, Map<Long, Map<Integer, Map<Long, Map<Integer, Map<String, Object>>>>> signToData, String cycle, Map<Integer, Map<Integer, String>> dayToDate, Map<Integer, Map<Integer, String>> yearToWeekTorange) {
        for (Map<String, Object> map : planDataMessage_qty) {
            Date sheduledate = (Date)map.get("requiredate");
            Long workcentre = (Long)map.get("workcenter");
            Object actresource = map.get("actresource");
            if (actresource == null) {
                actresource = 0L;
            }
            int year = sheduledate.getYear() + 1900;
            int value = "mon".equals(cycle) ? sheduledate.getMonth() + 1 : ("wek".equals(cycle) ? ReportQueryUtils.calculateWeek(sheduledate, yearToWeekTorange) : ("qua".equals(cycle) ? sheduledate.getMonth() / 3 + 1 : ReportQueryUtils.calculateDay(sheduledate, dayToDate)));
            Map map_num = null;
            Map<Object, Object> resourceToTimeMessage = null;
            Map timeToMessage = null;
            Map<Integer, Map<Long, Map<Integer, Map<String, Object>>>> yearToResourceTimeMessage = signToData.get(workcentre);
            if (yearToResourceTimeMessage == null) {
                yearToResourceTimeMessage = new HashMap<Integer, Map<Long, Map<Integer, Map<String, Object>>>>(8);
                resourceToTimeMessage = new HashMap(16);
                timeToMessage = new HashMap(16);
                resourceToTimeMessage.put((Long)actresource, timeToMessage);
                yearToResourceTimeMessage.put(year, resourceToTimeMessage);
                signToData.put(workcentre, yearToResourceTimeMessage);
            } else if (yearToResourceTimeMessage.containsKey(year)) {
                resourceToTimeMessage = yearToResourceTimeMessage.get(year);
                if (resourceToTimeMessage == null) {
                    resourceToTimeMessage = new HashMap(16);
                    timeToMessage = new HashMap(16);
                    if (actresource == null) {
                        actresource = 0L;
                    }
                    resourceToTimeMessage.put((Long)actresource, timeToMessage);
                } else {
                    timeToMessage = (Map)resourceToTimeMessage.get(actresource);
                    if (timeToMessage == null) {
                        timeToMessage = new HashMap(16);
                        resourceToTimeMessage.put((Long)actresource, timeToMessage);
                    } else {
                        map_num = (Map)timeToMessage.get(value);
                    }
                }
            } else {
                resourceToTimeMessage = new HashMap(16);
                yearToResourceTimeMessage.put(year, resourceToTimeMessage);
                timeToMessage = new HashMap(16);
                resourceToTimeMessage.put((Long)actresource, timeToMessage);
            }
            if (map_num != null) {
                BigDecimal allload;
                Object planlaod = map_num.get("planlaod");
                BigDecimal load = BigDecimal.ZERO;
                if (planlaod != null) {
                    load = new BigDecimal(planlaod.toString());
                }
                Object lastqty = map.get("lastqty");
                BigDecimal plsqty = BigDecimal.ZERO;
                if (lastqty != null) {
                    plsqty = (BigDecimal)lastqty;
                }
                load = load.add(plsqty);
                map_num.put("planlaod", load);
                map_num.put("allload", load);
                Object download_num = map_num.get("download");
                if (download_num != null) {
                    BigDecimal bigDecimal = new BigDecimal(download_num.toString());
                    allload = load.add(bigDecimal);
                } else {
                    allload = load;
                }
                map_num.put("allload", allload);
                continue;
            }
            HashMap<String, Object> keyToData = new HashMap<String, Object>(8);
            BigDecimal plsqty = (BigDecimal)map.get("lastqty");
            if (plsqty == null || BigDecimal.ZERO.compareTo(plsqty) == 0) {
                plsqty = (BigDecimal)map.get("plsqty");
            }
            if (plsqty == null || BigDecimal.ZERO.compareTo(plsqty) == 0) continue;
            keyToData.put("year", year);
            keyToData.put("cycle_r", cycle);
            keyToData.put("actresource", actresource);
            keyToData.put("workcenter_r", workcentre);
            keyToData.put("planlaod", plsqty);
            BigDecimal allload = plsqty;
            keyToData.put("allload", allload);
            timeToMessage.put(value, keyToData);
        }
    }

    public static BigDecimal getCoeffByBaseUnit(Long convId, Map<Long, String> measureunits, Map<String, Long> baseTimeMap, Object unitId, Map<String, BigDecimal> convToCoeff) {
        BigDecimal allCoeff = null;
        if (measureunits.containsKey(convId)) {
            String unitNumber = measureunits.get(convId);
            Long hour = baseTimeMap.get("hour");
            Long minute = baseTimeMap.get("minute");
            Long second = baseTimeMap.get("second");
            if ("hour".equals(unitNumber)) {
                String unitconvKey = hour + "," + minute;
                BigDecimal coeff_hour = convToCoeff.get(unitconvKey);
                unitconvKey = minute + "," + second;
                BigDecimal coeff_minute = convToCoeff.get(unitconvKey);
                allCoeff = coeff_hour.multiply(coeff_minute);
            } else if ("minute".equals(unitNumber)) {
                BigDecimal coeff_minute;
                String unitconvKey = minute + "," + second;
                allCoeff = coeff_minute = convToCoeff.get(unitconvKey);
            } else {
                if ("second".equals(unitNumber)) {
                    return BigDecimal.ONE;
                }
                String unitconvKey = convId + "," + unitId;
                BigDecimal coeff = convToCoeff.get(unitconvKey);
                if (coeff != null) {
                    allCoeff = coeff;
                }
            }
        }
        return allCoeff;
    }

    public static List<Long> getTimeunitValue() {
        HashMap<String, BigDecimal> convToCoeff = new HashMap<String, BigDecimal>(16);
        HashMap<String, Long> baseTimeMap = new HashMap<String, Long>(16);
        Map<Long, List<Long>> measureunitconv = ReportQueryUtils.getMeasureunitconv(convToCoeff, baseTimeMap);
        ArrayList<Long> timeList = new ArrayList<Long>(16);
        if (baseTimeMap.size() == 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u9884\u7f6e\u7684\u65f6\u5206\u79d2\u7684\u57fa\u672c\u5355\u4f4d\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"ReportQueryUtils_1", (String)"mmc-mps-common", (Object[])new Object[0]));
        }
        DynamicObjectCollection query = QueryServiceHelper.query((String)"bd_measureunits", (String)"id,number,name", (QFilter[])new QFilter[]{new QFilter("group.number", "=", (Object)"Time")});
        for (DynamicObject dynamicObject : query) {
            Long id = dynamicObject.getLong("id");
            if (baseTimeMap.values().contains(id)) {
                timeList.add(id);
                continue;
            }
            List<Long> secondCov = measureunitconv.get(baseTimeMap.get("second"));
            if (secondCov != null && secondCov.contains(id)) {
                timeList.add(id);
                continue;
            }
            List<Long> otherUnitCov = measureunitconv.get(id);
            if (otherUnitCov == null || !otherUnitCov.contains(baseTimeMap.get("second"))) continue;
            timeList.add(id);
        }
        return timeList;
    }

    public static void saveCapacityloadDataToBackByResources(List<Map<String, Object>> saveDate, DynamicObject queryplan) {
        ORM orm = ORM.create();
        ArrayList<DynamicObject> dnyList = new ArrayList<DynamicObject>(16);
        int delete = DeleteServiceHelper.delete((String)"mps_capacityload", (QFilter[])new QFilter[]{new QFilter("scheduleplan.number", "=", (Object)queryplan.getString("number"))});
        for (Map<String, Object> map : saveDate) {
            DynamicObject capacityload = ReportQueryUtils.getDyn(orm, "mps_capacityload");
            if ("A".equals(map.get("exsitbilltype"))) {
                capacityload.set("billtype", (Object)"A");
                capacityload.set("org", map.get("production_org"));
                if (map.containsKey("sourceentryid")) {
                    capacityload.set("sourcebillentryid", map.get("sourceentryid"));
                }
                capacityload.set("sourcetype", map.get("billtype"));
                capacityload.set("sourcebillid", map.get("sourcebillid_old"));
                capacityload.set("billno", map.get("plan_order_billno"));
                capacityload.set("sourcebillentryno", map.get("sourcebillentryno"));
                capacityload.set("materiel_code", map.get("materiel_code"));
                capacityload.set("configure", map.get("configure"));
                capacityload.set("tracknumber", map.get("tracknumber"));
                capacityload.set("auxiliary", map.get("auxiliary"));
                capacityload.set("workcenter", map.get("workcenter"));
                capacityload.set("requirenum", map.get("order_num"));
                capacityload.set("requiredate", map.get("requiredate"));
                capacityload.set("processno", map.get("operationno"));
                capacityload.set("activity", map.get("activity"));
                capacityload.set("baseqty", map.get("baseqty"));
                capacityload.set("actresource", map.get("actresource"));
                capacityload.set("productionworkshop", map.get("productionworkshop"));
                capacityload.set("resourcedetailnumber", map.get("resourcedetailnumber"));
                capacityload.set("resourcedetailname", map.get("resourcedetailname"));
                capacityload.set("processroute", map.get("processroute"));
                capacityload.set("capacityload", map.get("lastqty"));
                capacityload.set("creater", (Object)RequestContext.getOrCreate().getCurrUserId());
                capacityload.set("createdate", (Object)TimeServiceHelper.now());
                capacityload.set("scheduleplan", (Object)queryplan.getLong("id"));
                dnyList.add(capacityload);
                continue;
            }
            capacityload.set("billtype", (Object)"B");
            capacityload.set("org", map.get("production_org"));
            capacityload.set("sourcebillid", map.get("sourcebillid"));
            if (map.containsKey("sourceentryid")) {
                capacityload.set("sourcebillentryid", map.get("sourceentryid"));
            }
            if (map.containsKey("sourcebillentryno")) {
                capacityload.set("sourcebillentryno", map.get("sourcebillentryno"));
            }
            capacityload.set("materiel_code", map.get("materiel_code"));
            capacityload.set("configure", map.get("configure"));
            capacityload.set("tracknumber", map.get("tracknumber"));
            capacityload.set("auxiliary", map.get("auxiliary"));
            capacityload.set("workcenter", map.get("workcenter"));
            capacityload.set("requirenum", map.get("plsqty"));
            capacityload.set("requiredate", map.get("pls_date"));
            capacityload.set("billno", map.get("billno"));
            capacityload.set("processno", map.get("operationno"));
            capacityload.set("activity", map.get("activity"));
            capacityload.set("baseqty", map.get("baseqty"));
            capacityload.set("actresource", map.get("actresource"));
            capacityload.set("productionworkshop", map.get("productionworkshop"));
            capacityload.set("capacityload", map.get("lastqty"));
            capacityload.set("creater", (Object)RequestContext.getOrCreate().getCurrUserId());
            capacityload.set("createdate", (Object)TimeServiceHelper.now());
            capacityload.set("scheduleplan", (Object)queryplan.getLong("id"));
            capacityload.set("resourcedetailnumber", map.get("resourcedetailnumber"));
            capacityload.set("resourcedetailname", map.get("resourcedetailname"));
            capacityload.set("processroute", map.get("processroute"));
            dnyList.add(capacityload);
        }
        if (dnyList.size() != 0) {
            SaveServiceHelper.save((DynamicObject[])dnyList.toArray(new DynamicObject[0]));
        }
    }

    public static void saveCapaDataToBackByResources(Map<Long, Map<Long, Map<Long, BigDecimal>>> resoureQty, DynamicObject queryplan, Map<Long, Object[]> planWorkCenter, Map<Long, String> measureunits, DynamicObject org, Map<Long, Map<Long, BigDecimal>> workcenterToResourceToQty, Map<Long, Map<Long, List<String>>> resourceDetail, Map<String, Map<Long, Map<String, Map<String, Object>>>> downTimePlan) {
        ORM orm = ORM.create();
        ArrayList<DynamicObject> dnyList = new ArrayList<DynamicObject>(16);
        log.info("mps_availablecapacity" + resoureQty.size());
        int delete = DeleteServiceHelper.delete((String)"mps_availablecapacity", (QFilter[])new QFilter[]{new QFilter("scheduleplan.number", "=", (Object)queryplan.getString("number"))});
        for (Map.Entry<Long, Map<Long, Map<Long, BigDecimal>>> workcenterResoureMap : resoureQty.entrySet()) {
            Long workcenterId = workcenterResoureMap.getKey();
            Map<Long, Map<Long, BigDecimal>> dateResoureMap = workcenterResoureMap.getValue();
            for (Map.Entry<Long, Map<Long, BigDecimal>> resoureMap : dateResoureMap.entrySet()) {
                Long strattime = resoureMap.getKey();
                Date date = new Date(strattime);
                Map<Long, BigDecimal> value = resoureMap.getValue();
                for (Map.Entry<Long, BigDecimal> capaEntry : value.entrySet()) {
                    Long resoureId = capaEntry.getKey();
                    Map<Long, List<String>> resourceMessage = resourceDetail.get(workcenterId);
                    if (resourceMessage == null) continue;
                    List<String> resources = resourceMessage.get(resoureId);
                    if (resources != null) {
                        for (String s : resources) {
                            Map<String, Map<String, Object>> dowmtimeMessage_detail;
                            Map<Long, Map<String, Map<String, Object>>> downResourceMessage;
                            if (s == null || !s.contains(",")) continue;
                            DynamicObject availableCapacity = ReportQueryUtils.getDyn(orm, "mps_availablecapacity");
                            availableCapacity.set("workcenter", (Object)workcenterId);
                            availableCapacity.set("org", (Object)org);
                            availableCapacity.set("date", (Object)date);
                            availableCapacity.set("availablecapacity", (Object)capaEntry.getValue());
                            availableCapacity.set("actresource", (Object)resoureId);
                            Map<Long, BigDecimal> resourceToQty = workcenterToResourceToQty.get(workcenterId);
                            if (resourceToQty != null) {
                                availableCapacity.set("actresourceqty", (Object)resourceToQty.get(resoureId));
                            }
                            availableCapacity.set("workshift", planWorkCenter.get(workcenterId)[0]);
                            for (Map.Entry<Long, String> mapEntry : measureunits.entrySet()) {
                                if (!"hour".equals(mapEntry.getValue())) continue;
                                availableCapacity.set("workshiftunit", (Object)mapEntry.getKey());
                                break;
                            }
                            availableCapacity.set("effect", planWorkCenter.get(workcenterId)[2]);
                            String downKey = workcenterId + "," + resoureId + "," + org.getLong("id");
                            if (downTimePlan == null) {
                                downTimePlan = new HashMap<String, Map<Long, Map<String, Map<String, Object>>>>(16);
                            }
                            if ((downResourceMessage = downTimePlan.get(downKey)) != null && (dowmtimeMessage_detail = downResourceMessage.get(date.getTime())) != null) {
                                for (Map.Entry<String, Map<String, Object>> mapEntry_detail : dowmtimeMessage_detail.entrySet()) {
                                    String detailKey = mapEntry_detail.getKey();
                                    Map<String, Object> dowmtimeMessage = mapEntry_detail.getValue();
                                    if (dowmtimeMessage == null || !detailKey.equals(s)) continue;
                                    Object qty = dowmtimeMessage.get("qty");
                                    Object time = dowmtimeMessage.get("time");
                                    Object unit = dowmtimeMessage.get("unit");
                                    BigDecimal downQty = BigDecimal.ZERO;
                                    BigDecimal downTime = BigDecimal.ZERO;
                                    if (qty != null) {
                                        downQty = new BigDecimal(qty.toString());
                                    }
                                    if (time != null) {
                                        downTime = new BigDecimal(time.toString());
                                    }
                                    BigDecimal multiply = downQty.multiply(downTime);
                                    BigDecimal lastQty = capaEntry.getValue();
                                    BigDecimal bigDecimal = BigDecimal.ZERO;
                                    if (resourceToQty != null) {
                                        bigDecimal = resourceToQty.get(resoureId);
                                    }
                                    if ((lastQty = lastQty.subtract(multiply)).compareTo(BigDecimal.ZERO) < 0) {
                                        lastQty = BigDecimal.ZERO;
                                    }
                                    availableCapacity.set("availablecapacity", (Object)lastQty);
                                    availableCapacity.set("actresourceqty", (Object)bigDecimal);
                                    availableCapacity.set("haltdate", (Object)downTime);
                                    availableCapacity.set("haltqty", (Object)downQty);
                                    availableCapacity.set("haltunit", unit);
                                }
                            }
                            availableCapacity.set("creater", (Object)RequestContext.getOrCreate().getCurrUserId());
                            availableCapacity.set("createdate", (Object)TimeServiceHelper.now());
                            availableCapacity.set("scheduleplan", (Object)queryplan.getLong("id"));
                            String[] split = s.split(",");
                            availableCapacity.set("resourcedetailnumber", (Object)split[0]);
                            availableCapacity.set("resourcedetailname", (Object)split[1]);
                            dnyList.add(availableCapacity);
                        }
                        continue;
                    }
                    DynamicObject availableCapacity = ReportQueryUtils.getDyn(orm, "mps_availablecapacity");
                    availableCapacity.set("workcenter", (Object)workcenterId);
                    availableCapacity.set("org", (Object)org);
                    availableCapacity.set("date", (Object)date);
                    availableCapacity.set("availablecapacity", (Object)capaEntry.getValue());
                    availableCapacity.set("actresource", (Object)resoureId);
                    Map<Long, BigDecimal> resourceToQty = workcenterToResourceToQty.get(workcenterId);
                    if (resourceToQty != null) {
                        availableCapacity.set("actresourceqty", (Object)resourceToQty.get(resoureId));
                    }
                    availableCapacity.set("workshift", planWorkCenter.get(workcenterId)[0]);
                    for (Map.Entry<Long, String> mapEntry : measureunits.entrySet()) {
                        if (!"hour".equals(mapEntry.getValue())) continue;
                        availableCapacity.set("workshiftunit", (Object)mapEntry.getKey());
                        break;
                    }
                    availableCapacity.set("effect", planWorkCenter.get(workcenterId)[2]);
                    availableCapacity.set("haltdate", null);
                    availableCapacity.set("haltqty", null);
                    availableCapacity.set("haltunit", null);
                    availableCapacity.set("creater", (Object)RequestContext.getOrCreate().getCurrUserId());
                    availableCapacity.set("createdate", (Object)TimeServiceHelper.now());
                    availableCapacity.set("scheduleplan", (Object)queryplan.getLong("id"));
                    dnyList.add(availableCapacity);
                }
            }
        }
        if (dnyList.size() != 0) {
            SaveServiceHelper.save((DynamicObject[])dnyList.toArray(new DynamicObject[0]));
        }
    }

    public static void putDownloadQtyToMap(List<Map<String, Object>> assignedDataMessage_qty, Map<Long, Map<Integer, Map<Long, Map<Integer, Map<String, Object>>>>> signToData, String cycle, Map<Integer, Map<Integer, String>> dayToDate, Map<Integer, Map<Integer, String>> yearToWeekTorange) {
        for (Map<String, Object> map : assignedDataMessage_qty) {
            BigDecimal plsqty;
            Date sheduledate = (Date)map.get("pls_date");
            Long workcentre = (Long)map.get("workcenter");
            Object actresource = map.get("actresource");
            if (actresource == null) {
                actresource = 0L;
            }
            int year = sheduledate.getYear() + 1900;
            int value = "mon".equals(cycle) ? sheduledate.getMonth() + 1 : ("wek".equals(cycle) ? ReportQueryUtils.calculateWeek(sheduledate, yearToWeekTorange) : ("qua".equals(cycle) ? sheduledate.getMonth() / 3 + 1 : ReportQueryUtils.calculateDay(sheduledate, dayToDate)));
            Map map_num = null;
            Map<Object, Object> resourceToTimeMessage = null;
            Map timeToMessage = null;
            Map<Integer, Map<Long, Map<Integer, Map<String, Object>>>> yearToResourceTimeMessage = signToData.get(workcentre);
            if (yearToResourceTimeMessage == null) {
                yearToResourceTimeMessage = new HashMap<Integer, Map<Long, Map<Integer, Map<String, Object>>>>(8);
                resourceToTimeMessage = new HashMap(16);
                timeToMessage = new HashMap(16);
                resourceToTimeMessage.put((Long)actresource, timeToMessage);
                yearToResourceTimeMessage.put(year, resourceToTimeMessage);
                signToData.put(workcentre, yearToResourceTimeMessage);
            } else if (yearToResourceTimeMessage.containsKey(year)) {
                resourceToTimeMessage = yearToResourceTimeMessage.get(year);
                if (resourceToTimeMessage == null) {
                    resourceToTimeMessage = new HashMap(16);
                    timeToMessage = new HashMap(16);
                    if (actresource == null) {
                        actresource = 0L;
                    }
                    resourceToTimeMessage.put((Long)actresource, timeToMessage);
                } else {
                    timeToMessage = (Map)resourceToTimeMessage.get(actresource);
                    if (timeToMessage == null) {
                        timeToMessage = new HashMap(16);
                        resourceToTimeMessage.put((Long)actresource, timeToMessage);
                    } else {
                        map_num = (Map)timeToMessage.get(value);
                    }
                }
            } else {
                resourceToTimeMessage = new HashMap(16);
                yearToResourceTimeMessage.put(year, resourceToTimeMessage);
                timeToMessage = new HashMap(16);
                resourceToTimeMessage.put((Long)actresource, timeToMessage);
            }
            if (map_num != null) {
                Object download = map_num.get("download");
                plsqty = (BigDecimal)map.get("lastqty");
                if (download != null) {
                    BigDecimal load = new BigDecimal(download.toString());
                    load = load.add(plsqty);
                    map_num.put("download", load);
                    map_num.put("allload", load);
                    continue;
                }
                map_num.put("download", plsqty);
                map_num.put("allload", BigDecimal.ZERO);
                continue;
            }
            HashMap<String, Object> keyToData = new HashMap<String, Object>(8);
            plsqty = (BigDecimal)map.get("lastqty");
            keyToData.put("year", year);
            keyToData.put("cycle_r", cycle);
            keyToData.put("actresource", actresource);
            keyToData.put("workcenter_r", workcentre);
            keyToData.put("sheduledate", sheduledate);
            keyToData.put("planlaod", BigDecimal.ZERO);
            keyToData.put("allload", plsqty);
            keyToData.put("download", plsqty);
            timeToMessage.put(value, keyToData);
        }
    }

    public static void reduceNum(List<Map<String, Object>> dataMessageByReport, Map<String, BigDecimal> dimensionByReport, Set<String> allField) {
        for (Map<String, Object> map : dataMessageByReport) {
            ReportQueryUtils.assigedNumMatch(dimensionByReport, map, allField);
            if (!map.containsKey("assigedNum")) continue;
            BigDecimal assigedNum = (BigDecimal)map.get("assigedNum");
            BigDecimal baseQty = BigDecimal.ZERO;
            if (map.containsKey("order_num")) {
                Object baseqty = map.get("order_num");
                baseQty = new BigDecimal(baseqty.toString());
            }
            if (baseQty.compareTo(assigedNum) < 0) {
                map.put("order_num", BigDecimal.ZERO);
                continue;
            }
            map.put("order_num", baseQty.subtract(assigedNum));
        }
    }

    public static void getResourceDetail(List<Map<String, Object>> resoureDataMessage, Map<Long, Map<Long, List<String>>> resourceDetail) {
        for (Map<String, Object> map : resoureDataMessage) {
            List<String> details;
            Object workcenter = map.get("workcenter");
            Object resource = map.get("resource");
            Long resourceId = 0L;
            if (resource != null) {
                resourceId = (Long)resource;
            }
            Object resourcedetailname = map.get("resourcedetailname");
            Object resourcedetailnumber = map.get("resourcedetailnumber");
            String detailMessage = resourcedetailnumber + "," + resourcedetailname;
            Map<Long, List<String>> resourceMesaage = resourceDetail.get(workcenter);
            if (resourceMesaage == null) {
                resourceMesaage = new HashMap<Long, List<String>>(16);
                details = new ArrayList<String>(16);
                details.add(detailMessage);
                resourceMesaage.put(resourceId, details);
                resourceDetail.put((Long)workcenter, resourceMesaage);
                continue;
            }
            details = resourceMesaage.get(resourceId);
            if (details == null) {
                details = new ArrayList<String>(16);
                details.add(detailMessage);
                resourceMesaage.put(resourceId, details);
                continue;
            }
            if (details.contains(detailMessage)) continue;
            details.add(detailMessage);
        }
    }
}

