/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mps.common.util;

import java.util.List;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;

public class SaveUtils {
    private static final int DEFAULT_BATCHSIZE = 5000;

    private SaveUtils() {
        throw new UnsupportedOperationException();
    }

    public static void batchSave(String routeKey, String sql, List<Object[]> values) {
        DBRoute dbRoute = DBRoute.of((String)routeKey);
        int totalCount = values.size();
        if (totalCount > 5000) {
            int times = totalCount / 5000;
            times = totalCount % 5000 != 0 ? times + 1 : times;
            for (int i = 0; i < times; ++i) {
                int startIndex = i * 5000;
                int endIndex = Math.min(startIndex + 5000, totalCount);
                DB.executeBatch((DBRoute)dbRoute, (String)sql, values.subList(startIndex, endIndex));
            }
        } else {
            DB.executeBatch((DBRoute)dbRoute, (String)sql, values);
        }
    }
}

