/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mps.consts;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.inte.api.EnabledLang;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.inte.InteServiceHelper;
import kd.mmc.mps.consts.InitSQLConst;

public class InitDataConst {
    public static boolean isEn_US() {
        return StringUtils.equalsIgnoreCase((CharSequence)ResManager.getLanguage(), (CharSequence)"en_US");
    }

    public static Map<String, Map<String, List<Object>>> getSql(String entity, Long orgId, String defaultctrlstrategy, Map<String, String> cellsdatas, Map<String, String> xmls, String appId) {
        switch (entity) {
            case "mrp_algoregister": {
                return InitDataConst.getAlgoSql2Param(orgId, defaultctrlstrategy, appId);
            }
            case "mrp_businessplan": {
                return InitDataConst.getBizSql2Param(orgId, defaultctrlstrategy, cellsdatas, xmls, appId);
            }
            case "mrp_calplanconfig": {
                return InitDataConst.getCalcSql2Param(orgId, defaultctrlstrategy, appId);
            }
            case "mrp_billfieldtransfer": {
                return InitDataConst.getTrsfSql2Param(orgId, defaultctrlstrategy, appId);
            }
            case "mrp_resourceregister_cf": {
                return InitDataConst.getResSql2Param(orgId, defaultctrlstrategy, appId);
            }
        }
        return new HashMap<String, Map<String, List<Object>>>(0);
    }

    public static Map<String, Long> getDataIds(String entity) {
        switch (entity) {
            case "mrp_algoregister": {
                return InitDataConst.getAlgoIds();
            }
            case "mrp_businessplan": {
                return InitDataConst.getBizIds();
            }
            case "mrp_calplanconfig": {
                return InitDataConst.getCalcIds();
            }
            case "mrp_billfieldtransfer": {
                return InitDataConst.getTrsfIds();
            }
            case "mrp_resourceregister_cf": {
                return InitDataConst.getResIds();
            }
        }
        return new HashMap<String, Long>(0);
    }

    private static Map<String, Long> getAlgoIds() {
        HashMap<String, Long> algoIds = new HashMap<String, Long>(10);
        algoIds.put("CalcNo", 1588436968675521536L);
        algoIds.put("CalcVehicleStartTime", 1588437509816235008L);
        algoIds.put("ReportLog_S", 1832666188568709120L);
        algoIds.put("SchedulePlan_getdata", 1583526374734389248L);
        algoIds.put("schedu_plan", 1672584652012940288L);
        return algoIds;
    }

    private static Map<String, Long> getBizIds() {
        HashMap<String, Long> bizIds = new HashMap<String, Long>(1);
        bizIds.put("CalcNo", 1585417277606473728L);
        bizIds.put("CalcVehicleStartTime", 1588740577615161344L);
        bizIds.put("ReportLog_S", 1832667338487482368L);
        bizIds.put("SchedulePlan_getdata", 1583526655803088896L);
        bizIds.put("Schedu_plan", 1672584972138998784L);
        return bizIds;
    }

    private static Map<String, Long> getCalcIds() {
        HashMap<String, Long> calcIds = new HashMap<String, Long>(1);
        calcIds.put("Schedule_Caculate_S", 1583526992807027712L);
        return calcIds;
    }

    private static Map<String, Long> getTrsfIds() {
        HashMap<String, Long> trsfIds = new HashMap<String, Long>(14);
        trsfIds.put("mps_scheduleplan toRes", 1773141659559662592L);
        trsfIds.put("Performed matching", 1773239212779248640L);
        trsfIds.put("ResourceMapping_S", 1800087355537804288L);
        trsfIds.put("RouteMapping_S", 1799914787837113344L);
        trsfIds.put("saleToschedu", 1736165573051550720L);
        trsfIds.put("mftorderToAssignedorder_S", 1892795635963314176L);
        trsfIds.put("planorderToPlsorder_S", 1892895950586822656L);
        return trsfIds;
    }

    private static Map<String, Long> getResIds() {
        HashMap<String, Long> resIds = new HashMap<String, Long>(3);
        resIds.put("Pending schedule", 1773127372845880320L);
        resIds.put("Reserved plan", 1773137489700066304L);
        resIds.put("ResourceModel", 1800136835951855616L);
        resIds.put("RouteModel", 1800121521146963968L);
        return resIds;
    }

    private static Map<String, Map<String, List<Object>>> getAlgoSql2Param(Long orgId, String defaultctrlstrategy, String appId) {
        HashMap<String, Map<String, List<Object>>> algoSql = new HashMap<String, Map<String, List<Object>>>(16);
        AlgoParam algoParam = new AlgoParam(orgId, defaultctrlstrategy, (Long)1832666188568709120L, "3R33T95OPF/1", "ReportLog_S", ResManager.getLocaleString((String)"\u62a5\u8868\u4fe1\u606f\u8bb0\u5f55", (String)"InitDataConst_7", (String)"mmc-mps-common"), "1", "kd.mmc.mps.calcnode.MpsReportCalcStep", appId);
        algoSql.put("ReportLog_S", InitDataConst.getAlgoParam(algoParam));
        algoParam = new AlgoParam(orgId, defaultctrlstrategy, (Long)1588436968675521536L, "3+30M/JJK7X0", "CalcNo", ResManager.getLocaleString((String)"\u4e0a\u7ebf\u987a\u5e8f\u7801\u8ba1\u7b97", (String)"InitDataConst_2", (String)"mmc-mps-common"), "1", "kd.mmc.mps.calcnode.MPSSeqNumGeneratorStep", appId);
        algoSql.put("CalcNo", InitDataConst.getAlgoParam(algoParam));
        algoParam = new AlgoParam(orgId, defaultctrlstrategy, (Long)1588437509816235008L, "3+30PZAFJBYZ", "CalcVehicleStartTime", ResManager.getLocaleString((String)"\u4e0a\u7ebf\u65f6\u95f4\u8ba1\u7b97", (String)"InitDataConst_3", (String)"mmc-mps-common"), "1", "kd.mmc.mps.calcnode.MPSStartWorkTimeGeneratorStep", appId);
        algoSql.put("CalcVehicleStartTime", InitDataConst.getAlgoParam(algoParam));
        algoParam = new AlgoParam(orgId, defaultctrlstrategy, (Long)1583526374734389248L, "2ZHI2LCYT12=", "SchedulePlan_getdata", ResManager.getLocaleString((String)"\u83b7\u53d6\u4e1a\u52a1\u6570\u636e", (String)"InitDataConst_5", (String)"mmc-mps-common"), "1", "kd.mmc.mps.calcnode.MPSBranchingCalculateStep", appId);
        algoSql.put("SchedulePlan_getdata", InitDataConst.getAlgoParam(algoParam));
        algoParam = new AlgoParam(orgId, defaultctrlstrategy, (Long)1672584652012940288L, "38F68R2FAA25", "schedu_plan", ResManager.getLocaleString((String)"\u6392\u4ea7\u8ba1\u5212", (String)"InitDataConst_6", (String)"mmc-mps-common"), "1", "kd.mmc.mps.calcnode.MPSOrderScheduPlanStep", appId);
        algoSql.put("schedu_plan", InitDataConst.getAlgoParam(algoParam));
        return algoSql;
    }

    private static String getRealAppId(String appId) {
        String result = "0";
        if ("mrp".equals(appId)) {
            return result;
        }
        result = "msplan".equals(appId) || "msmpmm".equals(appId) ? "1" : appId;
        return result;
    }

    private static Map<String, List<Object>> getAlgoParam(AlgoParam algoParam) {
        Date nowTime = new Date();
        long userId = RequestContext.get().getCurrUserId();
        LinkedHashMap<String, List<Object>> map = new LinkedHashMap<String, List<Object>>(InitSQLConst.algoSql.length);
        for (int i = 0; i < InitSQLConst.algoSql.length; ++i) {
            ArrayList<Object> params = new ArrayList<Object>(1);
            switch (i) {
                case 0: 
                case 1: {
                    Object[] p = new Object[]{algoParam.id};
                    params.add(p);
                    break;
                }
                case 2: {
                    Object[] p = new Object[]{algoParam.pkId};
                    params.add(p);
                    break;
                }
                case 3: {
                    Object[] p = new Object[]{algoParam.id, "V1.0", algoParam.orgId, algoParam.id, algoParam.orgId, "C", algoParam.defaultctrlstrategy, algoParam.number, algoParam.classPath, nowTime, userId, "1", nowTime, userId, algoParam.type, algoParam.remark == null ? "" : algoParam.remark, InitDataConst.getRealAppId(algoParam.appId), "2XSPP0ASE8UG", true};
                    params.add(p);
                    break;
                }
                case 4: {
                    Object[] p;
                    List enabledLangs = InteServiceHelper.getEnabledLang();
                    ArrayList<Object[]> langList = new ArrayList<Object[]>(enabledLangs.size());
                    String[] ids = DBServiceHelper.genStringIds((String)"T_MRP_ALGOREGISTER_L", (int)enabledLangs.size());
                    int k = 0;
                    for (EnabledLang enabledLang : enabledLangs) {
                        String number = enabledLang.getNumber();
                        p = new Object[5];
                        p[0] = algoParam.id;
                        p[1] = ids[k];
                        p[2] = number;
                        if (algoParam.name != null) {
                            p[3] = algoParam.name.getItem(number);
                            if (algoParam.name.getItem(number) == null) {
                                p[3] = " ";
                            }
                        } else {
                            p[3] = " ";
                        }
                        p[4] = algoParam.remark == null ? "" : algoParam.remark;
                        langList.add(p);
                        ++k;
                    }
                    params.add(langList);
                    break;
                }
            }
            map.put(InitSQLConst.algoSql[i], params);
        }
        return map;
    }

    private static Map<String, Map<String, List<Object>>> getBizSql2Param(Long orgId, String defaultctrlstrategy, Map<String, String> cellsdatas, Map<String, String> xmls, String appId) {
        HashMap<String, Map<String, List<Object>>> bizSql = new HashMap<String, Map<String, List<Object>>>(16);
        ArrayList<BizEntryParam> bizEntrys = new ArrayList<BizEntryParam>(16);
        bizEntrys.add(new BizEntryParam(1737057243234315264L, 1, 1588436968675521536L));
        BizParam bizParam = new BizParam(orgId, defaultctrlstrategy, 1585417277606473728L, "2ZHI730BQNVN", "CalcNo", ResManager.getLocaleString((String)"\u4e0a\u7ebf\u987a\u5e8f\u7801\u8ba1\u7b97", (String)"InitDataConst_2", (String)"mmc-mps-common"), cellsdatas.getOrDefault("CalcNo", ""), xmls.getOrDefault("CalcNo", ""), bizEntrys, appId);
        bizSql.put("CalcNo", InitDataConst.getBizParam(bizParam));
        bizEntrys = new ArrayList(16);
        bizEntrys.add(new BizEntryParam(1588741632079964160L, 1, 1588437509816235008L));
        bizParam = new BizParam(orgId, defaultctrlstrategy, 1588740577615161344L, "3+4HBDW5J=4E", "CalcVehicleStartTime", ResManager.getLocaleString((String)"\u4e0a\u7ebf\u65f6\u95f4\u8ba1\u7b97", (String)"InitDataConst_3", (String)"mmc-mps-common"), cellsdatas.getOrDefault("CalcVehicleStartTime", ""), xmls.getOrDefault("CalcVehicleStartTime", ""), bizEntrys, appId);
        bizSql.put("CalcVehicleStartTime", InitDataConst.getBizParam(bizParam));
        bizEntrys = new ArrayList(16);
        bizEntrys.add(new BizEntryParam(1833403505210086400L, 1, 1832666188568709120L));
        bizParam = new BizParam(orgId, defaultctrlstrategy, 1832667338487482368L, "3R34/J83M9YE", "ReportLog_S", ResManager.getLocaleString((String)"\u62a5\u8868\u5de5\u827a\u8def\u7ebf\u67e5\u8be2\u8bb0\u5f55", (String)"InitDataConst_4", (String)"mmc-mps-common"), cellsdatas.getOrDefault("ReportLog_S", ""), xmls.getOrDefault("ReportLog_S", ""), bizEntrys, appId);
        bizSql.put("ReportLog_S", InitDataConst.getBizParam(bizParam));
        bizEntrys = new ArrayList(16);
        bizEntrys.add(new BizEntryParam(1738447017643963392L, 1, 1583526374734389248L));
        bizParam = new BizParam(orgId, defaultctrlstrategy, 1583526655803088896L, "2ZHI4N997/RC", "SchedulePlan_getdata", ResManager.getLocaleString((String)"\u83b7\u53d6\u4e1a\u52a1\u6570\u636e", (String)"InitDataConst_5", (String)"mmc-mps-common"), cellsdatas.getOrDefault("SchedulePlan_getdata", ""), xmls.getOrDefault("SchedulePlan_getdata", ""), bizEntrys, appId);
        bizSql.put("SchedulePlan_getdata", InitDataConst.getBizParam(bizParam));
        bizEntrys = new ArrayList(16);
        bizEntrys.add(new BizEntryParam(1737057364768556032L, 1, 1672584652012940288L));
        bizParam = new BizParam(orgId, defaultctrlstrategy, 1672584972138998784L, "38F6A2+KVQA/", "Schedu_plan", ResManager.getLocaleString((String)"\u6392\u4ea7\u8ba1\u5212", (String)"InitDataConst_6", (String)"mmc-mps-common"), cellsdatas.getOrDefault("Schedu_plan", ""), xmls.getOrDefault("Schedu_plan", ""), bizEntrys, appId);
        bizSql.put("Schedu_plan", InitDataConst.getBizParam(bizParam));
        return bizSql;
    }

    private static Map<String, List<Object>> getBizParam(BizParam bizParam) {
        Date nowTime = new Date();
        long userId = RequestContext.get().getCurrUserId();
        LinkedHashMap<String, List<Object>> map = new LinkedHashMap<String, List<Object>>(InitSQLConst.bizSql.length);
        for (int i = 0; i < InitSQLConst.bizSql.length; ++i) {
            ArrayList<Object> params = new ArrayList<Object>(1);
            switch (i) {
                case 0: 
                case 1: 
                case 5: {
                    Object[] p = new Object[]{bizParam.id};
                    params.add(p);
                    break;
                }
                case 2: {
                    Object[] p = new Object[]{bizParam.pkId};
                    params.add(p);
                    break;
                }
                case 3: {
                    Object[] p = new Object[]{bizParam.id, bizParam.cellsdata_tag, bizParam.orgId, bizParam.id, bizParam.orgId, "C", bizParam.defaultctrlstrategy, bizParam.number, "", nowTime, userId, "1", nowTime, bizParam.xml_tag, userId, "", "V1.0", InitDataConst.getRealAppId(bizParam.appId), true};
                    params.add(p);
                    break;
                }
                case 4: {
                    Object[] p;
                    List enabledLangs = InteServiceHelper.getEnabledLang();
                    ArrayList<Object[]> langList = new ArrayList<Object[]>(enabledLangs.size());
                    String[] ids = DBServiceHelper.genStringIds((String)"t_mrp_businessplan_l", (int)enabledLangs.size());
                    int k = 0;
                    for (EnabledLang enabledLang : enabledLangs) {
                        String number = enabledLang.getNumber();
                        p = new Object[4];
                        p[0] = bizParam.id;
                        p[1] = ids[k];
                        p[2] = number;
                        if (bizParam.name != null) {
                            p[3] = bizParam.name.getItem(number);
                            if (bizParam.name.getItem(number) == null) {
                                p[3] = " ";
                            }
                        } else {
                            p[3] = " ";
                        }
                        langList.add(p);
                        ++k;
                    }
                    params.add(langList);
                    break;
                }
                case 6: {
                    Object[] p;
                    for (BizEntryParam bizEntry : bizParam.bizEntrys) {
                        p = new Object[]{bizEntry.entryId};
                        params.add(p);
                    }
                    break;
                }
                case 7: {
                    Object[] p;
                    for (BizEntryParam bizEntry : bizParam.bizEntrys) {
                        p = new Object[]{bizParam.id, bizEntry.entryId, bizEntry.seq, bizEntry.algomodel};
                        params.add(p);
                    }
                    break;
                }
            }
            map.put(InitSQLConst.bizSql[i], params);
        }
        return map;
    }

    private static Map<String, List<Object>> getCalcParam(CalcParam calcParam) {
        Date nowTime = new Date();
        long userId = RequestContext.get().getCurrUserId();
        LinkedHashMap<String, List<Object>> map = new LinkedHashMap<String, List<Object>>(InitSQLConst.calcSql.length);
        for (int i = 0; i < InitSQLConst.calcSql.length; ++i) {
            ArrayList<Object> params = new ArrayList<Object>(1);
            switch (i) {
                case 0: 
                case 1: 
                case 5: {
                    Object[] p = new Object[]{calcParam.id};
                    params.add(p);
                    break;
                }
                case 2: {
                    Object[] p = new Object[]{calcParam.pkId};
                    params.add(p);
                    break;
                }
                case 3: {
                    Object[] p = new Object[]{calcParam.id, nowTime, "1", calcParam.orgId, calcParam.id, calcParam.orgId, "C", userId, calcParam.defaultctrlstrategy, calcParam.number, "V1.0", userId, nowTime, InitDataConst.getRealAppId(calcParam.appId), true};
                    params.add(p);
                    break;
                }
                case 4: {
                    Object[] p;
                    List enabledLangs = InteServiceHelper.getEnabledLang();
                    ArrayList<Object[]> langList = new ArrayList<Object[]>(enabledLangs.size());
                    String[] ids = DBServiceHelper.genStringIds((String)"t_mrp_calplanconfig_l", (int)enabledLangs.size());
                    int k = 0;
                    for (EnabledLang enabledLang : enabledLangs) {
                        String number = enabledLang.getNumber();
                        p = new Object[4];
                        p[0] = calcParam.id;
                        p[1] = ids[k];
                        p[2] = number;
                        if (calcParam.name != null) {
                            p[3] = calcParam.name.getItem(number);
                            if (calcParam.name.getItem(number) == null) {
                                p[3] = " ";
                            }
                        } else {
                            p[3] = " ";
                        }
                        langList.add(p);
                        ++k;
                    }
                    params.add(langList);
                    break;
                }
                case 6: {
                    Object[] p;
                    for (CalcEntryParam calcEntryParam : calcParam.calcEntrys) {
                        p = new Object[]{calcEntryParam.entryId};
                        params.add(p);
                    }
                    break;
                }
                case 7: {
                    Object[] p;
                    for (CalcEntryParam calcEntryParam : calcParam.calcEntrys) {
                        p = new Object[]{calcParam.id, calcEntryParam.runtype, calcEntryParam.entryId, calcEntryParam.seq, calcEntryParam.bizplan};
                        params.add(p);
                    }
                    break;
                }
            }
            map.put(InitSQLConst.calcSql[i], params);
        }
        return map;
    }

    private static Map<String, Map<String, List<Object>>> getCalcSql2Param(Long orgId, String defaultctrlstrategy, String appId) {
        HashMap<String, Map<String, List<Object>>> calcSql = new HashMap<String, Map<String, List<Object>>>(1);
        ArrayList<CalcEntryParam> entrys = new ArrayList<CalcEntryParam>(16);
        entrys.add(new CalcEntryParam(1672585543008939008L, 1, "mps_pls", 1672584972138998784L));
        entrys.add(new CalcEntryParam(1583526992832193536L, 2, "mps_scheduleplan_branch", 1583526655803088896L));
        entrys.add(new CalcEntryParam(1585417506632250368L, 3, "mps_scheduleplan_pre", 1585417277606473728L));
        entrys.add(new CalcEntryParam(1588744440485264384L, 4, "mps_genworktime", 1588740577615161344L));
        entrys.add(new CalcEntryParam(1832669792398592000L, 5, "mps_reportcalclog", 1832667338487482368L));
        CalcParam calcParam = new CalcParam(orgId, defaultctrlstrategy, 1583526992807027712L, "2ZHI730BQNVN", "Schedule_Caculate_S", ResManager.getLocaleString((String)"\u6392\u4ea7\u8fd0\u7b97\u8ba1\u7b97\u65b9\u6848", (String)"InitDataConst_1", (String)"mmc-mps-common"), entrys, appId);
        calcSql.put("Schedule_Caculate_S", InitDataConst.getCalcParam(calcParam));
        return calcSql;
    }

    private static String getTfsAppId(String appId) {
        String result = "B";
        if ("mrp".equals(appId)) {
            return result;
        }
        result = "mds".equals(appId) ? "A" : ("sfc".equals(appId) ? "C" : ("msplan".equals(appId) || "msmpmm".equals(appId) ? "D" : appId));
        return result;
    }

    private static Map<String, List<Object>> getTrsfParam(TrsfParam trsfParam) {
        Date nowTime = new Date();
        long userId = RequestContext.get().getCurrUserId();
        LinkedHashMap<String, List<Object>> map = new LinkedHashMap<String, List<Object>>(InitSQLConst.trsfSql.length);
        for (int i = 0; i < InitSQLConst.trsfSql.length; ++i) {
            ArrayList<Object> params = new ArrayList<Object>(1);
            switch (i) {
                case 0: 
                case 1: 
                case 5: {
                    Object[] p = new Object[]{trsfParam.id};
                    params.add(p);
                    break;
                }
                case 2: {
                    Object[] p = new Object[]{trsfParam.pkId};
                    params.add(p);
                    break;
                }
                case 3: {
                    Object[] p = new Object[]{trsfParam.id, "V1.0", trsfParam.orgId, trsfParam.orgId, trsfParam.id, "C", trsfParam.defaultctrlstrategy, trsfParam.number, trsfParam.srcbill, nowTime, "1", "1", trsfParam.destbill, userId, userId, nowTime, trsfParam.ismatchdim, InitDataConst.getTfsAppId(trsfParam.appId)};
                    params.add(p);
                    break;
                }
                case 4: {
                    Object[] p;
                    List enabledLangs = InteServiceHelper.getEnabledLang();
                    ArrayList<Object[]> langList = new ArrayList<Object[]>(enabledLangs.size());
                    String[] ids = DBServiceHelper.genStringIds((String)"t_mrp_bftransfer_l", (int)enabledLangs.size());
                    int k = 0;
                    for (EnabledLang enabledLang : enabledLangs) {
                        String number = enabledLang.getNumber();
                        p = new Object[4];
                        p[0] = trsfParam.id;
                        p[1] = ids[k];
                        p[2] = number;
                        if (trsfParam.name != null) {
                            p[3] = trsfParam.name.getItem(number);
                            if (trsfParam.name.getItem(number) == null) {
                                p[3] = " ";
                            }
                        } else {
                            p[3] = " ";
                        }
                        langList.add(p);
                        ++k;
                    }
                    params.add(langList);
                    break;
                }
                case 6: {
                    Object[] p;
                    for (TrsfEntryParam entryParam : trsfParam.entryParams) {
                        p = new Object[]{entryParam.entryId};
                        params.add(p);
                    }
                    break;
                }
                case 7: {
                    Object[] p;
                    for (TrsfEntryParam entryParam : trsfParam.entryParams) {
                        p = new Object[13];
                        p[0] = trsfParam.id;
                        p[1] = entryParam.calculateexc_tag;
                        p[2] = entryParam.calculateexc;
                        p[3] = entryParam.destfieldflag;
                        if (entryParam.sourcefieldname == null) {
                            p[4] = " ";
                        } else {
                            p[4] = entryParam.sourcefieldname.getLocaleValue();
                            if (entryParam.sourcefieldname.getLocaleValue() == null) {
                                p[4] = " ";
                            }
                        }
                        p[5] = entryParam.entryId;
                        p[6] = entryParam.calculatetext;
                        p[7] = entryParam.sourcefieldflag;
                        if (entryParam.destfieldname == null) {
                            p[8] = " ";
                        } else {
                            p[8] = entryParam.destfieldname.getLocaleValue();
                            if (entryParam.destfieldname.getLocaleValue() == null) {
                                p[8] = " ";
                            }
                        }
                        p[9] = entryParam.destentityflag;
                        p[10] = entryParam.converttype;
                        p[11] = entryParam.sourceentityflag;
                        p[12] = entryParam.seq;
                        params.add(p);
                    }
                    break;
                }
                case 8: {
                    Object[] p;
                    for (TrsfEntryParam entryParam : trsfParam.entryParams) {
                        List enabledLangsentry = InteServiceHelper.getEnabledLang();
                        ArrayList<Object[]> langListentry = new ArrayList<Object[]>(enabledLangsentry.size());
                        String[] idsentry = DBServiceHelper.genStringIds((String)"t_mrp_billtranferentry_l", (int)enabledLangsentry.size());
                        int m = 0;
                        for (EnabledLang enabledLang : enabledLangsentry) {
                            String number = enabledLang.getNumber();
                            p = new Object[5];
                            p[0] = entryParam.entryId;
                            p[1] = idsentry[m];
                            p[2] = number;
                            if (entryParam.destfieldname != null) {
                                p[3] = entryParam.destfieldname.getItem(number);
                                if (entryParam.destfieldname.getItem(number) == null) {
                                    p[3] = " ";
                                }
                            } else {
                                p[3] = " ";
                            }
                            if (entryParam.sourcefieldname != null) {
                                p[4] = entryParam.sourcefieldname.getItem(number);
                                if (entryParam.sourcefieldname.getItem(number) == null) {
                                    p[4] = " ";
                                }
                            } else {
                                p[4] = " ";
                            }
                            langListentry.add(p);
                            ++m;
                        }
                        params.add(langListentry);
                    }
                    break;
                }
            }
            map.put(InitSQLConst.trsfSql[i], params);
        }
        return map;
    }

    private static Map<String, Map<String, List<Object>>> getTrsfSql2Param(Long orgId, String defaultctrlstrategy, String appId) {
        HashMap<String, Map<String, List<Object>>> trsfSql = new HashMap<String, Map<String, List<Object>>>(16);
        ArrayList<TrsfEntryParam> entrys = new ArrayList<TrsfEntryParam>(16);
        entrys.add(new TrsfEntryParam(1773141660029424640L, 1, "", "", "", "sourcebillid", ResManager.getLocaleString((String)"\u5355\u636e\u5934.\u6765\u6e90\u5355\u636eID", (String)"InitDataConst_35", (String)"mmc-mps-common"), "sourcebillid", "datasourceid", ResManager.getLocaleString((String)"\u5355\u636e\u5934.\u6765\u6e90\u5355\u636eID", (String)"InitDataConst_35", (String)"mmc-mps-common"), "datasourceid", "0"));
        entrys.add(new TrsfEntryParam(1773141660029424641L, 2, "", "", "", "unit", ResManager.getLocaleString((String)"\u5355\u636e\u5934.\u57fa\u672c\u5355\u4f4d", (String)"InitDataConst_36", (String)"mmc-mps-common"), "unit", "unit", ResManager.getLocaleString((String)"\u5355\u636e\u5934.\u57fa\u672c\u5355\u4f4d", (String)"InitDataConst_36", (String)"mmc-mps-common"), "unit", "0"));
        entrys.add(new TrsfEntryParam(1773141660029424642L, 3, "", "", "", "materiel_code", ResManager.getLocaleString((String)"\u5355\u636e\u5934.\u7269\u6599\u7f16\u7801", (String)"InitDataConst_37", (String)"mmc-mps-common"), "materiel_code", "materiel", ResManager.getLocaleString((String)"\u5355\u636e\u5934.\u7269\u6599\u7f16\u7801", (String)"InitDataConst_37", (String)"mmc-mps-common"), "materiel", "0"));
        entrys.add(new TrsfEntryParam(1773141660029424643L, 4, "", "", "", "remark", ResManager.getLocaleString((String)"\u5355\u636e\u5934.\u5907\u6ce8", (String)"InitDataConst_38", (String)"mmc-mps-common"), "remark", "remark", ResManager.getLocaleString((String)"\u5355\u636e\u5934.\u5907\u6ce8", (String)"InitDataConst_38", (String)"mmc-mps-common"), "remark", "0"));
        entrys.add(new TrsfEntryParam(1773141660029424644L, 5, "", "", "", "configure", ResManager.getLocaleString((String)"\u5355\u636e\u5934.\u914d\u7f6e\u53f7", (String)"InitDataConst_39", (String)"mmc-mps-common"), "configure", "configuredcode", ResManager.getLocaleString((String)"\u5355\u636e\u5934.\u914d\u7f6e\u53f7", (String)"InitDataConst_39", (String)"mmc-mps-common"), "configuredcode", "0"));
        entrys.add(new TrsfEntryParam(1773141660029424645L, 6, "", "", "", "plan_order_billno", ResManager.getLocaleString((String)"\u5355\u636e\u5934.\u6765\u6e90\u8ba2\u5355\u7f16\u53f7", (String)"InitDataConst_40", (String)"mmc-mps-common"), "plan_order_billno", "sourcebillno", ResManager.getLocaleString((String)"\u5355\u636e\u5934.\u6765\u6e90\u5355\u636e\u7f16\u53f7", (String)"InitDataConst_41", (String)"mmc-mps-common"), "sourcebillno", "0"));
        entrys.add(new TrsfEntryParam(1773141660029424646L, 7, "", "", "", "production_org", ResManager.getLocaleString((String)"\u5355\u636e\u5934.\u751f\u4ea7\u7ec4\u7ec7", (String)"InitDataConst_42", (String)"mmc-mps-common"), "production_org", "org", ResManager.getLocaleString((String)"\u5355\u636e\u5934.\u751f\u4ea7\u7ec4\u7ec7", (String)"InitDataConst_42", (String)"mmc-mps-common"), "org", "0"));
        entrys.add(new TrsfEntryParam(1773141660029424647L, 8, "", "", "", "tracknumber", ResManager.getLocaleString((String)"\u5355\u636e\u5934.\u8ddf\u8e2a\u53f7", (String)"InitDataConst_43", (String)"mmc-mps-common"), "tracknumber", "tracknumber", ResManager.getLocaleString((String)"\u5355\u636e\u5934.\u8ddf\u8e2a\u53f7", (String)"InitDataConst_43", (String)"mmc-mps-common"), "tracknumber", "0"));
        entrys.add(new TrsfEntryParam(1773141660029424648L, 9, "", "", "", "bailedorg", ResManager.getLocaleString((String)"\u5355\u636e\u5934.\u59d4\u6258\u7ec4\u7ec7", (String)"InitDataConst_44", (String)"mmc-mps-common"), "bailedorg", "bailedorg", ResManager.getLocaleString((String)"\u5355\u636e\u5934.\u59d4\u6258\u7ec4\u7ec7", (String)"InitDataConst_44", (String)"mmc-mps-common"), "bailedorg", "0"));
        entrys.add(new TrsfEntryParam(1773141660029424649L, 10, "", "", "", "auxiliary", ResManager.getLocaleString((String)"\u5355\u636e\u5934.\u8f85\u52a9\u5c5e\u6027", (String)"InitDataConst_45", (String)"mmc-mps-common"), "auxiliary", "auxiliary", ResManager.getLocaleString((String)"\u5355\u636e\u5934.\u8f85\u52a9\u5c5e\u6027", (String)"InitDataConst_45", (String)"mmc-mps-common"), "auxiliary", "0"));
        entrys.add(new TrsfEntryParam(1773141660029424650L, 11, "", "", "", "workcenter", ResManager.getLocaleString((String)"\u5355\u636e\u5934.\u5de5\u4f5c\u4e2d\u5fc3", (String)"InitDataConst_46", (String)"mmc-mps-common"), "workcenter", "workcentre", ResManager.getLocaleString((String)"\u5355\u636e\u5934.\u4ea7\u80fd\u8ba1\u7b97\u5de5\u4f5c\u4e2d\u5fc3", (String)"InitDataConst_47", (String)"mmc-mps-common"), "workcentre", "0"));
        entrys.add(new TrsfEntryParam(1773229794075351040L, 12, "", "", "", "pls_date", ResManager.getLocaleString((String)"\u5355\u636e\u5934.\u6392\u4ea7\u65e5\u671f", (String)"InitDataConst_48", (String)"mmc-mps-common"), "pls_date", "sheduledate", ResManager.getLocaleString((String)"\u5355\u636e\u5934.\u6392\u4ea7\u65e5\u671f", (String)"InitDataConst_48", (String)"mmc-mps-common"), "sheduledate", "0"));
        entrys.add(new TrsfEntryParam(1776869747418253313L, 13, "", "", "", "plsqty", ResManager.getLocaleString((String)"\u5355\u636e\u5934.\u6570\u91cf", (String)"InitDataConst_49", (String)"mmc-mps-common"), "plsqty", "scheduleqty", ResManager.getLocaleString((String)"\u5355\u636e\u5934.\u6392\u4ea7\u6570\u91cf", (String)"InitDataConst_50", (String)"mmc-mps-common"), "scheduleqty", "0"));
        entrys.add(new TrsfEntryParam(1776873396638895104L, 14, "", "", "", "billno", ResManager.getLocaleString((String)"\u5355\u636e\u5934.\u5355\u636e\u7f16\u53f7", (String)"InitDataConst_51", (String)"mmc-mps-common"), "billno", "billno", ResManager.getLocaleString((String)"\u5355\u636e\u5934.\u5355\u636e\u7f16\u53f7", (String)"InitDataConst_51", (String)"mmc-mps-common"), "billno", "0"));
        entrys.add(new TrsfEntryParam(1783280071444959232L, 15, "", "", "", "sourceentryid", ResManager.getLocaleString((String)"\u5355\u636e\u5934.\u6765\u6e90\u5206\u5f55ID", (String)"InitDataConst_52", (String)"mmc-mps-common"), "sourceentryid", "sourceentryid", ResManager.getLocaleString((String)"\u5355\u636e\u5934.\u6765\u6e90\u5206\u5f55ID", (String)"InitDataConst_52", (String)"mmc-mps-common"), "sourceentryid", "0"));
        entrys.add(new TrsfEntryParam(1783280071444959233L, 16, "", "", "", "sourcebillentryno", ResManager.getLocaleString((String)"\u5355\u636e\u5934.\u6765\u6e90\u8ba2\u5355\u884c\u53f7", (String)"InitDataConst_53", (String)"mmc-mps-common"), "sourcebillentryno", "sourceentryseq", ResManager.getLocaleString((String)"\u5355\u636e\u5934.\u6765\u6e90\u5355\u636e\u884c\u53f7", (String)"InitDataConst_54", (String)"mmc-mps-common"), "sourceentryseq", "0"));
        entrys.add(new TrsfEntryParam(1783456004755938304L, 17, "", "", "", "billtype", ResManager.getLocaleString((String)"\u5355\u636e\u5934.\u6765\u6e90\u5b9e\u4f53\u7c7b\u578b", (String)"InitDataConst_55", (String)"mmc-mps-common"), "billtype", "sourcebilltypeid", ResManager.getLocaleString((String)"\u5355\u636e\u5934.\u6765\u6e90\u5355\u636e\u7c7b\u578b", (String)"InitDataConst_56", (String)"mmc-mps-common"), "sourcebilltypeid", "0"));
        TrsfParam trsfParam = new TrsfParam(orgId, defaultctrlstrategy, 1773141659559662592L, "3JSYWYR655AF", "mps_scheduleplan toRes", ResManager.getLocaleString((String)"\u6392\u4ea7\u8ba1\u5212\uff08\u5df2\u5206\u914d\uff09", (String)"InitDataConst_30", (String)"mmc-mps-common"), "mps_scheduleplan", "mps_pls_assignedorder", "0", entrys, appId);
        trsfSql.put("mps_scheduleplan toRes", InitDataConst.getTrsfParam(trsfParam));
        entrys = new ArrayList(16);
        entrys.add(new TrsfEntryParam(1736165573252877312L, 1, String.format("{\"expression\":\"id\",\"exprTran\":\"%1$s\",\"description\":{\"zh_CN\":\"\"},\"localeExprTran\":{\"zh_CN\":\"%1$s\"},\"exprDesc\":\"%1$s\"}", ResManager.loadKDString((String)"\u9500\u552e\u8ba2\u5355.\u5185\u7801", (String)"InitDataConst_58", (String)"mmc-mps-common", (Object[])new Object[0])), "id", ResManager.loadKDString((String)"\u9500\u552e\u8ba2\u5355.\u5185\u7801", (String)"InitDataConst_58", (String)"mmc-mps-common", (Object[])new Object[0]), "sourcebillid", ResManager.getLocaleString((String)"\u5355\u636e\u5934.\u6765\u6e90\u5355\u636eID", (String)"InitDataConst_35", (String)"mmc-mps-common"), "sourcebillid", " ", null, " ", "1"));
        entrys.add(new TrsfEntryParam(1736165573252877313L, 2, "", "", "", "remark", ResManager.getLocaleString((String)"\u5355\u636e\u5934.\u5907\u6ce8", (String)"InitDataConst_38", (String)"mmc-mps-common"), "remark", "comment", ResManager.getLocaleString((String)"\u5355\u636e\u5934.\u5907\u6ce8", (String)"InitDataConst_38", (String)"mmc-mps-common"), "comment", "0"));
        entrys.add(new TrsfEntryParam(1736165573252877314L, 3, "", "", "", "configure", ResManager.getLocaleString((String)"\u5355\u636e\u5934.\u914d\u7f6e\u53f7", (String)"InitDataConst_39", (String)"mmc-mps-common"), "configure", "billentry.configuredcode", ResManager.getLocaleString((String)"\u7269\u6599\u660e\u7ec6.\u914d\u7f6e\u53f7", (String)"InitDataConst_59", (String)"mmc-mps-common"), "billentry.configuredcode", "0"));
        entrys.add(new TrsfEntryParam(1736165573252877315L, 4, "", "", "", "plan_order_billno", ResManager.getLocaleString((String)"\u5355\u636e\u5934.\u6765\u6e90\u8ba2\u5355\u7f16\u53f7", (String)"InitDataConst_40", (String)"mmc-mps-common"), "plan_order_billno", "billno", ResManager.getLocaleString((String)"\u5355\u636e\u5934.\u5355\u636e\u7f16\u53f7", (String)"InitDataConst_51", (String)"mmc-mps-common"), "billno", "0"));
        entrys.add(new TrsfEntryParam(1736165573252877316L, 5, "", "", "", "unit", ResManager.getLocaleString((String)"\u5355\u636e\u5934.\u8ba1\u91cf\u5355\u4f4d", (String)"InitDataConst_60", (String)"mmc-mps-common"), "unit", "billentry.baseunit", ResManager.getLocaleString((String)"\u7269\u6599\u660e\u7ec6.\u57fa\u672c\u5355\u4f4d", (String)"InitDataConst_61", (String)"mmc-mps-common"), "billentry.baseunit", "0"));
        entrys.add(new TrsfEntryParam(1736165573252877317L, 6, String.format("{\"expression\":\"billentry.seq\",\"exprTran\":\"%1$s\",\"description\":{\"zh_CN\":\"\"},\"localeExprTran\":{\"zh_CN\":\"%1$s\"},\"exprDesc\":\"%1$s\"}", ResManager.loadKDString((String)"\u7269\u6599\u660e\u7ec6.\u5e8f\u53f7", (String)"InitDataConst_63", (String)"mmc-mps-common", (Object[])new Object[0])), "billentry.seq", ResManager.loadKDString((String)"\u7269\u6599\u660e\u7ec6.\u5e8f\u53f7", (String)"InitDataConst_63", (String)"mmc-mps-common", (Object[])new Object[0]), "sourcebillentryno", ResManager.getLocaleString((String)"\u5355\u636e\u5934.\u6765\u6e90\u8ba2\u5355\u884c\u53f7", (String)"InitDataConst_53", (String)"mmc-mps-common"), "sourcebillentryno", " ", null, " ", "1"));
        entrys.add(new TrsfEntryParam(1736165573252877318L, 7, "", "", "", "materiel_code", ResManager.getLocaleString((String)"\u5355\u636e\u5934.\u7269\u6599\u7f16\u7801", (String)"InitDataConst_37", (String)"mmc-mps-common"), "materiel_code", "billentry.material.masterid", ResManager.getLocaleString((String)"\u7269\u6599\u660e\u7ec6.\u7269\u6599\u7f16\u7801.\u7269\u6599\u7f16\u7801", (String)"InitDataConst_64", (String)"mmc-mps-common"), "billentry.material.masterid", "0"));
        entrys.add(new TrsfEntryParam(1736165573252877319L, 8, "", "", "", "order_num", ResManager.getLocaleString((String)"\u5355\u636e\u5934.\u8ba2\u5355\u6570\u91cf", (String)"InitDataConst_65", (String)"mmc-mps-common"), "order_num", "billentry.baseqty", ResManager.getLocaleString((String)"\u7269\u6599\u660e\u7ec6.\u57fa\u672c\u6570\u91cf", (String)"InitDataConst_66", (String)"mmc-mps-common"), "billentry.baseqty", "0"));
        entrys.add(new TrsfEntryParam(1736165573252877320L, 9, "", "", "", "plan_start_date", ResManager.getLocaleString((String)"\u5355\u636e\u5934.\u8ba1\u5212\u5f00\u59cb\u65e5\u671f", (String)"InitDataConst_67", (String)"mmc-mps-common"), "plan_start_date", "billentry.deliverydate", ResManager.getLocaleString((String)"\u7269\u6599\u660e\u7ec6.\u53d1\u8d27\u65e5\u671f", (String)"InitDataConst_68", (String)"mmc-mps-common"), "billentry.deliverydate", "0"));
        entrys.add(new TrsfEntryParam(1736165573252877321L, 10, "", "", "", "production_org", ResManager.getLocaleString((String)"\u5355\u636e\u5934.\u751f\u4ea7\u7ec4\u7ec7", (String)"InitDataConst_42", (String)"mmc-mps-common"), "production_org", "billentry.e_stockorg", ResManager.getLocaleString((String)"\u7269\u6599\u660e\u7ec6.\u53d1\u8d27\u7ec4\u7ec7", (String)"InitDataConst_69", (String)"mmc-mps-common"), "billentry.e_stockorg", "0"));
        entrys.add(new TrsfEntryParam(1736165573252877322L, 11, "", "", "", "tracknumber", ResManager.getLocaleString((String)"\u5355\u636e\u5934.\u8ddf\u8e2a\u53f7", (String)"InitDataConst_43", (String)"mmc-mps-common"), "tracknumber", "billentry.tracknumber", ResManager.getLocaleString((String)"\u7269\u6599\u660e\u7ec6.\u8ddf\u8e2a\u53f7", (String)"InitDataConst_70", (String)"mmc-mps-common"), "billentry.tracknumber", "0"));
        entrys.add(new TrsfEntryParam(1736174455949894656L, 12, String.format("{\"expression\":\"billentry.id\",\"exprTran\":\"%1$s\",\"description\":{\"zh_CN\":\"\"},\"localeExprTran\":{\"zh_CN\":\"%1$s\"},\"exprDesc\":\"%1$s\"}", ResManager.loadKDString((String)"\u7269\u6599\u660e\u7ec6.\u5185\u7801", (String)"InitDataConst_72", (String)"mmc-mps-common", (Object[])new Object[0])), "billentry.id", ResManager.loadKDString((String)"\u7269\u6599\u660e\u7ec6.\u5185\u7801", (String)"InitDataConst_72", (String)"mmc-mps-common", (Object[])new Object[0]), "sourceentryid", ResManager.getLocaleString((String)"\u5355\u636e\u5934.\u6765\u6e90\u5206\u5f55ID", (String)"InitDataConst_52", (String)"mmc-mps-common"), "sourceentryid", " ", null, " ", "1"));
        entrys.add(new TrsfEntryParam(1736175823309775872L, 13, "", "", "", "billtype", ResManager.getLocaleString((String)"\u5355\u636e\u5934.\u6765\u6e90\u5b9e\u4f53\u7c7b\u578b", (String)"InitDataConst_55", (String)"mmc-mps-common"), "billtype", "billtype", ResManager.getLocaleString((String)"\u5355\u636e\u5934.\u5355\u636e\u7c7b\u578b", (String)"InitDataConst_73", (String)"mmc-mps-common"), "billtype", "0"));
        entrys.add(new TrsfEntryParam(1736175823309775873L, 14, "", "", "", "auxiliary", ResManager.getLocaleString((String)"\u5355\u636e\u5934.\u8f85\u52a9\u5c5e\u6027", (String)"InitDataConst_45", (String)"mmc-mps-common"), "auxiliary", "billentry.auxpty", ResManager.getLocaleString((String)"\u7269\u6599\u660e\u7ec6.\u8f85\u52a9\u5c5e\u6027", (String)"InitDataConst_74", (String)"mmc-mps-common"), "billentry.auxpty", "0"));
        entrys.add(new TrsfEntryParam(1773134036806532096L, 15, "", "", "", "requiredate", ResManager.getLocaleString((String)"\u5355\u636e\u5934.\u9700\u6c42\u65e5\u671f", (String)"InitDataConst_187", (String)"mmc-mps-common"), "requiredate", "billentry.deliverydate", ResManager.getLocaleString((String)"\u7269\u6599\u660e\u7ec6.\u53d1\u8d27\u65e5\u671f", (String)"InitDataConst_188", (String)"mmc-mps-common"), "billentry.deliverydate", "0"));
        trsfParam = new TrsfParam(orgId, defaultctrlstrategy, 1736165573051550720L, "3F8T1UC94GO/", "saleToschedu", ResManager.getLocaleString((String)"\u9500\u552e\u6620\u5c04\u6392\u4ea7\u8ba2\u5355", (String)"InitDataConst_31", (String)"mmc-mps-common"), "sm_salorder", "mps_pls_order", "0", entrys, appId);
        trsfSql.put("saleToschedu", InitDataConst.getTrsfParam(trsfParam));
        entrys = new ArrayList(16);
        entrys.add(new TrsfEntryParam(1773239213064461312L, 1, "", "", "", "sourcebillid", ResManager.getLocaleString((String)"\u5355\u636e\u5934.\u6765\u6e90\u5355\u636eID", (String)"InitDataConst_35", (String)"mmc-mps-common"), "sourcebillid", "sourcebillid", ResManager.getLocaleString((String)"\u5355\u636e\u5934.\u6765\u6e90\u5355\u636eID", (String)"InitDataConst_35", (String)"mmc-mps-common"), "sourcebillid", "0"));
        entrys.add(new TrsfEntryParam(1773239213064461313L, 2, "", "", "", "materiel_code", ResManager.getLocaleString((String)"\u5355\u636e\u5934.\u7269\u6599\u7f16\u7801", (String)"InitDataConst_37", (String)"mmc-mps-common"), "materiel_code", "materiel_code", ResManager.getLocaleString((String)"\u5355\u636e\u5934.\u7269\u6599\u7f16\u7801", (String)"InitDataConst_37", (String)"mmc-mps-common"), "materiel_code", "0"));
        entrys.add(new TrsfEntryParam(1773239213064461314L, 3, "", "", "", "configure", ResManager.getLocaleString((String)"\u5355\u636e\u5934.\u914d\u7f6e\u53f7", (String)"InitDataConst_39", (String)"mmc-mps-common"), "configure", "configure", ResManager.getLocaleString((String)"\u5355\u636e\u5934.\u914d\u7f6e\u53f7", (String)"InitDataConst_39", (String)"mmc-mps-common"), "configure", "0"));
        entrys.add(new TrsfEntryParam(1773239213064461315L, 4, "", "", "", "tracknumber", ResManager.getLocaleString((String)"\u5355\u636e\u5934.\u8ddf\u8e2a\u53f7", (String)"InitDataConst_43", (String)"mmc-mps-common"), "tracknumber", "tracknumber", ResManager.getLocaleString((String)"\u5355\u636e\u5934.\u8ddf\u8e2a\u53f7", (String)"InitDataConst_43", (String)"mmc-mps-common"), "tracknumber", "0"));
        entrys.add(new TrsfEntryParam(1773239213064461316L, 5, "", "", "", "sourceentryid", ResManager.getLocaleString((String)"\u5355\u636e\u5934.\u6765\u6e90\u5206\u5f55ID", (String)"InitDataConst_52", (String)"mmc-mps-common"), "sourceentryid", "sourceentryid", ResManager.getLocaleString((String)"\u5355\u636e\u5934.\u6765\u6e90\u5206\u5f55ID", (String)"InitDataConst_52", (String)"mmc-mps-common"), "sourceentryid", "0"));
        entrys.add(new TrsfEntryParam(1773239213064461317L, 6, "", "", "", "auxiliary", ResManager.getLocaleString((String)"\u5355\u636e\u5934.\u8f85\u52a9\u5c5e\u6027", (String)"InitDataConst_45", (String)"mmc-mps-common"), "auxiliary", "auxiliary", ResManager.getLocaleString((String)"\u5355\u636e\u5934.\u8f85\u52a9\u5c5e\u6027", (String)"InitDataConst_45", (String)"mmc-mps-common"), "auxiliary", "0"));
        trsfParam = new TrsfParam(orgId, defaultctrlstrategy, 1773239212779248640L, "3JTE3TKBDRR2", "Performed matching", ResManager.getLocaleString((String)"\u5df2\u5206\u914d\u5339\u914d", (String)"InitDataConst_32", (String)"mmc-mps-common"), "mps_pls_order", "mps_pls_assignedorder", "1", entrys, appId);
        trsfSql.put("Performed matching", InitDataConst.getTrsfParam(trsfParam));
        entrys = new ArrayList(16);
        entrys.add(new TrsfEntryParam(1800087355604913152L, 1, "", "", "", "createorg", ResManager.getLocaleString((String)"\u5355\u636e\u5934.\u521b\u5efa\u7ec4\u7ec7", (String)"InitDataConst_75", (String)"mmc-mps-common"), "createorg", "createorg", ResManager.getLocaleString((String)"\u5355\u636e\u5934.\u521b\u5efa\u7ec4\u7ec7", (String)"InitDataConst_75", (String)"mmc-mps-common"), "createorg", "0"));
        entrys.add(new TrsfEntryParam(1800087355604913153L, 2, String.format("{\"expression\":\"id\",\"exprTran\":\"%1$s\",\"description\":{\"zh_CN\":\"\"},\"localeExprTran\":{\"zh_CN\":\"%1$s\"},\"exprDesc\":\"%1$s\"}", ResManager.loadKDString((String)"\u5de5\u4f5c\u4e2d\u5fc3\u5b9a\u4e49.\u5185\u7801", (String)"InitDataConst_77", (String)"mmc-mps-common", (Object[])new Object[0])), "id", ResManager.loadKDString((String)"\u5de5\u4f5c\u4e2d\u5fc3\u5b9a\u4e49.\u5185\u7801", (String)"InitDataConst_77", (String)"mmc-mps-common", (Object[])new Object[0]), "workcenter", ResManager.getLocaleString((String)"\u5355\u636e\u5934.\u5de5\u4f5c\u4e2d\u5fc3", (String)"InitDataConst_46", (String)"mmc-mps-common"), "workcenter", " ", null, " ", "1"));
        entrys.add(new TrsfEntryParam(1800087355604913158L, 3, "", "", "", "resouceqty", ResManager.getLocaleString((String)"\u5355\u636e\u5934.\u6570\u91cf", (String)"InitDataConst_49", (String)"mmc-mps-common"), "resouceqty", "entryresouce.resouceqty", ResManager.getLocaleString((String)"\u8d44\u6e90.\u8d44\u6e90\u6570\u91cf", (String)"InitDataConst_78", (String)"mmc-mps-common"), "entryresouce.resouceqty", "0"));
        entrys.add(new TrsfEntryParam(1813906027490373632L, 4, "", "", "", "resource", ResManager.getLocaleString((String)"\u5355\u636e\u5934.\u8d44\u6e90\u7f16\u7801", (String)"InitDataConst_79", (String)"mmc-mps-common"), "resource", "entryresouce.resource", ResManager.getLocaleString((String)"\u8d44\u6e90.\u8d44\u6e90\u7f16\u7801", (String)"InitDataConst_80", (String)"mmc-mps-common"), "entryresouce.resource", "0"));
        trsfParam = new TrsfParam(orgId, defaultctrlstrategy, 1800087355537804288L, "3N30KRV2CAN/", "ResourceMapping_S", ResManager.getLocaleString((String)"\u8d44\u6e90\u6620\u5c04", (String)"InitDataConst_33", (String)"mmc-mps-common"), "mpdm_workcentre", "mps_resourcemodel", "0", entrys, appId);
        trsfSql.put("ResourceMapping_S", InitDataConst.getTrsfParam(trsfParam));
        entrys = new ArrayList(16);
        entrys.add(new TrsfEntryParam(1799914788097160192L, 1, String.format("{\"expression\":\"id\",\"exprTran\":\"%1$s\",\"description\":{\"zh_CN\":\"\"},\"exprDesc\":\"%1$s\",\"localeExprTran\":{\"zh_CN\":\"%1$s\"}}", ResManager.loadKDString((String)"\u5de5\u827a\u8def\u7ebf\u7ef4\u62a4.\u5185\u7801", (String)"InitDataConst_189", (String)"mmc-mps-common", (Object[])new Object[0])), "id", ResManager.loadKDString((String)"\u5de5\u827a\u8def\u7ebf\u7ef4\u62a4.\u5185\u7801", (String)"InitDataConst_189", (String)"mmc-mps-common", (Object[])new Object[0]), "processroute", ResManager.getLocaleString((String)"\u5355\u636e\u5934.\u5de5\u827a\u8def\u7ebf", (String)"InitDataConst_81", (String)"mmc-mps-common"), "processroute", " ", null, " ", "1"));
        entrys.add(new TrsfEntryParam(1799914788097160193L, 2, "", "", "", "createorg", ResManager.getLocaleString((String)"\u5355\u636e\u5934.\u521b\u5efa\u7ec4\u7ec7", (String)"InitDataConst_75", (String)"mmc-mps-common"), "createorg", "createorg", ResManager.getLocaleString((String)"\u5355\u636e\u5934.\u521b\u5efa\u7ec4\u7ec7", (String)"InitDataConst_75", (String)"mmc-mps-common"), "createorg", "0"));
        entrys.add(new TrsfEntryParam(1799914788097160194L, 3, "", "", "", "material", ResManager.getLocaleString((String)"\u5355\u636e\u5934.\u7269\u6599\u7f16\u7801", (String)"InitDataConst_37", (String)"mmc-mps-common"), "material", "material", ResManager.getLocaleString((String)"\u5355\u636e\u5934.\u7269\u6599\u7f16\u7801", (String)"InitDataConst_37", (String)"mmc-mps-common"), "material", "0"));
        entrys.add(new TrsfEntryParam(1799914788097160195L, 4, "{\"expression\":\"processentry.actentryentity.activity\",\"exprTran\":\"processentry.actentryentity.activity\",\"description\":{\"zh_CN\":\"\"},\"exprDesc\":\"processentry.actentryentity.activity\",\"localeExprTran\":{\"zh_CN\":\"processentry.actentryentity.activity\"}}", "processentry.actentryentity.activity", "processentry.actentryentity.activity", "activity", ResManager.getLocaleString((String)"\u5355\u636e\u5934.\u6d3b\u52a8\u7f16\u7801", (String)"InitDataConst_82", (String)"mmc-mps-common"), "activity", " ", null, " ", "1"));
        entrys.add(new TrsfEntryParam(1799914788097160196L, 5, "", "", "", "workcenter", ResManager.getLocaleString((String)"\u5355\u636e\u5934.\u5de5\u4f5c\u4e2d\u5fc3", (String)"InitDataConst_46", (String)"mmc-mps-common"), "workcenter", "processentry.workcenter", ResManager.getLocaleString((String)"\u5de5\u5e8f\u4fe1\u606f.\u5de5\u4f5c\u4e2d\u5fc3", (String)"InitDataConst_83", (String)"mmc-mps-common"), "processentry.workcenter", "0"));
        entrys.add(new TrsfEntryParam(1799914788097160197L, 6, "", "", "", "processtype", ResManager.getLocaleString((String)"\u5355\u636e\u5934.\u5de5\u827a\u7c7b\u578b", (String)"InitDataConst_84", (String)"mmc-mps-common"), "processtype", "processtype", ResManager.getLocaleString((String)"\u5355\u636e\u5934.\u5de5\u827a\u7c7b\u578b", (String)"InitDataConst_84", (String)"mmc-mps-common"), "processtype", "0"));
        entrys.add(new TrsfEntryParam(1799914788097160198L, 7, "", "", "", "materialgroup", ResManager.getLocaleString((String)"\u5355\u636e\u5934.\u7269\u6599\u63a7\u5236\u7ec4", (String)"InitDataConst_85", (String)"mmc-mps-common"), "materialgroup", "materialgroup", ResManager.getLocaleString((String)"\u5355\u636e\u5934.\u7269\u6599\u63a7\u5236\u7ec4", (String)"InitDataConst_85", (String)"mmc-mps-common"), "materialgroup", "0"));
        entrys.add(new TrsfEntryParam(1799914788097160199L, 8, "", "", "", "group", ResManager.getLocaleString((String)"\u5355\u636e\u5934.\u5de5\u827a\u8def\u7ebf\u5206\u7ec4", (String)"InitDataConst_86", (String)"mmc-mps-common"), "group", "group", ResManager.getLocaleString((String)"\u5355\u636e\u5934.\u5de5\u827a\u8def\u7ebf\u5206\u7ec4", (String)"InitDataConst_86", (String)"mmc-mps-common"), "group", "0"));
        entrys.add(new TrsfEntryParam(1799914788097160200L, 9, "{\"expression\":\"processentry.actentryentity.activity.unit.id\",\"exprTran\":\"processentry.actentryentity.activity.unit.id\",\"description\":{\"zh_CN\":\"\"},\"exprDesc\":\"processentry.actentryentity.activity.unit.id\",\"localeExprTran\":{\"zh_CN\":\"processentry.actentryentity.activity.unit.id\"}}", "processentry.actentryentity.activity.unit.id", "processentry.actentryentity.activity.unit.id", "unit", ResManager.getLocaleString((String)"\u5355\u636e\u5934.\u8ba1\u91cf\u5355\u4f4d", (String)"InitDataConst_60", (String)"mmc-mps-common"), "unit", " ", null, " ", "1"));
        entrys.add(new TrsfEntryParam(1799914788097160201L, 10, "", "", "", "auxproperty", ResManager.getLocaleString((String)"\u5355\u636e\u5934.\u8f85\u52a9\u5c5e\u6027", (String)"InitDataConst_45", (String)"mmc-mps-common"), "auxproperty", "auxproperty", ResManager.getLocaleString((String)"\u5355\u636e\u5934.\u8f85\u52a9\u5c5e\u6027", (String)"InitDataConst_45", (String)"mmc-mps-common"), "auxproperty", "0"));
        entrys.add(new TrsfEntryParam(1799914788097160202L, 11, "", "", "", "operationno", ResManager.getLocaleString((String)"\u5355\u636e\u5934.\u5de5\u5e8f\u53f7", (String)"InitDataConst_87", (String)"mmc-mps-common"), "operationno", "relentryentity.transferprocessno", ResManager.getLocaleString((String)"\u5e8f\u5217\u5173\u7cfb.\u8f6c\u5165\u5de5\u5e8f\u53f7", (String)"InitDataConst_88", (String)"mmc-mps-common"), "relentryentity.transferprocessno", "0"));
        entrys.add(new TrsfEntryParam(1799914788097160203L, 12, "", "", "", "productionworkshop", ResManager.getLocaleString((String)"\u5355\u636e\u5934.\u751f\u4ea7\u8f66\u95f4", (String)"InitDataConst_89", (String)"mmc-mps-common"), "productionworkshop", "processentry.productionworkshop", ResManager.getLocaleString((String)"\u5de5\u5e8f\u4fe1\u606f.\u751f\u4ea7\u8f66\u95f4", (String)"InitDataConst_90", (String)"mmc-mps-common"), "processentry.productionworkshop", "0"));
        entrys.add(new TrsfEntryParam(1799914788097160204L, 13, "", "", "", "operation", ResManager.getLocaleString((String)"\u5355\u636e\u5934.\u5de5\u5e8f\u7f16\u7801", (String)"InitDataConst_91", (String)"mmc-mps-common"), "operation", "processentry.operation", ResManager.getLocaleString((String)"\u5de5\u5e8f\u4fe1\u606f.\u5de5\u5e8f\u7f16\u7801", (String)"InitDataConst_92", (String)"mmc-mps-common"), "processentry.operation", "0"));
        entrys.add(new TrsfEntryParam(1799914788097160205L, 14, "", "", "", "operationdesc", ResManager.getLocaleString((String)"\u5355\u636e\u5934.\u5de5\u5e8f\u8bf4\u660e", (String)"InitDataConst_93", (String)"mmc-mps-common"), "operationdesc", "processentry.operationdesc", ResManager.getLocaleString((String)"\u5de5\u5e8f\u4fe1\u606f.\u5de5\u5e8f\u8bf4\u660e", (String)"InitDataConst_94", (String)"mmc-mps-common"), "processentry.operationdesc", "0"));
        entrys.add(new TrsfEntryParam(1799914788097160211L, 15, "{\"expression\":\"processentry.actentryentity.actresource\",\"exprTran\":\"processentry.actentryentity.actresource\",\"description\":{\"zh_CN\":\"\"},\"exprDesc\":\"processentry.actentryentity.actresource\",\"localeExprTran\":{\"zh_CN\":\"processentry.actentryentity.actresource\"}}", "processentry.actentryentity.actresource", "processentry.actentryentity.actresource", "actresource", ResManager.getLocaleString((String)"\u5355\u636e\u5934.\u8d44\u6e90", (String)"InitDataConst_95", (String)"mmc-mps-common"), "actresource", " ", null, " ", "1"));
        entrys.add(new TrsfEntryParam(1799914788097160212L, 16, "", "", "", "productionorg.number", ResManager.getLocaleString((String)"\u5355\u636e\u5934.\u52a0\u5de5\u7ec4\u7ec7.\u7f16\u7801", (String)"InitDataConst_96", (String)"mmc-mps-common"), "productionorg.number", "processentry.productionorg.number", ResManager.getLocaleString((String)"\u5de5\u5e8f\u4fe1\u606f.\u52a0\u5de5\u7ec4\u7ec7.\u7f16\u7801", (String)"InitDataConst_97", (String)"mmc-mps-common"), "processentry.productionorg.number", "0"));
        entrys.add(new TrsfEntryParam(1842829222494611456L, 17, "{\"expression\":\"processentry.actentryentity.baseqty\",\"exprTran\":\"processentry.actentryentity.baseqty\",\"description\":{\"zh_CN\":\"\"},\"exprDesc\":\"processentry.actentryentity.baseqty\",\"localeExprTran\":{\"zh_CN\":\"processentry.actentryentity.baseqty\"}}", "processentry.actentryentity.baseqty", "processentry.actentryentity.baseqty", "qty", ResManager.getLocaleString((String)"\u5355\u636e\u5934.\u6570\u91cf", (String)"InitDataConst_49", (String)"mmc-mps-common"), "qty", " ", null, " ", "1"));
        entrys.add(new TrsfEntryParam(1844483800327792640L, 18, "", "", "", "validitybegindate", ResManager.getLocaleString((String)"\u5355\u636e\u5934.\u6709\u6548\u5f00\u59cb\u65f6\u95f4", (String)"InitDataConst_98", (String)"mmc-mps-common"), "validitybegindate", "processentry.entryvaliddate", ResManager.getLocaleString((String)"\u5de5\u5e8f\u4fe1\u606f.\u751f\u6548\u65f6\u95f4", (String)"InitDataConst_99", (String)"mmc-mps-common"), "processentry.entryvaliddate", "0"));
        entrys.add(new TrsfEntryParam(1844483800327792641L, 19, "", "", "", "validityenddate", ResManager.getLocaleString((String)"\u5355\u636e\u5934.\u6709\u6548\u7ed3\u675f\u65e5\u671f", (String)"InitDataConst_100", (String)"mmc-mps-common"), "validityenddate", "processentry.entryinvaliddate", ResManager.getLocaleString((String)"\u5de5\u5e8f\u4fe1\u606f.\u5931\u6548\u65f6\u95f4", (String)"InitDataConst_101", (String)"mmc-mps-common"), "processentry.entryinvaliddate", "0"));
        trsfParam = new TrsfParam(orgId, defaultctrlstrategy, 1799914787837113344L, "3N27B9GYPQN+", "RouteMapping_S", ResManager.getLocaleString((String)"\u5de5\u827a\u8def\u7ebf\u6620\u5c04", (String)"InitDataConst_34", (String)"mmc-mps-common"), "pdm_route", "mps_routemmodel", "0", entrys, appId);
        trsfSql.put("RouteMapping_S", InitDataConst.getTrsfParam(trsfParam));
        entrys = new ArrayList(16);
        entrys.add(new TrsfEntryParam(1892795636516962304L, 1, String.format("{\"expression\":\"treeentryentity.seq\",\"exprTran\":\"%1$s\",\"description\":{\"zh_CN\":\"\"},\"localeExprTran\":{\"zh_CN\":\"%1$s\"},\"exprDesc\":\"%1$s\"}", ResManager.loadKDString((String)"\u5206\u5f55.\u5e8f\u53f7", (String)"InitDataConst_161", (String)"mmc-mps-common", (Object[])new Object[0])), "treeentryentity.seq", ResManager.loadKDString((String)"\u5206\u5f55.\u5e8f\u53f7", (String)"InitDataConst_161", (String)"mmc-mps-common", (Object[])new Object[0]), "billentryno", ResManager.getLocaleString((String)"\u5355\u636e\u5934.\u8ba2\u5355\u884c\u53f7", (String)"InitDataConst_162", (String)"mmc-mps-common"), "billentryno", " ", null, " ", "1"));
        entrys.add(new TrsfEntryParam(1892795636516962305L, 2, String.format("{\"expression\":\"id\",\"exprTran\":\"%1$s\",\"description\":{\"zh_CN\":\"\"},\"localeExprTran\":{\"zh_CN\":\"%1$s\"},\"exprDesc\":\"%1$s\"}", ResManager.loadKDString((String)"\u751f\u4ea7\u5de5\u5355.\u5185\u7801", (String)"InitDataConst_164", (String)"mmc-mps-common", (Object[])new Object[0])), "id", ResManager.loadKDString((String)"\u751f\u4ea7\u5de5\u5355.\u5185\u7801", (String)"InitDataConst_164", (String)"mmc-mps-common", (Object[])new Object[0]), "sourcebillid", ResManager.getLocaleString((String)"\u5355\u636e\u5934.\u6765\u6e90\u5355\u636eID", (String)"InitDataConst_35", (String)"mmc-mps-common"), "sourcebillid", " ", null, " ", "1"));
        entrys.add(new TrsfEntryParam(1892795636516962306L, 3, "", "", "", "remark", ResManager.getLocaleString((String)"\u5355\u636e\u5934.\u5907\u6ce8", (String)"InitDataConst_38", (String)"mmc-mps-common"), "remark", "remark", ResManager.getLocaleString((String)"\u5355\u636e\u5934.\u5907\u6ce8", (String)"InitDataConst_38", (String)"mmc-mps-common"), "remark", "0"));
        entrys.add(new TrsfEntryParam(1892795636516962307L, 4, "", "", "", "configure", ResManager.getLocaleString((String)"\u5355\u636e\u5934.\u914d\u7f6e\u53f7", (String)"InitDataConst_39", (String)"mmc-mps-common"), "configure", "treeentryentity.configuredcode", ResManager.getLocaleString((String)"\u5206\u5f55.\u914d\u7f6e\u53f7", (String)"InitDataConst_165", (String)"mmc-mps-common"), "treeentryentity.configuredcode", "0"));
        entrys.add(new TrsfEntryParam(1892795636516962308L, 5, "", "", "", "plan_order_billno", ResManager.getLocaleString((String)"\u5355\u636e\u5934.\u6765\u6e90\u8ba2\u5355\u7f16\u53f7", (String)"InitDataConst_40", (String)"mmc-mps-common"), "plan_order_billno", "treeentryentity.sourcebillnumber", ResManager.getLocaleString((String)"\u5206\u5f55.\u6765\u6e90\u5355\u636e\u7f16\u53f7", (String)"InitDataConst_166", (String)"mmc-mps-common"), "treeentryentity.sourcebillnumber", "0"));
        entrys.add(new TrsfEntryParam(1892795636516962309L, 6, "", "", "", "unit", ResManager.getLocaleString((String)"\u5355\u636e\u5934.\u57fa\u672c\u5355\u4f4d", (String)"InitDataConst_36", (String)"mmc-mps-common"), "unit", "treeentryentity.baseunit", ResManager.getLocaleString((String)"\u5206\u5f55.\u57fa\u672c\u5355\u4f4d", (String)"InitDataConst_167", (String)"mmc-mps-common"), "treeentryentity.baseunit", "0"));
        entrys.add(new TrsfEntryParam(1892795636516962310L, 7, "", "", "", "plsqty", ResManager.getLocaleString((String)"\u5355\u636e\u5934.\u6570\u91cf", (String)"InitDataConst_49", (String)"mmc-mps-common"), "plsqty", "treeentryentity.baseqty", ResManager.getLocaleString((String)"\u5206\u5f55.\u57fa\u672c\u6570\u91cf", (String)"InitDataConst_168", (String)"mmc-mps-common"), "treeentryentity.baseqty", "0"));
        entrys.add(new TrsfEntryParam(1892795636516962311L, 8, "", "", "", "materiel_code", ResManager.getLocaleString((String)"\u5355\u636e\u5934.\u7269\u6599\u7f16\u7801", (String)"InitDataConst_37", (String)"mmc-mps-common"), "materiel_code", "treeentryentity.material.masterid", ResManager.getLocaleString((String)"\u5206\u5f55.\u7269\u6599\u7f16\u7801.\u7269\u6599\u7f16\u7801", (String)"InitDataConst_169", (String)"mmc-mps-common"), "treeentryentity.material.masterid", "0"));
        entrys.add(new TrsfEntryParam(1892795636516962312L, 9, "", "", "", "pls_date", ResManager.getLocaleString((String)"\u5355\u636e\u5934.\u6392\u4ea7\u65e5\u671f", (String)"InitDataConst_48", (String)"mmc-mps-common"), "pls_date", "treeentryentity.planbegintime", ResManager.getLocaleString((String)"\u5206\u5f55.\u8ba1\u5212\u5f00\u5de5\u65f6\u95f4", (String)"InitDataConst_170", (String)"mmc-mps-common"), "treeentryentity.planbegintime", "0"));
        entrys.add(new TrsfEntryParam(1892795636516962313L, 10, "", "", "", "billno", ResManager.getLocaleString((String)"\u5355\u636e\u5934.\u5355\u636e\u7f16\u53f7", (String)"InitDataConst_51", (String)"mmc-mps-common"), "billno", "billno", ResManager.getLocaleString((String)"\u5355\u636e\u5934.\u5355\u636e\u7f16\u53f7", (String)"InitDataConst_51", (String)"mmc-mps-common"), "billno", "0"));
        entrys.add(new TrsfEntryParam(1892795636516962314L, 11, "", "", "", "production_org", ResManager.getLocaleString((String)"\u5355\u636e\u5934.\u751f\u4ea7\u7ec4\u7ec7", (String)"InitDataConst_42", (String)"mmc-mps-common"), "production_org", "org", ResManager.getLocaleString((String)"\u5355\u636e\u5934.\u751f\u4ea7\u7ec4\u7ec7", (String)"InitDataConst_42", (String)"mmc-mps-common"), "org", "0"));
        entrys.add(new TrsfEntryParam(1892795636516962315L, 12, "", "", "", "tracknumber", ResManager.getLocaleString((String)"\u5355\u636e\u5934.\u8ddf\u8e2a\u53f7", (String)"InitDataConst_43", (String)"mmc-mps-common"), "tracknumber", "treeentryentity.tracknumber", ResManager.getLocaleString((String)"\u5206\u5f55.\u8ddf\u8e2a\u53f7", (String)"InitDataConst_171", (String)"mmc-mps-common"), "treeentryentity.tracknumber", "0"));
        entrys.add(new TrsfEntryParam(1892795636516962316L, 13, "", "", "", "bailedorg", ResManager.getLocaleString((String)"\u5355\u636e\u5934.\u59d4\u6258\u7ec4\u7ec7", (String)"InitDataConst_44", (String)"mmc-mps-common"), "bailedorg", "entrustdept", ResManager.getLocaleString((String)"\u5355\u636e\u5934.\u59d4\u6258\u7ec4\u7ec7", (String)"InitDataConst_44", (String)"mmc-mps-common"), "entrustdept", "0"));
        entrys.add(new TrsfEntryParam(1892795636516962317L, 14, "", "", "", "auxiliary", ResManager.getLocaleString((String)"\u5355\u636e\u5934.\u8f85\u52a9\u5c5e\u6027", (String)"InitDataConst_45", (String)"mmc-mps-common"), "auxiliary", "treeentryentity.auxproperty", ResManager.getLocaleString((String)"\u5206\u5f55.\u8f85\u52a9\u5c5e\u6027", (String)"InitDataConst_172", (String)"mmc-mps-common"), "treeentryentity.auxproperty", "0"));
        entrys.add(new TrsfEntryParam(1892795636516962318L, 15, "", "", "", "workcenter", ResManager.getLocaleString((String)"\u5355\u636e\u5934.\u5de5\u4f5c\u4e2d\u5fc3", (String)"InitDataConst_46", (String)"mmc-mps-common"), "workcenter", "treeentryentity.workcenter", ResManager.getLocaleString((String)"\u5206\u5f55.\u5de5\u4f5c\u4e2d\u5fc3", (String)"InitDataConst_173", (String)"mmc-mps-common"), "treeentryentity.workcenter", "0"));
        entrys.add(new TrsfEntryParam(1892795636516962319L, 16, String.format("{\"expression\":\"treeentryentity.id\",\"exprTran\":\"%1$s\",\"description\":{\"zh_CN\":\"\"},\"localeExprTran\":{\"zh_CN\":\"%1$s\"},\"exprDesc\":\"%1$s\"}", ResManager.loadKDString((String)"\u5206\u5f55.\u5185\u7801", (String)"InitDataConst_175", (String)"mmc-mps-common", (Object[])new Object[0])), "treeentryentity.id", ResManager.loadKDString((String)"\u5206\u5f55.\u5185\u7801", (String)"InitDataConst_175", (String)"mmc-mps-common", (Object[])new Object[0]), "sourceentryid", ResManager.getLocaleString((String)"\u5355\u636e\u5934.\u6765\u6e90\u5206\u5f55ID", (String)"InitDataConst_52", (String)"mmc-mps-common"), "sourceentryid", " ", null, " ", "1"));
        entrys.add(new TrsfEntryParam(1898794955502048256L, 17, "", "", "", "billtype", ResManager.getLocaleString((String)"\u5355\u636e\u5934.\u5355\u636e\u7c7b\u578b", (String)"InitDataConst_185", (String)"mmc-mps-common"), "billtype", "billtype", ResManager.getLocaleString((String)"\u5355\u636e\u5934.\u5355\u636e\u7c7b\u578b", (String)"InitDataConst_185", (String)"mmc-mps-common"), "billtype", "0"));
        trsfParam = new TrsfParam(orgId, defaultctrlstrategy, 1892795635963314176L, "3YH6QEIFEY8U", "mftorderToAssignedorder_S", ResManager.getLocaleString((String)"\u751f\u4ea7\u5de5\u5355\u6620\u5c04\u5df2\u5206\u914d", (String)"InitDataConst_158", (String)"mmc-mps-common"), "pom_mftorder", "mps_pls_assignedorder", "0", entrys, appId);
        trsfSql.put("mftorderToAssignedorder_S", InitDataConst.getTrsfParam(trsfParam));
        entrys = new ArrayList(16);
        entrys.add(new TrsfEntryParam(1892895951174025216L, 1, String.format("{\"expression\":\"id\",\"exprTran\":\"%1$s\",\"description\":{\"zh_CN\":\"\"},\"localeExprTran\":{\"zh_CN\":\"%1$s\"},\"exprDesc\":\"%1$s\"}", ResManager.loadKDString((String)"\u8ba1\u5212\u5efa\u8bae.\u5185\u7801", (String)"InitDataConst_177", (String)"mmc-mps-common", (Object[])new Object[0])), "id", ResManager.loadKDString((String)"\u8ba1\u5212\u5efa\u8bae.\u5185\u7801", (String)"InitDataConst_177", (String)"mmc-mps-common", (Object[])new Object[0]), "sourcebillid", ResManager.getLocaleString((String)"\u5355\u636e\u5934.\u6765\u6e90\u5355\u636eID", (String)"InitDataConst_35", (String)"mmc-mps-common"), "sourcebillid", " ", null, " ", "1"));
        entrys.add(new TrsfEntryParam(1892895951174025217L, 2, "", "", "", "plan_prepare_date", ResManager.getLocaleString((String)"\u5355\u636e\u5934.\u8ba1\u5212\u51c6\u5907\u65e5\u671f", (String)"InitDataConst_178", (String)"mmc-mps-common"), "plan_prepare_date", "orderdate", ResManager.getLocaleString((String)"\u5355\u636e\u5934.\u8ba1\u5212\u51c6\u5907\u65e5\u671f", (String)"InitDataConst_178", (String)"mmc-mps-common"), "orderdate", "0"));
        entrys.add(new TrsfEntryParam(1892895951174025218L, 3, "", "", "", "available_date", ResManager.getLocaleString((String)"\u5355\u636e\u5934.\u53ef\u7528\u65e5\u671f", (String)"InitDataConst_179", (String)"mmc-mps-common"), "available_date", "availabledate", ResManager.getLocaleString((String)"\u5355\u636e\u5934.\u53ef\u7528\u65e5\u671f", (String)"InitDataConst_179", (String)"mmc-mps-common"), "availabledate", "0"));
        entrys.add(new TrsfEntryParam(1892895951174025219L, 4, "", "", "", "remark", ResManager.getLocaleString((String)"\u5355\u636e\u5934.\u5907\u6ce8", (String)"InitDataConst_38", (String)"mmc-mps-common"), "remark", "comment", ResManager.getLocaleString((String)"\u5355\u636e\u5934.\u539f\u56e0\u63cf\u8ff0", (String)"InitDataConst_180", (String)"mmc-mps-common"), "comment", "0"));
        entrys.add(new TrsfEntryParam(1892895951174025220L, 5, "", "", "", "configure", ResManager.getLocaleString((String)"\u5355\u636e\u5934.\u914d\u7f6e\u53f7", (String)"InitDataConst_39", (String)"mmc-mps-common"), "configure", "configuredcode", ResManager.getLocaleString((String)"\u5355\u636e\u5934.\u914d\u7f6e\u53f7", (String)"InitDataConst_39", (String)"mmc-mps-common"), "configuredcode", "0"));
        entrys.add(new TrsfEntryParam(1892895951174025221L, 6, "", "", "", "plan_order_billno", ResManager.getLocaleString((String)"\u5355\u636e\u5934.\u6765\u6e90\u8ba2\u5355\u7f16\u53f7", (String)"InitDataConst_40", (String)"mmc-mps-common"), "plan_order_billno", "billno", ResManager.getLocaleString((String)"\u5355\u636e\u5934.\u5355\u636e\u7f16\u53f7", (String)"InitDataConst_51", (String)"mmc-mps-common"), "billno", "0"));
        entrys.add(new TrsfEntryParam(1892895951174025222L, 7, "", "", "", "plan_finish_date", ResManager.getLocaleString((String)"\u5355\u636e\u5934.\u8ba1\u5212\u5b8c\u6210\u65e5\u671f", (String)"InitDataConst_181", (String)"mmc-mps-common"), "plan_finish_date", "enddate", ResManager.getLocaleString((String)"\u5355\u636e\u5934.\u8ba1\u5212\u5b8c\u6210\u65e5\u671f", (String)"InitDataConst_181", (String)"mmc-mps-common"), "enddate", "0"));
        entrys.add(new TrsfEntryParam(1892895951174025223L, 8, "", "", "", "unit", ResManager.getLocaleString((String)"\u5355\u636e\u5934.\u57fa\u672c\u5355\u4f4d", (String)"InitDataConst_36", (String)"mmc-mps-common"), "unit", "unit", ResManager.getLocaleString((String)"\u5355\u636e\u5934.\u8ba1\u91cf\u5355\u4f4d", (String)"InitDataConst_60", (String)"mmc-mps-common"), "unit", "0"));
        entrys.add(new TrsfEntryParam(1892895951174025224L, 9, "", "", "", "materiel_code", ResManager.getLocaleString((String)"\u5355\u636e\u5934.\u7269\u6599\u7f16\u7801", (String)"InitDataConst_37", (String)"mmc-mps-common"), "materiel_code", "material", ResManager.getLocaleString((String)"\u5355\u636e\u5934.\u7269\u6599\u7f16\u7801", (String)"InitDataConst_37", (String)"mmc-mps-common"), "material", "0"));
        entrys.add(new TrsfEntryParam(1892895951174025225L, 10, String.format("{\"expression\":\"orderqty -  dropqty \",\"exprTran\":\"%1$s \",\"description\":{\"zh_CN\":\"\"},\"localeExprTran\":{\"zh_CN\":\"%1$s \"},\"exprDesc\":\"%1$s \"}", ResManager.loadKDString((String)"\u8ba2\u5355\u6570\u91cf -  \u6295\u653e\u6570\u91cf ", (String)"InitDataConst_182", (String)"mmc-mps-common", (Object[])new Object[0])), "orderqty -  dropqty ", ResManager.loadKDString((String)"\u8ba2\u5355\u6570\u91cf -  \u6295\u653e\u6570\u91cf ", (String)"InitDataConst_182", (String)"mmc-mps-common", (Object[])new Object[0]), "order_num", ResManager.getLocaleString((String)"\u5355\u636e\u5934.\u8ba2\u5355\u6570\u91cf", (String)"InitDataConst_65", (String)"mmc-mps-common"), "order_num", "", null, "", "1"));
        entrys.add(new TrsfEntryParam(1892895951174025226L, 11, "", "", "", "plan_start_date", ResManager.getLocaleString((String)"\u5355\u636e\u5934.\u8ba1\u5212\u5f00\u59cb\u65e5\u671f", (String)"InitDataConst_67", (String)"mmc-mps-common"), "plan_start_date", "startdate", ResManager.getLocaleString((String)"\u5355\u636e\u5934.\u8ba1\u5212\u5f00\u59cb\u65e5\u671f", (String)"InitDataConst_67", (String)"mmc-mps-common"), "startdate", "0"));
        entrys.add(new TrsfEntryParam(1892895951174025227L, 12, "", "", "", "production_org", ResManager.getLocaleString((String)"\u5355\u636e\u5934.\u751f\u4ea7\u7ec4\u7ec7", (String)"InitDataConst_42", (String)"mmc-mps-common"), "production_org", "proorpurorg", ResManager.getLocaleString((String)"\u5355\u636e\u5934.\u4f9b\u5e94\u7ec4\u7ec7", (String)"InitDataConst_183", (String)"mmc-mps-common"), "proorpurorg", "0"));
        entrys.add(new TrsfEntryParam(1892895951174025228L, 13, "", "", "", "tracknumber", ResManager.getLocaleString((String)"\u5355\u636e\u5934.\u8ddf\u8e2a\u53f7", (String)"InitDataConst_43", (String)"mmc-mps-common"), "tracknumber", "tracknumber", ResManager.getLocaleString((String)"\u5355\u636e\u5934.\u8ddf\u8e2a\u53f7", (String)"InitDataConst_43", (String)"mmc-mps-common"), "tracknumber", "0"));
        entrys.add(new TrsfEntryParam(1892895951174025229L, 14, "", "", "", "requiredate", ResManager.getLocaleString((String)"\u5355\u636e\u5934.\u9700\u6c42\u65e5\u671f", (String)"InitDataConst_184", (String)"mmc-mps-common"), "requiredate", "startdate", ResManager.getLocaleString((String)"\u5355\u636e\u5934.\u8ba1\u5212\u5f00\u59cb\u65e5\u671f", (String)"InitDataConst_67", (String)"mmc-mps-common"), "startdate", "0"));
        entrys.add(new TrsfEntryParam(1898796500306154496L, 15, String.format("{\"expression\":\"entryentity.seq\",\"exprTran\":\"%1$s\",\"description\":{\"zh_CN\":\"\"},\"localeExprTran\":{\"zh_CN\":\"%1$s\"},\"exprDesc\":\"%1$s\"}", ResManager.loadKDString((String)"\u5355\u636e\u4f53.\u5e8f\u53f7", (String)"InitDataConst_192", (String)"mmc-mps-common", (Object[])new Object[0])), "entryentity.seq", ResManager.loadKDString((String)"\u5355\u636e\u4f53.\u5e8f\u53f7", (String)"InitDataConst_192", (String)"mmc-mps-common", (Object[])new Object[0]), "billentryno", ResManager.getLocaleString((String)"\u5355\u636e\u5934.\u8ba2\u5355\u884c\u53f7", (String)"InitDataConst_186", (String)"mmc-mps-common"), "billentryno", "", null, "", "1"));
        trsfParam = new TrsfParam(orgId, defaultctrlstrategy, 1892895950586822656L, "3YHOGE60XN5N", "planorderToPlsorder_S", ResManager.getLocaleString((String)"\u8ba1\u5212\u5efa\u8bae\u6620\u5c04\u6392\u4ea7\u8ba2\u5355", (String)"InitDataConst_159", (String)"mmc-mps-common"), "mrp_planorder", "mps_pls_order", "0", entrys, appId);
        trsfSql.put("planorderToPlsorder_S", InitDataConst.getTrsfParam(trsfParam));
        return trsfSql;
    }

    private static Map<String, List<Object>> getResRegisParam(ResRegisParam resRegisParam) {
        Date nowTime = new Date();
        long userId = RequestContext.get().getCurrUserId();
        LinkedHashMap<String, List<Object>> map = new LinkedHashMap<String, List<Object>>(InitSQLConst.resSql.length);
        for (int i = 0; i < InitSQLConst.resSql.length; ++i) {
            ArrayList<Object> params = new ArrayList<Object>(1);
            switch (i) {
                case 0: 
                case 1: 
                case 5: {
                    Object[] p = new Object[]{resRegisParam.id};
                    params.add(p);
                    break;
                }
                case 2: {
                    Object[] p = new Object[]{resRegisParam.pkId};
                    params.add(p);
                    break;
                }
                case 3: {
                    Object[] p = new Object[]{resRegisParam.id, "V1.0", resRegisParam.type, resRegisParam.orgId, resRegisParam.orgId, resRegisParam.id, "C", resRegisParam.defaultctrlstrategy, resRegisParam.businessentity, resRegisParam.number, nowTime, resRegisParam.relativetransfer, "1", resRegisParam.relativeresource, userId, resRegisParam.businesstype, userId, nowTime, resRegisParam.outputmapping, resRegisParam.outputtype, resRegisParam.outtosupply, InitDataConst.getRealAppId(resRegisParam.appId), true};
                    params.add(p);
                    break;
                }
                case 4: {
                    Object[] p;
                    List enabledLangs = InteServiceHelper.getEnabledLang();
                    ArrayList<Object[]> langList = new ArrayList<Object[]>(enabledLangs.size());
                    String[] ids = DBServiceHelper.genStringIds((String)"t_mrp_bftransfer_l", (int)enabledLangs.size());
                    int k = 0;
                    for (EnabledLang enabledLang : enabledLangs) {
                        String number = enabledLang.getNumber();
                        p = new Object[4];
                        p[0] = resRegisParam.id;
                        p[1] = ids[k];
                        p[2] = number;
                        if (resRegisParam.name != null) {
                            p[3] = resRegisParam.name.getItem(number);
                            if (resRegisParam.name.getItem(number) == null) {
                                p[3] = " ";
                            }
                        } else {
                            p[3] = " ";
                        }
                        langList.add(p);
                        ++k;
                    }
                    params.add(langList);
                    break;
                }
                case 6: {
                    Object[] p;
                    for (ResRegisEntryParam entryParam : resRegisParam.entryParams) {
                        p = new Object[]{entryParam.entryId};
                        params.add(p);
                    }
                    break;
                }
                case 7: {
                    Object[] p;
                    for (ResRegisEntryParam entryParam : resRegisParam.entryParams) {
                        p = new Object[10];
                        p[0] = resRegisParam.id;
                        p[1] = entryParam.formuladesc;
                        p[2] = entryParam.bizdatatype;
                        p[3] = entryParam.signid;
                        p[4] = entryParam.srctype;
                        p[5] = entryParam.entryId;
                        if (entryParam.datatype == null) {
                            p[6] = " ";
                        } else {
                            p[6] = entryParam.datatype.getLocaleValue();
                            if (entryParam.datatype.getLocaleValue() == null) {
                                p[6] = " ";
                            }
                        }
                        if (entryParam.signname == null) {
                            p[7] = " ";
                        } else {
                            p[7] = entryParam.signname.getLocaleValue();
                            if (entryParam.signname.getLocaleValue() == null) {
                                p[7] = " ";
                            }
                        }
                        p[8] = entryParam.seq;
                        p[9] = entryParam.defaultvalue;
                        params.add(p);
                    }
                    break;
                }
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: {
                    String number;
                    int e;
                    String[] idsentry;
                    ArrayList<Object[]> langListentry;
                    List enabledLangsentry;
                    Object[] p;
                    if (i == 8 || i == 9) {
                        for (ResDataConfigParam configParam : resRegisParam.resDataConfigParams) {
                            p = new Object[]{configParam.id};
                            params.add(p);
                        }
                    } else if (i == 10) {
                        for (ResDataConfigParam configParam : resRegisParam.resDataConfigParams) {
                            p = new Object[]{configParam.pkId};
                            params.add(p);
                        }
                    } else if (i == 11) {
                        for (ResDataConfigParam configParam : resRegisParam.resDataConfigParams) {
                            p = new Object[]{configParam.id, configParam.billfieldtransfer, configParam.filter, nowTime, "1", resRegisParam.id, Character.valueOf(configParam.issystemdesign), configParam.id, "C", userId, configParam.filter_tag, configParam.number, configParam.sourcetype};
                            params.add(p);
                        }
                    } else {
                        for (ResDataConfigParam configParam : resRegisParam.resDataConfigParams) {
                            enabledLangsentry = InteServiceHelper.getEnabledLang();
                            langListentry = new ArrayList(enabledLangsentry.size());
                            idsentry = DBServiceHelper.genStringIds((String)"t_mrp_rsregisterentry_l", (int)enabledLangsentry.size());
                            e = 0;
                            for (EnabledLang enabledLang : enabledLangsentry) {
                                number = enabledLang.getNumber();
                                p = new Object[4];
                                p[0] = configParam.id;
                                p[1] = idsentry[e];
                                p[2] = number;
                                if (configParam.name != null) {
                                    p[3] = configParam.name.getItem(number);
                                    if (configParam.name.getItem(number) == null) {
                                        p[3] = " ";
                                    }
                                } else {
                                    p[3] = " ";
                                }
                                langListentry.add(p);
                                ++e;
                            }
                            params.add(langListentry);
                        }
                    }
                    break;
                }
                case 13: {
                    String number;
                    int e;
                    String[] idsentry;
                    ArrayList<Object[]> langListentry;
                    List enabledLangsentry;
                    Object[] p;
                    for (ResRegisEntryParam entryParam : resRegisParam.entryParams) {
                        enabledLangsentry = InteServiceHelper.getEnabledLang();
                        langListentry = new ArrayList<Object[]>(enabledLangsentry.size());
                        idsentry = DBServiceHelper.genStringIds((String)"t_mrp_rsregisterentry_l", (int)enabledLangsentry.size());
                        e = 0;
                        for (EnabledLang enabledLang : enabledLangsentry) {
                            number = enabledLang.getNumber();
                            p = new Object[5];
                            p[0] = entryParam.entryId;
                            p[1] = idsentry[e];
                            p[2] = number;
                            if (entryParam.signname != null) {
                                p[3] = entryParam.signname.getItem(number);
                                if (entryParam.signname.getItem(number) == null) {
                                    p[3] = " ";
                                }
                            } else {
                                p[3] = " ";
                            }
                            if (entryParam.datatype != null) {
                                p[4] = entryParam.datatype.getItem(number);
                                if (entryParam.datatype.getItem(number) == null) {
                                    p[4] = " ";
                                }
                            } else {
                                p[4] = " ";
                            }
                            langListentry.add(p);
                            ++e;
                        }
                        params.add(langListentry);
                    }
                    break;
                }
            }
            map.put(InitSQLConst.resSql[i], params);
        }
        return map;
    }

    private static Map<String, Map<String, List<Object>>> getResSql2Param(Long orgId, String defaultctrlstrategy, String appId) {
        HashMap<String, Map<String, List<Object>>> resSql = new HashMap<String, Map<String, List<Object>>>(16);
        ArrayList<ResRegisEntryParam> entryParams = new ArrayList<ResRegisEntryParam>(16);
        entryParams.add(new ResRegisEntryParam(1773137489775563776L, 1, "plan_order_billno", ResManager.getLocaleString((String)"\u6765\u6e90\u8ba2\u5355\u7f16\u53f7", (String)"InitDataConst_102", (String)"mmc-mps-common"), ResManager.getLocaleString((String)"\u6587\u672c\u578b", (String)"InitDataConst_103", (String)"mmc-mps-common"), ResManager.loadKDString((String)"\u8f85\u52a9\u4fe1\u606f", (String)"InitDataConst_104", (String)"mmc-mps-common", (Object[])new Object[0]), "", "", ""));
        entryParams.add(new ResRegisEntryParam(1773137489775563777L, 2, "sourcebillid", ResManager.getLocaleString((String)"\u6765\u6e90\u5355\u636eID", (String)"InitDataConst_105", (String)"mmc-mps-common"), ResManager.getLocaleString((String)"\u957f\u6574\u6570", (String)"InitDataConst_106", (String)"mmc-mps-common"), " ", "", "", ""));
        entryParams.add(new ResRegisEntryParam(1773137489775563778L, 3, "production_org", ResManager.getLocaleString((String)"\u751f\u4ea7\u7ec4\u7ec7", (String)"InitDataConst_107", (String)"mmc-mps-common"), ResManager.getLocaleString((String)"\u7ec4\u7ec7", (String)"InitDataConst_19", (String)"mmc-mps-common"), ResManager.loadKDString((String)"\u4e3b\u4e1a\u52a1\u7ec4\u7ec7", (String)"InitDataConst_23", (String)"mmc-mps-common", (Object[])new Object[0]), "", "", ""));
        entryParams.add(new ResRegisEntryParam(1773137489775563779L, 4, "materiel_code", ResManager.getLocaleString((String)"\u7269\u6599\u7f16\u7801", (String)"InitDataConst_108", (String)"mmc-mps-common"), ResManager.getLocaleString((String)"\u7269\u6599", (String)"InitDataConst_109", (String)"mmc-mps-common"), ResManager.loadKDString((String)"\u666e\u901a\u7ef4\u5ea6", (String)"InitDataConst_24", (String)"mmc-mps-common", (Object[])new Object[0]), "", "", ""));
        entryParams.add(new ResRegisEntryParam(1773137489775563780L, 5, "billtype", ResManager.getLocaleString((String)"\u6765\u6e90\u5b9e\u4f53\u7c7b\u578b", (String)"InitDataConst_110", (String)"mmc-mps-common"), ResManager.getLocaleString((String)"\u57fa\u7840\u8d44\u6599", (String)"InitDataConst_20", (String)"mmc-mps-common"), ResManager.loadKDString((String)"\u666e\u901a\u7ef4\u5ea6", (String)"InitDataConst_24", (String)"mmc-mps-common", (Object[])new Object[0]), "", "", ""));
        entryParams.add(new ResRegisEntryParam(1773137489775563781L, 6, "remark", ResManager.getLocaleString((String)"\u5907\u6ce8", (String)"InitDataConst_111", (String)"mmc-mps-common"), ResManager.getLocaleString((String)"\u591a\u884c\u6587\u672c\u578b", (String)"InitDataConst_112", (String)"mmc-mps-common"), ResManager.loadKDString((String)"\u8f85\u52a9\u4fe1\u606f", (String)"InitDataConst_104", (String)"mmc-mps-common", (Object[])new Object[0]), "", "", ""));
        entryParams.add(new ResRegisEntryParam(1773137489775563782L, 7, "unit", ResManager.getLocaleString((String)"\u57fa\u672c\u5355\u4f4d", (String)"InitDataConst_113", (String)"mmc-mps-common"), ResManager.getLocaleString((String)"\u57fa\u7840\u8d44\u6599", (String)"InitDataConst_20", (String)"mmc-mps-common"), ResManager.loadKDString((String)"\u666e\u901a\u7ef4\u5ea6", (String)"InitDataConst_24", (String)"mmc-mps-common", (Object[])new Object[0]), "", "", ""));
        entryParams.add(new ResRegisEntryParam(1773137489775563783L, 8, "plan_start_date", ResManager.getLocaleString((String)"\u8ba1\u5212\u5f00\u59cb\u65e5\u671f", (String)"InitDataConst_114", (String)"mmc-mps-common"), ResManager.getLocaleString((String)"\u65e5\u671f\u578b", (String)"InitDataConst_115", (String)"mmc-mps-common"), " ", "", "", ""));
        entryParams.add(new ResRegisEntryParam(1773137489775563784L, 9, "plan_finish_date", ResManager.getLocaleString((String)"\u8ba1\u5212\u7ed3\u675f\u65e5\u671f", (String)"InitDataConst_116", (String)"mmc-mps-common"), ResManager.getLocaleString((String)"\u65e5\u671f\u578b", (String)"InitDataConst_115", (String)"mmc-mps-common"), " ", "", "", ""));
        entryParams.add(new ResRegisEntryParam(1773137489775563785L, 10, "sourceentryid", ResManager.getLocaleString((String)"\u6765\u6e90\u5206\u5f55ID", (String)"InitDataConst_117", (String)"mmc-mps-common"), ResManager.getLocaleString((String)"\u957f\u6574\u6570", (String)"InitDataConst_106", (String)"mmc-mps-common"), " ", "", "", ""));
        entryParams.add(new ResRegisEntryParam(1773137489775563786L, 11, "tracknumber", ResManager.getLocaleString((String)"\u8ddf\u8e2a\u53f7", (String)"InitDataConst_118", (String)"mmc-mps-common"), ResManager.getLocaleString((String)"\u57fa\u7840\u8d44\u6599", (String)"InitDataConst_20", (String)"mmc-mps-common"), ResManager.loadKDString((String)"\u666e\u901a\u7ef4\u5ea6", (String)"InitDataConst_24", (String)"mmc-mps-common", (Object[])new Object[0]), "", "", ""));
        entryParams.add(new ResRegisEntryParam(1773137489775563787L, 12, "configure", ResManager.getLocaleString((String)"\u914d\u7f6e\u53f7", (String)"InitDataConst_119", (String)"mmc-mps-common"), ResManager.getLocaleString((String)"\u57fa\u7840\u8d44\u6599", (String)"InitDataConst_20", (String)"mmc-mps-common"), ResManager.loadKDString((String)"\u666e\u901a\u7ef4\u5ea6", (String)"InitDataConst_24", (String)"mmc-mps-common", (Object[])new Object[0]), "", "", ""));
        entryParams.add(new ResRegisEntryParam(1773137489775563788L, 13, "pls_date", ResManager.getLocaleString((String)"\u6392\u4ea7\u65e5\u671f", (String)"InitDataConst_120", (String)"mmc-mps-common"), ResManager.getLocaleString((String)"\u65e5\u671f\u578b", (String)"InitDataConst_115", (String)"mmc-mps-common"), " ", "", "", ""));
        entryParams.add(new ResRegisEntryParam(1773137489775563789L, 14, "workcenter", ResManager.getLocaleString((String)"\u5de5\u4f5c\u4e2d\u5fc3", (String)"InitDataConst_16", (String)"mmc-mps-common"), ResManager.getLocaleString((String)"\u57fa\u7840\u8d44\u6599", (String)"InitDataConst_20", (String)"mmc-mps-common"), ResManager.loadKDString((String)"\u666e\u901a\u7ef4\u5ea6", (String)"InitDataConst_24", (String)"mmc-mps-common", (Object[])new Object[0]), "", "", ""));
        entryParams.add(new ResRegisEntryParam(1773137489775563790L, 15, "auxiliary", ResManager.getLocaleString((String)"\u8f85\u52a9\u5c5e\u6027", (String)"InitDataConst_121", (String)"mmc-mps-common"), ResManager.getLocaleString((String)"\u5f39\u6027\u57df", (String)"InitDataConst_122", (String)"mmc-mps-common"), ResManager.loadKDString((String)"\u666e\u901a\u7ef4\u5ea6", (String)"InitDataConst_24", (String)"mmc-mps-common", (Object[])new Object[0]), "", "", ""));
        entryParams.add(new ResRegisEntryParam(1773137489775563791L, 16, "plsqty", ResManager.getLocaleString((String)"\u6570\u91cf", (String)"InitDataConst_18", (String)"mmc-mps-common"), ResManager.getLocaleString((String)"\u6570\u91cf\u578b", (String)"InitDataConst_123", (String)"mmc-mps-common"), "", "", "", ""));
        entryParams.add(new ResRegisEntryParam(1773137489783952384L, 17, "eigenvalue", ResManager.getLocaleString((String)"\u914d\u7f6e\u63cf\u8ff0", (String)"InitDataConst_124", (String)"mmc-mps-common"), ResManager.getLocaleString((String)"\u5927\u6587\u672c\u578b", (String)"InitDataConst_125", (String)"mmc-mps-common"), ResManager.loadKDString((String)"\u8f85\u52a9\u4fe1\u606f", (String)"InitDataConst_104", (String)"mmc-mps-common", (Object[])new Object[0]), "", "", ""));
        entryParams.add(new ResRegisEntryParam(1773137489783952385L, 18, "processroute", ResManager.getLocaleString((String)"\u5de5\u827a\u8def\u7ebf", (String)"InitDataConst_126", (String)"mmc-mps-common"), ResManager.getLocaleString((String)"\u57fa\u7840\u8d44\u6599", (String)"InitDataConst_20", (String)"mmc-mps-common"), ResManager.loadKDString((String)"\u666e\u901a\u7ef4\u5ea6", (String)"InitDataConst_24", (String)"mmc-mps-common", (Object[])new Object[0]), "", "", ""));
        entryParams.add(new ResRegisEntryParam(1773137489783952386L, 19, "productionversion", ResManager.getLocaleString((String)"\u751f\u4ea7\u7248\u672c", (String)"InitDataConst_127", (String)"mmc-mps-common"), ResManager.getLocaleString((String)"\u57fa\u7840\u8d44\u6599", (String)"InitDataConst_20", (String)"mmc-mps-common"), ResManager.loadKDString((String)"\u666e\u901a\u7ef4\u5ea6", (String)"InitDataConst_24", (String)"mmc-mps-common", (Object[])new Object[0]), "", "", ""));
        entryParams.add(new ResRegisEntryParam(1773137489783952387L, 20, "sourcebillentryno", ResManager.getLocaleString((String)"\u6765\u6e90\u8ba2\u5355\u884c\u53f7", (String)"InitDataConst_128", (String)"mmc-mps-common"), ResManager.getLocaleString((String)"\u6574\u6570", (String)"InitDataConst_22", (String)"mmc-mps-common"), "", "", "", ""));
        entryParams.add(new ResRegisEntryParam(1773137489783952388L, 21, "bailedorg", ResManager.getLocaleString((String)"\u59d4\u6258\u7ec4\u7ec7", (String)"InitDataConst_129", (String)"mmc-mps-common"), ResManager.getLocaleString((String)"\u7ec4\u7ec7", (String)"InitDataConst_19", (String)"mmc-mps-common"), ResManager.loadKDString((String)"\u4e3b\u4e1a\u52a1\u7ec4\u7ec7", (String)"InitDataConst_23", (String)"mmc-mps-common", (Object[])new Object[0]), "", "", ""));
        entryParams.add(new ResRegisEntryParam(1773137489783952389L, 22, "orderpoolid", ResManager.getLocaleString((String)"\u8ba2\u5355\u6c60ID", (String)"InitDataConst_130", (String)"mmc-mps-common"), ResManager.getLocaleString((String)"\u957f\u6574\u6570", (String)"InitDataConst_106", (String)"mmc-mps-common"), "", "", "", ""));
        ArrayList<ResDataConfigParam> resDataConfigParams = new ArrayList<ResDataConfigParam>(16);
        resDataConfigParams.add(new ResDataConfigParam(1773232972820913152L, "3JTCZB4LAOGG", "DS-1168", ResManager.getLocaleString((String)"\u6392\u4ea7\u8ba1\u5212", (String)"InitDataConst_6", (String)"mmc-mps-common"), 1773141659559662592L, '0', "", "{\"filterRow\":[{\"id\":\"3KANUA9+LQ1Z\",\"leftBracket\":\"\",\"compareType\":\"17\",\"fieldName\":\"billstatus\",\"rightBracket\":\"\",\"logic\":\"0\",\"value\":[{\"id\":\"3KANUA9282XZ\",\"value\":\"C\"},{\"id\":\"3KANUA92849G\",\"value\":\"D\"}],\"baseDataIds\":[]},{\"id\":\"3KANUA9282Y+\",\"leftBracket\":\"\",\"compareType\":\"105\",\"fieldName\":\"cancel\",\"rightBracket\":\"\",\"logic\":\"0\",\"value\":[{\"id\":\"3KANUA95VJG+\",\"value\":\"0\"}],\"baseDataIds\":[]}],\"forList\":false}", "mps"));
        ResRegisParam resRegisParam = new ResRegisParam(orgId, defaultctrlstrategy, 1773137489700066304L, "3JSY3JL5NMDF", "Reserved plan", ResManager.getLocaleString((String)"\u5df2\u5206\u914d\u8ba2\u5355", (String)"InitDataConst_13", (String)"mmc-mps-common"), "10", "10", "mps_pls_assignedorder", 0L, 0L, 0L, "", 0L, entryParams, resDataConfigParams, appId);
        resSql.put("Reserved plan", InitDataConst.getResRegisParam(resRegisParam));
        entryParams = new ArrayList(16);
        entryParams.add(new ResRegisEntryParam(1773127373441471488L, 1, "plan_order_billno", ResManager.getLocaleString((String)"\u6765\u6e90\u8ba2\u5355\u7f16\u53f7", (String)"InitDataConst_102", (String)"mmc-mps-common"), ResManager.getLocaleString((String)"\u6587\u672c\u578b", (String)"InitDataConst_103", (String)"mmc-mps-common"), ResManager.loadKDString((String)"\u8f85\u52a9\u4fe1\u606f", (String)"InitDataConst_104", (String)"mmc-mps-common", (Object[])new Object[0]), "", "", ""));
        entryParams.add(new ResRegisEntryParam(1773127373441471489L, 2, "sourcebillid", ResManager.getLocaleString((String)"\u6765\u6e90\u5355\u636eID", (String)"InitDataConst_105", (String)"mmc-mps-common"), ResManager.getLocaleString((String)"\u957f\u6574\u6570", (String)"InitDataConst_106", (String)"mmc-mps-common"), " ", "", "", ""));
        entryParams.add(new ResRegisEntryParam(1773127373441471490L, 3, "production_org", ResManager.getLocaleString((String)"\u751f\u4ea7\u7ec4\u7ec7", (String)"InitDataConst_107", (String)"mmc-mps-common"), ResManager.getLocaleString((String)"\u7ec4\u7ec7", (String)"InitDataConst_19", (String)"mmc-mps-common"), ResManager.loadKDString((String)"\u4e3b\u4e1a\u52a1\u7ec4\u7ec7", (String)"InitDataConst_23", (String)"mmc-mps-common", (Object[])new Object[0]), "", "", ""));
        entryParams.add(new ResRegisEntryParam(1773127373441471491L, 4, "materiel_code", ResManager.getLocaleString((String)"\u7269\u6599\u7f16\u7801", (String)"InitDataConst_108", (String)"mmc-mps-common"), ResManager.getLocaleString((String)"\u7269\u6599", (String)"InitDataConst_109", (String)"mmc-mps-common"), ResManager.loadKDString((String)"\u666e\u901a\u7ef4\u5ea6", (String)"InitDataConst_24", (String)"mmc-mps-common", (Object[])new Object[0]), "", "", ""));
        entryParams.add(new ResRegisEntryParam(1773127373441471492L, 5, "billtype", ResManager.getLocaleString((String)"\u6765\u6e90\u5b9e\u4f53\u7c7b\u578b", (String)"InitDataConst_110", (String)"mmc-mps-common"), ResManager.getLocaleString((String)"\u57fa\u7840\u8d44\u6599", (String)"InitDataConst_20", (String)"mmc-mps-common"), ResManager.loadKDString((String)"\u666e\u901a\u7ef4\u5ea6", (String)"InitDataConst_24", (String)"mmc-mps-common", (Object[])new Object[0]), "", "", ""));
        entryParams.add(new ResRegisEntryParam(1773127373441471493L, 6, "attribute", ResManager.getLocaleString((String)"\u7269\u6599\u5c5e\u6027", (String)"InitDataConst_131", (String)"mmc-mps-common"), ResManager.getLocaleString((String)"\u6587\u672c\u578b", (String)"InitDataConst_103", (String)"mmc-mps-common"), ResManager.loadKDString((String)"\u8f85\u52a9\u4fe1\u606f", (String)"InitDataConst_104", (String)"mmc-mps-common", (Object[])new Object[0]), "", "", ""));
        entryParams.add(new ResRegisEntryParam(1773127373441471494L, 7, "remark", ResManager.getLocaleString((String)"\u5907\u6ce8", (String)"InitDataConst_111", (String)"mmc-mps-common"), ResManager.getLocaleString((String)"\u591a\u884c\u6587\u672c\u578b", (String)"InitDataConst_112", (String)"mmc-mps-common"), ResManager.loadKDString((String)"\u8f85\u52a9\u4fe1\u606f", (String)"InitDataConst_104", (String)"mmc-mps-common", (Object[])new Object[0]), "", "", ""));
        entryParams.add(new ResRegisEntryParam(1773127373441471495L, 8, "order_num", ResManager.getLocaleString((String)"\u8ba2\u5355\u6570\u91cf", (String)"InitDataConst_132", (String)"mmc-mps-common"), ResManager.getLocaleString((String)"\u6570\u91cf\u578b", (String)"InitDataConst_123", (String)"mmc-mps-common"), " ", "", "", ""));
        entryParams.add(new ResRegisEntryParam(1773127373441471496L, 9, "unit", ResManager.getLocaleString((String)"\u57fa\u672c\u5355\u4f4d", (String)"InitDataConst_113", (String)"mmc-mps-common"), ResManager.getLocaleString((String)"\u57fa\u7840\u8d44\u6599", (String)"InitDataConst_20", (String)"mmc-mps-common"), ResManager.loadKDString((String)"\u666e\u901a\u7ef4\u5ea6", (String)"InitDataConst_24", (String)"mmc-mps-common", (Object[])new Object[0]), "", "", ""));
        entryParams.add(new ResRegisEntryParam(1773127373441471497L, 10, "product_yield_rate", ResManager.getLocaleString((String)"\u6210\u54c1\u7387", (String)"InitDataConst_133", (String)"mmc-mps-common"), null, " ", "", "", ""));
        entryParams.add(new ResRegisEntryParam(1773127373441471498L, 11, "product_yield_num", ResManager.getLocaleString((String)"\u6210\u54c1\u6570\u91cf", (String)"InitDataConst_134", (String)"mmc-mps-common"), ResManager.getLocaleString((String)"\u6570\u91cf\u578b", (String)"InitDataConst_123", (String)"mmc-mps-common"), " ", "", "", ""));
        entryParams.add(new ResRegisEntryParam(1773127373441471499L, 12, "bom", new LocaleString("BOM"), ResManager.getLocaleString((String)"\u57fa\u7840\u8d44\u6599", (String)"InitDataConst_20", (String)"mmc-mps-common"), ResManager.loadKDString((String)"\u666e\u901a\u7ef4\u5ea6", (String)"InitDataConst_24", (String)"mmc-mps-common", (Object[])new Object[0]), "", "", ""));
        entryParams.add(new ResRegisEntryParam(1773127373441471500L, 13, "bom_datetime", ResManager.getLocaleString((String)"\u5c55\u5f00BOM\u65f6\u95f4", (String)"InitDataConst_135", (String)"mmc-mps-common"), ResManager.getLocaleString((String)"\u65e5\u671f\u578b", (String)"InitDataConst_115", (String)"mmc-mps-common"), " ", "", "", ""));
        entryParams.add(new ResRegisEntryParam(1773127373441471501L, 14, "ecn_version", ResManager.getLocaleString((String)"ECN\u7248\u672c", (String)"InitDataConst_136", (String)"mmc-mps-common"), ResManager.getLocaleString((String)"\u57fa\u7840\u8d44\u6599", (String)"InitDataConst_20", (String)"mmc-mps-common"), ResManager.loadKDString((String)"\u666e\u901a\u7ef4\u5ea6", (String)"InitDataConst_24", (String)"mmc-mps-common", (Object[])new Object[0]), "", "", ""));
        entryParams.add(new ResRegisEntryParam(1773127373441471502L, 15, "planner", ResManager.getLocaleString((String)"\u8ba1\u5212\u5458", (String)"InitDataConst_137", (String)"mmc-mps-common"), ResManager.getLocaleString((String)"\u7528\u6237", (String)"InitDataConst_138", (String)"mmc-mps-common"), ResManager.loadKDString((String)"\u666e\u901a\u7ef4\u5ea6", (String)"InitDataConst_24", (String)"mmc-mps-common", (Object[])new Object[0]), "", "", ""));
        entryParams.add(new ResRegisEntryParam(1773127373441471503L, 16, "plan_prepare_date", ResManager.getLocaleString((String)"\u8ba1\u5212\u51c6\u5907\u65e5\u671f", (String)"InitDataConst_139", (String)"mmc-mps-common"), ResManager.getLocaleString((String)"\u65e5\u671f\u578b", (String)"InitDataConst_115", (String)"mmc-mps-common"), " ", "", "", ""));
        entryParams.add(new ResRegisEntryParam(1773127373441471504L, 17, "plan_start_date", ResManager.getLocaleString((String)"\u8ba1\u5212\u5f00\u59cb\u65e5\u671f", (String)"InitDataConst_114", (String)"mmc-mps-common"), ResManager.getLocaleString((String)"\u65e5\u671f\u578b", (String)"InitDataConst_115", (String)"mmc-mps-common"), " ", "", "", ""));
        entryParams.add(new ResRegisEntryParam(1773127373441471505L, 18, "plan_finish_date", ResManager.getLocaleString((String)"\u8ba1\u5212\u5b8c\u6210\u65e5\u671f", (String)"InitDataConst_140", (String)"mmc-mps-common"), ResManager.getLocaleString((String)"\u65e5\u671f\u578b", (String)"InitDataConst_115", (String)"mmc-mps-common"), " ", "", "", ""));
        entryParams.add(new ResRegisEntryParam(1773127373441471506L, 19, "available_date", ResManager.getLocaleString((String)"\u53ef\u7528\u65e5\u671f", (String)"InitDataConst_141", (String)"mmc-mps-common"), ResManager.getLocaleString((String)"\u65e5\u671f\u578b", (String)"InitDataConst_115", (String)"mmc-mps-common"), " ", "", "", ""));
        entryParams.add(new ResRegisEntryParam(1773127373441471507L, 20, "sourcebillentryno", ResManager.getLocaleString((String)"\u6765\u6e90\u8ba2\u5355\u884c\u53f7", (String)"InitDataConst_128", (String)"mmc-mps-common"), ResManager.getLocaleString((String)"\u6587\u672c\u578b", (String)"InitDataConst_103", (String)"mmc-mps-common"), ResManager.loadKDString((String)"\u8f85\u52a9\u4fe1\u606f", (String)"InitDataConst_104", (String)"mmc-mps-common", (Object[])new Object[0]), "", "", ""));
        entryParams.add(new ResRegisEntryParam(1773127373441471508L, 21, "sourceentryid", ResManager.getLocaleString((String)"\u6765\u6e90\u5206\u5f55ID", (String)"InitDataConst_117", (String)"mmc-mps-common"), ResManager.getLocaleString((String)"\u957f\u6574\u6570", (String)"InitDataConst_106", (String)"mmc-mps-common"), " ", "", "", ""));
        entryParams.add(new ResRegisEntryParam(1773127373441471509L, 22, "tracknumber", ResManager.getLocaleString((String)"\u8ddf\u8e2a\u53f7", (String)"InitDataConst_118", (String)"mmc-mps-common"), ResManager.getLocaleString((String)"\u57fa\u7840\u8d44\u6599", (String)"InitDataConst_20", (String)"mmc-mps-common"), ResManager.loadKDString((String)"\u666e\u901a\u7ef4\u5ea6", (String)"InitDataConst_24", (String)"mmc-mps-common", (Object[])new Object[0]), "", "", ""));
        entryParams.add(new ResRegisEntryParam(1773127373441471510L, 23, "configure", ResManager.getLocaleString((String)"\u914d\u7f6e\u53f7", (String)"InitDataConst_119", (String)"mmc-mps-common"), ResManager.getLocaleString((String)"\u57fa\u7840\u8d44\u6599", (String)"InitDataConst_20", (String)"mmc-mps-common"), ResManager.loadKDString((String)"\u666e\u901a\u7ef4\u5ea6", (String)"InitDataConst_24", (String)"mmc-mps-common", (Object[])new Object[0]), "", "", ""));
        entryParams.add(new ResRegisEntryParam(1773127373441471511L, 24, "priority", ResManager.getLocaleString((String)"\u8ba2\u5355\u4f18\u5148\u7ea7", (String)"InitDataConst_142", (String)"mmc-mps-common"), ResManager.getLocaleString((String)"\u6574\u6570", (String)"InitDataConst_22", (String)"mmc-mps-common"), " ", "", "", ""));
        entryParams.add(new ResRegisEntryParam(1773127373441471512L, 25, "requiredate", ResManager.getLocaleString((String)"\u9700\u6c42\u65e5\u671f", (String)"InitDataConst_143", (String)"mmc-mps-common"), ResManager.getLocaleString((String)"\u65e5\u671f\u578b", (String)"InitDataConst_115", (String)"mmc-mps-common"), " ", "", "", ""));
        entryParams.add(new ResRegisEntryParam(1773127373441471513L, 26, "workcenter", ResManager.getLocaleString((String)"\u5de5\u4f5c\u4e2d\u5fc3", (String)"InitDataConst_16", (String)"mmc-mps-common"), ResManager.getLocaleString((String)"\u57fa\u7840\u8d44\u6599", (String)"InitDataConst_20", (String)"mmc-mps-common"), ResManager.loadKDString((String)"\u666e\u901a\u7ef4\u5ea6", (String)"InitDataConst_24", (String)"mmc-mps-common", (Object[])new Object[0]), "", "", ""));
        entryParams.add(new ResRegisEntryParam(1773127373441471514L, 27, "auxiliary", ResManager.getLocaleString((String)"\u8f85\u52a9\u5c5e\u6027", (String)"InitDataConst_121", (String)"mmc-mps-common"), ResManager.getLocaleString((String)"\u5f39\u6027\u57df", (String)"InitDataConst_122", (String)"mmc-mps-common"), ResManager.loadKDString((String)"\u666e\u901a\u7ef4\u5ea6", (String)"InitDataConst_24", (String)"mmc-mps-common", (Object[])new Object[0]), "", "", ""));
        entryParams.add(new ResRegisEntryParam(1773127373441471515L, 28, "plsqty", ResManager.getLocaleString((String)"\u5df2\u6392\u4ea7\u6570\u91cf", (String)"InitDataConst_144", (String)"mmc-mps-common"), ResManager.getLocaleString((String)"\u6570\u91cf\u578b", (String)"InitDataConst_123", (String)"mmc-mps-common"), " ", "", "", ""));
        entryParams.add(new ResRegisEntryParam(1773127373441471516L, 29, "orderpoolid", ResManager.getLocaleString((String)"\u8ba2\u5355\u6c60ID", (String)"InitDataConst_130", (String)"mmc-mps-common"), ResManager.getLocaleString((String)"\u957f\u6574\u6570", (String)"InitDataConst_106", (String)"mmc-mps-common"), " ", "", "", ""));
        entryParams.add(new ResRegisEntryParam(1773127373441471517L, 30, "bailedorg", ResManager.getLocaleString((String)"\u59d4\u6258\u7ec4\u7ec7", (String)"InitDataConst_129", (String)"mmc-mps-common"), ResManager.getLocaleString((String)"\u7ec4\u7ec7", (String)"InitDataConst_19", (String)"mmc-mps-common"), ResManager.loadKDString((String)"\u4e3b\u4e1a\u52a1\u7ec4\u7ec7", (String)"InitDataConst_23", (String)"mmc-mps-common", (Object[])new Object[0]), "", "", ""));
        entryParams.add(new ResRegisEntryParam(1773127373441471518L, 31, "mafulldate", ResManager.getLocaleString((String)"\u7269\u6599\u6ee1\u8db3\u65e5\u671f", (String)"InitDataConst_145", (String)"mmc-mps-common"), ResManager.getLocaleString((String)"\u65e5\u671f\u578b", (String)"InitDataConst_115", (String)"mmc-mps-common"), " ", "", "", ""));
        resDataConfigParams = new ArrayList(16);
        resDataConfigParams.add(new ResDataConfigParam(1773135550321130496L, "3JSXREE7OUIJ", "DS-1167", ResManager.getLocaleString((String)"\u9500\u552e\u8ba2\u5355-\u5957\u4ef6-\u4ea7\u54c1\u6f14\u793a-\u522b\u5220", (String)"InitDataConst_12", (String)"mmc-mps-common"), 1736165573051550720L, '0', "", "{\"filterRow\":[{\"id\":\"3JSXT1RIONQB\",\"leftBracket\":\"\",\"compareType\":\"105\",\"fieldName\":\"billstatus\",\"rightBracket\":\"\",\"logic\":\"0\",\"value\":[{\"id\":\"3JSXT1RIMJL1\",\"value\":\"C\"}],\"baseDataIds\":[]},{\"id\":\"3JSXT1RIONQC\",\"leftBracket\":\"\",\"compareType\":\"105\",\"fieldName\":\"rowclosestatus\",\"rightBracket\":\"\",\"logic\":\"0\",\"value\":[{\"id\":\"3JSXT1RIMJL2\",\"value\":\"A\"}],\"baseDataIds\":[]},{\"id\":\"3JSXT1RIONQD\",\"leftBracket\":\"\",\"compareType\":\"105\",\"fieldName\":\"rowterminatestatus\",\"rightBracket\":\"\",\"logic\":\"0\",\"value\":[{\"id\":\"3JSXT1RIMJL3\",\"value\":\"A\"}],\"baseDataIds\":[]}],\"forList\":false}", "mps"));
        resRegisParam = new ResRegisParam(orgId, defaultctrlstrategy, 1773127372845880320L, "3JSW7ULS2OCX", "Pending schedule", ResManager.getLocaleString((String)"\u5f85\u6392\u8ba1\u5212", (String)"InitDataConst_14", (String)"mmc-mps-common"), "10", "10", "mps_pls_order", 0L, 0L, 0L, "", 0L, entryParams, resDataConfigParams, appId);
        resSql.put("Pending schedule", InitDataConst.getResRegisParam(resRegisParam));
        entryParams = new ArrayList(16);
        entryParams.add(new ResRegisEntryParam(1800136835968632832L, 1, "createorg", ResManager.getLocaleString((String)"\u521b\u5efa\u7ec4\u7ec7", (String)"InitDataConst_15", (String)"mmc-mps-common"), ResManager.getLocaleString((String)"\u7ec4\u7ec7", (String)"InitDataConst_19", (String)"mmc-mps-common"), ResManager.loadKDString((String)"\u4e3b\u4e1a\u52a1\u7ec4\u7ec7", (String)"InitDataConst_23", (String)"mmc-mps-common", (Object[])new Object[0]), "", "", ""));
        entryParams.add(new ResRegisEntryParam(1800136835968632833L, 2, "workcenter", ResManager.getLocaleString((String)"\u5de5\u4f5c\u4e2d\u5fc3", (String)"InitDataConst_16", (String)"mmc-mps-common"), ResManager.getLocaleString((String)"\u57fa\u7840\u8d44\u6599", (String)"InitDataConst_20", (String)"mmc-mps-common"), ResManager.loadKDString((String)"\u666e\u901a\u7ef4\u5ea6", (String)"InitDataConst_24", (String)"mmc-mps-common", (Object[])new Object[0]), "", "", ""));
        entryParams.add(new ResRegisEntryParam(1800136835968632834L, 3, "resource", ResManager.getLocaleString((String)"\u8d44\u6e90\u7f16\u7801", (String)"InitDataConst_17", (String)"mmc-mps-common"), ResManager.getLocaleString((String)"\u57fa\u7840\u8d44\u6599", (String)"InitDataConst_20", (String)"mmc-mps-common"), ResManager.loadKDString((String)"\u666e\u901a\u7ef4\u5ea6", (String)"InitDataConst_24", (String)"mmc-mps-common", (Object[])new Object[0]), "", "", ""));
        entryParams.add(new ResRegisEntryParam(1800136835968632835L, 4, "resouceqty", ResManager.getLocaleString((String)"\u6570\u91cf", (String)"InitDataConst_18", (String)"mmc-mps-common"), ResManager.getLocaleString((String)"\u6574\u6570", (String)"InitDataConst_22", (String)"mmc-mps-common"), "", "", "", ""));
        resDataConfigParams = new ArrayList(16);
        resDataConfigParams.add(new ResDataConfigParam(1800136836673185792L, "3N39UB+JQCQY", "DS-1029", ResManager.getLocaleString((String)"\u5de5\u4f5c\u4e2d\u5fc3\u5b9a\u4e49", (String)"InitDataConst_26", (String)"mmc-mps-common"), 1800087355537804288L, '0', "", "{\"filterRow\":[{\"id\":\"3Q4/=QOA7JB1\",\"leftBracket\":\"\",\"compareType\":\"105\",\"fieldName\":\"status\",\"rightBracket\":\"\",\"logic\":\"0\",\"value\":[{\"id\":\"3Q4/=QOA8=ZB\",\"value\":\"C\"}],\"baseDataIds\":[]},{\"id\":\"3Q4/=QOA7JB2\",\"leftBracket\":\"\",\"compareType\":\"105\",\"fieldName\":\"enable\",\"rightBracket\":\"\",\"logic\":\"0\",\"value\":[{\"id\":\"3Q4/=QOA8=ZC\",\"value\":\"1\"}],\"baseDataIds\":[]}],\"forList\":false}", "mps"));
        resRegisParam = new ResRegisParam(orgId, defaultctrlstrategy, 1800136835951855616L, "3N39UASR3+A=", "ResourceModel", ResManager.getLocaleString((String)"\u8d44\u6e90\u6a21\u578b", (String)"InitDataConst_27", (String)"mmc-mps-common"), "10", "10", "mps_resourcemodel", 0L, 0L, 0L, "", 0L, entryParams, resDataConfigParams, appId);
        resSql.put("ResourceModel", InitDataConst.getResRegisParam(resRegisParam));
        entryParams = new ArrayList(16);
        entryParams.add(new ResRegisEntryParam(1800121521297958912L, 1, "createorg", ResManager.getLocaleString((String)"\u521b\u5efa\u7ec4\u7ec7", (String)"InitDataConst_15", (String)"mmc-mps-common"), ResManager.getLocaleString((String)"\u7ec4\u7ec7", (String)"InitDataConst_19", (String)"mmc-mps-common"), ResManager.loadKDString((String)"\u4e3b\u4e1a\u52a1\u7ec4\u7ec7", (String)"InitDataConst_23", (String)"mmc-mps-common", (Object[])new Object[0]), "", "", ""));
        entryParams.add(new ResRegisEntryParam(1800121521297958913L, 2, "productionorg", ResManager.getLocaleString((String)"\u52a0\u5de5\u7ec4\u7ec7", (String)"InitDataConst_146", (String)"mmc-mps-common"), ResManager.getLocaleString((String)"\u7ec4\u7ec7", (String)"InitDataConst_19", (String)"mmc-mps-common"), ResManager.loadKDString((String)"\u4e3b\u4e1a\u52a1\u7ec4\u7ec7", (String)"InitDataConst_23", (String)"mmc-mps-common", (Object[])new Object[0]), "", "", ""));
        entryParams.add(new ResRegisEntryParam(1800121521297958914L, 3, "processroute", ResManager.getLocaleString((String)"\u5de5\u827a\u8def\u7ebf", (String)"InitDataConst_126", (String)"mmc-mps-common"), ResManager.getLocaleString((String)"\u57fa\u7840\u8d44\u6599", (String)"InitDataConst_20", (String)"mmc-mps-common"), ResManager.loadKDString((String)"\u666e\u901a\u7ef4\u5ea6", (String)"InitDataConst_24", (String)"mmc-mps-common", (Object[])new Object[0]), "", "", ""));
        entryParams.add(new ResRegisEntryParam(1800121521297958915L, 4, "processtype", ResManager.getLocaleString((String)"\u5de5\u827a\u7c7b\u578b", (String)"InitDataConst_147", (String)"mmc-mps-common"), ResManager.getLocaleString((String)"\u4e0b\u62c9\u5217\u8868", (String)"InitDataConst_148", (String)"mmc-mps-common"), " ", "", "", ""));
        entryParams.add(new ResRegisEntryParam(1800121521297958916L, 5, "material", ResManager.getLocaleString((String)"\u7269\u6599\u7f16\u7801", (String)"InitDataConst_108", (String)"mmc-mps-common"), ResManager.getLocaleString((String)"\u57fa\u7840\u8d44\u6599", (String)"InitDataConst_20", (String)"mmc-mps-common"), ResManager.loadKDString((String)"\u666e\u901a\u7ef4\u5ea6", (String)"InitDataConst_24", (String)"mmc-mps-common", (Object[])new Object[0]), "", "", ""));
        entryParams.add(new ResRegisEntryParam(1800121521297958917L, 6, "materialgroup", ResManager.getLocaleString((String)"\u7269\u6599\u63a7\u5236\u7ec4", (String)"InitDataConst_149", (String)"mmc-mps-common"), ResManager.getLocaleString((String)"\u57fa\u7840\u8d44\u6599", (String)"InitDataConst_20", (String)"mmc-mps-common"), ResManager.loadKDString((String)"\u666e\u901a\u7ef4\u5ea6", (String)"InitDataConst_24", (String)"mmc-mps-common", (Object[])new Object[0]), "", "", ""));
        entryParams.add(new ResRegisEntryParam(1800121521297958918L, 7, "unit", ResManager.getLocaleString((String)"\u8ba1\u91cf\u5355\u4f4d", (String)"InitDataConst_150", (String)"mmc-mps-common"), ResManager.getLocaleString((String)"\u57fa\u7840\u8d44\u6599", (String)"InitDataConst_20", (String)"mmc-mps-common"), ResManager.loadKDString((String)"\u666e\u901a\u7ef4\u5ea6", (String)"InitDataConst_24", (String)"mmc-mps-common", (Object[])new Object[0]), "", "", ""));
        entryParams.add(new ResRegisEntryParam(1800121521297958919L, 8, "auxproperty", ResManager.getLocaleString((String)"\u8f85\u52a9\u5c5e\u6027", (String)"InitDataConst_121", (String)"mmc-mps-common"), ResManager.getLocaleString((String)"\u5f39\u6027\u57df", (String)"InitDataConst_122", (String)"mmc-mps-common"), ResManager.loadKDString((String)"\u666e\u901a\u7ef4\u5ea6", (String)"InitDataConst_24", (String)"mmc-mps-common", (Object[])new Object[0]), "", "", ""));
        entryParams.add(new ResRegisEntryParam(1800121521297958920L, 9, "group", ResManager.getLocaleString((String)"\u5de5\u827a\u8def\u7ebf\u5206\u7ec4", (String)"InitDataConst_151", (String)"mmc-mps-common"), ResManager.getLocaleString((String)"\u57fa\u7840\u8d44\u6599", (String)"InitDataConst_20", (String)"mmc-mps-common"), ResManager.loadKDString((String)"\u666e\u901a\u7ef4\u5ea6", (String)"InitDataConst_24", (String)"mmc-mps-common", (Object[])new Object[0]), "", "", ""));
        entryParams.add(new ResRegisEntryParam(1800121521297958921L, 10, "operationno", ResManager.getLocaleString((String)"\u5de5\u5e8f\u53f7", (String)"InitDataConst_152", (String)"mmc-mps-common"), ResManager.getLocaleString((String)"\u6587\u672c\u578b", (String)"InitDataConst_103", (String)"mmc-mps-common"), ResManager.loadKDString((String)"\u8f85\u52a9\u4fe1\u606f", (String)"InitDataConst_104", (String)"mmc-mps-common", (Object[])new Object[0]), "", "", ""));
        entryParams.add(new ResRegisEntryParam(1800121521297958922L, 11, "productionworkshop", ResManager.getLocaleString((String)"\u751f\u4ea7\u8f66\u95f4", (String)"InitDataConst_153", (String)"mmc-mps-common"), ResManager.getLocaleString((String)"\u57fa\u7840\u8d44\u6599", (String)"InitDataConst_20", (String)"mmc-mps-common"), ResManager.loadKDString((String)"\u666e\u901a\u7ef4\u5ea6", (String)"InitDataConst_24", (String)"mmc-mps-common", (Object[])new Object[0]), "", "", ""));
        entryParams.add(new ResRegisEntryParam(1800121521297958923L, 12, "workcenter", ResManager.getLocaleString((String)"\u5de5\u4f5c\u4e2d\u5fc3", (String)"InitDataConst_16", (String)"mmc-mps-common"), ResManager.getLocaleString((String)"\u57fa\u7840\u8d44\u6599", (String)"InitDataConst_20", (String)"mmc-mps-common"), ResManager.loadKDString((String)"\u666e\u901a\u7ef4\u5ea6", (String)"InitDataConst_24", (String)"mmc-mps-common", (Object[])new Object[0]), "", "", ""));
        entryParams.add(new ResRegisEntryParam(1800121521297958924L, 13, "operation", ResManager.getLocaleString((String)"\u5de5\u5e8f\u7f16\u7801", (String)"InitDataConst_154", (String)"mmc-mps-common"), ResManager.getLocaleString((String)"\u57fa\u7840\u8d44\u6599", (String)"InitDataConst_20", (String)"mmc-mps-common"), ResManager.loadKDString((String)"\u666e\u901a\u7ef4\u5ea6", (String)"InitDataConst_24", (String)"mmc-mps-common", (Object[])new Object[0]), "", "", ""));
        entryParams.add(new ResRegisEntryParam(1800121521297958925L, 14, "operationdesc", ResManager.getLocaleString((String)"\u5de5\u5e8f\u8bf4\u660e", (String)"InitDataConst_155", (String)"mmc-mps-common"), ResManager.getLocaleString((String)"\u6587\u672c\u578b", (String)"InitDataConst_103", (String)"mmc-mps-common"), ResManager.loadKDString((String)"\u8f85\u52a9\u4fe1\u606f", (String)"InitDataConst_104", (String)"mmc-mps-common", (Object[])new Object[0]), "", "", ""));
        entryParams.add(new ResRegisEntryParam(1800121521297958926L, 15, "activity", ResManager.getLocaleString((String)"\u6d3b\u52a8\u7f16\u7801", (String)"InitDataConst_156", (String)"mmc-mps-common"), ResManager.getLocaleString((String)"\u57fa\u7840\u8d44\u6599", (String)"InitDataConst_20", (String)"mmc-mps-common"), ResManager.loadKDString((String)"\u666e\u901a\u7ef4\u5ea6", (String)"InitDataConst_24", (String)"mmc-mps-common", (Object[])new Object[0]), "", "", ""));
        entryParams.add(new ResRegisEntryParam(1800121521297958927L, 16, "actresource", ResManager.getLocaleString((String)"\u8d44\u6e90", (String)"InitDataConst_157", (String)"mmc-mps-common"), ResManager.getLocaleString((String)"\u57fa\u7840\u8d44\u6599", (String)"InitDataConst_20", (String)"mmc-mps-common"), ResManager.loadKDString((String)"\u666e\u901a\u7ef4\u5ea6", (String)"InitDataConst_24", (String)"mmc-mps-common", (Object[])new Object[0]), "", "", ""));
        resDataConfigParams = new ArrayList(16);
        resDataConfigParams.add(new ResDataConfigParam(1800121524838041600L, "3N36ZRGTSJQE", "DS-1028", ResManager.getLocaleString((String)"\u5de5\u827a\u8def\u7ebf\u7ef4\u62a4", (String)"InitDataConst_28", (String)"mmc-mps-common"), 1799914787837113344L, '0', "", "{\"filterRow\":[{\"id\":\"3N36ZI9YBEDH\",\"leftBracket\":\"\",\"compareType\":\"105\",\"fieldName\":\"status\",\"rightBracket\":\"\",\"logic\":\"0\",\"value\":[{\"id\":\"3N36ZI=/YABF\",\"value\":\"C\"}],\"baseDataIds\":[]},{\"id\":\"3N36ZI=/ZUL/\",\"leftBracket\":\"\",\"compareType\":\"105\",\"fieldName\":\"enable\",\"rightBracket\":\"\",\"logic\":\"0\",\"value\":[{\"id\":\"3N36ZI=/YABG\",\"value\":\"1\"}],\"baseDataIds\":[]}],\"forList\":false}", "mps"));
        resRegisParam = new ResRegisParam(orgId, defaultctrlstrategy, 1800121521146963968L, "3N36ZQGKMVOK", "RouteModel", ResManager.getLocaleString((String)"\u5de5\u827a\u8def\u7ebf\u6a21\u578b", (String)"InitDataConst_29", (String)"mmc-mps-common"), "10", "10", "mps_routemmodel", 0L, 0L, 0L, "", 0L, entryParams, resDataConfigParams, appId);
        resSql.put("RouteModel", InitDataConst.getResRegisParam(resRegisParam));
        return resSql;
    }

    private static class ResDataConfigParam {
        Long id;
        String pkId;
        String number;
        LocaleString name;
        Long billfieldtransfer;
        char issystemdesign;
        String filter;
        String filter_tag;
        String sourcetype;

        private ResDataConfigParam(Long id, String pkId, String number, LocaleString name, Long billfieldtransfer, char issystemdesign, String filter, String filter_tag, String sourcetype) {
            this.id = id;
            this.pkId = pkId;
            this.number = number;
            this.name = name;
            this.billfieldtransfer = billfieldtransfer;
            this.issystemdesign = issystemdesign;
            this.filter = filter;
            this.filter_tag = filter_tag;
            this.sourcetype = sourcetype;
        }
    }

    private static class ResRegisEntryParam {
        Long entryId;
        int seq;
        String signid;
        LocaleString signname;
        LocaleString datatype;
        String bizdatatype;
        String defaultvalue;
        String srctype;
        String formuladesc;

        private ResRegisEntryParam(Long entryId, int seq, String signid, LocaleString signname, LocaleString datatype, String bizdatatype, String defaultvalue, String srctype, String formuladesc) {
            this.entryId = entryId;
            this.seq = seq;
            this.signid = signid;
            this.signname = signname;
            this.datatype = datatype;
            this.bizdatatype = bizdatatype;
            this.defaultvalue = defaultvalue;
            this.srctype = srctype;
            this.formuladesc = formuladesc;
        }
    }

    private static class ResRegisParam {
        Long orgId;
        String defaultctrlstrategy;
        Long id;
        String pkId;
        String number;
        LocaleString name;
        String type;
        String businesstype;
        String businessentity;
        Long relativeresource;
        Long relativetransfer;
        Long outputmapping;
        String outputtype;
        Long outtosupply;
        List<ResRegisEntryParam> entryParams;
        List<ResDataConfigParam> resDataConfigParams;
        String appId;

        public ResRegisParam(Long orgId, String defaultctrlstrategy, Long id, String pkId, String number, LocaleString name, String type, String businesstype, String businessentity, Long relativeresource, Long relativetransfer, Long outputmapping, String outputtype, Long outtosupply, List<ResRegisEntryParam> entryParams, List<ResDataConfigParam> resDataConfigParams, String appId) {
            this.orgId = orgId;
            this.defaultctrlstrategy = defaultctrlstrategy;
            this.id = id;
            this.pkId = pkId;
            this.number = number;
            this.name = name;
            this.type = type;
            this.businesstype = businesstype;
            this.businessentity = businessentity;
            this.relativeresource = relativeresource;
            this.relativetransfer = relativetransfer;
            this.outputmapping = outputmapping;
            this.outputtype = outputtype;
            this.outtosupply = outtosupply;
            this.entryParams = entryParams;
            this.resDataConfigParams = resDataConfigParams;
            this.appId = appId;
        }
    }

    private static class TrsfEntryParam {
        Long entryId;
        int seq;
        String calculateexc_tag;
        String calculateexc;
        String calculatetext;
        String destfieldflag;
        LocaleString destfieldname;
        String destentityflag;
        String sourcefieldflag;
        LocaleString sourcefieldname;
        String sourceentityflag;
        String converttype;

        private TrsfEntryParam(Long entryId, int seq, String calculateexc_tag, String calculateexc, String calculatetext, String destfieldflag, LocaleString destfieldname, String destentityflag, String sourcefieldflag, LocaleString sourcefieldname, String sourceentityflag, String converttype) {
            this.entryId = entryId;
            this.seq = seq;
            this.calculateexc_tag = calculateexc_tag;
            this.calculateexc = calculateexc;
            this.calculatetext = calculatetext;
            this.destfieldflag = destfieldflag;
            this.destfieldname = destfieldname;
            this.destentityflag = destentityflag;
            this.sourcefieldflag = sourcefieldflag;
            this.sourcefieldname = sourcefieldname;
            this.sourceentityflag = sourceentityflag;
            this.converttype = converttype;
        }
    }

    private static class TrsfParam {
        Long orgId;
        String defaultctrlstrategy;
        Long id;
        String pkId;
        String number;
        LocaleString name;
        String srcbill;
        String destbill;
        String ismatchdim;
        String appId;
        List<TrsfEntryParam> entryParams;

        public TrsfParam(Long orgId, String defaultctrlstrategy, Long id, String pkId, String number, LocaleString name, String srcbill, String destbill, String ismatchdim, List<TrsfEntryParam> entryParams, String appId) {
            this.orgId = orgId;
            this.defaultctrlstrategy = defaultctrlstrategy;
            this.id = id;
            this.pkId = pkId;
            this.number = number;
            this.name = name;
            this.srcbill = srcbill;
            this.destbill = destbill;
            this.ismatchdim = ismatchdim;
            this.entryParams = entryParams;
            this.appId = appId;
        }
    }

    private static class CalcEntryParam {
        Long entryId;
        int seq;
        String runtype;
        Long bizplan;

        private CalcEntryParam(Long entryId, int seq, String runtype, Long bizplan) {
            this.entryId = entryId;
            this.seq = seq;
            this.runtype = runtype;
            this.bizplan = bizplan;
        }
    }

    private static class CalcParam {
        Long orgId;
        String defaultctrlstrategy;
        Long id;
        String pkId;
        String number;
        LocaleString name;
        List<CalcEntryParam> calcEntrys;
        String appId;

        private CalcParam(Long orgId, String defaultctrlstrategy, Long id, String pkId, String number, LocaleString name, List<CalcEntryParam> calcEntrys, String appId) {
            this.orgId = orgId;
            this.defaultctrlstrategy = defaultctrlstrategy;
            this.id = id;
            this.pkId = pkId;
            this.number = number;
            this.name = name;
            this.calcEntrys = calcEntrys;
            this.appId = appId;
        }
    }

    private static class BizEntryParam {
        Long entryId;
        int seq;
        Long algomodel;

        private BizEntryParam(Long entryId, int seq, Long algomodel) {
            this.entryId = entryId;
            this.seq = seq;
            this.algomodel = algomodel;
        }
    }

    private static class BizParam {
        Long orgId;
        String defaultctrlstrategy;
        Long id;
        String pkId;
        String number;
        LocaleString name;
        String cellsdata_tag;
        String xml_tag;
        List<BizEntryParam> bizEntrys;
        String appId;

        private BizParam(Long orgId, String defaultctrlstrategy, Long id, String pkId, String number, LocaleString name, String cellsdata_tag, String xml_tag, List<BizEntryParam> bizEntrys, String appId) {
            this.orgId = orgId;
            this.defaultctrlstrategy = defaultctrlstrategy;
            this.id = id;
            this.pkId = pkId;
            this.number = number;
            this.name = name;
            this.cellsdata_tag = cellsdata_tag;
            this.xml_tag = xml_tag;
            this.bizEntrys = bizEntrys;
            this.appId = appId;
        }
    }

    private static class AlgoParam {
        Long orgId;
        String defaultctrlstrategy;
        Long id;
        String pkId;
        String number;
        LocaleString name;
        String type;
        String classPath;
        String remark;
        String appId;

        private AlgoParam(Long orgId, String defaultctrlstrategy, Long id, String pkId, String number, LocaleString name, String type, String classPath, String appId) {
            this.orgId = orgId;
            this.defaultctrlstrategy = defaultctrlstrategy;
            this.id = id;
            this.pkId = pkId;
            this.number = number;
            this.name = name;
            this.type = type;
            this.classPath = classPath;
            this.appId = appId;
        }

        private AlgoParam(Long orgId, String defaultctrlstrategy, Long id, String pkId, String number, LocaleString name, String type, String classPath, String remark, String appId) {
            this.orgId = orgId;
            this.defaultctrlstrategy = defaultctrlstrategy;
            this.id = id;
            this.pkId = pkId;
            this.number = number;
            this.name = name;
            this.type = type;
            this.classPath = classPath;
            this.remark = remark;
            this.appId = appId;
        }
    }
}

