/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mps.formplugin.report;

import java.time.LocalDate;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAdjusters;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.MulBasedataDynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.redis.JedisClient;
import kd.bos.report.AbstractReportListModel;
import kd.bos.report.ReportList;
import kd.bos.report.ReportShowParameter;
import kd.bos.report.events.CellStyleRule;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.mmc.mps.common.util.MPSScheduleUtils;
import kd.mmc.mps.common.util.ReportQueryUtils;

public class CapacityScheduReportPlugin
extends AbstractReportFormPlugin
implements BeforeF7SelectListener,
RowClickEventListener,
HyperLinkClickListener {
    private static final String MPS_PROPLANSCHDEF = "mps_proplanschdef";

    public void initialize() {
        super.initialize();
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit workcenter = (BasedataEdit)this.getControl("workcenter");
        workcenter.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit datasources = (BasedataEdit)this.getControl("datasource");
        datasources.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit queryplan = (BasedataEdit)this.getControl("queryplan");
        queryplan.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit timeunit = (BasedataEdit)this.getControl("timeunit");
        timeunit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        ReportList reportList = (ReportList)this.getControl("reportlistap");
        reportList.addRowClickListener((RowClickEventListener)this);
        reportList.addHyperClickListener((HyperLinkClickListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        List hasPermOrg = MPSScheduleUtils.getHasPermOrg((String)"mps_capacityschedureport", (String)"mps");
        Set productOrg = MPSScheduleUtils.getProductOrg((List)hasPermOrg);
        Long orgId = 0L;
        if (productOrg.size() != 0) {
            long orgid = RequestContext.get().getOrgId();
            if (productOrg.contains(orgid)) {
                this.getModel().setValue("org", (Object)orgid);
                orgId = orgid;
            } else {
                this.getModel().setValue("org", productOrg.toArray()[0]);
                orgId = (Long)productOrg.toArray()[0];
            }
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u9875\u9762\u65e0\u6709\u6743\u9650\u7684\u7ec4\u7ec7\uff0c\u8bf7\u5148\u6388\u6743\u3002", (String)"scheduledataList_36", (String)"mmc-mps-formplugin", (Object[])new Object[0]));
            return;
        }
        DynamicObject planProgram = MPSScheduleUtils.getPlanProgram((Long)orgId);
        if (planProgram != null) {
            this.getModel().setValue("queryplan", (Object)planProgram.getLong("id"));
            if ("A".equals(planProgram.getString("capacalcway"))) {
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"timeunit"});
            }
        }
        Date firstDayOfMonth = MPSScheduleUtils.getFirstDayOfMonth((Date)new Date());
        Date lastDayOfMonth = MPSScheduleUtils.getLastDayOfMonth((Date)new Date());
        this.getModel().setValue("begindate", (Object)firstDayOfMonth);
        this.getModel().setValue("enddate", (Object)lastDayOfMonth);
    }

    public void afterQuery(ReportQueryParam queryParam) {
        JedisClient jedis;
        String error;
        super.afterQuery(queryParam);
        Object value = this.getModel().getValue("org");
        if (value != null) {
            DynamicObject planProgram = MPSScheduleUtils.getPlanProgram((Long)((DynamicObject)value).getLong("id"));
            if (planProgram == null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u5f53\u524d\u7ec4\u7ec7\u4e0b\u6240\u9009\u6392\u4ea7\u8ba1\u5212\u65b9\u6848\u4e0d\u53ef\u7528\u6216\u672a\u5ba1\u6838\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"CapacityScheduReportPlugin_10", (String)"mmc-mps-formplugin", (Object[])new Object[0]));
            }
            if ("A".equals(planProgram.getString("capacalcway"))) {
                return;
            }
        }
        if ((error = (jedis = MPSScheduleUtils.getJedis()).get("mpscalc-error-tip")) != null && !error.isEmpty()) {
            jedis.set("mpscalc-error-tip", "");
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u67e5\u8be2\u9519\u8bef\uff0c\u8bf7\u67e5\u770b\u8fd0\u7b97\u65e5\u5fd7\u3002", (String)"CapacityScheduReportQuery_16", (String)"mmc-mps-report", (Object[])new Object[0]));
            jedis.close();
        }
    }

    public void setCellStyleRules(List<CellStyleRule> cellStyleRules) {
        CellStyleRule cellStyleRule = new CellStyleRule();
        cellStyleRule.setFieldKey("morecapacity");
        cellStyleRule.setForeColor("#f90d58");
        cellStyleRule.setCondition("100 < morecapacity_num");
        cellStyleRules.add(cellStyleRule);
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String name = evt.getProperty().getName();
        if ("workcenter".equals(name)) {
            Object queryplan = this.getModel().getValue("queryplan");
            if (queryplan == null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u67e5\u8be2\u65b9\u6848\u3002", (String)"CapacityScheduReportPlugin_1", (String)"mmc-mps-formplugin", (Object[])new Object[0]));
            }
            ArrayList<Long> workcenter = new ArrayList<Long>(8);
            this.getWorkcenterList(workcenter, (DynamicObject)queryplan);
            ListShowParameter parameter = (ListShowParameter)evt.getFormShowParameter();
            QFilter filter = new QFilter("id", "in", workcenter);
            parameter.getListFilterParameter().getQFilters().add(filter);
        } else if ("datasource".equals(name)) {
            Object queryplan = this.getModel().getValue("queryplan");
            if (queryplan == null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u67e5\u8be2\u65b9\u6848\u3002", (String)"CapacityScheduReportPlugin_1", (String)"mmc-mps-formplugin", (Object[])new Object[0]));
            }
            Set<Long> orderModelId = this.getOrderModelId((DynamicObject)queryplan);
            ListShowParameter parameter = (ListShowParameter)evt.getFormShowParameter();
            QFilter filter = new QFilter("id", "in", orderModelId);
            parameter.getListFilterParameter().getQFilters().add(filter);
        } else if ("queryplan".equals(name)) {
            Object org = this.getModel().getValue("org");
            if (org == null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u7ec4\u7ec7\u3002", (String)"CapacityScheduReportPlugin_6", (String)"mmc-mps-formplugin", (Object[])new Object[0]));
            }
            Long id = ((DynamicObject)org).getLong("id");
            ListShowParameter parameter = (ListShowParameter)evt.getFormShowParameter();
            QFilter mps_proplanschdef = BaseDataServiceHelper.getBaseDataFilter((String)MPS_PROPLANSCHDEF, (Long)id);
            parameter.getListFilterParameter().getQFilters().add(mps_proplanschdef);
        } else if ("timeunit".equals(name)) {
            List timeunitValue = ReportQueryUtils.getTimeunitValue();
            ListShowParameter parameter = (ListShowParameter)evt.getFormShowParameter();
            QFilter qFilter = new QFilter("id", "in", (Object)timeunitValue);
            parameter.getListFilterParameter().getQFilters().add(qFilter);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        ChangeData[] changeSet = e.getChangeSet();
        if ("org".equals(name)) {
            Object newValue = changeSet[0].getNewValue();
            if (newValue != null) {
                this.getModel().setValue("workcenter", null);
                this.getModel().setValue("datasource", null);
                this.getModel().setValue("actresource_query", null);
                Long orgId = ((DynamicObject)newValue).getLong("id");
                DynamicObject planProgram = MPSScheduleUtils.getPlanProgram((Long)orgId);
                if (planProgram != null) {
                    this.getModel().setValue("queryplan", (Object)planProgram.getLong("id"));
                } else {
                    this.getModel().setValue("queryplan", null);
                }
            }
        } else if ("queryplan".equals(name)) {
            this.getModel().setValue("workcenter", null);
            this.getModel().setValue("datasource", null);
            this.getModel().setValue("actresource_query", null);
            DynamicObject queryplan = (DynamicObject)this.getModel().getValue("queryplan");
            if (queryplan == null) {
                return;
            }
            if ("A".equals(queryplan.getString("capacalcway"))) {
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"timeunit"});
            } else {
                this.getView().setVisible(Boolean.valueOf(true), new String[]{"timeunit"});
            }
        }
    }

    public void beforeQuery(ReportQueryParam queryParam) {
        super.beforeQuery(queryParam);
        FilterInfo filterInfo = queryParam.getFilter();
        DynamicObject org = filterInfo.getDynamicObject("org");
        DynamicObject queryplan = filterInfo.getDynamicObject("queryplan");
        Date filterEndDate = filterInfo.getDate("enddate");
        Date filterbeginDate = filterInfo.getDate("begindate");
        DynamicObject timeunit = filterInfo.getDynamicObject("timeunit");
        List<String> errorInfo = this.checkData(org, queryplan, filterbeginDate, filterEndDate, timeunit);
        if (errorInfo.size() != 0) {
            throw new KDBizException(errorInfo.get(0));
        }
    }

    private List<String> checkData(DynamicObject org, DynamicObject queryplan, Date filterbeginDate, Date filterEndDate, DynamicObject timeunit) {
        ArrayList<String> errorInfo = new ArrayList<String>(8);
        if (org == null) {
            errorInfo.add(ResManager.loadKDString((String)"\u7ec4\u7ec7\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"CapacityScheduReportPlugin_2", (String)"mmc-mps-formplugin", (Object[])new Object[0]));
            return errorInfo;
        }
        if (queryplan == null) {
            errorInfo.add(ResManager.loadKDString((String)"\u67e5\u8be2\u65b9\u6848\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"CapacityScheduReportPlugin_3", (String)"mmc-mps-formplugin", (Object[])new Object[0]));
            return errorInfo;
        }
        if (filterbeginDate == null || filterEndDate == null) {
            errorInfo.add(ResManager.loadKDString((String)"\u65e5\u671f\u8303\u56f4\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"CapacityScheduReportPlugin_4", (String)"mmc-mps-formplugin", (Object[])new Object[0]));
            return errorInfo;
        }
        if (timeunit == null) {
            errorInfo.add(ResManager.loadKDString((String)"\u8ba1\u91cf\u5355\u4f4d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"CapacityScheduReportPlugin_9", (String)"mmc-mps-formplugin", (Object[])new Object[0]));
            return errorInfo;
        }
        return errorInfo;
    }

    public void hyperLinkClick(HyperLinkClickEvent evt) {
        int row = evt.getRowIndex();
        ReportList reportList = (ReportList)evt.getSource();
        this.openDetailPage(row, reportList);
    }

    public void entryRowDoubleClick(RowClickEvent evt) {
        int row = evt.getRow();
        ReportList reportList = (ReportList)evt.getSource();
        this.openDetailPage(row, reportList);
    }

    private void openDetailPage(int row, ReportList reportList) {
        AbstractReportListModel reportModel = (AbstractReportListModel)reportList.getReportModel();
        DynamicObject dyn = reportModel.getRowData(row);
        String year = dyn.getString("year");
        String value = dyn.getString("cycle_s");
        String cycle = dyn.getString("cycle_r");
        ArrayList<Date> rangList = new ArrayList<Date>(8);
        if (value != null && !value.isEmpty()) {
            if ("mon".equals(cycle)) {
                this.getMonDate(year, value, rangList);
            } else if ("wek".equals(cycle)) {
                this.calcWeekDate(year, Integer.parseInt(value), rangList);
            } else if ("qua".equals(cycle)) {
                String star = this.getQuaMon(value, "star");
                String end = this.getQuaMon(value, "end");
                this.calcQuaDate(year, star, end, rangList);
            } else {
                this.getDay(year, value, rangList);
            }
        }
        this.showDetailPage(rangList, dyn);
    }

    private String getQuaMon(String value, String sign) {
        if ("1".equals(value)) {
            if ("star".equals(sign)) {
                return "1";
            }
            return "3";
        }
        if ("2".equals(value)) {
            if ("star".equals(sign)) {
                return "4";
            }
            return "6";
        }
        if ("3".equals(value)) {
            if ("star".equals(sign)) {
                return "7";
            }
            return "9";
        }
        if ("4".equals(value)) {
            if ("star".equals(sign)) {
                return "10";
            }
            return "12";
        }
        return "1";
    }

    private void getDay(String year, String value, List<Date> rangList) {
        if (value.contains("/")) {
            String[] split = value.split("/");
            Calendar calendar = Calendar.getInstance();
            calendar.set(1, Integer.parseInt(year));
            calendar.set(2, Integer.parseInt(split[0]) - 1);
            calendar.set(5, Integer.parseInt(split[1]));
            calendar.set(11, 0);
            calendar.set(12, 0);
            calendar.set(13, 0);
            calendar.set(14, 0);
            rangList.add(calendar.getTime());
            rangList.add(calendar.getTime());
        }
    }

    private void getMonDate(String year, String mons, List<Date> rangList) {
        int mon = Integer.parseInt(mons);
        String date = year + mon;
        if (mon < 10) {
            date = year + "0" + mon;
        }
        LocalDate localDate = LocalDate.parse(date + "01", DateTimeFormatter.BASIC_ISO_DATE);
        LocalDate with_begin = localDate.with(TemporalAdjusters.firstDayOfMonth());
        LocalDate with_end = localDate.with(TemporalAdjusters.lastDayOfMonth());
        Date from = Date.from(with_begin.atStartOfDay().atZone(ZoneId.systemDefault()).toInstant());
        Date to = Date.from(with_end.atStartOfDay().atZone(ZoneId.systemDefault()).toInstant());
        rangList.add(from);
        rangList.add(to);
    }

    private void calcWeekDate(String year, int week, List<Date> rangList) {
        Calendar calendar = Calendar.getInstance();
        calendar.set(1, Integer.parseInt(year));
        calendar.set(3, week - 1);
        calendar.set(7, 1);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        Date begintime = calendar.getTime();
        rangList.add(begintime);
        calendar.set(7, 7);
        Date endDate = calendar.getTime();
        rangList.add(endDate);
    }

    private void calcQuaDate(String year, String firstMon, String endMon, List<Date> rangList) {
        int beginMon = Integer.parseInt(firstMon);
        String date_begin = year + beginMon;
        if (beginMon < 10) {
            date_begin = year + "0" + beginMon;
        }
        int lastMon = Integer.parseInt(endMon);
        String date_end = year + lastMon;
        if (lastMon < 10) {
            date_end = year + "0" + lastMon;
        }
        LocalDate localDate = LocalDate.parse(date_begin + "01", DateTimeFormatter.BASIC_ISO_DATE);
        LocalDate with_begin = localDate.with(TemporalAdjusters.firstDayOfMonth());
        LocalDate localDate_end = LocalDate.parse(date_end + "01", DateTimeFormatter.BASIC_ISO_DATE);
        LocalDate with_end = localDate_end.with(TemporalAdjusters.lastDayOfMonth());
        Date from = Date.from(with_begin.atStartOfDay().atZone(ZoneId.systemDefault()).toInstant());
        Date to = Date.from(with_end.atStartOfDay().atZone(ZoneId.systemDefault()).toInstant());
        rangList.add(from);
        rangList.add(to);
    }

    private void showDetailPage(List<Date> rangList, DynamicObject dyn) {
        DynamicObject workcenter_r;
        ReportShowParameter parameter = new ReportShowParameter();
        ReportQueryParam param = new ReportQueryParam();
        parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        Boolean workcentertotal = (Boolean)this.getModel().getValue("workcentertotal");
        param.getFilter().addFilterItem("org", this.getModel().getValue("org"));
        param.getFilter().addFilterItem("queryplan", this.getModel().getValue("queryplan"));
        if (rangList == null || rangList.size() == 0) {
            param.getFilter().addFilterItem("begindate", this.getModel().getValue("begindate"));
            param.getFilter().addFilterItem("enddate", this.getModel().getValue("enddate"));
        } else {
            param.getFilter().addFilterItem("begindate", (Object)rangList.get(0));
            param.getFilter().addFilterItem("enddate", (Object)rangList.get(1));
        }
        Object queryplan_O = this.getModel().getValue("queryplan");
        DynamicObject queryplan = null;
        if (queryplan_O == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u67e5\u8be2\u65b9\u6848\u4e3a\u7a7a\u3002", (String)"scheduledataList_32", (String)"mmc-mps-formplugin", (Object[])new Object[0]));
        }
        queryplan = (DynamicObject)queryplan_O;
        HashMap<String, Long> custom = new HashMap<String, Long>(16);
        String capacalcway = queryplan.getString("capacalcway");
        if (capacalcway.isEmpty()) {
            capacalcway = "A";
        }
        if ((workcenter_r = dyn.getDynamicObject("workcenter_r")) == null) {
            param.getFilter().addFilterItem("workcenter", this.getModel().getValue("workcenter"));
            if (!"A".equals(capacalcway)) {
                custom.put("workcenter", 0L);
            }
        } else {
            MulBasedataDynamicObjectCollection mulBasedataDynamicObjectCollection = new MulBasedataDynamicObjectCollection();
            mulBasedataDynamicObjectCollection.add(dyn.getDynamicObject("workcenter_r"));
            param.getFilter().addFilterItem("workcenter", (Object)mulBasedataDynamicObjectCollection);
        }
        param.getFilter().addFilterItem("timeunit", this.getModel().getValue("timeunit"));
        param.getFilter().addFilterItem("cycle", this.getModel().getValue("cycle"));
        param.getFilter().addFilterItem("datasource", this.getModel().getValue("datasource"));
        DynamicObject actresource = dyn.getDynamicObject("actresource");
        if (actresource == null) {
            if (!workcentertotal.booleanValue()) {
                custom.put("actresource", 0L);
            }
        } else {
            MulBasedataDynamicObjectCollection mulBasedataDynamicObjectCollection = new MulBasedataDynamicObjectCollection();
            mulBasedataDynamicObjectCollection.add(dyn.getDynamicObject("actresource"));
            param.getFilter().addFilterItem("actresource_query", (Object)mulBasedataDynamicObjectCollection);
        }
        parameter.setCustomParams(custom);
        parameter.setQueryParam(param);
        parameter.setFormId("mps_capacityschedudetail");
        this.getView().showForm((FormShowParameter)parameter);
    }

    public Set<Long> getOrderModelId(DynamicObject queryplan) {
        DynamicObjectCollection dataEntryColl;
        DynamicObject plan = BusinessDataServiceHelper.loadSingle((Object)queryplan.getLong("id"), (String)MPS_PROPLANSCHDEF);
        DynamicObjectCollection orderEntryColl = plan.getDynamicObjectCollection("order_entryentity");
        HashSet<Long> idSet = new HashSet<Long>(orderEntryColl.size());
        if (orderEntryColl != null && !orderEntryColl.isEmpty()) {
            for (DynamicObject order : orderEntryColl) {
                boolean isCalculate = false;
                if (order.get("isincalculate") != null) {
                    isCalculate = order.getBoolean("isincalculate");
                }
                if (!isCalculate || order.get("resourceconfig") == null) continue;
                idSet.add(order.getLong("resourceconfig_id"));
            }
        }
        if ((dataEntryColl = plan.getDynamicObjectCollection("data_entryentity")) != null && !dataEntryColl.isEmpty()) {
            for (DynamicObject order : dataEntryColl) {
                boolean isCalculate = false;
                if (order.get("dataisincalculate") != null) {
                    isCalculate = order.getBoolean("dataisincalculate");
                }
                if (!isCalculate || order.get("dataresourceconfig") == null) continue;
                idSet.add(order.getLong("dataresourceconfig_id"));
            }
        }
        return idSet;
    }

    private void getWorkcenterList(List<Long> workcenter, DynamicObject queryplan) {
        DynamicObjectCollection query = QueryServiceHelper.query((String)MPS_PROPLANSCHDEF, (String)"id,workentry.workcenter", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)queryplan.getLong("id"))});
        for (DynamicObject dynamicObject : query) {
            workcenter.add(dynamicObject.getLong("workentry.workcenter"));
        }
    }
}

