/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mps.formplugin.schedule;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.api.ApiResult;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.entity.validate.ValidateResult;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.impt.BatchImportPlugin;
import kd.bos.form.plugin.impt.ImportBillData;
import kd.bos.form.plugin.impt.ImportEntityMapping;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;

public class MpsScheduleImportPlugin
extends BatchImportPlugin {
    protected void beforeSave(List<ImportBillData> billdatas, ImportLogger logger) {
        super.beforeSave(billdatas, logger);
        if (billdatas.isEmpty()) {
            return;
        }
        ImportEntityMapping mapping = billdatas.get(0).getEntityMapping();
        Map colInfoMap = mapping.getCols();
        ImportEntityMapping.ColInfo sourType = (ImportEntityMapping.ColInfo)colInfoMap.get("sourcebilltypeid");
        ImportEntityMapping.ColInfo soutNo = (ImportEntityMapping.ColInfo)colInfoMap.get("sourcebillno");
        Iterator<ImportBillData> it = billdatas.iterator();
        while (it.hasNext()) {
            ImportBillData billdata = it.next();
            JSONObject data = billdata.getData();
            String billNo = data.getString("billno");
            if (this.isUpdate() && StringUtils.isNotEmpty((CharSequence)billNo)) {
                this.addUnUpdateField(data);
                continue;
            }
            this.validateSourceData(sourType, soutNo, data, logger, it);
        }
    }

    private void validateSourceData(ImportEntityMapping.ColInfo sourType, ImportEntityMapping.ColInfo soutNo, JSONObject data, ImportLogger logger, Iterator<ImportBillData> it) {
        Integer rowNum = data.getInteger("rowNum");
        boolean error = false;
        if (sourType == null || !"number".equals(sourType.getBasedataProp()) || !sourType.isMustInput() && data.get((Object)"sourcebilltypeid") == null) {
            logger.log(rowNum, ResManager.loadKDString((String)"\u6570\u636e\u884c\u6216\u8005\u5206\u5f55\u884c\u5b58\u5728\u5fc5\u5f55\u9879\u672a\u5f55\u5165\uff1a\u6765\u6e90\u5355\u636e\u7c7b\u578b.\u7f16\u7801\u3002", (String)"MpsScheduleImportPlugin_0", (String)"mmc-mps-formplugin", (Object[])new Object[0]));
            error = true;
        }
        if (soutNo == null || !soutNo.isMustInput() && data.get((Object)"sourcebillno") == null) {
            logger.log(rowNum, ResManager.loadKDString((String)"\u6570\u636e\u884c\u6216\u8005\u5206\u5f55\u884c\u5b58\u5728\u5fc5\u5f55\u9879\u672a\u5f55\u5165\uff1a\u6765\u6e90\u5355\u636e\u7f16\u53f7\u3002", (String)"MpsScheduleImportPlugin_1", (String)"mmc-mps-formplugin", (Object[])new Object[0]));
            error = true;
        }
        if (error) {
            logger.fail();
            it.remove();
        }
    }

    private void addUnUpdateField(JSONObject data) {
        Set<String> fields = this.getUnUpdateField();
        for (String field : fields) {
            Object obj = data.get((Object)field);
            if (obj != null) continue;
            data.put(field, (Object)"test");
        }
    }

    private void removeUnUpdateField(JSONObject data) {
        Set<String> fields = this.getUnUpdateField();
        for (String field : fields) {
            data.remove((Object)field);
        }
    }

    protected ApiResult save(List<ImportBillData> rowdatas, ImportLogger logger) {
        if (this.isUpdate()) {
            ArrayList<String> updateBillNos = new ArrayList<String>(rowdatas.size());
            for (ImportBillData billdata : rowdatas) {
                JSONObject data = billdata.getData();
                String billNo = data.getString("billno");
                if (StringUtils.isEmpty((CharSequence)billNo)) continue;
                updateBillNos.add(billNo);
                this.removeUnUpdateField(data);
            }
            this.dealAuditPls(updateBillNos, rowdatas, logger);
        }
        return super.save(rowdatas, logger);
    }

    private void dealAuditPls(List<String> updateBillNos, List<ImportBillData> rowdatas, ImportLogger logger) {
        if (CollectionUtils.isEmpty(updateBillNos)) {
            return;
        }
        Map<Long, String> pls = this.queryPlsPks(updateBillNos);
        if (pls.isEmpty()) {
            return;
        }
        OperationResult result = OperationServiceHelper.executeOperate((String)"unaudit", (String)"mps_scheduleplan", (Object[])pls.keySet().toArray(new Object[0]), (OperateOption)OperateOption.create());
        if (result.isSuccess()) {
            return;
        }
        HashMap<String, String> errorNo = new HashMap<String, String>(result.getValidateResult().errorSize());
        for (ValidateResult validateError : result.getValidateResult().getValidateErrors()) {
            OperateErrorInfo errorInfo;
            Long pk;
            String no;
            List errorInfos = validateError.getAllErrorInfo();
            if (CollectionUtils.isEmpty((Collection)errorInfos) || (no = pls.get(pk = (Long)(errorInfo = (OperateErrorInfo)errorInfos.get(0)).getPkValue())) == null) continue;
            errorNo.put(no, errorInfo.getMessage());
        }
        Iterator<ImportBillData> it = rowdatas.iterator();
        while (it.hasNext()) {
            String errMsg;
            ImportBillData rowdata = it.next();
            JSONObject data = rowdata.getData();
            String billNo = data.getString("billno");
            if (StringUtils.isEmpty((CharSequence)billNo) || (errMsg = (String)errorNo.get(billNo)) == null) continue;
            it.remove();
            logger.log(data.getInteger("rowNum"), String.format(ResManager.loadKDString((String)"\u64a4\u9500\u5931\u8d25:%1$s", (String)"MpsScheduleImportPlugin_17", (String)"mmc-mps-formplugin", (Object[])new Object[0]), errMsg)).fail();
        }
    }

    private Map<Long, String> queryPlsPks(List<String> updateBillNos) {
        QFilter qFilter = new QFilter("billstatus", "=", (Object)"C");
        qFilter.and("lock", "=", (Object)"0");
        qFilter.and("cancel", "=", (Object)"0");
        qFilter.and("billno", "in", updateBillNos);
        HashMap<Long, String> plsPks = new HashMap<Long, String>(updateBillNos.size());
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"queryPlsPks", (String)"mps_scheduleplan", (String)"id,billno", (QFilter[])qFilter.toArray(), null);){
            for (Row row : ds) {
                plsPks.put(row.getLong(0), row.getString(1));
            }
        }
        return plsPks;
    }

    public List<ComboItem> getOverrideFieldsConfig() {
        List items = super.getOverrideFieldsConfig();
        return items.stream().filter(i -> StringUtils.equals((CharSequence)"billno", (CharSequence)i.getValue())).collect(Collectors.toList());
    }

    private boolean isUpdate() {
        String type = (String)this.ctx.getOption().get("importtype");
        return type.contains("override");
    }

    private Set<String> getUnUpdateField() {
        HashSet<String> fields = new HashSet<String>();
        fields.add("org");
        fields.add("materiel");
        fields.add("configuredcode");
        fields.add("tracknumber");
        fields.add("orderqty");
        fields.add("sourcebilltypeid");
        fields.add("sourcebillno");
        fields.add("sourceentryseq");
        return fields;
    }
}

