/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mps.formplugin.schedule;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.KDBizException;
import kd.bos.form.control.Control;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.fs.util.StringUtils;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.mmc.mps.business.helper.OperateLogHelper;
import kd.mmc.mps.common.util.MPSScheduleUtils;
import kd.mmc.mps.common.util.WorkcentreUtils;

public class MpsSchedulePlanChangePlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    private static final Log logger = LogFactory.getLog(MpsSchedulePlanChangePlugin.class);
    private static final String CHANGE = "change";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit changecentre = (BasedataEdit)this.getControl("changecentre");
        changecentre.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        Long org = Long.parseLong((String)this.getView().getFormShowParameter().getCustomParam("org"));
        Long workCentre = Long.parseLong((String)this.getView().getFormShowParameter().getCustomParam("workcentre"));
        this.getModel().setValue("workcentre", (Object)workCentre);
        this.getModel().setValue("org", (Object)org);
        this.getView().updateView("workcentre");
        this.getView().updateView("org");
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate op = (FormOperate)args.getSource();
        String key = op.getOperateKey();
        if (CHANGE.equals(key)) {
            logger.info("mmc-MPSSchedulePlanChange begin from change operation");
            ArrayList fieldsMapList = new ArrayList(16);
            String jsonStr = (String)this.getView().getFormShowParameter().getCustomParam("data");
            List idList = SerializationUtils.fromJsonStringToList((String)jsonStr, Long.class);
            DynamicObject changeWorkCentre = null;
            if (this.getModel().getValue("changecentre") != null) {
                changeWorkCentre = (DynamicObject)this.getModel().getValue("changecentre");
            }
            Date changeDate = null;
            if (this.getModel().getValue("changedate") != null) {
                changeDate = (Date)this.getModel().getValue("changedate");
            }
            if (changeWorkCentre == null && changeDate == null) {
                throw new KDBizException(ResManager.loadKDString((String)"\u53d8\u66f4\u5de5\u4f5c\u4e2d\u5fc3\u548c\u6392\u4ea7\u65e5\u671f\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a\u3002", (String)"MpsSchedulePlanListPlugin_23", (String)"mmc-mps-formplugin", (Object[])new Object[0]));
            }
            Set manuentryids = new HashSet(idList.size());
            Object manuentryidObj = this.getView().getFormShowParameter().getCustomParam("manuentryid");
            if (manuentryidObj != null) {
                manuentryids = (Set)SerializationUtils.deSerializeFromBase64((String)manuentryidObj.toString());
            }
            if (changeWorkCentre != null || changeDate != null) {
                ArrayList<DynamicObject> canChangeObjs = new ArrayList<DynamicObject>(16);
                DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)"mps_scheduleplan", (String)"id, org, billno, workcentre, sheduledate,totalworkcenter,entryentity,entryentity.sequence,entryentity.serialno,entryentity.ontime,entryentity.instocktime,productionid,scheduleqty,putinqty,entryentity.seq", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)idList)});
                long workCentreId = 0L;
                if (changeWorkCentre != null) {
                    workCentreId = changeWorkCentre.getLong("id");
                }
                HashMap orderEntryIdAndChangeInfo = new HashMap(16);
                HashMap<String, Object> innerMap = new HashMap<String, Object>(16);
                ArrayList<Date> dateList = new ArrayList<Date>(8);
                if (changeDate != null) {
                    dateList.add(changeDate);
                }
                Map orgWorkcenter = WorkcentreUtils.getOrgWorkcenter();
                for (DynamicObject dynamicObject : dynamicObjects) {
                    Boolean isSame = false;
                    long orgId = dynamicObject.getDynamicObject("org").getLong("id");
                    Long workcenterId_exsit = dynamicObject.getDynamicObject("workcentre").getLong("id");
                    Date scheduDate_exsit = dynamicObject.getDate("sheduledate");
                    if (workCentreId != 0L) {
                        Long totalWorkcenter = WorkcentreUtils.getTotalWorkcenter((Map)orgWorkcenter, (Long)workCentreId, (Long)orgId);
                        dynamicObject.set("workcentre", (Object)workCentreId);
                        dynamicObject.set("totalworkcenter", (Object)workCentreId);
                        innerMap.put("workcenter", changeWorkCentre);
                        if (totalWorkcenter != null) {
                            dynamicObject.set("totalworkcenter", (Object)totalWorkcenter);
                            DynamicObject workCenter = WorkcentreUtils.getWorkCenter((Long)totalWorkcenter);
                            if (workCenter != null) {
                                innerMap.put("workcenter", workCenter);
                            }
                        }
                        if (workcenterId_exsit.equals(workCentreId)) {
                            isSame = true;
                        }
                    } else {
                        isSame = true;
                    }
                    if (changeDate != null) {
                        dynamicObject.set("sheduledate", (Object)changeDate);
                        if (manuentryids != null && manuentryids.size() != 0) {
                            innerMap.put("planbegintime", changeDate);
                        }
                        isSame = isSame != false && changeDate.compareTo(scheduDate_exsit) == 0 ? Boolean.valueOf(true) : Boolean.valueOf(false);
                    }
                    if (!isSame.booleanValue()) {
                        canChangeObjs.add(dynamicObject);
                    }
                    if (manuentryids == null || manuentryids.size() == 0) continue;
                    for (Long manuentryid : manuentryids) {
                        if (orderEntryIdAndChangeInfo.containsKey(manuentryid)) continue;
                        orderEntryIdAndChangeInfo.put(manuentryid, innerMap);
                    }
                }
                HashSet<Long> failedSet = new HashSet<Long>(16);
                StringBuilder message_orderChange = new StringBuilder();
                if (orderEntryIdAndChangeInfo.size() > 0) {
                    long l = System.currentTimeMillis();
                    logger.info("mmc-MPSSchedulePlanChange begin invok IMftOrderService-xOrderByOrderEntryIdNew");
                    Map orderChangeResults = (Map)DispatchServiceHelper.invokeBizService((String)"bd", (String)"mpdm", (String)"IMftOrderService", (String)"xOrderByOrderEntryIdNew", (Object[])new Object[]{orderEntryIdAndChangeInfo, "pom_mftorder"});
                    logger.info("mmc-MPSSchedulePlanChange end invok IMftOrderService-xOrderByOrderEntryIdNew,cost " + (System.currentTimeMillis() - l) + "ms");
                    for (Map.Entry mapEntry : orderChangeResults.entrySet()) {
                        DynamicObject[] orderChangeFails;
                        Map orderChangeResult;
                        String ChangeResult;
                        Long orderEntryID = (Long)mapEntry.getKey();
                        if (!manuentryids.contains(orderEntryID) || "true".equals(ChangeResult = (orderChangeResult = (Map)mapEntry.getValue()).get("success") == null ? null : (orderChangeResult.get("success") instanceof String ? (String)orderChangeResult.get("success") : null))) continue;
                        for (DynamicObject orderChangeFail : orderChangeFails = BusinessDataServiceHelper.load((String)"mps_scheduleplan", (String)"id, org, workcentre, sheduledate", (QFilter[])new QFilter[]{new QFilter("downstreamentryid", "in", (Object)orderEntryID)})) {
                            failedSet.add(orderChangeFail.getLong("id"));
                        }
                        String message_orderChangeStr = orderChangeResult.get("message") == null ? null : (orderChangeResult.get("message") instanceof String ? (String)orderChangeResult.get("message") : null);
                        if (message_orderChangeStr == null || StringUtils.isEmpty(message_orderChangeStr)) continue;
                        message_orderChange.append(message_orderChangeStr);
                    }
                }
                Iterator changeIterator = canChangeObjs.iterator();
                ArrayList<Long> successIds = new ArrayList<Long>(16);
                while (changeIterator.hasNext()) {
                    DynamicObject changeObj = (DynamicObject)changeIterator.next();
                    Long id = changeObj.getLong("id");
                    if (failedSet.contains(id)) {
                        changeIterator.remove();
                        continue;
                    }
                    successIds.add(id);
                }
                if (!canChangeObjs.isEmpty()) {
                    long begintime = System.currentTimeMillis();
                    logger.info("mmc-MPSSchedulePlanChange begin update mps_scheduleplan");
                    for (DynamicObject dynamicObject : canChangeObjs) {
                        DynamicObjectCollection entryentitys = dynamicObject.getDynamicObjectCollection("entryentity");
                        if (entryentitys == null) continue;
                        entryentitys.clear();
                    }
                    Object[] save = SaveServiceHelper.save((DynamicObject[])canChangeObjs.toArray(new DynamicObject[0]));
                    if (save != null && save.length != 0) {
                        MainEntityType planorderType = EntityMetadataCache.getDataEntityType((String)"mps_scheduleplan");
                        DynamicObject[] scheduleplans = BusinessDataServiceHelper.load((Object[])successIds.toArray(), (DynamicObjectType)planorderType);
                        Map maxLevelSequence = MPSScheduleUtils.getMaxLevelSequence((DynamicObject[])scheduleplans, new ArrayList(8), null, null);
                        MPSScheduleUtils.setMaxSeqNoByExitEntry((Map)maxLevelSequence, (DynamicObject[])scheduleplans, (boolean)true, null, null);
                        SaveServiceHelper.save((DynamicObject[])scheduleplans);
                        MPSScheduleUtils.writeOrderPool((DynamicObject[])scheduleplans, (String)"submit", null);
                    }
                    long endtime1 = System.currentTimeMillis();
                    logger.info("mmc-MPSSchedulePlanChange end update mps_scheduleplan,cost " + (endtime1 - begintime) + "ms");
                    SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
                    for (DynamicObject changeObj : canChangeObjs) {
                        String number;
                        HashMap<String, Object> logMap = new HashMap<String, Object>(16);
                        StringBuilder info = new StringBuilder();
                        if (changeDate != null && changeWorkCentre != null) {
                            number = changeWorkCentre.getString("number");
                            info.append(ResManager.loadKDString((String)"\u6392\u4ea7\u8ba1\u5212\u5355\uff1a", (String)"MpsSchedulePlanSplitValidator_6", (String)"mmc-mps-opplugin", (Object[])new Object[0])).append(changeObj.getString("billno")).append(ResManager.loadKDString((String)"\u53d8\u66f4\u6210\u529f,", (String)"MpsSchedulePlanChangePlugin_2", (String)"mmc-mps-formplugin", (Object[])new Object[0])).append(ResManager.loadKDString((String)"\u53d8\u66f4\u65e5\u671f\u5230:", (String)"MpsSchedulePlanChangePlugin_5", (String)"mmc-mps-formplugin", (Object[])new Object[0])).append(simpleDateFormat.format(changeDate)).append(ResManager.loadKDString((String)"\u53d8\u66f4\u5de5\u4f5c\u4e2d\u5fc3\u4e3a:", (String)"MpsSchedulePlanChangePlugin_6", (String)"mmc-mps-formplugin", (Object[])new Object[0])).append(number);
                        } else {
                            if (changeDate != null) {
                                info.append(ResManager.loadKDString((String)"\u6392\u4ea7\u8ba1\u5212\u5355\uff1a", (String)"MpsSchedulePlanSplitValidator_6", (String)"mmc-mps-opplugin", (Object[])new Object[0])).append(changeObj.getString("billno")).append(ResManager.loadKDString((String)"\u53d8\u66f4\u6210\u529f,", (String)"MpsSchedulePlanChangePlugin_2", (String)"mmc-mps-formplugin", (Object[])new Object[0])).append(ResManager.loadKDString((String)"\u53d8\u66f4\u65e5\u671f\u5230:", (String)"MpsSchedulePlanChangePlugin_5", (String)"mmc-mps-formplugin", (Object[])new Object[0])).append(simpleDateFormat.format(changeDate));
                            }
                            if (changeWorkCentre != null) {
                                number = changeWorkCentre.getString("number");
                                info.append(ResManager.loadKDString((String)"\u6392\u4ea7\u8ba1\u5212\u5355\uff1a", (String)"MpsSchedulePlanSplitValidator_6", (String)"mmc-mps-opplugin", (Object[])new Object[0])).append(changeObj.getString("billno")).append(ResManager.loadKDString((String)"\u53d8\u66f4\u6210\u529f,", (String)"MpsSchedulePlanChangePlugin_2", (String)"mmc-mps-formplugin", (Object[])new Object[0])).append(ResManager.loadKDString((String)"\u53d8\u66f4\u5de5\u4f5c\u4e2d\u5fc3\u4e3a:", (String)"MpsSchedulePlanChangePlugin_6", (String)"mmc-mps-formplugin", (Object[])new Object[0])).append(number);
                            }
                        }
                        logMap.put("createorg", changeObj.getLong("org_id"));
                        logMap.put("operateentity", "mps_scheduleplan");
                        logMap.put("operatenum", CHANGE);
                        logMap.put("operatename", ResManager.loadKDString((String)"\u53d8\u66f4", (String)"MpsSchedulePlanChangePlugin_3", (String)"mmc-mps-formplugin", (Object[])new Object[0]));
                        logMap.put("operatedesc", info.toString());
                        logMap.put("opentityid", changeObj.getLong("id"));
                        fieldsMapList.add(logMap);
                    }
                    OperateLogHelper.genOperateLog(fieldsMapList);
                    logger.info("mmc-MPSSchedulePlanChange genOperateLog cost " + (System.currentTimeMillis() - endtime1) + "ms");
                }
                if (message_orderChange.length() > 0) {
                    this.getView().showMessage(message_orderChange.toString());
                    args.setCancel(true);
                    this.getView().close();
                }
            }
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String key = ((Control)e.getSource()).getKey();
        if ("changecentre".equals(key)) {
            long orgid = ((DynamicObject)this.getModel().getValue("org")).getLong("id");
            QFilter mpdm_workcentre = BaseDataServiceHelper.getBaseDataFilter((String)"mpdm_workcentre", (Long)orgid);
            ListShowParameter formShowParameter = (ListShowParameter)e.getFormShowParameter();
            formShowParameter.getListFilterParameter().getQFilters().add(mpdm_workcentre);
        }
    }
}

