/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mps.formplugin.schedule;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.mmc.mps.common.util.MPSScheduleUtils;
import kd.mmc.mps.common.util.WorkcentreUtils;

public class MpsSchedulePlanEditPlugin
extends AbstractFormPlugin {
    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.hideCancelFlex();
        this.sortData();
    }

    private void sortData() {
        String status = this.getView().getFormShowParameter().getStatus().name();
        if (!status.equals("ADDNEW")) {
            DynamicObjectCollection entry = this.getModel().getEntryEntity("entryentity");
            for (int i = 0; i < entry.size() - 1; ++i) {
                for (int j = 0; j < entry.size() - 1 - i; ++j) {
                    int seq_nextrow;
                    int seq = ((DynamicObject)entry.get(j)).getInt("sequence");
                    if (seq <= (seq_nextrow = ((DynamicObject)entry.get(j + 1)).getInt("sequence"))) continue;
                    this.getModel().moveEntryRowDown("entryentity", j);
                }
            }
            this.getView().updateView("entryentity");
        }
    }

    private void hideCancelFlex() {
        Boolean cancel = (Boolean)this.getModel().getValue("cancel");
        if (!cancel.booleanValue()) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"cancelflex"});
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        FormOperate operation = (FormOperate)afterDoOperationEventArgs.getSource();
        String operateKey = operation.getOperateKey();
        if ("submit".equals(operateKey)) {
            OperationResult operationResult = afterDoOperationEventArgs.getOperationResult();
            List successPkIds = operationResult.getSuccessPkIds();
            if (operationResult.isSuccess()) {
                DynamicObject[] successPlan = MPSScheduleUtils.getSuccessPlan((List)successPkIds);
                List<Long> idList = this.getIdList(successPkIds);
                Map maxLevelSequence = MPSScheduleUtils.getMaxLevelSequence((DynamicObject[])successPlan, idList, null, null);
                MPSScheduleUtils.setMaxSeqNoByExitEntry((Map)maxLevelSequence, (DynamicObject[])successPlan, (boolean)true, null, null);
                WorkcentreUtils.updateWorkCenter((DynamicObject[])successPlan);
                MPSScheduleUtils.writeSchedule((DynamicObject[])successPlan, (String)operateKey);
                MPSScheduleUtils.writeOrderPool((DynamicObject[])successPlan, (String)operateKey, null);
                String tips = MPSScheduleUtils.moreNumTips((DynamicObject[])successPlan);
                if (tips.length() != 0) {
                    this.getView().showConfirm(tips, MessageBoxOptions.OK);
                }
                this.getView().invokeOperation("refresh");
            }
        } else if ("unaudit".equals(operateKey)) {
            OperationResult operationResult = afterDoOperationEventArgs.getOperationResult();
            List successPkIds = operationResult.getSuccessPkIds();
            if (operationResult.getSuccessPkIds() != null && operationResult.getSuccessPkIds().size() > 0) {
                DynamicObject[] successPlan = MPSScheduleUtils.getSuccessPlan((List)successPkIds);
                this.clearEntry(successPlan);
                SaveServiceHelper.save((DynamicObject[])successPlan);
                MPSScheduleUtils.writeSchedule((DynamicObject[])successPlan, (String)operateKey);
                MPSScheduleUtils.writeOrderPool((DynamicObject[])successPlan, (String)operateKey, null);
                this.getView().invokeOperation("refresh");
            }
        }
    }

    private void clearEntry(DynamicObject[] successPlan) {
        for (DynamicObject dynamicObject : successPlan) {
            DynamicObjectCollection entryentity = dynamicObject.getDynamicObjectCollection("entryentity");
            entryentity.clear();
        }
    }

    private List<Long> getIdList(List<Object> successPkIds) {
        ArrayList<Long> idList = new ArrayList<Long>(successPkIds.size());
        for (Object object : successPkIds) {
            idList.add((Long)object);
        }
        return idList;
    }
}

