/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mps.formplugin.schedule;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.DataEntitySerializer;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.IListView;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.mmc.mps.business.helper.OperateLogHelper;
import kd.mmc.mps.common.util.MPSScheduleUtils;
import kd.mmc.mps.common.util.WorkcentreUtils;
import kd.mmc.mps.formplugin.schedule.v1.MPSUtil;

public class MpsSchedulePlanListPlugin
extends AbstractListPlugin {
    private static final Log logger = LogFactory.getLog(MpsSchedulePlanListPlugin.class);
    private static final String CHANGE = "change";
    private static final String BILLLISTAP = "billlistap";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"toolbarap"});
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
    }

    public void setFilter(SetFilterEvent e) {
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        FormOperate operation = (FormOperate)args.getSource();
        String operateKey = operation.getOperateKey();
        if ("split".equals(operateKey)) {
            Object listSelectedRow2;
            ListSelectedRowCollection selectedRows = this.getSelectedRows();
            ArrayList<Long> idList = new ArrayList<Long>(selectedRows.size());
            ArrayList<String> lockList = new ArrayList<String>(8);
            ArrayList<String> cancelList = new ArrayList<String>(8);
            ArrayList<String> billstatusList = new ArrayList<String>(8);
            for (Object listSelectedRow2 : selectedRows) {
                long id = (Long)listSelectedRow2.getPrimaryKeyValue();
                idList.add(id);
            }
            DataSet dataSet = QueryServiceHelper.queryDataSet((String)MpsSchedulePlanListPlugin.class.getName(), (String)"mps_scheduleplan", (String)"id,workcentre,billno ,org,materiel,configuredcode,downbilltype,downstreamentryid,downstreamid,lock,billstatus,cancel", (QFilter[])new QFilter[]{new QFilter("id", "in", idList)}, null);
            listSelectedRow2 = null;
            try {
                while (dataSet.hasNext()) {
                    Row next = dataSet.next();
                    if (next.getBoolean("lock").booleanValue()) {
                        lockList.add(next.getString("billno"));
                        continue;
                    }
                    if (next.getBoolean("cancel").booleanValue()) {
                        cancelList.add(next.getString("billno"));
                        continue;
                    }
                    if ("C".equals(next.getString("billstatus"))) continue;
                    billstatusList.add(next.getString("billno"));
                }
            }
            catch (Throwable next) {
                listSelectedRow2 = next;
                throw next;
            }
            finally {
                if (dataSet != null) {
                    if (listSelectedRow2 != null) {
                        try {
                            dataSet.close();
                        }
                        catch (Throwable next) {
                            ((Throwable)listSelectedRow2).addSuppressed(next);
                        }
                    } else {
                        dataSet.close();
                    }
                }
            }
            StringBuilder stringBuilder = new StringBuilder();
            if (lockList.size() > 0) {
                for (String s : lockList) {
                    stringBuilder.append(s).append(":").append(ResManager.loadKDString((String)"\u9501\u5b9a\u72b6\u6001\u4e0b\u7684\u5355\u636e\u4e0d\u5141\u8bb8\u62c6\u5206\u3002", (String)"MpsSchedulePlanListPlugin_16", (String)"mmc-mps-formplugin", (Object[])new Object[0])).append("\r\n");
                }
            }
            if (cancelList.size() > 0) {
                for (String s : cancelList) {
                    stringBuilder.append(s).append(":").append(ResManager.loadKDString((String)"\u5df2\u7ecf\u53d6\u6d88\u4e86\u7684\u5355\u636e\u4e0d\u5141\u8bb8\u62c6\u5206\u3002", (String)"MpsSchedulePlanListPlugin_17", (String)"mmc-mps-formplugin", (Object[])new Object[0])).append("\r\n");
                }
            }
            if (billstatusList.size() > 0) {
                for (String s : billstatusList) {
                    stringBuilder.append(s).append(":").append(ResManager.loadKDString((String)"\u5355\u636e\u72b6\u6001\u4e3a\u5df2\u5ba1\u6838\u624d\u80fd\u8fdb\u884c\u62c6\u5355\u64cd\u4f5c\u3002", (String)"MpsSchedulePlanListPlugin_18", (String)"mmc-mps-formplugin", (Object[])new Object[0])).append("\r\n");
                }
            }
            if (stringBuilder.length() > 2) {
                this.getView().showConfirm(stringBuilder.toString(), MessageBoxOptions.OK);
                args.setCancel(true);
            }
        } else if (CHANGE.equals(operateKey)) {
            ListSelectedRowCollection selectedRows = this.getSelectedRows();
            ArrayList<Long> idList = new ArrayList<Long>(selectedRows.size());
            ArrayList<String> lockList = new ArrayList<String>(8);
            ArrayList<String> cancelList = new ArrayList<String>(8);
            ArrayList<String> billstatusList = new ArrayList<String>(8);
            for (ListSelectedRow listSelectedRow : selectedRows) {
                long id = (Long)listSelectedRow.getPrimaryKeyValue();
                idList.add(id);
            }
            DataSet dataSet = QueryServiceHelper.queryDataSet((String)MpsSchedulePlanListPlugin.class.getName(), (String)"mps_scheduleplan", (String)"id,workcentre,billno ,org,materiel,configuredcode,downbilltype,downstreamentryid,downstreamid,lock,billstatus,cancel", (QFilter[])new QFilter[]{new QFilter("id", "in", idList)}, null);
            Iterator iterator = null;
            try {
                while (dataSet.hasNext()) {
                    Row next = dataSet.next();
                    if (next.getBoolean("lock").booleanValue()) {
                        lockList.add(next.getString("billno"));
                        continue;
                    }
                    if (next.getBoolean("cancel").booleanValue()) {
                        cancelList.add(next.getString("billno"));
                        continue;
                    }
                    if ("C".equals(next.getString("billstatus"))) continue;
                    billstatusList.add(next.getString("billno"));
                }
            }
            catch (Throwable next) {
                iterator = next;
                throw next;
            }
            finally {
                if (dataSet != null) {
                    if (iterator != null) {
                        try {
                            dataSet.close();
                        }
                        catch (Throwable next) {
                            ((Throwable)((Object)iterator)).addSuppressed(next);
                        }
                    } else {
                        dataSet.close();
                    }
                }
            }
            StringBuilder stringBuilder = new StringBuilder();
            if (lockList.size() > 0) {
                for (String s : lockList) {
                    stringBuilder.append(s).append(":").append(ResManager.loadKDString((String)"\u9501\u5b9a\u72b6\u6001\u4e0b\u7684\u5355\u636e\u4e0d\u5141\u8bb8\u53d8\u66f4\u3002", (String)"MpsSchedulePlanListPlugin_19", (String)"mmc-mps-formplugin", (Object[])new Object[0])).append("\r\n");
                }
            }
            if (cancelList.size() > 0) {
                for (String s : cancelList) {
                    stringBuilder.append(s).append(":").append(ResManager.loadKDString((String)"\u5df2\u7ecf\u53d6\u6d88\u4e86\u7684\u5355\u636e\u4e0d\u5141\u8bb8\u53d8\u66f4\u3002", (String)"MpsSchedulePlanListPlugin_22", (String)"mmc-mps-formplugin", (Object[])new Object[0])).append("\r\n");
                }
            }
            if (billstatusList.size() > 0) {
                for (String s : billstatusList) {
                    stringBuilder.append(s).append(":").append(ResManager.loadKDString((String)"\u5355\u636e\u72b6\u6001\u4e3a\u5df2\u5ba1\u6838\u624d\u80fd\u8fdb\u884c\u53d8\u66f4\u64cd\u4f5c\u3002", (String)"MpsSchedulePlanListPlugin_25", (String)"mmc-mps-formplugin", (Object[])new Object[0])).append("\r\n");
                }
            }
            if (stringBuilder.length() > 2) {
                this.getView().showConfirm(stringBuilder.toString(), MessageBoxOptions.OK);
                args.setCancel(true);
            }
        } else if ("startsortcalc".equals(operateKey)) {
            HashSet<Long> orgIds = new HashSet<Long>(16);
            List<Long> calcIdList = this.getCalcIdList();
            ArrayList<String> billstatusList = new ArrayList<String>(8);
            if (calcIdList != null) {
                if (!this.verifyOrg(calcIdList, orgIds)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u4e0d\u540c\u751f\u4ea7\u7ec4\u7ec7\u7684\u6392\u4ea7\u8ba1\u5212\u8fdb\u884c\u67e5\u770b\u3002", (String)"MpsSchedulePlanListPlugin_5", (String)"mmc-mps-formplugin", (Object[])new Object[0]));
                    return;
                }
                DataSet dataSet = QueryServiceHelper.queryDataSet((String)MpsSchedulePlanListPlugin.class.getName(), (String)"mps_scheduleplan", (String)"id,workcentre,billno ,org,materiel,configuredcode,downbilltype,downstreamentryid,downstreamid,lock,billstatus,cancel", (QFilter[])new QFilter[]{new QFilter("id", "in", calcIdList)}, null);
                Object object = null;
                try {
                    while (dataSet.hasNext()) {
                        Row next = dataSet.next();
                        if ("C".equals(next.getString("billstatus"))) continue;
                        billstatusList.add(next.getString("billno"));
                    }
                }
                catch (Throwable next) {
                    object = next;
                    throw next;
                }
                finally {
                    if (dataSet != null) {
                        if (object != null) {
                            try {
                                dataSet.close();
                            }
                            catch (Throwable next) {
                                ((Throwable)object).addSuppressed(next);
                            }
                        } else {
                            dataSet.close();
                        }
                    }
                }
                StringBuilder stringBuilder = new StringBuilder();
                if (billstatusList.size() > 0) {
                    for (String s : billstatusList) {
                        stringBuilder.append(s).append(":").append(ResManager.loadKDString((String)"\u5355\u636e\u72b6\u6001\u4e3a\u5df2\u5ba1\u6838\u624d\u80fd\u8fdb\u884c\u6392\u5e8f\u64cd\u4f5c\u3002", (String)"MpsSchedulePlanListPlugin_21", (String)"mmc-mps-formplugin", (Object[])new Object[0])).append("\r\n");
                    }
                }
                if (stringBuilder.length() > 2) {
                    this.getView().showConfirm(stringBuilder.toString(), MessageBoxOptions.OK);
                    args.setCancel(true);
                }
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        FormOperate operation = (FormOperate)afterDoOperationEventArgs.getSource();
        String operateKey = operation.getOperateKey();
        BillList billList = (BillList)this.getView().getControl(BILLLISTAP);
        OperationResult operationResult = afterDoOperationEventArgs.getOperationResult();
        if (CHANGE.equals(operateKey)) {
            HashSet<Long> manuentryIds;
            HashSet<Long> orgIds;
            HashSet<Long> workcentreIds;
            if (!operationResult.isSuccess()) return;
            ListSelectedRowCollection listSelectedRowCollection = this.getSelectedRows();
            ArrayList<Long> idList = new ArrayList<Long>(listSelectedRowCollection.size());
            if (!this.verifyDuplicate(idList, workcentreIds = new HashSet<Long>(16), orgIds = new HashSet<Long>(16), manuentryIds = new HashSet<Long>(16))) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u4e0d\u540c\u751f\u4ea7\u7ec4\u7ec7\u6216\u8005\u5de5\u4f5c\u4e2d\u5fc3\u7684\u6392\u4ea7\u8ba1\u5212\u8fdb\u884c\u53d8\u66f4\u3002", (String)"MpsSchedulePlanListPlugin_1", (String)"mmc-mps-formplugin", (Object[])new Object[0]));
                return;
            }
            this.showChangeView(idList, workcentreIds, orgIds, manuentryIds);
            return;
        }
        if ("lock".equals(operateKey) || "unlock".equals(operateKey)) {
            this.getView().invokeOperation("refresh");
            return;
        }
        if ("cancel".equals(operateKey)) {
            List successPkIds = operationResult.getSuccessPkIds();
            if (successPkIds.isEmpty()) return;
            FormShowParameter formShowParameter = new FormShowParameter();
            formShowParameter.setFormId("mps_cancelreason");
            formShowParameter.setCustomParam("idList", (Object)SerializationUtils.serializeToBase64((Object)successPkIds));
            formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
            formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "cancel"));
            this.getView().showForm(formShowParameter);
            return;
        }
        if ("split".equals(operateKey)) {
            if (!operationResult.isSuccess()) return;
            Long startdate = System.currentTimeMillis();
            logger.info("mmc-MPSSchedulePlan begin from split operation");
            ListSelectedRowCollection listSelectedRowCollection = this.getSelectedRows();
            ArrayList<Long> idList = new ArrayList<Long>(listSelectedRowCollection.size());
            HashSet<Long> workcentreIds = new HashSet<Long>(16);
            HashSet<Long> orgIds = new HashSet<Long>(16);
            if (!this.verifyDuplicate(idList, workcentreIds, orgIds, null)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u4e0d\u540c\u751f\u4ea7\u7ec4\u7ec7\u6216\u8005\u5de5\u4f5c\u4e2d\u5fc3\u7684\u6392\u4ea7\u8ba1\u5212\u8fdb\u884c\u62c6\u5206\u3002", (String)"MpsSchedulePlanListPlugin_2", (String)"mmc-mps-formplugin", (Object[])new Object[0]));
                return;
            }
            long enddate1 = System.currentTimeMillis();
            logger.info("mmc-MPSSchedulePlan-verifyDuplicate.....cost:" + (enddate1 - startdate) + "ms,from split operation");
            this.showSplitView(idList, workcentreIds, orgIds);
            logger.info("mmc-MPSSchedulePlan-showSplitView.....cost:" + (System.currentTimeMillis() - enddate1) + "ms,from split operation");
            logger.info("mmc-MPSSchedulePlan.....total cost:" + (System.currentTimeMillis() - startdate) + "ms,from split operation");
            return;
        }
        if ("querysort".equals(operateKey)) {
            HashSet<Long> orgIds = new HashSet<Long>(16);
            ListSelectedRowCollection listSelectedRowCollection = this.getSelectedRows();
            ArrayList<Long> idList = new ArrayList<Long>(listSelectedRowCollection.size());
            for (ListSelectedRow listSelectedRow : listSelectedRowCollection) {
                long id = (Long)listSelectedRow.getPrimaryKeyValue();
                idList.add(id);
            }
            if (this.verifyOrg(idList, orgIds)) {
                this.showQueryView(idList, orgIds);
                return;
            }
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u4e0d\u540c\u751f\u4ea7\u7ec4\u7ec7\u7684\u6392\u4ea7\u8ba1\u5212\u8fdb\u884c\u67e5\u770b\u3002", (String)"MpsSchedulePlanListPlugin_5", (String)"mmc-mps-formplugin", (Object[])new Object[0]));
            return;
        }
        if ("startsortcalc".equals(operateKey)) {
            HashSet<Long> orgIds = new HashSet<Long>(16);
            List<Long> calcIdList = this.getCalcIdList();
            if (calcIdList == null) return;
            if (!this.verifyOrg(calcIdList, orgIds)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u4e0d\u540c\u751f\u4ea7\u7ec4\u7ec7\u7684\u6392\u4ea7\u8ba1\u5212\u8fdb\u884c\u67e5\u770b\u3002", (String)"MpsSchedulePlanListPlugin_5", (String)"mmc-mps-formplugin", (Object[])new Object[0]));
                return;
            }
            if (calcIdList.size() != 0) {
                this.openCalcsortPage(calcIdList, false, orgIds);
                return;
            }
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u8ba1\u7b97\u7684\u6570\u636e\u3002", (String)"MpsSchedulePlanListPlugin_20", (String)"mmc-mps-formplugin", (Object[])new Object[0]));
            return;
        }
        if ("querylog".equals(operateKey)) {
            if (billList.getSelectedRows().size() <= 1 && billList.getSelectedRows().size() > 0) {
                this.doquerylog(billList.getSelectedRows());
                return;
            }
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5fc5\u987b\u9009\u62e9\u4e14\u53ea\u80fd\u9009\u62e9\u4e00\u884c\u6570\u636e\u8fdb\u884c\u3010\u67e5\u8be2\u65e5\u5fd7\u3011\u64cd\u4f5c\u3002", (String)"MpsSchedulePlanListPlugin_27", (String)"mmc-mps-formplugin", (Object[])new Object[0]));
            return;
        }
        if ("push".equals(operateKey)) {
            this.getView().invokeOperation("refresh");
            return;
        }
        if ("viewdetailconfig".equals(operateKey)) {
            if (billList.getSelectedRows().size() <= 1 && billList.getSelectedRows().size() > 0) {
                MPSScheduleUtils.doViewDetailConfig((ListSelectedRowCollection)billList.getSelectedRows(), (IFormView)this.getView(), (String)"mps_scheduleplan");
                return;
            }
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5fc5\u987b\u9009\u62e9\u4e14\u53ea\u80fd\u9009\u62e9\u4e00\u884c\u6570\u636e\u8fdb\u884c\u3010\u67e5\u770b\u8be6\u7ec6\u914d\u7f6e\u3011\u64cd\u4f5c\u3002", (String)"MpsSchedulePlanListPlugin_4", (String)"mmc-mps-formplugin", (Object[])new Object[0]));
            return;
        }
        if ("submit".equals(operateKey)) {
            if (operationResult.getSuccessPkIds() == null) return;
            if (operationResult.getSuccessPkIds().size() <= 0) return;
            List successPkIds = operationResult.getSuccessPkIds();
            DynamicObject[] successPlan = MPSScheduleUtils.getSuccessPlan((List)successPkIds);
            List<Long> idList = this.getIdList(successPkIds);
            Map maxLevelSequence = MPSScheduleUtils.getMaxLevelSequence((DynamicObject[])successPlan, idList, null, null);
            MPSScheduleUtils.setMaxSeqNoByExitEntry((Map)maxLevelSequence, (DynamicObject[])successPlan, (boolean)true, null, null);
            WorkcentreUtils.updateWorkCenter((DynamicObject[])successPlan);
            MPSScheduleUtils.writeSchedule((DynamicObject[])successPlan, (String)operateKey);
            MPSScheduleUtils.writeOrderPool((DynamicObject[])successPlan, (String)operateKey, null);
            String tips = MPSScheduleUtils.moreNumTips((DynamicObject[])successPlan);
            if (tips.length() == 0) return;
            this.getView().showConfirm(tips, MessageBoxOptions.OK);
            return;
        }
        if (!"unaudit".equals(operateKey)) return;
        if (operationResult.getSuccessPkIds() == null) return;
        if (operationResult.getSuccessPkIds().size() <= 0) return;
        List successPkIds = operationResult.getSuccessPkIds();
        DynamicObject[] successPlan = MPSScheduleUtils.getSuccessPlan((List)successPkIds);
        this.clearEntry(successPlan);
        SaveServiceHelper.save((DynamicObject[])successPlan);
        MPSScheduleUtils.writeSchedule((DynamicObject[])successPlan, (String)operateKey);
        MPSScheduleUtils.writeOrderPool((DynamicObject[])successPlan, (String)operateKey, null);
    }

    private void openCalcsortPage(List<Long> calcIdList, boolean isCalcLock, Set<Long> orgIds) {
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId("mps_calcsort");
        formShowParameter.setCustomParam("idList", (Object)SerializationUtils.serializeToBase64(calcIdList));
        formShowParameter.setCustomParam("isCalcLock", (Object)isCalcLock);
        formShowParameter.setCustomParam("orgIds", (Object)SerializationUtils.serializeToBase64(orgIds));
        this.getView().getPageCache().put("orgIds", SerializationUtils.serializeToBase64(orgIds));
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "calcsort"));
        this.getView().showForm(formShowParameter);
    }

    private List<Long> getCalcIdList() {
        ArrayList<String> stagingBill = new ArrayList<String>(8);
        HashMap<Long, String> lockBillMap = new HashMap<Long, String>(8);
        ArrayList<Long> idList = new ArrayList<Long>(8);
        ArrayList<String> cancelBill = new ArrayList<String>(8);
        if (this.checkDate(stagingBill, lockBillMap, idList, cancelBill).booleanValue()) {
            boolean isneed = false;
            Object[] datas = MPSUtil.reloadDatas(idList);
            Set workCenters = (Set)datas[1];
            Long from = (Long)datas[2];
            Long to = (Long)datas[3];
            for (int i = 0; i < workCenters.size(); ++i) {
                Long workCenterId = this.getLongValue(workCenters.toArray()[i]);
                QFilter[] filters = new QFilter[]{new QFilter("workcentre", "=", (Object)workCenterId), new QFilter("billstatus", "=", (Object)"C"), new QFilter("cancel", "=", (Object)Character.valueOf('0')), new QFilter("sheduledate", ">=", (Object)new Timestamp(from)), new QFilter("sheduledate", "<=", (Object)new Timestamp(to)), new QFilter("lock", "=", (Object)Character.valueOf('1'))};
                DynamicObjectCollection query = QueryServiceHelper.query((String)"mps_scheduleplan", (String)"id", (QFilter[])filters);
                if (query == null || query.size() <= 0) continue;
                isneed = true;
                break;
            }
            if (isneed) {
                StringBuilder sb = new StringBuilder();
                sb.append(ResManager.loadKDString((String)"\u8ba1\u7b97\u8303\u56f4\u5185\u5b58\u5728\u9501\u5b9a\u7684\u5355\u636e\uff0c\u662f\u5426\u91cd\u65b0\u8ba1\u7b97\u987a\u5e8f\uff0c\u70b9\u201c\u662f\u201d\u91cd\u65b0\u8ba1\u7b97\uff0c\u70b9\u201c\u5426\u201d\u5219\u4e0d\u91cd\u65b0\u8ba1\u7b97\u3002", (String)"MpsSchedulePlanListPlugin_11", (String)"mmc-mps-formplugin", (Object[])new Object[0])).append("\r\n");
                this.getPageCache().put("sort", SerializationUtils.serializeToBase64(lockBillMap));
                this.getPageCache().put("idList", SerializationUtils.serializeToBase64(idList));
                ConfirmCallBackListener sort = new ConfirmCallBackListener("sort", (IFormPlugin)this);
                this.getView().showConfirm(sb.toString(), MessageBoxOptions.YesNo, ConfirmTypes.Default, sort);
                return null;
            }
            return idList;
        }
        StringBuilder sb = new StringBuilder();
        for (String s : stagingBill) {
            sb.append(ResManager.loadKDString((String)"\u5355\u636e\uff1a", (String)"MpsSchedulePlanListPlugin_8", (String)"mmc-mps-formplugin", (Object[])new Object[0])).append(s).append(ResManager.loadKDString((String)"\u4e3a\u6682\u5b58\u72b6\u6001\uff0c\u4e0d\u53c2\u4e0e\u8ba1\u7b97\u3002", (String)"MpsSchedulePlanListPlugin_9", (String)"mmc-mps-formplugin", (Object[])new Object[0])).append("\r\n");
        }
        for (String s : cancelBill) {
            sb.append(ResManager.loadKDString((String)"\u5355\u636e\uff1a", (String)"MpsSchedulePlanListPlugin_8", (String)"mmc-mps-formplugin", (Object[])new Object[0])).append(s).append(ResManager.loadKDString((String)"\u4e3a\u53d6\u6d88\u72b6\u6001\uff0c\u4e0d\u53c2\u4e0e\u8ba1\u7b97\u3002", (String)"MpsSchedulePlanListPlugin_14", (String)"mmc-mps-formplugin", (Object[])new Object[0])).append("\r\n");
        }
        if (lockBillMap.size() != 0) {
            if (lockBillMap.size() != 0) {
                sb.append(ResManager.loadKDString((String)"\u8ba1\u7b97\u8303\u56f4\u5185\u5b58\u5728\u9501\u5b9a\u7684\u5355\u636e\uff0c\u662f\u5426\u91cd\u65b0\u8ba1\u7b97\u987a\u5e8f\uff0c\u70b9\u201c\u662f\u201d\u91cd\u65b0\u8ba1\u7b97\uff0c\u70b9\u201c\u5426\u201d\u5219\u4e0d\u91cd\u65b0\u8ba1\u7b97\u3002", (String)"MpsSchedulePlanListPlugin_11", (String)"mmc-mps-formplugin", (Object[])new Object[0])).append("\r\n");
            }
            this.getPageCache().put("sort", SerializationUtils.serializeToBase64(lockBillMap));
            this.getPageCache().put("idList", SerializationUtils.serializeToBase64(idList));
            ConfirmCallBackListener sort = new ConfirmCallBackListener("sort", (IFormPlugin)this);
            this.getView().showConfirm(sb.toString(), MessageBoxOptions.YesNo, ConfirmTypes.Default, sort);
            return null;
        }
        if (idList.size() != 0) {
            return idList;
        }
        this.getView().showConfirm(sb.toString(), MessageBoxOptions.OK);
        return idList;
    }

    private List<Long> getIdList(List<Object> successPkIds) {
        ArrayList<Long> idList = new ArrayList<Long>(successPkIds.size());
        for (Object object : successPkIds) {
            idList.add((Long)object);
        }
        return idList;
    }

    private void clearEntry(DynamicObject[] successPlan) {
        for (DynamicObject dynamicObject : successPlan) {
            DynamicObjectCollection entryentity = dynamicObject.getDynamicObjectCollection("entryentity");
            entryentity.clear();
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent e) {
        super.confirmCallBack(e);
        String callBackId = e.getCallBackId();
        MessageBoxResult result = e.getResult();
        if ("sort".equals(callBackId)) {
            List idList = (List)SerializationUtils.deSerializeFromBase64((String)this.getPageCache().get("idList"));
            HashSet<Long> orgIds = new HashSet<Long>(16);
            if (6 == result.getValue()) {
                Map sortMap = (Map)SerializationUtils.deSerializeFromBase64((String)this.getPageCache().get("sort"));
                idList.addAll(sortMap.keySet());
                if (idList.size() == 0) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u8ba1\u7b97\u7684\u6570\u636e\u3002", (String)"MpsSchedulePlanListPlugin_20", (String)"mmc-mps-formplugin", (Object[])new Object[0]));
                } else {
                    if (!this.verifyOrg(idList, orgIds)) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u4e0d\u540c\u751f\u4ea7\u7ec4\u7ec7\u7684\u6392\u4ea7\u8ba1\u5212\u8fdb\u884c\u67e5\u770b\u3002", (String)"MpsSchedulePlanListPlugin_5", (String)"mmc-mps-formplugin", (Object[])new Object[0]));
                        return;
                    }
                    this.openCalcsortPage(idList, true, orgIds);
                }
            } else if (idList.size() != 0) {
                if (!this.verifyOrg(idList, orgIds)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u4e0d\u540c\u751f\u4ea7\u7ec4\u7ec7\u7684\u6392\u4ea7\u8ba1\u5212\u8fdb\u884c\u67e5\u770b\u3002", (String)"MpsSchedulePlanListPlugin_5", (String)"mmc-mps-formplugin", (Object[])new Object[0]));
                    return;
                }
                this.openCalcsortPage(idList, false, orgIds);
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u8ba1\u7b97\u7684\u6570\u636e\u3002", (String)"MpsSchedulePlanListPlugin_20", (String)"mmc-mps-formplugin", (Object[])new Object[0]));
            }
        }
    }

    private Boolean checkDate(List<String> stagingBill, Map<Long, String> lockBill, List<Long> idList, List<String> cancelBill) {
        ListSelectedRowCollection listSelectedRowCollection = ((IListView)this.getView()).getSelectedRows();
        for (ListSelectedRow listSelectedRow : listSelectedRowCollection) {
            long id = (Long)listSelectedRow.getPrimaryKeyValue();
            idList.add(id);
        }
        DynamicObjectCollection query = QueryServiceHelper.query((String)"mps_scheduleplan", (String)"id,lock,billstatus,billno,cancel", (QFilter[])new QFilter[]{new QFilter("id", "in", idList)});
        idList.clear();
        for (DynamicObject dynamicObject : query) {
            boolean isAdd = true;
            long id = dynamicObject.getLong("id");
            String billno = dynamicObject.getString("billno");
            boolean lock = dynamicObject.getBoolean("lock");
            boolean cancel = dynamicObject.getBoolean("cancel");
            String billstatus = dynamicObject.getString("billstatus");
            if (lock) {
                lockBill.put(id, billno);
                isAdd = false;
            }
            if (billstatus.equals("A")) {
                stagingBill.add(billno);
                isAdd = false;
            }
            if (cancel) {
                cancelBill.add(billno);
                isAdd = false;
            }
            if (!isAdd) continue;
            idList.add(id);
        }
        if (stagingBill.size() == 0 && lockBill.size() == 0 && cancelBill.size() == 0) {
            return true;
        }
        return false;
    }

    private void doquerylog(ListSelectedRowCollection selectedData) {
        for (ListSelectedRow row : selectedData) {
            ListShowParameter listShowParameter = ShowFormHelper.createShowListForm((String)"mps_schedpla_change_log", (boolean)false);
            List filters = listShowParameter.getListFilterParameter().getQFilters();
            filters.add(new QFilter("opentityid", "=", row.getPrimaryKeyValue()));
            this.getView().showForm((FormShowParameter)listShowParameter);
        }
    }

    private boolean verifyDuplicate(List<Long> idList, Set<Long> workcentreIds, Set<Long> orgIds, Set<Long> manuentryIds) {
        ListSelectedRowCollection listSelectedRowCollection = this.getSelectedRows();
        for (ListSelectedRow listSelectedRow : listSelectedRowCollection) {
            long id = (Long)listSelectedRow.getPrimaryKeyValue();
            idList.add(id);
        }
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)MpsSchedulePlanListPlugin.class.getName(), (String)"mps_scheduleplan", (String)"id,workcentre, org,materiel,configuredcode,downbilltype,downstreamentryid,downstreamid", (QFilter[])new QFilter[]{new QFilter("id", "in", idList)}, null);){
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                workcentreIds.add(row.getLong("workcentre"));
                orgIds.add(row.getLong("org"));
                String downbilltype = row.getString("downbilltype");
                if (!"pom_mftorder_BT_S".equals(downbilltype) || manuentryIds == null) continue;
                Long downstreamentryid = row.getLong("downstreamentryid");
                if (downstreamentryid == null || downstreamentryid == 0L) {
                    downstreamentryid = row.getLong("downstreamid");
                }
                manuentryIds.add(downstreamentryid);
            }
        }
        return workcentreIds.size() < 2 && orgIds.size() < 2;
    }

    private boolean verifyOrg(List<Long> idList, Set<Long> orgIds) {
        ListSelectedRowCollection listSelectedRowCollection = this.getSelectedRows();
        for (ListSelectedRow listSelectedRow : listSelectedRowCollection) {
            long id = (Long)listSelectedRow.getPrimaryKeyValue();
            idList.add(id);
        }
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)MpsSchedulePlanListPlugin.class.getName(), (String)"mps_scheduleplan", (String)"id,workcentre, org,materiel,configuredcode", (QFilter[])new QFilter[]{new QFilter("id", "in", idList)}, null);){
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                orgIds.add(row.getLong("org"));
            }
        }
        return orgIds.size() < 2;
    }

    private void showChangeView(List<Long> idList, Set<Long> workcentreIds, Set<Long> orgIds, Set<Long> manuentryIds) {
        String idJsonStr = SerializationUtils.toJsonString(idList);
        HashMap<String, String> customParams = new HashMap<String, String>();
        customParams.put("data", idJsonStr);
        customParams.put("workcentre", ((Long)workcentreIds.stream().findFirst().get()).toString());
        customParams.put("org", ((Long)orgIds.stream().findFirst().get()).toString());
        customParams.put("manuentryid", SerializationUtils.serializeToBase64(manuentryIds));
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setFormId("mps_sheduleplan_change");
        showParameter.setCustomParams(customParams);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "callback_change"));
        this.getView().showForm(showParameter);
    }

    private void showQueryView(List<Long> idList, Set<Long> orgIds) {
        String idJsonStr = SerializationUtils.toJsonString(idList);
        HashMap<String, String> customParams = new HashMap<String, String>();
        customParams.put("data", idJsonStr);
        customParams.put("orgIds", SerializationUtils.serializeToBase64(orgIds));
        ListShowParameter showParameter = new ListShowParameter();
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setFormId("mps_schedulequery");
        showParameter.setCustomParams(customParams);
        ListFilterParameter listFilterParameter = showParameter.getListFilterParameter();
        listFilterParameter.getQFilters().add(new QFilter("id", "in", idList));
        showParameter.setListFilterParameter(listFilterParameter);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "callback_query"));
        this.getView().showForm((FormShowParameter)showParameter);
    }

    private void showSplitView(List<Long> idList, Set<Long> workcentreIds, Set<Long> orgIds) {
        String idJsonStr = SerializationUtils.toJsonString(idList);
        HashMap<String, String> customParams = new HashMap<String, String>();
        customParams.put("data", idJsonStr);
        customParams.put("workcentre", ((Long)workcentreIds.stream().findFirst().get()).toString());
        customParams.put("org", ((Long)orgIds.stream().findFirst().get()).toString());
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setFormId("mps_scheduleplansplit");
        showParameter.setCustomParams(customParams);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "callback_split"));
        this.getView().showForm(showParameter);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        Object returnData;
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        if ("callback_change".equals(actionId) || "callback_split".equals(actionId) || "mps_scheduledataimport".equals(actionId) || "callback_query".equals(actionId)) {
            this.getView().invokeOperation("refresh");
        } else if ("cancel".equals(actionId)) {
            Object returnData2 = closedCallBackEvent.getReturnData();
            if (returnData2 != null) {
                HashMap<String, String> errorMessage = new HashMap<String, String>(8);
                String idLists = (String)((Map)returnData2).get("idList");
                Object text = ((Map)returnData2).get("text");
                long currUserId = RequestContext.getOrCreate().getCurrUserId();
                List idList = (List)SerializationUtils.deSerializeFromBase64((String)idLists);
                MainEntityType planorderType = EntityMetadataCache.getDataEntityType((String)"mps_scheduleplan");
                DynamicObject[] scheduleplans = BusinessDataServiceHelper.load((Object[])idList.toArray(), (DynamicObjectType)planorderType);
                if (scheduleplans != null && scheduleplans.length > 0) {
                    List<DynamicObject> dynamicObjectList = this.writeBackmof(scheduleplans, errorMessage);
                    MPSScheduleUtils.writeSchedule((DynamicObject[])scheduleplans, (String)"unaudit");
                    MPSScheduleUtils.writeOrderPool((DynamicObject[])scheduleplans, (String)"unaudit", null);
                    for (DynamicObject schedule : dynamicObjectList) {
                        if (schedule.getBoolean("lock")) continue;
                        schedule.set("cancel", (Object)true);
                        schedule.set("cancelperson", (Object)currUserId);
                        schedule.set("canceltime", (Object)new Date());
                        schedule.set("cancelreason", text);
                    }
                    SaveServiceHelper.update((DynamicObject[])scheduleplans);
                    this.writeLog(Arrays.asList(scheduleplans));
                }
                if (errorMessage.size() == 0) {
                    this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u53d6\u6d88\u6210\u529f\u3002", (String)"MpsSchedulePlanListPlugin_13", (String)"mmc-mps-formplugin", (Object[])new Object[0]));
                } else {
                    StringBuilder sb = new StringBuilder();
                    for (Map.Entry mapEntry : errorMessage.entrySet()) {
                        sb.append((String)mapEntry.getKey()).append(':').append((String)mapEntry.getValue()).append('\n');
                    }
                    this.getView().showConfirm(sb.toString(), MessageBoxOptions.OK);
                }
                this.getView().invokeOperation("refresh");
            }
        } else if ("batchpushworkorder".equals(actionId)) {
            this.showBatchPushOrderResult(closedCallBackEvent);
        } else if ("calcsort".equals(actionId) && (returnData = closedCallBackEvent.getReturnData()) != null) {
            List idList = (List)SerializationUtils.deSerializeFromBase64((String)returnData.toString());
            Set orgIds = (Set)SerializationUtils.deSerializeFromBase64((String)this.getPageCache().get("orgIds"));
            MainEntityType planorderType = EntityMetadataCache.getDataEntityType((String)"mps_scheduleplan");
            DynamicObject[] scheduleplans = BusinessDataServiceHelper.load((Object[])idList.toArray(), (DynamicObjectType)planorderType);
            MPSScheduleUtils.writeOrderPool((DynamicObject[])scheduleplans, (String)"submit", null);
            this.showQueryView(idList, orgIds);
        }
    }

    private void writeLog(List<DynamicObject> updateObjs) {
        ArrayList fieldsMapList = new ArrayList(16);
        if (!updateObjs.isEmpty()) {
            for (DynamicObject schedule : updateObjs) {
                HashMap<String, Object> logMap = new HashMap<String, Object>(16);
                StringBuilder message = new StringBuilder();
                message.append(ResManager.loadKDString((String)"\u6392\u4ea7\u8ba1\u5212\u5355\uff1a", (String)"MpsSchedulePlanSplitValidator_6", (String)"mmc-mps-opplugin", (Object[])new Object[0])).append(schedule.getString("billno")).append(ResManager.loadKDString((String)"\u53d6\u6d88\u6210\u529f\u3002", (String)"MpsSchedulePlanSplitValidator_7", (String)"mmc-mps-opplugin", (Object[])new Object[0]));
                logMap.put("createorg", schedule.getLong("org_id"));
                logMap.put("operateentity", "mps_scheduleplan");
                logMap.put("operatenum", "cancel");
                logMap.put("operatename", ResManager.loadKDString((String)"\u53d6\u6d88", (String)"MpsSchedulePlanSplitValidator_8", (String)"mmc-mps-opplugin", (Object[])new Object[0]));
                logMap.put("operatedesc", message.toString());
                logMap.put("opentityid", schedule.getLong("id"));
                fieldsMapList.add(logMap);
            }
            OperateLogHelper.genOperateLog(fieldsMapList);
        }
    }

    private List<DynamicObject> writeBackmof(DynamicObject[] scheduleplans, Map<String, String> errorMessage) {
        ArrayList<DynamicObject> updateObjs = new ArrayList<DynamicObject>(8);
        for (DynamicObject dynamicObject : scheduleplans) {
            HashSet<Long> manuentryidList = new HashSet<Long>(16);
            Long manuentryid = dynamicObject.getLong("downstreamentryid");
            String downbilltype = dynamicObject.getString("downbilltype");
            String billstatus = dynamicObject.getString("billstatus");
            if (!"C".equals(billstatus) && !"pom_mftorder_BT_S".equals(downbilltype)) continue;
            if (manuentryid != null && manuentryid != 0L) {
                manuentryidList.add(manuentryid);
                Map<Long, Map<String, Object>> orderCanceleResults = this.useBizService(manuentryidList);
                if (orderCanceleResults == null) continue;
                for (Map.Entry<Long, Map<String, Object>> mapEntry : orderCanceleResults.entrySet()) {
                    String canceleResult;
                    Long orderEntryID = mapEntry.getKey();
                    if (!orderEntryID.equals(manuentryid)) continue;
                    Map<String, Object> orderCanceleResult = mapEntry.getValue();
                    String string = orderCanceleResult.get("success") == null ? null : (canceleResult = orderCanceleResult.get("success") instanceof String ? (String)orderCanceleResult.get("success") : null);
                    if ("true".equals(canceleResult)) {
                        if (dynamicObject.getBoolean("lock")) continue;
                        updateObjs.add(dynamicObject);
                        continue;
                    }
                    String message = orderCanceleResult.get("message") == null ? null : (orderCanceleResult.get("message") instanceof String ? (String)orderCanceleResult.get("message") : null);
                    String billno = dynamicObject.getString("billno");
                    errorMessage.put(billno, message);
                }
                continue;
            }
            if (dynamicObject.getBoolean("lock")) continue;
            updateObjs.add(dynamicObject);
        }
        return updateObjs;
    }

    private Map<Long, Map<String, Object>> useBizService(Set<Long> manuentryidList) {
        Map orderCanceleResults = (Map)DispatchServiceHelper.invokeBizService((String)"bd", (String)"mpdm", (String)"IMftOrderService", (String)"closeOrInvalidOrderByOrderEntryId", (Object[])new Object[]{manuentryidList, "pom_mftorder"});
        return orderCanceleResults;
    }

    private void showBatchPushOrderResult(ClosedCallBackEvent closedCallBackEvent) {
        Map returnData = (Map)closedCallBackEvent.getReturnData();
        String taskInfoStr = (String)returnData.get("taskinfo");
        Map taskInfo = (Map)SerializationUtils.fromJsonString((String)taskInfoStr, Map.class);
        String dataStr = (String)taskInfo.get("data");
        Map data = (Map)SerializationUtils.fromJsonString((String)dataStr, Map.class);
        String result = (String)data.get("data");
        OperationResult operationResult = (OperationResult)DataEntitySerializer.deSerializerFromString((String)result, (IDataEntityType)OrmUtils.getDataEntityType(OperationResult.class));
        this.getView().showOperationResult(operationResult);
    }

    public Long getLongValue(Object value) {
        if (value == null) {
            return 0L;
        }
        if (value instanceof Integer) {
            Integer result = (Integer)value;
            return result.longValue();
        }
        if (value instanceof String) {
            return Long.parseLong((String)value);
        }
        if (value instanceof BigDecimal) {
            BigDecimal result = (BigDecimal)value;
            return result.longValue();
        }
        return (Long)value;
    }
}

