/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mps.formplugin.schedule;

import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.UUID;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.form.control.Control;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.mmc.mps.consts.schedule.SchedulePlanConst;

public class MpsSchedulePlanSplitPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    private ORM orm = ORM.create();

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit splitworkcentre = (BasedataEdit)this.getControl("splitworkcentre");
        splitworkcentre.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        Long org = Long.parseLong((String)this.getView().getFormShowParameter().getCustomParam("org"));
        Long workCentre = Long.parseLong((String)this.getView().getFormShowParameter().getCustomParam("workcentre"));
        this.getModel().setValue("workcentre", (Object)workCentre);
        this.getModel().setValue("org", (Object)org);
        this.getView().updateView("workcentre");
        this.getView().updateView("org");
        String jsonStr = (String)this.getView().getFormShowParameter().getCustomParam("data");
        List idList = SerializationUtils.fromJsonStringToList((String)jsonStr, Long.class);
        DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((Object[])idList.toArray(new Long[0]), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"mps_scheduleplan"));
        int rowIndex = 0;
        TableValueSetter tableValueSetter = new TableValueSetter(new String[0]);
        this.getModel().beginInit();
        for (DynamicObject dynamicObject : dynamicObjects) {
            tableValueSetter.set("billid", (Object)dynamicObject.getLong("id"), rowIndex);
            tableValueSetter.set("billno", (Object)dynamicObject.getString("billno"), rowIndex);
            if (dynamicObject.get("sourcebilltypeid") != null) {
                DynamicObject billType = dynamicObject.getDynamicObject("sourcebilltypeid");
                tableValueSetter.set("sourcebilltype", (Object)billType.getString("name"), rowIndex);
            }
            tableValueSetter.set("sourcebillno", (Object)dynamicObject.getString("sourcebillno"), rowIndex);
            tableValueSetter.set("entryseq", (Object)dynamicObject.getInt("sourceentryseq"), rowIndex);
            if (dynamicObject.get("materiel") != null) {
                DynamicObject material = dynamicObject.getDynamicObject("materiel");
                tableValueSetter.set("matrerial", (Object)material.getLong("id"), rowIndex);
            }
            if (dynamicObject.get("tracknumber") != null) {
                DynamicObject track = dynamicObject.getDynamicObject("tracknumber");
                tableValueSetter.set("tracknumber", (Object)track.getLong("id"), rowIndex);
            }
            if (dynamicObject.get("configuredcode") != null) {
                DynamicObject configure = dynamicObject.getDynamicObject("configuredcode");
                tableValueSetter.set("configuredcode", (Object)configure.getLong("id"), rowIndex);
            }
            if (dynamicObject.get("sheduledate") != null) {
                Date scheduleDate = dynamicObject.getDate("sheduledate");
                tableValueSetter.set("sheduledate", (Object)scheduleDate, rowIndex);
            }
            if (dynamicObject.get("unit") != null) {
                DynamicObject unit = dynamicObject.getDynamicObject("unit");
                tableValueSetter.set("unit", (Object)unit.getLong("id"), rowIndex);
            }
            if (dynamicObject.get("downstreamid") != null) {
                Long downstreamid = dynamicObject.getLong("downstreamid");
                tableValueSetter.set("downstreamid", (Object)downstreamid, rowIndex);
            }
            if (dynamicObject.get("downstreamentryid") != null) {
                Long downstreamentryid = dynamicObject.getLong("downstreamentryid");
                tableValueSetter.set("downstreamentryid", (Object)downstreamentryid, rowIndex);
            }
            if (dynamicObject.get("downstreamno") != null) {
                String downstreamno = dynamicObject.getString("downstreamno");
                tableValueSetter.set("downstreamno", (Object)downstreamno, rowIndex);
            }
            if (dynamicObject.get("downstreamseq") != null) {
                int downstreamseq = dynamicObject.getInt("downstreamseq");
                tableValueSetter.set("downstreamseq", (Object)downstreamseq, rowIndex);
            }
            if (dynamicObject.get("downbilltype") != null) {
                String downbilltype = dynamicObject.getString("downbilltype");
                tableValueSetter.set("downbilltype", (Object)downbilltype, rowIndex);
            }
            if (dynamicObject.get("remark") != null) {
                String remark = dynamicObject.getString("remark");
                tableValueSetter.set("remark", (Object)remark, rowIndex);
            }
            tableValueSetter.set("scheduleqty", (Object)dynamicObject.getBigDecimal("scheduleqty"), rowIndex);
            tableValueSetter.set("remark", (Object)dynamicObject.getString("remark"), rowIndex);
            ++rowIndex;
        }
        ((AbstractFormDataModel)this.getModel()).batchCreateNewEntryRow("entryentity", tableValueSetter);
        this.getModel().endInit();
        this.getView().updateView("entryentity");
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        if ("newentry".equals(operateKey)) {
            String[] splitFields;
            int rowIndex = this.getModel().getEntryCurrentRowIndex("subentryentity");
            Long org = Long.parseLong((String)this.getView().getFormShowParameter().getCustomParam("org"));
            Long workCentre = Long.parseLong((String)this.getView().getFormShowParameter().getCustomParam("workcentre"));
            this.getModel().setValue(this.getSubEntryEntityFieldFlag("org"), (Object)org, rowIndex);
            this.getModel().setValue(this.getSubEntryEntityFieldFlag("workcentre"), (Object)workCentre, rowIndex);
            int parentIndex = this.getModel().getEntryCurrentRowIndex("entryentity");
            for (String splitField : splitFields = SchedulePlanConst.SchedulePlanSplitConst.splitFields) {
                this.getModel().setValue(this.getSubEntryEntityFieldFlag(splitField), this.getModel().getValue(splitField, parentIndex), rowIndex);
            }
            String billNo = CodeRuleServiceHelper.getNumber((String)"mps_scheduleplan", (DynamicObject)this.genDynamicObject("mps_scheduleplan"), (String)String.valueOf(org));
            if (StringUtils.isBlank((CharSequence)billNo)) {
                billNo = UUID.randomUUID().toString().substring(0, 30);
            }
            this.getModel().setValue(this.getSubEntryEntityFieldFlag("billno"), (Object)billNo);
        }
    }

    private DynamicObject genDynamicObject(String entityId) {
        return this.orm.newDynamicObject(entityId);
    }

    private String getSubEntryEntityFieldFlag(String field) {
        return "ori" + field;
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String key = ((Control)e.getSource()).getKey();
        if (StringUtils.equals((CharSequence)key, (CharSequence)"splitworkcentre")) {
            int rowIndex = this.getModel().getEntryCurrentRowIndex("subentryentity");
            DynamicObject entryRowEntity = this.getModel().getEntryRowEntity("subentryentity", rowIndex);
            Long orgid = entryRowEntity.getDynamicObject("oriorg").getLong("id");
            QFilter mpdm_workcentre = BaseDataServiceHelper.getBaseDataFilter((String)"mpdm_workcentre", (Long)orgid);
            ListShowParameter formShowParameter = (ListShowParameter)e.getFormShowParameter();
            formShowParameter.getListFilterParameter().getQFilters().add(mpdm_workcentre);
        }
    }
}

