/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mps.formplugin.schedule;

import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mutex.DataMutex;
import kd.bos.mutex.MutexFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.bos.servicehelper.devportal.BizAppServiceHelp;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.mmc.mps.formplugin.schedule.v1.MPSUtil;

public class MpsShcedulingCalcPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    private static final Log log = LogFactory.getLog(MpsShcedulingCalcPlugin.class);
    private static final String MRP_PLS = "mps_pls";
    private static final String SCHEDULING_ORG = "scheduling_org";
    private static final String SCHEDULING_SCHEME = "scheduling_scheme";
    private static final String BEGINDATE = "begindate";
    private static final String START_CAL = "calculate";
    private static final String MPS_PROPLANSCHDEF = "mps_proplanschdef";
    private static final String MRP_MUTEX_GROUP_ID = "mmc.mps";
    private static final String CACULATELOG_CACHE = "caculateLog_cache";
    private static final String MRP_CACULATE_lOG = "mrp_caculate_log";
    private static final String CONFIRM_EXEC = "confirm_exec";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit scheduling_scheme = (BasedataEdit)this.getControl(SCHEDULING_SCHEME);
        scheduling_scheme.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit org = (BasedataEdit)this.getView().getControl(SCHEDULING_ORG);
        org.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        long userId = Long.parseLong(RequestContext.get().getUserId());
        HasPermOrgResult result = PermissionServiceHelper.getAllPermOrgs((Long)userId, (String)BizAppServiceHelp.getAppIdByAppNumber((String)"mps"), (String)MRP_PLS, (String)"47150e89000000ac");
        List orgIds = result.getHasPermOrgs();
        if (!orgIds.isEmpty()) {
            long orgid = RequestContext.get().getOrgId();
            if (orgIds.contains(orgid)) {
                this.getModel().setValue(SCHEDULING_ORG, (Object)RequestContext.get().getOrgId());
            } else {
                this.getModel().setValue(SCHEDULING_ORG, orgIds.get(0));
            }
        } else if (result.hasAllOrgPerm()) {
            this.getModel().setValue(SCHEDULING_ORG, (Object)RequestContext.get().getOrgId());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        super.beforeDoOperation(e);
        FormOperate op = (FormOperate)e.getSource();
        String key = op.getOperateKey();
        if (START_CAL.equals(key)) {
            this.judgeType();
            this.getView().showLoading(new LocaleString(ResManager.loadKDString((String)"\u8ba1\u7b97\u51c6\u5907\u4e2d\uff0c\u8bf7\u7a0d\u7b49\u3002", (String)"MpsScheduleSummaryPlugin_1", (String)"mmc-mps-formplugin", (Object[])new Object[0])));
            try {
                this.beforeCalculate(e);
            }
            finally {
                this.getView().hideLoading();
            }
        }
    }

    private void judgeType() {
        DynamicObjectCollection entryentitys = this.getModel().getEntryEntity("entryentity");
        ArrayList<String> type = new ArrayList<String>(entryentitys.size());
        int i = 0;
        for (DynamicObject entryentity : entryentitys) {
            String scheduletype = entryentity.getString("scheduletype");
            if (type.size() == 0) {
                type.add(scheduletype);
            } else if (!type.contains(scheduletype)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u4e0d\u540c\u7684\u6392\u4ea7\u65b9\u5f0f\u4e0d\u5141\u8bb8\u5728\u4e00\u4e2a\u65b9\u6848\u4e2d\u8ba1\u7b97\u3002", (String)"MpsShcedulingCalcPlugin_6", (String)"mmc-mps-formplugin", (Object[])new Object[0]));
            }
            if ("B".equals(scheduletype)) {
                Object intgroup = entryentity.get("intgroup");
                if (intgroup == null) {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u7b2c%s\u884c\u7684\u9996\u6392\u5206\u7ec4\u3002", (String)"MpsShcedulingCalcPlugin_5", (String)"mmc-mps-formplugin", (Object[])new Object[0]), i + 1));
                }
                int firstsday = entryentity.getInt("firstsday");
                if (firstsday == 0) {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u7b2c%s\u884c\u7684\u9996\u6392\u5468\u671f\uff08\u5929\uff09\u3002", (String)"MpsShcedulingCalcPlugin_17", (String)"mmc-mps-formplugin", (Object[])new Object[0]), i + 1));
                }
            }
            ++i;
        }
    }

    private void beforeCalculate(BeforeDoOperationEventArgs e) {
        DynamicObject schedulingScheme = (DynamicObject)this.getModel().getValue(SCHEDULING_SCHEME);
        String schedulingSchemeId = schedulingScheme.getPkValue().toString();
        Map lockMap = null;
        try (DataMutex mutex = MutexFactory.createDataMutex();){
            lockMap = mutex.getLockInfo(schedulingSchemeId, MRP_MUTEX_GROUP_ID, MPS_PROPLANSCHDEF);
        }
        catch (IOException ioException) {
            log.info("\u83b7\u53d6\u4e92\u65a5\u9501\u5f02\u5e38");
        }
        if (lockMap != null) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8be5\u6392\u7a0b\u65b9\u6848\u5b58\u5728\u6b63\u5728\u8fd0\u884c\u7684\u8ba1\u5212\uff0c\u8bf7\u7b49\u5f85\u8fd0\u7b97\u7ed3\u675f\u6216\u7ec8\u6b62\u8fd0\u7b97\u540e\u518d\u8fdb\u884c\u8ba1\u7b97", (String)"ProdLineShcedulingPlugin_2", (String)"mmc-mrp-formplugin", (Object[])new Object[0]));
            e.setCancel(true);
            return;
        }
        DynamicObject caculateLog = ORM.create().newDynamicObject(MRP_CACULATE_lOG);
        String number = CodeRuleServiceHelper.getNumber((String)MRP_CACULATE_lOG, (DynamicObject)caculateLog, (String)((DynamicObject)this.getModel().getValue(SCHEDULING_ORG)).getPkValue().toString());
        if (StringUtils.isBlank((CharSequence)number)) {
            ConfirmCallBackListener confirmCallBack = new ConfirmCallBackListener(CONFIRM_EXEC, (IFormPlugin)this);
            String strs = String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7[%s]\u672a\u627e\u5230\u8fd0\u7b97\u65e5\u5fd7\u7f16\u7801\u89c4\u5219\uff0c\u662f\u5426\u7ee7\u7eed\u8fdb\u884c\u8fd0\u7b97\uff1f\u5982\u9009\u62e9\u662f\uff0c\u5219\u91c7\u7528\u7cfb\u7edf\u5185\u7801\u4f5c\u4e3a\u8fd0\u7b97\u65e5\u5fd7\u7f16\u7801\u3002", (String)"ProdLineShcedulingPlugin_3", (String)"mmc-mrp-formplugin", (Object[])new Object[0]), ((DynamicObject)this.getModel().getValue(SCHEDULING_ORG)).getString("name"));
            this.getPageCache().put(CACULATELOG_CACHE, caculateLog.getPkValue().toString());
            this.getView().showConfirm(strs, MessageBoxOptions.YesNo, confirmCallBack);
        } else {
            this.execSchedulingScheme();
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent e) {
        super.confirmCallBack(e);
        if (MessageBoxResult.Yes.equals((Object)e.getResult()) && CONFIRM_EXEC.equals(e.getCallBackId())) {
            DynamicObject schedulingScheme = (DynamicObject)this.getModel().getValue(SCHEDULING_SCHEME);
            String schedulingSchemeId = schedulingScheme.getPkValue().toString();
            Map lockMap = null;
            try (DataMutex mutex = MutexFactory.createDataMutex();){
                lockMap = mutex.getLockInfo(schedulingSchemeId, MRP_MUTEX_GROUP_ID, MPS_PROPLANSCHDEF);
            }
            catch (IOException ioException) {
                log.info("\u83b7\u53d6\u4e92\u65a5\u9501\u5f02\u5e38");
            }
            if (lockMap != null) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8be5\u6392\u7a0b\u65b9\u6848\u5b58\u5728\u6b63\u5728\u8fd0\u884c\u7684\u8ba1\u5212\uff0c\u8bf7\u7b49\u5f85\u8fd0\u7b97\u7ed3\u675f\u6216\u7ec8\u6b62\u8fd0\u7b97\u540e\u518d\u8fdb\u884c\u8ba1\u7b97", (String)"ProdLineShcedulingPlugin_2", (String)"mmc-mrp-formplugin", (Object[])new Object[0]));
                return;
            }
            this.execSchedulingScheme();
        }
    }

    private void execSchedulingScheme() {
        Long logid = (Long)DispatchServiceHelper.invokeBizService((String)"mpscmm", (String)"msplan", (String)"IMRPCalcRuntimeService", (String)"initRuntime", (Object[])new Object[]{MRP_CACULATE_lOG});
        DynamicObject caculateLog = this.writeLog(logid);
        Map<String, Object> planProgramMapData = this.getPlanProgramMapData();
        String planProgramMapDataValue = SerializationUtils.serializeToBase64(planProgramMapData);
        MPSUtil.getJedis().set("mpscalc-" + caculateLog.getLong("id") + "mps_scheduleplan_plangrams_args", planProgramMapDataValue);
        DynamicObject org = (DynamicObject)this.getModel().getValue(SCHEDULING_ORG);
        Long evntid = (Long)DispatchServiceHelper.invokeBizService((String)"mpscmm", (String)"msplan", (String)"IMRPCalcRuntimeService", (String)"startCalc", (Object[])new Object[]{logid, null, org.getLong("id"), org.getString("name"), this.getView().getFormShowParameter().getFormId(), this.getView().getFormShowParameter().getFormName(), MRP_CACULATE_lOG});
        this.showLogForm(evntid);
    }

    private DynamicObject writeLog(Long ctxId) {
        DynamicObject schedulingScheme = (DynamicObject)this.getModel().getValue(SCHEDULING_SCHEME);
        DynamicObject caculateLog = BusinessDataServiceHelper.loadSingle((Object)ctxId, (String)MRP_CACULATE_lOG);
        DynamicObject org = (DynamicObject)this.getModel().getValue(SCHEDULING_ORG);
        caculateLog.set("createorg", (Object)org);
        caculateLog.set("useorg", (Object)org);
        caculateLog.set("status", (Object)"C");
        caculateLog.set("enable", (Object)"1");
        caculateLog.set("plantype", (Object)"MPS");
        caculateLog.set("plangram", (Object)schedulingScheme.getLong("id"));
        caculateLog.set("programname", (Object)schedulingScheme.getString("name"));
        caculateLog.set("programnumber", (Object)schedulingScheme.getString("number"));
        caculateLog.set("plangramentity", (Object)MPS_PROPLANSCHDEF);
        caculateLog.set("plandate", this.getModel().getValue(BEGINDATE));
        caculateLog.set("creator", (Object)RequestContext.get().getCurrUserId());
        caculateLog.set("startdate", (Object)new Date());
        caculateLog.set("operatmode", (Object)this.getView().getFormShowParameter().getFormName());
        caculateLog.set("operatmodekey", (Object)this.getView().getFormShowParameter().getFormId());
        caculateLog.set("runtype", (Object)"MPS");
        if (caculateLog.getString("number") == null || "".equals(caculateLog.getString("number"))) {
            String number = CodeRuleServiceHelper.getNumber((String)MRP_CACULATE_lOG, (DynamicObject)caculateLog, (String)String.valueOf(RequestContext.get().getOrgId()));
            if (StringUtils.isNotEmpty((CharSequence)number)) {
                caculateLog.set("number", (Object)number);
            } else {
                caculateLog.set("number", (Object)caculateLog.getString("id"));
            }
        }
        SaveServiceHelper.update((DynamicObject)caculateLog);
        return caculateLog;
    }

    private Map<String, Object> getPlanProgramMapData() {
        HashMap<String, Object> planProgramMap = new HashMap<String, Object>(4);
        Object begindate = this.getModel().getValue(BEGINDATE);
        Object expectation = this.getModel().getValue("expectation");
        planProgramMap.put("calDate", begindate);
        planProgramMap.put("expectation", expectation);
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("entryentity");
        ArrayList workcenterList = new ArrayList(8);
        for (DynamicObject dynamicObject : entryEntity) {
            HashMap<String, Object> workCenterInfoMap = new HashMap<String, Object>(8);
            workCenterInfoMap.put("workCenterId", dynamicObject.getDynamicObject("workcenter").getLong("id"));
            DynamicObject intgroup = dynamicObject.getDynamicObject("intgroup");
            if (intgroup != null) {
                workCenterInfoMap.put("firstGroupId", intgroup.getLong("id"));
            }
            workCenterInfoMap.put("scheduleType", dynamicObject.getString("scheduletype"));
            workCenterInfoMap.put("firstDay", dynamicObject.getInt("firstsday"));
            workcenterList.add(workCenterInfoMap);
        }
        planProgramMap.put("workCenterInfoList", workcenterList);
        return planProgramMap;
    }

    public void propertyChanged(PropertyChangedArgs e) {
        block14: {
            Object oldValue;
            Object newValue;
            String name;
            block15: {
                block13: {
                    name = e.getProperty().getName();
                    newValue = e.getChangeSet()[0].getNewValue();
                    oldValue = e.getChangeSet()[0].getOldValue();
                    if (!SCHEDULING_SCHEME.equals(name)) break block13;
                    if (newValue != null) {
                        Object pkValue = ((DynamicObject)newValue).getPkValue();
                        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)pkValue, (String)MPS_PROPLANSCHDEF);
                        BigDecimal planoutlook = dynamicObject.getBigDecimal("planoutlook");
                        this.getModel().setValue("expectation", (Object)planoutlook);
                        this.getModel().deleteEntryData("entryentity");
                        DynamicObjectCollection workentry = dynamicObject.getDynamicObjectCollection("workentry");
                        if (workentry == null || workentry.size() == 0) {
                            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u7ef4\u62a4\u6392\u4ea7\u65b9\u6848\u7684\u5de5\u4f5c\u4e2d\u5fc3\u3002", (String)"MpsShcedulingCalcPlugin_4", (String)"mmc-mps-formplugin", (Object[])new Object[0]));
                        }
                        this.getModel().batchCreateNewEntryRow("entryentity", workentry.size());
                        for (int i = 0; i < workentry.size(); ++i) {
                            DynamicObject dynamicObject_plan = (DynamicObject)workentry.get(i);
                            if (dynamicObject_plan.getDynamicObject("productionrules") == null) {
                                throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u7ef4\u62a4\u6392\u4ea7\u65b9\u6848\u7684\u5206\u7ebf\u6392\u4ea7\u89c4\u5219\u3002", (String)"MpsShcedulingCalcPlugin_20", (String)"mmc-mps-formplugin", (Object[])new Object[0]));
                            }
                            String scheduletype = dynamicObject_plan.getDynamicObject("productionrules").getString("productiontype");
                            DynamicObject entryentity = this.getModel().getEntryRowEntity("entryentity", i);
                            entryentity.set("workcenter", dynamicObject_plan.get("workcenter"));
                            entryentity.set("scheduletype", (Object)scheduletype);
                            if ("B".equals(scheduletype)) {
                                this.getView().setEnable(Boolean.valueOf(true), i, new String[]{"intgroup", "firstsday"});
                                entryentity.set("intgroup", dynamicObject_plan.get("intgroup"));
                                entryentity.set("firstsday", (Object)planoutlook);
                                continue;
                            }
                            this.getView().setEnable(Boolean.valueOf(false), i, new String[]{"intgroup", "firstsday"});
                        }
                        this.getView().updateView("entryentity");
                    } else {
                        this.getModel().deleteEntryData("entryentity");
                    }
                    break block14;
                }
                if (!"firstsday".equals(name)) break block15;
                if (newValue == null) break block14;
                int day = (Integer)newValue;
                EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
                int[] selectRows = entryGrid.getSelectRows();
                if (selectRows != null && selectRows.length != 0) {
                    int row = selectRows[0];
                    int expectation = (Integer)this.getModel().getValue("expectation");
                    if (expectation < day) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u9996\u6392\u5468\u671f\u4e0d\u80fd\u5927\u4e8e\u5c55\u671b\u671f\u3002", (String)"MpsShcedulingCalcPlugin_7", (String)"mmc-mps-formplugin", (Object[])new Object[0]));
                        if (oldValue != null) {
                            int oldday = (Integer)oldValue;
                            this.getModel().setValue("firstsday", (Object)oldday, row);
                        } else {
                            this.getModel().setValue("firstsday", (Object)0, row);
                        }
                    }
                }
                break block14;
            }
            if ("expectation".equals(name) && newValue != null) {
                int day = (Integer)newValue;
                DynamicObjectCollection entryentity = this.getModel().getEntryEntity("entryentity");
                for (DynamicObject dynamicObject : entryentity) {
                    int firstsday = dynamicObject.getInt("firstsday");
                    if (day >= firstsday) continue;
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5c55\u671b\u671f\u4e0d\u80fd\u5c0f\u4e8e\u9996\u6392\u5468\u671f\u3002", (String)"MpsShcedulingCalcPlugin_8", (String)"mmc-mps-formplugin", (Object[])new Object[0]));
                    if (oldValue != null) {
                        int oldday = (Integer)oldValue;
                        this.getModel().setValue("expectation", (Object)oldday);
                        break;
                    }
                    this.getModel().setValue("expectation", (Object)0);
                    break;
                }
            }
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        Control con = (Control)e.getSource();
        String key = con.getKey();
        if (SCHEDULING_SCHEME.equals(key)) {
            Object org = this.getModel().getValue(SCHEDULING_ORG);
            if (org == null) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u5f55\u5165\u751f\u4ea7\u7ec4\u7ec7\u3002", (String)"MpsShcedulingCalcPlugin_0", (String)"mmc-mps-formplugin", (Object[])new Object[0]));
                e.setCancel(true);
                return;
            }
            Long orgId = (Long)((DynamicObject)org).getPkValue();
            QFilter orgFilter = new QFilter("createorg.id", "=", (Object)orgId);
            QFilter statusFilter = new QFilter("status", "=", (Object)"C");
            QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
            QFilter capacalcwayFilter = new QFilter("capacalcway", "=", (Object)"A").or("capacalcway", "=", (Object)Character.valueOf(' '));
            ListShowParameter param = (ListShowParameter)e.getFormShowParameter();
            param.getListFilterParameter().getQFilters().add(orgFilter);
            param.getListFilterParameter().getQFilters().add(statusFilter);
            param.getListFilterParameter().getQFilters().add(enableFilter);
            param.getListFilterParameter().getQFilters().add(capacalcwayFilter);
        }
    }

    private void showLogForm(Long id) {
        this.getView().close();
        BillShowParameter formShowParameter = new BillShowParameter();
        formShowParameter.setFormId("mps_caculate_log");
        formShowParameter.setStatus(OperationStatus.EDIT);
        formShowParameter.setPkId((Object)id);
        formShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        formShowParameter.setCustomParam("id", (Object)id);
        this.getView().showForm((FormShowParameter)formShowParameter);
    }
}

