/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mps.formplugin.schedule;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.filter.ControlFilters;
import kd.bos.exception.KDBizException;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.UrlUtil;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.BillListHyperLinkClickEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mutex.DataMutex;
import kd.bos.mutex.MutexFactory;
import kd.bos.mvc.export.ListDataExporter;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.service.ServiceFactory;
import kd.bos.service.metadata.MetadataService;
import kd.bos.service.metadata.export.ExportWriterFormat;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.svc.util.permission.datarule.DataRulePermissionUtil;
import kd.mmc.mps.business.helper.OperateLogHelper;
import kd.mmc.mps.common.util.MPSScheduleUtils;
import kd.mmc.mps.common.util.WorkcentreUtils;
import kd.mmc.mps.formplugin.schedule.MpsAssistScheduPlugin;
import kd.mmc.mps.mservice.license.MpsLicense;
import org.apache.poi.xssf.streaming.SXSSFCell;
import org.apache.poi.xssf.streaming.SXSSFRow;

public class ScheduledataList
extends AbstractListPlugin
implements MpsLicense {
    private static Log log = LogFactory.getLog(ScheduledataList.class);
    private static final String MPS_SCHEDULEDATA = "mps_scheduledata";
    private static final String MPS_PROPLANSCHDEF = "mps_proplanschdef";
    private static final String MPS = "mps";
    private static final String MRP_CACULATE_LOG = "mrp_caculate_log";
    private static final String PLANPROGRAMID = "planprogram.id";

    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
        this.mpsPreOpen(e);
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        for (FilterColumn filterColumn : args.getFilterContainerInitEvent().getCommonFilterColumns()) {
            List defaultValues;
            CommonFilterColumn columnFilter = (CommonFilterColumn)filterColumn;
            if (!columnFilter.getFieldName().startsWith("org") || (defaultValues = filterColumn.getDefaultValues()) != null && defaultValues.size() != 0) continue;
            List hasPermOrg = MPSScheduleUtils.getHasPermOrg((String)MPS_SCHEDULEDATA, (String)MPS);
            Set productOrg = MPSScheduleUtils.getProductOrg((List)hasPermOrg);
            if (productOrg.size() != 0) {
                long orgid = RequestContext.get().getOrgId();
                if (productOrg.contains(orgid)) {
                    columnFilter.setDefaultValues(new Object[]{String.valueOf(orgid)});
                    continue;
                }
                columnFilter.setDefaultValues(new Object[]{productOrg.toArray()[0].toString()});
                continue;
            }
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u9875\u9762\u65e0\u6709\u6743\u9650\u7684\u7ec4\u7ec7\uff0c\u8bf7\u5148\u6388\u6743\u3002", (String)"scheduledataList_36", (String)"mmc-mps-formplugin", (Object[])new Object[0]));
            return;
        }
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String itemKey = evt.getItemKey();
        if ("getdata".equals(itemKey)) {
            this.getModelData();
        } else if ("appoint".equals(itemKey)) {
            if (this.checkStatus()) {
                this.showPage("mps_appoint", itemKey);
            }
        } else if ("cleardate".equals(itemKey)) {
            this.cleardate();
        } else if ("markstatus".equals(itemKey)) {
            List<Long> selectId = this.getSelectId();
            if (selectId.size() != 0) {
                this.showPage("mps_makestatus", itemKey);
            }
        } else if ("assistschedu".equals(itemKey)) {
            Map<Long, String> unaccessData;
            List<Long> workcentreIdList = this.checkData();
            List<Long> orderData = this.getSelectId();
            String tips = this.unAccessTips(orderData, unaccessData = this.getUnaccessData());
            if (tips != null && !tips.isEmpty()) {
                this.getView().showTipNotification(tips);
            }
            if (orderData.size() != 0) {
                this.openAssistscheduPage(workcentreIdList);
            }
        } else if ("overallschedu".equals(itemKey)) {
            this.showPage("mps_pls", itemKey);
        } else if ("checknatural".equals(itemKey)) {
            List<Long> orderData = this.getSelectId();
            if (orderData.size() != 0) {
                this.checkNatural(orderData);
            }
        } else if ("access".equals(itemKey)) {
            List<Long> orderData = this.getSelectId();
            if (orderData.size() != 0) {
                this.accessData(orderData, true);
            }
        } else if ("unaccess".equals(itemKey)) {
            List<Long> orderData = this.getSelectId();
            if (orderData.size() != 0) {
                this.accessData(orderData, false);
            }
        } else if ("exportbylist".equals(itemKey)) {
            List pkIds;
            Long userId = Long.parseLong(RequestContext.getOrCreate().getUserId());
            QFilter validScope = new QFilter("applyscope", "=", (Object)"0").or("creator", "=", (Object)userId).or(new QFilter("applyscope", "=", (Object)"1").and("users.fbasedataid.id", "in", (Object)userId));
            ArrayList<QFilter> filters = new ArrayList<QFilter>(4);
            filters.add(new QFilter("bizobject.number", "=", (Object)"mps_scheduleplan"));
            filters.add(new QFilter("templatetype", "=", (Object)"IMPT").and(new QFilter("enable", "=", (Object)"1")).or(new QFilter("templatetype", "is null", null)));
            filters.add(new QFilter("number", "=", (Object)"mps_scheduleplan_IMPT_S"));
            filters.add(validScope);
            String appId = this.getView().getPageCache().get("CheckRightAppId");
            QFilter dataRule = DataRulePermissionUtil.getDataRule((long)RequestContext.get().getCurrUserId(), (String)appId, (String)"bos_importtemplate");
            if (dataRule != null) {
                filters.add(dataRule);
            }
            if ((pkIds = QueryServiceHelper.queryPrimaryKeys((String)"export", (String)"bos_importtemplate", (QFilter[])filters.toArray(new QFilter[0]), (String)"", (int)2)).size() > 0) {
                this.downloadTemplate(pkIds.get(0));
            }
        } else if ("setplangram".equals(itemKey)) {
            this.openSetPlanGramPage();
        } else if ("viewdetailconfig".equals(itemKey)) {
            List<Long> selectId = this.getSelectId();
            if (selectId.size() > 1 || selectId.size() <= 0) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5fc5\u987b\u9009\u62e9\u4e14\u53ea\u80fd\u9009\u62e9\u4e00\u884c\u6570\u636e\u8fdb\u884c\u3010\u67e5\u770b\u8be6\u7ec6\u914d\u7f6e\u3011\u64cd\u4f5c\u3002", (String)"MpsSchedulePlanListPlugin_4", (String)"mmc-mps-formplugin", (Object[])new Object[0]));
                return;
            }
            MPSScheduleUtils.doViewDetailConfig((ListSelectedRowCollection)this.getSelectedRows(), (IFormView)this.getView(), (String)MPS_SCHEDULEDATA);
        }
    }

    private void cleardate() {
        List<Long> selectId = this.getSelectId();
        if (selectId.size() != 0) {
            DynamicObject[] load;
            for (DynamicObject dynamicObject : load = BusinessDataServiceHelper.load((String)MPS_SCHEDULEDATA, (String)"id,scheduledate", (QFilter[])new QFilter[]{new QFilter("id", "in", selectId)})) {
                dynamicObject.set("scheduledate", null);
            }
            SaveServiceHelper.save((DynamicObject[])load);
            this.getView().invokeOperation("refresh");
        }
    }

    private Map<Long, String> getUnaccessData() {
        ListSelectedRowCollection selectedRows = this.getSelectedRows();
        ArrayList<Long> idList = new ArrayList<Long>(8);
        HashMap<Long, String> unAccessId = new HashMap<Long, String>(8);
        if (selectedRows.size() == 0) {
            return unAccessId;
        }
        for (ListSelectedRow selectedRow : selectedRows) {
            Object primaryKeyValue = selectedRow.getPrimaryKeyValue();
            idList.add((Long)primaryKeyValue);
        }
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)MpsAssistScheduPlugin.class.getName(), (String)MPS_SCHEDULEDATA, (String)"sourcebillid,id,sourceentryid,access,number", (QFilter[])new QFilter[]{new QFilter("id", "in", idList)}, null);){
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                Boolean access = row.getBoolean("access");
                if (access.booleanValue()) continue;
                unAccessId.put(row.getLong("id"), row.getString("number"));
            }
        }
        return unAccessId;
    }

    private String unAccessTips(List<Long> orderData, Map<Long, String> accessMap) {
        ArrayList<Long> orderData_clone = new ArrayList<Long>(orderData);
        String tip = "";
        StringBuilder sb = new StringBuilder();
        if (accessMap.size() != 0) {
            for (Long id : orderData_clone) {
                if (!accessMap.containsKey(id)) continue;
                orderData.remove(id);
                sb.append(accessMap.get(id)).append(",");
            }
            tip = String.format(ResManager.loadKDString((String)"\u5f85\u6392\u4ea7\u8ba2\u5355\u5355\u636e\u7f16\u7801\uff1a%1$s\u4e3a\u672a\u51c6\u5165\u6570\u636e\uff0c\u4e0d\u53c2\u4e0e\u8ba1\u7b97\u3002", (String)"MpsSchedulePlanListPlugin_6", (String)"mmc-mps-formplugin", (Object[])new Object[0]), sb.substring(0, sb.length() - 1));
        }
        return tip;
    }

    private void openSetPlanGramPage() {
        HashMap<String, String> para = new HashMap<String, String>();
        para.put("formId", "mps_setplangram");
        FormShowParameter showParameter = FormShowParameter.createFormShowParameter(para);
        ControlFilters controlFilters = this.getControlFilters();
        List filter = controlFilters.getFilter("org.id");
        Object orgId = filter.get(0);
        if (orgId == null || orgId.toString().isEmpty()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u751f\u4ea7\u7ec4\u7ec7\u3002", (String)"scheduledataList_2", (String)"mmc-mps-formplugin", (Object[])new Object[0]));
        }
        showParameter.setCustomParam("org", (Object)orgId.toString());
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "calc"));
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(showParameter);
    }

    private List<ExportWriterFormat> loadExportFormat(String entityNumber, long templateId) {
        MetadataService metaService = (MetadataService)ServiceFactory.getService(MetadataService.class);
        String formatJson = metaService.getExportWriter(entityNumber, templateId, (String)null, (String)null);
        List formats = JSONObject.parseArray((String)formatJson, ExportWriterFormat.class);
        return formats;
    }

    private void downloadTemplate(Object t) {
        String fileName = ResManager.loadKDString((String)"\u5f85\u6392\u4ea7\u8ba2\u5355\u5bfc\u51fa\u6570\u636e", (String)"DownloadTemplatePlugin_0", (String)"bos-import", (Object[])new Object[0]);
        LocalDate now = LocalDate.now();
        if (!StringUtils.isBlank((CharSequence)"mps_scheduleplan")) {
            fileName = fileName + "_" + String.format("%02d", now.getMonthValue()) + String.format("%02d", now.getDayOfMonth());
            List<ExportWriterFormat> formats = this.loadExportFormat("mps_scheduleplan", (Long)t);
            ListDataExporter exporter = new ListDataExporter("sheet1", formats, false);
            Map<Object, DynamicObject> scheduleData = this.getScheduleData();
            if (scheduleData == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u65e0\u6570\u636e\u5bfc\u51fa\u3002", (String)"scheduledataList_31", (String)"mmc-mps-formplugin", (Object[])new Object[0]));
                return;
            }
            this.setDataToSheet(scheduleData, exporter);
            String url = exporter.flush(fileName, 60);
            this.addFilePermission(url, this.getView().getFormShowParameter().getServiceAppId(), MPS_SCHEDULEDATA, "4730fc9f000004ae");
            this.getView().download(url);
        }
    }

    public void addFilePermission(String url, String appid, String entity, String permissionid) {
        String tempFileId = UrlUtil.getParam((String)url, (String)"id");
        HashMap<String, String> refEntitiyMap = new HashMap<String, String>(2);
        refEntitiyMap.put("entityNum", entity);
        refEntitiyMap.put("appId", appid);
        refEntitiyMap.put("permissionItemId", permissionid);
        DistributeSessionlessCache redisCache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("", true);
        redisCache.put("TempFileCheckId:" + tempFileId, (Object)SerializationUtils.toJsonString(refEntitiyMap), 7200);
    }

    private void setDataToSheet(Map<Object, DynamicObject> scheduleData, ListDataExporter exporter) {
        SXSSFRow row_field = exporter.getRow(2);
        int lastCellNum = row_field.getLastCellNum();
        int num = 4;
        for (DynamicObject dynamicObject : scheduleData.values()) {
            SXSSFRow row = exporter.getRow(num);
            for (int i = 0; i < lastCellNum; ++i) {
                SXSSFCell cell = row_field.getCell(i);
                String stringCellValue = cell.getStringCellValue();
                Object dataBySchedule = this.getDataBySchedule(stringCellValue, dynamicObject);
                if (row.getCell(i) != null) continue;
                SXSSFCell cell1 = row.createCell(i);
                if (dataBySchedule == null) continue;
                cell1.setCellValue(dataBySchedule.toString());
            }
            ++num;
        }
    }

    private Object getDataBySchedule(String stringCellValue, DynamicObject dynamicObject) {
        DynamicObjectType dynamicObjectType = dynamicObject.getDynamicObjectType();
        if (stringCellValue.contains(".")) {
            String[] split = stringCellValue.split("\\.");
            String s = split[0];
            if ("configuredcode".equals(s)) {
                s = "configurecode";
            } else if ("scheduleplan".equals(s)) {
                s = "planprogram";
            } else if ("totalworkcenter".equals(s)) {
                s = "totalworkcentre";
            } else if ("sourcebilltypeid".equals(s)) {
                s = "sourcebilltype";
            } else if ("datasourceid".equals(s)) {
                s = "sourcebillid";
            }
            if (dynamicObjectType.getProperty(s) != null) {
                DynamicObject fieldDyn = dynamicObject.getDynamicObject(s);
                String field = split[1];
                if (fieldDyn != null) {
                    Object o = fieldDyn.get(field);
                    return o;
                }
                return "";
            }
            return "";
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        if ("sheduledate".equals(stringCellValue)) {
            stringCellValue = "scheduledate";
        } else if ("scheduleqty".equals(stringCellValue)) {
            stringCellValue = "plsqty";
        } else if ("datasourceid".equals(stringCellValue)) {
            stringCellValue = "sourcebillid";
        } else if ("sourceentryseq".equals(stringCellValue)) {
            stringCellValue = "entryseq";
        } else if ("productionid".equals(stringCellValue)) {
            stringCellValue = "id";
        }
        if (dynamicObjectType.getProperty(stringCellValue) != null) {
            Object value = dynamicObject.get(stringCellValue);
            if (value instanceof Date) {
                return sdf.format((Date)value);
            }
            if (value instanceof BigDecimal) {
                return ((BigDecimal)value).toPlainString();
            }
            return dynamicObject.get(stringCellValue);
        }
        return "";
    }

    private Map<Object, DynamicObject> getScheduleData() {
        List<Long> selectId = this.getSelectId();
        if (selectId.size() == 0) {
            return null;
        }
        QFilter qFilter = new QFilter("id", "in", selectId);
        return BusinessDataServiceHelper.loadFromCache((String)MPS_SCHEDULEDATA, (QFilter[])new QFilter[]{qFilter});
    }

    private void accessData(List<Long> orderData, boolean isaccess) {
        String successTip;
        String tip;
        ArrayList<Map<String, Object>> fieldsMapList = new ArrayList<Map<String, Object>>(16);
        DynamicObject[] scheduledata = BusinessDataServiceHelper.load((String)MPS_SCHEDULEDATA, (String)"workcentre,totalworkcentre,scheduledate,number,schedustatus,abnormal,org,access,accessdate", (QFilter[])new QFilter[]{new QFilter("id", "in", orderData)});
        ArrayList<DynamicObject> dnyList = new ArrayList<DynamicObject>(scheduledata.length);
        for (DynamicObject dynamicObject : scheduledata) {
            String operatenum;
            String desc;
            String opreatName;
            long orgId = dynamicObject.getDynamicObject("org").getLong("id");
            String number = dynamicObject.getString("number");
            String schedustatus = dynamicObject.getString("schedustatus");
            boolean abnormal = dynamicObject.getBoolean("abnormal");
            boolean access = dynamicObject.getBoolean("access");
            if (!"A".equals(schedustatus) || abnormal || (!isaccess || access) && (isaccess || !access)) continue;
            if (isaccess) {
                dynamicObject.set("accessdate", (Object)new Date());
                opreatName = ResManager.loadKDString((String)"\u51c6\u5165", (String)"scheduledataList_20", (String)"mmc-mps-formplugin", (Object[])new Object[0]);
                desc = String.format(ResManager.loadKDString((String)"\u5f85\u6392\u4ea7\u8ba1\u5212\u5355\uff1a%1$s\u51c6\u5165\u6210\u529f\u3002", (String)"scheduledataList_21", (String)"mmc-mps-formplugin", (Object[])new Object[0]), number);
                operatenum = "access";
            } else {
                dynamicObject.set("accessdate", null);
                opreatName = ResManager.loadKDString((String)"\u53cd\u51c6\u5165", (String)"scheduledataList_24", (String)"mmc-mps-formplugin", (Object[])new Object[0]);
                desc = String.format(ResManager.loadKDString((String)"\u5f85\u6392\u4ea7\u8ba1\u5212\u5355\uff1a%1$s\u53cd\u51c6\u5165\u6210\u529f\u3002", (String)"scheduledataList_26", (String)"mmc-mps-formplugin", (Object[])new Object[0]), number);
                operatenum = "unaccess";
            }
            dynamicObject.set("access", (Object)isaccess);
            this.createOpLog(fieldsMapList, orgId, dynamicObject.getLong("id"), opreatName, desc, operatenum);
            dnyList.add(dynamicObject);
        }
        if (dnyList.size() != 0) {
            SaveServiceHelper.save((DynamicObject[])dnyList.toArray(new DynamicObject[0]));
            OperateLogHelper.genOperateLog(fieldsMapList);
        }
        if (isaccess) {
            tip = ResManager.loadKDString((String)"\u53ea\u6709\u5355\u636e\u72b6\u6001=\u5f85\u6392&\u6279\u51c6\u51c6\u5165=\u5426&\u5f02\u5e38=\u5426\u7684\u6570\u636e\u652f\u6301\u51c6\u5165\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\u3002", (String)"scheduledataList_22", (String)"mmc-mps-formplugin", (Object[])new Object[0]);
            successTip = ResManager.loadKDString((String)"\u51c6\u5165\u6210\u529f\u3002", (String)"scheduledataList_23", (String)"mmc-mps-formplugin", (Object[])new Object[0]);
        } else {
            tip = ResManager.loadKDString((String)"\u53ea\u6709\u5355\u636e\u72b6\u6001=\u5f85\u6392&\u6279\u51c6\u51c6\u5165=\u662f&\u5f02\u5e38=\u5426\u7684\u6570\u636e\u652f\u6301\u53cd\u51c6\u5165\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\u3002", (String)"scheduledataList_27", (String)"mmc-mps-formplugin", (Object[])new Object[0]);
            successTip = ResManager.loadKDString((String)"\u53cd\u51c6\u5165\u6210\u529f\u3002", (String)"scheduledataList_25", (String)"mmc-mps-formplugin", (Object[])new Object[0]);
        }
        if (dnyList.size() != scheduledata.length) {
            this.getView().showTipNotification(tip);
        } else {
            this.getView().showSuccessNotification(successTip);
        }
        this.getView().invokeOperation("refresh");
    }

    private void checkNatural(List<Long> orderData) {
    }

    private void openAssistscheduPage(List<Long> workcenterIdList) {
        DynamicObject org = this.getProductOrg();
        HashMap<String, String> para = new HashMap<String, String>();
        para.put("formId", "mps_assistschedu");
        FormShowParameter showParameter = FormShowParameter.createFormShowParameter(para);
        showParameter.setCustomParam("workcenterIdList", (Object)SerializationUtils.serializeToBase64(workcenterIdList));
        showParameter.setCustomParam("orderData", (Object)this.getPageCache().get("sourcebillidList"));
        showParameter.setCustomParam("sourcebillentryids", (Object)this.getPageCache().get("sourcebillentryids"));
        showParameter.setCustomParam("sourcebillentryIdToScheduData", (Object)this.getPageCache().get("sourcebillentryIdToScheduData"));
        showParameter.setCustomParam("scheduId", (Object)this.getPageCache().get("scheduId"));
        if (org != null) {
            Long orgId = org.getLong("id");
            showParameter.setCustomParam("orgId", (Object)orgId.toString());
        }
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "calc"));
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(showParameter);
    }

    private List<Long> checkData() {
        ArrayList<Long> workcentreIdList = new ArrayList<Long>(1);
        List<Long> idList = this.getSelectId();
        if (idList.size() == 0) {
            return workcentreIdList;
        }
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)"checkstaus", (String)MPS_SCHEDULEDATA, (String)"schedustatus,abnormal,workcentre", (QFilter[])new QFilter[]{new QFilter("id", "in", idList)}, (String)"");
        while (dataSet.hasNext()) {
            Row next = dataSet.next();
            Long workcentreId = next.getLong("workcentre");
            if (workcentreIdList.size() == 0) {
                if (workcentreIdList.contains(workcentreId)) continue;
                workcentreIdList.add(workcentreId);
                continue;
            }
            if (workcentreIdList.contains(workcentreId)) continue;
            throw new KDBizException(ResManager.loadKDString((String)"\u9009\u62e9\u7684\u6570\u636e\u5b58\u5728\u591a\u4e2a\u5de5\u4f5c\u4e2d\u5fc3\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u6570\u636e\u3002", (String)"MpsScheduleSummaryPlugin_6", (String)"mmc-mps-formplugin", (Object[])new Object[0]));
        }
        return workcentreIdList;
    }

    private boolean checkStatus() {
        List<Long> idList = this.getSelectId();
        if (idList.size() == 0) {
            return false;
        }
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)"checkstaus", (String)MPS_SCHEDULEDATA, (String)"schedustatus,abnormal", (QFilter[])new QFilter[]{new QFilter("id", "in", idList)}, (String)"");
        while (dataSet.hasNext()) {
            Row next = dataSet.next();
            String schedustatus = next.getString("schedustatus");
            Boolean abnormal = next.getBoolean("abnormal");
            if ("A".equals(schedustatus) && !abnormal.booleanValue()) continue;
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u80fd\u6307\u5b9a\u9000\u56de\u3001\u5173\u95ed\u6216\u8005\u5f02\u5e38\u7684\u6570\u636e\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"scheduledataList_7", (String)"mmc-mps-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private List<Long> getSelectId() {
        ListSelectedRowCollection selectedRows = this.getSelectedRows();
        ArrayList<Long> idList = new ArrayList<Long>(8);
        ArrayList<Long> scheduId = new ArrayList<Long>(8);
        ArrayList<Long> sourcebillidList = new ArrayList<Long>(8);
        ArrayList<Long> sourcebillentryIdList = new ArrayList<Long>(8);
        HashMap<Long, Long> sourcebillentryIdToScheduData = new HashMap<Long, Long>(8);
        if (selectedRows.size() == 0) {
            return sourcebillidList;
        }
        for (ListSelectedRow selectedRow : selectedRows) {
            Object primaryKeyValue = selectedRow.getPrimaryKeyValue();
            idList.add((Long)primaryKeyValue);
        }
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)MpsAssistScheduPlugin.class.getName(), (String)MPS_SCHEDULEDATA, (String)"sourcebillid,id,sourceentryid,access,number,scheduledate", (QFilter[])new QFilter[]{new QFilter("id", "in", idList)}, null);){
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                Boolean access = row.getBoolean("access");
                if (!access.booleanValue()) continue;
                sourcebillidList.add(row.getLong("sourcebillid"));
                scheduId.add(row.getLong("id"));
                sourcebillentryIdList.add(row.getLong("sourceentryid"));
                Date scheduledate = row.getDate("scheduledate");
                if (scheduledate == null) continue;
                sourcebillentryIdToScheduData.put(row.getLong("sourceentryid"), scheduledate.getTime());
            }
        }
        this.getView().getPageCache().put("idList", SerializationUtils.serializeToBase64(idList));
        this.getView().getPageCache().put("sourcebillidList", SerializationUtils.serializeToBase64(sourcebillidList));
        this.getView().getPageCache().put("scheduId", SerializationUtils.serializeToBase64(scheduId));
        this.getView().getPageCache().put("sourcebillentryids", SerializationUtils.serializeToBase64(sourcebillentryIdList));
        this.getView().getPageCache().put("sourcebillentryIdToScheduData", SerializationUtils.serializeToBase64(sourcebillentryIdToScheduData));
        return idList;
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        BillListHyperLinkClickEvent evt = (BillListHyperLinkClickEvent)args.getHyperLinkClickEvent();
        String fieldName = evt.getFieldName();
        ListSelectedRow currentRow = evt.getCurrentRow();
        Object logPk = currentRow.getPrimaryKeyValue();
        if ("mateqty".equals(fieldName)) {
            args.setCancel(true);
            BillShowParameter formShowParameter = new BillShowParameter();
            formShowParameter.setFormId("mps_scheduassgined");
            DynamicObject query = QueryServiceHelper.queryOne((String)"mps_scheduassgined", (String)"id", (QFilter[])new QFilter[]{new QFilter("scheduid", "=", logPk)});
            if (query != null) {
                formShowParameter.setPkId(query.get("id"));
                formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
                this.getView().showForm((FormShowParameter)formShowParameter);
            }
        }
    }

    private void showPage(String sign, String actionId) {
        FormShowParameter formShowParameter = new FormShowParameter();
        formShowParameter.setFormId(sign);
        if ("mps_pls".equals(sign)) {
            formShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        } else {
            formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        }
        if ("mps_appoint".equals(sign)) {
            DynamicObject productOrg = this.getProductOrg();
            formShowParameter.setCustomParam("org", (Object)productOrg.getLong("id"));
        }
        formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, actionId));
        this.getView().showForm(formShowParameter);
    }

    private void getModelData() {
        block18: {
            DataMutex mutex = MutexFactory.createDataMutex();
            DynamicObject productOrg = this.getProductOrg();
            Long orgid = productOrg.getLong("id");
            try {
                Map lockInfo_botton = mutex.getLockInfo(orgid.toString(), MPS, MPS_SCHEDULEDATA);
                if (lockInfo_botton != null) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u751f\u4ea7\u7ec4\u7ec7\u6b63\u5728\u83b7\u53d6\u6570\u636e,\u8bf7\u7a0d\u540e\u3002", (String)"scheduledataList_4", (String)"mmc-mps-formplugin", (Object[])new Object[0]));
                    return;
                }
                mutex.require(orgid.toString(), MPS, MPS_SCHEDULEDATA, "getdata", true);
                DynamicObject planprogram = this.getPlanProgram();
                if (planprogram != null) {
                    this.getView().showLoading(new LocaleString(ResManager.loadKDString((String)"\u8ba1\u7b97\u51c6\u5907\u4e2d\uff0c\u8bf7\u7a0d\u7b49\u3002", (String)"MpsScheduleSummaryPlugin_1", (String)"mmc-mps-formplugin", (Object[])new Object[0])));
                    DynamicObject caculateLog = this.createNewLog(planprogram, productOrg);
                    String orgName = productOrg.getString("name");
                    DispatchServiceHelper.invokeBizService((String)"mpscmm", (String)"msplan", (String)"IMRPCalcRuntimeService", (String)"startCalc", (Object[])new Object[]{caculateLog.getLong("id"), null, orgid, orgName, "mps_scheduleplan_branch", this.getView().getFormShowParameter().getFormName(), MRP_CACULATE_LOG});
                    String statuc = MPSScheduleUtils.pollingStatus((long)caculateLog.getLong("id"));
                    if ("A".equals(statuc)) {
                        this.getView().invokeOperation("refresh");
                        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u83b7\u53d6\u6210\u529f\u3002", (String)"scheduledataList_28", (String)"mmc-mps-formplugin", (Object[])new Object[0]));
                    } else {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u83b7\u53d6\u5931\u8d25\uff0c\u8be6\u60c5\u8bf7\u67e5\u770b\u8fd0\u7b97\u65e5\u5fd7\u3002", (String)"scheduledataList_34", (String)"mmc-mps-formplugin", (Object[])new Object[0]));
                    }
                    mutex.release(orgid.toString(), MPS_SCHEDULEDATA, "getdata");
                    break block18;
                }
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u8ba1\u5212\u65b9\u6848\u3002", (String)"scheduledataList_5", (String)"mmc-mps-formplugin", (Object[])new Object[0]));
                mutex.release(orgid.toString(), MPS_SCHEDULEDATA, "getdata");
                return;
            }
            catch (Exception e) {
                mutex.release(orgid.toString(), MPS_SCHEDULEDATA, "getdata");
                throw new KDBizException(e.getMessage());
            }
            finally {
                this.getView().hideLoading();
                try {
                    mutex.close();
                }
                catch (Exception e) {
                    log.info("mutex is error");
                }
            }
        }
    }

    private DynamicObject getProductOrg() {
        List selectedMainOrgIds = this.getSelectedMainOrgIds();
        if (selectedMainOrgIds == null || selectedMainOrgIds.size() == 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u751f\u4ea7\u7ec4\u7ec7\u3002", (String)"scheduledataList_2", (String)"mmc-mps-formplugin", (Object[])new Object[0]));
        }
        Long orgid = (Long)selectedMainOrgIds.get(0);
        Map orgMap = BusinessDataServiceHelper.loadFromCache((String)"bos_org", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)orgid)});
        if (orgMap == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5f53\u524d\u7ec4\u7ec7\u4e0d\u5b58\u5728\u3002", (String)"scheduledataList_3", (String)"mmc-mps-formplugin", (Object[])new Object[0]));
        }
        return (DynamicObject)orgMap.get(orgid);
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        String actionId = e.getActionId();
        Object returnData = e.getReturnData();
        if ("appoint".equals(actionId)) {
            if (returnData != null) {
                this.appointWorkcenterOrDate(returnData);
            }
        } else if ("markstatus".equals(actionId)) {
            if (returnData != null) {
                this.markStatus(returnData);
            }
        } else if ("calc".equals(actionId) && returnData != null) {
            this.showLogForm((Long)returnData);
        }
    }

    private void showLogForm(Long id) {
        BillShowParameter formShowParameter = new BillShowParameter();
        formShowParameter.setFormId("mps_caculate_log");
        formShowParameter.setStatus(OperationStatus.EDIT);
        formShowParameter.setPkId((Object)id);
        formShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        formShowParameter.setCustomParam("id", (Object)id);
        this.getView().showForm((FormShowParameter)formShowParameter);
    }

    private void markStatus(Object returnData) {
        ArrayList<Map<String, Object>> fieldsMapList = new ArrayList<Map<String, Object>>(16);
        List idList = (List)SerializationUtils.deSerializeFromBase64((String)this.getPageCache().get("idList"));
        Map returnMessage = (Map)SerializationUtils.deSerializeFromBase64((String)returnData.toString());
        DynamicObject[] scheduledata = BusinessDataServiceHelper.load((String)MPS_SCHEDULEDATA, (String)"number,schedustatus,abnormal,returndate,returnreason,org,access,orderpoolid", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)idList)});
        ArrayList<DynamicObject> dnyList = new ArrayList<DynamicObject>(scheduledata.length);
        String operatename = ResManager.loadKDString((String)"\u72b6\u6001\u6807\u6ce8", (String)"scheduledataList_13", (String)"mmc-mps-formplugin", (Object[])new Object[0]);
        String operatenum = "markstatus";
        Object radiogroupfield = returnMessage.get("radiogroupfield");
        Object renturnreason = returnMessage.get("renturnreason");
        for (DynamicObject dynamicObject : scheduledata) {
            long orgId = dynamicObject.getDynamicObject("org").getLong("id");
            String schedustatus = dynamicObject.getString("schedustatus");
            String number = dynamicObject.getString("number");
            if ("1".equals(radiogroupfield)) {
                String desc;
                boolean abnormal = dynamicObject.getBoolean("abnormal");
                if (abnormal && "B".equals(schedustatus)) {
                    dynamicObject.set("schedustatus", (Object)"A");
                    dynamicObject.set("returndate", null);
                    dynamicObject.set("returnreason", (Object)"");
                    dynamicObject.set("abnormal", (Object)false);
                    dnyList.add(dynamicObject);
                    desc = String.format(ResManager.loadKDString((String)"\u5f85\u6392\u4ea7\u8ba1\u5212\u5355\uff1a%1$s\u6807\u6ce8\u6210\u529f\uff0c\u6807\u6ce8\u72b6\u6001\uff1a%2$s\u3002", (String)"scheduledataList_12", (String)"mmc-mps-formplugin", (Object[])new Object[0]), number, ResManager.loadKDString((String)"\u5f85\u6392", (String)"scheduledataList_14", (String)"mmc-mps-formplugin", (Object[])new Object[0]));
                    this.createOpLog(fieldsMapList, orgId, dynamicObject.getLong("id"), operatename, desc, operatenum);
                    continue;
                }
                if (abnormal || "A".equals(schedustatus) || "C".equals(schedustatus)) continue;
                dynamicObject.set("schedustatus", (Object)"A");
                dynamicObject.set("returndate", null);
                dynamicObject.set("returnreason", (Object)"");
                dnyList.add(dynamicObject);
                desc = String.format(ResManager.loadKDString((String)"\u5f85\u6392\u4ea7\u8ba1\u5212\u5355\uff1a%1$s\u6807\u6ce8\u6210\u529f\uff0c\u6807\u6ce8\u72b6\u6001\uff1a%2$s\u3002", (String)"scheduledataList_12", (String)"mmc-mps-formplugin", (Object[])new Object[0]), number, ResManager.loadKDString((String)"\u5f85\u6392", (String)"scheduledataList_14", (String)"mmc-mps-formplugin", (Object[])new Object[0]));
                this.createOpLog(fieldsMapList, orgId, dynamicObject.getLong("id"), operatename, desc, operatenum);
                continue;
            }
            if ("2".equals(radiogroupfield)) {
                boolean access = dynamicObject.getBoolean("access");
                if (access || !"A".equals(schedustatus)) continue;
                dynamicObject.set("schedustatus", (Object)"C");
                dynamicObject.set("returndate", (Object)new Date());
                dynamicObject.set("returnreason", renturnreason);
                dnyList.add(dynamicObject);
                continue;
            }
            if (!"3".equals(radiogroupfield) || "B".equals(schedustatus)) continue;
            dynamicObject.set("schedustatus", (Object)"B");
            dnyList.add(dynamicObject);
            String desc = String.format(ResManager.loadKDString((String)"\u5f85\u6392\u4ea7\u8ba1\u5212\u5355\uff1a%1$s\u6807\u6ce8\u6210\u529f\uff0c\u6807\u6ce8\u72b6\u6001\uff1a%2$s\u3002", (String)"scheduledataList_12", (String)"mmc-mps-formplugin", (Object[])new Object[0]), number, ResManager.loadKDString((String)"\u5173\u95ed", (String)"scheduledataList_16", (String)"mmc-mps-formplugin", (Object[])new Object[0]));
            this.createOpLog(fieldsMapList, orgId, dynamicObject.getLong("id"), operatename, desc, operatenum);
        }
        ArrayList<String> errorList = new ArrayList<String>(8);
        if (dnyList.size() != 0) {
            if ("2".equals(radiogroupfield)) {
                HashMap dataToorder = new HashMap(8);
                HashMap<Long, DynamicObject> idToorder = new HashMap<Long, DynamicObject>(8);
                HashMap<Long, String> map = new HashMap<Long, String>(8);
                for (DynamicObject o : dnyList) {
                    HashSet<Long> longs;
                    Long orderpoolid = o.getLong("orderpoolid");
                    if (orderpoolid == null || orderpoolid == 0L) continue;
                    String returnreason = o.getString("returnreason");
                    map.put(orderpoolid, returnreason);
                    if (dataToorder.containsKey(orderpoolid)) {
                        longs = (HashSet<Long>)dataToorder.get(orderpoolid);
                        longs.add(o.getLong("id"));
                    } else {
                        longs = new HashSet<Long>(8);
                        longs.add(o.getLong("id"));
                        dataToorder.put(orderpoolid, longs);
                    }
                    idToorder.put(o.getLong("id"), o);
                }
                if (map.size() != 0) {
                    ArrayList<Long> orderPoolIds = new ArrayList<Long>(8);
                    Map longStringMap = MPSScheduleUtils.writeOrderPool_return(map);
                    if (longStringMap.size() != 0) {
                        for (Map.Entry mapEntry : longStringMap.entrySet()) {
                            Long key = (Long)mapEntry.getKey();
                            Set longs = (Set)dataToorder.get(key);
                            if (longs == null) continue;
                            orderPoolIds.add(key);
                        }
                        for (Map.Entry mapEntry : dataToorder.entrySet()) {
                            String desc;
                            DynamicObject dynamicObject;
                            Long orderpoolId = (Long)mapEntry.getKey();
                            Set value = (Set)mapEntry.getValue();
                            if (orderPoolIds.contains(orderpoolId)) {
                                for (Long id : value) {
                                    dynamicObject = (DynamicObject)idToorder.get(id);
                                    dnyList.remove(dynamicObject);
                                    desc = String.format(ResManager.loadKDString((String)"\u5f85\u6392\u4ea7\u8ba1\u5212\u5355\uff1a%1$s\u6807\u6ce8\u5931\u8d25\uff0c\u6807\u6ce8\u72b6\u6001\uff1a%2$s\u3002\u539f\u56e0\uff1a%3$s", (String)"scheduledataList_35", (String)"mmc-mps-formplugin", (Object[])new Object[0]), dynamicObject.getString("number"), ResManager.loadKDString((String)"\u9000\u56de", (String)"scheduledataList_15", (String)"mmc-mps-formplugin", (Object[])new Object[0]), longStringMap.get(orderpoolId));
                                    errorList.add(desc);
                                }
                                continue;
                            }
                            for (Long id : value) {
                                dynamicObject = (DynamicObject)idToorder.get(id);
                                desc = String.format(ResManager.loadKDString((String)"\u5f85\u6392\u4ea7\u8ba1\u5212\u5355\uff1a%1$s\u6807\u6ce8\u6210\u529f\uff0c\u6807\u6ce8\u72b6\u6001\uff1a%2$s\u3002", (String)"scheduledataList_12", (String)"mmc-mps-formplugin", (Object[])new Object[0]), dynamicObject.getString("number"), ResManager.loadKDString((String)"\u9000\u56de", (String)"scheduledataList_15", (String)"mmc-mps-formplugin", (Object[])new Object[0]));
                                this.createOpLog(fieldsMapList, dynamicObject.getDynamicObject("org").getLong("id"), dynamicObject.getLong("id"), operatename, desc, operatenum);
                            }
                        }
                    }
                }
            }
            SaveServiceHelper.save((DynamicObject[])dnyList.toArray(new DynamicObject[0]));
            OperateLogHelper.genOperateLog(fieldsMapList);
        }
        if (dnyList.size() != scheduledata.length) {
            if ("1".equals(radiogroupfield)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u6709\u5173\u95ed\u4e14\u5f02\u5e38=\u5426\u624d\u80fd\u6539\u6210\u201c\u5f85\u6392\u201d\u3002", (String)"scheduledataList_8", (String)"mmc-mps-formplugin", (Object[])new Object[0]));
            } else if ("2".equals(radiogroupfield)) {
                StringBuilder sb = new StringBuilder();
                if (errorList.size() != 0) {
                    for (String s : errorList) {
                        sb.append(s).append("\n");
                    }
                    this.getView().showTipNotification(sb.toString());
                } else {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u6709\u5f85\u6392\u72b6\u6001\u548c\u51c6\u5165\u72b6\u6001=\u5426\u624d\u80fd\u6539\u6210\u201c\u9000\u56de\u201d\u3002", (String)"scheduledataList_9", (String)"mmc-mps-formplugin", (Object[])new Object[0]));
                }
            } else if ("3".equals(radiogroupfield)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u6709\u5f85\u6392\u548c\u9000\u56de\u72b6\u6001\u624d\u80fd\u6539\u6210\u201c\u5173\u95ed\u201d\u3002", (String)"scheduledataList_10", (String)"mmc-mps-formplugin", (Object[])new Object[0]));
            }
        } else {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u72b6\u6001\u6807\u6ce8\u6210\u529f\u3002", (String)"scheduledataList_11", (String)"mmc-mps-formplugin", (Object[])new Object[0]));
        }
        this.getView().invokeOperation("refresh");
    }

    private void appointWorkcenterOrDate(Object returnData) {
        ArrayList<Map<String, Object>> fieldsMapList = new ArrayList<Map<String, Object>>(16);
        List idList = (List)SerializationUtils.deSerializeFromBase64((String)this.getPageCache().get("idList"));
        Map returnMessage = (Map)SerializationUtils.deSerializeFromBase64((String)returnData.toString());
        Object workcenter = null;
        if (returnMessage.containsKey("workcenter")) {
            workcenter = returnMessage.get("workcenter");
        }
        Object date = null;
        if (returnMessage.containsKey("date")) {
            date = returnMessage.get("date");
        }
        DynamicObject[] scheduledata = BusinessDataServiceHelper.load((String)MPS_SCHEDULEDATA, (String)"workcentre,totalworkcentre,scheduledate,number,schedustatus,abnormal,org", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)idList)});
        ArrayList<DynamicObject> dnyList = new ArrayList<DynamicObject>(scheduledata.length);
        Map orgWorkcenter = WorkcentreUtils.getOrgWorkcenter();
        for (DynamicObject dynamicObject : scheduledata) {
            long orgId = dynamicObject.getDynamicObject("org").getLong("id");
            String number = dynamicObject.getString("number");
            String schedustatus = dynamicObject.getString("schedustatus");
            boolean abnormal = dynamicObject.getBoolean("abnormal");
            if (!"A".equals(schedustatus) || abnormal) continue;
            if (workcenter != null) {
                dynamicObject.set("workcentre", workcenter);
                Long totalWorkcenter = WorkcentreUtils.getTotalWorkcenter((Map)orgWorkcenter, (Long)workcenter, (Long)orgId);
                if (totalWorkcenter != null) {
                    dynamicObject.set("totalworkcentre", (Object)totalWorkcenter);
                } else {
                    dynamicObject.set("totalworkcentre", workcenter);
                }
            }
            if (date != null) {
                dynamicObject.set("scheduledate", date);
            }
            String desc = String.format(ResManager.loadKDString((String)"\u5f85\u6392\u4ea7\u8ba1\u5212\u5355\uff1a%1$s\u6307\u5b9a\u6210\u529f", (String)"scheduledataList_37", (String)"mmc-mps-formplugin", (Object[])new Object[0]), number);
            this.createOpLog(fieldsMapList, orgId, dynamicObject.getLong("id"), ResManager.loadKDString((String)"\u6307\u5b9a", (String)"scheduledataList_19", (String)"mmc-mps-formplugin", (Object[])new Object[0]), desc, "appoint");
            dnyList.add(dynamicObject);
        }
        if (dnyList.size() != 0) {
            SaveServiceHelper.save((DynamicObject[])dnyList.toArray(new DynamicObject[0]));
            OperateLogHelper.genOperateLog(fieldsMapList);
        }
        if (dnyList.size() != scheduledata.length) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u6709\u5f85\u6392\u72b6\u6001\u4e14\u5f02\u5e38=\u5426\u624d\u80fd\u6307\u5b9a\u3002", (String)"scheduledataList_17", (String)"mmc-mps-formplugin", (Object[])new Object[0]));
        } else {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u6307\u5b9a\u6210\u529f\u3002", (String)"scheduledataList_18", (String)"mmc-mps-formplugin", (Object[])new Object[0]));
        }
        this.getView().invokeOperation("refresh");
    }

    private DynamicObject getPlanProgram() {
        ControlFilters controlFilters = this.getControlFilters();
        List filter = controlFilters.getFilter("org.id");
        Object o = filter.get(0);
        if (o == null || o.toString().isEmpty()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u751f\u4ea7\u7ec4\u7ec7\u3002", (String)"scheduledataList_2", (String)"mmc-mps-formplugin", (Object[])new Object[0]));
        }
        QFilter statusFilter = new QFilter("status", "=", (Object)Character.valueOf('C'));
        QFilter enableFilter = new QFilter("enable", "=", (Object)Character.valueOf('1'));
        DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"mps_setplangram", (String)"plangram", (QFilter[])new QFilter[]{new QFilter("org", "=", (Object)Long.parseLong(o.toString()))});
        if (dynamicObject == null) {
            QFilter isdefaultscheFilter;
            QFilter baseDataFilter = BaseDataServiceHelper.getBaseDataFilter((String)MPS_PROPLANSCHDEF, (Long)Long.parseLong(o.toString()));
            DynamicObjectCollection query = QueryServiceHelper.query((String)MPS_PROPLANSCHDEF, (String)"id, number, name", (QFilter[])new QFilter[]{baseDataFilter, isdefaultscheFilter = new QFilter("isdefaultsche", "=", (Object)Character.valueOf('1'))});
            if (query == null || query.size() == 0) {
                DynamicObjectCollection query_other = QueryServiceHelper.query((String)MPS_PROPLANSCHDEF, (String)"id, number, name", (QFilter[])new QFilter[]{new QFilter("ctrlstrategy", "=", (Object)"5").and("isdefaultsche", "=", (Object)Character.valueOf('1')), statusFilter, enableFilter});
                if (query_other == null || query_other.size() == 0 || query_other.size() > 1) {
                    return null;
                }
                return (DynamicObject)query_other.get(0);
            }
            return (DynamicObject)query.get(0);
        }
        long planprogramid = dynamicObject.getLong("plangram");
        QFilter idFilter = new QFilter("id", "=", (Object)planprogramid);
        DynamicObject planprogram = QueryServiceHelper.queryOne((String)MPS_PROPLANSCHDEF, (String)"id, number, name", (QFilter[])new QFilter[]{statusFilter, enableFilter, idFilter});
        return planprogram;
    }

    private DynamicObject createNewLog(DynamicObject planprogram, DynamicObject productOrg) {
        DynamicObject caculateLog = ORM.create().newDynamicObject(MRP_CACULATE_LOG);
        Long id = ORM.create().genLongId(MRP_CACULATE_LOG);
        caculateLog.set("id", (Object)id);
        String number = CodeRuleServiceHelper.getNumber((String)MRP_CACULATE_LOG, (DynamicObject)caculateLog, (String)productOrg.getString("id"));
        caculateLog.set("number", (Object)number);
        caculateLog.set("createorg", (Object)productOrg);
        caculateLog.set("useorg", (Object)productOrg);
        caculateLog.set("plantype", (Object)"MPS");
        caculateLog.set("plangram", (Object)planprogram.getLong("id"));
        caculateLog.set("programname", (Object)planprogram.getString("name"));
        caculateLog.set("programnumber", (Object)planprogram.getString("number"));
        caculateLog.set("plangramentity", (Object)MPS_PROPLANSCHDEF);
        caculateLog.set("plandate", (Object)new Date());
        caculateLog.set("creator", (Object)RequestContext.get().getUserId());
        caculateLog.set("operatmode", (Object)this.getView().getFormShowParameter().getFormName());
        caculateLog.set("operatmodekey", (Object)"mps_scheduleplan_branch");
        caculateLog.set("calculatestatus", (Object)"D");
        caculateLog.set("startdate", (Object)new Date());
        caculateLog.set("ctrlstrategy", (Object)"7");
        caculateLog.set("isllc", (Object)Boolean.FALSE);
        caculateLog.set("isbomcheck", (Object)Boolean.FALSE);
        caculateLog.set("isallowdateinpast", (Object)Boolean.FALSE);
        caculateLog.set("iscommon", (Object)Boolean.FALSE);
        caculateLog.set("iscustomize", (Object)Boolean.FALSE);
        caculateLog.set("isselection", (Object)Boolean.FALSE);
        caculateLog.set("isnotsetup", (Object)Boolean.FALSE);
        caculateLog.set("runtype", (Object)"MPS");
        if (number == null) {
            caculateLog.set("number", (Object)id.toString());
        }
        ORM.create().save(caculateLog);
        BaseDataServiceHelper.clearCache((DynamicObject)caculateLog);
        return caculateLog;
    }

    private void createOpLog(List<Map<String, Object>> fieldsMapList, Long orgId, Long entityId, String operatename, String desc, String operatenum) {
        HashMap<String, Object> logMap = new HashMap<String, Object>(6);
        logMap.put("createorg", orgId);
        logMap.put("operateentity", MPS_SCHEDULEDATA);
        logMap.put("operatenum", operatenum);
        logMap.put("operatename", operatename);
        logMap.put("operatedesc", desc);
        logMap.put("opentityid", entityId);
        fieldsMapList.add(logMap);
    }
}

