/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mps;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.datatype.BigDecimalType;
import kd.bos.algo.datatype.DateType;
import kd.bos.algo.datatype.LongType;
import kd.bos.algo.datatype.StringType;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.AbstractReportListDataPlugin;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.mmc.mps.calcnode.MPSBranchingCalculate;
import kd.mmc.mps.calcnode.MPSGetBrachingData;
import kd.mmc.mps.calcnode.MPSInitReduOrder;
import kd.mmc.mps.calcnode.MpsMatchDimension;
import kd.mmc.mps.common.util.MPSScheduleUtils;
import kd.mmc.mps.common.util.ReportQueryUtils;
import kd.mmc.mps.mservice.api.DowmTimePlanService;
import kd.mpscmm.msplan.mservice.service.datafetch.model.FetchDataQueryModule;
import kd.mpscmm.msplan.mservice.service.datafetch.util.DataSourceFetchDataUtil;
import org.apache.commons.lang3.time.DateUtils;

public class CapacityScheduReportDetailQuery
extends AbstractReportListDataPlugin {
    private static final Log log = LogFactory.getLog(CapacityScheduReportDetailQuery.class);
    private static String[] field = new String[]{"year", "workcenter_r", "group_r", "sourcenumber", "billstatus", "materiel", "date", "configure", "tracknumber", "download", "planlaod", "allload", "ratecapacity", "morecapacity", "morecapacity_num", "actresource", "ratecapacitytype", "rowseq", "sourcerowseq", "number", "sourcetype"};
    private static DataType[] dataType = new DataType[]{new StringType(), new LongType(), new LongType(), new StringType(), new StringType(), new LongType(), new DateType(), new LongType(), new LongType(), new BigDecimalType(), new BigDecimalType(), new BigDecimalType(), new BigDecimalType(), new StringType(), new BigDecimalType(), new LongType(), new StringType(), new StringType(), new StringType(), new StringType(), new StringType()};

    public DataSet query(ReportQueryParam reportQueryParam, Object o) throws Throwable {
        String capacalcway;
        Map customParam;
        FilterInfo filterInfo = reportQueryParam.getFilter();
        DynamicObject org = filterInfo.getDynamicObject("org");
        DynamicObject queryplan = filterInfo.getDynamicObject("queryplan");
        String timeunit = filterInfo.getDynamicObject("timeunit").getString("number");
        Date filterEndDate = filterInfo.getDate("enddate");
        Date filterbeginDate = filterInfo.getDate("begindate");
        ArrayList<Long> workcenterList = new ArrayList<Long>(8);
        DynamicObjectCollection workcenters = filterInfo.getDynamicObjectCollection("workcenter");
        if (workcenters != null) {
            for (DynamicObject dynamicObject : workcenters) {
                workcenterList.add(dynamicObject.getLong("id"));
            }
        }
        ArrayList<Long> groupsList = new ArrayList<Long>(8);
        DynamicObjectCollection groups = filterInfo.getDynamicObjectCollection("group");
        if (groups != null) {
            for (DynamicObject dynamicObject : groups) {
                groupsList.add(dynamicObject.getLong("id"));
            }
        }
        ArrayList<Long> actresourceList = new ArrayList<Long>(8);
        DynamicObjectCollection actresources = filterInfo.getDynamicObjectCollection("actresource_query");
        if (actresources != null) {
            for (DynamicObject dynamicObject : actresources) {
                actresourceList.add(dynamicObject.getLong("id"));
            }
        }
        if ((customParam = reportQueryParam.getCustomParam()) != null && customParam.size() != 0 && customParam.containsKey("workcenter")) {
            workcenterList.add(0L);
            if (customParam != null && customParam.size() != 0 && customParam.containsKey("actresource")) {
                actresourceList.add(0L);
            }
            reportQueryParam.setCustomParam(new HashMap(8));
        } else {
            if (customParam != null && customParam.size() != 0 && customParam.containsKey("actresource")) {
                actresourceList.add(0L);
            }
            reportQueryParam.setCustomParam(new HashMap(8));
        }
        ArrayList<Long> datasourcesList = new ArrayList<Long>(8);
        DynamicObjectCollection datasources = filterInfo.getDynamicObjectCollection("datasource");
        if (datasources != null) {
            for (DynamicObject dynamicObject : datasources) {
                datasourcesList.add(dynamicObject.getLong("id"));
            }
        }
        if ((capacalcway = queryplan.getString("capacalcway")).isEmpty()) {
            capacalcway = "A";
        }
        DataSet dataSet_sort = null;
        dataSet_sort = "A".equals(capacalcway) ? this.dayCapaQuery(org, queryplan, workcenterList, datasourcesList, filterbeginDate, filterEndDate, groupsList) : this.workingHoursQuery(org, queryplan, workcenterList, datasourcesList, filterbeginDate, filterEndDate, actresourceList);
        if (dataSet_sort != null) {
            if ("A".equals(capacalcway)) {
                return dataSet_sort;
            }
            Long unitId = filterInfo.getDynamicObject("timeunit").getLong("id");
            DataSet dataSet_addunit = dataSet_sort.addField(unitId.toString(), "unit");
            DataSet dataSet = ReportQueryUtils.timeCov((DataSet)dataSet_addunit, (String)timeunit);
            return dataSet;
        }
        RowMeta rowMeta = new RowMeta(field, dataType);
        Algo algo = Algo.create((String)"scm");
        ArrayList dataSetValue = new ArrayList(16);
        dataSet_sort = algo.createDataSet(dataSetValue, rowMeta);
        return dataSet_sort;
    }

    private DataSet workingHoursQuery(DynamicObject org, DynamicObject queryplan, List<Long> workcenterList, List<Long> datasourcesList, Date filterbeginDate, Date filterEndDate, List<Long> actresourceList) {
        StringBuilder tipMessage = new StringBuilder();
        HashMap<Long, BigDecimal> workshiftTime = new HashMap<Long, BigDecimal>(16);
        Map planWorkCenter = ReportQueryUtils.getPlanWorkCenter((DynamicObject)queryplan, workshiftTime, (StringBuilder)tipMessage);
        Map workcenterToworkDayByRange = MPSScheduleUtils.getWorkDayByRange((Date)filterbeginDate, (Date)filterEndDate, (Map)planWorkCenter);
        DataSet assignedData_nofilterTime = this.getAssignedData_nofilterTime_work(org, queryplan, datasourcesList);
        DataSet assignedData = this.getAssignedData_work(org, queryplan, filterbeginDate, filterEndDate, datasourcesList);
        DataSet planData = this.getPlanData(org, queryplan, filterbeginDate, filterEndDate, datasourcesList);
        DataSet routeData = ReportQueryUtils.getRouteData((DynamicObject)queryplan, actresourceList);
        DataSet resoureData = ReportQueryUtils.getResoureData((DynamicObject)queryplan);
        List planDataMessage = MPSScheduleUtils.getScheduleOrder((DataSet)planData);
        List assignedDataMessage = MPSScheduleUtils.getScheduleOrder((DataSet)assignedData);
        HashMap routeId = new HashMap(16);
        MPSInitReduOrder mpsInitReduOrder = new MPSInitReduOrder();
        List initReduOrder = mpsInitReduOrder.getInitReduOrderByReport(assignedData_nofilterTime, new HashMap(16), new HashMap(16));
        MpsMatchDimension mpsMatchDimension = new MpsMatchDimension();
        Set allField = mpsMatchDimension.getAllField(initReduOrder, queryplan);
        Map dimensionByReport = mpsMatchDimension.getDimensionByReport(initReduOrder, queryplan, planDataMessage);
        HashMap routeIdToDateRange = new HashMap(16);
        ReportQueryUtils.reduceNum((List)planDataMessage, (Map)dimensionByReport, (Set)allField);
        List routeDataMessage = ReportQueryUtils.getRouteOrder((DataSet)routeData, routeId, (String)"route", routeIdToDateRange);
        List resoureDataMessage = ReportQueryUtils.getRouteOrder((DataSet)resoureData, routeId, (String)"resource", routeIdToDateRange);
        HashMap workcenterToresourceToQty = new HashMap(16);
        Map measureunits = ReportQueryUtils.getMeasureunits();
        ArrayList<Map<String, Object>> planDataMessage_qty = new ArrayList(16);
        List assignedDataMessage_qty = new ArrayList(16);
        if ("B".equals(queryplan.getString("routerule"))) {
            DynamicObject arrangedmatchitem = queryplan.getDynamicObject("arrangedmatchitem");
            Map matchItem = mpsMatchDimension.getMatchItem(arrangedmatchitem);
            Map routeIdToCreatTime = ReportQueryUtils.getRouteCreatTime(routeId.keySet());
            Map matcthItemRoute = ReportQueryUtils.getMatcthItemRoute((Map)matchItem, (List)routeDataMessage, (Map)routeIdToCreatTime);
            ReportQueryUtils.getRouteByMatchItem((List)planDataMessage, (Map)matcthItemRoute, routeId, (Map)matchItem, (StringBuilder)tipMessage);
            DynamicObject routematchitem = queryplan.getDynamicObject("routematchitem");
            Map matchItem_dim = mpsMatchDimension.getMatchItem(routematchitem);
            ReportQueryUtils.getRouteByMatchItem((List)assignedDataMessage, (Map)matcthItemRoute, routeId, (Map)matchItem_dim, (StringBuilder)tipMessage);
            planDataMessage_qty = ReportQueryUtils.resourceDataFill_Detail((List)planDataMessage, (Map)planWorkCenter, (Map)measureunits, (String)"plan");
            assignedDataMessage_qty = ReportQueryUtils.resourceDataFill_Detail((List)assignedDataMessage, (Map)planWorkCenter, (Map)measureunits, (String)"assigned");
        } else {
            List planDataMessage_route = ReportQueryUtils.getRoute((List)planDataMessage, (DynamicObject)org, routeId, (StringBuilder)tipMessage, routeIdToDateRange);
            List assignedDataMessage_route = ReportQueryUtils.getRoute((List)assignedDataMessage, (DynamicObject)org, routeId, (StringBuilder)tipMessage, routeIdToDateRange);
            planDataMessage_qty = ReportQueryUtils.resourceDataFill_Detail((List)planDataMessage_route, (Map)planWorkCenter, (Map)measureunits, (String)"plan");
            assignedDataMessage_qty = ReportQueryUtils.resourceDataFill_Detail((List)assignedDataMessage_route, (Map)planWorkCenter, (Map)measureunits, (String)"assigned");
        }
        Map resoureQty = ReportQueryUtils.getResoureQty((List)resoureDataMessage, (Map)planWorkCenter, (Date)filterbeginDate, (Date)filterEndDate, workshiftTime, (Map)workcenterToworkDayByRange, workcenterToresourceToQty);
        ArrayList<Map<String, Object>> signToDataList = new ArrayList<Map<String, Object>>(16);
        Map<String, Map<Long, Map<String, Map<String, Object>>>> downTimePlan = this.getDownTimePlan(queryplan);
        if (downTimePlan == null) {
            downTimePlan = new HashMap<String, Map<Long, Map<String, Map<String, Object>>>>(16);
        }
        this.putDownloadQtyToMap(assignedDataMessage_qty, signToDataList, actresourceList);
        this.putPlanloadQtyToMap(planDataMessage_qty, signToDataList, actresourceList);
        this.putResourceToMap(signToDataList, resoureQty, workshiftTime, planWorkCenter, workcenterToworkDayByRange, downTimePlan, org);
        List<Object[]> dataSetValue = this.getListObject(signToDataList, new ArrayList<Map<String, Object>>(16));
        RowMeta rowMeta = new RowMeta(field, dataType);
        Algo algo = Algo.create((String)"scm");
        DataSet dataSet = algo.createDataSet(dataSetValue, rowMeta);
        DataSet dataSet_sort = dataSet.orderBy(new String[]{"date"});
        DataSet dataSet_filter = ReportQueryUtils.filterWorkCenter(workcenterList, (DataSet)dataSet_sort, actresourceList);
        return dataSet_filter;
    }

    private void putResourceToMap(List<Map<String, Object>> signToData, Map<Long, Map<Long, Map<Long, BigDecimal>>> resoureQty, Map<Long, BigDecimal> workshiftTime, Map<Long, Object[]> planWorkCenter, Map<Long, Map<Long, String>> workcenterToworkDayByRange, Map<String, Map<Long, Map<String, Map<String, Object>>>> downTimePlan, DynamicObject org) {
        for (Map<String, Object> message : signToData) {
            BigDecimal multiply;
            BigDecimal downTime;
            BigDecimal downQty;
            Object times;
            Object qty;
            Map<String, Object> dowmtimeMessage;
            Map<String, Map<String, Object>> detailMessage;
            Map<Long, Map<String, Map<String, Object>>> dateTodetailMessage;
            Long time;
            String s;
            Map<Long, String> workDayByRange;
            Object sheduledate = message.get("date");
            Object workcenter = message.get("workcenter_r");
            if (workcenter == null) continue;
            Object actresource = message.get("actresource");
            Map<Long, Map<Long, BigDecimal>> dateToResoucescapacity = resoureQty.get(workcenter);
            if (sheduledate instanceof Date && (workDayByRange = workcenterToworkDayByRange.get(workcenter)) != null && "4".equals(s = workDayByRange.get(time = Long.valueOf(((Date)sheduledate).getTime())))) continue;
            int year = (Integer)message.get("year");
            if (dateToResoucescapacity == null) {
                if (actresource != null && !actresource.equals(0L)) {
                    log.info("dateToResoucescapacity");
                    message.put("ratecapacity", BigDecimal.ZERO);
                    continue;
                }
                Object workshift = planWorkCenter.get(workcenter)[0];
                BigDecimal timeToHour = workshiftTime.get(workshift);
                if (timeToHour == null) continue;
                BigDecimal allCapatity = timeToHour.multiply(new BigDecimal(3600));
                String downKey = workcenter + "," + actresource + "," + org.getLong("id");
                dateTodetailMessage = downTimePlan.get(downKey);
                if (dateTodetailMessage != null && (detailMessage = dateTodetailMessage.get(((Date)sheduledate).getTime())) != null) {
                    for (Map.Entry<String, Map<String, Object>> mapEntry_detail : detailMessage.entrySet()) {
                        dowmtimeMessage = mapEntry_detail.getValue();
                        qty = dowmtimeMessage.get("qty");
                        times = dowmtimeMessage.get("time");
                        downQty = BigDecimal.ZERO;
                        downTime = BigDecimal.ZERO;
                        if (qty != null) {
                            downQty = new BigDecimal(qty.toString());
                        }
                        if (times != null) {
                            downTime = new BigDecimal(times.toString());
                        }
                        if ((allCapatity = allCapatity.subtract(multiply = downQty.multiply(downTime))).compareTo(BigDecimal.ZERO) >= 0) continue;
                        allCapatity = BigDecimal.ZERO;
                    }
                }
                message.put("ratecapacity", allCapatity);
                continue;
            }
            BigDecimal allCapatity = BigDecimal.ZERO;
            Map<Long, BigDecimal> resouceCapacity = dateToResoucescapacity.get(((Date)sheduledate).getTime());
            if (resouceCapacity == null) {
                Map<String, Map<String, Object>> detailMessage2;
                if (actresource != null && !actresource.equals(0L)) {
                    message.put("ratecapacity", BigDecimal.ZERO);
                    continue;
                }
                Object workshift = planWorkCenter.get(workcenter)[0];
                BigDecimal timeToHour = workshiftTime.get(workshift);
                if (timeToHour == null) continue;
                allCapatity = timeToHour.multiply(new BigDecimal(3600));
                String downKey = workcenter + "," + actresource + "," + org.getLong("id");
                Map<Long, Map<String, Map<String, Object>>> dateTodetailMessage2 = downTimePlan.get(downKey);
                if (dateTodetailMessage2 != null && (detailMessage2 = dateTodetailMessage2.get(((Date)sheduledate).getTime())) != null) {
                    Map.Entry<String, Map<String, Object>> mapEntry_detail;
                    mapEntry_detail = detailMessage2.entrySet().iterator();
                    while (mapEntry_detail.hasNext()) {
                        BigDecimal multiply2;
                        Map.Entry mapEntry_detail2 = (Map.Entry)mapEntry_detail.next();
                        Map dowmtimeMessage2 = (Map)mapEntry_detail2.getValue();
                        Object qty2 = dowmtimeMessage2.get("qty");
                        Object times2 = dowmtimeMessage2.get("time");
                        BigDecimal downQty2 = BigDecimal.ZERO;
                        BigDecimal downTime2 = BigDecimal.ZERO;
                        if (qty2 != null) {
                            downQty2 = new BigDecimal(qty2.toString());
                        }
                        if (times2 != null) {
                            downTime2 = new BigDecimal(times2.toString());
                        }
                        if ((allCapatity = allCapatity.subtract(multiply2 = downQty2.multiply(downTime2))).compareTo(BigDecimal.ZERO) >= 0) continue;
                        allCapatity = BigDecimal.ZERO;
                    }
                }
                message.put("ratecapacity", allCapatity);
                continue;
            }
            BigDecimal capacity = resouceCapacity.get(actresource);
            if (capacity != null) {
                int year_date;
                if (sheduledate == null || (year_date = ((Date)sheduledate).getYear() + 1900) != year) continue;
                allCapatity = allCapatity.add(capacity);
            } else {
                if (actresource != null && !actresource.equals(0L)) {
                    message.put("ratecapacity", BigDecimal.ZERO);
                    continue;
                }
                Object workshift = planWorkCenter.get(workcenter)[0];
                BigDecimal timeToHour = workshiftTime.get(workshift);
                if (timeToHour != null) {
                    allCapatity = timeToHour.multiply(new BigDecimal(3600));
                }
            }
            String downKey = workcenter + "," + actresource + "," + org.getLong("id");
            if (downTimePlan == null) {
                downTimePlan = new HashMap<String, Map<Long, Map<String, Map<String, Object>>>>(16);
            }
            if ((dateTodetailMessage = downTimePlan.get(downKey)) != null && (detailMessage = dateTodetailMessage.get(((Date)sheduledate).getTime())) != null) {
                for (Map.Entry<String, Map<String, Object>> mapEntry_detail : detailMessage.entrySet()) {
                    dowmtimeMessage = mapEntry_detail.getValue();
                    qty = dowmtimeMessage.get("qty");
                    times = dowmtimeMessage.get("time");
                    downQty = BigDecimal.ZERO;
                    downTime = BigDecimal.ZERO;
                    if (qty != null) {
                        downQty = new BigDecimal(qty.toString());
                    }
                    if (times != null) {
                        downTime = new BigDecimal(times.toString());
                    }
                    if ((allCapatity = allCapatity.subtract(multiply = downQty.multiply(downTime))).compareTo(BigDecimal.ZERO) >= 0) continue;
                    allCapatity = BigDecimal.ZERO;
                }
            }
            message.put("ratecapacity", allCapatity);
        }
    }

    public Map<String, Map<Long, Map<String, Map<String, Object>>>> getDownTimePlan(DynamicObject queryplan) {
        String haltschedule = queryplan.getString("haltschedule");
        if (haltschedule == null || haltschedule.isEmpty()) {
            return null;
        }
        try {
            Class<?> localStepClass = Class.forName(haltschedule);
            Object inst = localStepClass.newInstance();
            if (inst instanceof DowmTimePlanService) {
                DowmTimePlanService localStep = (DowmTimePlanService)inst;
                Map downTimeMessage = localStep.getWorkCenterDateTimes();
                return downTimeMessage;
            }
            throw new KDBizException("wrong impl");
        }
        catch (Throwable e) {
            throw new KDBizException("error");
        }
    }

    private void putPlanloadQtyToMap(List<Map<String, Object>> planDataMessage_qty, List<Map<String, Object>> signToData, List<Long> actresourceList) {
        for (Map<String, Object> map : planDataMessage_qty) {
            HashMap<String, Object> keyToData = new HashMap<String, Object>(16);
            Date sheduledate = (Date)map.get("requiredate");
            Long workcentre = (Long)map.get("workcenter");
            Object actresource = map.get("actresource");
            if (actresource == null) {
                actresource = 0L;
            }
            if (actresourceList.size() != 0 && !actresourceList.contains(actresource)) continue;
            int year = sheduledate.getYear() + 1900;
            Object baseqty = map.get("baseqty");
            keyToData.put("year", year);
            keyToData.put("group_r", map.get("group"));
            keyToData.put("number", map.get("plan_order_billno"));
            keyToData.put("billstatus", "C");
            keyToData.put("materiel", map.get("materiel_code"));
            keyToData.put("date", sheduledate);
            keyToData.put("configure", map.get("configure"));
            keyToData.put("tracknumber", map.get("tracknumber"));
            keyToData.put("workcenter_r", workcentre);
            keyToData.put("actresource", actresource);
            keyToData.put("ratecapacitytype", "B");
            keyToData.put("sourcetype", map.get("billtype"));
            BigDecimal plsqty = (BigDecimal)map.get("lastqty");
            keyToData.put("planlaod", plsqty);
            BigDecimal allload = plsqty;
            if (keyToData.containsKey("allload")) {
                BigDecimal allload_all = (BigDecimal)keyToData.get("allload");
                allload = allload.add(allload_all);
            }
            keyToData.put("allload", allload);
            keyToData.put("rowseq", map.get("billentryno"));
            keyToData.put("sourcerowseq", map.get("sourcebillentryno"));
            keyToData.put("billno", map.get("billno"));
            signToData.add(keyToData);
        }
    }

    private void putDownloadQtyToMap(List<Map<String, Object>> assignedDataMessage_qty, List<Map<String, Object>> signData, List<Long> actresourceList) {
        for (Map<String, Object> map : assignedDataMessage_qty) {
            Date sheduledate = (Date)map.get("pls_date");
            Long workcentre = (Long)map.get("workcenter");
            Object actresource = map.get("actresource");
            if (actresourceList.size() != 0 && !actresourceList.contains(actresource)) continue;
            int year = sheduledate.getYear() + 1900;
            HashMap<String, Object> keyToData = new HashMap<String, Object>(16);
            BigDecimal plsqty = (BigDecimal)map.get("lastqty");
            keyToData.put("year", year);
            keyToData.put("number", map.get("plan_order_billno"));
            keyToData.put("ratecapacitytype", "B");
            keyToData.put("materiel", map.get("materiel_code"));
            keyToData.put("date", sheduledate);
            keyToData.put("configure", map.get("configure"));
            keyToData.put("tracknumber", map.get("tracknumber"));
            keyToData.put("workcenter_r", workcentre);
            keyToData.put("sheduledate", sheduledate);
            keyToData.put("download", plsqty);
            keyToData.put("allload", plsqty);
            keyToData.put("actresource", actresource);
            keyToData.put("rowseq", map.get("billentryno"));
            keyToData.put("sourcerowseq", map.get("sourcebillentryno"));
            keyToData.put("billno", map.get("billno"));
            keyToData.put("sourcetype", map.get("billtype"));
            signData.add(keyToData);
        }
    }

    private DataSet dayCapaQuery(DynamicObject org, DynamicObject queryplan, List<Long> workcenterList, List<Long> datasourcesList, Date filterbeginDate, Date filterEndDate, List<Long> groupsList) {
        HashMap<Long, Long> groupToWorkcenter = new HashMap<Long, Long>(16);
        HashMap<Long, Long> orderToGroup = new HashMap<Long, Long>(16);
        DataSet assignedData = this.getAssignedData(org, queryplan, filterbeginDate, filterEndDate, workcenterList, datasourcesList);
        DataSet assignedData_nofilterTime = this.getAssignedData_nofilterTime(org, queryplan, filterbeginDate, filterEndDate, workcenterList, datasourcesList);
        DataSet planData = this.getPlanData(org, queryplan, filterbeginDate, filterEndDate, datasourcesList);
        HashMap<Long, Long> orderToGroupMap = new HashMap<Long, Long>(16);
        HashMap<Long, Long> groupToWorkcenter_assgined = new HashMap<Long, Long>(16);
        HashMap<Long, Long> orderToGroupMap_assgined = new HashMap<Long, Long>(16);
        List<Map<String, Object>> dataMessageByReport = this.getGroupToWorkcenter(planData, queryplan, groupToWorkcenter, orderToGroupMap, true);
        List<Map<String, Object>> dataMessageByReport_nofilterTime = this.getGroupToWorkcenter(assignedData_nofilterTime, queryplan, groupToWorkcenter_assgined, orderToGroupMap_assgined, false);
        MPSInitReduOrder mpsInitReduOrder = new MPSInitReduOrder();
        List initReduOrder = mpsInitReduOrder.getInitReduOrderByReport(assignedData_nofilterTime, groupToWorkcenter_assgined, orderToGroupMap_assgined);
        MpsMatchDimension mpsMatchDimension = new MpsMatchDimension();
        Set allField = mpsMatchDimension.getAllField(initReduOrder, queryplan);
        Map dimensionByReport = mpsMatchDimension.getDimensionByReport(initReduOrder, queryplan, dataMessageByReport_nofilterTime);
        ArrayList<Map<String, Object>> signToDataList = new ArrayList<Map<String, Object>>(8);
        ArrayList<Map<String, Object>> signToData_noworkcenterList = new ArrayList<Map<String, Object>>(8);
        Map<String, Long> scheduDataWorkcenter = this.getScheduDataWorkcenter(dataMessageByReport);
        this.putDownloadNumToMap(assignedData, signToDataList, signToData_noworkcenterList, orderToGroup, groupsList, workcenterList);
        this.putPlanloadNumToMap(dataMessageByReport, signToDataList, signToData_noworkcenterList, workcenterList, groupsList, allField, dimensionByReport, scheduDataWorkcenter);
        Map<Long, Map<String, BigDecimal>> capacityMessage = this.getCapacityMessage(queryplan);
        this.putCapatityToMap(signToDataList, capacityMessage);
        List<Object[]> dataSetValue = this.getListObject(signToDataList, signToData_noworkcenterList);
        RowMeta rowMeta = new RowMeta(field, dataType);
        Algo algo = Algo.create((String)"scm");
        DataSet dataSet = algo.createDataSet(dataSetValue, rowMeta);
        DataSet dataSet_sort = dataSet.orderBy(new String[]{"date"});
        return dataSet_sort;
    }

    private Map<String, Long> getScheduDataWorkcenter(List<Map<String, Object>> dataMessageByReport) {
        HashSet<Long> sourceentryidList = new HashSet<Long>(16);
        HashSet<Integer> rowList = new HashSet<Integer>(16);
        for (Map<String, Object> map : dataMessageByReport) {
            Long sourceentryid = (Long)map.get("sourceentryid");
            Integer entryseq = (Integer)map.get("entryseq");
            if (sourceentryid != null && sourceentryid != 0L) {
                sourceentryidList.add(sourceentryid);
            }
            if (entryseq == null) continue;
            rowList.add(entryseq);
        }
        QFilter qFilter_id = new QFilter("sourceentryid", "in", sourceentryidList);
        QFilter qFilter_row = new QFilter("entryseq", "in", rowList);
        DataSet scheduleplanDataset = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"mps_scheduledata", (String)"id,sourceentryid,entryseq,workcentre", (QFilter[])new QFilter[]{qFilter_id, qFilter_row}, null);
        HashMap<String, Long> idSeqToWorkcenter = new HashMap<String, Long>(16);
        while (scheduleplanDataset.hasNext()) {
            Row next = scheduleplanDataset.next();
            Long sourceentryid = next.getLong("sourceentryid");
            Integer entryseq = next.getInteger("entryseq");
            Long workcentre = next.getLong("workcentre");
            String key = sourceentryid + "," + entryseq;
            idSeqToWorkcenter.put(key, workcentre);
        }
        return idSeqToWorkcenter;
    }

    private List<Object[]> getListObject(List<Map<String, Object>> signToData, List<Map<String, Object>> signToData_noworkcenter) {
        List<Object[]> objectList = this.getObjectValue(signToData);
        List<Object[]> objectList_noWorkCenter = this.getObjectValue(signToData_noworkcenter);
        objectList.addAll(objectList_noWorkCenter);
        return objectList;
    }

    private void assigedNumMatch(Map<String, BigDecimal> fieldToNum, Map<String, Object> orderMap, Set<String> allField) {
        BigDecimal num;
        StringBuilder stringBuilder = new StringBuilder();
        Object order_num = orderMap.get("order_num");
        BigDecimal ordernum = BigDecimal.ZERO;
        if (order_num != null) {
            ordernum = new BigDecimal(order_num.toString());
        }
        for (String field : allField) {
            Object o;
            if ("sourcebillid".equals(field)) {
                field = "sourcebillid_old";
            }
            if ((o = orderMap.get(field)) == null) {
                o = 0;
            }
            stringBuilder.append(o).append(",");
        }
        String key = "";
        if (stringBuilder.length() > 1) {
            key = stringBuilder.substring(0, stringBuilder.length() - 1);
        }
        if ((num = fieldToNum.get(key)) != null) {
            if (ordernum.compareTo(num) > 0) {
                orderMap.put("assigedNum", num);
                fieldToNum.put(key, BigDecimal.ZERO);
            } else {
                orderMap.put("assigedNum", ordernum);
                num = num.subtract(ordernum);
                fieldToNum.put(key, num);
            }
        }
    }

    private List<Object[]> getObjectValue(List<Map<String, Object>> signToData) {
        ArrayList<Object[]> objectList = new ArrayList<Object[]>(signToData.size());
        for (Map<String, Object> message : signToData) {
            if (message.get("allload") == null || ((BigDecimal)message.get("allload")).compareTo(BigDecimal.ZERO) == 0) continue;
            Object[] objects = new Object[21];
            objects[0] = message.get("year");
            objects[1] = message.get("workcenter_r");
            objects[2] = message.get("group_r");
            objects[3] = message.get("number");
            objects[4] = message.get("billstatus");
            objects[5] = message.get("materiel");
            objects[6] = message.get("date");
            objects[7] = message.get("configure");
            objects[8] = message.get("tracknumber");
            objects[9] = message.get("download");
            objects[10] = message.get("planlaod");
            objects[11] = message.get("allload");
            objects[12] = message.get("ratecapacity");
            objects[15] = message.get("actresource");
            objects[16] = message.get("ratecapacitytype");
            objects[17] = message.get("rowseq");
            objects[18] = message.get("sourcerowseq");
            objects[19] = message.get("billno");
            objects[20] = message.get("sourcetype");
            Object ratecapacity = message.get("ratecapacity");
            Object allload = message.get("allload");
            BigDecimal ratecapacity_b = BigDecimal.ZERO;
            if (ratecapacity != null) {
                ratecapacity_b = (BigDecimal)ratecapacity;
            }
            BigDecimal allload_b = BigDecimal.ZERO;
            if (allload != null) {
                allload_b = (BigDecimal)allload;
            }
            BigDecimal deveideNum = ratecapacity_b.compareTo(BigDecimal.ZERO) != 0 ? allload_b.divide(ratecapacity_b, 2, 0).multiply(new BigDecimal("100")) : new BigDecimal("999");
            objects[13] = deveideNum.compareTo(BigDecimal.ZERO) == 0 ? "0%" : deveideNum.toPlainString() + "%";
            objects[14] = deveideNum.compareTo(new BigDecimal(1000)) >= 0 ? new BigDecimal("999") : deveideNum;
            objectList.add(objects);
        }
        return objectList;
    }

    private void putCapatityToMap(List<Map<String, Object>> signToData, Map<Long, Map<String, BigDecimal>> capacityMessage) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
        for (Map<String, Object> message : signToData) {
            Long workcenter = (Long)message.get("workcenter_r");
            Date date = (Date)message.get("date");
            Map<String, BigDecimal> dateTocapacity = capacityMessage.get(workcenter);
            if (dateTocapacity == null) continue;
            String format = simpleDateFormat.format(date);
            BigDecimal allCapatity = dateTocapacity.get(format);
            message.put("ratecapacity", allCapatity);
        }
    }

    private Map<Long, Map<String, BigDecimal>> getCapacityMessage(DynamicObject queryplan) {
        DynamicObjectCollection query = QueryServiceHelper.query((String)"mps_proplanschdef", (String)"workentry.workcenter,workentry.productionrules,calendar,createorg,workentry.workcalendar", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)queryplan.getLong("id"))});
        HashMap<Long, Long> workcenterToProductionRules = new HashMap<Long, Long>(8);
        HashMap<Long, Map<String, BigDecimal>> workcenterMaxcapacityToDate = new HashMap<Long, Map<String, BigDecimal>>(8);
        HashMap<Long, Map> workcenterToworkDay = new HashMap<Long, Map>(8);
        if (query != null && query.size() != 0) {
            for (DynamicObject dynamicObject : query) {
                Long workcalendar = dynamicObject.getLong("workentry.workcalendar");
                Long workcenterId = dynamicObject.getLong("workentry.workcenter");
                if (!workcenterToworkDay.containsKey(workcenterId)) {
                    Map workDay = MPSScheduleUtils.getWorkDay((DynamicObject)dynamicObject, (Long)workcalendar);
                    workcenterToworkDay.put(workcenterId, workDay);
                }
                Long productionrulesId = dynamicObject.getLong("workentry.productionrules");
                workcenterToProductionRules.put(workcenterId, productionrulesId);
            }
        }
        HashMap<Long, Long> productionRulesToCapacity = new HashMap<Long, Long>(8);
        DynamicObjectCollection productionrules = QueryServiceHelper.query((String)"mps_productionrules", (String)"id,capacitydefinition", (QFilter[])new QFilter[]{new QFilter("id", "in", workcenterToProductionRules.values())});
        for (DynamicObject dynamicObject : productionrules) {
            Long id = dynamicObject.getLong("id");
            Long capacitydefinition = dynamicObject.getLong("capacitydefinition");
            productionRulesToCapacity.put(id, capacitydefinition);
        }
        DynamicObjectCollection capacitydef = QueryServiceHelper.query((String)"mps_capacitydef", (String)"capacitytype,workcenter,entryentity.maxcapacity,entryentity.startdate,entryentity.enddate", (QFilter[])new QFilter[]{new QFilter("id", "in", productionRulesToCapacity.values())});
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
        for (DynamicObject dynamicObject : capacitydef) {
            String s;
            String type = dynamicObject.getString("capacitytype");
            if (!"A".equals(type)) continue;
            Long workcenter = dynamicObject.getLong("workcenter");
            Map workDay = (Map)workcenterToworkDay.get(workcenter);
            HashMap<String, BigDecimal> maxcapacityToDate = (HashMap<String, BigDecimal>)workcenterMaxcapacityToDate.get(workcenter);
            BigDecimal maxcapacity = dynamicObject.getBigDecimal("entryentity.maxcapacity");
            Date startdate = dynamicObject.getDate("entryentity.startdate");
            Date enddate = dynamicObject.getDate("entryentity.enddate");
            if (maxcapacityToDate == null) {
                maxcapacityToDate = new HashMap<String, BigDecimal>(8);
                while (!enddate.before(startdate)) {
                    s = (String)workDay.get(startdate.getTime());
                    if (!"4".equals(s)) {
                        maxcapacityToDate.put(simpleDateFormat.format(startdate), maxcapacity);
                    }
                    startdate = DateUtils.addDays((Date)startdate, (int)1);
                }
                workcenterMaxcapacityToDate.put(workcenter, maxcapacityToDate);
                continue;
            }
            while (!enddate.before(startdate)) {
                s = (String)workDay.get(startdate.getTime());
                if (!"4".equals(s)) {
                    maxcapacityToDate.put(simpleDateFormat.format(startdate), maxcapacity);
                }
                startdate = DateUtils.addDays((Date)startdate, (int)1);
            }
        }
        return workcenterMaxcapacityToDate;
    }

    private void putPlanloadNumToMap(List<Map<String, Object>> dataMessageByReport, List<Map<String, Object>> signToData, List<Map<String, Object>> signToData_noworkcenter, List<Long> workcenterList, List<Long> groupsList, Set<String> allField, Map<String, BigDecimal> dimensionByReport, Map<String, Long> scheduDataWorkcenter) {
        for (Map<String, Object> map : dataMessageByReport) {
            this.assigedNumMatch(dimensionByReport, map, allField);
            Long workcentre = (Long)map.get("workcentre");
            Long sourceentryid = (Long)map.get("sourceentryid");
            Integer entryseq = (Integer)map.get("entryseq");
            String key = sourceentryid + "," + entryseq;
            Long aLong = scheduDataWorkcenter.get(key);
            if (aLong != null && aLong != 0L) {
                workcentre = aLong;
            }
            if (workcenterList.size() != 0 && !workcenterList.contains(workcentre)) continue;
            Object group = map.get("group");
            if (groupsList.size() != 0 && !groupsList.contains(group)) continue;
            HashMap<String, Object> keyToData = new HashMap<String, Object>(8);
            Date sheduledate = (Date)map.get("demanddate");
            int year = sheduledate.getYear() + 1900;
            BigDecimal plsqty = (BigDecimal)map.get("orderqty");
            if (map.containsKey("assigedNum")) {
                BigDecimal assigedNum = (BigDecimal)map.get("assigedNum");
                plsqty = plsqty.subtract(assigedNum);
            }
            keyToData.put("year", year);
            keyToData.put("group_r", map.get("group"));
            keyToData.put("number", map.get("sourcebillno"));
            keyToData.put("billstatus", "C");
            keyToData.put("materiel", map.get("materiel"));
            keyToData.put("date", map.get("demanddate"));
            keyToData.put("configure", map.get("configurecode"));
            keyToData.put("tracknumber", map.get("tracknumber"));
            keyToData.put("workcenter_r", workcentre);
            keyToData.put("planlaod", plsqty);
            keyToData.put("ratecapacitytype", "A");
            BigDecimal allload = plsqty;
            if (keyToData.containsKey("allload")) {
                BigDecimal allload_all = (BigDecimal)keyToData.get("allload");
                allload = allload.add(allload_all);
            }
            keyToData.put("allload", allload);
            if (workcentre == null || workcentre == 0L) {
                signToData_noworkcenter.add(keyToData);
                continue;
            }
            signToData.add(keyToData);
        }
    }

    private void putDownloadNumToMap(DataSet assignedData, List<Map<String, Object>> signToData, List<Map<String, Object>> signToData_noworkcenter, Map<Long, Long> orderToGroup, List<Long> groupsList, List<Long> workcenterList) {
        if (assignedData != null && !assignedData.isEmpty()) {
            List<String> metas = Arrays.asList(assignedData.getRowMeta().getFieldNames());
            while (assignedData.hasNext()) {
                Row next = assignedData.next();
                this.putMessageToMap(signToData, next, signToData_noworkcenter, metas, orderToGroup, groupsList, workcenterList);
            }
        }
    }

    private void putMessageToMap(List<Map<String, Object>> signToData, Row next, List<Map<String, Object>> signToData_noworkcenter, List<String> metas, Map<Long, Long> orderToGroup, List<Long> groupsList, List<Long> workcenterList) {
        Long sourceentryid;
        Date sheduledate = next.getDate("pls_date");
        Long workcentre = next.getLong("workcenter");
        if (workcenterList.size() != 0 && !workcenterList.contains(workcentre)) {
            return;
        }
        if (metas.contains("sourceentryid")) {
            sourceentryid = next.getLong("sourceentryid");
            if (sourceentryid == null || sourceentryid == 0L) {
                sourceentryid = next.getLong("sourcebillid");
            }
        } else {
            sourceentryid = next.getLong("sourcebillid");
        }
        if (groupsList.size() == 0 || groupsList.contains(orderToGroup.get(sourceentryid))) {
            int year = sheduledate.getYear() + 1900;
            HashMap<String, Object> keyToData = new HashMap<String, Object>(8);
            keyToData.put("group_r", orderToGroup.get(sourceentryid));
            BigDecimal plsqty = next.getBigDecimal("plsqty");
            keyToData.put("year", year);
            keyToData.put("number", next.getString("plan_order_billno"));
            keyToData.put("materiel", next.getLong("materiel_code"));
            keyToData.put("date", sheduledate);
            keyToData.put("configure", next.getLong("configure"));
            keyToData.put("tracknumber", next.getLong("tracknumber"));
            keyToData.put("workcenter_r", workcentre);
            keyToData.put("sheduledate", sheduledate);
            keyToData.put("download", plsqty);
            keyToData.put("allload", plsqty);
            keyToData.put("ratecapacitytype", "A");
            if (workcentre == null || workcentre == 0L) {
                signToData_noworkcenter.add(keyToData);
            } else {
                signToData.add(keyToData);
            }
        }
    }

    private List<Map<String, Object>> getGroupToWorkcenter(DataSet planData, DynamicObject plan, Map<Long, Long> groupToWorkcenter, Map<Long, Long> orderToGroupMap, Boolean sign) {
        MPSGetBrachingData mpsGetBrachingData = new MPSGetBrachingData();
        groupToWorkcenter = mpsGetBrachingData.mpsGetBrachingData(plan, planData);
        MPSBranchingCalculate mpsBranchingCalculate = new MPSBranchingCalculate();
        List dataMessageByReport = mpsBranchingCalculate.getDataMessageByReport(groupToWorkcenter, planData, orderToGroupMap, sign);
        return dataMessageByReport;
    }

    private DataSet getPlanData(DynamicObject org, DynamicObject queryplan, Date filterbeginDate, Date filterEndDate, List<Long> datasourcesList) {
        Set<Long> orderModelId = this.getOrderModelId(queryplan, "order");
        HashSet<Long> orderModel_exit = new HashSet<Long>(8);
        if (datasourcesList.size() != 0) {
            for (Long id : orderModelId) {
                if (!datasourcesList.contains(id)) continue;
                orderModel_exit.add(id);
            }
        } else {
            orderModel_exit.addAll(orderModelId);
        }
        DataSet orderDataset = this.getOrderDataset(orderModel_exit);
        if (orderDataset == null) {
            return null;
        }
        HashMap<String, Timestamp> sqlParams = new HashMap<String, Timestamp>();
        sqlParams.put("_requiredate", new Timestamp(filterEndDate.getTime()));
        sqlParams.put("_requiredate_end", new Timestamp(filterbeginDate.getTime()));
        DataSet dataSet_finsh = orderDataset.filter("production_org = " + org.getLong("id")).filter("requiredate <= _requiredate", sqlParams).filter("requiredate >= _requiredate_end", sqlParams);
        return dataSet_finsh;
    }

    private DataSet getAssignedData_nofilterTime(DynamicObject org, DynamicObject queryplan, Date filterbeginDate, Date filterEndDate, List<Long> workcenterList, List<Long> datasourcesList) {
        Set<Long> orderModelId = this.getOrderModelId(queryplan, "assigned");
        HashSet<Long> orderModel_exit = new HashSet<Long>(8);
        if (datasourcesList.size() != 0) {
            for (Long id : orderModelId) {
                if (!datasourcesList.contains(id)) continue;
                orderModel_exit.add(id);
            }
        } else {
            orderModel_exit.addAll(orderModelId);
        }
        DataSet orderDataset = this.getOrderDataset(orderModel_exit);
        if (orderDataset != null) {
            DataSet dataSet_finsh;
            HashMap<String, List<Long>> sqlParams = new HashMap<String, List<Long>>();
            if (workcenterList.size() != 0) {
                sqlParams.put("_workcenter", workcenterList);
                dataSet_finsh = orderDataset.filter("production_org = " + org.getLong("id")).filter("workcenter in _workcenter", sqlParams);
            } else {
                dataSet_finsh = orderDataset.filter("production_org = " + org.getLong("id"));
            }
            return dataSet_finsh;
        }
        return null;
    }

    private DataSet getAssignedData_nofilterTime_work(DynamicObject org, DynamicObject queryplan, List<Long> datasourcesList) {
        Set<Long> orderModelId = this.getOrderModelId(queryplan, "assigned");
        HashSet<Long> orderModel_exit = new HashSet<Long>(8);
        if (datasourcesList.size() != 0) {
            for (Long id : orderModelId) {
                if (!datasourcesList.contains(id)) continue;
                orderModel_exit.add(id);
            }
        } else {
            orderModel_exit.addAll(orderModelId);
        }
        DataSet orderDataset = this.getOrderDataset(orderModel_exit);
        if (orderDataset != null) {
            DataSet dataSet_finsh = orderDataset.filter("production_org = " + org.getLong("id"));
            return dataSet_finsh;
        }
        return null;
    }

    private DataSet getAssignedData(DynamicObject org, DynamicObject queryplan, Date filterbeginDate, Date filterEndDate, List<Long> workcenterList, List<Long> datasourcesList) {
        Set<Long> orderModelId = this.getOrderModelId(queryplan, "assigned");
        HashSet<Long> orderModel_exit = new HashSet<Long>(8);
        if (datasourcesList.size() != 0) {
            for (Long id : orderModelId) {
                if (!datasourcesList.contains(id)) continue;
                orderModel_exit.add(id);
            }
        } else {
            orderModel_exit.addAll(orderModelId);
        }
        DataSet orderDataset = this.getOrderDataset(orderModel_exit);
        DataSet dataSet_finsh = null;
        if (orderDataset != null) {
            HashMap<String, Object> sqlParams = new HashMap<String, Object>();
            sqlParams.put("_requiredate", new Timestamp(filterEndDate.getTime()));
            sqlParams.put("_requiredate_end", new Timestamp(filterbeginDate.getTime()));
            DataSet dataSet = orderDataset.updateField("pls_date", "case when pls_date == null then null else TO_DATE(TO_CHAR(pls_date,'yyyy-MM-dd'),'yyyy-MM-dd') end");
            if (workcenterList.size() != 0) {
                sqlParams.put("_workcenter", workcenterList);
                dataSet_finsh = dataSet.filter("production_org = " + org.getLong("id")).filter("pls_date <= _requiredate", sqlParams).filter("pls_date >= _requiredate_end", sqlParams).filter("workcenter in _workcenter", sqlParams);
            } else {
                dataSet_finsh = dataSet.filter("production_org = " + org.getLong("id")).filter("pls_date <= _requiredate", sqlParams).filter("pls_date >= _requiredate_end", sqlParams);
            }
        }
        return dataSet_finsh;
    }

    private DataSet getAssignedData_work(DynamicObject org, DynamicObject queryplan, Date filterbeginDate, Date filterEndDate, List<Long> datasourcesList) {
        Set<Long> orderModelId = this.getOrderModelId(queryplan, "assigned");
        HashSet<Long> orderModel_exit = new HashSet<Long>(8);
        if (datasourcesList.size() != 0) {
            for (Long id : orderModelId) {
                if (!datasourcesList.contains(id)) continue;
                orderModel_exit.add(id);
            }
        } else {
            orderModel_exit.addAll(orderModelId);
        }
        DataSet orderDataset = this.getOrderDataset(orderModel_exit);
        DataSet dataSet_finsh = null;
        if (orderDataset != null) {
            HashMap<String, Timestamp> sqlParams = new HashMap<String, Timestamp>();
            sqlParams.put("_requiredate", new Timestamp(filterEndDate.getTime()));
            sqlParams.put("_requiredate_end", new Timestamp(filterbeginDate.getTime()));
            DataSet dataSet = orderDataset.updateField("pls_date", "case when pls_date == null then null else TO_DATE(TO_CHAR(pls_date,'yyyy-MM-dd'),'yyyy-MM-dd') end");
            dataSet_finsh = dataSet.filter("production_org = " + org.getLong("id")).filter("pls_date <= _requiredate", sqlParams).filter("pls_date >= _requiredate_end", sqlParams);
        }
        return dataSet_finsh;
    }

    public DataSet getOrderDataset(Set<Long> modelIds) {
        DataSet dataSet = null;
        for (Long modelId : modelIds) {
            DataSet ds;
            FetchDataQueryModule queryMD = DataSourceFetchDataUtil.getQueryModuleByModel((Long)modelId, null);
            DataSet dsItem = DataSourceFetchDataUtil.getDataSetByModel((FetchDataQueryModule)queryMD, (DataSet)(ds = QueryServiceHelper.queryDataSet((String)DataSourceFetchDataUtil.class.getName(), (String)queryMD.getMt(), (String)queryMD.getOql(), (QFilter[])queryMD.getqFilters(), null)));
            if (dsItem == null || dsItem.isEmpty()) {
                return null;
            }
            if (dataSet == null) {
                dataSet = dsItem;
                continue;
            }
            RowMeta leftRowMeta = dataSet.getRowMeta();
            RowMeta rightRowMeta = dsItem.getRowMeta();
            Field[] leftFields = leftRowMeta.getFields();
            Field[] rightFields = rightRowMeta.getFields();
            HashSet<String> allFieldName = new HashSet<String>(16);
            HashSet<String> leftName = new HashSet<String>(16);
            HashSet<String> rightName = new HashSet<String>(16);
            for (Field leftField : leftFields) {
                allFieldName.add(leftField.getName());
                leftName.add(leftField.getName());
            }
            for (Field rightField : rightFields) {
                allFieldName.add(rightField.getName());
                rightName.add(rightField.getName());
            }
            for (String fieldName : allFieldName) {
                if (!leftName.contains(fieldName)) {
                    dataSet = dataSet.addNullField(fieldName);
                }
                if (rightName.contains(fieldName)) continue;
                dsItem = dsItem.addNullField(fieldName);
            }
            dataSet = dataSet.select(allFieldName.toArray(new String[0]));
            dsItem = dsItem.select(allFieldName.toArray(new String[0]));
            dataSet = dataSet.union(dsItem);
        }
        return dataSet;
    }

    public Set<Long> getOrderModelId(DynamicObject plan, String sign) {
        DynamicObjectCollection orderEntryColl = "assigned".equals(sign) ? plan.getDynamicObjectCollection("data_entryentity") : plan.getDynamicObjectCollection("order_entryentity");
        HashSet<Long> idSet = new HashSet<Long>(orderEntryColl.size());
        if (orderEntryColl != null && !orderEntryColl.isEmpty()) {
            for (DynamicObject order : orderEntryColl) {
                boolean isCalculate = false;
                if ("assigned".equals(sign)) {
                    if (order.get("dataisincalculate") != null) {
                        isCalculate = order.getBoolean("dataisincalculate");
                    }
                    if (!isCalculate || order.get("dataresourceconfig") == null) continue;
                    idSet.add(order.getLong("dataresourceconfig_id"));
                    continue;
                }
                if (order.get("isincalculate") != null) {
                    isCalculate = order.getBoolean("isincalculate");
                }
                if (!isCalculate || order.get("resourceconfig") == null) continue;
                idSet.add(order.getLong("resourceconfig_id"));
            }
            if (idSet.size() == 0) {
                return idSet;
            }
        }
        return idSet;
    }

    public List<AbstractReportColumn> getColumns(List<AbstractReportColumn> columns) throws Throwable {
        List columns1 = super.getColumns(columns);
        for (AbstractReportColumn abstractReportColumn : columns1) {
            DynamicObject queryplan;
            String capacalcway;
            String fieldKey = ((ReportColumn)abstractReportColumn).getFieldKey();
            ReportQueryParam queryParam = this.getQueryParam();
            FilterInfo filterInfo = queryParam.getFilter();
            if (!"actresource".equals(fieldKey) && !"unit".equals(fieldKey) || !"A".equals(capacalcway = (queryplan = filterInfo.getDynamicObject("queryplan")).getString("capacalcway"))) continue;
            ((ReportColumn)abstractReportColumn).setHide(true);
        }
        return columns1;
    }
}

