/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mps;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.RowMeta;
import kd.bos.algo.datatype.BigDecimalType;
import kd.bos.algo.datatype.IntegerType;
import kd.bos.algo.datatype.LongType;
import kd.bos.algo.datatype.StringType;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.AbstractReportListDataPlugin;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.redis.JedisClient;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.mmc.mps.calcnode.MPSBranchingCalculate;
import kd.mmc.mps.calcnode.MPSGetBrachingData;
import kd.mmc.mps.calcnode.MPSInitReduOrder;
import kd.mmc.mps.calcnode.MpsMatchDimension;
import kd.mmc.mps.common.util.MPSScheduleUtils;
import kd.mmc.mps.common.util.ReportQueryUtils;
import kd.mmc.mps.mservice.api.DowmTimePlanService;

public class CapacityScheduReportQuery
extends AbstractReportListDataPlugin {
    private static final Log log = LogFactory.getLog(CapacityScheduReportQuery.class);
    private static String[] field = new String[]{"year", "cycle_s", "workcenter_r", "download", "planlaod", "allload", "ratecapacity", "morecapacity", "cycle_r", "morecapacity_num", "ratecapacitytype", "actresource", "date", "daterange_s"};
    private static DataType[] dataType = new DataType[]{new StringType(), new StringType(), new LongType(), new BigDecimalType(), new BigDecimalType(), new BigDecimalType(), new BigDecimalType(), new StringType(), new StringType(), new BigDecimalType(), new StringType(), new LongType(), new IntegerType(), new StringType()};

    public DataSet query(ReportQueryParam reportQueryParam, Object o) throws Throwable {
        String capacalcway;
        FilterInfo filterInfo = reportQueryParam.getFilter();
        DynamicObject org = filterInfo.getDynamicObject("org");
        DynamicObject queryplan = filterInfo.getDynamicObject("queryplan");
        boolean allloadiszerodata = filterInfo.getBoolean("allloadiszerodata");
        boolean workcentertotal = filterInfo.getBoolean("workcentertotal");
        String timeunit = filterInfo.getDynamicObject("timeunit").getString("number");
        Date filterEndDate = filterInfo.getDate("enddate");
        Date filterbeginDate = filterInfo.getDate("begindate");
        ArrayList<Long> workcenterList = new ArrayList<Long>(8);
        DynamicObjectCollection workcenters = filterInfo.getDynamicObjectCollection("workcenter");
        if (workcenters != null) {
            for (DynamicObject dynamicObject : workcenters) {
                workcenterList.add(dynamicObject.getLong("id"));
            }
        }
        ArrayList<Long> actresourceList = new ArrayList<Long>(8);
        DynamicObjectCollection actresources = filterInfo.getDynamicObjectCollection("actresource_query");
        if (actresources != null) {
            for (DynamicObject dynamicObject : actresources) {
                actresourceList.add(dynamicObject.getLong("id"));
            }
        }
        String cycle = filterInfo.getString("cycle");
        ArrayList<Long> datasourcesList = new ArrayList<Long>(8);
        DynamicObjectCollection datasources = filterInfo.getDynamicObjectCollection("datasource");
        if (datasources != null) {
            for (DynamicObject dynamicObject : datasources) {
                datasourcesList.add(dynamicObject.getLong("id"));
            }
        }
        if ((capacalcway = queryplan.getString("capacalcway")).isEmpty()) {
            capacalcway = "A";
        }
        DataSet dataSet_sort = null;
        StringBuilder tipMessage = new StringBuilder();
        HashMap<Integer, Object[]> weekToDate = new HashMap<Integer, Object[]>(16);
        if ("A".equals(capacalcway)) {
            dataSet_sort = this.dayCapaQuery(org, cycle, queryplan, workcenterList, datasourcesList, filterbeginDate, filterEndDate, capacalcway, allloadiszerodata, weekToDate);
        } else {
            try {
                dataSet_sort = this.workingHoursQuery(org, cycle, queryplan, workcenterList, datasourcesList, filterbeginDate, filterEndDate, capacalcway, allloadiszerodata, actresourceList, tipMessage, weekToDate);
                this.creatTip(queryplan, org, tipMessage, false);
            }
            catch (Exception e) {
                this.getStackTrace(e, tipMessage);
                this.creatTip(queryplan, org, tipMessage, true);
            }
        }
        if (dataSet_sort != null) {
            if ("A".equals(capacalcway)) {
                return dataSet_sort;
            }
            Long unitId = filterInfo.getDynamicObject("timeunit").getLong("id");
            DataSet dataSet_addunit = dataSet_sort.addField(unitId.toString(), "unit");
            DataSet dataSet = ReportQueryUtils.timeCov((DataSet)dataSet_addunit, (String)timeunit);
            if (workcentertotal) {
                DataSet finish = dataSet.groupBy(new String[]{"year", "workcenter_r", "ratecapacitytype", "unit"}).sum("download").sum("planlaod").sum("allload").sum("ratecapacity").finish();
                DataSet dataSet_updatenullvalue = finish.updateFields(new String[]{"allload", "ratecapacity"}, new String[]{"case when allload = null then 0 else allload end", "case when ratecapacity = null then 0 else ratecapacity end"});
                DataSet dataSet_updateratecapacityvalue = dataSet_updatenullvalue.addField("concat(String(case when allload = 0 or ratecapacity = 0 then 0 else Round(allload/ratecapacity,4) * 100 end),'%')", "morecapacity");
                DataSet dataSet_updateratecapacitynumvalue = dataSet_updateratecapacityvalue.addField("case when ratecapacity = 0 then 999  else (case when Round(allload/ratecapacity,4) * 100 > 999 then 999  else  Round(allload/ratecapacity,4) * 100 end) end", "morecapacity_num");
                return dataSet_updateratecapacitynumvalue;
            }
            return dataSet;
        }
        RowMeta rowMeta = new RowMeta(field, dataType);
        Algo algo = Algo.create((String)"scm");
        ArrayList dataSetValue = new ArrayList(16);
        dataSet_sort = algo.createDataSet(dataSetValue, rowMeta);
        return dataSet_sort;
    }

    private void getStackTrace(Exception t, StringBuilder tipMessage) {
        if (t != null && t.getStackTrace() != null && t.getStackTrace().length != 0) {
            StackTraceElement[] details = t.getStackTrace();
            tipMessage.append(t).append("\r\n");
            for (StackTraceElement stackTraceElement : details) {
                tipMessage.append(stackTraceElement).append("\r\n");
                if (tipMessage.length() > 3000) break;
            }
        }
    }

    private void creatTip(DynamicObject queryplan, DynamicObject org, StringBuilder tipMessage, Boolean iserror) {
        Long orgid = org.getLong("id");
        String orgName = org.getString("name");
        DynamicObject calculateLog = MPSScheduleUtils.createNewLog((DynamicObject)queryplan, (Long)orgid, (String)"report", (String)"mps_reportcalclog");
        if (tipMessage.length() == 0) {
            tipMessage.append("error");
        }
        JedisClient jedis = MPSScheduleUtils.getJedis();
        jedis.set("mpscalc-error-tip", "");
        jedis.set("mpscalc-" + calculateLog.getLong("id") + "report", tipMessage.toString());
        if (iserror.booleanValue()) {
            jedis.set("mpscalc-" + calculateLog.getLong("id") + "error", "error");
            jedis.set("mpscalc-error-tip", "error");
            jedis.close();
        }
        DispatchServiceHelper.invokeBizService((String)"mpscmm", (String)"msplan", (String)"IMRPCalcRuntimeService", (String)"startCalc", (Object[])new Object[]{calculateLog.getLong("id"), null, orgid, orgName, "mps_reportcalclog", "report", "mrp_caculate_log"});
    }

    private DataSet workingHoursQuery(DynamicObject org, String cycle, DynamicObject queryplan, List<Long> workcenterList, List<Long> datasourcesList, Date filterbeginDate, Date filterEndDate, String capacalcway, boolean allloadiszerodata, List<Long> actresourceList, StringBuilder tipMessage, Map<Integer, Object[]> weekToDate) {
        Long allBeginTime = TimeServiceHelper.now().getTime();
        log.info("beginTime", (Object)allBeginTime);
        HashMap workshiftTime = new HashMap(16);
        Map planWorkCenter = ReportQueryUtils.getPlanWorkCenter((DynamicObject)queryplan, workshiftTime, (StringBuilder)tipMessage);
        Map workcenterToworkDayByRange = MPSScheduleUtils.getWorkDayByRange((Date)filterbeginDate, (Date)filterEndDate, (Map)planWorkCenter);
        HashMap<Integer, Map<Integer, String>> yearToWeekTorange = new HashMap<Integer, Map<Integer, String>>(16);
        DataSet assignedData_nofilterTime = ReportQueryUtils.getAssignedData_nofilterTime((DynamicObject)org, (DynamicObject)queryplan, datasourcesList);
        DataSet assignedData = ReportQueryUtils.getAssignedData((DataSet)assignedData_nofilterTime, (Date)filterbeginDate, (Date)filterEndDate);
        DataSet planData = ReportQueryUtils.getPlanData((DynamicObject)org, (DynamicObject)queryplan, (Date)filterbeginDate, (Date)filterEndDate, datasourcesList);
        DataSet routeData = ReportQueryUtils.getRouteData((DynamicObject)queryplan, actresourceList);
        DataSet resoureData = ReportQueryUtils.getResoureData((DynamicObject)queryplan);
        List planDataMessage = MPSScheduleUtils.getScheduleOrder((DataSet)planData);
        tipMessage.append(ResManager.loadKDString((String)"\u83b7\u53d6\u8ba1\u5212\u6570\u636e\uff1a", (String)"CapacityScheduReportQuery_10", (String)"mmc-mps-report", (Object[])new Object[0])).append(planDataMessage.size()).append("\n");
        List assignedDataMessage = MPSScheduleUtils.getScheduleOrder((DataSet)assignedData);
        tipMessage.append(ResManager.loadKDString((String)"\u83b7\u53d6\u5df2\u4e0b\u8fbe\u6570\u636e\uff1a", (String)"CapacityScheduReportQuery_11", (String)"mmc-mps-report", (Object[])new Object[0])).append(assignedDataMessage.size()).append("\n");
        MPSInitReduOrder mpsInitReduOrder = new MPSInitReduOrder();
        List initReduOrder = mpsInitReduOrder.getInitReduOrderByReport(assignedData_nofilterTime, new HashMap(16), new HashMap(16));
        MpsMatchDimension mpsMatchDimension = new MpsMatchDimension();
        Set allField = mpsMatchDimension.getAllField(initReduOrder, queryplan);
        Map dimensionByReport = mpsMatchDimension.getDimensionByReport(initReduOrder, queryplan, planDataMessage);
        tipMessage.append(ResManager.loadKDString((String)"\u83b7\u53d6\u5339\u914d\u6570\u636e\uff1a", (String)"CapacityScheduReportQuery_12", (String)"mmc-mps-report", (Object[])new Object[0])).append(dimensionByReport.size()).append("\n");
        ReportQueryUtils.reduceNum((List)planDataMessage, (Map)dimensionByReport, (Set)allField);
        HashMap routeId = new HashMap(16);
        HashMap resourceDetail = new HashMap(16);
        HashMap routeIdToDateRange = new HashMap(16);
        List routeDataMessage = ReportQueryUtils.getRouteOrder((DataSet)routeData, routeId, (String)"route", routeIdToDateRange);
        tipMessage.append(ResManager.loadKDString((String)"\u83b7\u53d6\u5de5\u827a\u8def\u7ebf\u6570\u636e\uff1a", (String)"CapacityScheduReportQuery_13", (String)"mmc-mps-report", (Object[])new Object[0])).append(routeDataMessage.size()).append("\n");
        List resoureDataMessage = ReportQueryUtils.getRouteOrder((DataSet)resoureData, routeId, (String)"resource", routeIdToDateRange);
        tipMessage.append(ResManager.loadKDString((String)"\u83b7\u53d6\u8d44\u6e90\u6570\u636e\uff1a", (String)"CapacityScheduReportQuery_14", (String)"mmc-mps-report", (Object[])new Object[0])).append(resoureDataMessage.size()).append("\n");
        ReportQueryUtils.getResourceDetail((List)resoureDataMessage, resourceDetail);
        log.info("routeDataMessage", (Object)routeDataMessage.size());
        log.info("resoureDataMessage", (Object)resoureDataMessage.size());
        HashMap workcenterToresourceToQty = new HashMap(16);
        Map measureunits = ReportQueryUtils.getMeasureunits();
        List planDataMessage_qty = new ArrayList(16);
        List assignedDataMessage_qty = new ArrayList(16);
        ArrayList planDataMessage_save = new ArrayList(16);
        if ("B".equals(queryplan.getString("routerule"))) {
            DynamicObject arrangedmatchitem = queryplan.getDynamicObject("arrangedmatchitem");
            Map matchItem = mpsMatchDimension.getMatchItem(arrangedmatchitem);
            Map routeIdToCreatTime = ReportQueryUtils.getRouteCreatTime(routeId.keySet());
            Map matcthItemRoute = ReportQueryUtils.getMatcthItemRoute((Map)matchItem, (List)routeDataMessage, (Map)routeIdToCreatTime);
            ReportQueryUtils.getRouteByMatchItem((List)planDataMessage, (Map)matcthItemRoute, routeId, (Map)matchItem, (StringBuilder)tipMessage);
            DynamicObject routematchitem = queryplan.getDynamicObject("routematchitem");
            Map matchItem_dim = mpsMatchDimension.getMatchItem(routematchitem);
            ReportQueryUtils.getRouteByMatchItem((List)assignedDataMessage, (Map)matcthItemRoute, routeId, (Map)matchItem_dim, (StringBuilder)tipMessage);
            planDataMessage_qty = ReportQueryUtils.resourceDataFill((List)planDataMessage, (Map)planWorkCenter, (Map)measureunits, (String)"plan", planDataMessage_save);
            assignedDataMessage_qty = ReportQueryUtils.resourceDataFill((List)assignedDataMessage, (Map)planWorkCenter, (Map)measureunits, (String)"assigned", planDataMessage_save);
        } else {
            Long routeBeginTime = TimeServiceHelper.now().getTime();
            log.info("getRouteBeginTime" + (routeBeginTime - allBeginTime));
            log.info("planDataMessage" + planDataMessage.size());
            log.info("assignedDataMessage" + assignedDataMessage.size());
            List planDataMessage_route = ReportQueryUtils.getRoute((List)planDataMessage, (DynamicObject)org, routeId, (StringBuilder)tipMessage, routeIdToDateRange);
            List assignedDataMessage_route = ReportQueryUtils.getRoute((List)assignedDataMessage, (DynamicObject)org, routeId, (StringBuilder)tipMessage, routeIdToDateRange);
            Long routeEndTime = TimeServiceHelper.now().getTime();
            log.info("getRouteEndTime" + (routeEndTime - routeBeginTime));
            planDataMessage_qty = ReportQueryUtils.resourceDataFill((List)planDataMessage_route, (Map)planWorkCenter, (Map)measureunits, (String)"plan", planDataMessage_save);
            assignedDataMessage_qty = ReportQueryUtils.resourceDataFill((List)assignedDataMessage_route, (Map)planWorkCenter, (Map)measureunits, (String)"assigned", planDataMessage_save);
            log.info("planDataMessage" + planDataMessage_qty.size());
            log.info("assignedDataMessage" + assignedDataMessage_qty.size());
            log.info("resourceDataFill" + (TimeServiceHelper.now().getTime() - routeEndTime));
        }
        Map resoureQty = ReportQueryUtils.getResoureQty((List)resoureDataMessage, (Map)planWorkCenter, (Date)filterbeginDate, (Date)filterEndDate, workshiftTime, (Map)workcenterToworkDayByRange, workcenterToresourceToQty);
        HashMap<Long, Map<Integer, Map<Long, Map<Integer, Map<String, Object>>>>> signToData = new HashMap<Long, Map<Integer, Map<Long, Map<Integer, Map<String, Object>>>>>(16);
        HashMap<Integer, Map<Integer, String>> dayToDate = new HashMap<Integer, Map<Integer, String>>(8);
        ReportQueryUtils.putDownloadQtyToMap(assignedDataMessage_qty, signToData, (String)cycle, dayToDate, yearToWeekTorange);
        ReportQueryUtils.putPlanloadQtyToMap(planDataMessage_qty, signToData, (String)cycle, dayToDate, yearToWeekTorange);
        Map<String, Map<Long, Map<String, Map<String, Object>>>> downTimePlan = this.getDownTimePlan(queryplan);
        ReportQueryUtils.putExitResourceToMap(signToData, (Map)resoureQty, dayToDate, workshiftTime, (Map)planWorkCenter, (Map)workcenterToworkDayByRange, (String)cycle, (Date)filterbeginDate, (Date)filterEndDate, workcenterToresourceToQty, yearToWeekTorange);
        ReportQueryUtils.putResourceToMap(signToData, (Map)resoureQty, dayToDate, workshiftTime, (Map)planWorkCenter, (Map)workcenterToworkDayByRange, (String)cycle, (Date)filterbeginDate, (Date)filterEndDate, yearToWeekTorange);
        Map signToData_new = ReportQueryUtils.putaAllResourceDateToSignData((Map)resoureQty, signToData, (String)cycle, dayToDate, (Date)filterbeginDate, (Date)filterEndDate, (Map)workcenterToworkDayByRange, (Map)planWorkCenter, workshiftTime, yearToWeekTorange);
        ReportQueryUtils.putResourceCapaDataToSignData((Map)signToData_new, signToData);
        ReportQueryUtils.subtractionDownTimePlan_new(downTimePlan, signToData, (DynamicObject)org, (String)cycle, dayToDate, yearToWeekTorange);
        List<Object[]> dataSetValue = this.getListObjectByResource(signToData, cycle, dayToDate, capacalcway, allloadiszerodata, yearToWeekTorange);
        RowMeta rowMeta = new RowMeta(field, dataType);
        Algo algo = Algo.create((String)"scm");
        DataSet dataSet = algo.createDataSet(dataSetValue, rowMeta);
        DataSet dataSet_sort = dataSet.orderBy(new String[]{"year", "date asc", "workcenter_r", "actresource"});
        DataSet dataSet_filter = ReportQueryUtils.filterWorkCenter(workcenterList, (DataSet)dataSet_sort, actresourceList);
        ReportQueryUtils.saveCapaDataToBackByResources((Map)resoureQty, (DynamicObject)queryplan, (Map)planWorkCenter, (Map)measureunits, (DynamicObject)org, workcenterToresourceToQty, resourceDetail, downTimePlan);
        ReportQueryUtils.saveCapacityloadDataToBackByResources(planDataMessage_save, (DynamicObject)queryplan);
        return dataSet_filter;
    }

    public Map<String, Map<Long, Map<String, Map<String, Object>>>> getDownTimePlan(DynamicObject queryplan) {
        String haltschedule = queryplan.getString("haltschedule");
        if (haltschedule == null || haltschedule.isEmpty()) {
            return null;
        }
        try {
            Class<?> localStepClass = Class.forName(haltschedule);
            Object inst = localStepClass.newInstance();
            if (inst instanceof DowmTimePlanService) {
                DowmTimePlanService localStep = (DowmTimePlanService)inst;
                Map downTimeMessage = localStep.getWorkCenterDateTimes();
                return downTimeMessage;
            }
            throw new KDBizException("wrong impl");
        }
        catch (Throwable e) {
            throw new KDBizException("error");
        }
    }

    private List<Object[]> getListObjectByResource(Map<Long, Map<Integer, Map<Long, Map<Integer, Map<String, Object>>>>> signToData, String cycle, Map<Integer, Map<Integer, String>> dayToDate, String capacalcway, boolean allloadiszerodata, Map<Integer, Map<Integer, String>> yearToWeekTorange) {
        ArrayList<Object[]> objectList = new ArrayList<Object[]>(8);
        for (Map.Entry<Long, Map<Integer, Map<Long, Map<Integer, Map<String, Object>>>>> mapEntry : signToData.entrySet()) {
            Map<Integer, Map<Long, Map<Integer, Map<String, Object>>>> mapEntryValue_mapmap = mapEntry.getValue();
            for (Map.Entry<Integer, Map<Long, Map<Integer, Map<String, Object>>>> mapEntryValue_map : mapEntryValue_mapmap.entrySet()) {
                Map<Long, Map<Integer, Map<String, Object>>> mapEntryValue = mapEntryValue_map.getValue();
                Integer year = mapEntryValue_map.getKey();
                for (Map.Entry<Long, Map<Integer, Map<String, Object>>> mapEntry_messages : mapEntryValue.entrySet()) {
                    Map<Integer, Map<String, Object>> mapEntry_message = mapEntry_messages.getValue();
                    List<Object[]> objectList_work = this.getObjectValue(mapEntry_message, cycle, dayToDate, capacalcway, allloadiszerodata, year, yearToWeekTorange);
                    objectList.addAll(objectList_work);
                }
            }
        }
        return objectList;
    }

    private DataSet dayCapaQuery(DynamicObject org, String cycle, DynamicObject queryplan, List<Long> workcenterList, List<Long> datasourcesList, Date filterbeginDate, Date filterEndDate, String capacalcway, boolean allloadiszerodata, Map<Integer, Object[]> weekToDate) {
        Map planWorkCenter = ReportQueryUtils.getPlanWorkCenter((DynamicObject)queryplan, new HashMap(16), (StringBuilder)new StringBuilder());
        DataSet assignedData_nofilterTime = ReportQueryUtils.getAssignedData_nofilterTime((DynamicObject)org, (DynamicObject)queryplan, datasourcesList);
        DataSet assignedData = ReportQueryUtils.getAssignedData((DataSet)assignedData_nofilterTime, (Date)filterbeginDate, (Date)filterEndDate);
        DataSet planData = ReportQueryUtils.getPlanData((DynamicObject)org, (DynamicObject)queryplan, (Date)filterbeginDate, (Date)filterEndDate, datasourcesList);
        HashMap<Long, Long> groupToWorkcenter = new HashMap<Long, Long>(16);
        HashMap<Long, Long> orderToGroupMap = new HashMap<Long, Long>(16);
        HashMap<Long, Long> groupToWorkcenter_assgined = new HashMap<Long, Long>(16);
        HashMap<Long, Long> orderToGroupMap_assgined = new HashMap<Long, Long>(16);
        HashMap<Integer, Map<Integer, String>> yearToWeekTorange = new HashMap<Integer, Map<Integer, String>>(16);
        List<Map<String, Object>> dataMessageByReport = this.getGroupToWorkcenter(planData, queryplan, groupToWorkcenter, orderToGroupMap, true);
        List<Map<String, Object>> dataMessageByReport_assigned = this.getGroupToWorkcenter(assignedData, queryplan, groupToWorkcenter, orderToGroupMap, true);
        List<Map<String, Object>> dataMessageByReport_nofilterTime = this.getGroupToWorkcenter(assignedData_nofilterTime, queryplan, groupToWorkcenter_assgined, orderToGroupMap_assgined, false);
        MPSInitReduOrder mpsInitReduOrder = new MPSInitReduOrder();
        List initReduOrder = mpsInitReduOrder.getInitReduOrderByReport(assignedData_nofilterTime, groupToWorkcenter_assgined, orderToGroupMap_assgined);
        MpsMatchDimension mpsMatchDimension = new MpsMatchDimension();
        Set allField = mpsMatchDimension.getAllField(initReduOrder, queryplan);
        Map dimensionByReport = mpsMatchDimension.getDimensionByReport(initReduOrder, queryplan, dataMessageByReport_nofilterTime);
        ReportQueryUtils.reduceNum(dataMessageByReport, (Map)dimensionByReport, (Set)allField);
        HashMap<Integer, Map<Integer, String>> dayToDate = new HashMap<Integer, Map<Integer, String>>(8);
        HashMap<Long, Map<Integer, Map<Integer, Map<String, Object>>>> signToData = new HashMap<Long, Map<Integer, Map<Integer, Map<String, Object>>>>(16);
        HashMap<Integer, Map<Integer, Map<String, Object>>> signToData_noworkcenter = new HashMap<Integer, Map<Integer, Map<String, Object>>>(8);
        Map scheduDataWorkcenter = ReportQueryUtils.getScheduDataWorkcenter(dataMessageByReport);
        ReportQueryUtils.putDownloadNumToMap(dataMessageByReport_assigned, signToData, (String)cycle, signToData_noworkcenter, dayToDate, (Map)planWorkCenter, yearToWeekTorange);
        ReportQueryUtils.putPlanloadNumToMap(dataMessageByReport, signToData, (String)cycle, signToData_noworkcenter, dayToDate, workcenterList, (Map)scheduDataWorkcenter, (Map)planWorkCenter, yearToWeekTorange);
        HashMap workcenterGroupcapacityMessage = new HashMap(16);
        Map capacityMessage = ReportQueryUtils.getCapacityMessage((DynamicObject)queryplan, workcenterGroupcapacityMessage, (Date)filterbeginDate, (Date)filterEndDate);
        ReportQueryUtils.putCapatityToMap(signToData, (Map)capacityMessage, dayToDate, (String)cycle, yearToWeekTorange);
        Map signToData_new = ReportQueryUtils.putaAllQueryDateToSignData((Map)capacityMessage, signToData, dayToDate, (String)cycle, (Date)filterbeginDate, (Date)filterEndDate, yearToWeekTorange);
        ReportQueryUtils.putCapaDataToSignData((Map)signToData_new, signToData);
        List<Object[]> dataSetValue = this.getListObject(signToData, signToData_noworkcenter, cycle, dayToDate, capacalcway, allloadiszerodata, yearToWeekTorange);
        RowMeta rowMeta = new RowMeta(field, dataType);
        Algo algo = Algo.create((String)"scm");
        DataSet dataSet = algo.createDataSet(dataSetValue, rowMeta);
        DataSet dataSet_sort = dataSet.orderBy(new String[]{"year"});
        DataSet dataSet_filter = ReportQueryUtils.filterWorkCenter(workcenterList, (DataSet)dataSet_sort, datasourcesList);
        ReportQueryUtils.saveCapaDataToBack((Map)capacityMessage, (DynamicObject)org, groupToWorkcenter, (DynamicObject)queryplan, signToData, (Date)filterbeginDate, (Date)filterEndDate, workcenterGroupcapacityMessage);
        ReportQueryUtils.saveCapacityloadDataToBack(dataMessageByReport, (DynamicObject)queryplan, (Map)planWorkCenter);
        return dataSet_filter;
    }

    public List<AbstractReportColumn> getColumns(List<AbstractReportColumn> columns) throws Throwable {
        List columns1 = super.getColumns(columns);
        for (AbstractReportColumn abstractReportColumn : columns1) {
            DynamicObject queryplan;
            String capacalcway;
            String cycle;
            String fieldKey = ((ReportColumn)abstractReportColumn).getFieldKey();
            ReportQueryParam queryParam = this.getQueryParam();
            FilterInfo filterInfo = queryParam.getFilter();
            boolean workcentertotal = filterInfo.getBoolean("workcentertotal");
            if ("cycle_s".equals(fieldKey)) {
                cycle = filterInfo.getString("cycle");
                String value = ResManager.loadKDString((String)"\u65e5", (String)"CapacityScheduReportQuery_1", (String)"mmc-mps-report", (Object[])new Object[0]);
                if ("mon".equals(cycle)) {
                    value = ResManager.loadKDString((String)"\u6708", (String)"CapacityScheduReportQuery_3", (String)"mmc-mps-report", (Object[])new Object[0]);
                } else if ("wek".equals(cycle)) {
                    value = ResManager.loadKDString((String)"\u5468", (String)"CapacityScheduReportQuery_2", (String)"mmc-mps-report", (Object[])new Object[0]);
                } else if ("qua".equals(cycle)) {
                    value = ResManager.loadKDString((String)"\u5b63", (String)"CapacityScheduReportQuery_4", (String)"mmc-mps-report", (Object[])new Object[0]);
                }
                abstractReportColumn.setCaption(new LocaleString(value));
            } else if ("daterange_s".equals(fieldKey)) {
                cycle = filterInfo.getString("cycle");
                if (!"wek".equals(cycle)) {
                    ((ReportColumn)abstractReportColumn).setHide(true);
                }
            } else if (("actresource".equals(fieldKey) || "unit".equals(fieldKey)) && "A".equals(capacalcway = (queryplan = filterInfo.getDynamicObject("queryplan")).getString("capacalcway"))) {
                ((ReportColumn)abstractReportColumn).setHide(true);
            }
            if (!workcentertotal || !"cycle_r".equals(fieldKey) && !"cycle_s".equals(fieldKey) && !"actresource".equals(fieldKey)) continue;
            ((ReportColumn)abstractReportColumn).setHide(true);
        }
        return columns1;
    }

    private List<Object[]> getListObject(Map<Long, Map<Integer, Map<Integer, Map<String, Object>>>> signToData, Map<Integer, Map<Integer, Map<String, Object>>> signToData_noworkcenter, String cycle, Map<Integer, Map<Integer, String>> dayToDate, String capacalcway, boolean allloadiszerodata, Map<Integer, Map<Integer, String>> yearToWeekTorange) {
        ArrayList<Object[]> objectList = new ArrayList<Object[]>(8);
        for (Map.Entry<Long, Map<Integer, Map<Integer, Map<String, Object>>>> mapEntry : signToData.entrySet()) {
            Map<Integer, Map<Integer, Map<String, Object>>> mapEntryValue_mapmap = mapEntry.getValue();
            TreeMap<Integer, Map<Integer, Map<String, Object>>> mapEntryValue_mapmape_sort = new TreeMap<Integer, Map<Integer, Map<String, Object>>>(mapEntryValue_mapmap);
            for (Map.Entry mapEntryValue_map : mapEntryValue_mapmape_sort.entrySet()) {
                Map mapEntryValue = (Map)mapEntryValue_map.getValue();
                Integer year = (Integer)mapEntryValue_map.getKey();
                TreeMap<Integer, Map<String, Object>> mapEntryValue_sort = new TreeMap<Integer, Map<String, Object>>(mapEntryValue);
                List<Object[]> objectList_work = this.getObjectValue(mapEntryValue_sort, cycle, dayToDate, capacalcway, allloadiszerodata, year, yearToWeekTorange);
                objectList.addAll(objectList_work);
            }
        }
        TreeMap<Integer, Map<Integer, Map<String, Object>>> signToData_noworkcenter_sort = new TreeMap<Integer, Map<Integer, Map<String, Object>>>(signToData_noworkcenter);
        for (Map.Entry mapEntry_total_mapmap : signToData_noworkcenter_sort.entrySet()) {
            Map mapEntry_total_map = (Map)mapEntry_total_mapmap.getValue();
            Integer year = (Integer)mapEntry_total_mapmap.getKey();
            TreeMap<Integer, Map<String, Object>> mapEntry_total_map_sort = new TreeMap<Integer, Map<String, Object>>(mapEntry_total_map);
            List<Object[]> objectList_noWorkCenter = this.getObjectValue(mapEntry_total_map_sort, cycle, dayToDate, capacalcway, allloadiszerodata, year, yearToWeekTorange);
            objectList.addAll(objectList_noWorkCenter);
        }
        return objectList;
    }

    private List<Object[]> getObjectValue(Map<Integer, Map<String, Object>> signToData, String cycle, Map<Integer, Map<Integer, String>> dayToDate, String capacalcway, boolean allloadiszerodata, Integer year, Map<Integer, Map<Integer, String>> yearToWeekTorange) {
        ArrayList<Object[]> objectList = new ArrayList<Object[]>(signToData.size());
        for (Map.Entry<Integer, Map<String, Object>> mapEntry : signToData.entrySet()) {
            String value;
            Object[] objects = new Object[14];
            Map<String, Object> message = mapEntry.getValue();
            Integer integer = mapEntry.getKey();
            String weekStarAndEedDate = "";
            if ("mon".equals(cycle)) {
                value = integer.toString();
            } else if ("wek".equals(cycle)) {
                value = integer.toString();
                weekStarAndEedDate = yearToWeekTorange.get(year).get(integer);
            } else if ("qua".equals(cycle)) {
                value = integer.toString();
            } else {
                value = dayToDate.get(year).get(integer);
                if (value == null || value.isEmpty()) continue;
            }
            objects[0] = message.get("year");
            objects[1] = value;
            objects[2] = message.get("workcenter_r");
            objects[3] = message.get("download");
            objects[4] = message.get("planlaod");
            objects[5] = message.get("allload");
            objects[6] = message.get("ratecapacity");
            Object ratecapacity = message.get("ratecapacity");
            Object allload = message.get("allload");
            BigDecimal ratecapacity_b = BigDecimal.ZERO;
            if (ratecapacity != null) {
                ratecapacity_b = (BigDecimal)ratecapacity;
            }
            BigDecimal allload_b = BigDecimal.ZERO;
            if (allload != null) {
                allload_b = (BigDecimal)allload;
            }
            if (allload_b.compareTo(BigDecimal.ZERO) == 0 && ratecapacity_b.compareTo(BigDecimal.ZERO) == 0) continue;
            BigDecimal deveideNum = ratecapacity_b.compareTo(BigDecimal.ZERO) != 0 ? allload_b.divide(ratecapacity_b, 4, 0).multiply(new BigDecimal("100")) : new BigDecimal("999");
            objects[7] = deveideNum.compareTo(BigDecimal.ZERO) == 0 ? "0%" : deveideNum.toPlainString() + "%";
            objects[8] = cycle;
            objects[9] = deveideNum.compareTo(new BigDecimal(1000)) >= 0 ? new BigDecimal("999") : deveideNum;
            objects[10] = capacalcway;
            Object actresource = message.get("actresource");
            if (actresource == null) {
                actresource = 0L;
            }
            objects[11] = actresource;
            objects[12] = integer;
            objects[13] = weekStarAndEedDate;
            if (allloadiszerodata) {
                if (allload == null || ((BigDecimal)allload).compareTo(BigDecimal.ZERO) <= 0) continue;
                objectList.add(objects);
                continue;
            }
            objectList.add(objects);
        }
        return objectList;
    }

    private List<Map<String, Object>> getGroupToWorkcenter(DataSet planData, DynamicObject plan, Map<Long, Long> groupToWorkcenter, Map<Long, Long> orderToGroupMap, Boolean sign) {
        MPSGetBrachingData mpsGetBrachingData = new MPSGetBrachingData();
        Map groupWorkcenter = mpsGetBrachingData.mpsGetBrachingData(plan, planData);
        groupToWorkcenter.putAll(groupWorkcenter);
        MPSBranchingCalculate mpsBranchingCalculate = new MPSBranchingCalculate();
        List dataMessageByReport = mpsBranchingCalculate.getDataMessageByReport(groupToWorkcenter, planData, orderToGroupMap, sign);
        return dataMessageByReport;
    }
}

