/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mps.opplugin.basedata;

import java.util.Date;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;

public class CapacityDefinitionValidator
extends AbstractValidator {
    public void validate() {
        String opKey = this.getOperateKey();
        if ("save".equals(opKey) || "submit".equals(opKey)) {
            ExtendedDataEntity[] dataEntitys;
            for (ExtendedDataEntity data : dataEntitys = this.getDataEntities()) {
                this.checkData(data);
            }
        }
    }

    private void checkData(ExtendedDataEntity data) {
        DynamicObject obj = data.getDataEntity();
        DynamicObjectCollection col = obj.getDynamicObjectCollection("entryentity");
        for (int i = 0; i < col.size() - 1; ++i) {
            DynamicObject entry = (DynamicObject)col.get(i);
            Date beginDate = entry.getDate("startdate");
            Date endDate = entry.getDate("enddate");
            for (int j = i + 1; j < col.size(); ++j) {
                DynamicObject targetEtnry = (DynamicObject)col.get(j);
                Date targetBeginDate = targetEtnry.getDate("startdate");
                Date targetEndDate = targetEtnry.getDate("enddate");
                Long group = entry.getLong("group.id");
                Long targetGroup = targetEtnry.getLong("group.id");
                if (group.longValue() != targetGroup.longValue()) continue;
                if (beginDate.compareTo(targetBeginDate) >= 0 && beginDate.compareTo(targetEndDate) <= 0) {
                    this.addErrorMessage(data, String.format(ResManager.loadKDString((String)"\u7b2c[%1$s]\u884c\u5206\u5f55\u4e0e\u7b2c[%2$s]\u884c\u5206\u5f55\u751f\u6548\u671f\u95f4\u91cd\u53e0\u3002", (String)"CapacityDefinitionValidator_0", (String)"mmc-mps-opplugin", (Object[])new Object[0]), entry.getInt("seq"), targetEtnry.getInt("seq")));
                    continue;
                }
                if (endDate.compareTo(targetBeginDate) >= 0 && endDate.compareTo(targetEndDate) <= 0) {
                    this.addErrorMessage(data, String.format(ResManager.loadKDString((String)"\u7b2c[%1$s]\u884c\u5206\u5f55\u4e0e\u7b2c[%2$s]\u884c\u5206\u5f55\u751f\u6548\u671f\u95f4\u91cd\u53e0\u3002", (String)"CapacityDefinitionValidator_0", (String)"mmc-mps-opplugin", (Object[])new Object[0]), entry.getInt("seq"), targetEtnry.getInt("seq")));
                    continue;
                }
                if (beginDate.compareTo(targetBeginDate) > 0 || endDate.compareTo(targetEndDate) < 0) continue;
                this.addErrorMessage(data, String.format(ResManager.loadKDString((String)"\u7b2c[%1$s]\u884c\u5206\u5f55\u4e0e\u7b2c[%2$s]\u884c\u5206\u5f55\u751f\u6548\u671f\u95f4\u91cd\u53e0\u3002", (String)"CapacityDefinitionValidator_0", (String)"mmc-mps-opplugin", (Object[])new Object[0]), entry.getInt("seq"), targetEtnry.getInt("seq")));
            }
        }
    }
}

