/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mps.opplugin.botp;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.Algo;
import kd.bos.algo.AlgoContext;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.ExtendedDataEntitySet;
import kd.bos.entity.botp.plugin.AbstractConvertPlugIn;
import kd.bos.entity.botp.plugin.args.AfterBuildQueryParemeterEventArgs;
import kd.bos.entity.botp.plugin.args.AfterFieldMappingEventArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.mpscmm.common.enums.PrecisionAccountEnum;
import kd.mpscmm.msplan.mrp.business.helper.BillUnitAndQtytHelper;

public class ScheduleplanToOrderConvertOp
extends AbstractConvertPlugIn {
    private static final Log logger = LogFactory.getLog(ScheduleplanToOrderConvertOp.class);
    protected Map<String, String> cacheMap = new HashMap<String, String>();

    public void afterBuildQueryParemeter(AfterBuildQueryParemeterEventArgs e) {
        super.afterBuildQueryParemeter(e);
        e.addSrcField("id");
        e.addSrcField("sheduledate");
    }

    public void afterFieldMapping(AfterFieldMappingEventArgs e) {
        ExtendedDataEntitySet entitySet = e.getTargetExtDataEntitySet();
        String tgtMainType = this.getTgtMainType().toString();
        ExtendedDataEntity[] entitys = entitySet.FindByEntityKey(tgtMainType);
        Map<Object, DynamicObject> materialsMap = this.getMaterials(entitys, "treeentryentity");
        HashMap<Long, Set> orgMaterialIdMap = new HashMap<Long, Set>(entitys.length);
        HashSet<Long> masterIdSet = new HashSet<Long>(8);
        HashSet<Long> schedulePlanIds = new HashSet<Long>(entitys.length);
        for (int i = 0; i < entitys.length; ++i) {
            ExtendedDataEntity entity = entitys[i];
            DynamicObject order = entity.getDataEntity();
            Long orgid = order.get("org") == null ? 10000L : order.getDynamicObject("org").getLong("id");
            Long bailedorg = order.get("entrustdept") == null ? 0L : order.getDynamicObject("entrustdept").getLong("id");
            DynamicObjectCollection orderEntrys = order.getDynamicObjectCollection("treeentryentity");
            for (DynamicObject orderEntry : orderEntrys) {
                DynamicObject material = orderEntry.getDynamicObject("materielmasterid");
                if (material == null) continue;
                this.coverMultiUnit(orderEntry, materialsMap, this.cacheMap);
                masterIdSet.add(material.getLong("id"));
                orgMaterialIdMap.computeIfAbsent(orgid, k -> new HashSet(10)).add(material.getPkValue());
                long schedulePlanId = orderEntry.get("sourceentryseq") == null ? 0L : Long.parseLong(orderEntry.getString("sourceentryseq"));
                schedulePlanIds.add(schedulePlanId);
            }
            if (entity == null) continue;
            Map<Long, Map<String, Object>> mtfMessage = this.getMtfMessage(orgid, masterIdSet, bailedorg);
            this.setDefaultValue(entity, mtfMessage);
        }
        this.setVersionValue(entitys, schedulePlanIds);
    }

    private Map<Long, Map<String, Object>> getMtfMessage(Long orgid, Set<Long> masterIdSet, Long bailedorg) {
        Map mtfMessage = (Map)DispatchServiceHelper.invokeBizService((String)"bd", (String)"mpdm", (String)"IPlanScopeHelperService", (String)"getMaterialInwareInfo", (Object[])new Object[]{orgid, bailedorg, masterIdSet});
        return mtfMessage;
    }

    protected Map<Object, DynamicObject> getMaterials(ExtendedDataEntity[] entitys, String entryName) {
        HashSet<Long> materialIdSet = new HashSet<Long>(16);
        for (ExtendedDataEntity entity : entitys) {
            DynamicObject bill = entity.getDataEntity();
            DynamicObjectCollection entrys = bill.getDynamicObjectCollection(entryName);
            for (DynamicObject entry : entrys) {
                DynamicObject material;
                DynamicObject materialInfo = entry.getDynamicObject("material");
                if (materialInfo == null || (material = materialInfo.getDynamicObject("masterid")) == null) continue;
                materialIdSet.add(Long.valueOf(material.getPkValue().toString()));
            }
        }
        Map materialsMap = BusinessDataServiceHelper.loadFromCache((String)"bd_material", (String)"id,auxptyunit,unitconvertdir", (QFilter[])new QFilter[]{new QFilter("id", "in", materialIdSet)});
        return materialsMap;
    }

    private void setDefaultValue(ExtendedDataEntity entity, Map<Long, Map<String, Object>> mtfMessage) {
        DynamicObjectCollection treeentryentity;
        DynamicObject obj = entity.getDataEntity();
        DynamicObject bizOrg = obj.getDynamicObject("org");
        if (bizOrg != null && (treeentryentity = obj.getDynamicObjectCollection("treeentryentity")) != null && !treeentryentity.isEmpty()) {
            for (DynamicObject entry : treeentryentity) {
                DynamicObject masterid;
                long id;
                Map<String, Object> map;
                DynamicObject material = entry.getDynamicObject("material");
                if (material == null || (map = mtfMessage.get(id = (masterid = material.getDynamicObject("masterid")).getLong("id"))) == null) continue;
                entry.set("inwardept_id", map.get("inwarorg"));
                entry.set("warehouse_id", map.get("inwarehouse"));
                entry.set("location_id", map.get("inwarelocation"));
                entry.set("planscope_id", map.get("planscope"));
            }
        }
    }

    protected void coverMultiUnit(DynamicObject entityEntry, Map<Object, DynamicObject> materialsMap, Map<String, String> cacheMap) {
        DynamicObject materialInfo = entityEntry.getDynamicObject("material");
        if (materialInfo == null) {
            return;
        }
        DynamicObject material = materialInfo.getDynamicObject("masterid");
        DynamicObject materialUnit = materialInfo.getDynamicObject("mftunit");
        if (materialUnit == null) {
            return;
        }
        entityEntry.set("unit", (Object)materialUnit);
        DynamicObject baseunit = entityEntry.getDynamicObject("baseunit");
        BigDecimal baseqty = entityEntry.getBigDecimal("baseqty");
        if (baseunit == null || BigDecimal.ZERO.compareTo(baseqty) == 0) {
            return;
        }
        Object materialId = material.getPkValue();
        BigDecimal unit2ndRate = BillUnitAndQtytHelper.getUnitRateConv((Long)((Long)(material = materialsMap.get(materialId)).getPkValue()), (Long)((Long)materialUnit.getPkValue()), (Long)((Long)baseunit.getPkValue()), cacheMap);
        if (unit2ndRate == null || BigDecimal.ZERO.compareTo(unit2ndRate) == 0) {
            return;
        }
        BigDecimal qtyUnit2nd = BigDecimal.ZERO;
        if (baseqty != null && baseqty.compareTo(BigDecimal.ZERO) != 0) {
            qtyUnit2nd = baseqty.divide(unit2ndRate, materialUnit.getInt("precision"), PrecisionAccountEnum.getEnumByVal((int)materialUnit.getInt("precisionaccount")));
        }
        entityEntry.set("qty", (Object)qtyUnit2nd);
        entityEntry.set("planqty", (Object)qtyUnit2nd);
        DynamicObject auxptyunit = entityEntry.getDynamicObject("auxptyunit");
        String unitconvertdir = material.getString("unitconvertdir");
        if (auxptyunit != null && ("A".equals(unitconvertdir) || "C".equals(unitconvertdir))) {
            BigDecimal auxptyRate = BillUnitAndQtytHelper.getUnitRateConv((Long)((Long)material.getPkValue()), (Long)((Long)auxptyunit.getPkValue()), (Long)((Long)baseunit.getPkValue()), cacheMap);
            BigDecimal auxptyqty = BigDecimal.ZERO;
            if (baseqty != null && baseqty.compareTo(BigDecimal.ZERO) != 0 && auxptyRate.compareTo(BigDecimal.ZERO) != 0) {
                auxptyqty = baseqty.divide(auxptyRate, auxptyunit.getInt("precision"), PrecisionAccountEnum.getEnumByVal((int)auxptyunit.getInt("precisionaccount")));
            }
            entityEntry.set("auxptyqty", (Object)auxptyqty);
        }
    }

    private void setVersionValue(ExtendedDataEntity[] entitys, Set<Long> schedulePlanIds) {
        if (entitys.length < 1) {
            return;
        }
        logger.info("ScheduleplanToOrderConvertOp setVersionValue begin ");
        try (AlgoContext context = Algo.newContext();){
            QFilter qf = new QFilter("id", "in", schedulePlanIds);
            DataSet scheduleplanDataset = QueryServiceHelper.queryDataSet((String)(((Object)((Object)this)).getClass().getName() + "setVersionValue"), (String)"mps_scheduleplan", (String)"id,entryentity.ontime,entryentity.instocktime,sheduledate", (QFilter[])qf.toArray(), null);
            if (scheduleplanDataset == null) {
                return;
            }
            for (ExtendedDataEntity entity : entitys) {
                DynamicObject obj = entity.getDataEntity();
                DynamicObjectCollection treeentryentity = obj.getDynamicObjectCollection("treeentryentity");
                if (treeentryentity == null || treeentryentity.isEmpty()) continue;
                for (DynamicObject entry : treeentryentity) {
                    long schedulePlanId;
                    DataSet finish = scheduleplanDataset.copy().groupBy(new String[]{"id", "sheduledate"}).min("entryentity.ontime").max("entryentity.instocktime").finish();
                    long l = schedulePlanId = entry.get("sourceentryseq") == null ? 0L : Long.parseLong(entry.getString("sourceentryseq"));
                    DataSet filter = finish.filter("id = " + schedulePlanId);
                    if (!filter.hasNext()) continue;
                    Row row = filter.next();
                    Object ontime = row.get("entryentity.ontime");
                    if (ontime != null) {
                        entry.set("planbegintime", ontime);
                    } else {
                        entry.set("planbegintime", row.get("sheduledate"));
                    }
                    Object instocktime = row.get("entryentity.instocktime");
                    if (instocktime != null) {
                        entry.set("planendtime", instocktime);
                        continue;
                    }
                    entry.set("planendtime", row.get("sheduledate"));
                }
            }
        }
        logger.info("ScheduleplanToOrderConvertOp setVersionValue and ");
    }
}

