/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mps.mservice.license;

import java.util.ArrayList;
import kd.bos.context.RequestContext;
import kd.bos.entity.AppInfo;
import kd.bos.entity.AppMetadataCache;
import kd.bos.form.FormShowParameter;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.license.api.LicenseCheckResult;
import kd.bos.list.ListShowParameter;
import kd.bos.servicehelper.license.LicenseServiceHelper;

public interface MpsLicense {
    default public LicenseCheckResult checkLicense(String appId, String formId) {
        LicenseCheckResult re = null;
        ArrayList<String> keys = new ArrayList<String>(16);
        keys.add("mps_scheduledata");
        if (keys.contains(formId)) {
            Long userId = Long.parseLong(RequestContext.get().getUserId());
            AppInfo info = AppMetadataCache.getAppInfo((String)appId);
            re = LicenseServiceHelper.checkByAppAndBizObj((String)info.getId(), (String)"mps_scheduleplan", (Long)userId);
        }
        return re;
    }

    default public void mpsPreOpen(PreOpenFormEventArgs e) {
        LicenseCheckResult re;
        String appId;
        FormShowParameter fs = (FormShowParameter)e.getSource();
        fs.setHasRight(true);
        String formId = fs.getFormId();
        if (formId.equals("bos_list")) {
            ListShowParameter source = (ListShowParameter)e.getSource();
            formId = source.getBillFormId();
        }
        if ((appId = e.getFormShowParameter().getAppId()) == null || appId.isEmpty()) {
            appId = "mps";
        }
        if ((re = this.checkLicense(appId, formId)) != null && !re.getHasLicense().booleanValue()) {
            e.setCancel(true);
            e.setCancelMessage(re.getMsg());
            e.setCancelFormShowParameter(re.getCancelFormShowParameter());
        }
    }
}

