/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mps.mservice.upgrade;

import java.util.ArrayList;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.service.upgrade.UpgradeResult;

public class ExcuteSQLMPSMuLanguageSynHistory {
    private static final String ALGO_KEY = ExcuteSQLMPSMuLanguageSynHistory.class.getName();
    private static final DBRoute DB_ROUTE = DBRoute.of((String)"scm");
    private static final int BATCH_NUM = 1000;
    private static final int DEFAULT_BATCHSIZE = 5000;

    public static UpgradeResult synHistoryData() {
        UpgradeResult result = new UpgradeResult();
        String queryDropLog = "SELECT FID, FINITTYPE, FINITTEXT FROM T_MPS_INITDATA WHERE FID NOT IN (SELECT FID FROM T_MPS_INITDATA_L)";
        DataSet dropLogDataSet = DB.queryDataSet((String)ALGO_KEY, (DBRoute)DB_ROUTE, (String)queryDropLog);
        int count = dropLogDataSet.copy().count("FID", false);
        String[] pkids = DB.genStringIds((String)"T_MPS_INITDATA_L", (int)count);
        ArrayList<Object[]> updateParamList = new ArrayList<Object[]>(count);
        int i = 0;
        for (Row row : dropLogDataSet) {
            Long mappingEntryId = row.getLong("FID");
            String inittype = row.getString("FINITTYPE");
            String inittext = row.getString("FINITTEXT");
            Object[] param = new Object[]{pkids[i], mappingEntryId, "zh_CN", inittype, inittext};
            updateParamList.add(param);
            ++i;
        }
        String insertSQL = "INSERT INTO T_MPS_INITDATA_L(FPKID, FID, FLOCALEID, FINITTYPE, FINITTEXT) VALUES (?,?,?,?,?)";
        if (updateParamList.size() != 0) {
            ExcuteSQLMPSMuLanguageSynHistory.batchSave(DB_ROUTE, insertSQL, updateParamList);
        }
        result.setSuccess(true);
        return result;
    }

    public static void batchSave(DBRoute dbRoute, String sql, List<Object[]> values) {
        int totalCount = values.size();
        if (totalCount > 5000) {
            int times = totalCount / 5000;
            times = totalCount % 5000 != 0 ? times + 1 : times;
            for (int i = 0; i < times; ++i) {
                int startIndex = i * 5000;
                int endIndex = Math.min(startIndex + 5000, totalCount);
                DB.executeBatch((DBRoute)dbRoute, (String)sql, values.subList(startIndex, endIndex));
            }
        } else {
            DB.executeBatch((DBRoute)dbRoute, (String)sql, values);
        }
    }
}

