/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mps.mservice.upgrade;

import java.util.ArrayList;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;

public class proplanschdefUpgradeService
implements IUpgradeService {
    private static final String ALGO_KEY = proplanschdefUpgradeService.class.getName();
    private static final DBRoute DB_ROUTE = DBRoute.of((String)"scm");
    private static final int BATCH_NUM = 1000;

    public UpgradeResult afterExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult result = new UpgradeResult();
        try {
            this.upgrade();
            result.setSuccess(true);
            result.setLog("proplanschdefUpgradeLog upgrade success");
        }
        catch (Exception e) {
            result.setSuccess(false);
            result.setErrorInfo(e.getMessage());
            result.setLog("proplanschdefUpgradeLog upgrade failed");
        }
        return result;
    }

    private void upgrade() {
        String queryDropLog = "select fid, fcapacalcway from t_mps_propsdef";
        DataSet dropLogDataSet = DB.queryDataSet((String)ALGO_KEY, (DBRoute)DB_ROUTE, (String)queryDropLog);
        ArrayList<Object[]> updateParamList = new ArrayList<Object[]>(1000);
        for (Row row : dropLogDataSet) {
            Long planOrderId = row.getLong("fid");
            if (!row.getString("fcapacalcway").isEmpty()) continue;
            Object[] param = new Object[]{"A", planOrderId};
            updateParamList.add(param);
        }
        String updateDropLog = "update t_mps_propsdef set fcapacalcway = ? where fid = ?;";
        if (updateParamList.size() != 0) {
            DB.executeBatch((DBRoute)DB_ROUTE, (String)updateDropLog, updateParamList);
        }
    }
}

