/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mps.calcnode;

import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.mmc.mps.calcnode.MPSBranchingCalculate;
import kd.mmc.mps.calcnode.MPSGenprocessData;
import kd.mmc.mps.calcnode.MPSGetBrachingData;
import kd.mmc.mps.calcnode.MPSGetBusinessData;
import kd.mmc.mps.calcnode.MPSInitReduOrder;
import kd.mmc.mps.calcnode.MpsMatchDimension;
import kd.mmc.mps.common.model.ReduOrderModel;
import kd.mpscmm.msplan.mservice.service.mrp.ExecutionEnv;
import kd.mpscmm.msplan.mservice.service.mrp.step.ICalcStep;

public class MPSBranchingCalculateStep
implements ICalcStep {
    public String doWork(ExecutionEnv env, int stepIdx) {
        String message = this.mpsBranchingCalculate(env);
        return message;
    }

    public String mpsBranchingCalculate(ExecutionEnv env) {
        StringBuilder message = new StringBuilder();
        String logEntityNumber = env.getLogEntityNumber();
        DynamicObject runlog = BusinessDataServiceHelper.loadSingle((Object)env.getCtxId(), (String)logEntityNumber);
        String planEntityNumber = runlog.getString("plangramentity");
        Object planId = runlog.get("plangram");
        DynamicObject plan = BusinessDataServiceHelper.loadSingle((Object)planId, (String)planEntityNumber);
        MPSGetBusinessData mpsGetBusinessData = new MPSGetBusinessData();
        DataSet dataSet = mpsGetBusinessData.mpsGetBusinessData(plan);
        DataSet filterDataSet = this.filterOrg(dataSet, runlog);
        MPSGetBrachingData mpsGetBrachingData = new MPSGetBrachingData();
        Map<Long, Long> groupToWorkcenter = mpsGetBrachingData.mpsGetBrachingData(plan, filterDataSet);
        MPSBranchingCalculate mpsBranchingCalculate = new MPSBranchingCalculate(env);
        Map<String, Object> mpsGenprocessMessage = mpsBranchingCalculate.getMpsGenprocessData(groupToWorkcenter, filterDataSet, plan, runlog);
        MPSInitReduOrder mpsInitReduOrder = new MPSInitReduOrder();
        List<ReduOrderModel> initReduOrder = mpsInitReduOrder.getInitReduOrder(plan, mpsGenprocessMessage, false);
        MpsMatchDimension mpsMatchDimension = new MpsMatchDimension();
        mpsMatchDimension.getDimension(initReduOrder, mpsGenprocessMessage, plan);
        MPSGenprocessData mpsGenprocessData = new MPSGenprocessData();
        mpsGenprocessData.mpsGenprocessData(mpsGenprocessMessage, message, initReduOrder);
        return message.toString();
    }

    private DataSet filterOrg(DataSet dataSet, DynamicObject runlog) {
        if (dataSet != null) {
            long createorg = runlog.getDynamicObject("createorg").getLong("id");
            StringBuilder sb = new StringBuilder("production_org = ");
            sb.append(createorg);
            DataSet filterDataSet = dataSet.filter(sb.toString());
            return filterDataSet;
        }
        return null;
    }
}

