/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mps.calcnode;

import java.util.HashSet;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Field;
import kd.bos.algo.RowMeta;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.exception.KDBizException;
import kd.mmc.mps.consts.schedule.SchedulePlanErrors;
import kd.mpscmm.msplan.mservice.service.datafetch.DataFetcher;

public class MPSGetBusinessData {
    public DataSet mpsGetBusinessData(DynamicObject plan) {
        Set<Long> orderModelId = this.getOrderModelId(plan);
        DataSet orderDataset = this.getOrderDataset(orderModelId);
        return orderDataset;
    }

    public DataSet getOrderDataset(Set<Long> modelIds) {
        DataSet dataSet = null;
        DataFetcher dataFetcher = new DataFetcher();
        for (Long modelId : modelIds) {
            DataSet dsItem = dataFetcher.getDataSet(modelId);
            if (dsItem.isEmpty()) {
                return null;
            }
            if (dataSet == null) {
                dataSet = dsItem;
                continue;
            }
            RowMeta leftRowMeta = dataSet.getRowMeta();
            RowMeta rightRowMeta = dsItem.getRowMeta();
            Field[] leftFields = leftRowMeta.getFields();
            Field[] rightFields = rightRowMeta.getFields();
            HashSet<String> allFieldName = new HashSet<String>(16);
            HashSet<String> leftName = new HashSet<String>(16);
            HashSet<String> rightName = new HashSet<String>(16);
            for (Field leftField : leftFields) {
                allFieldName.add(leftField.getName());
                leftName.add(leftField.getName());
            }
            for (Field rightField : rightFields) {
                allFieldName.add(rightField.getName());
                rightName.add(rightField.getName());
            }
            for (String fieldName : allFieldName) {
                if (!leftName.contains(fieldName)) {
                    dataSet = dataSet.addNullField(fieldName);
                }
                if (rightName.contains(fieldName)) continue;
                dsItem = dsItem.addNullField(fieldName);
            }
            dataSet = dataSet.select(allFieldName.toArray(new String[0]));
            dsItem = dsItem.select(allFieldName.toArray(new String[0]));
            dataSet = dataSet.union(dsItem);
        }
        return dataSet;
    }

    public Set<Long> getOrderModelId(DynamicObject plan) {
        DynamicObjectCollection orderEntryColl = plan.getDynamicObjectCollection("order_entryentity");
        HashSet<Long> idSet = new HashSet<Long>(orderEntryColl.size());
        if (orderEntryColl != null && !orderEntryColl.isEmpty()) {
            for (DynamicObject order : orderEntryColl) {
                boolean isCalculate = false;
                if (order.get("isincalculate") != null) {
                    isCalculate = order.getBoolean("isincalculate");
                }
                if (!isCalculate || order.get("resourceconfig") == null) continue;
                idSet.add(order.getLong("resourceconfig_id"));
            }
            if (idSet.size() == 0) {
                throw new KDBizException(SchedulePlanErrors.orderNoOrderModel(), new Object[0]);
            }
        }
        return idSet;
    }
}

