/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mps.calcnode;

import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.portal.util.DateUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.mmc.mps.common.model.CapacityRateModel;
import kd.mmc.mps.common.model.MPSPlanProgramModel;
import kd.mmc.mps.common.model.MutexModel;
import kd.mmc.mps.common.model.ProductionrulesModel;
import kd.mmc.mps.common.util.MPSScheduleUtils;
import kd.mmc.mps.consts.schedule.SchedulePlanErrors;

public class MPSGetCapacityData {
    private static final Log logger = LogFactory.getLog(MPSGetCapacityData.class);
    String concatStr = ".";

    public void getCapacityData(MPSPlanProgramModel mpsPlanProgramModel, DynamicObject plan, Map<String, Object> capacityMessage, DynamicObject runlog) {
        Map orderIdToGroupDefineIdMap = (Map)capacityMessage.get("orderIdToGroupDefineIdMap");
        DynamicObjectCollection intensiveColl = MPSScheduleUtils.queryIntensiveColl((Map)orderIdToGroupDefineIdMap);
        MPSScheduleUtils.getGroupAndGroupDefineRelation((DynamicObjectCollection)intensiveColl, capacityMessage);
        this.getWorkCenterByProplanschde(mpsPlanProgramModel, capacityMessage);
        this.getMutexMessage(capacityMessage, runlog);
        this.getChangeMessage(plan, capacityMessage);
        Map<Long, Long> workCenterToRuleMap = this.getWorkCenterToProductionruleByProplanschde(plan);
        Map<Object, DynamicObject> productionRules = this.queryProductionrules(workCenterToRuleMap);
        Map<Object, DynamicObject> capacityDefMap = this.queryCapacityDef(productionRules);
        this.getCapacityMessage(productionRules, capacityDefMap, intensiveColl, capacityMessage);
    }

    public void getCapacityMessage(Map<Object, DynamicObject> productionRules, Map<Object, DynamicObject> capacityDefMap, DynamicObjectCollection intensiveColl, Map<String, Object> capacityMessage) {
        List workCenterIdList = (List)capacityMessage.get("workCenterIdList");
        Map groupDefineToGroupMap = (Map)capacityMessage.get("groupDefineToGroupMap");
        HashMap<Long, List<Long>> groupIdToWorkCentersMap = new HashMap<Long, List<Long>>(8);
        HashMap<Long, Set<String>> groupIdToPlanTypesMap = new HashMap<Long, Set<String>>(8);
        HashMap<Long, List> capacityRateMap = new HashMap<Long, List>(8);
        HashMap surplusCapacityMap = new HashMap(8);
        HashMap<Long, HashMap<String, BigDecimal>> groupIdTotalCapacityMap = new HashMap<Long, HashMap<String, BigDecimal>>(8);
        HashMap<String, HashMap<String, BigDecimal>> groupIdDateCapacityMap = new HashMap<String, HashMap<String, BigDecimal>>(8);
        HashMap<String, Map<String, BigDecimal>> workCenterGroupIdToUpCapacityMap = new HashMap<String, Map<String, BigDecimal>>(8);
        HashMap<String, BigDecimal> groupIdToRatioMap = new HashMap<String, BigDecimal>(16);
        HashMap<Long, List<ProductionrulesModel>> produceMessage = new HashMap<Long, List<ProductionrulesModel>>(8);
        for (Map.Entry<Object, DynamicObject> productionRuleDynEntry : productionRules.entrySet()) {
            DynamicObject productionRuleDyn = productionRuleDynEntry.getValue();
            long l = productionRuleDyn.getLong("workcenter.id");
            String productionType = productionRuleDyn.getString("productiontype");
            long capacityId = productionRuleDyn.getLong("capacitydefinition.id");
            DynamicObject capacityDef = capacityDefMap.get(capacityId);
            SimpleDateFormat si = new SimpleDateFormat("yyyy-MM-dd");
            HashMap<String, BigDecimal> dateAndCapacity = new HashMap<String, BigDecimal>(8);
            if (StringUtils.equals((CharSequence)"A", (CharSequence)productionType)) {
                DynamicObjectCollection rEntryEntity = productionRuleDyn.getDynamicObjectCollection("r_entryentity");
                List list = rEntryEntity.stream().filter(x -> groupDefineToGroupMap.values().contains(x.getLong("r_group.id"))).collect(Collectors.toList());
                if (!CollectionUtils.isEmpty(list)) {
                    List surplusCapacityList = list.stream().sorted((o1, o2) -> o2.getInt("r_priority") - o1.getInt("r_priority")).map(x -> x.getLong("r_group.id")).collect(Collectors.toList());
                    surplusCapacityMap.put(l, surplusCapacityList);
                }
                this.getProduceMessage(productionRuleDyn, l, produceMessage);
                DynamicObjectCollection entryentitys = capacityDef.getDynamicObjectCollection("entryentity");
                for (Iterator capacityEntity : entryentitys) {
                    int maxCapacity = capacityEntity.getInt("maxcapacity");
                    BigDecimal maxCapacity_big = new BigDecimal(Integer.toString(maxCapacity));
                    Date startDate = capacityEntity.getDate("startdate");
                    Date endDate = capacityEntity.getDate("enddate");
                    if (startDate == null || endDate == null) continue;
                    Date tempDate = startDate;
                    while (!endDate.before(tempDate)) {
                        String format_date = si.format(tempDate);
                        dateAndCapacity.put(format_date, maxCapacity_big);
                        DynamicObjectCollection entryEntity = productionRuleDyn.getDynamicObjectCollection("e_entryentity");
                        logger.info("entityDyn\uff1a" + entryEntity.size());
                        for (DynamicObject entityDyn : entryEntity) {
                            long groupId = entityDyn.getLong("e_group.id");
                            int ratio = entityDyn.getInt("e_ratio");
                            String type = entityDyn.getString("e_type");
                            int max = entityDyn.getInt("e_max");
                            BigDecimal groupCapacity = BigDecimal.ZERO;
                            boolean entryHasGroup = false;
                            String unionKey = l + this.concatStr + groupId;
                            HashMap<String, BigDecimal> dateAndGroupUpCapatity = (HashMap<String, BigDecimal>)workCenterGroupIdToUpCapacityMap.get(unionKey);
                            if (dateAndGroupUpCapatity == null) {
                                dateAndGroupUpCapatity = new HashMap<String, BigDecimal>(8);
                            }
                            groupCapacity = this.getCapacity(new BigDecimal(Integer.toString(maxCapacity)), ratio, type, max, RoundingMode.UP, dateAndGroupUpCapatity, format_date);
                            workCenterGroupIdToUpCapacityMap.put(unionKey, dateAndGroupUpCapatity);
                            HashMap<String, BigDecimal> dateAndGroupCapatity = (HashMap<String, BigDecimal>)groupIdDateCapacityMap.get(unionKey);
                            if (dateAndGroupCapatity == null) {
                                dateAndGroupCapatity = new HashMap<String, BigDecimal>(8);
                            }
                            dateAndGroupCapatity.put(format_date, groupCapacity);
                            groupIdDateCapacityMap.put(unionKey, dateAndGroupCapatity);
                            logger.info("unionKey\uff1a" + groupId + ":" + groupCapacity + ":" + ratio);
                            groupIdToRatioMap.put(unionKey, new BigDecimal(Integer.toString(ratio)));
                            this.addGroupWorkCenter(groupIdToWorkCentersMap, l, groupId);
                            this.addGroupPlanType(groupIdToPlanTypesMap, productionType, groupId);
                            entryHasGroup = true;
                            DynamicObjectCollection subEntryEntity = entityDyn.getDynamicObjectCollection("subentryentity");
                            for (DynamicObject subEntityDyn : subEntryEntity) {
                                BigDecimal capacity;
                                long subGroupId = subEntityDyn.getLong("s_group.id");
                                unionKey = l + this.concatStr + subGroupId;
                                this.addGroupWorkCenter(groupIdToWorkCentersMap, l, subGroupId);
                                this.addGroupPlanType(groupIdToPlanTypesMap, productionType, subGroupId);
                                int subRatio = subEntityDyn.getInt("s_ratio");
                                String constraintType = subEntityDyn.getString("s_constrainttype");
                                String subType = subEntityDyn.getString("s_type");
                                int subMax = subEntityDyn.getInt("s_max");
                                HashMap<String, BigDecimal> dateAndGroupUpCapatity_child = (HashMap<String, BigDecimal>)workCenterGroupIdToUpCapacityMap.get(unionKey);
                                if (dateAndGroupUpCapatity_child == null) {
                                    dateAndGroupUpCapatity_child = new HashMap<String, BigDecimal>(8);
                                }
                                if (StringUtils.equals((CharSequence)"A", (CharSequence)constraintType)) {
                                    capacity = this.getCapacity(new BigDecimal(Integer.toString(maxCapacity)), subRatio, subType, subMax, RoundingMode.DOWN, dateAndGroupUpCapatity_child, format_date);
                                    groupIdToRatioMap.put(unionKey, new BigDecimal(Integer.toString(ratio)).multiply(new BigDecimal(Integer.toString(subRatio))).divide(new BigDecimal(100), new MathContext(12)));
                                } else {
                                    capacity = this.getCapacity(groupCapacity, subRatio, subType, subMax, RoundingMode.DOWN, dateAndGroupUpCapatity_child, format_date);
                                    groupIdToRatioMap.put(unionKey, new BigDecimal(Integer.toString(subRatio)));
                                }
                                this.getParentUpCatatity(dateAndGroupUpCapatity_child, format_date, groupId, l, workCenterGroupIdToUpCapacityMap);
                                workCenterGroupIdToUpCapacityMap.put(unionKey, dateAndGroupUpCapatity);
                                HashMap<String, BigDecimal> dateAndGroupCapatity_child = (HashMap<String, BigDecimal>)groupIdDateCapacityMap.get(unionKey);
                                if (dateAndGroupCapatity_child == null) {
                                    dateAndGroupCapatity_child = new HashMap<String, BigDecimal>(8);
                                }
                                dateAndGroupCapatity_child.put(format_date, capacity);
                                groupIdDateCapacityMap.put(unionKey, dateAndGroupCapatity_child);
                                if (!entryHasGroup) continue;
                                List capacityRateModels = capacityRateMap.computeIfAbsent(l, k -> new ArrayList(10));
                                CapacityRateModel capacityRateModel = new CapacityRateModel(Long.valueOf(groupId), Long.valueOf(subGroupId), new BigDecimal(Integer.toString(subRatio)).divide(new BigDecimal(100), new MathContext(12)));
                                capacityRateModels.add(capacityRateModel);
                            }
                        }
                        DynamicObjectCollection r_entryentity = productionRuleDyn.getDynamicObjectCollection("r_entryentity");
                        for (DynamicObject entityDyn : r_entryentity) {
                            long groupId = entityDyn.getLong("r_group.id");
                            int priorit = entityDyn.getInt("r_priority");
                            String unionKey = l + this.concatStr + groupId;
                            if (groupIdToRatioMap.containsKey(unionKey)) continue;
                            groupIdToRatioMap.put(unionKey, new BigDecimal(priorit));
                            this.addGroupWorkCenter(groupIdToWorkCentersMap, l, groupId);
                            this.addGroupPlanType(groupIdToPlanTypesMap, productionType, groupId);
                        }
                        tempDate = DateUtils.addDays((Date)tempDate, (int)1);
                    }
                }
                groupIdTotalCapacityMap.put(l, dateAndCapacity);
                continue;
            }
            for (Map.Entry entry : productionRules.entrySet()) {
                Iterator capacityEntity;
                DynamicObject productionRuleDyn_change = (DynamicObject)entry.getValue();
                DynamicObjectCollection entryEntity = productionRuleDyn_change.getDynamicObjectCollection("e_entryentity");
                capacityEntity = entryEntity.iterator();
                while (capacityEntity.hasNext()) {
                    DynamicObject entityDyn = (DynamicObject)capacityEntity.next();
                    long groupId = entityDyn.getLong("e_group.id");
                    String unionKey = l + this.concatStr + groupId;
                    if (!groupDefineToGroupMap.containsValue(groupId)) continue;
                    this.addGroupWorkCenter(groupIdToWorkCentersMap, l, groupId);
                    this.addGroupPlanType(groupIdToPlanTypesMap, productionType, groupId);
                    groupIdToRatioMap.put(unionKey, BigDecimal.ZERO);
                }
                DynamicObjectCollection r_entryentity = productionRuleDyn.getDynamicObjectCollection("r_entryentity");
                for (DynamicObject entityDyn : r_entryentity) {
                    long groupId = entityDyn.getLong("r_group.id");
                    int priorit = entityDyn.getInt("r_priority");
                    String unionKey = l + this.concatStr + groupId;
                    if (groupIdToRatioMap.containsKey(unionKey)) continue;
                    groupIdToRatioMap.put(unionKey, new BigDecimal(priorit));
                    this.addGroupWorkCenter(groupIdToWorkCentersMap, l, groupId);
                    this.addGroupPlanType(groupIdToPlanTypesMap, productionType, groupId);
                }
            }
            DynamicObjectCollection entryEntity = capacityDef.getDynamicObjectCollection("entryentity");
            for (DynamicObject capacityEntity : entryEntity) {
                dateAndCapacity = new HashMap(8);
                Long groupId = capacityEntity.getLong("group.id");
                if (!groupDefineToGroupMap.containsValue(groupId)) continue;
                this.addGroupWorkCenter(groupIdToWorkCentersMap, l, groupId);
                this.addGroupPlanType(groupIdToPlanTypesMap, productionType, groupId);
                String unionKey = l + this.concatStr + groupId;
                int maxCapacity = capacityEntity.getInt("maxcapacity");
                Date startDate = capacityEntity.getDate("startdate");
                Date endDate = capacityEntity.getDate("enddate");
                BigDecimal maxCapacity_big = new BigDecimal(Integer.toString(maxCapacity));
                this.getEffectDateList(startDate, endDate, dateAndCapacity, maxCapacity_big, si);
                groupIdDateCapacityMap.put(unionKey, dateAndCapacity);
            }
        }
        ArrayList<Long> groupErrorList = new ArrayList<Long>();
        Map plantype = (Map)capacityMessage.get("groupIdToPlanTypeMap");
        for (Map.Entry entry : groupIdToPlanTypesMap.entrySet()) {
            List collect;
            Long groupId = (Long)entry.getKey();
            Set typeList = (Set)entry.getValue();
            if (typeList.size() != 1) {
                groupErrorList.add(groupId);
                continue;
            }
            String productionType = (String)typeList.iterator().next();
            plantype.put(entry.getKey(), productionType);
            List longList = (List)groupIdToWorkCentersMap.get(groupId);
            if (StringUtils.equals((CharSequence)"A", (CharSequence)productionType)) {
                if (longList == null) continue;
                collect = longList.stream().sorted((o2, o1) -> ((BigDecimal)groupIdToRatioMap.get(o1 + this.concatStr + groupId)).compareTo((BigDecimal)groupIdToRatioMap.get(o2 + this.concatStr + groupId))).collect(Collectors.toList());
                groupIdToWorkCentersMap.put(groupId, collect);
                continue;
            }
            if (longList == null) continue;
            collect = longList.stream().sorted((o1, o2) -> workCenterIdList.indexOf(o1) - workCenterIdList.indexOf(o2)).collect(Collectors.toList());
            groupIdToWorkCentersMap.put(groupId, collect);
        }
        if (!CollectionUtils.isEmpty(groupErrorList)) {
            ArrayList<String> errorNumberList = new ArrayList<String>(groupErrorList.size());
            for (DynamicObject dynamicObject : intensiveColl) {
                if (!groupErrorList.contains(dynamicObject.getLong("group"))) continue;
                errorNumberList.add(dynamicObject.getString("number"));
            }
            throw new KDBizException(SchedulePlanErrors.groupProdTypeError(), new Object[]{StringUtils.join(errorNumberList, (String)",")});
        }
        capacityMessage.put("workCenterAndProduce", produceMessage);
        capacityMessage.put("groupIdToWorkCentersMap", groupIdToWorkCentersMap);
        capacityMessage.put("capacityRateMap", capacityRateMap);
        capacityMessage.put("surplusCapacityMap", surplusCapacityMap);
        capacityMessage.put("groupIdTotalCapacityMap", groupIdTotalCapacityMap);
        capacityMessage.put("groupIdDateCapacityMap", groupIdDateCapacityMap);
        capacityMessage.put("workCenterGroupIdToUpCapacityMap", workCenterGroupIdToUpCapacityMap);
    }

    public Map<Long, Long> getGroupToWorkCenter(Map<Object, DynamicObject> productionRules, Map<Object, DynamicObject> capacityDefMap, Map<String, Object> capacityMessage) {
        List workCenterIdList = (List)capacityMessage.get("workCenterIdList");
        Map groupDefineToGroupMap = (Map)capacityMessage.get("groupDefineToGroupMap");
        HashMap<Long, List<Long>> groupIdToWorkCentersMap = new HashMap<Long, List<Long>>(8);
        HashMap<Long, Set<String>> groupIdToPlanTypesMap = new HashMap<Long, Set<String>>(8);
        HashMap<Long, List> capacityRateMap = new HashMap<Long, List>(8);
        HashMap<String, HashMap<String, BigDecimal>> groupIdDateCapacityMap = new HashMap<String, HashMap<String, BigDecimal>>(8);
        HashMap<String, Map<String, BigDecimal>> workCenterGroupIdToUpCapacityMap = new HashMap<String, Map<String, BigDecimal>>(8);
        HashMap<String, BigDecimal> groupIdToRatioMap = new HashMap<String, BigDecimal>(16);
        for (Map.Entry<Object, DynamicObject> entry : productionRules.entrySet()) {
            DynamicObject productionRuleDyn = entry.getValue();
            long workCenterId = productionRuleDyn.getLong("workcenter.id");
            String productionType = productionRuleDyn.getString("productiontype");
            long capacityId = productionRuleDyn.getLong("capacitydefinition.id");
            DynamicObject capacityDef = capacityDefMap.get(capacityId);
            SimpleDateFormat si = new SimpleDateFormat("yyyy-MM-dd");
            if (StringUtils.equals((CharSequence)"A", (CharSequence)productionType)) {
                DynamicObjectCollection entryentitys = capacityDef.getDynamicObjectCollection("entryentity");
                for (DynamicObject capacityEntity : entryentitys) {
                    int maxCapacity = capacityEntity.getInt("maxcapacity");
                    BigDecimal maxCapacity_big = new BigDecimal(Integer.toString(maxCapacity));
                    Date startDate = capacityEntity.getDate("startdate");
                    Date endDate = capacityEntity.getDate("enddate");
                    if (startDate == null || endDate == null) continue;
                    Date tempDate = startDate;
                    while (!endDate.before(tempDate)) {
                        String format_date = si.format(tempDate);
                        DynamicObjectCollection entryEntity = productionRuleDyn.getDynamicObjectCollection("e_entryentity");
                        logger.info("entityDyn\uff1a" + entryEntity.size());
                        for (DynamicObject entityDyn : entryEntity) {
                            long groupId = entityDyn.getLong("e_group.id");
                            int ratio = entityDyn.getInt("e_ratio");
                            String type = entityDyn.getString("e_type");
                            int max = entityDyn.getInt("e_max");
                            BigDecimal groupCapacity = BigDecimal.ZERO;
                            boolean entryHasGroup = false;
                            String unionKey = workCenterId + this.concatStr + groupId;
                            HashMap<String, BigDecimal> dateAndGroupUpCapatity = (HashMap<String, BigDecimal>)workCenterGroupIdToUpCapacityMap.get(unionKey);
                            if (dateAndGroupUpCapatity == null) {
                                dateAndGroupUpCapatity = new HashMap<String, BigDecimal>(8);
                            }
                            groupCapacity = this.getCapacity(new BigDecimal(Integer.toString(maxCapacity)), ratio, type, max, RoundingMode.UP, dateAndGroupUpCapatity, format_date);
                            workCenterGroupIdToUpCapacityMap.put(unionKey, dateAndGroupUpCapatity);
                            HashMap<String, BigDecimal> dateAndGroupCapatity = (HashMap<String, BigDecimal>)groupIdDateCapacityMap.get(unionKey);
                            if (dateAndGroupCapatity == null) {
                                dateAndGroupCapatity = new HashMap<String, BigDecimal>(8);
                            }
                            dateAndGroupCapatity.put(format_date, groupCapacity);
                            groupIdDateCapacityMap.put(unionKey, dateAndGroupCapatity);
                            logger.info("unionKey\uff1a" + groupId + ":" + groupCapacity + ":" + ratio);
                            groupIdToRatioMap.put(unionKey, new BigDecimal(Integer.toString(ratio)));
                            this.addGroupWorkCenter(groupIdToWorkCentersMap, workCenterId, groupId);
                            this.addGroupPlanType(groupIdToPlanTypesMap, productionType, groupId);
                            entryHasGroup = true;
                            DynamicObjectCollection subEntryEntity = entityDyn.getDynamicObjectCollection("subentryentity");
                            for (DynamicObject subEntityDyn : subEntryEntity) {
                                BigDecimal capacity;
                                long subGroupId = subEntityDyn.getLong("s_group.id");
                                unionKey = workCenterId + this.concatStr + subGroupId;
                                this.addGroupWorkCenter(groupIdToWorkCentersMap, workCenterId, subGroupId);
                                this.addGroupPlanType(groupIdToPlanTypesMap, productionType, subGroupId);
                                int subRatio = subEntityDyn.getInt("s_ratio");
                                String constraintType = subEntityDyn.getString("s_constrainttype");
                                String subType = subEntityDyn.getString("s_type");
                                int subMax = subEntityDyn.getInt("s_max");
                                HashMap<String, BigDecimal> dateAndGroupUpCapatity_child = (HashMap<String, BigDecimal>)workCenterGroupIdToUpCapacityMap.get(unionKey);
                                if (dateAndGroupUpCapatity_child == null) {
                                    dateAndGroupUpCapatity_child = new HashMap<String, BigDecimal>(8);
                                }
                                if (StringUtils.equals((CharSequence)"A", (CharSequence)constraintType)) {
                                    capacity = this.getCapacity(new BigDecimal(Integer.toString(maxCapacity)), subRatio, subType, subMax, RoundingMode.DOWN, dateAndGroupUpCapatity_child, format_date);
                                    groupIdToRatioMap.put(unionKey, new BigDecimal(Integer.toString(ratio)).multiply(new BigDecimal(Integer.toString(subRatio))).divide(new BigDecimal(100), new MathContext(12)));
                                } else {
                                    capacity = this.getCapacity(groupCapacity, subRatio, subType, subMax, RoundingMode.DOWN, dateAndGroupUpCapatity_child, format_date);
                                    groupIdToRatioMap.put(unionKey, new BigDecimal(Integer.toString(subRatio)));
                                }
                                this.getParentUpCatatity(dateAndGroupUpCapatity_child, format_date, groupId, workCenterId, workCenterGroupIdToUpCapacityMap);
                                workCenterGroupIdToUpCapacityMap.put(unionKey, dateAndGroupUpCapatity);
                                HashMap<String, BigDecimal> dateAndGroupCapatity_child = (HashMap<String, BigDecimal>)groupIdDateCapacityMap.get(unionKey);
                                if (dateAndGroupCapatity_child == null) {
                                    dateAndGroupCapatity_child = new HashMap<String, BigDecimal>(8);
                                }
                                dateAndGroupCapatity_child.put(format_date, capacity);
                                groupIdDateCapacityMap.put(unionKey, dateAndGroupCapatity_child);
                                if (!entryHasGroup) continue;
                                List capacityRateModels = capacityRateMap.computeIfAbsent(workCenterId, k -> new ArrayList(10));
                                CapacityRateModel capacityRateModel = new CapacityRateModel(Long.valueOf(groupId), Long.valueOf(subGroupId), new BigDecimal(Integer.toString(subRatio)).divide(new BigDecimal(100), new MathContext(12)));
                                capacityRateModels.add(capacityRateModel);
                            }
                        }
                        DynamicObjectCollection r_entryentity = productionRuleDyn.getDynamicObjectCollection("r_entryentity");
                        for (DynamicObject entityDyn : r_entryentity) {
                            long groupId = entityDyn.getLong("r_group.id");
                            int priorit = entityDyn.getInt("r_priority");
                            String unionKey = workCenterId + this.concatStr + groupId;
                            if (groupIdToRatioMap.containsKey(unionKey)) continue;
                            groupIdToRatioMap.put(unionKey, new BigDecimal(priorit));
                            this.addGroupWorkCenter(groupIdToWorkCentersMap, workCenterId, groupId);
                            this.addGroupPlanType(groupIdToPlanTypesMap, productionType, groupId);
                        }
                        tempDate = DateUtils.addDays((Date)tempDate, (int)1);
                    }
                }
                continue;
            }
            DynamicObjectCollection entryEntity = productionRuleDyn.getDynamicObjectCollection("e_entryentity");
            for (DynamicObject entityDyn : entryEntity) {
                long groupId = entityDyn.getLong("e_group.id");
                String unionKey = workCenterId + this.concatStr + groupId;
                if (!groupDefineToGroupMap.containsValue(groupId)) continue;
                groupIdToRatioMap.put(unionKey, BigDecimal.ZERO);
                this.addGroupWorkCenter(groupIdToWorkCentersMap, workCenterId, groupId);
                this.addGroupPlanType(groupIdToPlanTypesMap, productionType, groupId);
            }
            DynamicObjectCollection r_entryentity = productionRuleDyn.getDynamicObjectCollection("r_entryentity");
            for (DynamicObject entityDyn : r_entryentity) {
                long groupId = entityDyn.getLong("r_group.id");
                int priorit = entityDyn.getInt("r_priority");
                String unionKey = workCenterId + this.concatStr + groupId;
                if (groupIdToRatioMap.containsKey(unionKey)) continue;
                groupIdToRatioMap.put(unionKey, new BigDecimal(priorit));
                this.addGroupWorkCenter(groupIdToWorkCentersMap, workCenterId, groupId);
                this.addGroupPlanType(groupIdToPlanTypesMap, productionType, groupId);
            }
        }
        for (Map.Entry<Object, Object> entry : groupIdToWorkCentersMap.entrySet()) {
            List collect;
            Long groupId = (Long)entry.getKey();
            Set typeList = (Set)groupIdToPlanTypesMap.get(groupId);
            if (typeList == null) continue;
            if (typeList.size() != 1) {
                if (!typeList.contains("A")) continue;
                List longList = (List)groupIdToWorkCentersMap.get(groupId);
                List collect2 = longList.stream().sorted((o2, o1) -> ((BigDecimal)groupIdToRatioMap.get(o1 + this.concatStr + groupId)).compareTo((BigDecimal)groupIdToRatioMap.get(o2 + this.concatStr + groupId))).collect(Collectors.toList());
                groupIdToWorkCentersMap.put(groupId, collect2);
                continue;
            }
            String productionType = (String)typeList.iterator().next();
            List longList = (List)groupIdToWorkCentersMap.get(groupId);
            if (StringUtils.equals((CharSequence)"A", (CharSequence)productionType)) {
                if (longList == null) continue;
                collect = longList.stream().sorted((o2, o1) -> ((BigDecimal)groupIdToRatioMap.get(o1 + this.concatStr + groupId)).compareTo((BigDecimal)groupIdToRatioMap.get(o2 + this.concatStr + groupId))).collect(Collectors.toList());
                groupIdToWorkCentersMap.put(groupId, collect);
                continue;
            }
            if (longList == null) continue;
            collect = longList.stream().sorted((o1, o2) -> workCenterIdList.indexOf(o1) - workCenterIdList.indexOf(o2)).collect(Collectors.toList());
            groupIdToWorkCentersMap.put(groupId, collect);
        }
        capacityMessage.put("groupIdToWorkCentersMap", groupIdToWorkCentersMap);
        HashMap<Long, Long> groupToWorkCenter = new HashMap<Long, Long>(16);
        for (Map.Entry mapEntry : groupIdToWorkCentersMap.entrySet()) {
            groupToWorkCenter.put((Long)mapEntry.getKey(), (Long)((List)mapEntry.getValue()).get(0));
        }
        return groupToWorkCenter;
    }

    private Map<Object, DynamicObject> queryProductionrules(Map<Long, Long> workCenterToRuleMap) {
        QFilter ruleQFilter = new QFilter("id", "in", workCenterToRuleMap.values());
        Map productionRules = BusinessDataServiceHelper.loadFromCache((String)"mps_productionrules", (QFilter[])ruleQFilter.toArray());
        if (productionRules == null || productionRules.size() == 0) {
            throw new KDBizException(SchedulePlanErrors.scheduledNoRuleError(), new Object[0]);
        }
        return productionRules;
    }

    public Map<Object, DynamicObject> queryCapacityDef(Map<Object, DynamicObject> productionRules) {
        HashSet<Long> capacityIds = new HashSet<Long>(productionRules.size());
        HashMap<Long, String> capacityNotExistMap = new HashMap<Long, String>(productionRules.size());
        for (Map.Entry<Object, DynamicObject> entry : productionRules.entrySet()) {
            DynamicObject productionRuleDyn = entry.getValue();
            long capacityId = productionRuleDyn.getLong("capacitydefinition.id");
            capacityIds.add(capacityId);
            capacityNotExistMap.put(capacityId, productionRuleDyn.getString("number"));
        }
        Map capacityDefMap = BusinessDataServiceHelper.loadFromCache((Object[])capacityIds.toArray(), (String)"mps_capacitydef");
        logger.info("capacityDefMap\uff1a" + capacityDefMap.keySet().toString());
        if (capacityDefMap.size() != capacityIds.size()) {
            for (Object capacityId : capacityDefMap.keySet()) {
                capacityNotExistMap.remove(capacityId);
            }
            Collection collection = capacityNotExistMap.values();
            throw new KDBizException(SchedulePlanErrors.capacityDefNotExistError(), new Object[]{StringUtils.join(collection, (String)",")});
        }
        return capacityDefMap;
    }

    private void getParentUpCatatity(Map<String, BigDecimal> dateAndGroupUpCapatity, String format_date, long groupId_parent, long workCenterId, Map<String, Map<String, BigDecimal>> workCenterGroupIdToUpCapacityMap) {
        BigDecimal upCapatity_parent;
        BigDecimal upCapatity = dateAndGroupUpCapatity.get(format_date);
        String key_parent = workCenterId + "." + groupId_parent;
        Map<String, BigDecimal> dateUpCapacity = workCenterGroupIdToUpCapacityMap.get(key_parent);
        if (dateUpCapacity != null && (upCapatity_parent = dateUpCapacity.get(format_date)) != null && upCapatity != null && upCapatity_parent.compareTo(upCapatity) < 0) {
            dateAndGroupUpCapatity.put(format_date, upCapatity_parent);
        }
    }

    private void getProduceMessage(DynamicObject productionRuleDyn, long workCenterId, Map<Long, List<ProductionrulesModel>> workCenterAndProduce) {
        DynamicObjectCollection entryEntity = productionRuleDyn.getDynamicObjectCollection("e_entryentity");
        ArrayList<ProductionrulesModel> modelList = new ArrayList<ProductionrulesModel>(entryEntity.size());
        for (DynamicObject entityDyn : entryEntity) {
            long groupId = entityDyn.getLong("e_group.id");
            int ratio = entityDyn.getInt("e_ratio");
            String type = entityDyn.getString("e_type");
            int max = entityDyn.getInt("e_max");
            ProductionrulesModel productionrulesModel = new ProductionrulesModel(Long.valueOf(groupId), ratio, type, max, "", Long.valueOf(0L));
            modelList.add(productionrulesModel);
            DynamicObjectCollection subEntryEntity = entityDyn.getDynamicObjectCollection("subentryentity");
            for (DynamicObject subEntityDyn : subEntryEntity) {
                long subGroupId = subEntityDyn.getLong("s_group.id");
                int subRatio = subEntityDyn.getInt("s_ratio");
                String constraintType = subEntityDyn.getString("s_constrainttype");
                String subType = subEntityDyn.getString("s_type");
                int subMax = subEntityDyn.getInt("s_max");
                ProductionrulesModel productionrulesModel_sub = new ProductionrulesModel(Long.valueOf(subGroupId), subRatio, subType, subMax, constraintType, Long.valueOf(groupId));
                modelList.add(productionrulesModel_sub);
            }
        }
        workCenterAndProduce.put(workCenterId, modelList);
    }

    public void getWorkCenterByProplanschde(MPSPlanProgramModel mpsPlanProgramModel, Map<String, Object> capacityMessage) {
        List workCenterInfoList = mpsPlanProgramModel.getWorkCenterInfoList();
        List workCenterIdList = workCenterInfoList.stream().map(x -> x.getWorkCenterId()).collect(Collectors.toList());
        capacityMessage.put("workCenterIdList", workCenterIdList);
    }

    private Map<Long, Long> getWorkCenterToProductionruleByProplanschde(DynamicObject planProgram) {
        DynamicObjectCollection workEntryColl = planProgram.getDynamicObjectCollection("workentry");
        if (CollectionUtils.isEmpty((Collection)workEntryColl)) {
            throw new KDBizException(SchedulePlanErrors.noWorkCenterError(), new Object[0]);
        }
        HashMap<Long, Long> workCenterToRuleMap = new HashMap<Long, Long>(workEntryColl.size());
        for (DynamicObject workEntry : workEntryColl) {
            workCenterToRuleMap.put(workEntry.getLong("workcenter.id"), workEntry.getLong("productionrules.id"));
        }
        return workCenterToRuleMap;
    }

    private Map<Long, Map<String, MutexModel>> getMutexMessage(Map<String, Object> capacityMessage, DynamicObject runlog) {
        long createorg = runlog.getDynamicObject("createorg").getLong("id");
        QFilter mutexrulesQfilter = BaseDataServiceHelper.getBaseDataFilter((String)"mps_mutexrules", (Long)createorg);
        Map groupToGroupDefineMap = (Map)capacityMessage.get("groupToGroupDefineMap");
        HashMap<Long, Map<String, MutexModel>> groupIdToMutexModelMap = new HashMap<Long, Map<String, MutexModel>>(8);
        Map objectDynamicObjectMap = BusinessDataServiceHelper.loadFromCache((String)"mps_mutexrules", (QFilter[])new QFilter[]{mutexrulesQfilter.and("enable", "=", (Object)"1").and("status", "=", (Object)"C")});
        if (objectDynamicObjectMap.size() != 0) {
            Collection values = objectDynamicObjectMap.values();
            for (DynamicObject dynamicObject : values) {
                DynamicObjectCollection dynamicObjectCollection = dynamicObject.getDynamicObjectCollection("entryentity");
                for (DynamicObject dynamicObject_collection : dynamicObjectCollection) {
                    String type = dynamicObject_collection.getString("type");
                    String timeperiod = dynamicObject_collection.getString("timeperiod");
                    DynamicObjectCollection groups = dynamicObject_collection.getDynamicObjectCollection("group");
                    DynamicObjectCollection workCenterIds = dynamicObject_collection.getDynamicObjectCollection("range");
                    HashSet<Long> groupIdLsit = new HashSet<Long>(groups.size());
                    for (DynamicObject dynamicObject_group : groups) {
                        Long groupId = dynamicObject_group.getDynamicObject("fbasedataid").getLong("id");
                        groupIdLsit.add(groupId);
                    }
                    for (DynamicObject dynamicObject_group : groups) {
                        ArrayList<Long> workCenterIdList;
                        List list;
                        ArrayList<Long> groupIdLsit_new = new ArrayList<Long>(groups.size());
                        groupIdLsit_new.addAll(groupIdLsit);
                        Long groupId = dynamicObject_group.getDynamicObject("fbasedataid").getLong("id");
                        Map mutexModelMap = (Map)groupIdToMutexModelMap.get(groupId);
                        if (mutexModelMap == null || mutexModelMap.size() == 0) {
                            MutexModel mutexModel = new MutexModel();
                            HashMap<String, MutexModel> mutexModelList = new HashMap<String, MutexModel>(8);
                            mutexModel.setMutexType(type);
                            if ("A".equals(type)) {
                                groupIdLsit_new.remove(groupId);
                                mutexModel.setGroupIdList(groupIdLsit_new);
                                this.setGroupWorkCenterList(mutexModel, groupIdLsit_new, workCenterIds);
                            } else {
                                list = (List)groupToGroupDefineMap.get(groupId);
                                mutexModel.setGroupIdList(list);
                            }
                            mutexModel.setTimePeriod(timeperiod);
                            workCenterIdList = new ArrayList<Long>(8);
                            for (DynamicObject workCenter : workCenterIds) {
                                workCenterIdList.add(workCenter.getDynamicObject("fbasedataid").getLong("id"));
                            }
                            mutexModel.setWorkCenterList(workCenterIdList);
                            mutexModelList.put(type, mutexModel);
                            groupIdToMutexModelMap.put(groupId, mutexModelList);
                            continue;
                        }
                        MutexModel mutexModel_new = (MutexModel)mutexModelMap.get(type);
                        if (mutexModel_new == null) {
                            mutexModel_new = new MutexModel();
                            mutexModel_new.setMutexType(type);
                            ArrayList<Long> groupIdList = new ArrayList<Long>(8);
                            if ("A".equals(type)) {
                                groupIdLsit_new.remove(groupId);
                                groupIdList.addAll(groupIdLsit_new);
                                mutexModel_new.setGroupIdList(groupIdList);
                                this.setGroupWorkCenterList(mutexModel_new, groupIdLsit_new, workCenterIds);
                            } else {
                                list = (List)groupToGroupDefineMap.get(groupId);
                                mutexModel_new.setGroupIdList(list);
                            }
                            mutexModel_new.setTimePeriod(timeperiod);
                            workCenterIdList = new ArrayList(8);
                            for (DynamicObject workCenter : workCenterIds) {
                                workCenterIdList.add(workCenter.getDynamicObject("fbasedataid").getLong("id"));
                            }
                            mutexModel_new.setWorkCenterList(workCenterIdList);
                            mutexModelMap.put(type, mutexModel_new);
                            continue;
                        }
                        String timePeriod = mutexModel_new.getTimePeriod();
                        if (!timePeriod.equals(timeperiod)) {
                            mutexModel_new.setTimePeriod("A");
                        }
                        List groupIdList = mutexModel_new.getGroupIdList();
                        if ("A".equals(type)) {
                            groupIdLsit_new.remove(groupId);
                            groupIdList.addAll(groupIdLsit_new);
                            this.setGroupWorkCenterList(mutexModel_new, groupIdLsit_new, workCenterIds);
                        }
                        List workCenterList = mutexModel_new.getWorkCenterList();
                        for (DynamicObject workCenter : workCenterIds) {
                            Long workCenterId = workCenter.getDynamicObject("fbasedataid").getLong("id");
                            if (workCenterList.contains(workCenterId)) continue;
                            workCenterList.add(workCenterId);
                        }
                    }
                }
            }
        }
        capacityMessage.put("mutexMessage", groupIdToMutexModelMap);
        return groupIdToMutexModelMap;
    }

    private void setGroupWorkCenterList(MutexModel mutexModel, List<Long> groupIdLsit_new, DynamicObjectCollection workCenterIds) {
        HashMap groupIdAndWorkCenterList = mutexModel.getGroupIdAndWorkCenterList();
        if (groupIdAndWorkCenterList == null) {
            groupIdAndWorkCenterList = new HashMap(8);
        }
        for (Long id : groupIdLsit_new) {
            ArrayList<Long> workcenterList = (ArrayList<Long>)groupIdAndWorkCenterList.get(id);
            if (workcenterList == null) {
                workcenterList = new ArrayList<Long>(8);
            }
            for (DynamicObject workCenter : workCenterIds) {
                Long workCenterId = workCenter.getDynamicObject("fbasedataid").getLong("id");
                if (workcenterList.contains(workCenterId)) continue;
                workcenterList.add(workCenterId);
            }
            groupIdAndWorkCenterList.put(id, workcenterList);
        }
        mutexModel.setGroupIdAndWorkCenterList(groupIdAndWorkCenterList);
    }

    public void getChangeMessage(DynamicObject planprogram, Map<String, Object> capacityMessage) {
        List workCenterIdList = (List)capacityMessage.get("workCenterIdList");
        ArrayList<Long> changeRuleIds = new ArrayList<Long>(workCenterIdList.size());
        DynamicObject dynamicObject_plan = BusinessDataServiceHelper.loadSingle((String)"mps_proplanschdef", (QFilter[])new QFilter[]{new QFilter("id", "=", planprogram.getPkValue())});
        DynamicObjectCollection dynamicObjectCollection = dynamicObject_plan.getDynamicObjectCollection("workentry");
        for (DynamicObject dynamicObject : dynamicObjectCollection) {
            DynamicObject prochangerule = dynamicObject.getDynamicObject("prochangerules");
            if (prochangerule == null) continue;
            long id = prochangerule.getLong("id");
            changeRuleIds.add(id);
        }
        Map prochangerulesMap = BusinessDataServiceHelper.loadFromCache((String)"mps_prochangerules", (QFilter[])new QFilter[]{new QFilter("id", "in", changeRuleIds).and("status", "=", (Object)"C").and("enable", "=", (Object)"1")});
        HashMap workcenterAndChangeMap = new HashMap(prochangerulesMap.size());
        HashMap workcenterAndChangeReduceMap = new HashMap(prochangerulesMap.size());
        for (Map.Entry prochangeruleDynEntry : prochangerulesMap.entrySet()) {
            DynamicObject prochangeRuleDyn = (DynamicObject)prochangeruleDynEntry.getValue();
            Long workCenterId = prochangeRuleDyn.getDynamicObject("workcenter").getLong("id");
            DynamicObjectCollection entryentity = prochangeRuleDyn.getDynamicObjectCollection("entryentity");
            HashMap<String, BigDecimal> reduceMap = new HashMap<String, BigDecimal>(8);
            HashMap groupAndGroupReduceNum = new HashMap(prochangerulesMap.size());
            for (DynamicObject dynamicObject : entryentity) {
                DynamicObjectCollection beforegroups = dynamicObject.getDynamicObjectCollection("beforegroup");
                DynamicObject aftergroup = dynamicObject.getDynamicObject("aftergroup");
                long aftergroupId = aftergroup.getLong("id");
                BigDecimal qty = dynamicObject.getBigDecimal("qty");
                StringBuilder stringBuilder = new StringBuilder();
                StringBuilder sb = new StringBuilder();
                HashMap<Long, BigDecimal> groupAndCapatitys = new HashMap<Long, BigDecimal>();
                for (DynamicObject beforegroup : beforegroups) {
                    ArrayList<HashMap<Long, BigDecimal>> list;
                    stringBuilder.setLength(0);
                    Long beforegroupId = beforegroup.getLong("fbasedataid_id");
                    stringBuilder.append(beforegroupId).append(",").append(aftergroupId);
                    if (groupAndGroupReduceNum.containsKey(beforegroupId)) {
                        list = (ArrayList<HashMap<Long, BigDecimal>>)groupAndGroupReduceNum.get(beforegroupId);
                        sb.setLength(0);
                        Map groupAndCapacity = (Map)list.get(0);
                        sb.append(beforegroupId).append(",").append(groupAndCapacity.keySet().toArray()[0]);
                        BigDecimal bigDecimal = (BigDecimal)reduceMap.get(sb.toString());
                        reduceMap.put(stringBuilder.toString(), qty);
                        groupAndCapatitys.put(aftergroupId, qty);
                        if (bigDecimal.compareTo(qty) > 0) {
                            list.add(0, groupAndCapatitys);
                            continue;
                        }
                        list.add(groupAndCapatitys);
                        continue;
                    }
                    list = new ArrayList<HashMap<Long, BigDecimal>>(8);
                    groupAndCapatitys.put(aftergroupId, qty);
                    list.add(groupAndCapatitys);
                    reduceMap.put(stringBuilder.toString(), qty);
                    groupAndGroupReduceNum.put(beforegroupId, list);
                }
            }
            workcenterAndChangeMap.put(workCenterId, groupAndGroupReduceNum);
            workcenterAndChangeReduceMap.put(workCenterId, reduceMap);
        }
        capacityMessage.put("workcenterAndChangeMap", workcenterAndChangeMap);
        capacityMessage.put("workcenterAndChangeReduceMap", workcenterAndChangeReduceMap);
    }

    private BigDecimal getCapacity(BigDecimal maxCapacity, int ratio, String type, int max, RoundingMode roundingMode, Map<String, BigDecimal> dateAndGroupUpCapatity, String format_date) {
        if (StringUtils.equals((CharSequence)"A", (CharSequence)type)) {
            BigDecimal groupCapacity = maxCapacity.multiply(new BigDecimal(Integer.toString(ratio))).divide(new BigDecimal(100), 0, roundingMode);
            if (max != 0) {
                BigDecimal bigDecimal = new BigDecimal(Integer.toString(max));
                dateAndGroupUpCapatity.put(format_date, bigDecimal);
                return groupCapacity.compareTo(bigDecimal) > 0 ? bigDecimal : groupCapacity;
            }
            dateAndGroupUpCapatity.put(format_date, null);
            return groupCapacity;
        }
        int realRatio = ratio;
        if (max != 0) {
            int n = realRatio = ratio > max ? max : ratio;
            if (ratio < max) {
                roundingMode = RoundingMode.DOWN;
            }
            BigDecimal upCapatity = maxCapacity.multiply(new BigDecimal(Integer.toString(max))).divide(new BigDecimal(100), 0, roundingMode);
            dateAndGroupUpCapatity.put(format_date, upCapatity);
        } else {
            dateAndGroupUpCapatity.put(format_date, null);
        }
        return maxCapacity.multiply(new BigDecimal(Integer.toString(realRatio))).divide(new BigDecimal(100), 0, roundingMode);
    }

    private List<Date> getEffectDateList(Date startDate, Date endDate, Map<String, BigDecimal> dateAndCapacity, BigDecimal maxCapacity, SimpleDateFormat si) {
        ArrayList<Date> effectDates = new ArrayList<Date>(10);
        if (startDate != null && endDate != null) {
            Date tempDate = startDate;
            while (!endDate.before(tempDate)) {
                String format_date = si.format(tempDate);
                dateAndCapacity.put(format_date, maxCapacity);
                tempDate = DateUtils.addDays((Date)tempDate, (int)1);
            }
        }
        return effectDates;
    }

    private void addGroupPlanType(Map<Long, Set<String>> groupIdToPlanTypeMap, String productionType, long groupId) {
        Set planTypes = groupIdToPlanTypeMap.computeIfAbsent(groupId, k -> new HashSet());
        planTypes.add(productionType);
    }

    private void addGroupWorkCenter(Map<Long, List<Long>> groupIdToWorkCentersMap, long workCenterId, long groupId) {
        List workCenterIds = groupIdToWorkCentersMap.computeIfAbsent(groupId, k -> new ArrayList());
        if (!workCenterIds.contains(workCenterId)) {
            workCenterIds.add(workCenterId);
        }
    }
}

