/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mps.calcnode;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.JoinDataSet;
import kd.bos.algo.JoinType;
import kd.bos.algo.RowMeta;
import kd.bos.algo.datatype.LongType;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.mmc.mps.common.model.MPSPlanProgramModel;
import kd.mmc.mps.common.util.MPSScheduleUtils;
import kd.mmc.mps.consts.schedule.SchedulePlanErrors;
import kd.mmc.mps.mservice.exception.PLSWarnException;
import kd.mpscmm.msplan.mservice.service.datafetch.DataFetcher;
import kd.mpscmm.msplan.mservice.service.mrp.ExecutionEnv;

public class MPSGetOrderData {
    List<String> mustInputFileds = Arrays.asList("configure", "materiel_code", "order_num", "production_org", "sourcebillid", "plan_order_billno");
    private static String[] field = new String[]{"sourcebillid_select", "sourceentryid_select", "scheduId"};

    public DataSet getOrderData(DynamicObject plan, MPSPlanProgramModel mpsPlanProgramModel) {
        Set<Long> orderModelId = this.getOrderModelId(plan);
        DataSet orderDataset = this.getOrderDataset(orderModelId, mpsPlanProgramModel);
        return orderDataset;
    }

    public DataSet getOrderDataset(Set<Long> modelIds, MPSPlanProgramModel mpsPlanProgramModel) {
        DataSet dataSet = null;
        DataFetcher dataFetcher = new DataFetcher();
        for (Long modelId : modelIds) {
            List<String> metas;
            DataSet dsItem = dataFetcher.getDataSet(modelId);
            if (dsItem == null || dsItem.isEmpty()) {
                return null;
            }
            DataSet finish = null;
            if (mpsPlanProgramModel != null && mpsPlanProgramModel.getOrderData() != null) {
                if (!Arrays.asList(dsItem.getRowMeta().getFieldNames()).contains("sourceentryid")) {
                    dsItem = dsItem.addField("sourcebillid", "sourceentryid");
                }
                List orderData = mpsPlanProgramModel.getOrderData();
                List sourcebillentryids = mpsPlanProgramModel.getSourcebillentryids();
                List scheduIds = mpsPlanProgramModel.getScheduId();
                List<Object[]> listObject = this.getListObject(orderData, sourcebillentryids, scheduIds);
                DataType[] dataType = new DataType[]{new LongType(), new LongType(), new LongType()};
                RowMeta rowMeta = new RowMeta(field, dataType);
                Algo algo = Algo.create((String)"scm");
                DataSet dataSet_exit = algo.createDataSet(listObject, rowMeta);
                JoinDataSet join = dsItem.join(dataSet_exit, JoinType.INNER);
                finish = join.on("sourcebillid", "sourcebillid_select").on("sourceentryid", "sourceentryid_select").select(dsItem.getRowMeta().getFieldNames(), new String[]{"scheduId"}).finish();
                if (finish == null || finish.isEmpty()) {
                    return null;
                }
            }
            if (!(metas = finish == null || finish.isEmpty() ? Arrays.asList(dsItem.getRowMeta().getFieldNames()) : Arrays.asList(finish.getRowMeta().getFieldNames())).containsAll(this.mustInputFileds)) {
                throw new PLSWarnException(SchedulePlanErrors.fieldMustInputError(), new Object[]{StringUtils.join(this.mustInputFileds, (String)",")});
            }
            if (dataSet == null) {
                if (finish == null) {
                    dataSet = dsItem;
                    continue;
                }
                dataSet = finish;
                continue;
            }
            RowMeta leftRowMeta = dataSet.getRowMeta();
            RowMeta rightRowMeta = finish == null || finish.isEmpty() ? dsItem.getRowMeta() : finish.getRowMeta();
            Field[] leftFields = leftRowMeta.getFields();
            Field[] rightFields = rightRowMeta.getFields();
            HashSet<String> allFieldName = new HashSet<String>(16);
            HashSet<String> leftName = new HashSet<String>(16);
            HashSet<String> rightName = new HashSet<String>(16);
            for (Field leftField : leftFields) {
                allFieldName.add(leftField.getName());
                leftName.add(leftField.getName());
            }
            for (Field rightField : rightFields) {
                allFieldName.add(rightField.getName());
                rightName.add(rightField.getName());
            }
            for (String fieldName : allFieldName) {
                if (!leftName.contains(fieldName)) {
                    dataSet = dataSet.addNullField(fieldName);
                }
                if (rightName.contains(fieldName)) continue;
                if (finish == null || finish.isEmpty()) {
                    dsItem = dsItem.addNullField(fieldName);
                    continue;
                }
                finish = finish.addNullField(fieldName);
            }
            dataSet = dataSet.select(allFieldName.toArray(new String[0]));
            if (finish == null || finish.isEmpty()) {
                dsItem = dsItem.select(allFieldName.toArray(new String[0]));
                dataSet = dataSet.union(dsItem);
                continue;
            }
            finish = finish.select(allFieldName.toArray(new String[0]));
            dataSet = dataSet.union(finish);
        }
        return dataSet;
    }

    private List<Object[]> getListObject(List<Long> orderData, List<Long> orderData_entry, List<Long> scheduIds) {
        ArrayList<Object[]> objectList = new ArrayList<Object[]>(orderData.size());
        if (orderData_entry != null && orderData_entry.size() != 0 && scheduIds != null && scheduIds.size() != 0) {
            int i = 0;
            for (Long id : orderData) {
                Object[] objects = new Object[]{id, orderData_entry.get(i), scheduIds.get(i)};
                objectList.add(objects);
                ++i;
            }
        }
        return objectList;
    }

    public MPSPlanProgramModel getPlanProgramModel(ExecutionEnv env) {
        String key = "mpscalc-" + env.getCtxId() + "mps_scheduleplan_plangrams_args";
        String paramStr = MPSScheduleUtils.getJedis().get(key);
        if (paramStr == null) {
            return null;
        }
        Map planProgramMapData = (Map)SerializationUtils.deSerializeFromBase64((String)paramStr);
        MPSPlanProgramModel mpsPlanProgramModel = (MPSPlanProgramModel)JSON.parseObject((String)JSON.toJSONString((Object)planProgramMapData), MPSPlanProgramModel.class);
        return mpsPlanProgramModel;
    }

    public Set<Long> getOrderModelId(DynamicObject plan) {
        DynamicObjectCollection orderEntryColl = plan.getDynamicObjectCollection("order_entryentity");
        HashSet<Long> idSet = new HashSet<Long>(orderEntryColl.size());
        if (orderEntryColl != null && !orderEntryColl.isEmpty()) {
            for (DynamicObject order : orderEntryColl) {
                boolean isCalculate = false;
                if (order.get("isincalculate") != null) {
                    isCalculate = order.getBoolean("isincalculate");
                }
                if (!isCalculate || order.get("resourceconfig") == null) continue;
                idSet.add(order.getLong("resourceconfig_id"));
            }
        }
        return idSet;
    }
}

